% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_nodes_in_neighborhood.R
\name{select_nodes_in_neighborhood}
\alias{select_nodes_in_neighborhood}
\title{Select nodes based on a walk distance from a specified node}
\usage{
select_nodes_in_neighborhood(graph, node, distance, set_op = "union")
}
\arguments{
\item{graph}{a graph object of class \code{dgr_graph} that is created
using \code{create_graph}.}

\item{node}{the node from which the traversal will originate.}

\item{distance}{the maximum number of steps from the \code{node}
for inclusion in the subgraph.}

\item{set_op}{the set operation to perform upon consecutive selections
of graph nodes. This can either be as a \code{union} (the default), as an
\code{intersection}, or, as a \code{difference} on the previous selection,
if it exists.}
}
\value{
a graph object of class \code{dgr_graph}.
}
\description{
Select those nodes in the neighborhood of nodes connected
a specified distance from an initial node.
}
\examples{
\dontrun{
# Create a graph, then, create a subgraph of that larger graph
nodes <-
  create_nodes(nodes = LETTERS,
               type = "letter",
               shape = sample(c("circle", "rectangle"),
                              length(LETTERS),
                              replace = TRUE),
               fillcolor = sample(c("aqua", "red",
                                    "pink", "lightgreen",
                                    "azure", "yellow"),
                                  length(LETTERS),
                                  replace = TRUE))

edges <-
  create_edges(from = sample(LETTERS, replace = TRUE),
               to = sample(LETTERS, replace = TRUE),
               rel = "letter_to_letter")

graph <- create_graph(nodes_df = nodes,
                      edges_df = edges,
                      graph_attrs = "layout = neato",
                      node_attrs = c("fontname = Helvetica",
                                     "style = filled"),
                      edge_attrs = c("color = gray20",
                                     "arrowsize = 0.5"))

# Create a selection of nodes centered around node "U" and
# including those nodes a depth of 2 edges away
graph <-
  select_nodes_in_neighborhood(graph = graph,
                               node = "U",
                               distance = 2)
}
}

