% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ds.correlation.R
\name{ds.correlation}
\alias{ds.correlation}
\title{Correlation Coefficient of a dataframe}
\usage{
ds.correlation(x, y=NULL, cor.method="pearson", tojson=FALSE)
}
\arguments{
\item{x}{A numeric vector, matrix or data frame}

\item{y}{A vector, matrix or data frame with same dimension as x. By default it is equal with NULL.}

\item{cor.method}{The correlation coefficient method to compute: "pearson" (default),
"kendall" or "spearman".}

\item{tojson}{If TRUE the results are returned in json format, default returns a data frame}
}
\description{
This functions calculates the correlation coefficient of the input vectors, matrix or data frame.
By default, the correlation coefficient of pearson is computed.
}
\details{
This function returns an upper triangle matrix with the correlation coefficients 
of the input data. The correlation coefficient of pearson is computed, by default. 
Other options are "kendall" or "spearman".
}
\examples{
# with data frame as an input and the default parameters
data <- iris
ds.correlation(data, cor.method = "pearson", tojson=FALSE)

# with matrix as an input , different parameters and json output
Matrix <- cbind(Uni05 = (1:200)/21, Norm = rnorm(200),
         `5T` = rt(200, df = 5), Gam2 = rgamma(200, shape = 2))
ds.correlation(Matrix, cor.method = "kendall", tojson=TRUE)

# OpenBudgets.eu Dataset Example:
Wuppertal_df
ds.correlation(Wuppertal_df, cor.method = "pearson", tojson = FALSE)

}
\seealso{
\code{\link{ds.analysis}}, \code{\link{open_spending.ds}}
}
\author{
Aikaterini Chatzopoulou, Kleanthis Koupidis
}
