% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ObservedRep.R
\name{ObservedRepresentation}
\alias{ObservedRepresentation}
\title{Compute the observed degree of representation for any group in a political body}
\usage{
ObservedRepresentation(BodyMemberCharacteristics, PopShares, BodyShares, a = -0.5, b = 1)
}
\arguments{
\item{BodyMemberCharacteristics}{A vector specifying the characteristics for members of a political body.}

\item{PopShares}{A numeric vector specifying population shares of identities specified in the body-member characteristics input. The names of the entries in \code{PopShares} should correspond to identities in that body-member characteristics input  (see Example).}

\item{BodyShares}{(optional) A numeric vector with same structure as \code{PopShares} specifying group population shares of a given body. If specified, used by default instead of \code{BodyMemberCharacteristics}.}

\item{a, b}{Parameters controlling the affine transformation for how the representation measure is summarized.
That is, \code{a} and \code{b} control how the L1 deviation of the population shares from the body shares
is re-weighted. This expected L1 deviation is multiplied by \code{a}; \code{b} is as an additive re-scaling term: \code{a*L1+b}.
By default, \code{a=-0.5} and \code{b=1} so that the Rose Index of Proportionality is returned.}
}
\value{
The observed degree of representation (a scalar). By default, this quantity is the Rose Index of Proportionality.
}
\description{
Finds the degree of observed representation for any group in a political body.
}
\examples{

ObsRep <- ObservedRepresentation(
                        BodyMemberCharacteristics = c("A","A","C","A","C","A"),
                        PopShares = c("A"=1/3,"B"=2/3, "C"=1/3))

print( ObsRep )

}
