#
# Project:	DescTools
#
# Purpose:  Tools for descriptive statistics, the missing link...
#	          Univariat, pairwise bivariate, groupwise und multivariate
#
# Author:   Andri Signorell
# Version:	0.99.12 (under construction)
#
# Depends:  tcltk
# Imports:  boot
# Suggests: RDCOMClient
#
# Datum:
#           05.01.2015  version 0.99.9 next version
#           05.09.2014  version 0.99.8 next version
#           10.05.2014  version 0.99.7 next version
#           16.12.2013  version 0.99.6 made fit for CRAN
#           26.09.2013  version 0.99.5 some minor bugfixes
#           31.07.2013  version 0.99.4 almost releaseable
#           06.05.2011 	created
#
# ****************************************************************************


# **********  DescTools' design goals, Dos and Donts
# Some thoughts about coding:

# 1.  Use recycling rules as often and wherever possible.
# 2.  Handle NAs by adding an na.rm option (default FALSE) where it makes sense.
# 3.  Use Google Naming StyleGuide
# 4.  no data.frame or matrix interfaces for functions, the user is supposed to use
#     sapply and apply.
#     Interfaces for data.frames are widely deprecated nowadays and so we abstained to implement one.
#     Use do.call (do.call), rbind and lapply for getting a matrix with estimates and confidence
#     intervals for more than 1 column.
# 5.  A pairwise apply construction is implemented PwApply
# 6.  Use formula interfaces wherever possible.
# 7.  use test results format class "htest"
# 8.  deliver confidence intervals wherever possible, rather than tests (use ci for that)
# 9.  always define appropriate default values for function arguments
# 10. provide an inverse function whenever possible (ex.: BoxCox - BoxCoxInv)
# 11. auxiliary functions, which don't have to be defined globally are put in the function's body
#     (and not made invisible to the user by using .funname)
# 12. restrict the use of other libraries to the minimum (possibly only core),
#     avoid hierarchical dependencies of packages over more than say 2 steps
# 13. do not create wrappers, which basically only define specific arguments and
#     call an existing function (we would run into a forest of functions, loosing overview)
# 14. make functions as flexible as possible but do not define more than say
#     a maximum of 12 arguments for a function (can hardly be controlled by the user)
# 15. define reasonable default values for possibly all used arguments
#     (besides x), the user should get some result when typing fun(x)!
# 16. do not reinvent the wheel
# 17. do not write a function for a problem already solved(!), unless you think
#     it is NOT (from your point of view) and you are pretty sure you can do better..
# 18. take the most flexible function on the market, if there are several
#     take the most efficient function on the market, if there are differences in speed
# 19. make it work - make it safe - make it fast (in this very order...)
# 20. possibly publish all functions, if internal functions are used, define it within
#     the functions body, this will ensure a quick source lookup.


# **********  Similar packages:

# - descr, UsingR
# - prettyR
# - reporttools
# - lessR (full)
# - Hmisc (describe)
# - psych

# check:
# library(pwr) # Power-Analyse
# http://www.ats.ucla.edu/stat/r/dae/t_test_power2.htm


# Data in packages
# http://www.hep.by/gnu/r-patched/r-exts/R-exts_8.html


# library(gtools): odd   zu IsOdd, vgl: stars.pval
# library(e1071): hamming.distance, hamming.window, hsv_palette, matchControls (SampleTwins)
# library(plotrix): color.id (RgbToCol), color.scale (FindColor)
# vgl: PlotCI  (plotCI), plot_bg


# **********  Know issues:

# bug:    Desc( driver + temperature ~ operator + interaction(city, driver, sep=":") , data=d.pizza)
# works:  Desc( driver + temperature ~ operator + interaction(city, driver, sep=".") , data=d.pizza)
# works:  Desc( driver + temperature ~ operator + city:driver, data=d.pizza)

# - bei der Anwendung von tapply wird die Bezeichnung des Levels nicht verwendet
#       Beispiel:
        # tapply( d.pizza$delivery_min, d.pizza$driver, Desc )
        # Problem:  Titel und level kommt nicht mit   ***CLEARME***CLEARME***CLEARME***CLEARME***CLEARME***

# - DescWrd.factor.factor gibt die Argumente an WrdText nicht weiter? fontsize, etc. (17.4.2012)
# - ein langer label fuehrt dazu, dass die Tabellenausgabe umgebrochen wird und die Grafik unter dem Text plaziert wird.

# this error arises when no plot windows exists, but is the same for boxplot, so we leave it here
# PlotViolin(temperature ~ driver, d.pizza, col="steelblue", panel.first=grid())
# Error in int_abline(a = a, b = b, h = h, v = v, untf = untf, ...) :
#  plot.new has not been called yet



# **********  Open implementations:

# functions:
# polychor, tetrachor

# Cohen's effect fformat(ISOdate(2000, 1:12, 1), "%B")ct
# Cohen's effect hlp

# eta fct lines
# eta hlp
# eta2 <- function(x,y) {
#   return(summary(lm(as.formula(x~y)))$r.squared)
# }

# open multiple comparisons:
# ScottKnott test (scottknott),
#   Waller-Duncan test (agricolae), Gabriel test (not found)


# flag ~ flag  mit mosaicplot und allgemein bivariate darstellung

# ConDisPairs als O(n log(n)) AVL-Tree implementation

# PlotMultiDens stack and 100% (cdplot)
#
# PlotCirc for symmetric tables


# Konsequente ueberpruefung der uebergabe und weiterreichung der parameter
# z.B. was ist mit  Boxplot las?

# uebersicht, was wird wo vewendet, z.b. kommt rfrq ueberhaupt an bei Desc(data.frame)
# Was ist die maximale Menge an parameter?

# - Tabellen factor ~ factor nebeneinander wenn Platz


# PercTable tasks:
#   Sum, perc, usw. Texte parametrisieren
#   0 values als '-' optional anzeigen
#   Format perc stimmt im ersten Fall nicht, parametrisieren?
#   Reihenfolge Zuerich, perc vs. perc , Zuerich wechselbar machen. Ist das schon?


# faqNC <- function() browseURL("http://www.ncfaculty.net/dogle/R/FAQ/FAQ_R_NC.html")

# Formula-Interface fuer PlotBag

# - replace .fmt by Format

# - DescDlg

# - Object Browser a la RevoR
# - Fixierung Nachkommastellen pro Variable - geloest, aber unbefriedigend
#   sollte unterscheiden zwischen kleinen (1.22e-22), mittleren (100.33) und
#   grossen Zahlen (1.334e5)
#   grosse Zahlen mit Tausendertrennzeichen ausgegeben: 13'899
# - Alle PlotDesc sollten so funktionieren wie Desc, also mit data, ohne data etc.

# wenn mal viel Zeit: test routinen mit htest result fuer
# SomersDelta, GoodmanKruskal etc.


# separate Data ========

# Creation of the Page distribution function for the Page TrendTest
#
# .PageDF <- list(
#   NA, NA
#   , k3 = c(1, 3, 3, 5, 6)
#   , k4 = c(1, 4, 5, 9, 11, 13, 15, 19, 20, 23, 24)
#   , k5 = c(1, 5, 8, 14, 21, 27, 31, 41, 47, 57, 63, 73, 79, 89, 93, 99, 106, 112, 115, 119, 120)
#   , k6 = c(1, 6, 12, 21, 37, 49, 63, 87, 107, 128, 151, 179, 203, 237,
#            257, 289, 331, 360, 389, 431, 463, 483, 517, 541, 569, 592, 613,
#            633, 657, 671, 683, 699, 708, 714, 719, 720)
#   , k7 = c(1, 7, 17, 31, 60, 86, 121, 167, 222, 276, 350, 420, 504, 594,
#            672, 762, 891, 997, 1120, 1254, 1401, 1499, 1667, 1797, 1972,
#            2116, 2284, 2428, 2612, 2756, 2924, 3068, 3243, 3373, 3541, 3639,
#            3786, 3920, 4043, 4149, 4278, 4368, 4446, 4536, 4620, 4690, 4764,
#            4818, 4873, 4919, 4954, 4980, 5009, 5023, 5033, 5039, 5040)
#   , k8 = c(1, 8, 23, 45, 92, 146, 216, 310, 439, 563, 741, 924, 1161,
#            1399, 1675, 1939, 2318, 2667, 3047, 3447, 3964, 4358, 4900, 5392,
#            6032, 6589, 7255, 7850, 8626, 9310, 10096, 10814, 11736, 12481,
#            13398, 14179, 15161, 15987, 16937, 17781, 18847, 19692, 20628,
#            21473, 22539, 23383, 24333, 25159, 26141, 26922, 27839, 28584,
#            29506, 30224, 31010, 31694, 32470, 33065, 33731, 34288, 34928,
#            35420, 35962, 36356, 36873, 37273, 37653, 38002, 38381, 38645,
#            38921, 39159, 39396, 39579, 39757, 39881, 40010, 40104, 40174,
#            40228, 40275, 40297, 40312, 40319, 40320)
#   , k9 = c(1, 9, 30, 64, 136, 238, 368, 558, 818, 1102, 1500, 1954, 2509,
#            3125, 3881, 4625, 5647, 6689, 7848, 9130, 10685, 12077, 13796,
#            15554, 17563, 19595, 21877, 24091, 26767, 29357, 32235, 35163,
#            38560, 41698, 45345, 48913, 52834, 56700, 61011, 65061, 69913,
#            74405, 79221, 84005, 89510, 94464, 100102, 105406, 111296, 116782,
#            122970, 128472, 134908, 140730, 146963, 152987, 159684, 165404,
#            172076, 178096, 184784, 190804, 197476, 203196, 209893, 215917,
#            222150, 227972, 234408, 239910, 246098, 251584, 257474, 262778,
#            268416, 273370, 278875, 283659, 288475, 292967, 297819, 301869,
#            306180, 310046, 313967, 317535, 321182, 324320, 327717, 330645,
#            333523, 336113, 338789, 341003, 343285, 345317, 347326, 349084,
#            350803, 352195, 353750, 355032, 356191, 357233, 358255, 358999,
#            359755, 360371, 360926, 361380, 361778, 362062, 362322, 362512,
#            362642, 362744, 362816, 362850, 362871, 362879, 362880)
#   , k10 = c(1, 10, 38, 89, 196, 373, 607, 967, 1465, 2084, 2903, 3943,  5195, 6723, 8547, 10557, 13090, 15927, 19107, 22783, 27088, 31581,  36711, 42383, 48539, 55448, 62872, 70702, 79475, 88867, 98759,  109437, 121084, 133225, 146251, 160169, 174688, 190299, 206577,  223357, 242043, 261323, 280909, 301704, 324089, 346985, 370933,  395903, 421915, 449011, 477478, 505905, 536445, 567717, 599491,  632755, 667503, 702002, 738301, 774897, 813353, 852279, 892263,  931649, 973717, 1016565, 1058989, 1101914, 1146958, 1191542,  1237582, 1283078, 1329968, 1377004, 1424345, 1471991, 1520878,  1569718, 1617762, 1666302, 1716368, 1765338, 1814400, 1863462,  1912432, 1962498, 2011038, 2059082, 2107922, 2156809, 2204455,  2251796, 2298832, 2345722, 2391218, 2437258, 2481842, 2526886,  2569811, 2612235, 2655083, 2697151, 2736537, 2776521, 2815447,  2853903, 2890499, 2926798, 2961297, 2996045, 3029309, 3061083,  3092355, 3122895, 3151322, 3179789, 3206885, 3232897, 3257867,  3281815, 3304711, 3327096, 3347891, 3367477, 3386757, 3405443,  3422223, 3438501, 3454112, 3468631, 3482549, 3495575, 3507716,  3519363, 3530041, 3539933, 3549325, 3558098, 3565928, 3573352,  3580261, 3586417, 3592089, 3597219, 3601712, 3606017, 3609693,  3612873, 3615710, 3618243, 3620253, 3622077, 3623605, 3624857,  3625897, 3626716, 3627335, 3627833, 3628193, 3628427, 3628604,  3628711, 3628762, 3628790, 3628799, 3628800)
#
#   , k11 = c(1, 11, 47, 121, 277, 565, 974, 1618, 2548, 3794, 5430, 7668,  10382, 13858, 18056, 23108, 29135, 36441, 44648, 54464, 65848,  78652, 92845, 109597, 127676, 148544, 171124, 196510, 223843,  254955, 287403, 323995, 363135, 406241, 451019, 501547, 553511,  610953, 670301, 735429, 803299, 877897, 953161, 1036105, 1122228,  1215286, 1309506, 1413368, 1518681, 1632877, 1749090, 1874422,  2002045, 2140515, 2278832, 2429566, 2581919, 2744859, 2908190,  3085090, 3263110, 3453608, 3643760, 3847514, 4052381, 4272633,  4489678, 4722594, 4956028, 5204156, 5449644, 5712530, 5973493,  6250695, 6523539, 6816137, 7104526, 7411262, 7710668, 8030252,  8345178, 8678412, 9002769, 9348585, 9686880, 10046970, 10393880,  10763840, 11125055, 11506717, 11876164, 12267556, 12646883, 13049009,  13434313, 13845399, 14241951, 14660041, 15058960, 15484804, 15894731,  16324563, 16734970, 17170868, 17587363, 18027449, 18444344, 18884724,  19305912, 19748160, 20168640, 20610888, 21032076, 21472456, 21889351,  22329437, 22745932, 23181830, 23592237, 24022069, 24431996, 24857840,  25256759, 25674849, 26071401, 26482487, 26867791, 27269917, 27649244,  28040636, 28410083, 28791745, 29152960, 29522920, 29869830, 30229920,  30568215, 30914031, 31238388, 31571622, 31886548, 32206132, 32505538,  32812274, 33100663, 33393261, 33666105, 33943307, 34204270, 34467156,  34712644, 34960772, 35194206, 35427122, 35644167, 35864419, 36069286,  36273040, 36463192, 36653690, 36831710, 37008610, 37171941, 37334881,  37487234, 37637968, 37776285, 37914755, 38042378, 38167710, 38283923,  38398119, 38503432, 38607294, 38701514, 38794572, 38880695, 38963639,  39038903, 39113501, 39181371, 39246499, 39305847, 39363289, 39415253,  39465781, 39510559, 39553665, 39592805, 39629397, 39661845, 39692957,  39720290, 39745676, 39768256, 39789124, 39807203, 39823955, 39838148,  39850952, 39862336, 39872152, 39880359, 39887665, 39893692, 39898744,  39902942, 39906418, 39909132, 39911370, 39913006, 39914252, 39915182,  39915826, 39916235, 39916523, 39916679, 39916753, 39916789, 39916799,  39916800)
#
#   , k12 = c(1, 12, 57, 161, 385, 832, 1523, 2629, 4314, 6678, 9882, 14397,  20093, 27582, 36931, 48605, 62595, 80232, 100456, 125210, 154227,  188169, 226295, 272179, 322514, 381283, 446640, 521578, 602955,  697449, 798012, 913234, 1037354, 1177139, 1325067, 1493942, 1670184,  1867627, 2075703, 2306597, 2547605, 2817918, 3095107, 3402876,  3723206, 4075092, 4436130, 4836594, 5245232, 5694249, 6155263,  6658390, 7171170, 7734985, 8304533, 8927791, 9562307, 10250749,  10946272, 11707175, 12472247, 13304674, 14143124, 15051520, 15964324,  16958207, 17951038, 19024576, 20103385, 21266520, 22428668, 23688490,  24941145, 26293113, 27640685, 29092979, 30538037, 32094364, 33635325,  35292663, 36939122, 38705429, 40450799, 42327667, 44179645, 46167953,  48128734, 50226064, 52293360, 54508939, 56686818, 59015668, 61303483,  63746140, 66141668, 68703444, 71211606, 73883239, 76497639, 79284492,  82008603, 84912335, 87739711, 90750133, 93683865, 96803338, 99840816,  103063901, 106199027, 109522404, 112757434, 116187490, 119511072,  123034744, 126446666, 130064197, 133565830, 137269085, 140848253,  144633119, 148294783, 152161902, 155889546, 159821171, 163617371,  167622510, 171480066, 175541648, 179449088, 183562195, 187525039,  191692873, 195691020, 199891634, 203924412, 208164174, 212229695,  216488881, 220574078, 224852631, 228953203, 233247651, 237351468,  241650132, 245753949, 250048397, 254148969, 258427522, 262512719,  266771905, 270837426, 275077188, 279109966, 283310580, 287308727,  291476561, 295439405, 299552512, 303459952, 307521534, 311379090,  315384229, 319180429, 323112054, 326839698, 330706817, 334368481,  338153347, 341732515, 345435770, 348937403, 352554934, 355966856,  359490528, 362814110, 366244166, 369479196, 372802573, 375937699,  379160784, 382198262, 385317735, 388251467, 391261889, 394089265,  396992997, 399717108, 402503961, 405118361, 407789994, 410298156,  412859932, 415255460, 417698117, 419985932, 422314782, 424492661,  426708240, 428775536, 430872866, 432833647, 434821955, 436673933,  438550801, 440296171, 442062478, 443708937,
#             445366275, 446907236,  448463563, 449908621, 451360915, 452708487, 454060455, 455313110,  456572932, 457735080, 458898215, 459977024, 461050562, 462043393,  463037276, 463950080, 464858476, 465696926, 466529353, 467294425,  468055328, 468750851, 469439293, 470073809, 470697067, 471266615,  471830430, 472343210, 472846337, 473307351, 473756368, 474165006,  474565470, 474926508, 475278394, 475598724, 475906493, 476183682,  476453995, 476695003, 476925897, 477133973, 477331416, 477507658,  477676533, 477824461, 477964246, 478088366, 478203588, 478304151,  478398645, 478480022, 478554960, 478620317, 478679086, 478729421,  478775305, 478813431, 478847373, 478876390, 478901144, 478921368,  478939005, 478952995, 478964669, 478974018, 478981507, 478987203,  478991718, 478994922, 478997286, 478998971, 479000077, 479000768,  479001215, 479001439, 479001543, 479001588, 479001599, 479001600 )
#
#   , k13 = c(1, 13, 68, 210, 527, 1197, 2324, 4168, 7119, 11429, 17517,  26225, 37812, 53230, 73246, 98816, 130483, 170725, 218750, 278034,  349136, 434162, 532482, 651024, 785982, 944022, 1124332, 1332640,  1565876, 1835792, 2132840, 2472812, 2848749, 3273357, 3735585,  4260527, 4827506, 5461252, 6147299, 6908609, 7725716, 8635460,  9600260, 10666252, 11804773, 13050503, 14365677, 15812701, 17335403,  18994955, 20742001, 22638493, 24624900, 26787112, 29032733, 31464927,  34008755, 36743621, 39579021, 42647201, 45817786, 49226378, 52752239,  56535435, 60435209, 64628147, 68927405, 73528499, 78274283, 83329815,  88504447, 94050417, 99720505, 105759011, 111937321, 118508917,  125224959, 132372517, 139644194, 147366078, 155251313, 163598355,  172068955, 181074075, 190212385, 199875487, 209687980, 220053214,  230566521, 241680167, 252905559, 264763303, 276775771, 289421809,  302176267, 315640063, 329231261, 343509837, 357915454, 373057790,  388317114, 404365328, 420470916, 437394874, 454438992, 472280042,  490183678, 508970736, 527836540, 547557794, 567333404, 588036304,  608771329, 630463117, 652127890, 674778950, 697468748, 721126694,  744732766, 769392312, 794014392, 819670692, 845236737, 871892593,  898464180, 926132356, 953650676, 982290898, 1010834369, 1040477655,  1069921254, 1100563830, 1131007339, 1162609975, 1193943276, 1226507722,  1258827639, 1292328257, 1325502938, 1359918362, 1394027869, 1429370035,  1464279071, 1500517059, 1536339992, 1573396522, 1609980791, 1647854021,  1685286706, 1723967698, 1762082365, 1801533261, 1840420643, 1880601675,  1920106583, 1960960701, 2001224218, 2042719638, 2083488859, 2125600829,  2167005742, 2209678334, 2251531986, 2294726538, 2337123023, 2380790291,  2423568572, 2467632034, 2510865295, 2555331665, 2598793469, 2643582407,  2687416596, 2732465154, 2776464125, 2821723625, 2865981806, 2911394478,  2955721182, 3001237104, 3045709215, 3091307829, 3135712971, 3181311585,  3225783696, 3271299618, 3315626322, 3361038994, 3405297175, 3450556675,  3494555646, 3539604204, 3583438393, 3628227331, 3671689135, 3716155505,
#             3759388766, 3803452228, 3846230509, 3889897777, 3932294262, 3975488814,  4017342466, 4060015058, 4101419971, 4143531941, 4184301162, 4225796582,  4266060099, 4306914217, 4346419125, 4386600157, 4425487539, 4464938435,  4503053102, 4541734094, 4579166779, 4617040009, 4653624278, 4690680808,  4726503741, 4762741729, 4797650765, 4832992931, 4867102438, 4901517862,  4934692543, 4968193161, 5000513078, 5033077524, 5064410825, 5096013461,  5126456970, 5157099546, 5186543145, 5216186431, 5244729902, 5273370124,  5300888444, 5328556620, 5355128207, 5381784063, 5407350108, 5433006408,  5457628488, 5482288034, 5505894106, 5529552052, 5552241850, 5574892910,  5596557683, 5618249471, 5638984496, 5659687396, 5679463006, 5699184260,  5718050064, 5736837122, 5754740758, 5772581808, 5789625926, 5806549884,  5822655472, 5838703686, 5853963010, 5869105346, 5883510963, 5897789539,  5911380737, 5924844533, 5937598991, 5950245029, 5962257497, 5974115241,  5985340633, 5996454279, 6006967586, 6017332820, 6027145313, 6036808415,  6045946725, 6054951845, 6063422445, 6071769487, 6079654722, 6087376606,  6094648283, 6101795841, 6108511883, 6115083479, 6121261789, 6127300295,  6132970383, 6138516353, 6143690985, 6148746517, 6153492301, 6158093395,  6162392653, 6166585591, 6170485365, 6174268561, 6177794422, 6181203014,  6184373599, 6187441779, 6190277179, 6193012045, 6195555873, 6197988067,  6200233688, 6202395900, 6204382307, 6206278799, 6208025845, 6209685397,  6211208099, 6212655123, 6213970297, 6215216027, 6216354548, 6217420540,  6218385340, 6219295084, 6220112191, 6220873501, 6221559548, 6222193294,  6222760273, 6223285215, 6223747443, 6224172051, 6224547988, 6224887960,  6225185008, 6225454924, 6225688160, 6225896468, 6226076778, 6226234818,  6226369776, 6226488318, 6226586638, 6226671664, 6226742766, 6226802050,  6226850075, 6226890317, 6226921984, 6226947554, 6226967570, 6226982988,  6226994575, 6227003283, 6227009371, 6227013681, 6227016632, 6227018476,  6227019603, 6227020273, 6227020590, 6227020732, 6227020787, 6227020799,  6227020800)
#
#   , k14 = c(1, 14, 80, 269, 711, 1689, 3467, 6468, 11472, 19093, 30278,  46574, 69288, 99975, 141304, 195194, 264194, 352506, 462442,  598724, 766789, 970781, 1213870, 1507510, 1853680, 2260125, 2736501,  3291591, 3930026, 4668007, 5508108, 6466862, 7556159, 8787659,  10165645, 11724144, 13460539, 15392221, 17539134, 19922717, 22546063,  25447736, 28627069, 32116076, 35937108, 40106433, 44631074, 49573596,  54926631, 60716114, 66974508, 73740246, 81009240, 88845749, 97239223,  106246902, 115900686, 126216169, 137197091, 148953202, 161446731,  174730758, 188835459, 203837905, 219695178, 236524328, 254283795,  273083666, 292923813, 313860397, 335854799, 359112526, 383528656,  409202706, 436135896, 464473466, 494134210, 525276498, 557815202,  591946436, 627603800, 664907029, 703773267, 744486823, 786877234,  831103465, 877129675, 925182097, 975110533, 1027121161, 1081080881,  1137323422, 1195661689, 1256271970, 1319049120, 1384348268, 1451952010,  1522055063, 1594541080, 1669783989, 1747541228, 1828055758, 1911151548,  1997286462, 2086139682, 2177925841, 2272580839, 2370486063, 2471328513,  2575410222, 2682471831, 2793082385, 2906881741, 3024092956, 3144510886,  3268758800, 3396339981, 3527578003, 3662304885, 3800998837, 3943227695,  4089440734, 4239185132, 4393196954, 4551031331, 4712856765, 4878478438,  5048720892, 5222754969, 5401045094, 5583410846, 5770395123, 5961416258,  6157027619, 6356554732, 6561015163, 6769843465, 6983093805, 7200534248,  7423263710, 7650023569, 7881592853, 8117625307, 8358760439, 8604199870,  8854704639, 9109316970, 9369314835, 9633980748, 9903337745, 10177004917,  10456529218, 10740122230, 11028754748, 11321981370, 11620526571,  11923494567, 12231834199, 12544092637, 12862071155, 13184668352,  13511964024, 13843525611, 14181198310, 14522618329, 14869105782,  15220174133, 15576509168, 15936926462, 16302784406, 16672089744,  17047134658, 17426587171, 17810429228, 18198087372, 18591770156,  18988751460, 19390461912, 19796344325, 20207120401, 20621426516,  21040873172, 21463087253, 21890649743, 22322106033, 22757217771,  23195600046,
#             23639594170, 24086026475, 24536477172, 24990465186,  25448639418, 25909641657, 26374985116, 26842266606, 27314012018,  27788960817, 28266602799, 28746609271, 29231436410, 29717689954,  30206932003, 30698971843, 31193949888, 31690902354, 32191012868,  32692174745, 33196629733, 33703478249, 34211544046, 34720969890,  35234031737, 35747617060, 36262719119, 36779697578, 37298186864,  37817722298, 38338904825, 38860175016, 39383211341, 39907644570,  40431821887, 40956454566, 41483109694, 42009225414, 42535209127,  43062242912, 43589145600, 44116048288, 44643082073, 45169065786,  45695181506, 46221836634, 46746469313, 47270646630, 47795079859,  48318116184, 48839386375, 49360568902, 49880104336, 50398593622,  50915572081, 51430674140, 51944259463, 52457321310, 52966747154,  53474812951, 53981661467, 54486116455, 54987278332, 55487388846,  55984341312, 56479319357, 56971359197, 57460601246, 57946854790,  58431681929, 58911688401, 59389330383, 59864279182, 60336024594,  60803306084, 61268649543, 61729651782, 62187826014, 62641814028,  63092264725, 63538697030, 63982691154, 64421073429, 64856185167,  65287641457, 65715203947, 66137418028, 66556864684, 66971170799,  67381946875, 67787829288, 68189539740, 68586521044, 68980203828,  69367861972, 69751704029, 70131156542, 70506201456, 70875506794,  71241364738, 71601782032, 71958117067, 72309185418, 72655672871,  72997092890, 73334765589, 73666327176, 73993622848, 74316220045,  74634198563, 74946457001, 75254796633, 75557764629, 75856309830,  76149536452, 76438168970, 76721761982, 77001286283, 77274953455,  77544310452, 77808976365, 78068974230, 78323586561, 78574091330,  78819530761, 79060665893, 79296698347, 79528267631, 79755027490,  79977756952, 80195197395, 80408447735, 80617276037, 80821736468,  81021263581, 81216874942, 81407896077, 81594880354, 81777246106,  81955536231, 82129570308, 82299812762, 82465434435, 82627259869,  82785094246, 82939106068, 83088850466, 83235063505, 83377292363,  83515986315, 83650713197, 83781951219, 83909532400, 84033780314,  84154198244, 84271409459, 84385208815, 84495819369,
#             84602880978,  84706962687, 84807805137, 84905710361, 85000365359, 85092151518,  85181004738, 85267139652, 85350235442, 85430749972, 85508507211,  85583750120, 85656236137, 85726339190, 85793942932, 85859242080,  85922019230, 85982629511, 86040967778, 86097210319, 86151170039,  86203180667, 86253109103, 86301161525, 86347187735, 86391413966,  86433804377, 86474517933, 86513384171, 86550687400, 86586344764,  86620475998, 86653014702, 86684156990, 86713817734, 86742155304,  86769088494, 86794762544, 86819178674, 86842436401, 86864430803,  86885367387, 86905207534, 86924007405, 86941766872, 86958596022,  86974453295, 86989455741, 87003560442, 87016844469, 87029337998,  87041094109, 87052075031, 87062390514, 87072044298, 87081051977,  87089445451, 87097281960, 87104550954, 87111316692, 87117575086,  87123364569, 87128717604, 87133660126, 87138184767, 87142354092,  87146175124, 87149664131, 87152843464, 87155745137, 87158368483,  87160752066, 87162898979, 87164830661, 87166567056, 87168125555,  87169503541, 87170735041, 87171824338, 87172783092, 87173623193,  87174361174, 87174999609, 87175554699, 87176031075, 87176437520,  87176783690, 87177077330, 87177320419, 87177524411, 87177692476,  87177828758, 87177938694, 87178027006, 87178096006, 87178149896,  87178191225, 87178221912, 87178244626, 87178260922, 87178272107,  87178279728, 87178284732, 87178287733, 87178289511, 87178290489,  87178290931, 87178291120, 87178291186, 87178291199, 87178291200 )
#
#   , k15 = c(1, 15, 93, 339, 946, 2344, 5067, 9845, 18094, 31210, 51135,  80879, 123856, 183350, 265744, 375782, 520770, 709108, 950935,  1254359, 1637783, 2110255, 2688261, 3392105, 4243753, 5253985,  6463435, 7887051, 9559689, 11508657, 13779635, 16385319, 19406949,  22847453, 26778757, 31237429, 36312890, 41988174, 48415169, 55581133,  63617482, 72531890, 82493993, 93449491, 105663309, 119038213,  133821033, 149981059, 167810258, 187138620, 208394580, 231407260,  256572630, 283728734, 313349422, 345140612, 379784963, 416871267,  457037763, 499992359, 546463298, 595886554, 649243982, 705940396,  766920856, 831552862, 900947933, 974276983, 1052930913, 1135866291,  1224452526, 1317816142, 1417501545, 1522137313, 1633652530, 1750626806,  1875052020, 2005336686, 2143665106, 2288248572, 2441639216, 2601691186,  2771087853, 2947714613, 3134569070, 3328885582, 3534148307, 3747528715,  3972688056, 4206327920, 4452435789, 4707707507, 4976502908, 5254730366,  5547265512, 5849894908, 6167966973, 6496524245, 6841251954, 7197208516,  7570606695, 7955492307, 8358702869, 8774325693, 9209487348, 9657140024,  10125565750, 10607269130, 11110947428, 11628498256, 12168723926,  12723609294, 13303228032, 13897378066, 14517038181, 15152582797,  15815095216, 16493452984, 17200382721, 17923779849, 18677052770,  19447720986, 20249039825, 21068309835, 21920989644, 22790961184,  23695090223, 24618800757, 25577947305, 26555930925, 27571664648,  28606831690, 29681188983, 30776084989, 31910591023, 33065874467,  34264718158, 35483254398, 36745418556, 38030320602, 39360005810,  40711195500, 42110524356, 43531199878, 45001319765, 46494257553,  48036654343, 49602075643, 51221875032, 52862604614, 54557065970,  56276716608, 58051331346, 59848489468, 61704800734, 63582981112,  65521450173, 67484389131, 69506528883, 71552497079, 73663855894,  75795896650, 77992481274, 80214974822, 82502403057, 84811883255,  87191972089, 89593082611, 92064881373, 94560883919, 97125402107,  99713005329, 102377610307, 105060302611, 107817686686, 110599694856,  113456740182, 116333639168, 119291579167, 122267356121,
#             125323501236,  128401997238, 131558157109, 134734085833, 137997611218, 141274089126,  144635051739, 148017803651, 151483637626, 154964665476, 158536414603,  162120609581, 165794608949, 169485898871, 173262539499, 177052751993,  180940334728, 184834047000, 188819766650, 192821736664, 196913537154,  201013587060, 205213037672, 209416246916, 213716661616, 218026615728,  222428224181, 226835589231, 231347734832, 235855804736, 240461451056,  245075672864, 249785350011, 254493014069, 259306386598, 264111876662,  269020469253, 273929072733, 278932752466, 283931152738, 289039128373,  294131477475, 299325743006, 304517112400, 309806619906, 315081186550,  320465864608, 325829963244, 331299254515, 336756611895, 342309552544,  347844707934, 353492785526, 359109888388, 364830049809, 370533853771,  376336452468, 382110605480, 387994926455, 393843943991, 399797486177,  405725583879, 411748092537, 417737799943, 423839699258, 429894358406,  436050852136, 442177460900, 448399401827, 454577618889, 460862851875,  467097523711, 473433714049, 479729592211, 486115143213, 492451898587,  498897897209, 505281471971, 511760849379, 518195355931, 524718405991,  531183425467, 537750411835, 544250726707, 550846203604, 557385785810,  564007939322, 570567450178, 577227764133, 583810787025, 590480506935,  597092270467, 603784200787, 610403013525, 617114828578, 623745063632,  630461354816, 637109043600, 643828046362, 650470873262, 657203494738,  663846321638, 670565324400, 677213013184, 683929304368, 690559539422,  697271354475, 703890167213, 710582097533, 717193861065, 723863580975,  730446603867, 737106917822, 743666428678, 750288582190, 756828164396,  763423641293, 769923956165, 776490942533, 782955962009, 789479012069,  795913518621, 802392896029, 808776470791, 815222469413, 821559224787,  827944775789, 834240653951, 840576844289, 846811516125, 853096749111,  859274966173, 865496907100, 871623515864, 877780009594, 883834668742,  889936568057, 895926275463, 901948784121, 907876881823, 913830424009,  919679441545, 925563762520, 931337915532, 937140514229, 942844318191,  948564479612,
#             954181582474, 959829660066, 965364815456, 970917756105,  976375113485, 981844404756, 987208503392, 992593181450, 997867748094,  1003157255600, 1008348624994, 1013542890525, 1018635239627, 1023743215262,  1028741615534, 1033745295267, 1038653898747, 1043562491338, 1048367981402,  1053181353931, 1057889017989, 1062598695136, 1067212916944, 1071818563264,  1076326633168, 1080838778769, 1085246143819, 1089647752272, 1093957706384,  1098258121084, 1102461330328, 1106660780940, 1110760830846, 1114852631336,  1118854601350, 1122840321000, 1126734033272, 1130621616007, 1134411828501,  1138188469129, 1141879759051, 1145553758419, 1149137953397, 1152709702524,  1156190730374, 1159656564349, 1163039316261, 1166400278874, 1169676756782,  1172940282167, 1176116210891, 1179272370762, 1182350866764, 1185407011879,  1188382788833, 1191340728832, 1194217627818, 1197074673144, 1199856681314,  1202614065389, 1205296757693, 1207961362671, 1210548965893, 1213113484081,  1215609486627, 1218081285389, 1220482395911, 1222862484745, 1225171964943,  1227459393178, 1229681886726, 1231878471350, 1234010512106, 1236121870921,  1238167839117, 1240189978869, 1242152917827, 1244091386888, 1245969567266,  1247825878532, 1249623036654, 1251397651392, 1253117302030, 1254811763386,  1256452492968, 1258072292357, 1259637713657, 1261180110447, 1262673048235,  1264143168122, 1265563843644, 1266963172500, 1268314362190, 1269644047398,  1270928949444, 1272191113602, 1273409649842, 1274608493533, 1275763776977,  1276898283011, 1277993179017, 1279067536310, 1280102703352, 1281118437075,  1282096420695, 1283055567243, 1283979277777, 1284883406816, 1285753378356,  1286606058165, 1287425328175, 1288226647014, 1288997315230, 1289750588151,  1290473985279, 1291180915016, 1291859272784, 1292521785203, 1293157329819,  1293776989934, 1294371139968, 1294950758706, 1295505644074, 1296045869744,  1296563420572, 1297067098870, 1297548802250, 1298017227976, 1298464880652,  1298900042307, 1299315665131, 1299718875693, 1300103761305, 1300477159484,  1300833116046, 1301177843755, 1301506401027, 1301824473092,
#             1302127102488,  1302419637634, 1302697865092, 1302966660493, 1303221932211, 1303468040080,  1303701679944, 1303926839285, 1304140219693, 1304345482418, 1304539798930,  1304726653387, 1304903280147, 1305072676814, 1305232728784, 1305386119428,  1305530702894, 1305669031314, 1305799315980, 1305923741194, 1306040715470,  1306152230687, 1306256866455, 1306356551858, 1306449915474, 1306538501709,  1306621437087, 1306700091017, 1306773420067, 1306842815138, 1306907447144,  1306968427604, 1307025124018, 1307078481446, 1307127904702, 1307174375641,  1307217330237, 1307257496733, 1307294583037, 1307329227388, 1307361018578,  1307390639266, 1307417795370, 1307442960740, 1307465973420, 1307487229380,  1307506557742, 1307524386941, 1307540546967, 1307555329787, 1307568704691,  1307580918509, 1307591874007, 1307601836110, 1307610750518, 1307618786867,  1307625952831, 1307632379826, 1307638055110, 1307643130571, 1307647589243,  1307651520547, 1307654961051, 1307657982681, 1307660588365, 1307662859343,  1307664808311, 1307666480949, 1307667904565, 1307669114015, 1307670124247,  1307670975895, 1307671679739, 1307672257745, 1307672730217, 1307673113641,  1307673417065, 1307673658892, 1307673847230, 1307673992218, 1307674102256,  1307674184650, 1307674244144, 1307674287121, 1307674316865, 1307674336790,  1307674349906, 1307674358155, 1307674362933, 1307674365656, 1307674367054,  1307674367661, 1307674367907, 1307674367985, 1307674367999, 1307674368000 )
# )
#
# .PageDF <- lapply(.PageDF, function(x) c(x[1], diff(x)) / tail(x,1))
# save(.PageDF, file="C:/Users/Andri/Documents/R/sources/DescTools/MakeDescToolsBase/PageDF.rda")

# load(file="C:/Users/Andri/Documents/R/Projects/load/PageDF.rda")
# load(file="C:/Users/Andri/Documents/R/Projects/DescTools/load/wdConst.rda")
# load(file="C:/Users/Andri/Documents/R/sources/DescTools/periodic.rda")

utils::globalVariables(c("d.units","d.periodic","d.prefix","day.name","day.abb","wdConst","hblue","hred","hgreen"))

# source( "C:/Users/Andri/Documents/R/sources/DescTools/wdConst.r" )

# Base functions  ====

## base: calculus

# we have month.name and month.abb in base R, but nothing similar for day names
# in english (use format(ISOdate(2000, 1:12, 1), "%B") for months in current locale)

day.name <- c("Monday","Tuesday","Wednesday","Thursday","Friday","Saturday","Sunday")
day.abb <- c("Mon","Tue","Wed","Thu","Fri","Sat","Sun")



Primes <- function (n) {
# Source: sfsmisc
# Bill Venables (<= 2001); Martin Maechler gained another 40% speed, working with logicals and integers.
    if ((M2 <- max(n)) <= 1)
        return(integer(0))
    P <- rep.int(TRUE, M2)
    P[1] <- FALSE
    M <- as.integer(sqrt(M2))
    n <- as.integer(M2)
    for (p in 1:M) if (P[p])
        P[seq(p * p, n, p)] <- FALSE
    (1:n)[P]
}


Factorize <- function (n) {
  # Factorize <- function (n, verbose = FALSE) {
  # Source sfsmisc: Martin Maechler, Jan. 1996.
    if (all(n < .Machine$integer.max))
        n <- as.integer(n)
    else {
        warning("factorizing large int ( > maximal integer )")
        n <- round(n)
    }
    N <- length(n)
    M <- as.integer(sqrt(max(n)))
    k <- length(pr <- Primes(M))
    nDp <- outer(pr, n, FUN = function(p, n) n%%p == 0)
    res <- vector("list", length = N)
    names(res) <- n
    for (i in 1:N) {
        nn <- n[i]
        if (any(Dp <- nDp[, i])) {
            nP <- length(pfac <- pr[Dp])
#            if (verbose) cat(nn, " ")
        }
        else {
            res[[i]] <- cbind(p = nn, m = 1)
#            if (verbose) cat("direct prime", nn, "\n")
            next
        }
        m.pr <- rep(1, nP)
        Ppf <- prod(pfac)
        while (1 < (nn <- nn%/%Ppf)) {
            Dp <- nn%%pfac == 0
            if (any(Dp)) {
                m.pr[Dp] <- m.pr[Dp] + 1
                Ppf <- prod(pfac[Dp])
            }
            else {
                pfac <- c(pfac, nn)
                m.pr <- c(m.pr, 1)
                break
            }
        }
        res[[i]] <- cbind(p = pfac, m = m.pr)
    }
    res
}



GCD <- function(..., na.rm = FALSE) {

  x <- unlist(list(...), recursive=TRUE)

  if(na.rm) x <- na.omit(x)
  if(anyNA(x)) return(NA)


  stopifnot(is.numeric(x))
  if (floor(x) != ceiling(x) || length(x) < 2)
    stop("Argument 'x' must be an integer vector of length >= 2.")

  x <- x[x != 0]
  n <- length(x)
  if (n == 0) {
    g <- 0
  } else if (n == 1) {
    g <- x
  } else if (n == 2) {
    g <- .Call("DescTools_compute_GCD", PACKAGE = "DescTools", x[1], x[2])
  } else {
    # g <- .GCD(x[1], x[2])
    g <- .Call("DescTools_compute_GCD", PACKAGE = "DescTools", x[1], x[2])
    for (i in 3:n) {
      g <- .Call("DescTools_compute_GCD", PACKAGE = "DescTools", g, x[i])
      if (g == 1) break
    }
  }
  return(g)
}


LCM <- function(..., na.rm = FALSE) {


#   .LCM <- function(n, m) {
#     stopifnot(is.numeric(n), is.numeric(m))
#     if (length(n) != 1 || floor(n) != ceiling(n) ||
#           length(m) != 1 || floor(m) != ceiling(m))
#       stop("Arguments 'n', 'm' must be integer scalars.")
#     if (n == 0 && m == 0) return(0)
#
#     return(n / GCD(c(n, m)) * m)
#   }

  x <- unlist(list(...), recursive=TRUE)

  if(na.rm) x <- na.omit(x)
  if(anyNA(x)) return(NA)


  stopifnot(is.numeric(x))
  if (floor(x) != ceiling(x) || length(x) < 2)
    stop("Argument 'x' must be an integer vector of length >= 2.")

  x <- x[x != 0]
  n <- length(x)
  if (n == 0) {
    l <- 0
  } else if (n == 1) {
    l <- x
  } else if (n == 2) {
    # l <- .LCM(x[1], x[2])
    l <- .Call("DescTools_compute_LCM", PACKAGE = "DescTools", x[1], x[2])
  } else {
#    l <- .LCM(x[1], x[2])
    l <- .Call("DescTools_compute_LCM", PACKAGE = "DescTools", x[1], x[2])
    for (i in 3:n) {
#      l <- .LCM(l, x[i])
      l <- .Call("DescTools_compute_LCM", PACKAGE = "DescTools", l, x[i])
    }
  }
  return(l)
}



CombN <- function(x, m, repl=FALSE, ord=FALSE){
  # return the number for the 4 combinatoric cases
  n <- length(x)
  if(repl){
    res <- n^m
    if(!ord){
      res <- choose(n+m-1, m)
    }
  } else {
    if(ord){
      res <- choose(n, m) * factorial(m)
    } else {
      res <- choose(n, m)
    }
  }

  return(res)

}



Permn <- function(x, sort = FALSE) {

  # by F. Leisch

  n <- length(x)

  if (n == 1)
    return(matrix(x))
# Andri: why should we need that??? ...
#   else if (n < 2)
#     stop("n must be a positive integer")
  z <- matrix(1)
  for (i in 2:n) {
    y <- cbind(z, i)
    a <- c(1:i, 1:(i - 1))
    z <- matrix(0, ncol = ncol(y), nrow = i * nrow(y))
    z[1:nrow(y), ] <- y
    for (j in 2:i - 1) {
      z[j * nrow(y) + 1:nrow(y), ] <- y[, a[1:i + j]]
    }
  }
  dimnames(z) <- NULL

  m <- apply(z, 2, function(i) x[i])

  if(any(duplicated(x)))
    m <- unique(m)

  if(sort) m <- Sort(m)
  return(m)

}



CombSet <- function(x, m, repl=FALSE, ord=FALSE, as.list=FALSE) {

  if(length(m)>1){
    res <- lapply(m, function(i) CombSet(x=x, m=i, repl=repl, ord=ord))

  } else {
    # generate the samples for the 4 combinatoric cases
    if(repl){
      res <- as.matrix(do.call(expand.grid, as.list(as.data.frame(replicate(m, x)))))
      dimnames(res) <- NULL
      if(!ord){
        res <- unique(t(apply(res, 1, sort)))
      }
    } else {
      if(ord){
        res <- do.call(rbind, combn(x, m=m, FUN=Permn, simplify = FALSE))
      } else {
        res <- t(combn(x, m))
      }
    }
  }

  if(as.list){

    # Alternative: we could flatten the whole list
    # and now flatten the list of lists into one list
    # lst <- split(unlist(lst), rep(1:length(idx <- rapply(lst, length)), idx))

    if(is.list(res)){
      res <- do.call(c, lapply(res,
                               function(x){ as.list(as.data.frame(t(x), stringsAsFactors = FALSE))}))
    } else {
      res <- as.list(as.data.frame(t(res), stringsAsFactors = FALSE))
    }
    names(res) <- NULL
  }
  return(res)

}


# CombSet(x, m, repl=TRUE, ord=FALSE)
# CombSet(x, m, repl=TRUE, ord=TRUE)
# CombSet(x, m, repl=FALSE, ord=TRUE)
# CombSet(x, m, repl=FALSE, ord=FALSE)


CombPairs <- function(x, y = NULL) {
  # liefert einen data.frame mit allen paarweisen Kombinationen der Variablen
  if( missing(y)) {  # kein y vorhanden, use x only
    data.frame( t(combn(x, 2)), stringsAsFactors=F )
  } else {
    # wenn y definiert ist, wird all.x zu all.y zurueckgegeben
    expand.grid(x, y, stringsAsFactors=F )
  }
}


# GetAllSubsets <- function(x, min.n=1, max.n=length(x)){
#   # returns a list with all subsets of x
#   # CAUTION: this can be heavy for moderate length of x
#   lst <- lapply( min.n:max.n, function(i) {
#     m <- combn(x,i) # this is a matrix, split into it's columns
#     lapply( seq_len(ncol(m)), function(k) m[,k])
#   }  )
#   # Alternative:
#   # lst <- lapply(min.n:max.n, function(i) lapply(apply(combn(x,i),2,list),unlist))
#   # flatten the list of lists to one single list
#   lst <- split(unlist(lst), rep(1:length(idx <- rapply(lst, length)), idx))
#   return(lst)
# }



# Permn <- function(x, sort = FALSE) {
#
#   # by F. Leisch
#
#   n <- length(x)
#
#   if (n == 1)
#     return(matrix(1))
#   else if (n < 2)
#     stop("n must be a positive integer")
#   z <- matrix(1)
#   for (i in 2:n) {
#     y <- cbind(z, i)
#     a <- c(1:i, 1:(i - 1))
#     z <- matrix(0, ncol = ncol(y), nrow = i * nrow(y))
#     z[1:nrow(y), ] <- y
#     for (j in 2:i - 1) {
#       z[j * nrow(y) + 1:nrow(y), ] <- y[, a[1:i + j]]
#     }
#   }
#   dimnames(z) <- NULL
#
#   m <- apply(z, 2, function(i) x[i])
#
#   if(any(duplicated(x)))
#     m <- unique(m)
#
#   if(sort) m <- Sort(m)
#   return(m)
#
# }


# this was far too slow

# Permn <- function(x){
#
# #' Determine all permutations of a set.
# #'
# #' An implementation of the Steinhaus-Johnson-Trotter permutation algorithm.
# #'
# #' @param set a set
# #' @return a matrix whose rows are the permutations of set
# #' @export
# #' @examples
# #' permutations(1:3)
# #' permutations(c('first','second','third'))
# #' permutations(c(1,1,3))
# #' apply(permutations(letters[1:6]), 1, paste, collapse = '')
# # author: David Kahle <david.kahle@gmail.com>
# # package: mpoly
# # original function name: permutations
#
#   insert <- function(elem, slot, v){
#     n <- length(v)
#     if(slot == 1) return( c(elem, v) )
#     if(slot == n+1) return( c(v, elem) )
#     c(v[1:(slot-1)], elem, v[slot:n])
#   }
#
#   r <- length(x)
#   if(r == 1) return(as.matrix(x))
#
#   row2diag <- function(row, direction){
#     np1 <- length(row) + 1
#     mat <- matrix(nrow = np1, ncol = np1)
#     if(direction == -1){
#       for(k in 1:np1){
#         mat[k,] <- insert(np1, np1-k+1, row)
#       }
#     }
#     if(direction == +1){
#       for(k in 1:np1){
#         mat[k,] <- insert(np1, k, row)
#       }
#     }
#     mat
#   }
#
#   stepUp <- function(mat){ # an r x c matrix
#     c <- ncol(mat)
#     m <- NULL
#     for(k in 1:nrow(mat)){
#       m <- rbind(m, row2diag(mat[k,],(-1)^k))
#     }
#     m
#   }
#
#   # iterate stepUp
#   out <- matrix(1)
#   for(k in 1:(r-1)){
#     out <- stepUp(out)
#   }
#
#   # substitute set values
#   for(k in 1:r){
#     out[out==k] <- paste('_', x[k], sep = '')
#   }
#   out <- gsub('_', '', out) # clear PH
#   if(is.numeric(x)){
#     d <- dim(out)
#     out <- as.numeric(out)
#     dim(out) <- d
#   }
#
#   # return
#   unique(out)
# }


# the easy way by myself:
#
# Permn <- function(x) {
  # m <- expand.grid( split( rep(x, each=length(x)), 1:length(x)) )
  # attr(m, "out.attrs") <- NULL
  # ### get rid of rows with duplicated elements
  # m <- m[ apply( m, 1, FUN=function(x){ sum(duplicated(x)) } )==0, ]
  # ### .. und sortiere noch sinnvoll
  # m <- m[ do.call(order, m[colnames(m)]), ]
  # rownames(m) <- 1:nrow(m)
  # return(m)
# }



# Fibonacci <- function(n, sequence = TRUE) {
#   if (!is.numeric(n) || length(n) != 1 || floor(n) != ceiling(n) || n < 0)
#     stop("Argument 'n' must be a single integer >= 0.")
#   if (n <= 1) return(c(1))
#
#   if (sequence) {
#     if (n == 2) return(c(1, 2))
#     fib <- numeric(n)
#     fib[1:2] <- c(1, 2)
#     for (k in 3:n) {
#       fib[k] <- fib[k-1] + fib[k-2]
#     }
#   } else {
#     if (n <= 1) {
#       return(1)
#     } else {
#       fib = Fibonacci(n-1) + Fibonacci(n-2)
#     }
#   }
#   return(fib)
# }



Fibonacci <- function(n) {

  if (!is.numeric(n) || !IsWhole(n) || n < 0)
    stop("Argument 'n' must be integer >= 0.")

  maxn <- max(n)
  if (maxn == 0) return(0)
  if (maxn == 1) return(c(0, 1)[n+1])
  if (maxn == 2) return(c(0, 1, 1)[n+1])
  z <- c(0, 1, 1, rep(NA, maxn-3))
  for (i in 4:(maxn+1)) {
    z[i] <- z[i-1] + z[i-2]
  }

  z[n+1]

}



Vigenere <- function(x, key = NULL, decrypt = FALSE) {

  # hold that constant, as it makes the function too flexible else
  # in cases you maybe remind your password, but lost the charlist definition....
  charlist <- c(LETTERS, letters, 0:9)

  if(is.null(key)) key <- PasswordDlg()

  .mod1 <- function(v, n) {
    # mod1(1:20, 6)   =>   1 2 3 4 5 6 1 2 3 4 5 6 1 2 3 4 5 6 1 2
    ((v - 1) %% n) + 1
  }

  .str2ints <- function(s) {

    as.integer(Filter(Negate(is.na),
                      factor(levels = charlist, strsplit(s, "")[[1]])))
  }

  x <- .str2ints(x)
  key <- rep(.str2ints(key), len = length(x)) - 1
  paste(collapse = "", charlist[
    .mod1(x + (if (decrypt) -1 else 1)*key, length(charlist))])
}




Winsorize <- function(x, minval = NULL, maxval = NULL,
                      probs=c(0.05, 0.95), na.rm = FALSE) {

  # following an idea from Gabor Grothendieck
  # http://r.789695.n4.nabble.com/how-to-winsorize-data-td930227.html

  # in HuberM things are implemented the same way

  # don't eliminate NAs in x, moreover leave them untouched,
  # just calc quantile without them...

  # pmax(pmin(x, maxval), minval)

  # the pmax(pmin()-version is slower than the following
  if(is.null(minval) || is.null(maxval)){
    xq <- quantile(x=x, probs=probs, na.rm=na.rm)
    if(is.null(minval)) minval <- xq[1]
    if(is.null(maxval)) maxval <- xq[2]
  }

  x[x<minval] <- minval
  x[x>maxval] <- maxval

  return(x)

  # see also Andreas Alfons, KU Leuven
  # roubustHD, Winsorize

  # Jim Lemon's rather clumsy implementation:

  # #added winsor.var and winsor.sd and winsor.mean (to supplement winsor.means)
  # #August 28, 2009 following a suggestion by Jim Lemon
  # #corrected January 15, 2009 to use the quantile function rather than sorting.
  # #suggested by Michael Conklin in correspondence with Karl Healey
  # #this preserves the order of the data
  # "wins" <- function(x,trim=.2, na.rm=TRUE) {
    # if ((trim < 0) | (trim>0.5) )
        # stop("trimming must be reasonable")
      # qtrim <- quantile(x,c(trim,.5, 1-trim),na.rm = na.rm)
      # xbot <- qtrim[1]
      # xtop <- qtrim[3]
       # if(trim<.5) {
      # x[x < xbot]  <- xbot
      # x[x > xtop] <- xtop} else {x[!is.na(x)] <- qtrim[2]}
     # return(x) }

}


Trim <- function(x, trim = 0.1, na.rm = FALSE){

  if (na.rm) x <- na.omit(x)

  if (!is.numeric(trim) || length(trim) != 1L)
    stop("'trim' must be numeric of length one")

  n <- length(x)

  if (trim > 0 && n) {
    if (is.complex(x))
      stop("trim is not defined for complex data")
    if (anyNA(x))
      return(NA_real_)
    if (trim >= 0.5 && trim < 1)
      return(NA_real_)
    if(trim < 1)
      lo <- floor(n * trim) + 1
    else{
      lo <- trim + 1
      if (trim >= (n/2))
        return(NA_real_)
    }
    hi <- n + 1 - lo
    x <- sort.int(x, partial = unique(c(lo, hi)))[lo:hi]
  }
  return(x)
}


RobScale <- function(x, center = TRUE, scale = TRUE){

  x <- as.matrix(x)

  if(center) {
    x <- scale(x, center = apply(x, 2, median, na.rm=TRUE), scale = FALSE)
  }
  if(scale) {
    x <- scale(x, center = FALSE, scale = apply(x, 2, mad, na.rm=TRUE))
  }
  return(x)
}



MoveAvg <- function(x, order, align = c("center","left","right"),
                    endrule = c("NA", "keep", "constant")){

  n <- length(x)
  align   = match.arg(align)

  switch(align,
  "center" = {
      idx <- c(1:(order %/% 2), (n-order %/% 2+1):n)
      idx_const <- c(rep((order %/% 2)+1, order %/% 2),
                     rep(n-(order %/% 2), order %/% 2))

      if(order %% 2 == 1){   # order is odd
        z <- filter(x, rep(1/order, order), sides=2)
      } else {           # order is even
        z <- filter(x, c(1/(2*order), rep(1/order, order-1), 1/(2*order)), sides=2)
      }   }
  , "right" = {
      idx <- 1:(order-1)
      idx_const <- order
      z <- filter(x, rep(1/order, order), sides=1)
    }
  , "left" = {
      idx <- (n-order+2):n
      idx_const <- n-order+1
      z <- rev(filter(rev(x), rep(1/order, order), sides=1))
  }
  )

  endrule <- match.arg(endrule)
  switch(endrule,
         "NA" =     {},
         keep =     {z[idx] <- x[idx]},
         constant = {z[idx] <- z[idx_const]})

  if(!is.ts(x)) attr(z, "tsp") <- NULL
  class(z) <- class(x)
  return(z)
}




LinScale <- function (x, low = NULL, high = NULL, newlow = 0, newhigh = 1)  {

    x <- as.matrix(x)

    if(is.null(low)) {
      low <- apply(x, 2, min, na.rm=TRUE)
    } else {
      low <- rep(low, length.out=ncol(x))
    }
    if(is.null(high)) {
      high <- apply(x, 2, max, na.rm=TRUE)
    } else {
      high <- rep(high, length.out=ncol(x))
    }
    # do the recycling job
    newlow <- rep(newlow, length.out=ncol(x))
    newhigh <- rep(newhigh, length.out=ncol(x))

    xcntr <- (low * newhigh - high * newlow) / (newhigh - newlow)
    xscale <- (high - low) / (newhigh - newlow)

    return( scale(x, center = xcntr, scale = xscale))

}



Small <- function (x, k = 5, unique = FALSE, na.rm = FALSE) {

  if (na.rm)
    x <- na.omit(x)

  if (unique==TRUE) {
    ux <- unique(x)
    un <- length(ux)
    maxval <- sort(ux, partial = min(k, un))[min(k, un)]

    # we are using the rationale of rle here, as it turned out to be the fastest approach
    x <- sort(x[x<=maxval])
    n <- length(x)
    if (n == 0L)
      res <- list(lengths = integer(), values = x)

    y <- x[-1L] != x[-n]
    i <- c(which(y | is.na(y)), n)
    res <- list(lengths = diff(c(0L, i)), values = x[i])

    # res <- unclass(rle(sort(x[x<=maxval])))
  }
  else {
    n <- length(x)
    res <- sort(x, partial = 1:min(k, n))[1:min(k, n)]
    #   lst <- as.vector(unlist(lapply(lst, "[", "val")))
    #   http://stackoverflow.com/questions/15659783/why-does-unlist-kill-dates-in-r
  }
  return(res)
}


Large <- function (x, k = 5, unique = FALSE, na.rm = FALSE) {

  if (na.rm)
    x <- na.omit(x)

  if (unique==TRUE) {
    ux <- unique(x)
    un <- length(ux)
    minval <- sort(ux, partial=max((un-k+1), 1):un)[max((un-k+1),1)]

    # we are using the rationale of rle here, as it turned out to be the fastest approach
    x <- sort(x[x>=minval])
    n <- length(x)
    if (n == 0L)
      res <- list(lengths = integer(), values = x)

    y <- x[-1L] != x[-n]
    i <- c(which(y | is.na(y)), n)
    res <- list(lengths = diff(c(0L, i)), values = x[i])

    # res <- unclass(rle(sort(x[x>=minval])))
  }
  else {
    n <- length(x)
    res <- sort(x, partial=max((n-k+1),1):n)[max((n-k+1),1):n]
    #   lst <- as.vector(unlist(lapply(lst, "[", "val")))
    #   http://stackoverflow.com/questions/15659783/why-does-unlist-kill-dates-in-r
  }
  return(res)
}


# Small <- function(x, k = 5, unique = FALSE, na.rm = FALSE){
#   if(na.rm) x <- na.omit(x)
#   if(unique){
#     ux <- unique(x)
#     un <- length(ux)
#     lst <- lapply(sort(ux, partial=1:min(k,un))[1:min(k,un)], function(n) list(val=n, n=length(which(x == n))))
#   } else {
#     n <- length(x)
#     lst <- lapply(sort(x, partial=1:min(k,n))[1:min(k,n)], function(n) list(val=n, n=length(which(x == n))))
# #   lst <- as.vector(unlist(lapply(lst, "[", "val")))
# #   http://stackoverflow.com/questions/15659783/why-does-unlist-kill-dates-in-r
#     lst <- do.call("c", sapply(lst, "[", "val") )
#     names(lst) <- NULL
#   }
#   return(lst)
# }


# Large <- function(x, k = 5, unique = FALSE, na.rm = FALSE){
#   if(na.rm) x <- na.omit(x)
#   if(unique){
#     ux <- unique(x)
#     un <- length(ux)
#     lst <- lapply(sort(ux, partial=max((un-k+1), 1):un)[max((un-k+1),1):un], function(n) list(val=n, n=length(which(x == n))))
#   } else {
#     n <- length(x)
#     lst <- lapply(sort(x, partial=max((n-k+1),1):n)[max((n-k+1),1):n], function(n) list(val=n, n=length(which(x == n))))
# #   http://stackoverflow.com/questions/15659783/why-does-unlist-kill-dates-in-r
# #    lst <- as.vector(unlist(lapply(lst, "[", "val")))
#     lst <- do.call("c", sapply(lst, "[", "val") )
#     names(lst) <- NULL
#   }
#   return(lst)
# }



HighLow <- function (x, nlow = 5, nhigh = nlow, na.rm = FALSE) {

  # updated 1.2.2014 / Andri
  # using table() was unbearable slow and inefficient for big vectors!!
  # sort(partial) is the way to go..
  # http://r.789695.n4.nabble.com/Fast-way-of-finding-top-n-values-of-a-long-vector-td892565.html

  if(na.rm) x <- na.omit(x)

  if ((nlow + nhigh) != 0) {
    frqs <- Small(x, k=nlow, unique=TRUE, na.rm=na.rm)
    frql <- Large(x, k=nhigh, unique=TRUE, na.rm=na.rm)
    frq <- c(frqs$lengths, frql$lengths)

    vals <- c(frqs$values, frql$values)
    if (is.numeric(x)) {
      vals <- prettyNum(vals, big.mark = "'")
    }
    else {
      vals <- vals
    }
    frqtxt <- paste(" (", frq, ")", sep = "")
    frqtxt[frq < 2] <- ""

#     txt <- StrTrim(paste(vals, frqtxt, sep = ""))
#     lowtxt <- paste(head(txt, nlow), collapse = ", ")
#     hightxt <- paste(tail(txt, nhigh), collapse = ", ")

    txt <- StrTrim(paste(vals, frqtxt, sep = ""))
    lowtxt <- paste(head(txt, min(length(frqs$lengths), nlow)), collapse = ", ")
    hightxt <- paste(tail(txt, min(length(frql$lengths), nhigh)), collapse = ", ")
  }
  else {
    lowtxt <- ""
    hightxt <- ""
  }
  return(paste("lowest : ", lowtxt, "\n",
               "highest: ", hightxt, "\n", sep = ""))
}



Closest <- function(x, a, which = FALSE, na.rm = FALSE){

#   # example: Closest(a=67.5, x=d.pizza$temperature)
#
  if(na.rm) x <- na.omit(x)

  mdist <- min(abs(x-a))
  if(is.na(mdist))
    res <- NA

  else {
    idx <- DescTools::IsZero(abs(x-a) - mdist)    # beware of floating-point-gods
    if(which == TRUE )
      res <- which(idx)
    else
      res <- x[idx]
  }

# Frank's Hmisc solution is faster
# but does not handle ties satisfactorily

#   res <- .Fortran("wclosest", as.double(a), as.double(x), length(a),
#            length(x), j = integer(length(a)), PACKAGE = "DescTools")$j
#   if(!which) res <- x[res]
  return(res)

}


DenseRank <- function(x, na.last = TRUE) {
  as.numeric(as.factor(rank(x, na.last)))
}



###

## base: string functions ====


# Missing string functions for newbies..

StrTrim <- function(x, pattern=" \t\n", method="both") {

  switch(match.arg(arg = method, choices = c("both", "left", "right")),
         both =  { gsub( pattern=gettextf("^[%s]+|[%s]+$", pattern, pattern), replacement="", x=x) },
         left =  { gsub( pattern=gettextf("^[%s]+",pattern), replacement="", x=x)  },
         right = { gsub( pattern=gettextf("[%s]+$",pattern), replacement="", x=x)  }
         )

}


StrRight <- function(x, n) {
  n <- rep(n, length.out=length(x))
  sapply(seq_along(x), function(i) substr(x[i], (nchar(x[i]) - n[i]+1), nchar(x[i])))
}

StrLeft <- function(x, n) {
  n <- rep(n, length.out=length(x))
  sapply(seq_along(x), function(i) substr(x[i], 0, n[i]))
}


StrTrunc <- function(x, maxlen = 20) {

  # original truncString from prettyR
  # author: Jim Lemon

  #   toolong <- nchar(x) > maxlen
  #   maxwidth <- ifelse(toolong, maxlen - 3, maxlen)
  #   chopx <- substr(x, 1, maxwidth)
  #
  #   for(i in 1:length(x)) if(toolong[i]) chopx[i] <- paste(chopx[i], "...", sep="")
  #
  #   return(formatC(chopx, width = maxlen, flag = ifelse(justify == "left", "-", " ")) )

  # ... but this is all a bit clumsy, let's have it shorter:  ;-)

  paste(substr(x, 0, maxlen), ifelse(nchar(x) > maxlen, "...", ""), sep="")
}


StrAbbr <- function(x, minchar=1, method=c("left","fix")){

  switch(match.arg(arg = method, choices = c("left", "fix")),
         "left"={
           idx <- rep(minchar, length(x))-1
           for(i in minchar:max(nchar(x))){
             adup <- AllDuplicated(substr(x, 1, i))
             idx[adup] <- i
           }
           res <- substr(x, 1, idx+1)
         },
         "fix"={
           i <- 1
           while(sum(duplicated(substr(x, 1, i))) > 0) { i <- i+1 }
           res <- substr(x, 1, pmax(minchar, i))
         }
  )
  return(res)
}


StrCap <- function(x) {
  # Source: Hmisc
  # Author: Charles Dupont
  capped <- grep('^[^A-Z]*', x, perl=TRUE)

  substr(x[capped], 1,1) <- toupper(substr(x[capped], 1,1))
  return(x)

}


StrDist <- function (x, y, method = "levenshtein", mismatch = 1, gap = 1){

    # source MKmisc, Author: Matthias Kohl

  if (!is.na(pmatch(method, "levenshtein")))
      method <- "levenshtein"

    METHODS <- c("levenshtein", "hamming")
    method <- pmatch(method, METHODS)

    if (is.na(method))
      stop("invalid distance method")

    if (method == -1)
      stop("ambiguous distance method")

    stopifnot(is.character(x), is.character(y))

    if (length(x) == 1 & nchar(x[1]) > 1)
      x1 <- strsplit(x, split = "")[[1]]
    else
      x1 <- x

    if (length(y) == 1 & nchar(y[1]) > 1)
      y1 <- strsplit(y, split = "")[[1]]
    else
      y1 <- y

    if (method == 1){ ## Levenshtein
      m <- length(x1)
      n <- length(y1)
      D <- matrix(NA, nrow = m+1, ncol = n+1)
      M <- matrix("", nrow = m+1, ncol = n+1)
      D[,1] <- seq_len(m+1)*gap-1
      D[1,] <- seq_len(n+1)*gap-1
      D[1,1] <- 0
      M[,1] <- "d"
      M[1,] <- "i"
      M[1,1] <- "start"
      text <- c("d", "m", "i")
      for(i in c(2:(m+1))){
        for(j in c(2:(n+1))){
          m1 <- D[i-1,j] + gap
          m2 <- D[i-1,j-1] + (x1[i-1] != y1[j-1])*mismatch
          m3 <- D[i,j-1] + gap
          D[i,j] <- min(m1, m2, m3)
          wmin <- text[which(c(m1, m2, m3) == D[i,j])]
          if("m" %in% wmin & x1[i-1] != y1[j-1])
            wmin[wmin == "m"] <- "mm"
          M[i,j] <- paste(wmin, collapse = "/")
        }
      }
      rownames(M) <- rownames(D) <- c("gap", x1)
      colnames(M) <- colnames(D) <- c("gap", y1)
      d <- D[m+1, n+1]
    }
    if(method == 2){ ## Hamming
      if(length(x1) != length(y1))
        stop("Hamming distance is only defined for equal length strings")
      d <- sum(x1 != y1)
      D <- NULL
      M <- NULL
    }
    attr(d, "Size") <- 2
    attr(d, "Diag") <- FALSE
    if(length(x) > 1) x <- paste0("", x, collapse = "")
    if(length(y) > 1) y <- paste0("", y, collapse = "")
    attr(d, "Labels") <- c(x,y)
    attr(d, "Upper") <- FALSE
    attr(d, "method") <- METHODS[method]
    attr(d, "call") <- match.call()
    attr(d, "ScoringMatrix") <- D
    attr(d, "TraceBackMatrix") <- M
    class(d) <- c("stringDist", "dist")

    return(d)
}


StrRev <- function(x) {
  # reverses a string
  sapply(lapply(strsplit(x, NULL), rev), paste, collapse="")
}



StrPad <- function(x, width = NULL, pad = " ", adj = "left") {

  .pad <- function(x, width, pad=" ", adj="left"){

    if(is.na(x)) return(NA)

    mto <- match.arg(adj, c("left", "right", "center"))
    free <- max(0, width - nchar(x))
    fill <- substring(paste(rep(pad, ceiling(free / nchar(pad))), collapse = ""), 1, free)
    #### cat("  free=",free,",  fill=",fill,",  mto=",mto,"\n")
    # old, but chop is not a good idea:  if(free <= 0) substr(x, 1, len)
    if(free <= 0) x
    else if  (mto == "left") paste(x, fill, sep = "")
    else if  (mto == "right") paste(fill, x, sep = "")
    else  paste(substring(fill, 1, free %/% 2), x, substring(fill, 1 + free %/% 2, free), sep = "")
  }

  # adj <- sapply(adj, match.arg, choices=c("left", "right", "center"))

  if(is.null(width)) width <- max(nchar(x))

  lgp <- DescTools::Recycle(x=x, width=width, pad=pad, adj=adj)
  sapply( 1:attr(lgp, "maxdim"), function(i) .pad(lgp$x[i], lgp$width[i], lgp$pad[i], lgp$adj[i]) )

}



StrAlign <- function(x, sep = " ", ...){

  # Pad to same maximal length, for right alignment this is mandatory
  # for left alignment not, but for any point
  x <- StrPad(x, max(nchar(x)))

  # left alignment
  if(sep == "\\^")
    return( sub("(^ +)(.+)", "\\2\\1", x) )

  # right alignment
  if(sep == "\\$")
    return( sub("(.+?)( +$)", "\\2\\1", x) )

  bef <- substr(x, 1, StrPos(x, sep, fix=TRUE))  # use fix = TRUE as otherwise the decimal would be to have entered as \\.
  aft <- substr(x, StrPos(x, sep, fix=TRUE) + 1, nchar(x))
  res <- paste(replace(StrPad(bef, max(nchar(bef)),
                              " ", adj = "right"), is.na(bef), ""),
               replace(StrPad(aft, max(nchar(aft)), " ", adj = "left"), is.na(aft),
                       ""), sep = "")
  res[is.na(x)] <- NA
  res
}



StrChop <- function(x, len) {
  # Splits a string into a number of pieces of fixed length
  # example: StrChop(x=paste(letters, collapse=""), len = c(3,5,0))
  xsplit <- character(0)
  for(i in 1:length(len)){
    xsplit <- append(xsplit, substr(x, 1, len[i]))
    x <- substr(x, len[i]+1, nchar(x))
  }
  return(xsplit)
}


StrCountW <- function(x){
  # old:    does not work for one single word!!
  # return(sapply(gregexpr("\\b\\W+\\b", x, perl=TRUE), length) + 1)
  return(sapply(gregexpr("\\b\\W+\\b", x, perl = TRUE), function(x) sum(x>0)) + 1)
}


StrVal <- function(x, paste = FALSE, as.numeric = FALSE){

  # Problem 20.2.2015: - will not be accepted, when a space is between sign and number
  # not sure if this is really a problem: -> oberserve...
  # StrVal(x="- 2.5", paste = FALSE, as.numeric = FALSE)

  pat <- "[-+.e0-9]*\\d"
  gfound <- gregexpr(pattern=pat, text=x)
  vals <- lapply(seq_along(x), function(i){
    found <- gfound[[i]]
    ml <- attr(found, which="match.length")
    res <- sapply(seq_along(found), function(j) substr(x[i], start=found[j], stop=found[j]+ml[j]-1) )
    return(res)
  })

  if(paste==TRUE) {
    vals <- sapply(vals, paste, collapse="")
    if(as.numeric==TRUE)
      vals <- as.numeric(vals)
  } else {
    if(as.numeric==TRUE)
      vals <- lapply(vals, as.numeric)
  }

  return(vals)

}


StrPos <- function(x, pattern, pos=1, ... ){

# example:
#    StrPos(x=levels(d.pizza$driver), "t", pos=4)

  pos <- rep(pos, length.out=length(x))
  x <- substr(x, start=pos, stop=nchar(x))

  i <- as.vector(regexpr(pattern = pattern, text = x, ...))
  i[i<0] <- NA
  return(i)
}



SplitPath <- function(path, last.is.file=NULL) {

  if(is.null(last.is.file)){
    # if last sign is delimiter / or \ read path as dirname
    last.is.file <- (length(grep(pattern="[/\\]$", path)) == 0)
  }

  path <- normalizePath(path, mustWork = FALSE)

  lst <- list()

  lst$normpath <- path
  if (.Platform$OS.type == "windows") {
    lst$drive <- regmatches(path, regexpr("^([[:alpha:]]:)|(\\\\[[:alnum:]]+)", path))
    lst$dirname <- gsub(pattern=lst$drive, x=dirname(path), replacement="")
  } else {
    lst$drive <- NA
    lst$dirname <- dirname(path)
  }

  lst$dirname <- paste(lst$dirname, "/", sep="")
  lst$fullfilename <- basename(path)

  lst$filename <- strsplit(lst$fullfilename, "\\.")[[1]][1]
  lst$extension <- strsplit(lst$fullfilename, "\\.")[[1]][2]

  if(!last.is.file){
    lst$dirname <- paste(lst$dirname, lst$fullfilename, "/",
                         sep="")
    lst$extension <- lst$filename <- lst$fullfilename <- NA
  }
  return(lst)

}




###

## base: conversion functions ====


CharToAsc <- function(x) {
  # Original from Henrik Bengtsson R.oo:
  # char2asc <- function (ch, ...) { match(ch, ASCII) - 1 }
  # example:  x.char <- char2asc(x="Andri")


  if(length(x) == 1)
    strtoi(charToRaw(x), 16L)
  else
    sapply(x, function(x) strtoi(charToRaw(x), 16L))

}


AscToChar <- function(i) {
# old version:
# example: AscToChar(x.char)
#  ASCII <- intToUtf8(1:256, multiple=TRUE)

  # new and far more elegant
  # ref: http://datadebrief.blogspot.ch/search/label/R
  rawToChar(as.raw(i))

}

HexToDec <- function(x) strtoi(x, 16L)
# example: strtoi(c("9A", "3B"), 16L)
DecToHex <- function(x) as.hexmode(as.numeric(x))

OctToDec <- function(x) strtoi(x, 8L)
# example: strtoi(c("12", "24"), 8L)
DecToOct <- function(x) as.numeric(as.character(as.octmode(as.numeric(x))))

BinToDec <- function(x) {
  # Alternative:  bin2dec <- function(x) { sum(2^.subset((length(x)-1):0, x)) }
  # example: bin2dec(x=as.numeric(unlist(strsplit("1001", split=NULL)))==1)
  strtoi(x, 2L)
}
# example: strtoi(c("100001", "101"), 2L)

# DecToBin <- function (x) {
#   # This would be nice, but does not work: (intToBin from R.utils)
#   # y <- as.integer(x)
#   # class(y) <- "binmode"
#   # y <- as.character(y)
#   # dim(y) <- dim(x)
#   # y
#   as.vector(sapply(x, function(x) as.integer(paste(rev(as.integer(intToBits(x))), collapse=""))))
# }

DecToBin <- function (x) {
  z <- .Call("DescTools_conv_DecToBin", PACKAGE = "DescTools", x)
  z[x > 536870911] <- NA
  return(sub("^0+", "", z))
}


# void dec_to_bin(int number) {
#   int remainder;
#
#   if(number <= 1) {
#     cout << number;
#     return;
#   }
#
#   remainder = number%2;
#   dec_to_bin(number >> 1);
#   cout << remainder;
# }

# DecToBinC <- function(x){
#   z <- .C("dec_to_bin", x = as.integer(x))
#   return(z)
# }


DegToRad <- function(deg) deg * pi /180

RadToDeg <- function(rad) rad * 180 / pi



UnitConv <- function(x, from_unit, to_unit){

  if(from_unit == "C") {
    if(to_unit=="F") return(x *1.8+32)
  }
  if(from_unit == "F") {
    if(to_unit=="C") return((x -32) *5/9)
  }

  fact <- d.units[d.units$from == from_unit & d.units$to==to_unit, "fact"]
  if(length(fact)==0) fact <- NA

  return(x * fact)

}


DoCall <- function (what, args, quote = FALSE, envir = parent.frame())  {

  # source: Gmisc
  # author: Max Gordon <max@gforge.se>

  if (quote)
    args <- lapply(args, enquote)
  if (is.null(names(args)) || is.data.frame(args)) {
    argn <- args
    args <- list()
  }
  else {
    argn <- lapply(names(args)[names(args) != ""], as.name)
    names(argn) <- names(args)[names(args) != ""]
    argn <- c(argn, args[names(args) == ""])
    args <- args[names(args) != ""]
  }
  if (class(what) == "character") {
    if (is.character(what)) {
      fn <- strsplit(what, "[:]{2,3}")[[1]]
      what <- if (length(fn) == 1) {
        get(fn[[1]], envir = envir, mode = "function")
      }
      else {
        get(fn[[2]], envir = asNamespace(fn[[1]]), mode = "function")
      }
    }
    call <- as.call(c(list(what), argn))
  }
  else if (class(what) == "function") {
    f_name <- deparse(substitute(what))
    call <- as.call(c(list(as.name(f_name)), argn))
    args[[f_name]] <- what
  }
  else if (class(what) == "name") {
    call <- as.call(c(list(what, argn)))
  }
  eval(call, envir = args, enclos = envir)
}

###

## base: transformation functions ====

as.matrix.xtabs <- function(x, ...){

  # xtabs would not be converted by as.matrix.default...

  attr(x, "class") <- NULL
  attr(x, "call") <- NULL

  return(x)

}


TextToTable <- function(x, dimnames = NULL, ...){

  d.frm <- read.table(text=x, ...)
  tab <- as.table(as.matrix(d.frm))
  if(!is.null(dimnames)) names(dimnames(tab)) <- dimnames

  return(tab)

}


Recode <- function(x, newlevels, elselevel=NA, use.empty=FALSE){

  if( sum(duplicated(unlist(newlevels))) > 0) stop ("!Recode! newlevels contain non unique values!")

  if(is.null(elselevel)) { # leave elselevels as they are
    elselevels <- setdiff(levels(x), unlist(newlevels))
    names(elselevels) <- elselevels
    newlevels <- c(newlevels, elselevels)
  } else {
    if(!is.na(elselevel)){
      newlevels[[length(newlevels)+1]] <- setdiff(levels(x), unlist(newlevels))
      names(newlevels)[[length(newlevels)]] <- elselevel
    }
  }
  levels(x) <- newlevels
  if(!use.empty) x <- factor(x)  # delete potentially empty levels
  return(x)
}



ZeroIfNA <- function(x) {
#  same as zeroifnull in SQL
  replace(x, is.na(x), 0)
}


Impute <- function(x, FUN = function(x) median(x, na.rm=TRUE)) {

  if(is.function(FUN)) {
    #  if FUN is a function, then save it under new name and
    # overwrite function name in FUN, which has to be character
    fct <- FUN
    FUN <- "fct"
    FUN <- gettextf("%s(x)", FUN)
  }
  # Calculates the mean absolute deviation from the sample mean.
  return(eval(parse(text = gettextf("replace(x, is.na(x), %s)", FUN))))

}



reorder.factor <- function(x, X, FUN, ..., order = is.ordered(x), new.order,
                           sort = SortMixed) {

  # $Id: reorder.R 988 2006-10-29 12:55:08Z ggorjan $
  # Reorder the levels of a factor.

  constructor <- if (order) ordered else factor

  if (!missing(new.order))  {

    if (is.numeric(new.order))
      new.order <- levels(x)[new.order]
    else
      new.order <- new.order

  } else if (!missing(FUN))
    new.order <- names(sort(tapply(X, x, FUN, ...)))

  else
    new.order <- sort(levels(x))

  constructor(x, levels=new.order)

}



SortMixed <- function(x) x[OrderMixed(x)]

OrderMixed <- function(x) {
# $Id: SortMixed.R 1774 2014-03-01 20:02:08Z warnes $

  # - Split each each character string into an vector of strings and
  #   numbers
  # - Separately rank numbers and strings
  # - Combine orders so that strings follow numbers

  if(length(x)<1)
    return(NULL)
  else if(length(x)==1)
    return(1)

  if( is.numeric(x) )
    return( order(x) )


  delim="\\$\\@\\$"

  numeric <- function(x) {
    suppressWarnings( as.numeric(x) )
  }

  nonnumeric <- function(x) {
    suppressWarnings( ifelse(is.na(as.numeric(x)), toupper(x), NA) )
  }

  x <- as.character(x)

  which.nas <- which(is.na(x))
  which.blanks <- which(x=="")

  if(length(which.blanks) >0)
    x[ which.blanks ] <- -Inf

  if(length(which.nas) >0)
    x[ which.nas ] <- Inf

  ####
  # - Convert each character string into an vector containing single
  #   character and  numeric values.
  ####

  # find and mark numbers in the form of +1.23e+45.67
  delimited <- gsub("([+-]{0,1}[0-9]+\\.{0,1}[0-9]*([eE][\\+\\-]{0,1}[0-9]+\\.{0,1}[0-9]*){0,1})",
                    paste(delim,"\\1",delim,sep=""), x)

  # separate out numbers
  step1 <- strsplit(delimited, delim)

  # remove empty elements
  step1 <- lapply( step1, function(x) x[x>""] )

  # create numeric version of data
  step1.numeric <- lapply( step1, numeric )

  # create non-numeric version of data
  step1.character <- lapply( step1, nonnumeric )

  # now transpose so that 1st vector contains 1st element from each
  # original string
  maxelem <- max(sapply(step1, length))

  step1.numeric.t <- lapply(1:maxelem,
                            function(i)
                              sapply(step1.numeric,
                                     function(x)x[i])
  )

  step1.character.t <- lapply(1:maxelem,
                              function(i)
                                sapply(step1.character,
                                       function(x)x[i])
  )

  # now order them
  rank.numeric   <- sapply(step1.numeric.t,rank)
  rank.character <- sapply(step1.character.t,
                           function(x) as.numeric(factor(x)))

  # and merge
  rank.numeric[!is.na(rank.character)] <- 0  # mask off string values

  rank.character <- t(
    t(rank.character) +
      apply(matrix(rank.numeric),2,max,na.rm=TRUE)
  )

  rank.overall <- ifelse(is.na(rank.character),rank.numeric,rank.character)

  order.frame <- as.data.frame(rank.overall)
  if(length(which.nas) > 0)
    order.frame[which.nas,] <- Inf
  retval <- do.call("order",order.frame)

  return(retval)

}





# StahelLogC <- function(x, na.rm=FALSE) {
#   if(na.rm) x <- na.omit(x)
#   ### muessen die 0-Werte hier weggelassen werden??
#   x <- x[x>0]
#   ### additive Konstante fuer die Logarithmierung nach Stahel "...es hat sich gezeigt, dass..."
#   return(as.vector(median(x) / (median(x)/quantile(x, 0.25))^2.9))
# }

# http://support.sas.com/documentation/cdl/en/statugfreq/63124/PDF/default/statugfreq.pdf

LogSt <- function(x, calib = x, threshold = NULL, mult = 1) {

# original function logst in source regr
#
#   # Purpose:   logs of x, zeros and small values treated well
#   # *********************************************************************
#   # Author: Werner Stahel, Date:  3 Nov 2001, 08:22
#   x <- cbind(x)
#   calib <- cbind(calib)
#   lncol <- ncol(calib)
#   ljthr <- length(threshold) > 0
#   if (ljthr) {
#     if (!length(threshold) %in% c(1, lncol))
#       stop("!LogSt! length of argument 'threshold' is inadequate")
#     lthr <- rep(threshold, length=lncol)
#     ljdt <- !is.na(lthr)
#   } else {
#     ljdt <- rep(TRUE, lncol)
#     lthr <- rep(NA, lncol)
#     for (lj in 1:lncol) {
#       lcal <- calib[, lj]
#       ldp <- lcal[lcal > 0 & !is.na(lcal)]
#       if(length(ldp) == 0) ljdt[lj] <- FALSE else {
#         lq <- quantile(ldp,probs = c(0.25,0.75), na.rm = TRUE)
#         if(lq[1] == lq[2]) lq[1] <- lq[2]/2
#         lthr[lj] <- lc <- lq[1]^(1 + mult) / lq[2]^mult
#       }
#     }
#   }
#   # transform x
#   for (lj in 1:lncol) {
#     ldt <- x[,lj]
#     lc <- lthr[lj]
#     li <- which(ldt < lc)
#     if (length(li))
#       ldt[li] <- lc * 10^((ldt[li] - lc) / (lc * log(10)))
#     x[,lj] <- log10(ldt)
#   }
#   if (length(colnames(x)))
#     lnmpd <- names(ljdt) <- names(lthr) <- colnames(x)  else
#     lnmpd <- as.character(1:lncol)
#
#   attr(x,"threshold") <- c(lthr)
#
#   if (any(!ljdt)) {
#     warning(':LogSt: no positive x for variables',lnmpd[!ljdt],
#             '. These are not transformed')
#     attr(x,"untransformed") <- c(ljdt)
#   }
#   x


  if(is.null(threshold)){
    lq <- quantile(calib[calib > 0], probs = c(0.25, 0.75), na.rm = TRUE)
    if (lq[1] == lq[2]) lq[1] <- lq[2]/2
    threshold <- lq[1]^(1 + mult)/lq[2]^mult
  }

  res <- rep(NA, length(x))
  idx <- (x < threshold)
  idx.na <- is.na(idx)
  res[idx & !idx.na] <- log10(threshold) + ((x[idx & !idx.na] - threshold)/(threshold * log(10)))
  res[!idx & !idx.na] <- log10(x[!idx & !idx.na])

  attr(res, "threshold") <- threshold
  return(res)

}


LogStInv <- function (x, threshold = NULL) {

  if(is.null(threshold)) threshold <- attr(x, "threshold")

  res <- rep(NA, length(x))
  idx <- (x < log10(threshold))
  idx.na <- is.na(idx)
  res[idx & !idx.na] <- threshold - threshold * log(10) *( log10(threshold) - x[idx & !idx.na])
  res[!idx & !idx.na] <- 10^(x[!idx & !idx.na])

  return(res)

}



# Variance stabilizing functions
# log(x+a)
# log(x+a, base=10)
# sqrt(x+a)
# 1/x
# arcsinh(x)

LogGen <- function(x, a) { return( log((x + sqrt(x^2 + a^2)) / 2)) }


LogLin <- function(x, a) {
  # log-linear hybrid transformation
  # introduced by Rocke and Durbin (2003)
  x[x<=a] <- x[x<=a] / a + log(a) - 1
  x[x>a] <- log(x[x>a])

  return(x)
}


Logit <- function(x, min=0, max=1) {

  # variant in boot:::logit - CHECKME if better ********
    p <- (x-min)/(max-min)
    log(p/(1-p))
}


LogitInv <- function(x, min=0, max=1) {

    p <- exp(x)/(1+exp(x))
    p <- ifelse( is.na(p) & !is.na(x), 1, p ) # fix problems with +Inf
    p * (max-min) + min
}



# from library(forecast)

BoxCox <- function (x, lambda) {

# Author: Rob J Hyndman
# origin: library(forecast)
    if (lambda < 0)
        x[x < 0] <- NA
    if (lambda == 0)
        out <- log(x)
    else out <- (sign(x) * abs(x)^lambda - 1)/lambda
    if (!is.null(colnames(x)))
        colnames(out) <- colnames(x)
    return(out)

# Greg Snow's Variant
# BoxCox <- function (x, lambda)
# {
# ### Author: Greg Snow
# ### Source: Teaching Demos
# xx <- exp(mean(log(x)))
# if (lambda == 0)
# return(log(x) * xx)
# res <- (x^lambda - 1)/(lambda * xx^(lambda - 1))
# return(res)
# }

}


BoxCoxInv <- function(x, lambda){
    if (lambda < 0)
        x[x > -1/lambda] <- NA
    if (lambda == 0)
        out <- exp(x)
    else {
        xx <- x * lambda + 1
        out <- sign(xx) * abs(xx)^(1/lambda)
    }
    if (!is.null(colnames(x)))
        colnames(out) <- colnames(x)
    return(out)
}


# This R script contains code for extracting the Box-Cox
# parameter, lambda, using Guerrero's method (1993).
# Written by Leanne Chhay

BoxCoxLambda <- function(x, method=c("guerrero","loglik"), lower=-1, upper=2) {

  # Guerrero extracts the required lambda
  # Input: x = original time series as a time series object
  # Output: lambda that minimises the coefficient of variation

  Guerrero <- function(x, lower=-1, upper=2, nonseasonal.length=2)  {

    # guer.cv computes the coefficient of variation
    # Input:
    #             lam = lambda
    #             x = original time series as a time series object
    # Output: coefficient of variation
    guer.cv <- function(lam, x, nonseasonal.length=2)
    {
      period <- max(nonseasonal.length, frequency(x))
      nobsf <- length(x)
      nyr <- floor(nobsf / period)
      nobst <- nyr * period
      x.mat <- matrix(x[(nobsf-nobst+1):nobsf], period, nyr)
      x.mean <- apply(x.mat, 2, mean, na.rm=TRUE)
      x.sd <- apply(x.mat, 2, sd, na.rm=TRUE)
      x.rat <- x.sd / x.mean^(1-lam)
      return(sd(x.rat, na.rm=TRUE)/mean(x.rat, na.rm=TRUE))
    }

    return(optimize(guer.cv, c(lower,upper), x=x,
              nonseasonal.length=nonseasonal.length)$minimum)
  }


  # Modified version of boxcox from MASS package
  BCLogLik <- function(x, lower=-1, upper=2)
  {
    n <- length(x)
    if (any(x <= 0))
      stop("x must be positive")
    logx <- log(x)
    xdot <- exp(mean(logx))
#    if(all(class(x)!="ts"))
      fit <- lm(x ~ 1, data=data.frame(x=x))
#     else if(frequency(x)>1)
#       fit <- tslm(x ~ trend + season, data=data.frame(x=x))
#     else
#       fit <- tslm(x ~ trend, data=data.frame(x=x))
    xqr <- fit$qr
    lambda <- seq(lower,upper,by=.05)
    xl <- loglik <- as.vector(lambda)
    m <- length(xl)
    for (i in 1L:m)
    {
      if (abs(la <- xl[i]) > 0.02)
        xt <- (x^la - 1)/la
      else
        xt <- logx * (1 + (la*logx)/2 * (1+(la*logx)/3*(1+(la*logx)/4)))
      loglik[i] <- -n/2 * log(sum(qr.resid(xqr, xt/xdot^(la-1))^2))
    }
    return(xl[which.max(loglik)])
  }


  if(any(x <= 0))
                lower <- 0
#   stop("All values must be positive")
  method <- match.arg(method)
  if(method=="loglik")
    return(BCLogLik(x,lower,upper))
  else
    return(Guerrero(x,lower,upper))
}




LOCF <- function(x) UseMethod("LOCF")


LOCF.default <- function(x) {

  # last observation carried forward
  # replaces NAs by the last observed value

#   while(any(is.na(x))) {
#     x[is.na(x)] <- x[which(is.na(x))-1]
#   }
#   return(x)

  # faster solution from Daniel Wollschlaeger:
  rep(x[!is.na(x)], diff(c(which(!is.na(x)), length(x)+1)))

}

LOCF.data.frame <- function(x){
  as.data.frame(lapply(x, LOCF))
}

LOCF.matrix <- function(x){
  apply(x, 2, LOCF)
}

# Alternative names: PairApply, PwApply, pwapply, papply, ...
PairApply <- function(x, FUN = NULL, ..., symmetric = FALSE){

  if(is.function(FUN)) {
    # if FUN is a function, then save it under new name and
    # overwrite function name in FUN, which has to be character
    fct <- FUN
    FUN <- "fct"
  }

  if(is.matrix(x)) x <- as.data.frame(x)
  x <- as.list(x)

  ix <- 1:length(x)
  # pairwise logic from pairwise.table
  pp <- outer(ix, ix, function(ivec, jvec) sapply(seq_along(ivec),
                                                  function(k) {
                                                    i <- ivec[[k]]
                                                    j <- jvec[[k]]
                                                    if (i > j)
                                                      eval(parse(text = gettextf("%s(x[[i]], x[[j]], ...)", FUN)))
                                                    else NA
                                                  }))
  diag(pp) <- 1
  if(symmetric){
    pp[upper.tri(pp)] <- t(pp)[upper.tri(t(pp))]
  } else {
    pp.upr <- outer(ix, ix, function(ivec, jvec) sapply(seq_along(ivec),
                                                        function(k) {
                                                          i <- ivec[[k]]
                                                          j <- jvec[[k]]
                                                          if (i > j)
                                                            eval(parse(text = gettextf("%s(x[[j]], x[[i]], ...)", FUN)))
                                                          else NA
                                                        }))
    pp[upper.tri(pp)] <- t(pp.upr)[upper.tri(pp.upr)]

  }

  dimnames(pp) <- list(names(x),names(x))

  return(pp)
}




###

## base: date functions  ====

# fastPOSIXct <- function(x, tz=NULL, required.components = 3L)
#   .POSIXct(if (is.character(x)) .Call("parse_ts", x, required.components) else .Call("parse_ts", as.character(x), required.components), tz)


HmsToSec <- function(x) {

  hms <- as.character(x)
  z <- sapply(data.frame(do.call(rbind, strsplit(hms, ":"))),
              function(x) { as.numeric(as.character(x)) })
  z[,1] * 3600 + z[,2] * 60 + z[,3]
}



SecToHms <- function(x, digits=NULL) {

  x <- as.numeric(x)

  h <- floor(x/3600)
  m <- floor((x-h*3600)/60)
  s <- floor(x-(m*60 + h*3600))
  b <- x-(s + m*60 + h*3600)

  if(is.null(digits)) digits <- ifelse(all(b < .Machine$double.eps^0.5),0, 2)
  if(digits==0) f <- "" else f <- gettextf(paste(".%0", digits, "d", sep=""), round(b*10^digits, 0))

  gettextf("%02d:%02d:%02d%s", h, m, s, f)

}



IsDate <- function(x, what=c('either','both','timeVaries')) {

  what <- match.arg(what)
  cl <- class(x) # was oldClass 22jun03
  if(!length(cl)) return(FALSE)

  dc <- c('POSIXt','POSIXct','dates','times','chron','Date')
  dtc <- c('POSIXt','POSIXct','chron')
  switch(what,
    either = any(cl %in% dc),
    both = any(cl %in% dtc),
    timeVaries = {
      # original: if('chron' %in% cl || !.R.) { ### chron or S+ timeDate
      if('chron' %in% cl) { # chron ok, but who cares about S+?
        y <- as.numeric(x)
        length(unique(round(y - floor(y),13))) > 1
      } else {
        length(unique(format(x, '%H%M%S'))) > 1
      }
    }
  )

}


IsWeekend <- function(x) {
  x <- as.POSIXlt(x)
  x$wday > 5 | x$wday < 1
}


Date <- function(year, month = NA, day = NA) {
  if(is.na(month) && is.na(day)) {
    # try to interpret year as yearmonthday yyyymmdd
    res <- as.Date(ISOdate(year %/% 10000, (year %% 10000) %/% 100, (year %% 100)))
  } else {
    res <- as.Date(ISOdate(year, month, day))
  }
  return(res)
}

# Year <- function(x){ as.integer( format(as.Date(x), "%Y") ) }
Year <- function(x){ as.POSIXlt(x)$year + 1900 }


IsLeapYear <- function(x){
  x <- Year(as.Date(x))
  ifelse(x %% 100 == 0, x %% 400 == 0, x %% 4 == 0)
}


Month <- function (x, fmt = c("m", "mm", "mmm"), lang = c("local", "engl"), stringsAsFactors = TRUE) {

  res <- as.POSIXlt(x)$mon + 1

  switch(match.arg(arg = fmt, choices = c("m", "mm", "mmm")),
         m = { res },
         mm = {
           # res <- as.integer(format(x, "%m"))
           switch(match.arg(arg = lang, choices = c("local", "engl")),
             local = {
               # months in current locale:  format(ISOdate(2000, 1:12, 1), "%b")
               res <- factor(res, levels=1:12, labels=format(ISOdate(2000, 1:12, 1), "%b"))
               },
             engl = {
               res <- factor(res, levels=1:12, labels=month.abb)
             })
           if(!stringsAsFactors) res <- as.character(res)
         },
         mmm = {
           # res <- as.integer(format(x, "%m"))
           switch(match.arg(arg = lang, choices = c("local", "engl")),
                  local = {
                    # months in current locale:  format(ISOdate(2000, 1:12, 1), "%b")
                    res <- factor(res, levels=1:12, labels=format(ISOdate(2000, 1:12, 1), "%B"))
                  },
                  engl = {
                    res <- factor(res, levels=1:12, labels=month.name)
                  })
           if(!stringsAsFactors) res <- as.character(res)
         })
  return(res)
}


Week <- function(x, method = c("iso", "us")){

  # cast x to date, such as being able to handle POSIX-Dates automatically
  x <- as.Date(x)

  method <- match.arg(method, c("iso", "us"))
  switch(method,
    "iso" = {

#??? fast implementation in lubridate:

#       xday <- ISOdate(year(x), month(x), day(x), tz = tz(x))
#       dn <- 1 + (wday(x) + 5)%%7
#       nth <- xday + ddays(4 - dn)
#       jan1 <- ISOdate(year(nth), 1, 1, tz = tz(x))
#       1 + (nth - jan1)%/%ddays(7)


      # The weeknumber is the number of weeks between the
      # first thursday of the year and the thursday in the target week
      # der Donnerstag in der Zielwoche
#       x.y <- Year(x)
#       x.weekday <- Weekday(x)
#
#       x.thursday <- (x - x.weekday + 4)
#       # der erste Donnerstag des Jahres
#       jan1.weekday <- Weekday(as.Date(paste(x.y, "01-01", sep="-")))
#       first.thursday <- as.Date(paste(x.y, "01", (5 + 7*(jan1.weekday > 4) - jan1.weekday), sep="-"))
#
#       wn <- (as.integer(x.thursday - first.thursday) %/% 7) + 1 - ((x.weekday < 4) & (Year(x.thursday) != Year(first.thursday)))*52
#       wn <- ifelse(wn == 0, Week(as.Date(paste(x.y-1, "12-31", sep="-"))), wn)

      z <- x + (3 - (as.POSIXlt(x)$wday + 6) %% 7)
      # jan1 <- as.Date(gettextf("%s-01-01", Year(z)))
      jan1 <- as.Date(paste(Year(z), "-01-01", sep=""))

      wn <- 1 + as.integer(z - jan1) %/% 7

    },
    "us"={
      wn <- as.numeric(strftime(as.POSIXlt(x), format="%W"))
    }
  )
  return(wn)

}


# Day <- function(x){ as.integer(format(as.Date(x), "%d") ) }
Day <- function(x){ as.POSIXlt(x)$mday }


# Accessor for Day, as defined by library(lubridate)
"Day<-" <- function(x, value) { x <- x + (value - Day(x)) }

Weekday <- function (x, fmt = c("d", "dd", "ddd"), lang = c("local", "engl"), stringsAsFactors = TRUE) {

  # x <- as.Date(x)
  res <- as.POSIXlt(x)$wday
  res <- replace(res, res==0, 7)

  switch(match.arg(arg = fmt, choices = c("d", "dd", "ddd")),
         d = { res },
         dd = {
           # weekdays in current locale, Sunday : Saturday, format(ISOdate(2000, 1, 2:8), "%A")
           switch(match.arg(arg = lang, choices = c("local", "engl")),
                  local = {
                    # months in current locale:  format(ISOdate(2000, 1:12, 1), "%b")
                    res <- factor(res, levels=1:7, labels=format(ISOdate(2000, 1, 3:9), "%a"))
                  },
                  engl = {
                    res <- factor(res, levels=1:7, labels=day.abb)
                  })
           if(!stringsAsFactors) res <- as.character(res)
         },
         ddd = {
           # weekdays in current locale, Sunday : Saturday, format(ISOdate(2000, 1, 2:8), "%A")
           switch(match.arg(arg = lang, choices = c("local", "engl")),
                  local = {
                    # months in current locale:  format(ISOdate(2000, 1:12, 1), "%b")
                    res <- factor(res, levels=1:7, labels=format(ISOdate(2000, 1, 3:9), "%A"))
                  },
                  engl = {
                    res <- factor(res, levels=1:7, labels=day.name)
                  })
           if(!stringsAsFactors) res <- as.character(res)
         })
  return(res)
}


Quarter <- function (x) {
  # Berechnet das Quartal eines Datums
  # y <- as.numeric( format( x, "%Y") )
  # paste(y, "Q", (as.POSIXlt(x)$mon)%/%3 + 1, sep = "")
  # old definition is counterintuitive...
  return((as.POSIXlt(x)$mon) %/% 3 + 1)
}

YearDay <- function(x) {
  # return(as.integer(format(as.Date(x), "%j")))
  as.POSIXlt(x)$yday
}


YearMonth <- function(x){
  # returns the yearmonth representation of a date x
  x <- as.POSIXlt(x)
  return((x$year + 1900)*100 + x$mon + 1)
}


Today <- function() Sys.Date()

Now <- function() Sys.time()

Hour <- function(x) {
  # strptime(x, "%H")
  as.POSIXlt(x)$hour
}

Minute <- function(x) {
#  strptime(x, "%M")
  as.POSIXlt(x)$min
}

Second <- function(x) {
#  strptime(x, "%S")
  as.POSIXlt(x)$sec
}


DiffDays360 <- function(start_d, end_d, method=c("eu","us")){

  # source: http://en.wikipedia.org/wiki/360-day_calendar
  start_d <- as.Date(start_d)
  end_d <- as.Date(end_d)

  d1 <- Day(start_d)
  m1 <- Month(start_d)
  y1 <- Year(start_d)
  d2 <- Day(end_d)
  m2 <- Month(end_d)
  y2 <- Year(end_d)

  method = match.arg(method)
  switch(method,
    "eu" = {
      if(Day(start_d)==31) start_d <- start_d-1
      if(Day(end_d)==31) end_d <- end_d-1
    }
    , "us" ={
      if( (Day(start_d+1)==1 & Month(start_d+1)==3) &
            (Day(end_d+1)==1 & Month(end_d+1)==3)) d2 <- 30
      if( d1==31 ||
            (Day(start_d+1)==1 & Month(start_d+1)==3)) {
          d1 <- 30
          if(d2==31) d2 <- 30
      }

    }
  )

  return( (y2-y1)*360 + (m2-m1)*30 + d2-d1)

}


LastDayOfMonth <- function(x){
  z <- AddMonths(x, 1)
  Day(z) <- 1
  return(z-1)
}


AddMonths <- function (x, n, ceiling = TRUE) {

  if (IsDate(x)) {
    # ref: http://stackoverflow.com/questions/14169620/add-a-month-to-a-date
    # Author: Antonio

    # no ceiling
    res <- sapply(x, seq, by = paste(n, "months"), length = 2)[2,]
    # sapply kills the Date class, so recreate here
    class(res) <- class(x)

    #ceiling
    DescTools::Day(x) <- 1
    res_c <- sapply(x, seq, by = paste(n + 1, "months"), length = 2)[2,] - 1
    class(res_c) <- class(x)

    #use ceiling in case of overlapping
    res <- pmin(res, res_c)
  }
  else if (all(DescTools::IsWhole(x))) {
    res <- sapply(x, function(i){
      if (i %[]% c(100001, 999912)) {
        # Author: Roland Rapold
        # YYYYMM
        y <- i%/%100
        m <- i - y * 100
        res <- (y - 10 + ((m + n + 120 - 1)%/%12)) * 100 +
          ((m + n + 120 - 1)%%12) + 1
      }
      else if (i %[]% c(10000101, 99991231)) {
        # YYYYMMDD
        res <- DescTools::AddMonths(x = as.Date(as.character(i), "%Y%m%d"), n = n, ceiling = ceiling)
        res <- DescTools::Year(res)*10000 + DescTools::Month(res)*100 + Day(res)
      }
      return(res)
    })
  }
  else {
    res <- NA
  }
  return(res)

}


Zodiac <- function(x, lang = c("engl","deu"), stringsAsFactors = TRUE) {

  switch(match.arg(lang, choices=c("engl","deu"))
    , engl = {z <- c("Capricorn","Aquarius","Pisces","Aries","Taurus","Gemini","Cancer","Leo","Virgo","Libra","Scorpio","Sagittarius","Capricorn") }
    , deu =  {z <- c("Steinbock","Wassermann","Fische","Widder","Stier","Zwillinge","Krebs","Loewe","Jungfrau","Waage","Skorpion","Schuetze","Steinbock") }
  )

  i <- cut(DescTools::Month(x)*100 + DescTools::Day(x), breaks=c(0,120,218,320,420,520,621,722,822,923,1023,1122,1221,1231))
  if(stringsAsFactors){
    res <- i
    levels(res) <- z
  } else {
    res <- z[i]
  }
  return(res)
}


axTicks.POSIXct <- function (side, x, at, format, labels = TRUE, ...) {

  # This is completely original R-code with one exception:
  # Not an axis is drawn but z are returned.

  mat <- missing(at) || is.null(at)
  if (!mat)
    x <- as.POSIXct(at)
  else x <- as.POSIXct(x)
  range <- par("usr")[if (side%%2)
    1L:2L
    else 3L:4L]
  d <- range[2L] - range[1L]
  z <- c(range, x[is.finite(x)])
  attr(z, "tzone") <- attr(x, "tzone")
  if (d < 1.1 * 60) {
    sc <- 1
    if (missing(format))
      format <- "%S"
  }
  else if (d < 1.1 * 60 * 60) {
    sc <- 60
    if (missing(format))
      format <- "%M:%S"
  }
  else if (d < 1.1 * 60 * 60 * 24) {
    sc <- 60 * 60
    if (missing(format))
      format <- "%H:%M"
  }
  else if (d < 2 * 60 * 60 * 24) {
    sc <- 60 * 60
    if (missing(format))
      format <- "%a %H:%M"
  }
  else if (d < 7 * 60 * 60 * 24) {
    sc <- 60 * 60 * 24
    if (missing(format))
      format <- "%a"
  }
  else {
    sc <- 60 * 60 * 24
  }
  if (d < 60 * 60 * 24 * 50) {
    zz <- pretty(z/sc)
    z <- zz * sc
    z <- .POSIXct(z, attr(x, "tzone"))
    if (sc == 60 * 60 * 24)
      z <- as.POSIXct(round(z, "days"))
    if (missing(format))
      format <- "%b %d"
  }
  else if (d < 1.1 * 60 * 60 * 24 * 365) {
    z <- .POSIXct(z, attr(x, "tzone"))
    zz <- as.POSIXlt(z)
    zz$mday <- zz$wday <- zz$yday <- 1
    zz$isdst <- -1
    zz$hour <- zz$min <- zz$sec <- 0
    zz$mon <- pretty(zz$mon)
    m <- length(zz$mon)
    M <- 2 * m
    m <- rep.int(zz$year[1L], m)
    zz$year <- c(m, m + 1)
    zz <- lapply(zz, function(x) rep(x, length.out = M))
    zz <- .POSIXlt(zz, attr(x, "tzone"))
    z <- as.POSIXct(zz)
    if (missing(format))
      format <- "%b"
  }
  else {
    z <- .POSIXct(z, attr(x, "tzone"))
    zz <- as.POSIXlt(z)
    zz$mday <- zz$wday <- zz$yday <- 1
    zz$isdst <- -1
    zz$mon <- zz$hour <- zz$min <- zz$sec <- 0
    zz$year <- pretty(zz$year)
    M <- length(zz$year)
    zz <- lapply(zz, function(x) rep(x, length.out = M))
    z <- as.POSIXct(.POSIXlt(zz))
    if (missing(format))
      format <- "%Y"
  }
  if (!mat)
    z <- x[is.finite(x)]
  keep <- z >= range[1L] & z <= range[2L]
  z <- z[keep]
  if (!is.logical(labels))
    labels <- labels[keep]
  else if (identical(labels, TRUE))
    labels <- format(z, format = format)
  else if (identical(labels, FALSE))
    labels <- rep("", length(z))

  # axis(side, at = z, labels = labels, ...)
  # return(list(at=z, labels=labels))
  return(z)
}

###

## base: information functions ====

# Between operators

`%[]%` <- function(x, rng) {

  if(is.matrix(rng)){
    # recycle things
    # which parameter has the highest dimension
    maxdim <- max(length(x), nrow(rng))
    # recycle all params to maxdim
    x <- rep(x, length.out = maxdim)
    # the rows of the matrix rng
    rng <- rng[rep(1:nrow(rng), length.out = maxdim),]

    res <- .Call("between_num_lrm", as.numeric(x), as.numeric(rng[,1]), as.numeric(rng[,2]), PACKAGE="DescTools")
    res[is.na(x)] <- NA

    return( res)

  }

  if(is.numeric(x)) {
    # as.numeric still needed for casting integer to numeric!!
    res <- .Call("between_num_lr", as.numeric(x), as.numeric(rng[1]), as.numeric(rng[2]), PACKAGE="DescTools")
    res[is.na(x)] <- NA
  } else if(is.ordered(x)) {
    res <- .Call("between_num_lr", as.numeric(x), as.numeric(match(rng[1], levels(x))), as.numeric(match(rng[2], levels(x))), PACKAGE="DescTools")
    res[is.na(x)] <- NA
  }  else if(class(x) == "character")  {
    res <- ifelse ( x >= rng[1] & x <= rng[2], TRUE, FALSE )
  } else {
    res <- rep(NA, length(x))
  }
  return(res)
}


`%(]%` <- function(x, rng) {

  if(is.matrix(rng)){
    # recycle things
    # which parameter has the highest dimension
    maxdim <- max(length(x), nrow(rng))
    # recycle all params to maxdim
    x <- rep(x, length.out = maxdim)
    # the rows of the matrix rng
    rng <- rng[rep(1:nrow(rng), length.out = maxdim),]

    res <- .Call("between_num_rm", as.numeric(x), as.numeric(rng[,1]), as.numeric(rng[,2]), PACKAGE="DescTools")
    res[is.na(x)] <- NA

    return( res)

  }

  if(is.numeric(x)) {
    # as.numeric still needed for casting integer to numeric!!
    res <- .Call("between_num_r", as.numeric(x), as.numeric(rng[1]), as.numeric(rng[2]), PACKAGE="DescTools")
    res[is.na(x)] <- NA
  } else if(is.ordered(x)) {
    res <- .Call("between_num_r", as.numeric(x), as.numeric(match(rng[1], levels(x))), as.numeric(match(rng[2], levels(x))), PACKAGE="DescTools")
    res[is.na(x)] <- NA
  }  else if(class(x) == "character")  {
    res <- ifelse ( x > rng[1] & x <= rng[2], TRUE, FALSE )
  } else {
    res <- rep(NA, length(x))
  }
  return(res)
}

`%[)%` <- function(x, rng) {

  if(is.matrix(rng)){
    # recycle things
    # which parameter has the highest dimension
    maxdim <- max(length(x), nrow(rng))
    # recycle all params to maxdim
    x <- rep(x, length.out = maxdim)
    # the rows of the matrix rng
    rng <- rng[rep(1:nrow(rng), length.out = maxdim),]

    res <- .Call("between_num_lm", as.numeric(x), as.numeric(rng[,1]), as.numeric(rng[,2]), PACKAGE="DescTools")
    res[is.na(x)] <- NA

    return( res)

  }

  if(is.numeric(x)) {
    # as.numeric still needed for casting integer to numeric!!
    res <- .Call("between_num_l", as.numeric(x), as.numeric(rng[1]), as.numeric(rng[2]), PACKAGE="DescTools")
    res[is.na(x)] <- NA
  } else if(is.ordered(x)) {
    res <- .Call("between_num_l", as.numeric(x), as.numeric(match(rng[1], levels(x))), as.numeric(match(rng[2], levels(x))), PACKAGE="DescTools")
    res[is.na(x)] <- NA
  }  else if(class(x) == "character")  {
    res <- ifelse ( x >= rng[1] & x < rng[2], TRUE, FALSE )
  } else {
    res <- rep(NA, length(x))
  }
  return(res)
}


`%()%` <- function(x, rng) {

  if(is.matrix(rng)){
    # recycle things
    # which parameter has the highest dimension
    maxdim <- max(length(x), nrow(rng))
    # recycle all params to maxdim
    x <- rep(x, length.out = maxdim)
    # the rows of the matrix rng
    rng <- rng[rep(1:nrow(rng), length.out = maxdim),]

    res <- .Call("between_num_m", as.numeric(x), as.numeric(rng[,1]), as.numeric(rng[,2]), PACKAGE="DescTools")
    res[is.na(x)] <- NA

    return( res)

  }


  if(is.numeric(x)) {
    # as.numeric still needed for casting integer to numeric!!
    res <- .Call("between_num_", as.numeric(x), as.numeric(rng[1]), as.numeric(rng[2]), PACKAGE="DescTools")
    res[is.na(x)] <- NA
  } else if(is.ordered(x)) {
    res <- .Call("between_num_", as.numeric(x), as.numeric(match(rng[1], levels(x))), as.numeric(match(rng[2], levels(x))), PACKAGE="DescTools")
    res[is.na(x)] <- NA
  }  else if(class(x) == "character")  {
    res <- ifelse ( x > rng[1] & x < rng[2], TRUE, FALSE )
  } else {
    res <- rep(NA, length(x))
  }
  return(res)
}


# outside operators (not exactly the negations)

`%][%` <- function(x, rng) {
  return(!(x %()% rng))
}

`%](%` <- function(x, rng) {
  return(!(x %(]% rng))
}

`%)[%` <- function(x, rng) {
  return(!(x %[)% rng))
}

`%)(%` <- function(x, rng) {
  return(!(x %[]% rng))
}



# Not %in% operator
`%nin%` <- function(x, table) match(x, table, nomatch = 0) == 0


# quick paste operator
# Core (Chambers) does not recommend + for non commutative operators, but still it's convenient and so we use c
# is it really? I doubt meanwhile...
# https://www.stat.math.ethz.ch/pipermail/r-devel/2006-August/039013.html
# http://stackoverflow.com/questions/1319698/why-doesnt-operate-on-characters-in-r?lq=1

`%c%` <- function(x, y) paste(x, y, sep="")


`%like%` <- function(x, pattern) {

    if (!substr(pattern, 1, 1) == "%") {
      pattern <- paste("^", pattern, sep="")
    } else {
      pattern <- substr(pattern, 2, nchar(pattern) )
    }
    if (!substr(pattern, nchar(pattern), nchar(pattern)) == "%") {
      pattern <- paste(pattern, "$", sep="")
    } else {
      pattern <- substr(pattern, 1, nchar(pattern)-1 )
    }

    grepl(pattern = pattern, x = x)
}



# c(Date(2012,1,3), Date(2012,2,3)) %overlaps% c(Date(2012,3,1), Date(2012,3,3))
# c(Date(2012,1,3), Date(2012,2,3)) %overlaps% c(Date(2012,1,15), Date(2012,1,21))
# Date(2012,1,3) %overlaps% c(Date(2012,3,1), Date(2012,3,3))
# c(1, 18) %overlaps% c(10, 45)


# Interval <- function(xp, yp){
#   # calculates the number of days of the overlapping part of two date periods
#   length(intersect(xp[1]:xp[2], yp[1]:yp[2]))
# }

Interval <- function(x, y){

  # make sure that min is left and max right
  x <- cbind(apply(rbind(x), 1, min), apply(rbind(x), 1, max))
  y <- cbind(apply(rbind(y), 1, min), apply(rbind(y), 1, max))

  # replicate
  maxdim <- max(nrow(x), nrow(y))
  x <- x[rep(1:nrow(x), length.out=maxdim), , drop=FALSE]
  y <- y[rep(1:nrow(y), length.out=maxdim), , drop=FALSE]

  d <- numeric(maxdim)
  idx <- y[,1] > x[,2]
  d[idx] <- (y[idx,1] - x[idx,2])
  idx <- y[,2] < x[,1]
  d[idx] <- (y[idx,2] - x[idx,1])

  unname(d)
}


`%overlaps%` <- function(x, y) {
  if(length(x) < 2) x <- rep(x, 2)
  if(length(y) < 2) y <- rep(y, 2)
  return(!(max(x) < min(y) | min(x) > max(y)) )
}

Overlap <- function(x, y){

  # make sure that min is left and max right
  x <- cbind(apply(rbind(x), 1, min), apply(rbind(x), 1, max))
  y <- cbind(apply(rbind(y), 1, min), apply(rbind(y), 1, max))

  # replicate
  maxdim <- max(nrow(x), nrow(y))
  x <- x[rep(1:nrow(x), length.out=maxdim), , drop=FALSE]
  y <- y[rep(1:nrow(y), length.out=maxdim), , drop=FALSE]

  d <- (apply(x, 1, diff) + apply(y, 1, diff)) - pmin(x[,2] - y[,1], y[,2]- x[,1])
  d[x[,1] > y[,2] | y[,1] > x[,2]] <- 0
  unname(d)
}




AllDuplicated <- function(x){
  # returns an index vector of all values involved in ties
  # so !AllDuplicated determines all values in x just appearing once
  duplicated(x, fromLast=FALSE) | duplicated(x, fromLast=TRUE)
}


# dummy codierung als Funktion aus:   library(nnet)
# see also model.frame(...)

# ClassInd <- function(cl) {
  # n <- length(cl)
  # cl <- as.factor(cl)
  # x <- matrix(0, n, length(levels(cl)))
  # x[(1L:n) + n * (unclass(cl) - 1L)] <- 1
  # dimnames(x) <- list(names(cl), levels(cl))
  # x
# }


Dummy <- function (x, method = c("treatment", "sum", "helmert", "poly", "full"),  base = 1) {

  # Alternatives:
  # options(contrasts = c("contr.sum", "contr.poly"))
  # model.matrix(~x.)[, -1]               ### und die dummy-codes
  # or Ripley's brilliant shorty-function:
  #   diag(nlevels(x))[x,]

  x <- as.factor(x)
  if(!is.numeric(base)) base <- match(base, levels(x))

  method <- match.arg( arg = method, choices = c("treatment", "sum", "helmert", "poly", "full") )

  switch( method
    , "treatment" = { res <- contr.treatment(n = nlevels(x), base = base)[x,] }
    , "sum" = { res <- contr.sum(n = nlevels(x))[x,] }
    , "helmert" = { res <- contr.helmert(n = nlevels(x))[x,] }
    , "poly" = { res <- contr.poly(n = nlevels(x))[x,] }
    , "full" = { res <- diag(nlevels(x))[x,] }
  )
  res <- as.matrix(res) # force res to be matrix, avoiding res being a vector if nlevels(x) = 2

  if(method=="full") {
    dimnames(res) <- list(if(is.null(names(x))) 1:length(x) else names(x), levels(x))
    attr(res, "base") <- NA
  } else {
    dimnames(res) <- list(if(is.null(names(x))) 1:length(x) else names(x), levels(x)[-base])
    attr(res, "base") <- levels(x)[base]
  }
  return(res)
}


Coalesce <- function(..., method = c("is.na", "is.finite")) {
  # Returns the first element in x which is not NA

  if(length(list(...)) > 1) {
    if(all(lapply(list(...), length) > 1)){
      x <- data.frame(...)
    } else {
      x <- unlist(list(...))
    }
  } else {
    if(is.matrix(...)) {
      x <- data.frame(...)
    } else {
      x <- (...)
    }
  }
  switch(match.arg(method, choices=c("is.na", "is.finite")),
    "is.na" = res <- Reduce(function (x,y) ifelse(!is.na(x), x, y), x),
    "is.finite" = res <- Reduce(function (x,y) ifelse(is.finite(x), x, y), x)
  )
  return(res)
}




PartitionBy <- function(x, by, FUN, ...){

  # SQL-OLAP: sum() over (partition by g)
  # (more than 1 grouping variables are enumerated like by=list(g1,g2,g3),
  # as it is defined in tapply

  # see also ave, which only handles arguments otherwise..

  if (missing(by))
    x[] <- FUN(x, ...)
  else {
    g <- interaction(by)
    split(x, g) <- lapply(split(x, g), FUN, ...)
  }
  x

}



# those are useless for R-NonDummies:
#
# WhichFlags <- function(d.frm) {
#   # liefert die Namen aller Flags (logische Var, int mit 2 levels) eines data.frames
#   switch( class(d.frm)[1]
#       , "data.frame" = {
#            ints <- names(d.frm)[ grep( pattern="integer", x=lapply( d.frm, class ) ) ]
#            c(
#               ints[ unlist( lapply(d.frm[,ints], function(x) length(unique(na.omit(x))) == 2 )) ]
#             , names(d.frm)[ grep( pattern="logical", x=lapply( d.frm, class ) ) ]
#            )
#       }
# 	  , "integer" = { if( length(unique(na.omit(d.frm))) == 2 ) names(d.frm) else NULL }
# 	  , "logical" = { deparse(substitute(d.frm)) }
# 	  , NULL
#   )
# }
#
#
#
# WhichFactors <- function(d.frm) {
#   # liefert die Namen aller Faktoren eines data.frames
#   names(d.frm)[ grep( pattern="factor", x=lapply( d.frm, class ) ) ]
# }
#
# WhichNumerics <- function(d.frm, type=c("all","numeric","integer"), excl.flags=FALSE ) {
#   # liefert die Namen aller kardinalskalierten Variablen eines data.frames
#   ints <- names(d.frm)[ grep(
#               pattern=switch( match.arg(type), "all"="integer|numeric", "numeric"="numeric", "integer"="integer" )
#             , x=lapply( d.frm, class )
#             ) ]
#   if( !excl.flags ){
#     ints} else { ints[ !ints %in% WhichFlags(d.frm) ] }
#
# }
#
# WhichCharacters <- function (d.frm) {
#   # returns the names of all character vectors of a data.frame
#   names(d.frm)[grep(pattern = "character", x = lapply(d.frm, class))]
# }
#



# IsWhole <-function(x, tol = .Machine$double.eps^0.5, na.rm=FALSE) {
#   # Define check if integer as (source: help-file from is.integer, example section)
#
#   # example:
#   # x <- c(1,3,2.003)
#   # all(IsWhole(x))
#
#   # an alternative in cwhmisc :
#   #   whole.number <- function (x) all((x%%1) == 0)
#
#   # other idea: floor(n) != ceiling(n)
#
#   if (na.rm)
#     x <- na.omit(x)
#   if(is.numeric(x))
#     abs(x - round(x)) < tol
#   else
#     FALSE
#
# }


IsWhole <-function(x, tol = .Machine$double.eps^0.5, na.rm=FALSE) {

  # this is a new version form sfsmisc
  # replaced old solution in DescTools 0.99.12
  if (na.rm)
    x <- na.omit(x)

  is.whole.scalar <- if (is.integer(x)) {
  function(x) TRUE
  }
  else if (is.numeric(x)) {
    function(x) isTRUE(all.equal(x, round(x), tol = tol))
  }
  else if (is.complex(x)) {
    function(x) isTRUE(all.equal(Re(x), round(Re(x)), tol = tol)) &&
      isTRUE(all.equal(Im(x), round(Im(x)), tol = tol))
  }
#  else stop("Input must be of type integer, numeric or complex.")
  else   function(x) FALSE

  if (is.null(dim(x)))
    vapply(x, is.whole.scalar, NA)
  else apply(x, seq_along(dim(x)), is.whole.scalar)

}



IsZero <-function(x, tol = .Machine$double.eps^0.5, na.rm=FALSE) {
  # Define check if a numeric is 0

  if (na.rm)
    x <- na.omit(x)
  if(is.numeric(x))
    x < tol
  else
    FALSE

}


IsNumeric <- function (x, length.arg = Inf, integer.valued = FALSE, positive = FALSE, na.rm = FALSE){

  if (na.rm)
    x <- na.omit(x)

  if (all(is.numeric(x)) && all(is.finite(x)) && (if (is.finite(length.arg)) length(x) ==
                                                    length.arg else TRUE) && (if (integer.valued) all(x == round(x)) else TRUE) &&
        (if (positive) all(x > 0) else TRUE)) TRUE else FALSE
}

IsOdd <- function(x) x %% 2 == 1


IsDichotomous <- function(x) length(unique(na.omit(x))) <= 2

# IsDichotomous <- function(x){
#   if(inherits(x, "logical")) return(TRUE)
#   if(inherits(x, "factor")) return(nlevels(x)==2)
#   if(inherits(x, "integer") || inherits(x, "numeric")) return(length(unique(na.omit(x))) == 2 )
#   return(FALSE)
# }


StrIsNumeric <- function(x){
  #example: x <- c("123", "-3.141", "foobar123")
  suppressWarnings(!is.na(as.numeric(x)))
}


IsPrime <- function(x) {
  if (is.null(x) || length(x) == 0)
    stop("Argument 'x' must be a nonempty vector or matrix.")
  if (!is.numeric(x) || any(x < 0) || any(x != round(x)))
    stop("All entries of 'x' must be nonnegative integers.")

  n <- length(x)
  X <- x[1:n]
  L <- logical(n)
  p <- DescTools::Primes(ceiling(sqrt(max(x))))
  for (i in 1:n) {
    L[i] <- all(X[i] %% p[p < X[i]] != 0)
  }
  L[X == 1 | X == 0] <- FALSE
  dim(L) <- dim(x)
  return(L)
}


VecRot <- function(x, n = 1)  {
  # just one shift:    (1:x %% x) + 1
  n <- n %% length(x)
#  rep(x, times=2)[(n+1):(n+length(x))]
  rep(x, times=2)[(length(x) - n+1):(2*length(x)-n)]
}


# Mround <- function(x, multiple) {
#   round(x/multiple, 0) * multiple
# }

RoundM <- function(x, multiple = 1, FUN = round) {

  # check for functions: round, ceiling, floor, but how????
  # FUN <- match.arg(FUN, c(round, ceiling, floor))

  if(is.function(FUN)) {
    # if FUN is a function, then save it under new name and
    # overwrite function name in FUN, which has to be character
    fct <- FUN
    FUN <- "fct"
    FUN <- gettextf("%s", FUN)
  }

  # round will set digits to 0 by default, which is exactly what we need here
  return(eval(parse(text = gettextf("%s(x/multiple) * multiple", FUN))))
}


# Alternative Idee mit up and down:

# Round <- function(x, digits = 0, direction=c("both", "down", "up"), multiple = NA) {
#
#   direction <- match.arg(direction)
#
#   switch(direction
#          , both={
#            if(is.na(multiple)){
#              res <- round(x, digits = digits)
#            } else {
#              res <- round(x/multiple) * multiple
#            }
#          }
#          , down={
#            if(is.na(multiple)){
#              res <- floor(x, digits = digits)
#            } else {
#              res <- floor(x/multiple) * multiple
#            }
#          }
#          , up={
#            if(is.na(multiple)){
#              res <- ceiling(x, digits = digits)
#            } else {
#              res <- ceiling(x/multiple) * multiple
#            }
#          }
#   )
#   return(res)
# }



Ray <- function(x){
  nidx <- sort(c(which(sapply(x, inherits, "numeric")), which(sapply(x, inherits, "integer")))  )
  nums <- data.frame(
    idx= nidx,
    classes=do.call("rbind", lapply(x[,nidx], class)),
    typeof=do.call("rbind", lapply(x[,nidx], typeof)),
    mode=do.call("rbind", lapply(x[,nidx], mode)),
    NAs=do.call("rbind", lapply(x[,nidx], function(x) sum(is.na(x)))),
    mean=do.call("rbind", lapply(x[,nidx], mean, na.rm=TRUE)),
    sd=do.call("rbind", lapply(x[,nidx], sd, na.rm=TRUE)),
    median=do.call("rbind", lapply(x[,nidx], median, na.rm=TRUE)),
    IQR=do.call("rbind", lapply(x[,nidx], IQR, na.rm=TRUE)),
    min=do.call("rbind", lapply(x[,nidx], min, na.rm=TRUE)),
    max=do.call("rbind", lapply(x[,nidx], max, na.rm=TRUE))
  )

  fidx <- which(sapply(x, is.factor))
  facts <- data.frame(
    idx=fidx,
    classes=do.call("rbind", lapply(x[,fidx], function(x) paste(class(x), collapse=", "))),
    typeof=do.call("rbind", lapply(x[,fidx], typeof)),
    mode=do.call("rbind", lapply(x[,fidx], mode)),
    NAs=do.call("rbind", lapply(x[,fidx], function(x) sum(is.na(x)))),
    nlevels=do.call("rbind", lapply(x[,fidx], nlevels))
  )

  idx <- seq_along(x)[-c(nidx, fidx)]
  elses <- data.frame(
    idx=idx,
    classes=do.call("rbind", lapply(x[,idx], class)),
    typeof=do.call("rbind", lapply(x[,idx], typeof)),
    mode=do.call("rbind", lapply(x[,idx], mode)),
    NAs=do.call("rbind", lapply(x[,idx], function(x) sum(is.na(x))))
  )

  return(list("numeric"=nums, "factors"=facts, "rest"=elses))

}



Str <- function(x, ...){
  if(identical(class(x), "data.frame")) {

    args <- list(...)
    if(is.null(args["strict.width"])) args["strict.width"] <- "cut"

    out <- .CaptOut(do.call(str, c(list(object=x), args)))
    idx <- format(1:length(grep(pattern="^ \\$", out)))
    i <- 1
    j <- 1
    while(i <= length(out)) {
      if( length(grep(pattern="^ \\$", out[i])) > 0 ) {
        out[i] <- gsub(pattern="^ \\$", replacement= paste(" ", idx[j], " \\$", sep=""), out[i])
        j <- j + 1
      }
      i <- i + 1
    }
    res <- out
  } else {
    res <- str(x)
  }
  cat(res, sep="\n")
  invisible(res)
}


LsFct <- function(package){
  as.vector(unclass(lsf.str(pos = gettextf("package:%s", package) )))

}

LsData <- function(package){
  # example  lsf("DescTools")
  ls(pos = gettextf("package:%s", package))
  as.vector(unclass(ls.str(gettextf("package:%s", package), mode="list")))

}

LsObj <- function(package){
  # example  lsf("DescTools")
  ls(pos = gettextf("package:%s", package))
}


PDFManual <- function(package){
  package <- as.character(substitute(package))
  browseURL(paste("http://cran.r-project.org/web/packages/", package,"/", package, ".pdf", sep = ""))
}


# showPDFmanual <- function(package, lib.loc=NULL)
# {
#   path <- find.package(package, lib.loc)
#   system(paste(shQuote(file.path(R.home("bin"), "R")),
#                "CMD", "Rd2pdf",
#                shQuote(path)))
# }


###

## base: organisation, format, report and printing routines ====


# Mbind <- function(...){
#   # matrix bind
#   # function um n nxm-matrizen zu einem 3d-array zusammenzufassen
#
#   arg.list <- list(...)
#   # check dimensions, by compare the dimension of each matrix to the first
#   if( !all( unlist(lapply(arg.list, function(m) all(unlist(dim(arg.list[[1]])) == unlist(dim(m)))) )))
#      stop("Not all matrices have the same dimension!")
#
#   ma <- array(unlist(arg.list), dim=c(nrow(arg.list[[1]]), ncol(arg.list[[2]]), length(arg.list)) )
#   dimnames(ma) <- dimnames(arg.list[[1]])
#   dimnames(ma)[[3]] <- if(is.null(names(arg.list))){1:length(arg.list)} else {names(arg.list)}
#
#   return(ma)
# }


Abind <- function(..., along=N, rev.along=NULL, new.names=NULL,
                  force.array=TRUE, make.names=use.anon.names, use.anon.names=FALSE,
                  use.first.dimnames=FALSE, hier.names=FALSE, use.dnns=FALSE) {

  if (is.character(hier.names))
    hier.names <- match.arg(hier.names, c('before', 'after', 'none'))
  else
    hier.names <- if (hier.names) 'before' else 'no'
  arg.list <- list(...)
  if (is.list(arg.list[[1]]) && !is.data.frame(arg.list[[1]])) {
    if (length(arg.list)!=1)
      stop("can only supply one list-valued argument for ...")
    if (make.names)
      stop("cannot have make.names=TRUE with a list argument")
    arg.list <- arg.list[[1]]
    have.list.arg <- TRUE
  } else {
    N <- max(1, sapply(list(...), function(x) length(dim(x))))
    have.list.arg <- FALSE
  }
  if (any(discard <- sapply(arg.list, is.null)))
    arg.list <- arg.list[!discard]
  if (length(arg.list)==0)
    return(NULL)
  N <- max(1, sapply(arg.list, function(x) length(dim(x))))

  ## N will eventually be length(dim(return.value))
  if (!is.null(rev.along))
    along <- N + 1 - rev.along

  if (along < 1 || along > N || (along > floor(along) && along < ceiling(along))) {
    N <- N + 1
    along <- max(1, min(N+1, ceiling(along)))
  }

  ## this next check should be redundant, but keep it here for safety...
  if (length(along) > 1 || along < 1 || along > N + 1)
    stop(paste("\"along\" must specify one dimension of the array,",
               "or interpolate between two dimensions of the array",
               sep="\n"))

  if (!force.array && N==2) {
    if (!have.list.arg) {
      if (along==2)
        return(cbind(...))
      if (along==1)
        return(rbind(...))
    } else {
      if (along==2)
        return(do.call("cbind", arg.list))
      if (along==1)
        return(do.call("rbind", arg.list))
    }
  }

  if (along>N || along<0)
    stop("along must be between 0 and ", N)

  pre <- seq(from=1, len=along-1)
  post <- seq(to=N-1, len=N-along)
  ## "perm" specifies permutation to put join dimension (along) last
  perm <- c(seq(len=N)[-along], along)

  arg.names <- names(arg.list)
  if (is.null(arg.names)) arg.names <- rep("", length(arg.list))
  ## if new.names is a character vector, treat it as argument names
  if (is.character(new.names)) {
    arg.names[seq(along=new.names)[nchar(new.names)>0]] <-
      new.names[nchar(new.names)>0]
    new.names <- NULL
  }

  ## Be careful with dot.args, because if Abind was called
  ## using do.call(), and had anonymous arguments, the expressions
  ## returned by match.call() are for the entire structure.
  ## This can be a problem in S-PLUS, not sure about R.
  ## E.g., in this one match.call() returns compact results:
  ## > (function(...)browser())(1:10,letters)
  ## Called from: (function(...)  browser())....
  ## b()> match.call(expand.dots=FALSE)$...
  ## list(1:10, letters)
  ## But in this one, match.call() returns evaluated results:
  ## > test <- function(...) browser()
  ## > do.call("test", list(1:3,letters[1:4]))
  ## Called from: test(c(1, 2, 3), c("a", "b....
  ## b(test)> match.call(expand.dots=FALSE)$...
  ## list(c(1, 2, 3), c("a", "b", "c", "d")
  ## The problem here was largely mitigated by making Abind()
  ## accept a single list argument, which removes most of the
  ## need for the use of do.call("Abind", ...)

  ## Create deparsed versions of actual arguments in arg.alt.names
  ## These are used for error messages
  if (any(arg.names=="")) {
    if (make.names) {
      ## Create dot.args to be a list of calling expressions for the objects to be bound.
      ## Be careful here with translation to R --
      ## dot.args does not have the "list" functor with R
      ## (and dot.args is not a call object), whereas with S-PLUS, dot.args
      ## must have the list functor removed
      dot.args <- match.call(expand.dots=FALSE)$... ## [[2]]
      if (is.call(dot.args) && identical(dot.args[[1]], as.name("list")))
        dot.args <- dot.args[-1]
      arg.alt.names <- arg.names
      for (i in seq(along=arg.names)) {
        if (arg.alt.names[i]=="") {
          if (object.size(dot.args[[i]])<1000) {
            arg.alt.names[i] <- paste(deparse(dot.args[[i]], 40), collapse=";")
          } else {
            arg.alt.names[i] <- paste("X", i, sep="")
          }
          arg.names[i] <- arg.alt.names[i]
        }
      }
      ## unset(dot.args) don't need dot.args any more, but R doesn't have unset()
    } else {
      arg.alt.names <- arg.names
      arg.alt.names[arg.names==""] <- paste("X", seq(along=arg.names), sep="")[arg.names==""]
    }
  } else {
    arg.alt.names <- arg.names
  }

  use.along.names <- any(arg.names!="")

  ## need to have here: arg.names, arg.alt.names, don't need dot.args

  names(arg.list) <- arg.names
  ## arg.dimnames is a matrix of dimension names, each element of the
  ## the matrix is a character vector, e.g., arg.dimnames[j,i] is
  ## the vector of names for dimension j of arg i
  arg.dimnames <- matrix(vector("list", N*length(arg.names)), nrow=N, ncol=length(arg.names))
  dimnames(arg.dimnames) <- list(NULL, arg.names)
  ## arg.dnns is a matrix of names of dimensions, each element is a
  ## character vector len 1, or NULL
  arg.dnns <- matrix(vector("list", N*length(arg.names)), nrow=N, ncol=length(arg.names))
  dimnames(arg.dnns) <- list(NULL, arg.names)
  dimnames.new <- vector("list", N)

  ## Coerce all arguments to have the same number of dimensions
  ## (by adding one, if necessary) and permute them to put the
  ## join dimension last.

  ## Create arg.dim as a matrix with length(dim) rows and
  ## length(arg.list) columns: arg.dim[j,i]==dim(arg.list[[i]])[j],
  ## The dimension order of arg.dim is original
  arg.dim <- matrix(integer(1), nrow=N, ncol=length(arg.names))

  for (i in seq(len=length(arg.list))) {
    m <- arg.list[[i]]
    m.changed <- FALSE

    ## be careful with conversion to array: as.array converts data frames badly
    if (is.data.frame(m)) {
      ## use as.matrix() in preference to data.matrix() because
      ## data.matrix() uses the unintuitive codes() function on factors
      m <- as.matrix(m)
      m.changed <- TRUE
    } else if (!is.array(m) && !is.null(m)) {
      if (!is.atomic(m))
        stop("arg '", arg.alt.names[i], "' is non-atomic")
      ## make sure to get the names of a vector and attach them to the array
      dn <- names(m)
      m <- as.array(m)
      if (length(dim(m))==1 && !is.null(dn))
        dimnames(m) <- list(dn)
      m.changed <- TRUE
    }
    new.dim <- dim(m)
    if (length(new.dim)==N) {
      ## Assign the dimnames of this argument to the i'th column of arg.dimnames.
      ## If dimnames(m) is NULL, would need to do arg.dimnames[,i] <- list(NULL)
      ## to set all elts to NULL, as arg.dimnames[,i] <- NULL does not actually
      ## change anything in S-PLUS (leaves whatever is there) and illegal in R.
      ## Since arg.dimnames has NULL entries to begin with, don't need to do
      ## anything when dimnames(m) is NULL
      if (!is.null(dimnames(m))) {
        arg.dimnames[,i] <- dimnames(m)
        if (use.dnns && !is.null(names(dimnames(m))))
          arg.dnns[,i] <- as.list(names(dimnames(m)))
      }
      arg.dim[,i] <- new.dim
    } else if (length(new.dim)==N-1) {
      ## add another dimension (first set dimnames to NULL to prevent errors)
      if (!is.null(dimnames(m))) {
        ## arg.dimnames[,i] <- c(dimnames(m)[pre], list(NULL), dimnames(m))[post]
        ## is equivalent to arg.dimnames[-N,i] <- dimnames(m)
        arg.dimnames[-along,i] <- dimnames(m)
        if (use.dnns && !is.null(names(dimnames(m))))
          arg.dnns[-along,i] <- as.list(names(dimnames(m)))
        ## remove the dimnames so that we can assign a dim of an extra length
        dimnames(m) <- NULL
      }
      arg.dim[,i] <- c(new.dim[pre], 1, new.dim[post])
      if (any(perm!=seq(along=perm))) {
        dim(m) <- c(new.dim[pre], 1, new.dim[post])
        m.changed <- TRUE
      }
    } else {
      stop("'", arg.alt.names[i], "' does not fit: should have `length(dim())'=",
           N, " or ", N-1)
    }

    if (any(perm!=seq(along=perm)))
      arg.list[[i]] <- aperm(m, perm)
    else if (m.changed)
      arg.list[[i]] <- m
  }

  ## Make sure all arguments conform
  conform.dim <- arg.dim[,1]
  for (i in seq(len=ncol(arg.dim))) {
    if (any((conform.dim!=arg.dim[,i])[-along])) {
      stop("arg '", arg.alt.names[i], "' has dims=", paste(arg.dim[,i], collapse=", "),
           "; but need dims=", paste(replace(conform.dim, along, "X"), collapse=", "))
    }
  }

  ## find the last (or first) names for each dimensions except the join dimension
  if (N>1)
    for (dd in seq(len=N)[-along]) {
      for (i in (if (use.first.dimnames) seq(along=arg.names) else rev(seq(along=arg.names)))) {
        if (length(arg.dimnames[[dd,i]]) > 0) {
          dimnames.new[[dd]] <- arg.dimnames[[dd,i]]
          if (use.dnns && !is.null(arg.dnns[[dd,i]]))
            names(dimnames.new)[dd] <- arg.dnns[[dd,i]]
          break
        }
      }
    }

  ## find or create names for the join dimension
  for (i in seq(len=length(arg.names))) {
    ## only use names if arg i contributes some elements
    if (arg.dim[along,i] > 0) {
      dnm.along <- arg.dimnames[[along,i]]
      if (length(dnm.along)==arg.dim[along,i]) {
        use.along.names <- TRUE
        if (hier.names=='before' && arg.names[i]!="")
          dnm.along <- paste(arg.names[i], dnm.along, sep=".")
        else if (hier.names=='after' && arg.names[i]!="")
          dnm.along <- paste(dnm.along, arg.names[i], sep=".")
      } else {
        ## make up names for the along dimension
        if (arg.dim[along,i]==1)
          dnm.along <- arg.names[i]
        else if (arg.names[i]=="")
          dnm.along <- rep("", arg.dim[along,i])
        else
          dnm.along <- paste(arg.names[i], seq(length=arg.dim[along,i]), sep="")
      }
      dimnames.new[[along]] <- c(dimnames.new[[along]], dnm.along)
    }
    if (use.dnns) {
      dnn <- unlist(arg.dnns[along,])
      if (length(dnn)) {
        if (!use.first.dimnames)
          dnn <- rev(dnn)
        names(dimnames.new)[along] <- dnn[1]
      }
    }
  }
  ## if no names at all were given for the along dimension, use none
  if (!use.along.names)
    dimnames.new[along] <- list(NULL)

  ## Construct the output array from the pieces.
  ## Could experiment here with more efficient ways of constructing the
  ## result than using unlist(), e.g.
  ##    out <- numeric(prod(c( arg.dim[-along,1], sum(arg.dim[along,]))))
  ## Don't use names in unlist because this can quickly exhaust memory when
  ## Abind is called with "do.call" (which creates horrendous names in S-PLUS).
  out <- array(unlist(arg.list, use.names=FALSE),
               dim=c( arg.dim[-along,1], sum(arg.dim[along,])),
               dimnames=dimnames.new[perm])
  ## permute the output array to put the join dimension back in the right place
  if (any(order(perm)!=seq(along=perm)))
    out <- aperm(out, order(perm))

  ## if new.names is list of character vectors, use whichever are non-null
  ## for dimension names, checking that they are the right length
  if (!is.null(new.names) && is.list(new.names)) {
    for (dd in seq(len=N)) {
      if (!is.null(new.names[[dd]])) {
        if (length(new.names[[dd]])==dim(out)[dd])
          dimnames(out)[[dd]] <- new.names[[dd]]
        else if (length(new.names[[dd]]))
          warning(paste("Component ", dd,
                        " of new.names ignored: has length ",
                        length(new.names[[dd]]), ", should be ",
                        dim(out)[dd], sep=""))
      }
      if (use.dnns && !is.null(names(new.names)) && names(new.names)[dd]!='')
        names(dimnames(out))[dd] <- names(new.names)[dd]
    }
  }
  if (use.dnns && !is.null(names(dimnames(out))) && any(i <- is.na(names(dimnames(out)))))
    names(dimnames(out))[i] <- ''
  out
}




# *********************************** 12.12.2014
# stack/unstack does exactly that

# ToLong <- function(x, varnames=NULL){
#   lst <- as.list(x)
#   res <- data.frame(rep(names(lst), lapply(lst, length)), unlist(lst))
#   rownames(res) <- NULL
#   if(is.null(varnames)) varnames <- c("grp","x")
#   colnames(res) <- varnames
#   return(res)
# }

ToLong <- function (x, varnames = NULL) {
  if(!is.list(x)) {
    lst <- as.list(x)
  } else {
    lst <- x
  }
  grpnames <- names(lst)
  if(is.null(grpnames)) grpnames <- paste("X", 1:length(lst), sep="")
  res <- data.frame(rep(grpnames, lapply(lst, length)), unlist(lst))
  rownames(res) <- NULL
  if (is.null(varnames))
    varnames <- c("grp", "x")

  colnames(res) <- varnames
  rownames(res) <- do.call(paste, c(expand.grid(grpnames, rownames(x)), sep="."))

  return(res)
}




ToWide <- function(x, g, varnames=NULL){
  g <- factor(g)
  res <- do.call("cbind", split(x, g))
  if(is.null(varnames)) varnames <- levels(g)
  colnames(res) <- varnames
  return(res)
}



CatTable <- function( tab, wcol, nrepchars, width=getOption("width") ) {

  # Wie viele Datenspalten haben vollstaendig Platz auf einer Linie?
  ncols <- ( width - nrepchars ) %/% wcol
  # Wieviele Zeilen ergeben sich?
  nrows <- ((nchar(tab[1]) - nrepchars) %/% wcol) / ncols +
    (((nchar(tab[1]) - nrepchars) %% wcol ) > 0) *1  # Rest Linie
  for( i in 1:nrows ) {
    for( j in 1:length(tab) ){
  #    cat( i, nrepchars + 1 + (i-1)*(ncols*wcol-4), nrepchars + i*ncols*wcol-5, "\n")
      cat( substr(tab[j],1,nrepchars)
	       , substr(tab[j], nrepchars + 1 + (i-1)*(ncols*wcol), nrepchars + 1 + i*ncols*wcol-1 )
	       , "\n", sep="" )
    }
	cat( "\n" )
	}
}



.CaptOut <- function(..., file = NULL, append = FALSE, width=150) {

  opt <- options(width=width)

  args <- substitute(list(...))[-1L]
  rval <- NULL
  closeit <- TRUE
  if (is.null(file))
    file <- textConnection("rval", "w", local = TRUE)
  else if (is.character(file))
    file <- file(file, if (append)
      "a"
      else "w")
  else if (inherits(file, "connection")) {
    if (!isOpen(file))
      open(file, if (append)
        "a"
        else "w")
    else closeit <- FALSE
  }
  else stop("'file' must be NULL, a character string or a connection")
  sink(file)
  on.exit({
    sink()
    if (closeit) close(file)
    options(opt)
  })
  pf <- parent.frame()
  evalVis <- function(expr) withVisible(eval(expr, pf))
  for (i in seq_along(args)) {
    expr <- args[[i]]
    tmp <- switch(mode(expr), expression = lapply(expr, evalVis),
                  call = , name = list(evalVis(expr)), stop("bad argument"))
    for (item in tmp) if (item$visible)
      print(item$value)
  }
  on.exit(options(opt))
  sink()
  if (closeit)
    close(file)
  if (is.null(rval))
    invisible(NULL)
  else rval

}



Ndec <- function(x) {
  # liefert die Anzahl der Nachkommastellen einer Zahl x
  # Alternative auch format.info [1]... Breite, [2]...Anzahl Nachkommastellen, [3]...Exponential ja/nein
  stopifnot(class(x)=="character")

  res <- rep(0, length(x))
  # remove evtl. exponents
  x <- gsub(pattern="[eE].+$", replacement="", x=x)
  res[grep("\\.",x)] <- nchar( sub("^.+[.]","",x) )[grep("\\.",x)]

  return(res)

}


Prec <- function (x) {

  # Function to return the most precise
  # digit from a vector of real numbers
  # Keep dividing by powers of 10 (pos and neg from trunc(log(max(x)) down)
  # until the fractional portion is zero, then we have the highest precision
  # digit in terms of a integer power of 10.

  # Thanks to Thomas Lumley for help with machine precision

  # Note:  Turn this into a standalone function for "regularizing" a
  #        time-activity object with irregular time breaks.

  init <- trunc(log10(max(x))) + 1
  zero <- 0
  y <- 1
  while (any(y > zero)) {
    init <- init - 1
    x1 <- x*10^(-init)
    y <- x1 - trunc(x1)
    zero <- max(x1)*.Machine$double.eps
  }
  10^init

  # sapply(c(1.235, 125.3, 1245), prec)

}

# other idea:
# precision <- function(x) {
#   rng <- range(x, na.rm = TRUE)
#
#   span <- if (zero_range(rng)) rng[1] else diff(rng)
#   10 ^ floor(log10(span))
# }





# FormatFix <- function(x, after, before=2, extend=TRUE) {
#   # library(cwhmisc)
#   # 2001-08-29, C.Hoffmann
#
#   stripform <- function(x,after,len) {
#     st <- format(x,digits=min(max(1,after),22),trim=TRUE,nsmall=after)
#     difflen <- nchar(st) - len
#     while (difflen < 0) {
#       st <- paste(" ",st,sep="")
#       difflen <- difflen+1
#     }
#     while ((difflen > 0) & (substring(st,1,1) == " ")) {
#       st <- substring(st,2)
#       difflen <- difflen-1
#     }
#     if (difflen) paste(rep("*",len),collapse="")
#     else st
#   }
#   maxA  <- 1.0e8
#   after <- max(after,0)
#   withdot <- after>0
#   toobig  <- ifelse(is.na(x),TRUE,abs(x)>=maxA)
#   decim <- pmax(floor(log10(abs(x))*(1+.Machine$double.eps)),0)
#   reqbef  <- ifelse(is.na(x),2,pmax(decim,0) + as.numeric(x<0) + 1)
#   placesbefore <- ifelse(is.na(x),2,ifelse(rep(extend,length(x)),decim+2,pmin(before,reqbef)))
#   placesbefore[toobig] <- 0
#   xx     <- round(abs(x)*10^after)  #  treat as integer
#   before <- max(before,placesbefore)
#   filldot <- reqbef > before
#   regular <- !filldot & !toobig
#   len <- mlen <- before+after+1
#   if (!withdot) mlen <- mlen-1
#   if (extend & any(toobig)) {
#     ncc <- max(nchar(format(x[toobig],digits=min(max(1,after),22)))) - mlen
#     if (ncc>0) {mlen <- mlen+ncc; len <- len+ncc}
#   }
#   str <- matrix("*",mlen,length(x))
#   str[,regular] <- " "
#   if (any(regular)) {
#     kk <- 1
#     while (kk <= after) {
#       str[len-kk+1,regular] <- xx[regular] %% 10
#       xx[regular] <- xx[regular] %/% 10
#       kk <- kk+1
#     }
#     if (withdot) str[len-kk+1,regular] <- "."
#     while (max(xx[regular]) > 0 | kk == after+1) { # latter for leading 0
#       str[len-kk,regular] <- ifelse(xx[regular] > 0 | kk == after+1,xx[regular] %% 10,str[len-kk,regular])
#       xx[regular] <- xx[regular] %/% 10
#       kk <- kk+1
#     }
#     str[cbind(len-after-placesbefore,seq(ncol(str)))[regular & (x<0),]] <- "-"
#   }
#   res <- apply(str,2,paste,collapse="")
#   if (any(toobig)) res[toobig] <- sapply(x[toobig],stripform,after,mlen)
#   names(res) <- names(x)
#   res
# }

Format <- function(x, digits = NULL, sci = getOption("scipen")
                                     , big.mark="", leading = NULL
                                     , zero.form = NULL, na.form = NULL
                                     , fmt = NULL, align = "left", width = NULL, ...){
  UseMethod("Format")
}


Format.matrix <- function(x, digits = NULL, sci = getOption("scipen")
                           , big.mark="", leading = NULL
                           , zero.form = NULL, na.form = NULL
                           , fmt = NULL, align = "left", width = NULL, ...){
  x[,] <- Format.default(x=x, digits=digits, sci=sci, big.mark=big.mark,
                         leading=leading, zero.form=zero.form, na.form=na.form,
                         fmt=fmt, align=align, width=width, ...)
  return(x)
}


Format.table <- function(x, digits = NULL, sci = getOption("scipen")
                          , big.mark="", leading = NULL
                          , zero.form = NULL, na.form = NULL
                          , fmt = NULL, align = "left", width = NULL, ...){
  x[] <- Format.default(x=x, digits=digits, sci=sci, big.mark=big.mark,
                         leading=leading, zero.form=zero.form, na.form=na.form,
                         fmt=fmt, align=align, width=width, ...)
  return(x)
}


Format.default <- function(x, digits = NULL, sci = getOption("scipen")
                   , big.mark="", leading = NULL
                   , zero.form = NULL, na.form = NULL
                   , fmt = NULL, align = NULL, width = NULL, ...){


#   We accept here a fmt class to be used as user templates
#   example:
#
#   fmt.int <- structure(list(
#     digits = 5, sci = getOption("scipen"), big.mark = "",
#     leading = NULL, zero.form = NULL, na.form = NULL,
#     align = "left", width = NULL, txt="(%s), %s - CHF"), class="fmt"
#   )
#
#   Format(7845, fmt=fmt.int)


  # The defined decimal character:
  # getOption("OutDec")


  if(is.null(fmt)) fmt <- ""
  if(class(fmt) == "fmt") return(do.call(Format, c(fmt, x=list(x))))

  if(all(class(x) == "Date")){
# format dates  ********************************************************************

    # fine format codes
    # http://www.autohotkey.com/docs/commands/FormatTime.htm

    formatd <- function(x, fmt) {

      pat <- ""
      fpat <- ""

      i <- 1
# we used here:
#       if(length(grep("\\bd{4}\\b", fmt)) > 0)
# which found dddd only as separated string from others (\b ... blank)
# this is not suitable for formats like yyyymmdd
# hence this was changed to d{4}

#      if(length(grep("\\bd{4}\\b", fmt)) > 0) {
      if(length(grep("d{4}", fmt)) > 0) {
        fmt <- gsub(pattern = "dddd", replacement = paste("\\\\", i, sep=""), x = fmt)
        pat <- paste(pat, "(.+)-", sep="")
        fpat <- paste(fpat, "%A-", sep="")
        i <- i+1
      }
#      if(length(grep("\\bd{3}\\b", fmt)) > 0) {
      if(length(grep("d{3}", fmt)) > 0) {
        fmt <- gsub(pattern = "ddd", replacement = paste("\\\\", i, sep=""), x = fmt)
        pat <- paste(pat, "(.+)-", sep="")
        fpat <- paste(fpat, "%a-", sep="")
        i <- i+1
      }
      if(length(grep("d{2}", fmt)) > 0) {
        fmt <- gsub(pattern = "dd", replacement = paste("\\\\", i, sep=""), x = fmt)
        pat <- paste(pat, "(.+)-", sep="")
        fpat <- paste(fpat, "%d-", sep="")
        i <- i+1
      }
      if(length(grep("d{1}", fmt)) > 0) {
        fmt <- gsub(pattern = "d", replacement = paste("\\\\", i, sep=""), x = fmt)
        pat <- paste(pat, "0?(.+)-", sep="")
        fpat <- paste(fpat, "%d-", sep="")
        i <- i+1
      }
      if(length(grep("m{4}", fmt)) > 0) {
        fmt <- gsub(pattern = "mmmm", replacement = paste("\\\\", i, sep=""), x = fmt)
        pat <- paste(pat, "(.+)-", sep="")
        fpat <- paste(fpat, "%B-", sep="")
        i <- i+1
      }
      if(length(grep("m{3}", fmt)) > 0) {
        fmt <- gsub(pattern = "mmm", replacement = paste("\\\\", i, sep=""), x = fmt)
        pat <- paste(pat, "(.+)-", sep="")
        fpat <- paste(fpat, "%b-", sep="")
        i <- i+1
      }
      if(length(grep("m{2}", fmt)) > 0) {
        fmt <- gsub(pattern = "mm", replacement = paste("\\\\", i, sep=""), x = fmt)
        pat <- paste(pat, "(.+)-", sep="")
        fpat <- paste(fpat, "%m-", sep="")
        i <- i+1
      }
      if(length(grep("m{1}", fmt)) > 0) {
        fmt <- gsub(pattern = "m", replacement = paste("\\\\", i, sep=""), x = fmt)
        pat <- paste(pat, "0?(.+)-", sep="")
        fpat <- paste(fpat, "%m-", sep="")
        i <- i+1
      }
      if(length(grep("y{4}", fmt)) > 0) {
        fmt <- gsub(pattern = "yyyy", replacement = paste("\\\\", i, sep=""), x = fmt)
        pat <- paste(pat, "(.+)-", sep="")
        fpat <- paste(fpat, "%Y-", sep="")
        i <- i+1
      }
      if(length(grep("y{2}", fmt)) > 0) {
        fmt <- gsub(pattern = "yy", replacement = paste("\\\\", i, sep=""), x = fmt)
        pat <- paste(pat, "(.+)-", sep="")
        fpat <- paste(fpat, "%y-", sep="")
        i <- i+1
      }
      if(length(grep("y{1}", fmt)) > 0) {
        fmt <- gsub(pattern = "y", replacement = paste("\\\\", i, sep=""), x = fmt)
        pat <- paste(pat, "0?(.+)-", sep="")
        fpat <- paste(fpat, "%y-", sep="")
        i <- i+1
      }

      sub(pat, fmt, format(x, fpat))

    }

    res <- formatd(x, fmt=fmt)

  } else if(fmt=="*"){
# format significance stars  ***************************************************

    breaks <- c(0,0.001,0.01,0.05,0.1,1)
    labels <- c("***","** ","*  ",".  ","   ")
    if(identical(x, NA)) return(NA)
    # example: Format(c(0.3, 0.08, 0.042, 0.001), fmt="*")
    res <- as.character(sapply(x, cut, breaks=breaks, labels=labels, include.lowest=TRUE))

  } else if(fmt=="p"){

# format p-values  ********************************************************************
     if(is.null(na.form)) na.form <- "NA"
#    this is based on original code from format.pval

      eps <- .Machine$double.eps

      if ((has.na <- any(ina <- is.na(x))))
        x <- x[!ina]
      r <- character(length(is0 <- x < eps))
      if (any(!is0)) {
        rr <- x <- x[!is0]
        expo <- floor(log10(ifelse(x > 0, x, 1e-50)))
        fixp <- (expo >= -3)
        if (any(fixp))
          rr[fixp] <- format(x[fixp], digits = 4)
        if (any(!fixp))
          rr[!fixp] <- format(x[!fixp], digits=3, scientific=TRUE)
        r[!is0] <- rr
      }
      if (any(is0)) {
        r[is0] <- gettextf("< %s", format(eps, digits = 2))
      }
      if (has.na) {
        rok <- r
        r <- character(length(ina))
        r[!ina] <- rok
        r[ina] <- na.form
      }

      res <- r

  } else if(fmt=="e"){
    res <- formatC(x, digits = digits, width = width, format = "e",
                   big.mark=big.mark)

  } else {

# format else (meaning nor date, nor p-vals, nor sign *, nor exp) ****************************************************************
    perc <- (fmt == "%")
    if(perc)
      # format percentages  ********************************************************************
      x <- round(x * 100, ifelse(is.null(digits), 0, digits))

    if(is.na(sci)){
      res <- formatC(x, digits = digits, width = width, format = "f",
                     big.mark=big.mark)
    } else {
      idx <- (((abs(x) > .Machine$double.eps) & (abs(x) <= 10^-sci)) | (abs(x) >= 10^sci))
      res <- as.character(rep(NA, length(x)))
      # use which here instead of res[idx], because of NAs
      res[which(idx)] <- formatC(x[which(idx)], digits = digits, width = width, format = "e",
                                 big.mark=big.mark)

#       Warning messages:
#         1: In formatC(x[which(!idx)], digits = digits, width = width, format = "f",  :
#                         class of 'x' was discarded
#     formatC is barking, classes are of no interess here, so suppress warning...
      res[which(!idx)] <- suppressWarnings(formatC(x[which(!idx)], digits = digits, width = width, format = "f",
                                  big.mark=big.mark))
    }
    if(perc) res <- paste(res, "%", sep="")

    if(!is.null(leading)){
      # handle leading zeros ------------------------------
      if(leading %in% c("","drop")) {
        # drop leading zeros
        res <- gsub("(?<![0-9])0+\\.", "\\.", res, perl = TRUE)

        # alternative:
        # res <- gsub("(-?)[^[:digit:]]0+\\.", "\\.", res)

        # old: mind the minus
        # res <- gsub("[^[:digit:]]0+\\.","\\.", res)

      } else if(grepl("^[0]*$", leading)){
        # leading contains only zeros, so let's use them as leading zeros
#         old:
#         n <- nchar(leading) - unlist(lapply(lapply(strsplit(res, "\\."), "[", 1), nchar))

        lz <- function(x, n){
          # just add a given number of leading zeros
          # split at the .
          z <- strsplit(as.character(x), split=".", fixed = TRUE)
          # left side
          zl <- lapply(z, "[", 1)
          zl <- sapply(zl, function(x) sprintf(paste0("%0", n + (x<0)*1, "i"), as.numeric(x)))
          # right side
          zr <- sapply(z, "[", 2)
          zr <- ifelse(is.na(zr), "", paste(".", zr, sep=""))

          paste(zl, zr, sep="")

        }
        # old: did not handle - correctly
        # res <- StrPad(res, pad = "0", width=nchar(res) + pmax(n, 0), adj="right")
        res <- lz(res, nchar(leading))
      }
    }
    if(!is.null(zero.form))
      res[abs(x) < .Machine$double.eps] <- zero.form
#         StrPad(zero.form, width = Coalesce(width, 1),
#                adj = Coalesce(ifelse(align == "dec", "right", align), "left"))
    if(!is.null(na.form)) res[is.na(x)] <- na.form
#         StrPad(na.form, width = Coalesce(width, 1),
#                adj = Coalesce(ifelse(align == "dec", "right", align), "left"))

    if(!is.null(align)){
      # touch alignment only when required
      switch(match.arg(align, c("left", "right", "center", "dec"))
# old:       , left  = { res <- gsub("^ +","", res) }   # delete all space on the left
             , left  = { res <- sub("(^ +)(.+)", "\\2\\1", res) } # delete all space on the left and append to the right
# old:       , right = { res <- StrPad(res, width = max(nchar(res)), pad = " ", adj="right")}
# see:   http://stackoverflow.com/questions/31221065/r-regexp-swapping-text-parts
             , right = { res <- sub("(.+?)( +$)", "\\2\\1", res) }
             , center= { res <- StrPad(StrTrim(res), width = max(nchar(res)), pad = " ", adj="center" )}
             , dec   = {
                         spx <- strsplit(res, "\\.")
                         bef <- lapply(spx, "[", 1)
                         aft <- lapply(spx, "[", 2)

                         res <- paste(
                           replace(StrPad(bef, max(nchar(bef)), " ", adj = "right"), is.na(bef), "")
                           , replace(StrPad(aft, max(nchar(aft)), " ", adj = "left"), is.na(aft), "")
                           , sep=".")
                         res[is.na(x)] <- NA
             }
      )}

  }

  return(res)

}


# define some format templates
.fmt_abs <- function()
    getOption("fmt.abs", structure(list(digits=0,
                                        big.mark="'"), class="fmt"))
# there is an option Sys.localeconv()["thousands_sep"], but we can't change it


.fmt_per <- function(digits=NULL){

  res <- getOption("fmt.per", structure(list(digits=1,
                                      fmt="%"), class="fmt"))
  # overwrite digits if given
  if(!is.null(digits))
     res["digits"] <- digits
  return(res)
}


.fmt_num <- function(digits = getOption("digits"))
  getOption("fmt.num", structure(list(digits=digits,
                                      big.mark=Sys.localeconv()["thousands_sep"]), class="fmt"))



Frac <- function(x, dpwr = NA) {  # fractional part
  res <- abs(x) %% 1
  # Alternative: res <- abs(x-trunc(x))
  if (!missing(dpwr)) res <- round(10^dpwr * res)
  res
}


MaxDigits <- function(x){
  # How to find the significant digits of a number?
  z <- na.omit(unlist(
    lapply(strsplit(as.character(x),
                    split = getOption("OutDec"), fixed = TRUE),
           "[", 2)))
  if(length(z)==0)
    res <- 0
  else
    res <- max(nchar(z))

  return(res)

  # Alternative: Sys.localeconv()["decimal_point"]
}




Recycle <- function(...){
  lgp <- list(...)
  maxdim <- max(unlist(lapply(lgp, length)))
  # recycle all params to maxdim
  res <- lapply(lgp, rep, length.out=maxdim)
  attr(res, "maxdim") <- maxdim

  return(res)
}




PartCor <- function(m, x, y)  {

  cl <- match.call()

  if(dim(m)[1] != dim(m)[2]) {
    n.obs <- dim(m)[1]
    m <- cor(m, use="pairwise")
  }
  if(!is.matrix(m)) m <- as.matrix(m)

  # first reorder the matrix to select the right variables
  nm <- dim(m)[1]
  t.mat <- matrix(0, ncol=nm, nrow=nm)
  xy <- c(x,y)
  numx <- length(x)
  numy <- length(y)
  nxy <- numx+numy

  for (i in 1:nxy) {
    t.mat[i, xy[i]] <- 1
  }

  reorder <- t.mat %*% m %*% t(t.mat)
  reorder[abs(reorder) > 1] <- NA    # this allows us to use the matrix operations to reorder and pick

  X <- reorder[1:numx, 1:numx]
  Y <- reorder[1:numx, (numx+1):nxy]

  phi <- reorder[(numx+1):nxy,(numx+1):nxy]
  phi.inv <- solve(phi)

  X.resid <- X - Y %*% phi.inv %*% t(Y)
  sd <- diag(sqrt(1/diag(X.resid)))
  X.resid <- sd %*% X.resid %*% sd

  colnames(X.resid) <- rownames(X.resid) <- colnames(m)[x]

  return(X.resid)

}


###


## stats: functions (RobRange, Hmean, Gmean, Aad, HuberM etc.) ====


FisherZ <- function(rho)  {0.5*log((1+rho)/(1-rho)) }   #converts r to z

FisherZInv <- function(z) {(exp(2*z)-1)/(1+exp(2*z)) }   #converts back again


CorCI <- function(rho, n, conf.level = 0.95, alternative = c("two.sided","less","greater")) {


    if (n < 3L)
      stop("not enough finite observations")

    if (!missing(conf.level) && (length(conf.level) != 1 || !is.finite(conf.level)
                                 || conf.level < 0 || conf.level > 1))
      stop("'conf.level' must be a single number between 0 and 1")

    alternative <- match.arg(alternative)

    z <- FisherZ(rho)
    sigma <- 1/sqrt(n - 3)

    ci <- switch(alternative,
                 less = c(-Inf, z + sigma * qnorm(conf.level)),
                 greater = c(z - sigma * qnorm(conf.level), Inf),
                 two.sided = z + c(-1, 1) * sigma * qnorm((1 + conf.level)/2))
    ci <- FisherZInv(ci)

    return(c(cor = rho, lwr.ci = ci[1], upr.ci = ci[2]))
}




CorPolychor <- function (x, y, ML=FALSE, control=list(), std.err=FALSE, maxcor=.9999){

    # last modified 21 Oct 08 by J. Fox

    binBvn <- function(rho, row.cuts, col.cuts, bins=4){
      # last modified 29 Mar 07 by J. Fox

      row.cuts <- if (missing(row.cuts)) c(-Inf, 1:(bins - 1)/bins, Inf) else  c(-Inf, row.cuts, Inf)
      col.cuts <- if (missing(col.cuts)) c(-Inf, 1:(bins - 1)/bins, Inf) else  c(-Inf, col.cuts, Inf)
      r <- length(row.cuts) - 1
      c <- length(col.cuts) - 1
      P <- matrix(0, r, c)
      R <- matrix(c(1, rho, rho, 1), 2, 2)
      for (i in 1:r){
        for (j in 1:c){
          P[i,j] <- pmvnorm(lower=c(row.cuts[i], col.cuts[j]),
                            upper=c(row.cuts[i+1], col.cuts[j+1]),
                            corr=R)
        }
      }
      P
    }


    f <- function(pars) {
      if (length(pars) == 1){
        rho <- pars
        if (abs(rho) > maxcor) rho <- sign(rho)*maxcor
        row.cuts <- rc
        col.cuts <- cc
      }
      else {
        rho <- pars[1]
        if (abs(rho) > maxcor) rho <- sign(rho)*maxcor
        row.cuts <- pars[2:r]
        col.cuts <- pars[(r+1):(r+c-1)]
      }
      P <- binBvn(rho, row.cuts, col.cuts)
      - sum(tab * log(P))
    }

    tab <- if (missing(y)) x else table(x, y)
    zerorows <- apply(tab, 1, function(x) all(x == 0))
    zerocols <- apply(tab, 2, function(x) all(x == 0))
    zr <- sum(zerorows)
    if (0 < zr) warning(paste(zr, " row", suffix <- if(zr == 1) "" else "s",
                              " with zero marginal", suffix," removed", sep=""))
    zc <- sum(zerocols)
    if (0 < zc) warning(paste(zc, " column", suffix <- if(zc == 1) "" else "s",
                              " with zero marginal", suffix, " removed", sep=""))
    tab <- tab[!zerorows, ,drop=FALSE]
    tab <- tab[, !zerocols, drop=FALSE]
    r <- nrow(tab)
    c <- ncol(tab)
    if (r < 2) {
      warning("the table has fewer than 2 rows")
      return(NA)
    }
    if (c < 2) {
      warning("the table has fewer than 2 columns")
      return(NA)
    }
    n <- sum(tab)
    rc <- qnorm(cumsum(rowSums(tab))/n)[-r]
    cc <- qnorm(cumsum(colSums(tab))/n)[-c]
    if (ML) {
      result <- optim(c(optimise(f, interval=c(-1, 1))$minimum, rc, cc), f,
                      control=control, hessian=std.err)
      if (result$par[1] > 1){
        result$par[1] <- 1
        warning("inadmissible correlation set to 1")
      }
      else if (result$par[1] < -1){
        result$par[1] <- -1
        warning("inadmissible correlation set to -1")
      }
      if (std.err) {
        chisq <- 2*(result$value + sum(tab * log((tab + 1e-6)/n)))
        df <- length(tab) - r - c
        result <- list(type="polychoric",
                       rho=result$par[1],
                       row.cuts=result$par[2:r],
                       col.cuts=result$par[(r+1):(r+c-1)],
                       var=solve(result$hessian),
                       n=n,
                       chisq=chisq,
                       df=df,
                       ML=TRUE)
        class(result) <- "polycor"
        return(result)
      }
      else return(as.vector(result$par[1]))
    }
    else if (std.err){
      result <- optim(0, f, control=control, hessian=TRUE, method="BFGS")
      if (result$par > 1){
        result$par <- 1
        warning("inadmissible correlation set to 1")
      }
      else if (result$par < -1){
        result$par <- -1
        warning("inadmissible correlation set to -1")
      }
      chisq <- 2*(result$value + sum(tab *log((tab + 1e-6)/n)))
      df <- length(tab) - r - c
      result <- list(type="polychoric",
                     rho=result$par,
                     var=1/result$hessian,
                     n=n,
                     chisq=chisq,
                     df=df,
                     ML=FALSE)
      class(result) <- "CorPolychor"
      return(result)
    }
    else optimise(f, interval=c(-1, 1))$minimum
  }




print.CorPolychor <- function(x, digits = max(3, getOption("digits") - 3), ...){

    # last modified 24 June 04 by J. Fox

        if (x$type == "polychoric"){
      se <- sqrt(diag(x$var))
      se.rho <- se[1]
      est <- if (x$ML) "ML est." else "2-step est."
      cat("\nPolychoric Correlation, ", est, " = ", signif(x$rho, digits),
          " (", signif(se.rho, digits), ")", sep="")
      if (x$df > 0)
        cat("\nTest of bivariate normality: Chisquare = ",
            signif(x$chisq, digits), ", df = ", x$df, ", p = ",
            signif(pchisq(x$chisq, x$df, lower.tail=FALSE), digits), "\n", sep="")
      else cat("\n")
      r <- length(x$row.cuts)
      c <- length(x$col.cuts)
      if (r == 0) return(invisible(x))
      row.cuts.se <- se[2:(r+1)]
      col.cuts.se <- se[(r+2):(r+c+1)]
      rowThresh <- signif(cbind(x$row.cuts, row.cuts.se), digits)
      if (r > 1) cat("\n  Row Thresholds\n")
      else cat("\n  Row Threshold\n")
      colnames(rowThresh) <- c("Threshold", "Std.Err.")
      rownames(rowThresh) <- if (r > 1) 1:r else " "
      print(rowThresh)
      colThresh <- signif(cbind(x$col.cuts, col.cuts.se), digits)
      if (c > 1) cat("\n\n  Column Thresholds\n")
      else cat("\n\n  Column Threshold\n")
      colnames(colThresh) <- c("Threshold", "Std.Err.")
      rownames(colThresh) <- if (c > 1) 1:c else " "
      print(colThresh)
    }
    else if (x$type == "polyserial"){
      se <- sqrt(diag(x$var))
      se.rho <- se[1]
      est <- if (x$ML) "ML est." else "2-step est."
      cat("\nPolyserial Correlation, ", est, " = ", signif(x$rho, digits),
          " (", signif(se.rho, digits), ")", sep="")
      cat("\nTest of bivariate normality: Chisquare = ", signif(x$chisq, digits),
          ", df = ", x$df, ", p = ", signif(pchisq(x$chisq, x$df, lower.tail=FALSE), digits),
          "\n\n", sep="")
      if (length(se) == 1) return(invisible(x))
      cuts.se <- se[-1]
      thresh <- signif(rbind(x$cuts, cuts.se), digits)
      colnames(thresh) <- 1:length(x$cuts)
      rownames(thresh) <- c("Threshold", "Std.Err.")
      print(thresh)
    }
    else print(unclass(x))
    invisible(x)
  }




FindCorr <- function(x, cutoff = .90, verbose = FALSE) {

  # Author: Max Kuhn
  # source library(caret)

  varnum <- dim(x)[1]

  if(!isTRUE(all.equal(x, t(x)))) stop("correlation matrix is not symmetric")
  if(varnum ==1) stop("only one variable given")

  x <- abs(x)

  # re-ordered columns based on max absolute correlation
  originalOrder <- 1:varnum

  averageCorr <- function(x) mean(x, na.rm = TRUE)
  tmp <- x
  diag(tmp) <- NA

  maxAbsCorOrder <- order(apply(tmp, 2, averageCorr), decreasing = TRUE)
  x <- x[maxAbsCorOrder, maxAbsCorOrder]
  newOrder <- originalOrder[maxAbsCorOrder]

  deletecol <- 0

  for(i in 1:(varnum-1))
  {
    for(j in (i+1):varnum)
    {
      if(!any(i == deletecol)  & !any(j == deletecol))
      {
        if(verbose)
          cat("Considering row\t", newOrder[i],
              "column\t", newOrder[j],
              "value\t", round(x[i,j], 3), "\n")
        if(abs(x[i,j]) > cutoff)
        {
          if(mean(x[i, -i]) > mean(x[-j, j]))
          {
            deletecol <- unique(c(deletecol, i))
            if(verbose) cat("  Flagging column\t", newOrder[i], "\n")
          } else {
            deletecol <- unique(c(deletecol, j))
            if(verbose) cat("  Flagging column\t", newOrder[j], "\n")
          }
        }
      }
    }
  }
  deletecol <- deletecol[deletecol != 0]
  newOrder[deletecol]
}




RobRange <- function(x, trim = 0.2, fac = 3, na.rm = FALSE) {

  # author: Werner Stahel
  # from:   regr.r

  if(na.rm) x <- na.omit(x)

  ldat <- x[is.finite(x)]
  if (is.character(ldat)|length(ldat) == 0) stop("invalid data")
  trim <- c(trim, 0.2)[1]
  if (!is.finite(trim)) trim <- 0.2
  lmn <- mean(ldat, trim=trim)
  lds <- sort(abs(ldat - lmn))
  ln <- ceiling((1 - trim) * length(ldat))
  if (ln < 3) {
    warning("Not enough valid data. returning ordinary range")
    lsd <- Inf
  } else {
    lsd <- fac * sum(lds[1:ln] / (ln-1))
    if (lsd == 0) {
      warning("Robust range has width 0. returning ordinary range")
      lsd <- Inf }
  }
  c(max(lmn - lsd, min(ldat)), min(lmn + lsd, max(ldat)))

}


# Alternative:
# From roc bioconductor
# Vince Carey (stvjc@channing.harvard.edu)

# trapezint <- function (x, y, a, b){
#
#   if (length(x) != length(y))
#     stop("length x must equal length y")
#   y <- y[x >= a & x <= b]
#   x <- x[x >= a & x <= b]
#   if (length(unique(x)) < 2)
#     return(NA)
#   ya <- approx(x, y, a, ties = max, rule = 2)$y
#   yb <- approx(x, y, b, ties = max, rule = 2)$y
#   x <- c(a, x, b)
#   y <- c(ya, y, yb)
#   h <- diff(x)
#   lx <- length(x)
#   0.5 * sum(h * (y[-1] + y[-lx]))
# }


AUC <- function(x, y, method=c("trapezoid", "step", "spline"), na.rm = FALSE) {

  # calculates Area unter the curve
  # example:
  #   AUC( x=c(1,2,3,5), y=c(0,1,1,2))
  #   AUC( x=c(2,3,4,5), y=c(0,1,1,2))

  if(na.rm) {
    idx <- na.omit(cbind(x,y))
    x <- x[idx]
    y <- y[idx]
  }

  if (length(x) != length(y))
    stop("length x must equal length y")

  idx <- order(x)
  x <- x[idx]
  y <- y[idx]

  switch( match.arg( arg=method, choices=c("trapezoid","step","spline") )
    , "trapezoid" = { a <- sum((apply( cbind(y[-length(y)], y[-1]), 1, mean))*(x[-1] - x[-length(x)])) }
    , "step" = { a <- sum( y[-length(y)] * (x[-1] - x[-length(x)])) }
    , "spline" = { a <- integrate(splinefun(x, y, method="natural"), lower=min(x), upper=max(x))$value }
  )
  return(a)
}



# mode value, the most frequent element
Mode <- function(x, na.rm=FALSE) {
  if(!is.atomic(x) | is.matrix(x)) stop("Mode supports only atomic vectors. Use sapply(*, Mode) instead.")
  if(na.rm) x <- na.omit(x)
  tab <- table(x)
  res <- names( which(tab==max(tab)) )    # handle ties...
  if( !inherits(x,"factor")) class(res) <- class(x)
  return(as.vector(res))
}



Gmean <- function (x, na.rm = FALSE) {
    if (na.rm) x <- na.omit(x)
    if(any(x < 0)) return(NA)
    return( exp(mean(log(x))) )
}


Gsd <- function (x, na.rm = FALSE) {
    if (na.rm) x <- na.omit(x)
    return( exp(sd(log(x))) )
}

Hmean <- function(x, na.rm = FALSE) {
  if(any(x < 0)) return(NA)
  else
  return( 1 / mean(1/x, na.rm = na.rm) )
}


# Average absolute deviation from the median
MeanAD <- function(x, FUN = mean, na.rm = FALSE) {

  if (na.rm) x <- na.omit(x)

  if(is.function(FUN)) {
    #  if FUN is a function, then save it under new name and
    # overwrite function name in FUN, which has to be character
    fct <- FUN
    FUN <- "fct"
    FUN <- gettextf("%s(x)", FUN)
  }
  # Calculates the mean absolute deviation from the sample mean.
  return(eval(parse(text = gettextf("mean(abs(x - %s))", FUN))))
}




TukeyBiweight <- function(x, const=9, na.rm = FALSE, conf.level = NA, ci.type = "bca", R=1000, ...) {

  if(na.rm) x <- na.omit(x)
  if(anyNA(x)) return(NA)

  if(is.na(conf.level)){
    #  .Call("tbrm", as.double(x[!is.na(x)]), const)
    res <- .Call("tbrm", as.double(x), const)

  } else {


    # adjusted bootstrap percentile (BCa) interval
    boot.tbw <- boot(x, function(x, d) .Call("tbrm", as.double(x[d]), const), R=R, ...)
    ci <- boot.ci(boot.tbw, conf=conf.level, type=ci.type)
    res <- c(tbw=boot.tbw$t0, lwr.ci=ci[[4]][4], upr.ci=ci[[4]][5])
  }

  return(res)

}



## Originally from  /u/ftp/NDK/Source-NDK-9/R/rg2-fkt.R :
.tauHuber <- function(x, mu, k=1.345, s = mad(x), resid = (x - mu)/s) {
  ## Purpose: Korrekturfaktor Tau fuer die Varianz von Huber-M-Schaetzern
  ## -------------------------------------------------------------------------
  ## Arguments: x = Daten mu = Lokations-Punkt k = Parameter der Huber Psi-Funktion
  ## -------------------------------------------------------------------------
  ## Author: Rene Locher Update: R. Frisullo 23.4.02;  M.Maechler (as.log(); s, resid)
  inr <- abs(resid) <= k
  psi  <- ifelse(inr, resid, sign(resid)*k)                # psi (x)
  psiP <- as.logical(inr)# = ifelse(abs(resid) <= k, 1, 0) # psi'(x)
  length(x) * sum(psi^2) / sum(psiP)^2
}

.wgt.himedian <- function(x, weights = rep(1,n)) {

  # Purpose: weighted hiMedian of x
  # Author: Martin Maechler, Date: 14 Mar 2002
  n <- length(x <- as.double(x))
  stopifnot(storage.mode(weights) %in% c("integer", "double"))
  if(n != length(weights))
    stop("'weights' must have same length as 'x'")
  # if(is.integer(weights)) message("using integer weights")
  .C(if(is.integer(weights)) "wgt_himed_i" else "wgt_himed",
     x, n, weights,
     res = double(1))$res
}


##  A modified "safe" (and more general) Huber estimator:
.huberM <-
  function(x, k = 1.345, weights = NULL,
           tol = 1e-06,
           mu = if(is.null(weights)) median(x) else .wgt.himedian(x, weights),
           s = if(is.null(weights)) mad(x, center=mu)
           else .wgt.himedian(abs(x - mu), weights),
           se = FALSE,
           warn0scale = getOption("verbose"))
  {
             ## Author: Martin Maechler, Date: 6 Jan 2003, ff

             ## implicit 'na.rm = TRUE':
             if(any(i <- is.na(x))) {
               x <- x[!i]
               if(!is.null(weights)) weights <- weights[!i]
             }
             n <- length(x)
             sum.w <-
               if(!is.null(weights)) {
                 stopifnot(is.numeric(weights), weights >= 0, length(weights) == n)
                 sum(weights)
               } else n
             it <- 0L
             NA. <- NA_real_
             if(sum.w == 0) # e.g 'x' was all NA
               return(list(mu = NA., s = NA., it = it, se = NA.)) # instead of error

             if(se && !is.null(weights))
               stop("Std.error computation not yet available for the case of 'weights'")
             if (s <= 0) {
               if(s < 0) stop("negative scale 's'")
               if(warn0scale && n > 1)
                 warning("scale 's' is zero -- returning initial 'mu'")
             }
             else {
               wsum <- if(is.null(weights)) sum else function(u) sum(u * weights)
               repeat {
                 it <- it + 1L
                 y <- pmin(pmax(mu - k * s, x), mu + k * s)
                 mu1 <- wsum(y) / sum.w
                 if (abs(mu - mu1) < tol * s)
                   break
                 mu <- mu1
               }
             }
             list(mu = mu, s = s, it = it,
                  SE = if(se) s * sqrt(.tauHuber(x, mu=mu, s=s, k=k) / n) else NA.)
}


HuberM <- function(x, k = 1.345, mu = median(x), s = mad(x, center=mu),
    na.rm = FALSE, conf.level = NA, ci.type = c("wald", "boot"), ...){

  # new interface to HuberM, making it less complex
  # refer to robustbase::huberM if more control is required

  if(na.rm) x <- na.omit(x)
  if(anyNA(x)) return(NA)


  if(is.na(conf.level)){
    res <- .huberM(x=x, k=k, mu=mu, s=s, warn0scale=TRUE)$mu

    return(res)

  } else {

    switch(match.arg(ci.type)
           ,"wald"={
             res <- .huberM(x=x, k=k, mu=mu, s=s, se=TRUE, warn0scale=TRUE)
# Solution: (12.6.06) - Robuste Regression (Rg-2d) - Musterloeungen zu Serie 1
# r.loc$mu + c(-1,1)*qt(0.975,8)*sqrt(t.tau/length(d.ertrag))*r.loc$s
#
# Ruckstuhl's Loesung:
# (Sleep.HM$mu + c(-1,1)*qt(0.975, length(Sleep)-1) *
#              sqrt(f.tau(Sleep, Sleep.HM$mu)) * Sleep.HM$s/sqrt(length(Sleep)))

#             ci <- qnorm(1-(1-conf.level)/2) * res$SE
             ci <- qt(1-(1-conf.level)/2, length(x)-1) *
                             sqrt(.tauHuber(x, res$mu, k=k)) * res$s/sqrt(length(x))
             res <- c(hm=res$mu, lwr.ci=res$mu - ci, upr.ci=res$mu + ci)
           }
           ,"boot" ={
             R <- InDots(..., arg="R", default=1000)
             bci.type <- InDots(..., arg="type", default="perc")

             boot.hm <- boot(x, function(x, d){
               hm <- .huberM(x=x[d], k=k, mu=mu, s=s, se=TRUE)
               return(c(hm$mu, hm$s^2))
               }, R=R)
             ci <- boot.ci(boot.hm, conf=conf.level, ...)

             if(ci.type =="norm") {
               lwr.ci <- ci[[4]][2]
               upr.ci <- ci[[4]][3]
             } else {
               lwr.ci <- ci[[4]][4]
               upr.ci <- ci[[4]][5]
             }

             res <- c(hm=boot.hm$t0[1], lwr.ci=lwr.ci, upr.ci=upr.ci)

           }
           )
    return(res)

  }

}




# old version, replace 13.5.2015
#
# #  A modified "safe" (and more general) Huber estimator:
# HuberM <- function(x, k = 1.5, weights = NULL, tol = 1e-06,
# 	     mu = if(is.null(weights)) median(x) else wgt.himedian(x, weights),
# 	     s = if(is.null(weights)) mad(x, center=mu) else wgt.himedian(abs(x - mu), weights),
# 	     se = FALSE, warn0scale = getOption("verbose"), na.rm = FALSE, stats = FALSE) {
#
#     # Author: Martin Maechler, Date: 6 Jan 2003, ff
#
#     # Originally from  /u/ftp/NDK/Source-NDK-9/R/rg2-fkt.R :
#     tauHuber <- function(x, mu, k=1.5, s = mad(x), resid = (x - mu)/s) {
#       # Purpose: Korrekturfaktor Tau fuer die Varianz von Huber-M-Schaetzern
#       # ******************************************************************************
#       # Arguments: x = Daten mu = Lokations-Punkt k = Parameter der Huber Psi-Funktion
#       # ******************************************************************************
#       # Author: Rene Locher Update: R. Frisullo 23.4.02;  M.Maechler (as.log(); s, resid)
#       inr <- abs(resid) <= k
#       psi  <- ifelse(inr, resid, sign(resid)*k)                 #### psi (x)
#       psiP <- as.logical(inr) # = ifelse(abs(resid) <= k, 1, 0) #### psi'(x)
#       length(x) * sum(psi^2) / sum(psiP)^2
#     }
#
#     wgt.himedian <- function(x, weights = rep(1,n)) {
#
#         # Purpose: weighted hiMedian of x
#         # Author: Martin Maechler, Date: 14 Mar 2002
#         n <- length(x <- as.double(x))
#         stopifnot(storage.mode(weights) %in% c("integer", "double"))
#         if(n != length(weights))
#       stop("'weights' must have same length as 'x'")
#         # if(is.integer(weights)) message("using integer weights")
#         .C(if(is.integer(weights)) "wgt_himed_i" else "wgt_himed",
#            x, n, weights,
#            res = double(1))$res
#     }
#
#
#     # Andri: introduce na.rm
#     # old: implicit 'na.rm = TRUE'
#     if(na.rm) {
#         i <- is.na(x)
#         x <- x[!i]
#         if(!is.null(weights)) weights <- weights[!i]
#     } else {
#       if(anyNA(x)) return(NA)
#     }
#
#
#     n <- length(x)
#     sum.w <-
#         if(!is.null(weights)) {
#             stopifnot(is.numeric(weights), weights >= 0, length(weights) == n)
#             sum(weights)
#         } else n
#     it <- 0L
#     NA. <- NA_real_
#     if(sum.w == 0) # e.g 'x' was all NA
# 	return(list(mu = NA., s = NA., it = it, se = NA.)) # instead of error
#
#     if(se && !is.null(weights))
# 	stop("Std.error computation not yet available for the case of 'weights'")
#
#     if (s <= 0) {
#         if(s < 0) stop("negative scale 's'")
#         if(warn0scale && n > 1)
#             warning("scale 's' is zero -- returning initial 'mu'")
#     }
#     else {
#         wsum <- if(is.null(weights)) sum else function(u) sum(u * weights)
#
# 	repeat {
# 	    it <- it + 1L
#             y <- pmin(pmax(mu - k * s, x), mu + k * s)
# 	    mu1 <- wsum(y) / sum.w
# 	    if (abs(mu - mu1) < tol * s)
# 		break
# 	    mu <- mu1
# 	}
#     }
#
#   if(stats)
#     res <- list(mu = mu, s = s, it = it,
#              SE = if(se) s * sqrt(tauHuber(x, mu=mu, s=s, k=k) / n) else NA.)
#   else
#     res <- mu
#
#   return(res)
#
# }



HodgesLehmann <- function(x, y = NULL, conf.level = NA, na.rm = FALSE) {

#   Werner Stahel's version:
#
#   f.HodgesLehmann <- function(data)
#   {
#     ## Purpose:   Hodges-Lehmann estimate and confidence interval
#     ## -------------------------------------------------------------------------
#     ## Arguments:
#     ## Remark: function changed so that CI covers >= 95%, before it was too
#     ##         small (9/22/04)
#     ## -------------------------------------------------------------------------
#     ## Author: Werner Stahel, Date: 12 Aug 2002, 14:13
#     ## Update: Beat Jaggi, Date: 22 Sept 2004
#     .cexact <-
#       # c(NA,NA,NA,NA,NA,21,26,33,40,47,56,65,74,84,95,107,119,131,144,158)
#       c(NA,NA,NA,NA,NA,22,27,34,41,48,57,66,75,85,96,108,120,132,145,159)
#     .d <- na.omit(data)
#     .n <- length(.d)
#     .wa <- sort(c(outer(.d,.d,"+")/2)[outer(1:.n,1:.n,"<=")])
#     .c <- if (.n<=length(.cexact)) .n*(.n+1)/2+1-.cexact[.n] else
#       floor(.n*(.n+1)/4-1.96*sqrt(.n*(.n+1)*(2*.n+1)/24))
#     .r <- c(median(.wa), .wa[c(.c,.n*(.n+1)/2+1-.c)])
#     names(.r) <- c("estimate","lower","upper")
#     .r
#   }


  # inspired by package ICSNP, function hl.loc

  if(na.rm) {
    if(is.null(y))
      x <- na.omit(x)
    else {
      ok <- complete.cases(x, y)
      x <- x[ok]
      y <- y[ok]
    }
  }

  if(anyNA(x) || (!is.null(y) && anyNA(y)))
    if(is.na(conf.level))
      return(NA)
    else
      return(c(est=NA,  lwr.ci=NA, upr.ci=NA))


  res <- wilcox.test(x,  y, conf.int = TRUE, conf.level = Coalesce(conf.level, 0.8))

  if(is.na(conf.level)){
    result <-  res$estimate
    names(result) <- NULL
  } else {
    result <- c(est=res$estimate,  lwr.ci=res$conf.int[1], upr.ci=res$conf.int[2])
    names(result)[1] <- "est"
  }

  return(result)

}



Skew <- function (x, na.rm = FALSE, method = 3, conf.level = NA, ci.type = "bca", R=1000, ...) {

  # C part for the expensive (x - mean(x))^2 etc. is a kind of 14 times faster
  #   > x <- rchisq(100000000, df=2)
  #   > system.time(Skew(x))
  #   user  system elapsed
  #   6.32    0.30    6.62
  #   > system.time(Skew2(x))
  #   user  system elapsed
  #   0.47    0.00    0.47


  i.skew <- function(x, method = 3) {

    n <- length(x)

    # method 1: older textbooks
    r.skew <- .Call("rskew", as.numeric(x), as.numeric(mean(x)), PACKAGE="DescTools")
    se <- sqrt((6*(n-2))/((n+1)*(n+3)))

    if (method == 2) {
      # method 2: SAS/SPSS
      r.skew <- r.skew * n^0.5 * (n - 1)^0.5/(n - 2)
      se <- se * sqrt(n*(n-1))/(n-2)
    }
    else if (method == 3) {
      # method 3: MINITAB/BDMP
      r.skew <- r.skew * ((n - 1)/n)^(3/2)
      se <- se * ((n - 1)/n)^(3/2)
    }
    return(c(r.skew, se^2))
  }

  if (na.rm) x <- na.omit(x)

  if(is.na(conf.level)){
    res <- i.skew(x, method=method)[1]

  } else {

    if(ci.type == "classic") {
      res <- i.skew(x, method=method)
      res <- c(skewness=res[1], lwr.ci=qnorm(1-(1-conf.level)/2) * sqrt(res[2]), upr.ci=qnorm(1-(1-conf.level)/2) * sqrt(res[2]))

    } else {
      # Problematic standard errors and confidence intervals for skewness and kurtosis.
      # Wright DB, Herrington JA. (2011) recommend only bootstrap intervals
      # adjusted bootstrap percentile (BCa) interval
      boot.skew <- boot(x, function(x, d) i.skew(x[d], method=method), R=R, ...)
      ci <- boot.ci(boot.skew, conf=conf.level, type=ci.type)
      if(ci.type =="norm") {
        lwr.ci <- ci[[4]][2]
        upr.ci <- ci[[4]][3]
      } else {
        lwr.ci <- ci[[4]][4]
        upr.ci <- ci[[4]][5]
      }
    }

    res <- c(skew=boot.skew$t0[1], lwr.ci=lwr.ci, upr.ci=upr.ci)
    # res <- ci
  }

  return(res)

}



Kurt <- function (x, na.rm = FALSE, method = 3, conf.level = NA, ci.type = "bca", R=1000, ...) {

  i.kurt <- function(x, na.rm = FALSE, method = 3) {
    if (na.rm) x <- na.omit(x)

    n <- length(x)
    # method 1: older textbooks
    r.kurt <- .Call("rkurt", as.numeric(x), as.numeric(mean(x)), PACKAGE="DescTools")
    se <- sqrt((24*n*(n-2)*(n-3))/((n+1)^2*(n+3)*(n+5)))

    if (method == 2) {
      # method 2: SAS/SPSS
      r.kurt <- ((r.kurt + 3) * (n + 1)/(n - 1) - 3) * (n - 1)^2/(n - 2)/(n - 3)
      se <- se * (((n-1)*(n+1))/((n-2)*(n-3)))
    }
    else if (method == 3) {
      # method 3: MINITAB/BDMP
      r.kurt <- (r.kurt + 3) * (1 - 1/n)^2 - 3
      se <- se * ((n-1)/n)^2
    }
    return(c(r.kurt, se^2))
  }

  if(is.na(conf.level)){
    res <- i.kurt(x, na.rm=na.rm, method=method)[1]

  } else {
    if(ci.type == "classic") {
      res <- i.kurt(x, method=method)
      res <- c(kurtosis=res[1], lwr.ci=qnorm(1-(1-conf.level)/2) * sqrt(res[2]), upr.ci=qnorm(1-(1-conf.level)/2) * sqrt(res[2]))

    } else {

      # Problematic standard errors and confidence intervals for skewness and kurtosis.
      # Wright DB, Herrington JA. (2011) recommend only bootstrap intervals
      # adjusted bootstrap percentile (BCa) interval
      boot.kurt <- boot(x, function(x, d) i.kurt(x[d], na.rm=na.rm, method=method), R=R, ...)
      ci <- boot.ci(boot.kurt, conf=conf.level, type=ci.type)

      if(ci.type =="norm") {
        lwr.ci <- ci[[4]][2]
        upr.ci <- ci[[4]][3]
      } else {
        lwr.ci <- ci[[4]][4]
        upr.ci <- ci[[4]][5]
      }

      res <- c(kurt=boot.kurt$t0[1], lwr.ci=lwr.ci, upr.ci=upr.ci)
    }
  }

  return(res)

}


Outlier <- function(x, method=c("boxplot"), na.rm=FALSE){

  if(na.rm) x <- na.omit(x)

  switch(match.arg(arg = method, choices = c("boxplot")),
  #         boxplot =  { x[x %)(% (quantile(x, c(0.25,0.75), na.rm=na.rm) + c(-1,1) * 1.5*IQR(x,na.rm=na.rm))] }
     boxplot =  { res <- boxplot(x, plot = FALSE)$out }

  )
  return(res)

}


LOF <- function(data,k) {

    # source: library(dprep)

    # A function that finds the local outlier factor (Breunig,2000) of
    # the matrix "data" with k neighbors
    # Adapted by Caroline Rodriguez and Edgar Acuna, may 2004

  knneigh.vect <-
    function(x,data,k)
    {
      #Function that returns the distance from a vector "x" to
      #its k-nearest-neighbors in the matrix "data"

      temp=as.matrix(data)
      numrow=dim(data)[1]
      dimnames(temp)=NULL

      #subtract rowvector x from each row of data
      difference<- scale(temp, x, FALSE)

      #square and add all differences and then take the square root
      dtemp <- drop(difference^2 %*% rep(1, ncol(data)))
      dtemp=sqrt(dtemp)

      #order the distances
      order.dist <- order(dtemp)
      nndist=dtemp[order.dist]

      #find distance to k-nearest neighbor
      #uses k+1 since first distance in vector is a 0
      knndist=nndist[k+1]

      #find neighborhood
      #eliminate first row of zeros from neighborhood
      neighborhood=drop(nndist[nndist<=knndist])
      neighborhood=neighborhood[-1]
      numneigh=length(neighborhood)

      #find indexes of each neighbor in the neighborhood
      index.neigh=order.dist[1:numneigh+1]

      # this will become the index of the distance to first neighbor
      num1=length(index.neigh)+3

      # this will become the index of the distance to last neighbor
      num2=length(index.neigh)+numneigh+2

      #form a vector
      neigh.dist=c(num1,num2,index.neigh,neighborhood)

      return(neigh.dist)
    }



    dist.to.knn <-
      function(dataset,neighbors)
      {

        #function returns an object in which each column contains
        #the indices of the first k neighbors followed by the
        #distances to each of these neighbors

        numrow=dim(dataset)[1]

        #applies a function to find distance to k nearest neighbors
        #within "dataset" for each row of the matrix "dataset"

        knndist=rep(0,0)


        for (i in 1:numrow)
        {
          #find obervations that make up the k-distance neighborhood for dataset[i,]
          neighdist=knneigh.vect(dataset[i,],dataset,neighbors)

          #adjust the length of neighdist or knndist as needed to form matrix of neighbors
          #and their distances
          if (i==2)
          {
            if (length(knndist)<length(neighdist))
            {
              z=length(neighdist)-length(knndist)
              zeros=rep(0,z)
              knndist=c(knndist,zeros)
            }
            else if (length(knndist)>length(neighdist))
            {
              z=length(knndist)-length(neighdist)
              zeros=rep(0,z)
              neighdist=c(neighdist,zeros)
            }
          }
          else
          {
            if (i!=1)
            {
              if (dim(knndist)[1]<length(neighdist))
              {
                z=(length(neighdist)-dim(knndist)[1])
                zeros=rep(0,z*dim(knndist)[2])
                zeros=matrix(zeros,z,dim(knndist)[2])
                knndist=rbind(knndist,zeros)
              }
              else if (dim(knndist)[1]>length(neighdist))
              {
                z=(dim(knndist)[1]-length(neighdist))
                zeros=rep(0,z)
                neighdist=c(neighdist,zeros)
              }
            }
          }
          knndist=cbind(knndist,neighdist)
        }

        return(knndist)
      }


  reachability <-
    function(distdata,k)
    {
      #function that calculates the local reachability density
      #of Breuing(2000) for each observation in a matrix, using
      #a matrix (distdata) of k nearest neighbors computed by the function dist.to.knn2

      p=dim(distdata)[2]
      lrd=rep(0,p)

      for (i in 1:p)
      {
        j=seq(3,3+(distdata[2,i]-distdata[1,i]))
        # compare the k-distance from each observation to its kth neighbor
        # to the actual distance between each observation and its neighbors
        numneigh=distdata[2,i]-distdata[1,i]+1
        temp=rbind(diag(distdata[distdata[2,distdata[j,i]],distdata[j,i]]),distdata[j+numneigh,i])

        #calculate reachability
        reach=1/(sum(apply(temp,2,max))/numneigh)
        lrd[i]=reach
      }
      lrd
    }


    data=as.matrix(data)

    #find k nearest neighbors and their distance from each observation
    #in data
    distdata=dist.to.knn(data,k)
    p=dim(distdata)[2]

    #calculate the local reachability density for each observation in data
    lrddata=reachability(distdata,k)

    lof=rep(0,p)

    #computer the local outlier factor of each observation in data
    for ( i in 1:p)
    {
      nneigh=distdata[2,i]-distdata[1,i]+1
      j=seq(0,(nneigh-1))
      local.factor=sum(lrddata[distdata[3+j,i]]/lrddata[i])/nneigh
      lof[i]=local.factor
    }

    #return lof, a vector with the local outlier factor of each observation
    lof
}




# Confidence Intervals for Binomial Proportions
BinomCI <- function(x, n, conf.level = 0.95, method = c("wilson", "wald", "agresti-coull", "jeffreys", "modified wilson",
    "modified jeffreys", "clopper-pearson", "arcsine", "logit", "witting", "pratt"), rand = 123) {

  if(missing(method)) method <- "wilson"

  iBinomCI <- function(x, n, conf.level = 0.95, method = c("wilson", "wald", "agresti-coull", "jeffreys", "modified wilson",
      "modified jeffreys", "clopper-pearson", "arcsine", "logit", "witting", "pratt"), rand = 123) {

    if(length(x) != 1) stop("'x' has to be of length 1 (number of successes)")
    if(length(n) != 1) stop("'n' has to be of length 1 (number of trials)")
    if(length(conf.level) != 1)  stop("'conf.level' has to be of length 1 (confidence level)")
    if(conf.level < 0.5 | conf.level > 1)  stop("'conf.level' has to be in [0.5, 1]")

    alpha <- 1 - conf.level
    kappa <- qnorm(1-alpha/2)
    p.hat <- x/n
    q.hat <- 1 - p.hat

    switch( match.arg(arg=method, choices=c("wilson", "wald", "agresti-coull", "jeffreys", "modified wilson",
                                            "modified jeffreys", "clopper-pearson", "arcsine", "logit", "witting","pratt"))
            , "wald" = {
              est <- p.hat
              term2 <- kappa*sqrt(p.hat*q.hat)/sqrt(n)
              CI.lower <- max(0, p.hat - term2)
              CI.upper <- min(1, p.hat + term2)
            }
            , "wilson" = {
              est <- p.hat
              term1 <- (x + kappa^2/2)/(n + kappa^2)
              term2 <- kappa*sqrt(n)/(n + kappa^2)*sqrt(p.hat*q.hat + kappa^2/(4*n))
              CI.lower <-  max(0, term1 - term2)
              CI.upper <- min(1, term1 + term2)
            }
            , "agresti-coull" = {
              x.tilde <- x + kappa^2/2
              n.tilde <- n + kappa^2
              p.tilde <- x.tilde/n.tilde
              q.tilde <- 1 - p.tilde
              est <- p.tilde
              term2 <- kappa*sqrt(p.tilde*q.tilde)/sqrt(n.tilde)
              CI.lower <- max(0, p.tilde - term2)
              CI.upper <- min(1, p.tilde + term2)
            }
            , "jeffreys" = {
              est <- p.hat
              if(x == 0)
                CI.lower <- 0
              else
                CI.lower <- qbeta(alpha/2, x+0.5, n-x+0.5)
              if(x == n)
                CI.upper <- 1
              else
                CI.upper <- qbeta(1-alpha/2, x+0.5, n-x+0.5)
            }
            , "modified wilson" = {
              est <- p.hat
              term1 <- (x + kappa^2/2)/(n + kappa^2)
              term2 <- kappa*sqrt(n)/(n + kappa^2)*sqrt(p.hat*q.hat + kappa^2/(4*n))
              if((n <= 50 & x %in% c(1, 2)) | (n >= 51 & n <= 100 & x %in% c(1:3)))
                CI.lower <- 0.5*qchisq(alpha, 2*x)/n
              else
                CI.lower <-  max(0, term1 - term2)

              if((n <= 50 & x %in% c(n-1, n-2)) | (n >= 51 & n <= 100 & x %in% c(n-(1:3))))
                CI.upper <- 1 - 0.5*qchisq(alpha, 2*(n-x))/n
              else
                CI.upper <- min(1, term1 + term2)
            }
            , "modified jeffreys" = {
              est <- p.hat
              if(x == n)
                CI.lower <- (alpha/2)^(1/n)
              else {
                if(x <= 1)
                  CI.lower <- 0
                else
                  CI.lower <- qbeta(alpha/2, x+0.5, n-x+0.5)
              }
              if(x == 0)
                CI.upper <- 1 - (alpha/2)^(1/n)
              else{
                if(x >= n-1)
                  CI.upper <- 1
                else
                  CI.upper <- qbeta(1-alpha/2, x+0.5, n-x+0.5)
              }
            }
            , "clopper-pearson" = {
              est <- p.hat
              CI.lower <- qbeta(alpha/2, x, n-x+1)
              CI.upper <- qbeta(1-alpha/2, x+1, n-x)
            }
            , "arcsine" = {
              p.tilde <- (x + 0.375)/(n + 0.75)
              est <- p.tilde
              CI.lower <- sin(asin(sqrt(p.tilde)) - 0.5*kappa/sqrt(n))^2
              CI.upper <- sin(asin(sqrt(p.tilde)) + 0.5*kappa/sqrt(n))^2
            }
            , "logit" = {
              est <- p.hat
              lambda.hat <- log(x/(n-x))
              V.hat <- n/(x*(n-x))
              lambda.lower <- lambda.hat - kappa*sqrt(V.hat)
              lambda.upper <- lambda.hat + kappa*sqrt(V.hat)
              CI.lower <- exp(lambda.lower)/(1 + exp(lambda.lower))
              CI.upper <- exp(lambda.upper)/(1 + exp(lambda.upper))
            }
            , "witting" = {
              set.seed(rand)
              x.tilde <- x + runif(1, min = 0, max = 1)
              pbinom.abscont <- function(q, size, prob){
                v <- trunc(q)
                term1 <- pbinom(v-1, size = size, prob = prob)
                term2 <- (q - v)*dbinom(v, size = size, prob = prob)
                return(term1 + term2)
              }
              qbinom.abscont <- function(p, size, x){
                fun <- function(prob, size, x, p){
                  pbinom.abscont(x, size, prob) - p
                }
                uniroot(fun, interval = c(0, 1), size = size, x = x, p = p)$root
              }
              est <- p.hat
              CI.lower <- qbinom.abscont(1-alpha, size = n, x = x.tilde)
              CI.upper <- qbinom.abscont(alpha, size = n, x = x.tilde)
            }

          , "pratt" = {

                  est <- p.hat

                  if(x==0) {
                    CI.lower <- 0
                    CI.upper <- 1-alpha^(1/n)
                  } else if(x==1) {
                    CI.lower <- 1-(1-alpha/2)^(1/n)
                    CI.upper <- 1-(alpha/2)^(1/n)
                  } else if(x==(n-1)) {
                    CI.lower <- (alpha/2)^(1/n)
                    CI.upper <- (1-alpha/2)^(1/n)
                  } else if(x==n) {
                    CI.lower <- alpha^(1/n)
                    CI.upper <- 1
                  } else {
                    z <- qnorm(1 - alpha/2)

                    A <- ((x+1) / (n-x))^2
                    B <- 81*(x+1)*(n-x)-9*n-8
                    C <- (0-3)*z*sqrt(9*(x+1)*(n-x)*(9*n+5-z^2)+n+1)
                    D <- 81*(x+1)^2-9*(x+1)*(2+z^2)+1
                    E <- 1+A*((B+C)/D)^3
                    CI.upper <- 1/E

                    A <- (x / (n-x-1))^2
                    B <- 81*x*(n-x-1)-9*n-8
                    C <- 3*z*sqrt(9*x*(n-x-1)*(9*n+5-z^2)+n+1)
                    D <- 81*x^2-9*x*(2+z^2)+1
                    E <- 1+A*((B+C)/D)^3
                    CI.lower <- 1/E
                }
                }
          )

    ci <- c( est=est, lwr.ci=CI.lower, upr.ci=CI.upper )
    return(ci)

  }

  # handle vectors
  # which parameter has the highest dimension
  lst <- list(x=x, n=n, conf.level=conf.level, method=method, rand=rand)
  maxdim <- max(unlist(lapply(lst, length)))
  # recycle all params to maxdim
  lgp <- lapply( lst, rep, length.out=maxdim )

  res <- sapply(1:maxdim, function(i) iBinomCI(x=lgp$x[i], n=lgp$n[i], conf.level=lgp$conf.level[i], method=lgp$method[i], rand=lgp$rand[i]))
  rownames(res)[1] <- c("est")

  # colnames(res) <- names(x)
  # colnames(res) <- unlist(lapply(lgp, paste, collapse=" "))

  return(t(res))

}



BinomDiffCI <- function(x1, n1, x2, n2, conf.level = 0.95,
                        method=c("wald", "waldcor", "ac","exact","newcombe","newcombecor","fm","ha")) {
  #   .Wald #1
  #   .Wald (Corrected) #2
  #   .Exact
  #   .Exact (FM Score)
  #   .Newcombe Score #10
  #   .Newcombe Score (Corrected) #11
  #   .Farrington-Manning
  #   .Hauck-Anderson
  # http://www.jiangtanghu.com/blog/2012/09/23/statistical-notes-5-confidence-intervals-for-difference-between-independent-binomial-proportions-using-sas/
  #  Interval estimation for the difference between independent proportions: comparison of eleven methods.

  method <- match.arg(arg = method,
                      choices = c("wald", "waldcor", "ac","exact","newcombe","newcombecor","fm","ha"))

  alpha <- 1 - conf.level
  kappa <- qnorm(1 - alpha/2)

  p1.hat <- x1/n1
  p2.hat <- x2/n2
  est <- p2.hat - p1.hat

  switch(method,
         "wald" = {  vd <- p1.hat*(1-p1.hat)/n1 + p2.hat*(1-p2.hat)/n2
                     term2 <- sign(est) * kappa * sqrt(vd)

                     CI.lower <- max(-1, est - term2)
                     CI.upper <- min(1, est + term2)
         },

         "waldcor" = {
           vd <- p1.hat*(1-p1.hat)/n1 + p2.hat*(1-p2.hat)/n2

           term2 <- sign(est) * kappa * sqrt(vd)
           term2 <- term2 + 0.5 * (1/n1+1/n2)

           CI.lower <- max(-1, est - term2)
           CI.upper <- min(1, est + term2)
         },
         "ac" = {   # Agresti-Caffo

           n1 <- n1+2
           n2 <- n2+2
           x1  <- x1+1
           x2  <- x2+1

           p1.hat <- x1/n1
           p2.hat <- x2/n2
           est1 <-  p2.hat - p1.hat

           vd <- p1.hat*(1-p1.hat)/n1 + p2.hat*(1-p2.hat)/n2

           term2 <- sign(est1) * kappa * sqrt(vd)

           CI.lower <- max(-1, est1 - term2)
           CI.upper <- min(1, est1 + term2)
         } ,
         "newcombe" = {   # Newcombe

           w1 <- BinomCI(x=x1, n=n1, conf.level=conf.level, method="wilson")
           w2 <- BinomCI(x=x2, n=n2, conf.level=conf.level, method="wilson")
           l1 <- w1[2]
           u1 <- w1[3]
           l2 <- w2[2]
           u2 <- w2[3]

           CI.lower <- max(-1, est + kappa * sqrt(l1*(1-l1)/n1 + u2*(1-u2)/n2))
           CI.upper <- min( 1, est - kappa * sqrt(u1*(1-u1)/n1 + l2*(1-l2)/n2))
         }
  )

  ci <- c(est = est, lwr.ci = min(CI.lower, CI.upper), upr.ci = max(CI.lower, CI.upper))
  return(ci)

}



BinomRatioCI <- function(x1, n1, x2, n2, conf.level = 0.95, method = "katz.log", bonf = FALSE, tol = .Machine$double.eps^0.25, R = 1000, r = length(x1)) {

  # source: asbio::ci.prat by Ken Aho <kenaho1 at gmail.com>

  conf <- conf.level

  x <- x1; m <- n1; y <- x2; n <- n2

  indices <- c("adj.log","bailey","boot","katz.log","koopman","noether","sinh-1")
  method <- match.arg(method, indices)


  if(any(c(length(m),length(y),length(n))!= length(x))) stop("x1, n1, x2, and n2 vectors must have equal length")

  alpha <- 1 - conf
  oconf <- conf
  conf <- ifelse(bonf == FALSE, conf, 1 - alpha/r)
  z.star <- qnorm(1 - (1 - conf)/2)
  x2 <- qchisq(conf, 1)

  ci.prat1 <- function(x, m, y, n, conf = 0.95, method = "katz.log", bonf = FALSE){
    if((x > m)|(y > n)) stop("Use correct parameterization for x1, x2, n1, and n2")

    #-------------------------- Adj-log ------------------------------#

    if(method == "adj.log"){
      if((x == m & y == n)){
        rat <- (x/m)/(y/n); x <- m - 0.5; y <- n - 0.5; nrat <- ((x+0.5)/(m+0.5))/((y+0.5)/(n+0.5)); varhat <- (1/(x+0.5)) - (1/(m+0.5)) + (1/(y+0.5)) - (1/(n+0.5))
        CIL <- nrat * exp(-1 * z.star * sqrt(varhat))
        CIU <- nrat * exp(z.star * sqrt(varhat))
      } else if(x == 0 & y == 0){CIL = 0; CIU = Inf; rat = 0; varhat <- (1/(x+0.5)) - (1/(m+0.5)) + (1/(y+0.5)) - (1/(n+0.5))
      }else{
        rat <- (x/m)/(y/n); nrat <- ((x+0.5)/(m+0.5))/((y+0.5)/(n+0.5)); varhat <- (1/(x+0.5)) - (1/(m+0.5)) + (1/(y+0.5)) - (1/(n+0.5))
        CIL <- nrat * exp(-1 * z.star * sqrt(varhat))
        CIU <- nrat * exp(z.star * sqrt(varhat))}
      CI <- c(rat, CIL, CIU)
    }

    #-------------------------------Bailey-----------------------------#

    if(method == "bailey"){
      rat <- (x/m)/(y/n)
      varhat <- ifelse((x == m) & (y == n),(1/(m-0.5)) - (1/(m)) + (1/(n-0.5)) - (1/(n)),(1/(x)) - (1/(m)) + (1/(y)) - (1/(n)))

      p.hat1 <- x/m; p.hat2 <- y/n;
      q.hat1 <- 1 - p.hat1; q.hat2 <- 1 - p.hat2

      if(x == 0 | y == 0){
        xn <- ifelse(x == 0, 0.5, x)
        yn <- ifelse(y == 0, 0.5, y)
        nrat <- (xn/m)/(yn/n)
        p.hat1 <- xn/m; p.hat2 <- yn/n;
        q.hat1 <- 1 - p.hat1; q.hat2 <- 1 - p.hat2
        if(xn == m | yn == n){
          xn <- ifelse(xn == m, m - 0.5, xn)
          yn <- ifelse(yn == n, n - 0.5, yn)
          nrat <- (xn/m)/(yn/n)
          p.hat1 <- xn/m; p.hat2 <- yn/n;
          q.hat1 <- 1 - p.hat1; q.hat2 <- 1 - p.hat2
        }
      }

      if(x == 0 | y == 0){
        if(x == 0 & y == 0){
          rat <- Inf
          CIL <- 0
          CIU <- Inf
        }
        if(x == 0 & y != 0){
          CIL <- 0
          CIU <- nrat * ((1+ z.star * sqrt((q.hat1/xn) + (q.hat2/yn) - (z.star^2 * q.hat1 * q.hat2)/(9 * xn * yn))/3)/((1 - (z.star^2 * q.hat2)/(9 * yn))))^3
        }
        if(y == 0 & x != 0){
          CIU = Inf
          CIL <- nrat * ((1- z.star * sqrt((q.hat1/xn) + (q.hat2/yn) - (z.star^2 * q.hat1 * q.hat2)/(9 * xn * yn))/3)/((1 - (z.star^2 * q.hat2)/(9 * yn))))^3
        }
      }else if(x == m | y == n){
        xn <- ifelse(x == m, m - 0.5, x)
        yn <- ifelse(y == n, n - 0.5, y)
        nrat <- (xn/m)/(yn/n)
        p.hat1 <- xn/m; p.hat2 <- yn/n;
        q.hat1 <- 1 - p.hat1; q.hat2 <- 1 - p.hat2
        CIL <- nrat * ((1- z.star * sqrt((q.hat1/xn) + (q.hat2/yn) - (z.star^2 * q.hat1 * q.hat2)/(9 * xn * yn))/3)/((1 - (z.star^2 * q.hat2)/(9 * yn))))^3
        CIU <- nrat * ((1+ z.star * sqrt((q.hat1/xn) + (q.hat2/yn) - (z.star^2 * q.hat1 * q.hat2)/(9 * xn * yn))/3)/((1 - (z.star^2 * q.hat2)/(9 * yn))))^3
      }else{
        CIL <- rat * ((1- z.star * sqrt((q.hat1/x) + (q.hat2/y) - (z.star^2 * q.hat1 * q.hat2)/(9 * x * y))/3)/((1 - (z.star^2 * q.hat2)/(9 * y))))^3
        CIU <- rat * ((1+ z.star * sqrt((q.hat1/x) + (q.hat2/y) - (z.star^2 * q.hat1 * q.hat2)/(9 * x * y))/3)/((1 - (z.star^2 * q.hat2)/(9 * y))))^3
      }
      CI <- c(rat, CIL, CIU)
    }

    #-------------------------- Boot ------------------------------#

    if(method == "boot"){
      rat <- (x/m)/(y/n)
      if((x == 0 & y == 0)|(x == 0 & y != 0)|(x != 0 & y == 0)){
        if(x == 0 & y == 0) {CIL <- 0;  CIU <- Inf; rat = 0; varhat = NA}
        if(x == 0 & y != 0) {CIL <- 0;  rat <- (x/m)/(y/n); x <- 0.5; nrat <- (x/m)/(y/n)
                             varhat <- (1/x) - (1/m) + (1/y) - (1/n)
                             CIU <- nrat * exp(z.star * sqrt(varhat))}
        if(x != 0 & y == 0) {CIU <- Inf;  rat <- (x/m)/(y/n); y <- 0.5; nrat <- (x/m)/(y/n)
                             varhat <- (1/x) - (1/m) + (1/y) - (1/n)
                             CIL <- nrat * exp(-1 * z.star * sqrt(varhat))}
      } else{
        num.data <- c(rep(1, x), rep(0, m - x))
        den.data <- c(rep(1, y), rep(0, n - y))
        nd <- matrix(ncol = R, nrow = m)
        dd <- matrix(ncol = R, nrow = n)
        brat <- 1:R
        for(i in 1:R){
          nd[,i] <- sample(num.data, m, replace = TRUE)
          dd[,i] <- sample(den.data, n, replace = TRUE)
          brat[i] <- (sum(nd[,i])/m)/(sum(dd[,i])/n)
        }
        alpha <- 1 - conf
        CIU <- quantile(brat, 1 - alpha/2, na.rm = TRUE)
        CIL <- quantile(brat, alpha/2, na.rm = TRUE)
        varhat <- var(brat)
      }
      CI <- c(rat, CIL, CIU)
    }

    #-------------------------- Katz-log ------------------------------#

    if(method == "katz.log"){
      if((x == 0 & y == 0)|(x == 0 & y != 0)|(x != 0 & y == 0)|(x == m & y == n)){
        if(x == 0 & y == 0) {CIL <- 0;  CIU <- Inf; rat = 0; varhat = NA}
        if(x == 0 & y != 0) {CIL <- 0;  rat <- (x/m)/(y/n); x <- 0.5; nrat <- (x/m)/(y/n)
                             varhat <- (1/x) - (1/m) + (1/y) - (1/n)
                             CIU <- nrat * exp(z.star * sqrt(varhat))}
        if(x != 0 & y == 0) {CIU <- Inf;  rat <- (x/m)/(y/n); y <- 0.5; nrat <- (x/m)/(y/n)
                             varhat <- (1/x) - (1/m) + (1/y) - (1/n)
                             CIL <- nrat * exp(-1 * z.star * sqrt(varhat))}
        if(x == m & y == n) {
          rat <- (x/m)/(y/n); x <- m - 0.5; y <- n - 0.5; nrat <- (x/m)/(y/n); varhat <- (1/x) - (1/m) + (1/y) - (1/n); CIL <- nrat * exp(-1 * z.star * sqrt(varhat))
          x <- m - 0.5; y <- n - 0.5; nrat <- (x/m)/(y/n); varhat <- (1/x) - (1/m) + (1/y) - (1/n); CIU <- nrat * exp(z.star * sqrt(varhat))
        }
      } else
      {rat <- (x/m)/(y/n); varhat <- (1/x) - (1/m) + (1/y) - (1/n)
       CIL <- rat * exp(-1 * z.star * sqrt(varhat))
       CIU <- rat * exp(z.star * sqrt(varhat))}
      CI <- c(rat, CIL, CIU)
    }

    #-------------------------- Koopman ------------------------------#

    if(method == "koopman"){

      if(x == 0 & y == 0) {CIL <- 0;  CIU <- Inf; rat = 0; varhat = NA
      } else {

        a1 = n * (n * (n + m) * x + m * (n + x) * (z.star^2))
        a2 = -n * (n * m * (y + x) + 2 * (n + m) * y *
                     x + m * (n + y + 2 * x) * (z.star^2))
        a3 = 2 * n * m * y * (y + x) + (n + m) * (y^2) *
          x + n * m * (y + x) * (z.star^2)
        a4 = -m * (y^2) * (y + x)
        b1 = a2/a1; b2 = a3/a1; b3 = a4/a1
        c1 = b2 - (b1^2)/3;  c2 = b3 - b1 * b2/3 + 2 * (b1^3)/27
        ceta = suppressWarnings(acos(sqrt(27) * c2/(2 * c1 * sqrt(-c1))))
        t1 <- suppressWarnings(-2 * sqrt(-c1/3) * cos(pi/3 - ceta/3))
        t2 <- suppressWarnings(-2 * sqrt(-c1/3) * cos(pi/3 + ceta/3))
        t3 <- suppressWarnings(2 * sqrt(-c1/3) * cos(ceta/3))
        p01 = t1 - b1/3; p02 = t2 - b1/3; p03 = t3 - b1/3
        p0sum = p01 + p02 + p03; p0up = min(p01, p02, p03); p0low = p0sum - p0up - max(p01, p02, p03)


        U <- function(a){
          p.hatf <- function(a){
            (a * (m + y) + x + n - ((a * (m + y) + x + n)^2 - 4 * a * (m + n) * (x + y))^0.5)/(2 * (m + n))
          }
          p.hat <- p.hatf(a)
          (((x - m * p.hat)^2)/(m * p.hat * (1 - p.hat)))*(1 + (m * (a - p.hat))/(n * (1 - p.hat))) - x2
        }

        rat <- (x/m)/(y/n); nrat <- (x/m)/(y/n); varhat <- (1/x) - (1/m) + (1/y) - (1/n)
        if((x == 0) & (y != 0)) {nrat <- ((x + 0.5)/m)/(y/n); varhat <- (1/(x + 0.5)) - (1/m) + (1/y) - (1/n)}
        if((y == 0) & (x != 0)) {nrat <- (x/m)/((y + 0.5)/n); varhat <- (1/x) - (1/m) + (1/(y + 0.5)) - (1/n)}
        if((y == n) & (x == m)) {nrat <- 1; varhat <- (1/(m - 0.5)) - (1/m) + 1/(n - 0.5) - (1/n)}

        La <- nrat * exp(-1 * z.star * sqrt(varhat)) * 1/4
        Lb <- nrat
        Ha <- nrat
        Hb <- nrat * exp(z.star * sqrt(varhat)) * 4

        #----------------------------------------------------------------------------#

        if((x != 0) & (y == 0)) {
          if(x == m){
            CIL = (1 - (m - x) * (1 - p0low)/(y + m - (n + m) * p0low))/p0low
            CIU <- Inf
          }
          else{
            CIL <- uniroot(U, c(La, Lb), tol=tol)$root
            CIU <- Inf
          }
        }

        #------------------------------------------------------------#

        if((x == 0) & (y != n)) {
          CIU <- uniroot(U, c(Ha, Hb), tol=tol)$root
          CIL <- 0
        }

        #------------------------------------------------------------#

        if(((x == m)|(y == n)) & (y != 0)){


          if((x == m)&(y == n)){
            U.0 <- function(a){if(a <= 1) {m * (1 - a)/a - x2}
                               else{(n * (a - 1)) - x2}
            }
            CIL <- uniroot(U.0, c(La, rat), tol = tol)$root
            CIU <- uniroot(U.0, c(rat, Hb), tol = tol)$root
          }

          #------------------------------------------------------------#

          if((x == m) & (y != n)){

            phat1 = x/m; phat2 = y/n
            phihat = phat2/phat1
            phiu = 1.1 * phihat
            r = 0
            while (r >= -z.star) {
              a = (m + n) * phiu
              b = -((x + n) * phiu + y + m)
              c = x + y
              p1hat = (-b - sqrt(b^2 - 4 * a * c))/(2 * a)
              p2hat = p1hat * phiu
              q2hat = 1 - p2hat
              var = (m * n * p2hat)/(n * (phiu - p2hat) +
                                       m * q2hat)
              r = ((y - n * p2hat)/q2hat)/sqrt(var)
              phiu1 = phiu
              phiu = 1.0001 * phiu1
            }
            CIU = (1 - (m - x) * (1 - p0up)/(y + m - (n + m) * p0up))/p0up
            CIL = 1/phiu1
          }

          #------------------------------------------------------------#

          if((y == n) & (x != m)){
            p.hat2 = y/n; p.hat1 = x/m; phihat = p.hat1/p.hat2
            phil = 0.95 * phihat; r = 0
            if(x != 0){
              while(r <= z.star) {
                a = (n + m) * phil
                b = -((y + m) * phil + x + n)
                c = y + x
                p1hat = (-b - sqrt(b^2 - 4 * a * c))/(2 * a)
                p2hat = p1hat * phil
                q2hat = 1 - p2hat
                var = (n * m * p2hat)/(m * (phil - p2hat) +
                                         n * q2hat)
                r = ((x - m * p2hat)/q2hat)/sqrt(var)
                CIL = phil
                phil = CIL/1.0001
              }
            }

            phiu = 1.1 * phihat

            if(x == 0){CIL = 0; phiu <- ifelse(n < 100, 0.01, 0.001)}

            r = 0
            while(r >= -z.star) {
              a = (n + m) * phiu
              b = -((y + m) * phiu + x  + n)
              c = y + x
              p1hat = (-b - sqrt(b^2 - 4 * a * c))/(2 * a)
              p2hat = p1hat * phiu
              q2hat = 1 - p2hat
              var = (n * m * p2hat)/(m * (phiu - p2hat) +
                                       n * q2hat)
              r = ((x  - m * p2hat)/q2hat)/sqrt(var)
              phiu1 = phiu
              phiu = 1.0001 * phiu1
            }
            CIU <- phiu1
          }
        } else if((y != n) & (x != m) & (x != 0) & (y != 0)){
          CIL <- uniroot(U, c(La, Lb), tol=tol)$root
          CIU <- uniroot(U, c(Ha, Hb), tol=tol)$root
        }
      }
      CI <- c(rat, CIL, CIU)
    }

    #-------------------------- Noether ------------------------------#

    if(method == "noether"){
      if((x == 0 & y == 0)|(x == 0 & y != 0)|(x != 0 & y == 0)|(x == m & y == n)){
        if(x == 0 & y == 0) {CIL <- 0;  CIU <- Inf; rat = 0; se.hat <- NA; varhat = NA}
        if(x == 0 & y != 0) {rat <- (x/m)/(y/n); CIL <- 0;  x <- 0.5
                             nrat <- (x/m)/(y/n); se.hat <- nrat * sqrt((1/x) - (1/m) + (1/y) - (1/n))
                             CIU <- nrat + z.star * se.hat}
        if(x != 0 & y == 0) {rat <- Inf; CIU <- Inf;  y <- 0.5
                             nrat <- (x/m)/(y/n); se.hat <- nrat * sqrt((1/x) - (1/m) + (1/y) - (1/n))
                             CIL <- nrat - z.star * se.hat}
        if(x == m & y == n) {
          rat <- (x/m)/(y/n); x <- m - 0.5; y <- n - 0.5; nrat <- (x/m)/(y/n); se.hat <- nrat * sqrt((1/x) - (1/m) + (1/y) - (1/n))
          CIU <- nrat + z.star * se.hat
          CIL <- nrat - z.star * se.hat
        }
      } else
      {
        rat <- (x/m)/(y/n)
        se.hat <- rat * sqrt((1/x) - (1/m) + (1/y) - (1/n))
        CIL <- rat - z.star * se.hat
        CIU <- rat + z.star * se.hat
      }
      varhat <- ifelse(is.na(se.hat), NA, se.hat^2)
      CI <- c(rat, max(0,CIL), CIU)
    }

    #------------------------- sinh-1 -----------------------------#

    if(method == "sinh-1"){

      if((x == 0 & y == 0)|(x == 0 & y != 0)|(x != 0 & y == 0)|(x == m & y == n)){
        if(x == 0 & y == 0) {CIL <- 0;  CIU <- Inf; rat = 0; varhat = NA}
        if(x == 0 & y != 0) {rat <- (x/m)/(y/n); CIL <- 0;  x <- z.star
                             nrat <- (x/m)/(y/n); varhat <- 2 * asinh((z.star/2)*sqrt(1/x + 1/y - 1/m - 1/n))
                             CIU <- exp(log(nrat) + varhat)}
        if(x != 0 & y == 0) {rat = Inf; CIU <- Inf;  y <- z.star
                             nrat <- (x/m)/(y/n); varhat <- 2 * asinh((z.star/2)*sqrt(1/x + 1/y - 1/m - 1/n))
                             CIL <- exp(log(nrat) - varhat)}
        if(x == m & y == n) {
          rat <- (x/m)/(y/n); x <- m - 0.5; y <- n - 0.5; nrat <- (x/m)/(y/n); varhat <- 2 * asinh((z.star/2)*sqrt(1/x + 1/y - 1/m - 1/n))
          CIL <- exp(log(nrat) - varhat)
          CIU <- exp(log(nrat) + varhat)
        }
      } else
      {rat <- (x/m)/(y/n); varhat <- 2 * asinh((z.star/2)*sqrt(1/x + 1/y - 1/m - 1/n))
       CIL <- exp(log(rat) - varhat)
       CIU <- exp(log(rat) + varhat)
      }
      CI <- c(rat, CIL, CIU)
    }

    #------------------------Results ------------------------------#

    res <- list(CI = CI, varhat = varhat)
    res
  }

  CI <- matrix(ncol = 3, nrow = length(x1))
  vh <- rep(NA, length(x1))

  for(i in 1 : length(x1)){
    temp <- ci.prat1(x = x[i], m = m[i], y = y[i], n = n[i], conf = conf, method = method, bonf = bonf)
    CI[i,] <- temp$CI
    vh[i] <- temp$varhat
  }

  CI <- data.frame(CI)
  if(length(x1) == 1) row.names(CI) <- ""
  head <- paste(paste(as.character(oconf * 100),"%",sep=""), c("Confidence interval for ratio of binomial proportions"))
  if(method == "adj.log")head <- paste(head,"(method=adj-log)")
  if(method == "bailey")head <- paste(head,"(method=Bailey)")
  if(method == "boot")head <- paste(head,"(method=percentile bootstrap)")
  if(method == "katz.log")head <- paste(head,"(method=Katz-log)")
  if(method == "koopman")head <- paste(head,"(method=Koopman)")
  if(method == "noether")head <- paste(head,"(method=Noether)")
  if(method == "sinh")head <- paste(head,"(method=sinh^-1)")

  if(bonf == TRUE)head <- paste(head, "\n Bonferroni simultaneous intervals, r = ", bquote(.(r)),
                                "\n Marginal confidence = ", bquote(.(conf)), "\n", sep = "")

  ends <- c("Estimate", paste(as.character(c((1-oconf)/2, 1-((1-oconf)/2))*100), "%", sep=""))
  # res <- list(varhat = vh, ci = CI, ends = ends, head = head)
  # class(res) <- "ci"
  res <- data.matrix(CI)
  dimnames(res) <- list(NULL, c("est","lwr.ci","upr.ci"))

  res
}



MultinomCI <- function(x, conf.level = 0.95, method = c("sisonglaz", "cplus1", "goodman")) {

  # Code mainly by:
  # Pablo J. Villacorta Iglesias <pjvi@decsai.ugr.es>\n
  # Department of Computer Science and Artificial Intelligence, University of Granada (Spain)

  .moments <- function(c, lambda){

    a <- lambda + c
    b <- lambda - c
    if(b < 0) b <- 0
    if(b > 0) den <- ppois(a, lambda) - ppois(b-1, lambda)
    if(b == 0) den <- ppois(a,lambda)

    mu <- mat.or.vec(4,1)
    mom <- mat.or.vec(5,1)
    for(r in 1:4){
      poisA <- 0
      poisB <- 0

      if((a-r) >=0){ poisA <- ppois(a,lambda)-ppois(a-r,lambda) }
      if((a-r) < 0){ poisA <- ppois(a,lambda) }
      if((b-r-1) >=0){ poisB <- ppois(b-1,lambda)-ppois(b-r-1,lambda) }
      if((b-r-1) < 0 && (b-1)>=0){ poisB <- ppois(b-1,lambda) }
      if((b-r-1) < 0 && (b-1) < 0){ poisB <- 0 }

      mu[r] <- (lambda^r)*(1-(poisA-poisB)/den)
    }
    mom[1] <- mu[1]
    mom[2] <- mu[2] + mu[1] - mu[1]^2
    mom[3] <- mu[3] + mu[2]*(3-3*mu[1]) + (mu[1]-3*mu[1]^2+2*mu[1]^3)
    mom[4] <- mu[4] + mu[3]*(6-4*mu[1]) + mu[2]*(7-12*mu[1]+6*mu[1]^2)+mu[1]-4*mu[1]^2+6*mu[1]^3-3*mu[1]^4
    mom[5] <- den

    return(mom)

  }

  .truncpoi <- function(c, x, n, k){

    m <- matrix(0, k, 5)

    for(i in 1:k){
      lambda <- x[i]
      mom <- .moments(c, lambda)
      for(j in 1:5){ m[i,j] <- mom[j] }
    }
    for(i in 1:k){ m[i, 4] <- m[i, 4] - 3 * m[i, 2]^2 }

    s <- colSums(m)
    s1 <- s[1]
    s2 <- s[2]
    s3 <- s[3]
    s4 <- s[4]

    probn <- 1/(ppois(n,n)-ppois(n-1,n))
    z <- (n-s1)/sqrt(s2)
    g1 <- s3/(s2^(3/2))
    g2 <- s4/(s2^2)
    poly <- 1 + g1*(z^3-3*z)/6 + g2*(z^4-6*z^2+3)/24
    + g1^2*(z^6-15*z^4 + 45*z^2-15)/72
    f <- poly*exp(-z^2/2)/(sqrt(2)*gamma(0.5))

    probx <- 1
    for(i in 1:k){ probx <- probx * m[i,5]  }

    return(probn * probx * f / sqrt(s2))
  }


  n <- sum(x, na.rm=TRUE)
  k <- length(x)
  p <- x/n

  if (missing(method)) method <- "sisonglaz"

  method <- match.arg(arg = method, choices = c("sisonglaz", "cplus1", "goodman"))
  if(method == "goodman") {

    q.chi <- qchisq(conf.level, k - 1)
    lci <- (q.chi + 2*x - sqrt(q.chi*(q.chi + 4*x*(n-x)/n))) / (2*(n+q.chi))
    uci <- (q.chi + 2*x + sqrt(q.chi*(q.chi + 4*x*(n-x)/n))) / (2*(n+q.chi))

    res <- cbind(est=p, lwr.ci=lci, upr.ci=uci)

  } else {  # sisonglaz, cplus1

    const <- 0
    pold <- 0

    for(cc in 1:n){
      poi <- .truncpoi(cc, x, n, k)
      if(poi > conf.level && pold < conf.level) {
        const <- cc
        break
      }
      pold <- poi
    }

    delta <- (conf.level - pold)/(poi - pold)
    const <- const - 1

    if(method == "sisonglaz") {
      res <- cbind(est = p, lwr.ci = pmax(0, p - const/n), upr.ci = pmin(1, p + const/n + 2*delta/n))

    } else if(method == "cplus1") {
      res <- cbind(est = p, lwr.ci = pmax(0, p - const/n - 1/n), upr.ci = pmin(1,p + const/n + 1/n))
    }
  }

  return(res)
}



# Confidence Intervals for Poisson mean

PoissonCI <- function(x, n = 1, conf.level = 0.95,
                      method = c("exact","score", "wald")) {

  iPoissonCI <- function(x, n = 1, conf.level = 0.95,
                      method = c("exact","score", "wald")) {

    # ref:  http://www.ijmo.org/papers/189-S083.pdf but wacklig!!!
    # http://www.math.montana.edu/~rjboik/classes/502/ci.pdf
    # http://www.ine.pt/revstat/pdf/rs120203.pdf
    # http://www.pvamu.edu/include/Math/AAM/AAM%20Vol%206,%20Issue%201%20(June%202011)/06_%20Kibria_AAM_R308_BK_090110_Vol_6_Issue_1.pdf

    # see also:   pois.conf.int {epitools}

    if(missing(method)) method <- "score"

    if(length(conf.level) != 1)  stop("'conf.level' has to be of length 1 (confidence level)")
    if(conf.level < 0.5 | conf.level > 1)  stop("'conf.level' has to be in [0.5, 1]")

    alpha <- 1 - conf.level
    z <- qnorm(1-alpha/2)

    lambda <- x/n

    switch( match.arg(arg=method, choices=c("exact","score", "wald"))
            , "exact" = {
              ci <- poisson.test(x, n, conf.level = conf.level)$conf.int
              lwr.ci <- ci[1]
              upr.ci <- ci[2]
            }
            , "score" = {
              term1 <- (x + z^2/2)/n
              term2 <- z * n^-0.5 * sqrt(x/n + z^2/(4*n))
              lwr.ci <- term1 - term2
              upr.ci <- term1 + term2
            }
            , "wald" = {
              term2 <- z*sqrt(lambda/n)
              lwr.ci <- lambda - term2
              upr.ci <- lambda + term2
            }
  # agresti-coull is the same as score
  #             , "agresti-coull" = {
  #               lwr.ci <- lambda + z^2/(2*n) - z*sqrt(lambda/n + z^2/(4*n^2))
  #               upr.ci <- lambda + z^2/(2*n) + z*sqrt(lambda/n + z^2/(4*n^2))
  #
  #             }
  # garwood is the same as exact, check that!!
  #             , "garwood" = {
  #               lwr.ci <- qchisq((1 - conf.level)/2, 2*x)/(2*n)
  #               upr.ci <- qchisq(1 - (1 - conf.level)/2, 2*(x + 1))/(2*n)
  #             }
    )

    ci <- c( est=lambda, lwr.ci=lwr.ci, upr.ci=upr.ci )
    return(ci)
  }

  # handle vectors
  # which parameter has the highest dimension
  lst <- list(x=x, n=n, conf.level=conf.level, method=method)
  maxdim <- max(unlist(lapply(lst, length)))
  # recycle all params to maxdim
  lgp <- lapply( lst, rep, length.out=maxdim )

  res <- sapply(1:maxdim, function(i) iPoissonCI(x=lgp$x[i], n=lgp$n[i], conf.level=lgp$conf.level[i], method=lgp$method[i]))
  rownames(res)[1] <- c("est")
  colnames(res) <- names(x)

  return(t(res))

}



# ordered interface for the median
median.factor <- function(x, na.rm = FALSE) {

  # Answered by Hong Ooi on 2011-10-28T00:37:08-04:00
  # http://www.rqna.net/qna/nuiukm-idiomatic-method-of-finding-the-median-of-an-ordinal-in-r.html

  if(is.ordered(x)) return(NA)

  if(na.rm) x <- na.omit(x)
  if(any(is.na(x))) return(NA)

  levs <- levels(x)
  m <- median(as.integer(x), na.rm = na.rm)
  if(floor(m) != m)
  {
    warning("Median is between two values; using the first one")
    m <- floor(m)
  }
  ordered(m, labels = levs, levels = seq_along(levs))
}


# Konfidenzintervall fuer den Median

MedianCI <- function(x, conf.level=0.95, na.rm=FALSE, method=c("exact","boot"), R=999) {
  if(na.rm) x <- na.omit(x)

  # alte Version, ziemlich grosse Unterschiede zu wilcox.test:
  # Bosch: Formelsammlung Statistik (bei Markus Naepflin), S. 95
  # x <- sort(x)
  # return( c(
  # x[ qbinom(alpha/2,length(x),0.5) ], ### lower limit
  # x[ qbinom(1-alpha/2,length(x),0.5) ] ### upper limit
  # ) )

  switch( match.arg(arg=method, choices=c("exact","boot"))
          , "exact" = { # this is the SAS-way to do it
            # https://stat.ethz.ch/pipermail/r-help/2003-September/039636.html
            r <- SignTest(x)$conf.int
          }
          , "boot" = {
              boot.med <- boot(x, function(x, d) median(x[d], na.rm=na.rm), R=R)
              r <- boot.ci(boot.med, conf=conf.level, type="basic")[[4]][4:5]
          } )

  med <- median(x, na.rm=na.rm)
  if(is.na(med)) {   # do not report a CI if the median is not defined...
    r <- rep(NA, 3)
  } else {
    r <- c(median=med, r)
  }
  names(r) <- c("median","lwr.ci","upr.ci")
  return( r )

}



# standard error of mean
MeanSE <- function(x, sd = NULL, na.rm = FALSE) {
  if(na.rm) x <- na.omit(x)
  if(is.null(sd)) s <- sd(x)
  s/sqrt(length(x))
}



MeanCI <- function (x, sd = NULL, trim = 0, method = c("classic", "boot"),
                    conf.level = 0.95, na.rm = FALSE, ...) {

  if (na.rm) x <- na.omit(x)

  winvar <- function(x, trim) {
    n <- length(x)
    # calculate the winsorized variance of x
    trn <- floor(trim * n) + 1

# new 17.2.2015:
    minval <- sort(x, partial = trn)[trn]
    maxval <- sort(x, partial = max((n - trn + 1), 1))[max((n - trn + 1), 1)]
    winvar <- var(Winsorize(x, minval = minval, maxval = maxval))

# This was an overkill, we need only the n-thest value here:
# winvar <- var(Winsorize(x, minval=max(Small(x, trn)), maxval=min(Large(x, trn))))
#
    # degrees of freedom
    DF <- n - 2*(trn-1) - 1
    return(c(var=winvar, DF=DF))
  }

  method <- match.arg(method, c("classic", "boot"))
  if(method == "classic"){
    if(trim != 0) {
      # see: http://dornsife.usc.edu/assets/sites/239/docs/Rallfun-v27.txt
      #      http://www.psychology.mcmaster.ca/bennett/boot09/rt2.pdf

      wvar <- winvar(x, trim)
      # the standard error
      se <- sqrt(wvar["var"]) / ((1 - 2*trim) * sqrt(length(x)))

      res <- mean(x, trim = trim) + c(0, -1, 1) * qt(1-(1-conf.level)/2, wvar["DF"]) * se
      names(res) <- c("mean", "lwr.ci", "upr.ci")

    } else {
      if(is.null(sd)) {
        a <- qt(p = (1 - conf.level)/2, df = length(x) - 1) * sd(x)/sqrt(length(x))
      } else {
        a <- qnorm(p = (1 - conf.level)/2) * sd/sqrt(length(x))
      }
      res <- c(mean = mean(x), lwr.ci = mean(x) + a, upr.ci = mean(x) - a)
    }

  } else {

    # see: http://www.psychology.mcmaster.ca/bennett/boot09/percentileT.pdf
    # this might contain an erroneuous calculation of boot variance...

    btype <- InDots(..., arg="type", default="basic")

    # we need separate functions for trimmed means and normal means
    if(trim != 0) {
      boot.fun <- boot(x,
                       function(x, i){
                         # this is according to the example in boot.ci
                         m <- mean(x[i], na.rm = FALSE, trim = trim)
                         n <- length(i)
                         v <- winvar(x, trim)/((1-2*trim)*sqrt(length(x)))^2
                         c(m, v)
                       },
                       R=InDots(..., arg="R", default=999),
                       parallel=InDots(..., arg="parallel", default="no"))

    } else {
      boot.fun <- boot(x,
                       function(x, i){
                         # this is according to the example in boot.ci
                         m <- mean(x[i], na.rm = FALSE)
                         n <- length(i)
                         v <- (n-1) * var(x[i]) / n^2
                         # v <- (sd(x[i]) / sqrt(n))^2  # following Bennet
                         c(m, v)
                         # IMPORTANT: boot.ci requires the estimated VARIANCE of the statistic
                         # pop sd estimated from bootstrapped sample
                       },
                       R=InDots(..., arg="R", default=999),
                       parallel=InDots(..., arg="parallel", default="no"))
    }
    ci <- boot.ci(boot.fun, conf=conf.level, type=btype)

    if(btype == "norm"){
      res <- c(mean=boot.fun$t0[1], lwr.ci=ci[[4]][2], upr.ci=ci[[4]][3])
    } else {
      res <- c(mean=boot.fun$t0[1], lwr.ci=ci[[4]][4], upr.ci=ci[[4]][5])
    }
  }

  return(res)
}


MeanDiffCI <- function(x, ...){
  UseMethod("MeanDiffCI")
}



MeanDiffCI.formula <- function (formula, data, subset, na.action, ...) {

  # this is from t.test.formula

  if (missing(formula) || (length(formula) != 3L) || (length(attr(terms(formula[-2L]),
                                                                  "term.labels")) != 1L))
    stop("'formula' missing or incorrect")
  m <- match.call(expand.dots = FALSE)
  if (is.matrix(eval(m$data, parent.frame())))
    m$data <- as.data.frame(data)
  m[[1L]] <- as.name("model.frame")
  m$... <- NULL
  mf <- eval(m, parent.frame())
  DNAME <- paste(names(mf), collapse = " by ")
  names(mf) <- NULL
  response <- attr(attr(mf, "terms"), "response")
  g <- factor(mf[[-response]])
  if (nlevels(g) != 2L)
    stop("grouping factor must have exactly 2 levels")
  DATA <- setNames(split(mf[[response]], g), c("x", "y"))

  y <- DoCall("MeanDiffCI", c(DATA, list(...)))

  #   y$data.name <- DNAME
  #   if (length(y$estimate) == 2L)
  #     names(y$estimate) <- paste("mean in group", levels(g))
  y
}



MeanDiffCI.default <- function (x, y, method = c("classic", "norm","basic","stud","perc","bca"),
                    conf.level = 0.95, na.rm = FALSE, R=999, ...) {

  if (na.rm) {
    x <- na.omit(x)
    y <- na.omit(y)
  }
  method <- match.arg(method, c("classic", "norm","basic","stud","perc","bca"))
  if(method == "classic"){
      a <- t.test(x, y, conf.level = conf.level)
      res <- c(meandiff = mean(x) - mean(y), lwr.ci = a$conf.int[1], upr.ci = a$conf.int[2])

  } else {

    diff.means <- function(d, f)
    {    n <- nrow(d)
         gp1 <- 1:table(as.numeric(d[,2]))[1]
         m1 <- sum(d[gp1,1] * f[gp1])/sum(f[gp1])
         m2 <- sum(d[-gp1,1] * f[-gp1])/sum(f[-gp1])
         m1 - m2
    }

    m <- cbind(c(x,y), c(rep(1,length(x)), rep(2,length(y))))

    boot.fun <- boot(m, diff.means, R=R, stype="f", strata = m[,2])
    ci <- boot.ci(boot.fun, conf=conf.level, type=method)
    if(method == "norm"){
      res <- c(meandiff=boot.fun$t0, lwr.ci=ci[[4]][2], upr.ci=ci[[4]][3])
    } else {
      res <- c(meandiff=boot.fun$t0, lwr.ci=ci[[4]][4], upr.ci=ci[[4]][5])
    }
  }

  return(res)
}


# CohenEffectSize <- function(x){

# (C) Antti Arppe 2007-2011
# E-mail: antti.arppe@helsinki.fi

# Cohen's Effect Size (1988)
# e0 <- matrix(,ctable.rows,ctable.cols)
# for(i in 1:ctable.rows)
# for(j in 1:ctable.cols)
# e0[i,j] <- sum.row[i]*sum.col[j]/N
# p0 <- e0/N
# p1 <- ctable/N
# effect.size <- sqrt(sum(((p1-p0)^2)/p0))
# noncentrality <- N*(effect.size^2)
# d.f=(ctable.rows-1)*(ctable.cols-1)
# beta <- pchisq(qchisq(alpha,df=d.f,lower.tail=FALSE),df=d.f,ncp=noncentrality)
# power <- 1-beta

# return(effect.size)
# }


CohenD <- function(x, y=NULL, pooled = TRUE, correct = FALSE, conf.level = NA, na.rm = FALSE) {

  if (na.rm) {
    x <- na.omit(x)
    if(!is.null(y)) y <- na.omit(y)
  }

  if(is.null(y)){   # one sample Cohen d
    d <- mean(x) / sd(x)
    n <- length(x)
    if(!is.na(conf.level)){
      # reference: Smithson Confidence Intervals pp. 36:
      ci <- .nctCI(d / sqrt(n), df = n-1, conf = conf.level)
      res <- c(d=d, lwr.ci=ci[1]/sqrt(n), upr.ci=ci[3]/sqrt(n))
    } else {
      res <- d
    }
  } else {

    meanx <- mean(x)
    meany <- mean(y)
#     ssqx <- sum((x - meanx)^2)
#     ssqy <- sum((y - meany)^2)
    nx <- length(x)
    ny <- length(y)

    DF <- nx + ny - 2
    d <- (meanx - meany)

    if(pooled){
      d <- d / sqrt(((nx - 1) * var(x) + (ny - 1) * var(y)) / DF)
    }else{
      d <- d / sd(c(x, y))
    }

    #  if(unbiased) d <- d * gamma(DF/2)/(sqrt(DF/2) * gamma((DF - 1)/2))

    if(correct){  # "Hedges's g"
      # Hedges, L. V. & Olkin, I. (1985). Statistical methods for meta-analysis. Orlando, FL: Academic Press.
      d <- d * (1 - 3 / ( 4 * (nx + ny) - 9))
    }

    if(!is.na(conf.level)) {
      # old:
      # The Handbook of Research Synthesis and Meta-Analysis (Cooper, Hedges, & Valentine, 2009)
      ## p 238
      # ci <- d + c(-1, 1) * sqrt(((nx+ny) / (nx*ny) + .5 * d^2 / DF) * ((nx + ny)/DF)) * qt((1 - conf.level) / 2, DF)

      # supposed to be better, Smithson's version:
      ci <- .nctCI(d / sqrt(nx*ny/(nx+ny)), df = DF, conf = conf.level)
      res <- c(d=d, lwr.ci=ci[1]/sqrt(nx*ny/(nx+ny)), upr.ci=ci[3]/sqrt(nx*ny/(nx+ny)))

      res <- c(d=d, lwr.ci=ci[1], upr.ci=ci[2])
    } else {
      res <- d
    }
  }

  ## Cohen, J. (1992). A power primer. Psychological Bulletin, 112, 155-159. Crow, E. L. (1991).
  attr(res, "magnitude") <- c("negligible","small","medium","large")[findInterval(abs(d), c(0.2, 0.5, 0.8)) + 1]

  return(res)

}



.nctCI <- function(tval.1, df, conf) {

  # Function for finding the upper and lower confidence limits for the noncentrality from noncentral t distributions.
  # Especially helpful when forming confidence intervals around the standardized effect size, Cohen's d.

  ###################################################################################################################
  # The following code was adapted from code written by Michael Smithson:
  # Australian National University, sometime around the early part of October, 2001
  # Adapted by Joe Rausch & Ken Kelley: University of Notre Dame, in January 2002.
  # Available at: JRausch@nd.edu & KKelley@nd.edu
  ###################################################################################################################


  # tval.1 is the observed t value, df is the degrees of freedom (group size need not be equal), and conf is simply 1 - alpha

  #         Result <- matrix(NA,1,4)
  tval <- abs(tval.1)


  ############################This part Finds the Lower bound for the confidence interval###########################
  ulim <- 1 - (1-conf)/2

  # This first part finds a lower value from which to start.
  lc <- c(-tval,tval/2,tval)
  while(pt(tval, df, lc[1])<ulim)    {
    lc <- c(lc[1]-tval,lc[1],lc[3])
  }

  # This next part finds the lower limit for the ncp.
  diff <- 1
  while(diff > .00000001)    {
    if(pt(tval, df, lc[2]) <ulim)
      lc <- c(lc[1],(lc[1]+lc[2])/2,lc[2])
    else lc <- c(lc[2],(lc[2]+lc[3])/2,lc[3])
    diff <- abs(pt(tval,df,lc[2]) - ulim)
    ucdf <- pt(tval,df,lc[2])
  }
  res.1 <- ifelse(tval.1 >= 0,lc[2],-lc[2])

  ############################This part Finds the Upper bound for the confidence interval###########################
  llim <- (1-conf)/2

  # This first part finds an upper value from which to start.
  uc <- c(tval,1.5*tval,2*tval)
  while(pt(tval,df,uc[3])>llim)   {
    uc <- c(uc[1],uc[3],uc[3]+tval)
  }

  # This next part finds the upper limit for the ncp.
  diff <- 1
  while(diff > .00000001)         {
    if(pt(tval,df,uc[2])<llim)
      uc <- c(uc[1],(uc[1]+uc[2])/2,uc[2])
    else uc <- c(uc[2],(uc[2]+uc[3])/2,uc[3])
    diff <- abs(pt(tval,df,uc[2]) - llim)
    lcdf <- pt(tval,df,uc[2])
  }
  res <- ifelse(tval.1 >= 0,uc[2],-uc[2])


  #################################This part Compiles the results into a matrix#####################################

  return(c(lwr.ci=min(res, res.1), lprob=ucdf, upr.ci=max(res, res.1), uprob=lcdf))

  #        Result[1,1] <- min(res,res.1)
  #         Result[1,2] <- ucdf
  #         Result[1,3] <- max(res,res.1)
  #         Result[1,4] <- lcdf
  # dimnames(Result) <- list("Values", c("Lower.Limit", "Prob.Low.Limit", "Upper.Limit", "Prob.Up.Limit"))
  #         Result
}


CoefVar <- function(x, unbiased = FALSE, conf.level = NA, na.rm = FALSE) {

  if(na.rm) x <- na.omit(x)

  res <- sd(x) / mean(x)
  n <- length(x)
  if(unbiased) {
    res <- res * ((1 - (1/(4*(n-1))) + (1/n) * res^2)+(1/(2*(n-1)^2)))
  }


  if(!is.na(conf.level)){
    ci <- .nctCI(sqrt(n)/res, df = n-1, conf = conf.level)
    res <- c(est=res, low.ci= unname(sqrt(n)/ci["upr.ci"]), upr.ci= unname(sqrt(n)/ci["lwr.ci"]))
  }

  return(res)

}

# aus agricolae: Variations Koeffizient aus aov objekt
#
# CoefVar.aov <- function(x){
#   return(sqrt(sum(x$residual^2) / x$df.residual) / mean(x$fitted.values))
# }


VarCI <- function (x, method = c("classic", "norm","basic","stud","perc","bca"),
                    conf.level = 0.95, na.rm = FALSE, R=999) {

  if (na.rm) x <- na.omit(x)
  method <- match.arg(method, c("classic", "norm","basic","stud","perc","bca"))

  if(method == "classic"){
    df <- length(x) - 1
    v <- var(x)
    res <- c (var = v, lwr.ci = df * v/qchisq((1 - conf.level)/2, df, lower.tail = FALSE)
              , upr.ci = df * v/qchisq((1 - conf.level)/2, df) )

  } else {
    boot.fun <- boot(x, function(x, d) var(x[d], na.rm=na.rm), R=R)
    ci <- boot.ci(boot.fun, conf=conf.level, type=method)
    if(method == "norm"){
      res <- c(mean=boot.fun$t0, lwr.ci=ci[[4]][2], upr.ci=ci[[4]][3])
    } else {
      res <- c(mean=boot.fun$t0, lwr.ci=ci[[4]][4], upr.ci=ci[[4]][5])
    }
  }

  return(res)
}

## stats: strata sampling ----------------

Strata <- function (x, stratanames = NULL, size = 1,
                    method = c("srswor", "srswr", "poisson", "systematic"),
                    pik, description = FALSE) {

  method <- match.arg(method, c("srswor", "srswr", "poisson", "systematic"))

  # find non factors in stratanames
  factor_fg <- unlist(lapply(x[, stratanames, drop=FALSE], is.factor))
  # factorize nonfactors, get their levels and combine with levels of existing factors
  lvl <- c(lapply(lapply(x[,names(which(!factor_fg)), drop=FALSE], factor), levels)
           , lapply(x[,names(which(factor_fg)), drop=FALSE], levels))

  # get the stratanames in the given order
  strat <- expand.grid(lvl[stratanames])
  strat$stratum <- factor(1:nrow(strat))

  # set the size for the strata to sample
  strat$size <- rep(size, length.out=nrow(strat))

  # prepare the sample
  x <- merge(x, strat)
  x$id <- 1:nrow(x)
  n <- table(x$stratum)

  if(method %in% c("srswor", "srswr")) {
    res <- do.call(rbind,
                   lapply(split(x, x$stratum),
                          function(z){
                            if(nrow(z)>0){
                              idx <- sample(x=nrow(z), size=z$size[1], replace=(method=="srswr"))
                              z[idx,]
                            } else {
                              z
                            }
                          }
                   )
    )
  } else if(method == "poisson") {

    # still to implement!!!  *********************
    res <- do.call(rbind,
                   lapply(split(x, x$stratum),
                          function(z){
                            if(nrow(z)>0){
                              idx <- sample(x=nrow(z), size=z$size[1], replace=(method=="srswr"))
                              z[idx,]
                            } else {
                              z
                            }
                          }
                   )
    )
  } else if(method == "systematic") {

    # still to implement!!!  *********************
    res <- do.call(rbind,
                   lapply(split(x, x$stratum),
                          function(z){
                            if(nrow(z)>0){
                              idx <- sample(x=nrow(z), size=z$size[1], replace=(method=="srswr"))
                              z[idx,]
                            } else {
                              z
                            }
                          }
                   )
    )
  }

  return(res)

}



# Strata <- function (data, stratanames = NULL, size,
#                     method = c("srswor", "srswr", "poisson", "systematic"),
#                     pik, description = FALSE)
# {
#
# #  Author: Yves Tille <yves.tille@unine.ch>, Alina Matei <alina.matei@unine.ch>
# #  source: library(sampling)
#
#   inclusionprobabilities <- function (a, n)
#   {
#     nnull = length(a[a == 0])
#     nneg = length(a[a < 0])
#     if (nnull > 0)
#       warning("there are zero values in the initial vector a\n")
#     if (nneg > 0) {
#       warning("there are ", nneg, " negative value(s) shifted to zero\n")
#       a[(a < 0)] = 0
#     }
#     if (identical(a, rep(0, length(a))))
#       pik1 = a
#     else {
#       pik1 = n * a/sum(a)
#       pik = pik1[pik1 > 0]
#       list1 = pik1 > 0
#       list = pik >= 1
#       l = length(list[list == TRUE])
#       if (l > 0) {
#         l1 = 0
#         while (l != l1) {
#           x = pik[!list]
#           x = x/sum(x)
#           pik[!list] = (n - l) * x
#           pik[list] = 1
#           l1 = l
#           list = (pik >= 1)
#           l = length(list[list == TRUE])
#         }
#         pik1[list1] = pik
#       }
#     }
#     pik1
#   }
#
#   srswor <- function (n, N)
#   {
#     s <- rep(0, times = N)
#     s[sample(N, n)] <- 1
#     s
#   }
#
#   srswr <-  function (n, N)
# #    as.vector(rmultinom(1, n, rep(n/N, times = N)))
#     if(n==0) rep(0, N) else as.vector(rmultinom(1, n, rep(n/N, times = N)))
#
#
#   UPsystematic <- function (pik, eps = 1e-06)
#   {
#     if (any(is.na(pik)))
#       stop("there are missing values in the pik vector")
#     list = pik > eps & pik < 1 - eps
#     pik1 = pik[list]
#     N = length(pik1)
#     a = (c(0, cumsum(pik1)) - runif(1, 0, 1))%%1
#     s1 = as.integer(a[1:N] > a[2:(N + 1)])
#     s = pik
#     s[list] = s1
#     s
#   }
#
#   UPpoisson <- function (pik)
#   {
#     if (any(is.na(pik)))
#       stop("there are missing values in the pik vector")
#     as.numeric(runif(length(pik)) < pik)
#   }
#
#
#
#   if (missing(method)) {
#     warning("the method is not specified; by default, the method is srswor")
#     method = "srswor"
#   }
#   if (!(method %in% c("srswor", "srswr", "poisson", "systematic")))
#     stop("the name of the method is wrong")
#   if (method %in% c("poisson", "systematic") & missing(pik))
#     stop("the vector of probabilities is missing")
#   if (missing(stratanames) | is.null(stratanames)) {
#     if (method == "srswor")
#       result = data.frame((1:nrow(data))[srswor(size, nrow(data)) ==
#                                            1], rep(size/nrow(data), size))
#     if (method == "srswr") {
#       s = srswr(size, nrow(data))
#       st = s[s != 0]
#       l = length(st)
#       result = data.frame((1:nrow(data))[s != 0])
#       if (size <= nrow(data))
#         result = cbind.data.frame(result, st, prob = rep(size/nrow(data),
#                                                          l))
#       else {
#         prob = rep(size/nrow(data), l)/sum(rep(size/nrow(data),
#                                                l))
#         result = cbind.data.frame(result, st, prob)
#       }
#       colnames(result) = c("id", "replicates", "prob")
#     }
#     if (method == "poisson") {
#       pikk = inclusionprobabilities(pik, size)
#       s = (UPpoisson(pikk) == 1)
#       if (length(s) > 0)
#         result = data.frame((1:nrow(data))[s], pikk[s])
#       if (description)
#         cat("\nPopulation total and number of selected units:",
#             nrow(data), sum(s), "\n")
#     }
#     if (method == "systematic") {
#       pikk = inclusionprobabilities(pik, size)
#       s = (UPsystematic(pikk) == 1)
#       result = data.frame((1:nrow(data))[s], pikk[s])
#     }
#     if (method != "srswr")
#       colnames(result) = c("id", "prob")
#     if (description & method != "poisson")
#       cat("\nPopulation total and number of selected units:",
#           nrow(data), sum(size), "\n")
#   }
#   else {
#     data = data.frame(data)
#     index = 1:nrow(data)
#     m = match(stratanames, colnames(data))
#     if (any(is.na(m)))
#       stop("the names of the strata are wrong")
#     data2 = cbind.data.frame(data[, m], index)
#     colnames(data2) = c(stratanames, "index")
#     x1 = data.frame(unique(data[, m]))
#     colnames(x1) = stratanames
#     result = NULL
#     for (i in 1:nrow(x1)) {
#       if (is.vector(x1[i, ]))
#         data3 = data2[data2[, 1] == x1[i, ], ]
#       else {
#         as = data.frame(x1[i, ])
#         names(as) = names(x1)
#         data3 = merge(data2, as, by = intersect(names(data2),
#                                                 names(as)))
#       }
#       y = sort(data3$index)
#       if (description & method != "poisson") {
#         cat("Stratum", i, "\n")
#         cat("\nPopulation total and number of selected units:",
#             length(y), size[i], "\n")
#       }
#       if (method != "srswr" & length(y) < size[i]) {
#         stop("not enough obervations in the stratum ",
#              i, "\n")
#         st = c(st, NULL)
#       }
#       else {
#         if (method == "srswor") {
#           st = y[srswor(size[i], length(y)) == 1]
#           r = cbind.data.frame(data2[st, ], rep(size[i]/length(y),
#                                                 size[i]))
#         }
#         if (method == "systematic") {
#           pikk = inclusionprobabilities(pik[y], size[i])
#           s = (UPsystematic(pikk) == 1)
#           st = y[s]
#           r = cbind.data.frame(data2[st, ], pikk[s])
#         }
#         if (method == "srswr") {
#           s = srswr(size[i], length(y))
#           st = rep(y[s != 0], s[s != 0])
#           l = length(st)
#           if (size[i] <= length(y))
#             r = cbind.data.frame(data2[st, ], prob = rep(size[i]/length(y),
#                                                          l))
#           else {
#             prob = rep(size[i]/length(y), l)/sum(rep(size[i]/length(y),
#                                                      l))
#             r = cbind.data.frame(data2[st, ], prob)
#           }
#         }
#         if (method == "poisson") {
#           pikk = inclusionprobabilities(pik[y], size[i])
#           s = (UPpoisson(pikk) == 1)
#           if (any(s)) {
#             st = y[s]
#             r = cbind.data.frame(data2[st, ], pikk[s])
#             if (description) {
#               cat("Stratum", i, "\n")
#               cat("\nPopulation total and number of selected units:",
#                   length(y), length(st), "\n")
#             }
#           }
#           else {
#             if (description) {
#               cat("Stratum", i, "\n")
#               cat("\nPopulation total and number of selected units:",
#                   length(y), 0, "\n")
#             }
#             r = NULL
#           }
#         }
#       }
#       # corrected 7.4.2014 for allowing size=0 for a stratum:
#       # if (!is.null(r)) {
#       if (!is.null(r) & nrow(r)>0) {
#         r = cbind(r, i)
#         result = rbind.data.frame(result, r)
#       }
#     }
#
# # original, seems a bit "over-ifed"
# #     if (method == "srswr")
# #          colnames(result) = c(stratanames, "ID_unit", "Prob", "Stratum")
# #     else colnames(result) = c(stratanames, "ID_unit", "Prob", "Stratum")
#
#     colnames(result) <- c(stratanames, "id", "prob", "stratum")
#
#     if (description) {
#       cat("Number of strata ", nrow(x1), "\n")
#       if (method == "poisson")
#         cat("Total number of selected units", nrow(result),
#             "\n")
#       else cat("Total number of selected units", sum(size),
#                "\n")
#     }
#   }
#   result
# }


SampleTwins <- function (x, stratanames = NULL, twins,
                         method = c("srswor", "srswr", "poisson", "systematic"),
                         pik, description = FALSE) {

  # sort data first
  x <- x[do.call("order", lapply(x[,stratanames], order)),]

  # define the frequencies
  twinsize <- as.data.frame.table(xtabs( as.formula(gettextf("~ %s", paste(stratanames, collapse="+"))), twins))

  size <- merge(x=expand.grid(lapply(x[stratanames], unique)),
                y=twinsize, all.x=TRUE, all.y=TRUE)
  size$Freq[is.na(size$Freq)] <- 0

  s <- Strata(x = x, stratanames = stratanames, size=size$Freq, method=method,
              pik=pik, description=description)

  if(!identical(table(s[,stratanames]), table(twins[,stratanames]))) {
    warning("Could not find a twin for all records. Enlighten the restrictions!")
  }
  return(s)

}


## stats: Freq und PercTable ====

# replaced in version 0.99.11
Freq <- function(x, breaks = hist(x, plot = FALSE)$breaks, include.lowest = TRUE,
                 ord = c("level", "desc", "asc", "name"),
                 useNA = c("no", "ifany", "always"), ...){

  # check if x is a vector (do not use is.vector()!!!)
  if(!(is.atomic(x) || is.list(x))) stop("'x' must be a vector")

  if(inherits(x, "table")){
    tab <- x

  } else {

    if(is.numeric(x) || IsDate(x)){
      x <- cut(x, breaks = breaks, include.lowest = include.lowest,
               ordered_result = TRUE, ...)
    }

    tab <- table(x, useNA = useNA)
  }

  # how should the table be sorted, by name, level or frq? (NULL means "desc")
  switch(match.arg(ord, c("level", "desc", "asc", "name")),
           level  = {  }
         , name   = { tab <- tab[rownames(tab)] }
         , asc    = { tab <- sort(tab) }
         , desc   = { tab <- -sort(-tab) }
  )

  ptab <- prop.table(tab)
  names(tab)[is.na(names(tab))] <- "<NA>"

  z <- data.frame(level = names(tab),
                  freq = as.vector(tab[]), perc = as.vector(ptab[]),
                  cumfreq = cumsum(tab[]), cumperc = cumsum(ptab[]))

  rownames(z) <- NULL # enumerate from 1:nrow(z)
  class(z) <- c("Freq", "data.frame")
  return(z)

}



print.Freq <- function(x, digits=NULL, ...) {

  # print as data.frame if something was changed
  if(ncol(x) != 5) {
    print.data.frame(x, digits=digits, ...)
  } else {

    afmt <- .fmt_abs()
    pfmt <- .fmt_per(digits=digits)

    # object x comes as list lacking an as.data.frame option...
    print(data.frame(level=x$level, freq=Format(x$freq, fmt=afmt), perc=Format(x$perc, fmt=pfmt),
                     cumfreq=Format(x$cumfreq, fmt=afmt), cumperc=Format(x$cumperc, fmt=pfmt)),
                     print.gap = InDots(..., arg="print.gap", default=2))
  }
}


# ToDo: perctable
# param cumul.count show cumulative frequencies?
# param cumul.pct show cumulative percentage?
# param total.name a string containing footer label (defaults to "Total")
# Drop unused levels
# useNA ?
# expected values, residuals, standardized residuals



PercTable <- function (...) UseMethod("PercTable")

PercTable.default <- function (x, y = NULL, ...) {

  # all dot arguments
  dot.args <- match.call(expand.dots=FALSE)$...
  # the dot arguments which match PercTable.table
  pt.args <- dot.args[names(dot.args) %in% names(formals(PercTable.table))]
  # the dot arguments which DO NOT match PercTable.table
  tab.args <- dot.args[names(dot.args) %nin% names(formals(PercTable.table))]

  if(is.null(y)){
    tab <- do.call("table", append(list(x), tab.args) )
  } else {
    tab <- do.call("table", append(list(x, y), tab.args) )
  }
  do.call( "PercTable", append(list(tab=tab), pt.args) )

}

# PercTable.data.frame <- function(x, ...){  sapply(x, PercTable, ...) }
PercTable.matrix <- function(x, ...){  PercTable(as.table(x), ...) }


PercTable.formula <- function(formula, data, subset, na.action, ...)
{
  # this is taken basically from wilcox.test.formula

  if (missing(formula) || (length(formula) != 3L) || (length(attr(terms(formula[-2L]),
                                                                  "term.labels")) != 1L))
    stop("'formula' missing or incorrect")
  m <- match.call(expand.dots = FALSE)
  if (is.matrix(eval(m$data, parent.frame())))
    m$data <- as.data.frame(data)
  m[[1L]] <- as.name("model.frame")
  m$... <- NULL
  mf <- eval(m, parent.frame())
  DNAME <- paste(names(mf), collapse = " by ")

  DATA <- list(table(mf))
  do.call("PercTable", c(DATA, list(...)))
}



PercTable.table <- function(tab, row.vars=NULL, col.vars = 2, justify = "right"
                            , freq=TRUE, rfrq="100",
                            expected = FALSE, residuals = FALSE, stdres = FALSE, margins = NULL, vsep = NULL
                            , ...) {

  # labels = c("Sum", "freq", "perc", "p.row", "p.col"),

  # example:
  # tab <- table(d.pizza[,c("driver","operator")])
  # PercTable(tab, rfrq="110", margins=c(1,2))

  # create prop tables and format them
  fmt.tab <- function(x, perc, w) {

    if(perc==1) {
      px <- addmargins(prop.table(addmargins(x, 1), 1), 2)
      if(!1 %in% margins) px <- px[,-ncol(px)]
      if(!2 %in% margins) px <- px[-nrow(px),]
      class(px) <- "table"
    } else if(perc==2) {
      px <- addmargins(prop.table(addmargins(x, 2), 2), 1)
      if(!1 %in% margins) px <- px[,-ncol(px)]
      if(!2 %in% margins) px <- px[-nrow(px),]
      class(px) <- "table"
    } else {
      px <- prop.table(x)
      if(!is.null(margins)) px <- addmargins(px, if(length(dim(x))==1) {1} else {3 - margins} )
    }

    # get the percent format from global option
    px[] <- Format(px, fmt=.fmt_per())

    # set 100% margins to some zero value
    if(perc==1 & (1 %in% margins)) px[, ncol(px)] <- zero
    if(perc==2 & (1 %in% margins)) px[, ncol(px)] <- zero
    if(perc==1 & (2 %in% margins)) px[nrow(px), ] <- zero
    if(perc==2 & (2 %in% margins)) px[nrow(px), ] <- zero

    px
  }


  # set zero element
  zero <- "."

  tlst <- list(freq=tab)

  # overwrite percents if only 1-dim table
  if(length(dim(tab)) == 1) rfrq <- paste(sum(as.numeric(rfrq) > 0), "00", sep="")

  if(unlist(strsplit(rfrq, NULL))[1] == "1")
    tlst[["perc"]] <- fmt.tab(tab, perc=0)
  if(unlist(strsplit(rfrq, NULL))[2] == "1")
    tlst[["p.row"]] <- fmt.tab(tab, perc=1)
  if(unlist(strsplit(rfrq, NULL))[3] == "1")
    tlst[["p.col"]] <- fmt.tab(tab, perc=2)

  # flip 1 to 2 and 2 to 1 in margins with: 3 - margins
  if(!is.null(margins)) tlst[["freq"]] <- addmargins(tab, if(length(dim(tab))==1) {1} else {3 - margins})

  # format tab as.character
  tlst[["freq"]][] <- Format(tlst[["freq"]], fmt=.fmt_abs())
  if(freq == FALSE) tlst[["freq"]] <- NULL

  suppressWarnings(r.chisq <- chisq.test(tab))

  if(expected == TRUE) {
    tlst[["exp"]] <- Format(r.chisq$expected, fmt=.fmt_num())

    if(1 %in% margins) tlst[["exp"]] <- cbind(tlst[["exp"]], Sum=zero)
    if(2 %in% margins) tlst[["exp"]] <- rbind(tlst[["exp"]], Sum=zero)
  }

  if(residuals == TRUE){
    tlst[["res"]] <- Format(r.chisq$residuals, fmt=.fmt_num())
    if(1 %in% margins) tlst[["res"]] <- cbind(tlst[["res"]], Sum=zero)
    if(2 %in% margins) tlst[["res"]] <- rbind(tlst[["res"]], Sum=zero)
  }
  if(stdres == TRUE) {
    tlst[["stdres"]] <-  Format(r.chisq$stdres, fmt=.fmt_num())
    if(1 %in% margins) tlst[["stdres"]] <- cbind(tlst[["stdres"]], Sum=zero)
    if(2 %in% margins) tlst[["stdres"]] <- rbind(tlst[["stdres"]], Sum=zero)
  }

  if(length(tlst) == 1){
    ftab <- ftable(tlst[[1]])

  } else {
    if(length(dim(tab)) > 1){
      if(is.null(vsep))
        vsep <- length(tlst) > 1
      if(vsep)         # insert a separator line
        tlst[[""]] <- matrix("", nrow=nrow(tlst[[1]]), ncol=ncol(tlst[[1]]))
    }

    # build a table array, such as to be able to pass it to ftable afterwards...
    if(length(dim(tab))==1){
      ma <- do.call("cbind", tlst)
    } else {
      ma <- do.call("Abind", c(tlst, along = 3))
    }
    ftab <- ftable(ma, col.vars=col.vars, row.vars=row.vars)

  }

  justify <- match.arg(justify, c("left","right"))
  if(justify == "right")
    # align the whole stuff to the right
    ftab[] <- StrAlign(ftab, "\\$")

  names(attr(ftab, "row.vars"))[1] <- names(dimnames(tab))[1]
  if(length(names(attr(ftab, "row.vars"))) == 2)
    names(attr(ftab, "row.vars"))[2] <- ""
  names(attr(ftab, "col.vars")) <- names(dimnames(tab))[2]

  class(ftab) <- c("PercTable", "ftable")

  return(ftab)

}


print.PercTable <- function(x, ...){

  cat(paste(c(rep(" ", times=max(nchar(c(names(attr(x, "row.vars")), attr(x, "row.vars")[[1]])), na.rm=TRUE) +
                    ifelse(length(attr(x, "row.vars")) == 2, max(nchar(attr(x, "row.vars")[[2]]), na.rm=TRUE) + 2, 0) + 1),
              names(attr(x, "col.vars"))), collapse=""), sep="\n")

  names(attr(x, "col.vars")) <- NULL
  NextMethod(x, ...)
}



MarginTable <- function(tab, ...){
  lst <- lapply(1:length(dim(tab)),
                function(i) Freq(margin.table(tab, i), ...))
  names(lst) <- names(dimnames(tab))
  lst
}



ExpFreq <- function(x, freq = c("abs", "rel")) {

  # returns the expected frequencies of a table assuming independence

  # this is a copy of independence_table {vcd}
  # by David Meyer David.Meyer@R-project.org

  if (!is.array(x))
    stop("Need array of absolute frequencies!")
  frequency <- match.arg(freq)
  n <- sum(x)
  x <- x/n
  d <- dim(x)
  margins <- lapply(1:length(d), function(i) apply(x, i, sum))
  tab <- array(apply(expand.grid(margins), 1, prod), d, dimnames = dimnames(x))
  if (frequency == "rel")
    tab
  else tab * n
}


CollapseTable <- function (x, ...) {

  nargs <- length(args <- list(...))
  if (!nargs)
    return(x)

  if (inherits(x, "ftable"))
    x <- as.table(x)

  if (inherits(x, "table")) {
    tvars <- names(dimnames(x))
    x <- as.data.frame.table(x)
    freq <- x[, "Freq"]
  } else {
    stop("Argument must be a table or ftable object")
  }

  names <- names(args)

  for (i in 1:nargs) {
    vals <- args[[i]]
    nm <- names[[i]]
    if (any(nm == tvars))
      levels(x[[nm]]) <- vals
    else warning(nm, " is not among the x variables.")
  }

  xtabs(as.formula(paste("freq ~", paste(tvars, collapse = "+"))),
        data = x)

}



###

## stats: Lorenz, Gini & ineq ====

Lc <- function(x, ...)
  UseMethod("Lc")


Lc.formula <- function(formula, data, subset, na.action, ...) {

  # this is taken basically from wilcox.test.formula

  if (missing(formula) || (length(formula) != 3L) || (length(attr(terms(formula[-2L]),
                                                                  "term.labels")) != 1L))
    stop("'formula' missing or incorrect")

  m <- match.call(expand.dots = FALSE)
  if (is.matrix(eval(m$data, parent.frame())))
    m$data <- as.data.frame(data)
  m[[1L]] <- as.name("model.frame")
  m$... <- NULL
  mf <- eval(m, parent.frame())
#   mf$na.action <- substitute(na.action)
#   DNAME <- paste(names(mf), collapse = " by ")
#
#   DATA <- list(table(mf))
#   do.call("Lc", c(DATA, list(...)))
    drop <- TRUE
#   mf <- model.frame(x, data)
    x <- split(x = mf[,1], f = mf[,2], drop=drop, ...)

    res <- lapply(x, FUN = "Lc", ...)
    class(res) <- "Lclist"

  return(res)

}


Lc.default <- function(x, n = rep(1, length(x)), na.rm = FALSE, ...) {

  g <- Gini(x, n, na.rm=na.rm)

  if(na.rm) x <- na.omit(x)
  if (any(is.na(x)) || any(x < 0)) return(NA_real_)

  k <- length(x)
  o <- order(x)
  x <- x[o]
  n <- n[o]
  x <- n*x
  p <- cumsum(n)/sum(n)
  L <- cumsum(x)/sum(x)
  p <- c(0,p)
  L <- c(0,L)
  L2 <- L * mean(x)
  Lc <- list(p, L, L2, g)
  names(Lc) <- c("p", "L", "L.general", "Gini")
  class(Lc) <- "Lc"

  # no plot anymore, we have plot(lc) and Desc(lc, plotit=TRUE)
  # if(plot) plot(Lc)
  Lc
}

plot.Lc <- function(x, general=FALSE, lwd=2, type="l", xlab="p", ylab="L(p)",
                    main="Lorenz curve", las=1, ...)  {
  if(!general)
    L <- x$L
  else
    L <- x$L.general
  plot(x$p, L, type=type, main=main, lwd=lwd, xlab=xlab, ylab=ylab, xaxs="i",
       yaxs="i", las=las, ...)
  abline(0,max(L))
}

lines.Lc <- function(x, general=FALSE, lwd=2, ...) {

  if(!general)
    L <- x$L
  else
    L <- x$L.general
  lines(x$p, L, lwd=lwd, ...)
}


plot.Lclist <- function(x, col=1, lwd=2, lty=1, main = "Lorenz curve",
                        xlab="p", ylab="L(p)", ...){

  # Recycle arguments
  lgp <- Recycle(x=seq_along(x), col=col, lwd=lwd, lty=lty)

  plot(x[[1]], col=lgp$col[1], lwd=lgp$lwd[1], lty=lgp$lty[1], main=main, xlab=xlab, ylab=ylab, ...)
  for(i in 2:length(x)){
    lines(x[[i]], col=lgp$col[i], lwd=lgp$lwd[i], lty=lgp$lty[i])
  }
}



# Original Zeileis:
# Gini <- function(x)
# {
#   n <- length(x)
#   x <- sort(x)
#   G <- sum(x * 1:n)
#   G <- 2*G/(n*sum(x))
#   G - 1 - (1/n)
# }

# other:
# http://rss.acs.unt.edu/Rdoc/library/reldist/html/gini.html
# http://finzi.psych.upenn.edu/R/library/dplR/html/gini.coef.html


Gini <- function(x, n = rep(1, length(x)), unbiased = TRUE, conf.level = NA, R = 1000, type = "bca", na.rm = FALSE) {

  x <- rep(x, n)    # same handling as Lc
  if(na.rm) x <- na.omit(x)
  if (any(is.na(x)) || any(x < 0)) return(NA_real_)

  i.gini <- function (x, unbiased = TRUE){
    n <- length(x)
    x <- sort(x)

    res <- 2 * sum(x * 1:n) / (n*sum(x)) - 1 - (1/n)
    if(unbiased) res <- n / (n - 1) * res

# limit Gini to 0 here, if negative values appear, which is the case with
# Gini( c(10,10,10))
    return( pmax(0, res))

# other guy out there:
#     N <- if (unbiased) n * (n - 1) else n * n
#     dsum <- drop(crossprod(2 * 1:n - n - 1, x))
#     dsum / (mean(x) * N)
# is this slower, than above implementation??
  }

  if(is.na(conf.level)){
    res <- i.gini(x, unbiased = unbiased)

  } else {
    # adjusted bootstrap percentile (BCa) interval
    boot.gini <- boot(x, function(x, d) i.gini(x[d], unbiased = unbiased), R=R)
    ci <- boot.ci(boot.gini, conf=conf.level, type=type)
    res <- c(gini=boot.gini$t0, lwr.ci=ci[[4]][4], upr.ci=ci[[4]][5])
  }

  return(res)

}



GiniSimpson <- function(x, na.rm = FALSE) {


  # referenz:   Sachs, Angewandte Statistik, S. 57

  # example:
  # x <- as.table(c(69,17,7,62))
  # rownames(x) <- c("A","B","AB","0")
  # GiniSimpson(x)

  if(na.rm) x <- na.omit(x)

  x <- as.table(x)
  ptab <- prop.table(x)
  return(sum(ptab*(1-ptab)))
}



Atkinson <- function(x, n = rep(1, length(x)), parameter = 0.5, na.rm = FALSE) {

  x <- rep(x, n)    # same handling as Lc and Gini
  if(na.rm) x <- na.omit(x)
  if (any(is.na(x)) || any(x < 0)) return(NA_real_)

  if(is.null(parameter)) parameter <- 0.5
  if(parameter==1)
    A <- 1 - (exp(mean(log(x)))/mean(x))
  else
  {
    x <- (x/mean(x))^(1-parameter)
    A <- 1 - mean(x)^(1/(1-parameter))
  }
  A
}

Herfindahl <- function(x, n = rep(1, length(x)), parameter=1, na.rm = FALSE) {

  x <- rep(x, n)    # same handling as Lc and Gini
  if(na.rm) x <- na.omit(x)
  if (any(is.na(x)) || any(x < 0)) return(NA_real_)

  if(is.null(parameter))
    m <- 1
  else
    m <- parameter
  Herf <- x/sum(x)
  Herf <- Herf^(m+1)
  Herf <- sum(Herf)^(1/m)
  Herf
}

Rosenbluth <- function(x, n = rep(1, length(x)), na.rm = FALSE) {

  x <- rep(x, n)    # same handling as Lc and Gini
  if(na.rm) x <- na.omit(x)
  if (any(is.na(x)) || any(x < 0)) return(NA_real_)

  n <- length(x)
  x <- sort(x)
  HT <- (n:1)*x
  HT <- 2*sum(HT/sum(x))
  HT <- 1/(HT-1)
  HT
}

###

## stats: assocs etc. ====


CutQ <- function(x, breaks=quantile(x, seq(0, 1, by=0.25), na.rm=TRUE), labels=NULL, na.rm = FALSE, ...){

  # old version:
  #  cut(x, breaks=probsile(x, breaks=probs, na.rm = na.rm), include.lowest=TRUE, labels=labels)

  # $Id: probscut.R 1431 2010-04-28 17:23:08Z ggrothendieck2 $
  # from gtools

  if(na.rm) x <- na.omit(x)

  if(is.null(labels)) labels <- gettextf("Q%s", 1:(length(breaks)-1))

  # probs <- quantile(x, probs)
  dups <- duplicated(breaks)
  if(any(dups)) {

    flag <- x %in% unique(breaks[dups])
    retval <- ifelse(flag, paste("[", as.character(x), "]", sep=''), NA)
    uniqs <- unique(breaks)

    # move cut points over a bit...
    reposition <- function(cut) {
      flag <- x>=cut
      if(sum(flag)==0)
        return(cut)
      else
        return(min(x[flag]))
    }

    newprobs <- sapply(uniqs, reposition)
    retval[!flag] <- as.character(cut(x[!flag], breaks=newprobs, include.lowest=TRUE,...))

    levs <- unique(retval[order(x)]) # ensure factor levels are
    # properly ordered
    retval <- factor(retval, levels=levs)

    ## determine open/closed interval ends
    mkpairs <- function(x) # make table of lower, upper
      sapply(x,
             function(y) if(length(y)==2) y[c(2,2)] else y[2:3]
      )
    pairs <- mkpairs(strsplit(levs, '[^0-9+\\.\\-]+'))
    rownames(pairs) <- c("lower.bound","upper.bound")
    colnames(pairs) <- levs

    closed.lower <- rep(F,ncol(pairs)) # default lower is open
    closed.upper <- rep(T,ncol(pairs)) # default upper is closed
    closed.lower[1] <- TRUE             # lowest interval is always closed

    for(i in 2:ncol(pairs))            # open lower interval if above singlet
      if(pairs[1,i]==pairs[1,i-1] && pairs[1,i]==pairs[2,i-1])
        closed.lower[i] <- FALSE

    for(i in 1:(ncol(pairs)-1))        # open upper interval if below singlet
      if(pairs[2,i]==pairs[1,i+1] && pairs[2,i]==pairs[2,i+1])
        closed.upper[i] <- FALSE

    levs <- ifelse(pairs[1,]==pairs[2,],
                   pairs[1,],
                   paste(ifelse(closed.lower,"[","("),
                         pairs[1,],
                         ",",
                         pairs[2,],
                         ifelse(closed.upper,"]",")"),
                         sep='')
    )
    levels(retval) <- levs

  } else
    retval <- cut( x, breaks, include.lowest=TRUE,  labels=labels, ... )

  return(retval)

}



# Phi-Koeff
Phi  <- function (x, y = NULL, ...) {
  if(!is.null(y)) x <- table(x, y, ...)
  # when computing phi, note that Yates' correction to chi-square must not be used.
  as.numeric( sqrt( suppressWarnings(chisq.test(x, correct=FALSE)$statistic) / sum(x) ) )
}



# Kontingenz-Koeffizient
ContCoef <- function(x, y = NULL, correct = FALSE, ...) {
  if(!is.null(y)) x <- table(x, y, ...)
  chisq <- suppressWarnings(chisq.test(x, correct = FALSE)$statistic)
  cc <- as.numeric( sqrt( chisq / ( chisq + sum(x)) ))
  if(correct) {  # Sakoda's adjusted Pearson's C
    k <- min(nrow(x),ncol(x))
    cc <- cc/sqrt((k-1)/k)
  }
  return(cc)
}


CramerV <- function(x, y = NULL, conf.level = NA, ...){

  if(!is.null(y)) x <- table(x, y, ...)

  # CIs and power for the noncentral chi-sq noncentrality parameter (ncp):
  # The function lochi computes the lower CI limit and hichi computes the upper limit.
  # Both functions take 3 arguments: observed chi-sq, df, and confidence level.

  # author:   Michael Smithson
  # http://psychology3.anu.edu.au/people/smithson/details/CIstuff/Splusnonc.pdf

  lochi <- function(chival, df, conf) {
    ulim <- 1 - (1-conf)/2
    #  This first part finds a lower value from which to start.
    lc <- c(.001,chival/2,chival)
    while(pchisq(chival,df,lc[1])<ulim) {
      if(pchisq(chival,df)<ulim)
        return(c(0,pchisq(chival,df)))
      lc <- c(lc[1]/4,lc[1],lc[3])
    }
    #	This next part finds the lower limit for the ncp.
    diff <- 1
    while(diff > .00001) {
      if(pchisq(chival, df, lc[2]) < ulim)
        lc <- c(lc[1],(lc[1]+lc[2])/2,lc[2])
      else lc <- c(lc[2],(lc[2]+lc[3])/2,lc[3])
      diff <- abs(pchisq(chival,df,lc[2]) - ulim)
      ucdf <- pchisq(chival,df,lc[2])
    }
    c(lc[2], ucdf)
  }

  hichi <- function(chival,df,conf) {
    #	This first part finds upper and lower startinig values.
    uc <- c(chival, 2*chival, 3*chival)
    llim <- (1-conf)/2
    while(pchisq(chival, df, uc[1]) < llim) {
      uc <- c(uc[1]/4,uc[1],uc[3])
    }
    while(pchisq(chival,df,uc[3])>llim) {
      uc <- c(uc[1],uc[3],uc[3]+chival)
    }
    #	This next part finds the upper limit for the ncp.
    diff <- 1
    while(diff > .00001) {
      if(pchisq(chival,df,uc[2]) < llim)
        uc <- c(uc[1],(uc[1]+uc[2])/2,uc[2])
      else uc <- c(uc[2],(uc[2]+uc[3])/2,uc[3])
      diff <- abs(pchisq(chival,df,uc[2]) - llim)
      lcdf <- pchisq(chival,df,uc[2])
    }
    c(uc[2], lcdf)
  }

  # Remark Andri 18.12.2014:
  # lochi and hichi could be replaced with:
  #   optimize(function(x) abs(pchisq(chival, DF, x)  - (1-(1-conf.level)/2)), c(0, chival))
  #   optimize(function(x) abs(pchisq(chival, DF, x)  - (1-conf.level)/2), c(0, 3*chival))
  #
  # ... which would run ~ 25% faster and be more exact

  # what can go wrong while calculating chisq.stat?
  # we don't need test results here, so we suppress those warnings
  chisq.hat <- suppressWarnings(chisq.test(x, correct = FALSE)$statistic)
  df <- prod(dim(x)-1)
  v <- as.numeric(sqrt(chisq.hat/(sum(x) * (min(dim(x)) - 1))))

  if (is.na(conf.level)) {
    res <- v

  } else {
    ci <- c(lochi(chisq.hat, df, conf.level)[1], hichi(chisq.hat, df, conf.level)[1])
# corrected by michael smithson, 17.5.2014:
#    ci <- unname(sqrt( (ci + df) / (sum(x) * (min(dim(x)) - 1)) ))
    ci <- unname(sqrt( (ci) / (sum(x) * (min(dim(x)) - 1)) ))
    res <- c("Cramer V"=v, lwr.ci=max(0, ci[1]), upr.ci=min(1, ci[2]))

  }

  return(res)
}




YuleQ <- function(x, y = NULL, ...){

  if(!is.null(y)) x <- table(x, y, ...)

  # allow only 2x2 tables
  stopifnot(prod(dim(x)) == 4 || length(x) == 4)

   a <- x[1,1]
   b <- x[1,2]
   c <- x[2,1]
   d <- x[2,2]
  return((a*d- b*c)/(a*d + b*c))  #Yule Q

}


YuleY <- function(x, y = NULL, ...){

  if(!is.null(y)) x <- table(x, y, ...)

  # allow only 2x2 tables
  stopifnot(prod(dim(x)) == 4 || length(x) == 4)

   a <- x[1,1]
   b <- x[1,2]
   c <- x[2,1]
   d <- x[2,2]
  return((sqrt(a*d) - sqrt(b*c))/(sqrt(a*d)+sqrt(b*c))) # YuleY

}


TschuprowT <- function(x, y = NULL, ...){

  if(!is.null(y)) x <- table(x, y, ...)

  # Tschuprow, A. A. (1939) Principles of the Mathematical Theory of Correlation; translated by M. Kantorowitsch. W. Hodge & Co.
  # http://en.wikipedia.org/wiki/Tschuprow's_T
  # Hartung S. 451

  # what can go wrong while calculating chisq.stat?
  # we don't need test results here, so we suppress those warnings
  as.numeric( sqrt(suppressWarnings(chisq.test(x, correct = FALSE)$statistic)/
                  (sum(x) * sqrt(prod(dim(x)-1)) )))

}




# based on Kappa from library(vcd)
# author: David Meyer
# see also: kappa in library(psych)

CohenKappa <- function (x, y = NULL, weights = c("Unweighted", "Equal-Spacing", "Fleiss-Cohen"), conf.level = NA, ...) {

  if (is.character(weights)) weights <- match.arg(weights)

  if(!is.null(y)) {
    # we can not ensure a reliable weighted kappa for 2 factors with different levels
    # so refuse trying it... (unweighted is no problem)

    if( !identical(weights, "Unweighted")) stop("Vector interface for weighted Kappa is not supported. Provide confusion matrix.")

    # x and y must have the same levels in order to build a symmetric confusion matrix
    x <- factor(x)
    y <- factor(y)
    lvl <- unique(c(levels(x), levels(y)))
    x <- factor(x, levels=lvl)
    y <- factor(y, levels=lvl)
    x <- table(x, y, ...)

  } else {
    d <- dim(x)
    if (d[1L] != d[2L]) stop("x must be square matrix if provided as confusion matrix")
  }

  d <- diag(x)
  n <- sum(x)
  nc <- ncol(x)
  colFreqs <- colSums(x)/n
  rowFreqs <- rowSums(x)/n

  kappa <- function(po, pc) (po - pc)/(1 - pc)
  std <- function(po, pc, W = 1) sqrt(sum(W * W * po * (1 - po))/crossprod(1 - pc)/n)

  po <- sum(d)/n
  pc <- crossprod(colFreqs, rowFreqs)

  k <- kappa(po, pc)
  s <- std(po, pc)

  W <- if (is.matrix(weights))
    weights
  else if (weights == "Equal-Spacing")
    1 - abs(outer(1:nc, 1:nc, "-"))/(nc - 1)
  else # weightx == "Fleiss-Cohen"
    1 - (abs(outer(1:nc, 1:nc, "-"))/(nc - 1))^2

  pow <- sum(W * x)/n
  pcw <- sum(W * colFreqs %o% rowFreqs)

  kw <- kappa(pow, pcw)
  sw <- std(x/n, 1 - pcw, W)

#   structure(list(Unweighted = c(value = k, ASE = s), Weighted = c(value = kw,
#       ASE = sw), Weights = W), class = "Kappa")

  if (is.na(conf.level)) {
    if(identical(weights, "Unweighted"))
      res <- as.vector(k)
    else
      res <- as.vector(kw)
  } else {
    if(identical(weights, "Unweighted")) {
      ci <- k + c(1,-1) * qnorm((1-conf.level)/2) * s
      res <- c("kappa"=k, lwr.ci=ci[1], upr.ci=ci[2])
    } else {
      ci <- kw + c(1,-1) * qnorm((1-conf.level)/2) * sw
      res <- c("kappa"=kw, lwr.ci=ci[1], upr.ci=ci[2])
    }
  }
  return(res)

}

# KappaTest <- function(x, weights = c("Equal-Spacing", "Fleiss-Cohen"), conf.level = NA) {
  # to do, idea is to implement a Kappa test for H0: kappa = 0 as in
  # http://support.sas.com/documentation/cdl/en/statugfreq/63124/PDF/default/statugfreq.pdf, pp. 1687
#   print( "still to do...." )

# }


KappaM <- function(x, method = c("Fleiss", "Conger", "Light"), conf.level = NA) {

	ratings <- as.matrix(na.omit(x))

	ns <- nrow(ratings)
	nr <- ncol(ratings)

	# Build table
	lev <- levels(as.factor(ratings))

	for (i in 1:ns) {
		frow <- factor(ratings[i,],levels=lev)

		if (i==1)
			ttab <- as.numeric(table(frow))
		else
			ttab <- rbind(ttab, as.numeric(table(frow)))
	}

	ttab <- matrix(ttab, nrow=ns)
	agreeP <- sum((apply(ttab^2, 1, sum)-nr)/(nr*(nr-1))/ns)

	switch( match.arg(method, choices= c("Fleiss", "Conger", "Light"))
    , "Fleiss" = {
      chanceP <- sum(apply(ttab,2,sum)^2)/(ns*nr)^2
      value <- (agreeP - chanceP)/(1 - chanceP)

      pj <- apply(ttab,2,sum)/(ns*nr)
      qj <- 1-pj

      varkappa <- (2/(sum(pj*qj)^2*(ns*nr*(nr-1))))*(sum(pj*qj)^2-sum(pj*qj*(qj-pj)))
      SEkappa <- sqrt(varkappa)

      ci <- value + c(1,-1) * qnorm((1-conf.level)/2) * SEkappa
    }
    , "Conger" = {
      for (i in 1:nr) {
        rcol <- factor(ratings[,i],levels=lev)

        if (i==1)
          rtab <- as.numeric(table(rcol))
        else
          rtab <- rbind(rtab, as.numeric(table(rcol)))
      }

      rtab <- rtab/ns

      chanceP <- sum(apply(ttab,2,sum)^2)/(ns*nr)^2 - sum(apply(rtab,2,var)*(nr-1)/nr)/(nr-1)
      value <- (agreeP - chanceP)/(1 - chanceP)

      # we have not SE for exact Kappa value
      ci <- c(NA, NA)

    }
	  , "Light" = {
	    m <- DescTools::PairApply(ratings, DescTools::CohenKappa, symmetric=TRUE)
	    value <- mean(m[upper.tri(m)])

	    levlen <- length(lev)
	    for (nri in 1:(nr - 1)) for (nrj in (nri + 1):nr) {
	      for (i in 1:levlen) for (j in 1:levlen) {
	        if (i != j) {
	          r1i <- sum(ratings[, nri] == lev[i])
	          r2j <- sum(ratings[, nrj] == lev[j])
	          if (!exists("dis"))
	            dis <- r1i * r2j
	          else dis <- c(dis, r1i * r2j)
	        }
	      }
	      if (!exists("disrater"))
	        disrater <- sum(dis)
	      else disrater <- c(disrater, sum(dis))
	      rm(dis)
	    }
	    B <- length(disrater) * prod(disrater)
	    chanceP <- 1 - B/ns^(choose(nr, 2) * 2)
	    varkappa <- chanceP/(ns * (1 - chanceP))
	    SEkappa <- sqrt(varkappa)

	    ci <- value + c(1,-1) * qnorm((1-conf.level)/2) * SEkappa

	  }
	)


	if (is.na(conf.level)) {
    res <- value
	} else {
    res <- c("kappa"=value, lwr.ci=ci[1], upr.ci=ci[2])
	}
	return(res)

}



Agree <- function(x, tolerance = 0, na.rm = FALSE) {

  x <- as.matrix(x)
  if(na.rm) x <- na.omit(x)

  if(anyNA(x)) return(NA)

  ns <- nrow(x)
  nr <- ncol(x)

  if (is.numeric(x)) {
    rangetab <- apply(x, 1, max) - apply(x, 1, min)
    coeff <-  sum(rangetab <= tolerance)/ns

  } else {
    rangetab <- as.numeric(sapply(apply(x, 1, table), length))
    coeff <- (sum(rangetab == 1)/ns)
    tolerance <- 0
  }

  rval <- coeff
  attr(rval, c("subjects")) <- ns
  attr(rval, c("raters")) <- nr

  return(rval)

}


# ICC(ratings)
# ICC_(ratings, type="ICC3", conf.level=0.95)
# ICC_(ratings, type="all", conf.level=0.95)

ICC <- function(ratings, type=c("all", "ICC1","ICC2","ICC3","ICC1k","ICC2k","ICC3k"), conf.level = NA, na.rm = FALSE) {

  ratings <- as.matrix(ratings)
  if(na.rm) ratings <- na.omit(ratings)

  ns <- nrow(ratings)
  nr <- ncol(ratings)

  x.s <- stack(data.frame(ratings))
  x.df <- data.frame(x.s, subs = rep(paste("S", 1:ns, sep = ""), nr))

  s.aov <- summary(aov(values ~ subs + ind, data=x.df))
  stats <- matrix(unlist(s.aov), ncol=3, byrow=TRUE)
  MSB <- stats[3,1]
  MSW <- (stats[2,2] + stats[2,3])/(stats[1,2] + stats[1,3])
  MSJ <- stats[3,2]
  MSE <- stats[3,3]

  ICC1 <- (MSB- MSW)/(MSB+ (nr-1)*MSW)
  ICC2 <- (MSB- MSE)/(MSB + (nr-1)*MSE + nr*(MSJ-MSE)/ns)
  ICC3 <- (MSB - MSE)/(MSB+ (nr-1)*MSE)
  ICC12 <- (MSB-MSW)/(MSB)
  ICC22 <- (MSB- MSE)/(MSB +(MSJ-MSE)/ns)
  ICC32 <- (MSB-MSE)/MSB

  #find the various F values from Shrout and Fleiss
  F11 <- MSB/MSW
  df11n <- ns-1
  df11d <- ns*(nr-1)
  p11 <- 1 - pf(F11, df11n, df11d)
  F21 <- MSB/MSE
  df21n <- ns-1
  df21d <- (ns-1)*(nr-1)
  p21 <- 1-pf(F21, df21n, df21d)
  F31 <- F21


  # results <- t(results)

  results <- data.frame(matrix(NA, ncol=8, nrow=6))
  colnames(results ) <- c("type", "est","F-val","df1","df2","p-val","lwr.ci","upr.ci")
  rownames(results) <- c("Single_raters_absolute","Single_random_raters","Single_fixed_raters", "Average_raters_absolute","Average_random_raters","Average_fixed_raters")

  results[,1] = c("ICC1","ICC2","ICC3","ICC1k","ICC2k","ICC3k")
  results[,2] = c(ICC1, ICC2, ICC3, ICC12, ICC22, ICC32)
  results[1,3] <- results[4,3] <- F11
  results[2,3] <- F21
  results[3,3] <- results[6,3] <- results[5,3] <- F31 <- F21
  results[5,3] <- F21
  results[1,4] <- results[4,4] <- df11n
  results[1,5] <- results[4,5] <- df11d
  results[1,6] <- results[4,6] <- p11
  results[2,4] <- results[3,4] <- results[5,4] <- results[6,4] <- df21n
  results[2,5] <- results[3,5] <- results[5,5] <- results[6,5] <- df21d
  results[2,6] <- results[5,6] <- results[3,6] <- results[6,6] <- p21

  #now find confidence limits
  #first, the easy ones
  alpha <- 1 - conf.level
  F1L <- F11 / qf(1-alpha/2, df11n, df11d)
  F1U <- F11 * qf(1-alpha/2, df11d, df11n)
  L1 <- (F1L-1) / (F1L + (nr - 1))
  U1 <- (F1U -1) / (F1U + nr - 1)
  F3L <- F31 / qf(1-alpha/2, df21n, df21d)
  F3U <- F31 * qf(1-alpha/2, df21d, df21n)
  results[1,7] <- L1
  results[1,8] <- U1
  results[3,7] <- (F3L-1)/(F3L+nr-1)
  results[3,8] <- (F3U-1)/(F3U+nr-1)
  results[4,7] <- 1- 1/F1L
  results[4,8] <- 1- 1/F1U
  results[6,7] <- 1- 1/F3L
  results[6,8] <- 1 - 1/F3U

  #the hard one is case 2
  Fj <- MSJ/MSE
  vn <- (nr-1)*(ns-1)* ( (nr*ICC2*Fj+ns*(1+(nr-1)*ICC2) - nr*ICC2))^2
  vd <- (ns-1)*nr^2 * ICC2^2 * Fj^2 + (ns *(1 + (nr-1)*ICC2) - nr*ICC2)^2
  v <- vn/vd
  F3U <- qf(1-alpha/2,ns-1,v)
  F3L <- qf(1-alpha/2,v,ns-1)

  L3 <- ns *(MSB- F3U*MSE)/(F3U*(nr * MSJ + (nr*ns-nr-ns) * MSE)+ ns*MSB)
  results[2, 7] <- L3
  U3 <- ns *(F3L * MSB - MSE)/(nr * MSJ + (nr * ns - nr - ns)*MSE + ns * F3L * MSB)
  results[2, 8] <- U3
  L3k <- L3 * nr/(1+ L3*(nr-1))
  U3k <- U3 * nr/(1+ U3*(nr-1))
  results[5, 7] <- L3k
  results[5, 8] <- U3k


  #clean up the output
  results[,2:8] <- results[,2:8]

  type <- match.arg(type, c("all", "ICC1","ICC2","ICC3","ICC1k","ICC2k","ICC3k"))

  switch(type
         , all={res <- list(results=results, summary=s.aov, stats=stats, MSW=MSW, ns=ns, nr=nr)
                class(res) <- "ICC"
           }
         , ICC1={idx <- 1}
         , ICC2={idx <- 2}
         , ICC3={idx <- 3}
         , ICC1k={idx <- 4}
         , ICC2k={idx <- 5}
         , ICC3k={idx <- 6}
  )

  if(type!="all"){
    if(is.na(conf.level)){
      res <- results[idx, c(2)][,]
    } else {
      res <- unlist(results[idx, c(2, 7:8)])
      names(res) <- c(type,"lwr.ci","upr.ci")
    }
  }

  return(res)

}


print.ICC <- function(x, digits = 3, ...){
  cat("\nIntraclass correlation coefficients \n")
  print(x$results, digits=digits)
  cat("\n Number of subjects =", x$ns, "    Number of raters =", x$nr, "\n")
}




CronbachAlpha <- function(x, conf.level = NA, cond = FALSE, na.rm = FALSE){

  i.CronbachAlpha <- function(x, conf.level = NA){
    nc <- ncol(x)
    colVars <- apply(x, 2, var)
    total   <- var(apply(x, 1, sum))
    res <- (total - sum(colVars)) / total * (nc/(nc-1))

    if (!is.na(conf.level)) {
      N <- length(x)
      ci <- 1 - (1-res) * qf( c(1-(1-conf.level)/2, (1-conf.level)/2), N-1, (nc-1)*(N-1))
      res <- c("Cronbach Alpha"=res, lwr.ci=ci[1], upr.ci=ci[2])
    }
    return(res)
  }


  x <- as.matrix(x)
  if(na.rm) x <- na.omit(x)

  res <- i.CronbachAlpha(x = x, conf.level = conf.level)

  if(cond) {
    condCronbachAlpha <- list()
    n <- ncol(x)
    if(n > 2) {     # can't calculate conditional with only 2 items
      for(i in 1:n){
        condCronbachAlpha[[i]] <- i.CronbachAlpha(x[,-i], conf.level = conf.level)
      }
      condCronbachAlpha <- data.frame(Item = 1:n, do.call("rbind", condCronbachAlpha))
      colnames(condCronbachAlpha)[2] <- "Cronbach Alpha"
    }
    res <- list(unconditional=res, condCronbachAlpha = condCronbachAlpha)
  }

  return(res)
}


KendallW <- function(ratings, correct=FALSE, test=FALSE, na.rm = FALSE) {

  # see also old Jim Lemon function kendall.w
  # other solution: library(irr);  kendall(ratings, correct = TRUE)
  # http://www.real-statistics.com/reliability/kendalls-w/

  dname <- deparse(substitute(ratings))

  ratings <- as.matrix(ratings)
  if(na.rm) ratings <- na.omit(ratings)

  ns <- nrow(ratings)
  nr <- ncol(ratings)

  #Without correction for ties
  if (!correct) {
    #Test for ties
    TIES = FALSE
    testties <- apply(ratings, 2, unique)
    if (!is.matrix(testties)) TIES=TRUE
    else { if (length(testties) < length(ratings)) TIES=TRUE }

    ratings.rank <- apply(ratings,2,rank)

    coeff.name <- "W"
    coeff <- (12*var(apply(ratings.rank,1,sum))*(ns-1))/(nr^2*(ns^3-ns))
  }
  else { #With correction for ties
    ratings <- as.matrix(na.omit(ratings))

    ns <- nrow(ratings)
    nr <- ncol(ratings)

    ratings.rank <- apply(ratings,2,rank)

    Tj <- 0
    for (i in 1:nr) {
      rater <- table(ratings.rank[,i])
      ties  <- rater[rater>1]
      l 	  <- as.numeric(ties)
      Tj	  <- Tj + sum(l^3-l)
    }

    coeff.name <- "Wt"
    coeff <- (12*var(apply(ratings.rank,1,sum))*(ns-1))/(nr^2*(ns^3-ns)-nr*Tj)
  }

  if(test){
    #test statistics
    Xvalue  <- nr*(ns-1)*coeff
    df1     <- ns-1
    names(df1) <- "df"
    p.value <- pchisq(Xvalue, df1, lower.tail = FALSE)
    method <- paste("Kendall's coefficient of concordance", coeff.name)
    alternative <- paste(coeff.name, "is greater 0")
    names(ns) <- "subjects"
    names(nr) <- "raters"
    names(Xvalue) <- "Kendall chi-squared"
    names(coeff) <- coeff.name
    rval <- list(#subjects = ns, raters = nr,
                 estimate = coeff, parameter=c(df1, ns, nr),
                 statistic = Xvalue, p.value = p.value,
                 alternative = alternative, method = method, data.name = dname)

    class(rval) <- "htest"
  } else {
    rval <- coeff
  }

  if (!correct && TIES) warning("Coefficient may be incorrect due to ties")
  return(rval)
}



CCC <- function(x, y, ci = "z-transform", conf.level = 0.95, na.rm = FALSE){

  dat <- data.frame(x, y)

  if(na.rm) dat <- na.omit(dat)
#   id <- complete.cases(dat)
#   nmissing <- sum(!complete.cases(dat))
#   dat <- dat[id,]


  N. <- 1 - ((1 - conf.level) / 2)
  zv <- qnorm(N., mean = 0, sd = 1)
  lower <- "lwr.ci"
  upper <- "upr.ci"

  k <- length(dat$y)
  yb <- mean(dat$y)
  sy2 <- var(dat$y) * (k - 1) / k
  sd1 <- sd(dat$y)

  xb <- mean(dat$x)
  sx2 <- var(dat$x) * (k - 1) / k
  sd2 <- sd(dat$x)

  r <- cor(dat$x, dat$y)
  sl <- r * sd1 / sd2

  sxy <- r * sqrt(sx2 * sy2)
  p <- 2 * sxy / (sx2 + sy2 + (yb - xb)^2)

  delta <- (dat$x - dat$y)
  rmean <- apply(dat, MARGIN = 1, FUN = mean)
  blalt <- data.frame(mean = rmean, delta)

  # Scale shift:
  v <- sd1 / sd2
  # Location shift relative to the scale:
  u <- (yb - xb) / ((sx2 * sy2)^0.25)
  # Variable C.b is a bias correction factor that measures how far the best-fit line deviates from a line at 45 degrees (a measure of accuracy). No deviation from the 45 degree line occurs when C.b = 1. See Lin (1989 page 258).
  # C.b <- (((v + 1) / (v + u^2)) / 2)^-1

  # The following taken from the Stata code for function "concord" (changed 290408):
  C.b <- p / r

  # Variance, test, and CI for asymptotic normal approximation (per Lin (March 2000) Biometrics 56:325-5):
  sep = sqrt(((1 - ((r)^2)) * (p)^2 * (1 - ((p)^2)) / (r)^2 + (2 * (p)^3 * (1 - p) * (u)^2 / r) - 0.5 * (p)^4 * (u)^4 / (r)^2 ) / (k - 2))
  ll = p - zv * sep
  ul = p + zv * sep

  # Statistic, variance, test, and CI for inverse hyperbolic tangent transform to improve asymptotic normality:
  t <- log((1 + p) / (1 - p)) / 2
  set = sep / (1 - ((p)^2))
  llt = t - zv * set
  ult = t + zv * set
  llt = (exp(2 * llt) - 1) / (exp(2 * llt) + 1)
  ult = (exp(2 * ult) - 1) / (exp(2 * ult) + 1)

  if(ci == "asymptotic"){
    rho.c <- as.data.frame(cbind(p, ll, ul))
    names(rho.c) <- c("est", lower, upper)
    rval <- list(rho.c = rho.c, s.shift = v, l.shift = u, C.b = C.b, blalt = blalt ) # , nmissing = nmissing)
  }

  else if(ci == "z-transform"){
    rho.c <- as.data.frame(cbind(p, llt, ult))
    names(rho.c) <- c("est", lower, upper)
    rval <- list(rho.c = rho.c, s.shift = v, l.shift = u, C.b = C.b, blalt = blalt) #, nmissing = nmissing)
  }
  return(rval)
}




KrippAlpha <- function (x, method = c("nominal", "ordinal", "interval", "ratio")) {

  method  <-  match.arg(method)

  coincidence.matrix <- function(x) {
    levx <- (levels(as.factor(x)))
    nval <- length(levx)
    cm <- matrix(rep(0, nval * nval), nrow = nval)
    dimx <- dim(x)
    vn <- function(datavec) sum(!is.na(datavec))
    if(any(is.na(x))) mc <- apply(x, 2, vn) - 1
    else mc <- rep(1, dimx[2])
    for(col in 1:dimx[2]) {
      for(i1 in 1:(dimx[1] - 1)) {
        for(i2 in (i1 + 1):dimx[1]) {
          if(!is.na(x[i1, col]) && !is.na(x[i2, col])) {
            index1 <- which(levx == x[i1, col])
            index2 <- which(levx == x[i2, col])
            cm[index1, index2] <- cm[index1,index2] + (1 + (index1 == index2))/mc[col]
            if(index1 != index2) cm[index2,index1] <- cm[index1,index2]
          }
        }
      }
    }
    nmv  <-  sum(apply(cm, 2, sum))
    return(structure(list(method="Krippendorff's alpha",
                          subjects=dimx[2], raters=dimx[1],irr.name="alpha",
                          value=NA,stat.name="nil",statistic=NULL,
                          cm=cm,data.values=levx,nmatchval=nmv,data.level=NA),
                     class = "irrlist"))
  }

  ka <- coincidence.matrix(x)
  ka$data.level <- method
  dimcm <- dim(ka$cm)
  utcm <- as.vector(ka$cm[upper.tri(ka$cm)])
  diagcm <- diag(ka$cm)
  occ <- sum(diagcm)
  nc <- apply(ka$cm,1,sum)
  ncnc <- sum(nc * (nc - 1))
  dv <- as.numeric(ka$data.values)
  diff2 <- rep(0,length(utcm))
  ncnk <- rep(0,length(utcm))
  ck <- 1

  if (dimcm[2]<2)
    ka$value <- 1.0
  else {
    for(k in 2:dimcm[2]) {
      for(c in 1:(k-1)) {
        ncnk[ck] <- nc[c] * nc[k]
        if(match(method[1],"nominal",0)) diff2[ck] <- 1
        if(match(method[1],"ordinal",0)) {
          diff2[ck] <- nc[c]/2
          if(k > (c+1))
            for(g in (c+1):(k-1)) diff2[ck] <- diff2[ck] + nc[g]
          diff2[ck] <- diff2[ck]+nc[k]/2
          diff2[ck] <- diff2[ck]^2
        }
        if(match(method[1],"interval",0)) diff2[ck] <- (dv[c]-dv[k])^2
        if(match(method[1],"ratio",0)) diff2[ck] <- (dv[c]-dv[k])^2/(dv[c]+dv[k])^2
        ck <- ck+1
      }
    }
    ka$value <- 1-(ka$nmatchval-1)*sum(utcm*diff2)/sum(ncnk*diff2)
  }
  return(ka)
}



Entropy <- function(x, y = NULL, base = 2, ...) {

  # x is either a table or a vector if y is defined

  if(!is.null(y)) { x <- table(x, y, ...) }
  x <- as.matrix(x)

  ptab <- x / sum(x)
  H <- - sum( ifelse(ptab > 0, ptab * log(ptab, base=base), 0) )
  return(H)

}


MutInf <- function(x, y = NULL, base = 2, ...){
  # ### Ref.:  http://en.wikipedia.org/wiki/Cluster_labeling

  if(!is.null(y)) { x <- table(x, y, ...) }
  x <- as.matrix(x)

  return(
    Entropy(apply(x, 1, sum), base=base) +
      Entropy(apply(x, 2, sum), base=base) - Entropy(x, base=base)
  )

}



# Rao's Diversity from ade4 divc
# author:

DivCoef <- function(df, dis = NULL, scale = FALSE){
    # checking of user's data and initialization.
    if (!inherits(df, "data.frame")) stop("Non convenient df")
    if (any(df < 0)) stop("Negative value in df")
    if (!is.null(dis)) {
        if (!inherits(dis, "dist")) stop("Object of class 'dist' expected for distance")
        if (!IsEuclid(dis)) warning("Euclidean property is expected for distance")
        dis <- as.matrix(dis)
        if (nrow(df)!= nrow(dis)) stop("Non convenient df")
        dis <- as.dist(dis)
    }
    if (is.null(dis)) dis <- as.dist((matrix(1, nrow(df), nrow(df))
        - diag(rep(1, nrow(df)))) * sqrt(2))
    div <- as.data.frame(rep(0, ncol(df)))
    names(div) <- "diversity"
    rownames(div) <- names(df)
    for (i in 1:ncol(df)) {
        if(sum(df[, i]) < 1e-16) div[i, ] <- 0
        else div[i, ] <- (t(df[, i]) %*% (as.matrix(dis)^2) %*% df[, i]) / 2 / (sum(df[, i])^2)
    }
    if(scale == TRUE){
        divmax <- DivCoefMax(dis)$value
        div <- div / divmax
    }
    return(div)
}

IsEuclid <- function (distmat, plot = FALSE, print = FALSE, tol = 1e-07) {

  "bicenter.wt" <- function (X, row.wt = rep(1, nrow(X)), col.wt = rep(1, ncol(X))) {
      X <- as.matrix(X)
      n <- nrow(X)
      p <- ncol(X)
      if (length(row.wt) != n)
          stop("length of row.wt must equal the number of rows in x")
      if (any(row.wt < 0) || (sr <- sum(row.wt)) == 0)
          stop("weights must be non-negative and not all zero")
      row.wt <- row.wt/sr
      if (length(col.wt) != p)
          stop("length of col.wt must equal the number of columns in x")
      if (any(col.wt < 0) || (st <- sum(col.wt)) == 0)
          stop("weights must be non-negative and not all zero")
      col.wt <- col.wt/st
      row.mean <- apply(row.wt * X, 2, sum)
      col.mean <- apply(col.wt * t(X), 2, sum)
      col.mean <- col.mean - sum(row.mean * col.wt)
      X <- sweep(X, 2, row.mean)
      X <- t(sweep(t(X), 2, col.mean))
      return(X)
  }

  if (!inherits(distmat, "dist"))
    stop("Object of class 'dist' expected")
  if(any(distmat<tol))
    warning("Zero distance(s)")
  distmat <- as.matrix(distmat)
  n <- ncol(distmat)
  delta <- -0.5 * bicenter.wt(distmat * distmat)
  lambda <- eigen(delta, symmetric = TRUE, only.values = TRUE)$values
  w0 <- lambda[n]/lambda[1]
  if (plot)
    barplot(lambda)
  if (print)
    print(lambda)
  return((w0 > -tol))
}


DivCoefMax <- function(dis, epsilon = 1e-008, comment = FALSE) {

# inititalisation
    if(!inherits(dis, "dist")) stop("Distance matrix expected")
    if(epsilon <= 0) stop("epsilon must be positive")
    if(!IsEuclid(dis)) stop("Euclidean property is expected for dis")
    D2 <- as.matrix(dis)^2 / 2
    n <- dim(D2)[1]
    result <- data.frame(matrix(0, n, 4))
    names(result) <- c("sim", "pro", "met", "num")
    relax <- 0    # determination de la valeur initiale x0
    x0 <- apply(D2, 1, sum) / sum(D2)
    result$sim <- x0    # ponderation simple
    objective0 <- t(x0) %*% D2 %*% x0
    if (comment == TRUE)
        print("evolution of the objective function:")
    xk <- x0    # grande boucle de test des conditions de Kuhn-Tucker
    repeat {
        # boucle de test de nullite du gradient projete
        repeat {
            maxi.temp <- t(xk) %*% D2 %*% xk
            if(comment == TRUE) print(as.character(maxi.temp))
            #calcul du gradient
            deltaf <- (-2 * D2 %*% xk)
            # determination des contraintes saturees
            sature <- (abs(xk) < epsilon)
            if(relax != 0) {
                sature[relax] <- FALSE
                relax <- 0
            }
            # construction du gradient projete
            yk <- ( - deltaf)
            yk[sature] <- 0
            yk[!(sature)] <- yk[!(sature)] - mean(yk[!(
                sature)])
            # test de la nullite du gradient projete
            if (max(abs(yk)) < epsilon) {
                break
            }
            # determination du pas le plus grand compatible avec les contraintes
            alpha.max <- as.vector(min( - xk[yk < 0] / yk[yk <
                0]))
            alpha.opt <- as.vector( - (t(xk) %*% D2 %*% yk) / (
                t(yk) %*% D2 %*% yk))
            if ((alpha.opt > alpha.max) | (alpha.opt < 0)) {
                alpha <- alpha.max
            }
            else {
                alpha <- alpha.opt
            }
            if (abs(maxi.temp - t(xk + alpha * yk) %*% D2 %*% (
                xk + alpha * yk)) < epsilon) {
                break
            }
            xk <- xk + alpha * yk
        }
        # verification des conditions de KT
        if (prod(!sature) == 1) {
            if (comment == TRUE)
                print("KT")
            break
        }
        vectD2 <- D2 %*% xk
        u <- 2 * (mean(vectD2[!sature]) - vectD2[sature])
        if (min(u) >= 0) {
            if (comment == TRUE)
                print("KT")
            break
        }
        else {
            if (comment == TRUE)
                print("relaxation")
            satu <- (1:n)[sature]
            relax <- satu[u == min(u)]
            relax <-relax[1]
        }
    }
    if (comment == TRUE)
        print(list(objective.init = objective0, objective.final
             = maxi.temp))
    result$num <- as.vector(xk, mode = "numeric")
    result$num[result$num < epsilon] <- 0
    # ponderation numerique
    xk <- x0 / sqrt(sum(x0 * x0))
    repeat {
        yk <- D2 %*% xk
        yk <- yk / sqrt(sum(yk * yk))
        if (max(xk - yk) > epsilon) {
            xk <- yk
        }
        else break
    }
    x0 <- as.vector(yk, mode = "numeric")
    result$pro <- x0 / sum(x0)    # ponderation propre
    result$met <- x0 * x0    # ponderation propre
    restot <- list()
    restot$value <- DivCoef(cbind.data.frame(result$num), dis)[,1]
    restot$vectors <- result
    return(restot)
}





# http://sph.bu.edu/otlt/MPH-Modules/BS/BS704_Confidence_Intervals/BS704_Confidence_Intervals8.html
# sas:    http://support.sas.com/documentation/cdl/en/statug/63347/HTML/default/viewer.htm#statug_surveyfreq_a0000000227.htm

# discussion:   http://tolstoy.newcastle.edu.au/R/e2/help/06/11/4982.html
#
# RelRisk0 <- function(x, conf.level = NA) {
#
#   rr <- (x[1,1]/sum(x[,1])) / (x[1,2]/sum(x[,2]))
#   if (is.na(conf.level)) {
#     res <- rr
#   } else {
#     sigma <- x[1,2]/(x[1,1]*sum(x[1,])) + x[2,2]/(x[2,1]*sum(x[2,]))
#     qn <- qnorm(1-(1-conf.level)/2)
#     ci <- exp(log(rr) + c(-1,1)*qn*sqrt(sigma))
#     res <- c("rel. risk"=rr, lwr.ci=ci[1], upr.ci=ci[2])
#   }
#   return(res)
# }


RelRisk <- function(x, y = NULL, conf.level = NA, method = c("score", "wald", "use.or"), delta = 0.5, ...) {

  if(!is.null(y)) x <- table(x, y, ...)

  p <- (d <- dim(x))[1L]
  if(!is.numeric(x) || length(d) != 2L || p != d[2L] || p !=2L)
    stop("'x' is not a 2x2 numeric matrix")

  x1 <- x[1,1]
  x2 <- x[2,1]
  n1 <- x[1,1] + x[1,2]
  n2 <- x[2,1] + x[2,2]

  rr <- (x[1,1]/sum(x[1,])) / (x[2,1]/sum(x[2,]))

  if( !is.na(conf.level)) {
    switch( match.arg( arg = method, choices = c("score", "wald", "use.or") )
      , "score" = {
        # source:
        # Agresti-Code:        http://www.stat.ufl.edu/~aa/cda/R/two-sample/R2/

        # R Code for large-sample score confidence interval for a relative risk
        # in a 2x2 table (Koopman 1984, Miettinen and Nurminen 1985, Nurminen 1986).

      z =  abs(qnorm((1-conf.level)/2))
        if ((x2==0) &&(x1==0)){
          ul = Inf
          ll = 0
        }
        else{
          a1 =  n2*(n2*(n2+n1)*x1+n1*(n2+x1)*(z^2))
          a2 = -n2*(n2*n1*(x2+x1)+2*(n2+n1)*x2*x1+n1*(n2+x2+2*x1)*(z^2))
          a3 = 2*n2*n1*x2*(x2+x1)+(n2+n1)*(x2^2)*x1+n2*n1*(x2+x1)*(z^2)
          a4 = -n1*(x2^2)*(x2+x1)
          b1 = a2/a1
          b2 = a3/a1
          b3 = a4/a1
          c1 = b2-(b1^2)/3
          c2 = b3-b1*b2/3+2*(b1^3)/27
          ceta = acos(sqrt(27)*c2/(2*c1*sqrt(-c1)))
          t1 = -2*sqrt(-c1/3)*cos(pi/3-ceta/3)
          t2 = -2*sqrt(-c1/3)*cos(pi/3+ceta/3)
          t3 = 2*sqrt(-c1/3)*cos(ceta/3)
          p01 = t1-b1/3
          p02 = t2-b1/3
          p03 = t3-b1/3
          p0sum = p01+p02+p03
          p0up = min(p01,p02,p03)
          p0low = p0sum-p0up-max(p01,p02,p03)

          if( (x2==0) && (x1!=0) ){
            ll = (1-(n1-x1)*(1-p0low)/(x2+n1-(n2+n1)*p0low))/p0low
            ul = Inf
          }
          else if( (x2!=n2) && (x1==0)){
            ul = (1-(n1-x1)*(1-p0up)/(x2+n1-(n2+n1)*p0up))/p0up
            ll = 0
          }
          else if( (x2==n2) && (x1==n1)){
            ul = (n2+z^2)/n2
            ll =  n1/(n1+z^2)
          }
          else if( (x1==n1) || (x2==n2) ){
            if((x2==n2) && (x1==0)) { ll = 0 }
            if((x2==n2) && (x1!=0)) {
              phat1  = x2/n2
              phat2  =  x1/n1
              phihat = phat2/phat1
              phil = 0.95*phihat
              chi2 = 0
              while (chi2 <= z){
                a = (n2+n1)*phil
                b = -((x2+n1)*phil+x1+n2)
                c = x2+x1
                p1hat = (-b-sqrt(b^2-4*a*c))/(2*a)
                p2hat = p1hat*phil
                q2hat = 1-p2hat
                var = (n2*n1*p2hat)/(n1*(phil-p2hat)+n2*q2hat)
                chi2 = ((x1-n1*p2hat)/q2hat)/sqrt(var)
                ll = phil
                phil = ll/1.0001}}
            i = x2
            j = x1
            ni = n2
            nj = n1
            if( x1==n1 ){
              i = x1
              j = x2
              ni = n1
              nj = n2
            }
            phat1  = i/ni
            phat2  =  j/nj
            phihat = phat2/phat1
            phiu = 1.1*phihat
            if((x2==n2) && (x1==0)) {
              if(n2<100) {phiu = .01}
              else {phiu=0.001}
            }
            chi1 = 0
            while (chi1 >= -z){
              a = (ni+nj)*phiu
              b = -((i+nj)*phiu+j+ni)
              c = i+j
              p1hat = (-b-sqrt(b^2-4*a*c))/(2*a)
              p2hat = p1hat*phiu
              q2hat = 1-p2hat
              var = (ni*nj*p2hat)/(nj*(phiu-p2hat)+ni*q2hat)
              chi1  = ((j-nj*p2hat)/q2hat)/sqrt(var)
              phiu1 = phiu
              phiu = 1.0001*phiu1
            }

            if(x1==n1) {
              ul = (1-(n1-x1)*(1-p0up)/(x2+n1-(n2+n1)*p0up))/p0up
              ll = 1/phiu1
            }
            else{ ul = phiu1}
          }

          else{
            ul = (1-(n1-x1)*(1-p0up)/(x2+n1-(n2+n1)*p0up))/p0up
            ll = (1-(n1-x1)*(1-p0low)/(x2+n1-(n2+n1)*p0low))/p0low
          }
        }
    }
    , "wald" = {
      # based on code by Michael Dewey, 2006

      x1.d <- x1 + delta
      x2.d <- x2 + delta
      lrr <- log(rr)
      se.lrr <- sqrt(1/x1.d - 1/n1 + 1/x2.d - 1/n2)
      mult <- abs(qnorm((1-conf.level)/2))
      ll <- exp(lrr - mult * se.lrr)
      ul <- exp(lrr + mult * se.lrr)
    }
    , "use.or" = {
      or <- OddsRatio(x, conf.level=conf.level)
      p2 <- x2/n2
      rr.ci <- or/((1-p2) + p2 * or)
      ll <- unname(rr.ci[2])
      ul <- unname(rr.ci[3])
    }
    )
  }

  if (is.na(conf.level)) {
    res <- rr
  } else {
    res <- c("rel. risk"=rr, lwr.ci=ll, upr.ci=ul)
  }
  return(res)

}



OddsRatio <- function(x, y = NULL, conf.level = NA, method=c("wald", "mle", "midp")
                      , interval = c(0, 1000), ...) {

  if(!is.null(y)) x <- table(x, y, ...)

  p <- (d <- dim(x))[1L]
  if(!is.numeric(x) || length(d) != 2L || p != d[2L] || p != 2L)
    stop("'x' is not a 2x2 numeric matrix")

  switch( match.arg( arg = method, choices = c("wald", "mle", "midp") )
          , "wald" = {
              if (any(x == 0)) x <- x + 0.5
              lx <- log(x)
              or <- exp(lx[1, 1] + lx[2, 2] - lx[1, 2] - lx[2, 1])

              if(is.na(conf.level)){
                res <- or
              } else {
                # Agresti Categorical Data Analysis, 3.1.1
                sigma2lor <- sum(1/x)
                ci <- or * exp(c(1,-1) * qnorm((1-conf.level)/2) * sqrt(sigma2lor))
                res <- c("odds ratio"=or, lwr.ci=ci[1], upr.ci=ci[2])
              }
          }
          , "mle" = {
              if(is.na(conf.level)){
                res <- unname(fisher.test(x, conf.int=FALSE)$estimate)
              } else {
                res <- fisher.test(x, conf.level=conf.level)
                res <- c(res$estimate, lwr.ci=res$conf.int[1], upr.ci=res$conf.int[2])
              }
          }
          , "midp" = {

              # based on code from Tomas J. Aragon Developer <aragon at berkeley.edu>

              a1 <- x[1,1]; a0 <- x[1,2]; b1 <- x[2,1]; b0 <- x[2,2]; or <- 1

              # median-unbiased estimate function
              mue <- function(a1, a0, b1, b0, or){
                mm <- matrix(c(a1,a0,b1,b0), 2, 2, byrow=TRUE)
                fisher.test(mm, or=or, alternative="l")$p-fisher.test(x=x, or=or, alternative="g")$p
              }
              ##mid-p function
              midp <- function(a1, a0, b1, b0, or = 1){
                mm <- matrix(c(a1,a0,b1,b0),2,2, byrow=TRUE)
                lteqtoa1 <- fisher.test(mm,or=or,alternative="l")$p.val
                gteqtoa1 <- fisher.test(mm,or=or,alternative="g")$p.val
                0.5*(lteqtoa1-gteqtoa1+1)
              }

              # root finding
              EST <- uniroot(
                   function(or){ mue(a1, a0, b1, b0, or)},
                   interval = interval)$root

              if(is.na(conf.level)){
                res <- EST
              } else {

                alpha <- 1 - conf.level
                LCL <- uniroot(function(or){
                  1-midp(a1, a0, b1, b0, or)-alpha/2
                },  interval = interval)$root
                UCL <- 1/uniroot(function(or){
                  midp(a1, a0, b1, b0, or=1/or)-alpha/2
                },  interval = interval)$root

                res <- c("odds ratio" = EST, lwr.ci=LCL, upr.ci= UCL)
              }
          }
  )
  return(res)
}




Conf <- function(x, ...) UseMethod("Conf")


Conf.table <- function(x, pos = NULL, ...) {

  CollapseConfTab <- function(x, pos = NULL, ...) {

    if(nrow(x) > 2) {
      names(attr(x, "dimnames")) <- c("pred", "obs")
      x <- CollapseTable(x, obs=c("neg", pos)[(rownames(x)==pos)+1],
                         pred=c("neg", pos)[(rownames(x)==pos)+1])
    }

    # order confusion table so
    # that the positive class is the first and the others keep their position
    ord <- c(pos, rownames(x)[-grep(pos, rownames(x))])
    # the columnnames must be the same as the rownames
    x <- as.table(x[ord, ord])
    return(x)
  }

  p <- (d <- dim(x))[1L]
  if(!is.numeric(x) || length(d) != 2L || p != d[2L]) # allow nxn!  || p != 2L)
    stop("'x' is not a nxn numeric matrix")

  # observed in columns, predictions in rows
  if(!identical(rownames(x), colnames(x)))
    stop("rownames(x) and colnames(x) must be identical")

  if(is.null(pos)) pos <- rownames(x)[1]
  if(nrow(x)!=2) {
    # ignore pos for nxn tables, pos makes only sense for sensitivity
    # and that is not defined for n-dim tables
    pos <- NULL

  } else {
    # order 2x2-confusion table so
    # that the positive class is the first and the others keep their position
    ord <- c(pos, rownames(x)[-grep(pos, rownames(x))])
    # the columnnames must be the same as the rownames
    x <- as.table(x[ord, ord])
  }

  # overall statistics first
  res <- list(
    table   = x,
    pos     = pos,
    diag    = sum(diag(x)),
    n       = sum(x)
  )
  res <- c(res,
           acc     = BinomCI(x=res$diag, n=res$n),
           sapply(binom.test(x=res$diag, n=res$n,
                             p=max(apply(x, 2, sum) / res$n),
                             alternative = "greater")[c("null.value", "p.value")], unname),
           kappa   = CohenKappa(x),
           mcnemar = mcnemar.test(x)$p.value
  )
  names(res) <- c("table","pos","diag","n","acc","acc.lci","acc.uci",
                  "nri","acc.pval","kappa","mcnemar.pval")

  # byclass
  lst <- list()
  for(i in 1:nrow(x)){

    z <- CollapseConfTab(x=x, pos=rownames(x)[i])
    A <- z[1, 1]; B <- z[1, 2]; C <- z[2, 1]; D <- z[2, 2]

    lst[[i]] <- rbind(
      sens    = A / (A + C),                 # sensitivity
      spec    = D / (B + D),                 # specificity
      ppv     = A / (A + B),                 # positive predicted value
      npv     = D / (C + D),                 # negative predicted value
      prev    = (A + C) / (A + B + C + D),   # prevalence
      detrate = A / (A + B + C + D),         # detection rate
      detprev = (A + C) / (A + B + C + D),   # detection prevalence
      bacc    = mean(c(A / (A + C), D / (B + D)) ),  # balanced accuracy
      fval    = Hmean(c(A / (A + B), A / (A + C))) # guetemass wollschlaeger s. 150
    )
  }

  res <- c(res, byclass=list(do.call(cbind, lst)))
  colnames(res[["byclass"]]) <- rownames(x)

  if(nrow(x)==2) res[["byclass"]] <- res[["byclass"]][, res[["pos"]], drop=FALSE]

  class(res) <- "Conf"

  return(res)

}


Conf.default <-  function(x, ref, pos = NULL, na.rm = TRUE, ...) {
  if(na.rm) {
    idx <- complete.cases(data.frame(x, ref))
    x <- x[idx]
    ref <- ref[idx]
  }
  Conf.table(table(pred=x, obs=ref), pos = pos, ...)
}

Conf.matrix <- function(x, pos = NULL, ...) {
  Conf.table(as.table(x), pos=pos, ...)
}


# the confusion interface for rpart
Conf.rpart <- function(x, ...){
  # y <- attr(x, "ylevels")
  Conf(x=attr(x,"ylevels")[x$frame$yval[x$where]], reference=attr(x,"ylevels")[x$y], ...)
}

Conf.multinom <- function(x, ...){
  if(is.null(x$model)) stop("x does not contain model. Run multinom with argument model=TRUE!")
  resp <- model.extract(x$model, "response")

  # attention: this will not handle correctly responses defined as dummy codes
  # adapt for that!!  ************************************************************
  # resp <- x$response[,1]

  pred <- predict(x, type="class")
  Conf(x=pred, resp, ... )
}


Conf.glm <- function(x, cutoff = 0.5, ...){
  resp <- model.extract(x$model, "response")
  pred <- levels(resp)[(predict(x)>cutoff)+1]
  Conf(x=pred, reference=resp, ... )
}


Conf.randomForest <- function(x, ...){
  Conf(x=x$predicted, reference=x$y, ... )
}


Conf.svm <- function(x, ...){
  Conf(x=predict(x), reference=model.frame(x)[,1], ... )
}


Conf.regr <- function(x, ...){
  NextMethod()
  # Conf(x=Predict(x, type="class"), reference=x$response[,], ... )
}


plot.Conf <- function(x, main="Confusion Matrix", ...){
  mosaicplot(t(x$table), shade=TRUE, main=main, col=c("red", "green"), ...)
}


print.Conf <- function(x, digits = max(3, getOption("digits") - 3), ...) {
  cat("Confusion Matrix and Statistics\n\n")

  names(attr(x$table, "dimnames")) <- c("Prediction","Reference")
  print(x$table, ...)

  if(nrow(x$table)!=2) cat("\nOverall Statistics\n")

  txt <- gettextf("
               Accuracy : %s
                 95%s CI : (%s, %s)
    No Information Rate : %s
    P-Value [Acc > NIR] : %s

                  Kappa : %s
 Mcnemar's Test P-Value : %s\n\n",
                  Format(x$acc, digits=digits), "%",
                  Format(x$acc.lci, digits=digits), Format(x$acc.uci, digits=digits),
                  Format(x$nri, digits=digits), Format(x$acc.pval, fmt="p", na.form="NA"),
                  Format(x$kappa, digits=digits), Format(x$mcnemar.pval, fmt="p", na.form="NA")
                  )
  cat(txt)

  rownames(x$byclass) <- c("Sensitivity", "Specificity", "Pos Pred Value", "Neg Pred Value", "Prevalence",
                           "Detection Rate", "Detection Prevalence", "Balanced Accuracy","F-val Accuracy")

  if(nrow(x$table)==2){
    cat(
      paste(StrPad(paste(rownames(x$byclass), ":"), width=25, adj = "right"),
            Format(x$byclass, digits=digits))
      , sep="\n")

    txt <- gettextf("\n       'Positive' Class : %s\n\n", x$pos)
    cat(txt)

  } else {

    cat("\nStatistics by Class:\n\n")
    print(Format(x$byclass, digits = digits, na.form="NA"), quote = FALSE)
    cat("\n")

  }

}



Sens <- function(x, ...) Conf(x, ...)[["byclass"]]["sens",]

Spec <- function(x, ...) Conf(x, ...)[["byclass"]]["spec",]




# Cohen, Jacob. 1988. Statistical power analysis for the behavioral
# sciences, (2nd edition). Lawrence Erlbaum Associates, Hillsdale, New
# Jersey, United States.

# Garson, G. David. 2007. Statnotes: Topics in Multivariate
# Analysis. URL:
# http://www2.chass.ncsu.edu/garson/pa765/statnote.htm. Visited Spring
# 2006 -- Summer 2007.

# Goodman, Leo A. and William H. Kruskal. 1954. Measures of Association
# for Cross-Classifications. Journal of the American Statistical
# Association, Vol. 49, No. 268 (December 1954), pp. 732-764.

# Liebetrau, Albert M. 1983. Measures of Association. Sage University
# Paper series on Quantitative Applications in the Social Sciences,
# 07-032. Sage Publications, Beverly Hills and London, United
# States/England.

# Margolin, Barry H. and Richard J. Light. 1974. An Analysis of Variance
# for Categorical Data II: Small Sample Comparisons with Chi Square and
# Other Competitors. Journal of the American Statistical Association,
# Vol. 69, No. 347 (September 1974), pp. 755-764.

# Reynolds, H. T. 1977. Analysis of Nominal Data. Sage University Paper
# series on Quantitative Applications in the Social Sciences, 08-007,
# Sage Publications, Beverly Hills/London, California/UK.

# SAS Institute. 2007. Measures of Association
# http://support.sas.com/onlinedoc/913/getDoc/en/statug.hlp/freq_sect20.htm
# Visited January 2007.

# Theil, Henri. 1970. On the Estimation of Relationships Involving
# Qualitative Variables.  The American Journal of Sociology, Vol. 76,
# No. 1 (July 1970), pp. 103-154.

# N.B. One should use the values for the significance of the
# Goodman-Kruskal lambda and Theil's UC with reservation, as these
# have been modeled to mimic the the behavior of the same statistics
# in SPSS.



GoodmanKruskalTauA <- function(x, y = NULL, direction = c("row", "column"), conf.level = NA, ...){

  if(!is.null(y)) x <- table(x, y, ...)

  n <- sum(x)
  n.err.unconditional <- n^2
  sum.row <- rowSums(x)
  sum.col <- colSums(x)

  switch( match.arg( arg = direction, choices = c("row", "column") )
          , "column" = {             # Tau Column|Row

            for(i in 1:nrow(x))
              n.err.unconditional <- n.err.unconditional-n*sum(x[i,]^2/sum.row[i])
            n.err.conditional <- n^2-sum(sum.col^2)
            tau.CR <- 1-(n.err.unconditional/n.err.conditional)
            v <- n.err.unconditional/(n^2)
            d <- n.err.conditional/(n^2)
            f <- d*(v+1)-2*v
            var.tau.CR <- 0
            for(i in 1:nrow(x))
              for(j in 1:ncol(x))
                var.tau.CR <- var.tau.CR + x[i,j]*(-2*v*(sum.col[j]/n)+d*((2*x[i,j]/sum.row[i])-sum((x[i,]/sum.row[i])^2))-f)^2/(n^2*d^4)
            ASE.tau.CR <- sqrt(var.tau.CR)
            est <- tau.CR
            sigma2 <- ASE.tau.CR^2
          }
          , "row" = {             # Tau Row|Column

            for(j in 1:ncol(x))
              n.err.unconditional <- n.err.unconditional-n*sum(x[,j]^2/sum.col[j])
            n.err.conditional <- n^2-sum(sum.row^2)
            tau.RC <- 1-(n.err.unconditional/n.err.conditional)
            v <- n.err.unconditional/(n^2)
            d <- n.err.conditional/(n^2)
            f <- d*(v+1)-2*v
            var.tau.RC <- 0
            for(i in 1:nrow(x))
              for(j in 1:ncol(x))
                var.tau.RC <- var.tau.RC + x[i,j]*(-2*v*(sum.row[i]/n)+d*((2*x[i,j]/sum.col[j])-sum((x[,j]/sum.col[j])^2))-f)^2/(n^2*d^4)
            ASE.tau.RC <- sqrt(var.tau.RC)
            est <- tau.RC
            sigma2 <- ASE.tau.RC^2
          }
  )

  if(is.na(conf.level)){
    res <- est
  } else {
    pr2 <- 1 - (1 - conf.level)/2
    ci <- qnorm(pr2) * sqrt(sigma2) * c(-1, 1) + est
    res <- c(tauA=est, lwr.ci=ci[1], upr.ci=ci[2])
  }

  return(res)
}


# good description
# http://salises.mona.uwi.edu/sa63c/Crosstabs%20Measures%20for%20Nominal%20Data.htm

Lambda <- function(x, y = NULL, direction = c("symmetric", "row", "column"), conf.level = NA, ...){

  if(!is.null(y)) x <- table(x, y, ...)

  # Guttman'a lambda (1941), resp. Goodman Kruskal's Lambda (1954)

  n <- sum(x)
  csum <- colSums(x)
  rsum <- rowSums(x)
  rmax <- apply(x, 1, max)
  cmax <- apply(x, 2, max)
  max.rsum <- max(rsum)
  max.csum <- max(csum)

  nr <- nrow(x)
  nc <- ncol(x)

  switch( match.arg( arg = direction, choices = c("symmetric", "row", "column") )
          , "symmetric" = { res <- 0.5*(sum(rmax, cmax) - (max.csum +  max.rsum)) / (n - 0.5*(max.csum +  max.rsum)) }
          , "column" = { res <- (sum(rmax) - max.csum) / (n - max.csum) }
          , "row" = { res <- (sum(cmax) - max.rsum) / (n - max.rsum) }
  )

  if(is.na(conf.level)){
    res <- res
  } else {

    L.col <- matrix(,nc)
    L.row <- matrix(,nr)

    switch( match.arg( arg = direction, choices = c("symmetric", "row", "column") )
            , "symmetric" = {

#     How to see:
#     http://support.sas.com/documentation/cdl/en/statugfreq/63124/PDF/default/statugfreq.pdf
#     pp. 1744
#     Author:   Nina

              l <- which.max(csum)
              k <- which.max(rsum)
              li <- apply(x,1,which.max)
              ki <- apply(x,2,which.max)

              w <- 2*n-max.csum-max.rsum
              v <- 2*n -sum(rmax,cmax)
              xx <- sum(rmax[li==l], cmax[ki==k], rmax[k], cmax[l])
              y <- 8*n-w-v-2*xx

              t <- rep(NA, length(li))
              for (i in 1:length(li)){
                t[i] <- (ki[li[i]]==i & li[ki[li[i]]]==li[i])
              }

              sigma2 <- 1/w^4*(w*v*y-2 *w^2*(n - sum(rmax[t]))-2*v^2*(n-x[k,l]))

            }
            , "column" = {
              L.col.max <- min(which(csum == max.csum))
              for(i in 1:nr) {
                if(length(which(x[i, intersect(which(x[i,] == max.csum), which(x[i,] == max.rsum))] == n))>0)
                  L.col[i] <- min(which(x[i, intersect(which(x[i,] == max.csum), which(x[i,] == max.rsum))] == n))
                else
                  if(x[i, L.col.max] == max.csum)
                    L.col[i] <- L.col.max
                  else
                    L.col[i] <- min(which(x[i,] == rmax[i]))
              }
              sigma2 <- (n-sum(rmax))*(sum(rmax) + max.csum -
                                         2*(sum(rmax[which(L.col == L.col.max)])))/(n-max.csum)^3
            }
            , "row" = {
              L.row.max <- min(which(rsum == max.rsum))
              for(i in 1:nc) {
                if(length(which(x[intersect(which(x[,i] == max.rsum), which(x[,i] == max.csum)),i] == n))>0)
                  L.row[i] <- min(which(x[i,intersect(which(x[i,] == max.csum), which(x[i,] == max.rsum))] == n))
                else
                  if(x[L.row.max,i] == max.rsum)
                    L.row[i] <- L.row.max
                else
                  L.row[i] <- min(which(x[,i] == cmax[i]))
              }
              sigma2 <- (n-sum(cmax))*(sum(cmax) + max.rsum -
                                         2*(sum(cmax[which(L.row == L.row.max)])))/(n-max.rsum)^3
            }
    )

    pr2 <- 1 - (1 - conf.level)/2
    ci <- pmin(1, pmax(0, qnorm(pr2) * sqrt(sigma2) * c(-1, 1) + res))
    res <- c(lambda = res,  lwr.ci=ci[1], ups.ci=ci[2])
  }

  return(res)
}



UncertCoef <- function(x, y = NULL, direction = c("symmetric", "row", "column"),
                             conf.level = NA, p.zero.correction = 1/sum(x)^2, ... ) {
  # Theil's UC (1970)
  # slightly nudge zero values so that their logarithm can be calculated (cf. Theil 1970: x->0 => xlogx->0)
  if(!is.null(y)) x <- table(x, y, ...)

  x[x == 0] <- p.zero.correction

  n <- sum(x)
  rsum <- apply(x, 1, sum)
  csum <- apply(x, 2, sum)

  hx <- -sum((apply(x, 1, sum) * log(apply(x, 1, sum)/n))/n)
  hy <- -sum((apply(x, 2, sum) * log(apply(x, 2, sum)/n))/n)
  hxy <- -sum(apply(x, c(1, 2), sum) * log(apply(x, c(1, 2), sum)/n)/n)

  switch( match.arg( arg = direction, choices = c("symmetric", "row", "column") )
          , "symmetric" = { res <- 2 * (hx + hy - hxy)/(hx + hy) }
          , "row" = { res <- (hx + hy - hxy)/hx }
          , "column" = { res <- (hx + hy - hxy)/hy }
  )

  if(!is.na(conf.level)){
    var.uc.RC <- var.uc.CR <- 0
    for(i in 1:nrow(x))
      for(j in 1:ncol(x))
      { var.uc.RC <- var.uc.RC + x[i,j]*(hx*log(x[i,j]/csum[j])+((hy-hxy)*log(rsum[i]/n)))^2/(n^2*hx^4);
        var.uc.CR <- var.uc.CR + x[i,j]*(hy*log(x[i,j]/rsum[i])+((hx-hxy)*log(csum[j]/n)))^2/(n^2*hy^4);
      }
    switch( match.arg( arg = direction, choices = c("symmetric", "row", "column") )
            , "symmetric" = {
              sigma2 <- 4*sum(x * (hxy * log(rsum %o% csum/n^2) - (hx+hy)*log(x/n))^2 ) /
                (n^2*(hx+hy)^4)
            }
            , "row" = { sigma2 <- var.uc.RC }
            , "column" = { sigma2 <- var.uc.CR }
    )

    pr2 <- 1 - (1 - conf.level)/2
    ci <- qnorm(pr2) * sqrt(sigma2) * c(-1, 1) + res

    res <- c(uc = res,  lwr.ci=max(ci[1], -1), ups.ci=min(ci[2], 1))
  }
  return(res)
}


TheilU <- function(a, p, type = c(2, 1), na.rm = FALSE){

  if(na.rm) {
    idx <- complete.cases(a, p)
    a <- a[idx]
    p <- p[idx]
  }
  n <- length(a)
  if(length(p)!=n) {
    warning("a must have same length as p")
    res <- NA
  } else {
    switch( match.arg(as.character(type), c("2", "1"))
            , "1" = { res <- sqrt(sum((a-p)^2/n))/(sqrt(sum(a^2)/n) + sqrt(sum(p^2)/n)) }
            , "2" = { res <- sqrt(sum((a-p)^2))/(sqrt(sum(a^2))) }
            )
  }
  return(res)

}


#S function SomersDelta
#
#    Calculates concordance probability and Somers'  Dxy  rank  correlation
#    between  a  variable  X  (for  which  ties are counted) and a binary
#    variable Y (having values 0 and 1, for which ties are not  counted).
#    Uses short cut method based on average ranks in two groups.
#
#    Usage:
#
#         SomersDelta(x, y, weights)
#
#    Returns vector whose elements are C Index, Dxy, n and missing, where
#    C Index is the concordance probability and Dxy=2(C Index-.5).
#
#    F. Harrell 28 Nov 90     6 Apr 98: added weights
#
# SomersDelta2 <- function(x, y, weights=NULL, normwt=FALSE, na.rm=TRUE) {
#
#   wtd.mean <- function(x, weights=NULL, normwt='ignored', na.rm=TRUE)
#   {
#     if(!length(weights)) return(mean(x, na.rm=na.rm))
#     if(na.rm) {
#       s <- !is.na(x + weights)
#       x <- x[s]
#       weights <- weights[s]
#     }
#
#     sum(weights*x)/sum(weights)
#   }
#
#   wtd.table <- function(x, weights=NULL, type=c('list','table'),
#                         normwt=FALSE, na.rm=TRUE)
#   {
#     type <- match.arg(type)
#     if(!length(weights))
#       weights <- rep(1, length(x))
#
#     isdate <- IsDate(x)  ### 31aug02 + next 2
#     ax <- attributes(x)
#     ax$names <- NULL
#     x <- if(is.character(x)) as.category(x)
#          else unclass(x)
#
#     lev <- levels(x)
#     if(na.rm) {
#       s <- !is.na(x + weights)
#       x <- x[s,drop=FALSE]    ### drop is for factor class
#       weights <- weights[s]
#     }
#
#     n <- length(x)
#     if(normwt)
#       weights <- weights*length(x)/sum(weights)
#
#     i <- order(x)  ### R does not preserve levels here
#     x <- x[i]; weights <- weights[i]
#
#     if(any(diff(x)==0)) {  ### slightly faster than any(duplicated(xo))
#       weights <- tapply(weights, x, sum)
#       if(length(lev)) {    ### 3apr03
#         levused <- lev[sort(unique(x))]  ### 7sep02
#         ### Next 3 lines 21apr03
#         if((length(weights) > length(levused)) &&
#            any(is.na(weights)))
#           weights <- weights[!is.na(weights)]
#
#         if(length(weights) != length(levused))
#           stop('program logic error')
#
#         names(weights) <- levused   ### 10Apr01  length 16May01
#       }
#
#       if(!length(names(weights)))
#         stop('program logic error')  ### 16May01
#
#       if(type=='table')
#         return(weights)
#
#       x <- all.is.numeric(names(weights),'vector')
#       if(isdate)
#         attributes(x) <- c(attributes(x),ax)   ### 31aug02
#
#       names(weights) <- NULL
#       return(list(x=x, sum.of.weights=weights))
#     }
#
#     xx <- x  ### 31aug02
#     if(isdate)
#       attributes(xx) <- c(attributes(xx),ax)
#
#     if(type=='list')
#       list(x=if(length(lev))lev[x]
#              else xx,
#            sum.of.weights=weights)
#     else {
#       names(weights) <- if(length(lev)) lev[x]
#                         else xx
#       weights
#     }
#   }
#
#
#   wtd.rank <- function(x, weights=NULL, normwt=FALSE, na.rm=TRUE)
#   {
#     if(!length(weights))
#       return(rank(x),na.last=if(na.rm)NA else TRUE)
#
#     tab <- wtd.table(x, weights, normwt=normwt, na.rm=na.rm)
#
#     freqs <- tab$sum.of.weights
#     ### rank of x = ### <= x - .5 (# = x, minus 1)
#     r <- cumsum(freqs) - .5*(freqs-1)
#     ### Now r gives ranks for all unique x values.  Do table look-up
#     ### to spread these ranks around for all x values.  r is in order of x
#     approx(tab$x, r, xout=x)$y
#   }
#
#
#   if(length(y)!=length(x))stop("y must have same length as x")
#   y <- as.integer(y)
#   wtpres <- length(weights)
#   if(wtpres && (wtpres != length(x)))
#     stop('weights must have same length as x')
#
#   if(na.rm) {
#       miss <- if(wtpres) is.na(x + y + weights)
#       else is.na(x + y)
#
#       nmiss <- sum(miss)
#       if(nmiss>0) {
#           miss <- !miss
#           x <- x[miss]
#           y <- y[miss]
#           if(wtpres) weights <- weights[miss]
#         }
#     }
#   else nmiss <- 0
#
#   u <- sort(unique(y))
#   if(any(! y %in% 0:1)) stop('y must be binary')
#
#   if(wtpres) {
#       if(normwt)
#         weights <- length(x)*weights/sum(weights)
#       n <- sum(weights)
#     }
#   else n <- length(x)
#
#   if(n<2) stop("must have >=2 non-missing observations")
#
#   n1 <- if(wtpres)sum(weights[y==1]) else sum(y==1)
#
#   if(n1==0 || n1==n)
#     return(c(C=NA,Dxy=NA,n=n,Missing=nmiss))
#
#   mean.rank <- if(wtpres)
#       wtd.mean(wtd.rank(x, weights, na.rm=FALSE), weights*y)
#     else
#       mean(rank(x)[y==1])
#
#   c.index <- (mean.rank - (n1+1)/2)/(n-n1)
#   dxy <- 2*(c.index-.5)
#   r <- c(c.index, dxy, n, nmiss)
#   names(r) <- c("C", "Dxy", "n", "Missing")
#   r
# }
#


SomersDelta <- function(x,  y = NULL, direction=c("row","column"), conf.level = NA, ...) {

  if(!is.null(y)) tab <- table(x, y, ...)
  else tab <- as.table(x)

  # tab is a matrix of counts
  x <- ConDisPairs(tab)

# use .DoCount
#   if(is.na(conf.level)) {
#     d.tab <- as.data.frame.table(tab)
#     x <- .DoCount(d.tab[,1], d.tab[,2], d.tab[,3])
#   } else {
#     x <- ConDisPairs(tab)
#   }

  m <- min(dim(tab))
  n <- sum(tab)
  switch( match.arg( arg = direction, choices = c("row","column") )
    , "row" = { ni. <- apply(tab, 2, sum) }
    , "column" = { ni. <- apply(tab, 1, sum) }
  )
  wt <- n^2 - sum(ni.^2)
  # Asymptotic standard error: sqrt(sigma2)
  sigma2 <- 4/wt^4 * (sum(tab * (wt*(x$pi.c - x$pi.d) - 2*(x$C-x$D)*(n-ni.))^2))
  # debug: print(sqrt(sigma2))

  somers <- (x$C - x$D) / (n * (n-1) /2 - sum(ni. * (ni. - 1) /2 ))

  pr2 <- 1 - (1 - conf.level)/2
  ci <- qnorm(pr2) * sqrt(sigma2) * c(-1, 1) + somers

  if(is.na(conf.level)){
    result <- somers
  } else {
    result <- c(somers = somers,  lwr.ci=max(ci[1], -1), ups.ci=min(ci[2], 1))
  }

  return(result)

}


# Computes rank correlation measures between a variable X and a possibly
# censored variable Y, with event/censoring indicator EVENT
# Rank correlation is extension of Somers' Dxy = 2(Concordance Prob-.5)
# See Harrell et al JAMA 1984(?)
# Set outx=T to exclude ties in X from computations (-> Goodman-Kruskal
#  gamma-type rank correlation)
# based on rcorr.cens in Hmisc, https://stat.ethz.ch/pipermail/r-help/2003-March/030837.html
# author Frank Harrell


# GoodmanGammaF <- function(x, y) {

  # ### Fortran implementation of Concordant/Discordant, but still O(n^2)

  # x <- as.numeric(x)
  # y <- as.numeric(y)

  # event <-  rep(TRUE, length(x))
  # if(length(y)!=length(x))
    # stop("y must have same length as x")

  # outx <- TRUE
  # n <- length(x)
  # ne <- sum(event)

  # z <- .Fortran("cidxcn", x, y, event, length(x), nrel=double(1), nconc=double(1),
                # nuncert=double(1),
                # c.index=double(1), gamma=double(1), sd=double(1), as.logical(outx)
  # )

  # r <- c(z$c.index, z$gamma, z$sd, n, ne, z$nrel, z$nconc, z$nuncert)
  # names(r) <- c("C Index","Dxy","S.D.","n","uncensored",
                # "Relevant Pairs",
                # "Concordant","Uncertain")
  # unname(r[2])

# }


# GoodmanGamma(as.numeric(d.frm$Var1), as.numeric(d.frm$Var2))
# cor(as.numeric(d.frm$Var1), as.numeric(d.frm$Var2))

GoodmanKruskalGamma <- function(x, y = NULL, conf.level = NA, ...) {

  if(!is.null(y)) tab <- table(x, y, ...)
  else tab <- as.table(x)

  # tab is a matrix of counts
  # Based on code of Michael Friendly and Laura Thompson
  # Confidence interval calculation and output from Greg Rodd

  x <- ConDisPairs(tab)

  psi <- 2 * (x$D * x$pi.c - x$C * x$pi.d)/(x$C + x$D)^2
  # Asymptotic standard error: sqrt(sigma2)
  sigma2 <- sum(tab * psi^2) - sum(tab * psi)^2

  gamma <- (x$C - x$D)/(x$C + x$D)

  if(is.na(conf.level)){
    result <- gamma
  } else {
    pr2 <- 1 - (1 - conf.level)/2
    ci <- qnorm(pr2) * sqrt(sigma2) * c(-1, 1) + gamma
    result <- c(gamma = gamma,  lwr.ci=max(ci[1], -1), ups.ci=min(ci[2], 1))
  }

  return(result)

}


# KendallTauB.table <- function(tab, conf.level = NA) {

  # http://support.sas.com/documentation/cdl/en/statugfreq/63124/PDF/default/statugfreq.pdf
  # pp 1738

  # tab is a matrix of counts

  # x <- ConDisPairs(tab)

  # n <- sum(tab)
  # ni. <- apply(tab, 1, sum)
  # n.j <- apply(tab, 2, sum)
  # wr <- n^2 - sum(ni.^2)
  # wc <- n^2 - sum(n.j^2)
  # w <- sqrt(wr * wc)
  # vij <- ni. * wc + n.j * wr
  # dij <- x$pi.c - x$pi.d    ### Aij - Dij

  # Asymptotic standard error: sqrt(sigma2)
  # sigma2 <- 1/w^4 * (sum(tab * (2*w*dij + taub*vij)^2) - n^3 * taub^2 * (wr + wc)^2)

  # this is the H0 = 0 variance:
  # sigma2 <- 4/(wr * wc) * (sum(tab * (x$pi.c - x$pi.d)^2) - 4*(x$C - x$D)^2/n )


  # taub <- 2*(x$C - x$D)/sqrt(wr * wc)

  # if(is.na(conf.level)){
    # result <- taub
  # } else {
    # pr2 <- 1 - (1 - conf.level)/2
    # ci <- qnorm(pr2) * sqrt(sigma2) * c(-1, 1) + taub
    # result <- c(taub = taub,  lwr.ci=max(ci[1], -1), ups.ci=min(ci[2], 1))
  # }

  # return(result)

# }


# KendallTauB <- function(x, y = NULL, conf.level = NA, test=FALSE, alternative = c("two.sided", "less", "greater"), ...){
  KendallTauB <- function(x, y = NULL, conf.level = NA, ...){

  # Ref: http://www.fs.fed.us/psw/publications/lewis/LewisHMP.pdf
  # pp 2-9
  #
  if (!is.null(y)) {
    dname <- paste(deparse(substitute(x)), "and", deparse(substitute(y)))
  } else {
    dname <- deparse(substitute(x))
  }

  if(!is.null(y)) tab <- table(x, y, ...)
  else tab <- as.table(x)

  x <- ConDisPairs(tab)

  n <- sum(tab)
  n0 <- n*(n-1)/2
  ti <- apply(tab, 1, sum)
  uj <- apply(tab, 2, sum)
  n1 <- sum(ti * (ti-1) / 2)
  n2 <- sum(uj * (uj-1) / 2)

  taub <- (x$C - x$D) / sqrt((n0-n1)*(n0-n2))

  pi <- tab / sum(tab)

  pdiff <- (x$pi.c - x$pi.d) / sum(tab)
  Pdiff <- 2 * (x$C - x$D) / sum(tab)^2

  rowsum <- apply(pi, 1, sum)
  colsum <- apply(pi, 2, sum)

  rowmat <- matrix(rep(rowsum, dim(tab)[2]), ncol = dim(tab)[2])
  colmat <- matrix(rep(colsum, dim(tab)[1]), nrow = dim(tab)[1], byrow = T)

  delta1 <- sqrt(1 - sum(rowsum^2))
  delta2 <- sqrt(1 - sum(colsum^2))

  # Compute asymptotic standard errors taub
  tauphi <- (2 * pdiff + Pdiff * colmat) * delta2 * delta1 + (Pdiff * rowmat * delta2)/delta1
  sigma2 <- ((sum(pi * tauphi^2) - sum(pi * tauphi)^2)/(delta1 * delta2)^4) / n

  if (is.na(conf.level)) {
    result <- taub
  }
  else {
    pr2 <- 1 - (1 - conf.level)/2
    ci <- qnorm(pr2) * sqrt(sigma2) * c(-1, 1) + taub
    result <- c(tau_b = taub, lwr.ci = max(ci[1], -1), ups.ci = min(ci[2], 1))
  }

#   if(test){
#
#     alternative <- match.arg(alternative)
#
#     zstat <- taub / sqrt(sigma2)
#
#     if (alternative == "less") {
#       pval <- pnorm(zstat)
#       cint <- c(-Inf, zstat + qnorm(conf.level))
#     }
#     else if (alternative == "greater") {
#       pval <- pnorm(zstat, lower.tail = FALSE)
#       cint <- c(zstat - qnorm(conf.level), Inf)
#     }
#     else {
#       pval <- 2 * pnorm(-abs(zstat))
#       alpha <- 1 - conf.level
#       cint <- qnorm(1 - alpha/2)
#       cint <- zstat + c(-cint, cint)
#     }
#
#     RVAL <- list()
#     RVAL$p.value <- pval
#     RVAL$method <- "Kendall's rank correlation tau"
#     RVAL$data.name <- dname
#     RVAL$statistic <- x$C - x$D
#     names(RVAL$statistic) <- "T"
#     RVAL$estimate <- taub
#     names(RVAL$estimate) <- "tau-b"
#     RVAL$conf.int <- c(max(ci[1], -1), min(ci[2], 1))
#   #  attr(RVAL$conf.int, "conf.level") = round(attr(ci,"conf.level"), 3)
#     class(RVAL) <- "htest"
#     return(RVAL)
#
# #     rval <- list(statistic = zstat, p.value = pval,
# #                  parameter = sd_pop,
# #                  conf.int = cint, estimate = estimate, null.value = mu,
# #                  alternative = alternative, method = method, data.name = dname)
#
#   } else {
    return(result)
#   }

}

# KendallTauB(x, y, conf.level = 0.95, test=TRUE)
#
# cor.test(x,y, method="kendall")

# tab <- as.table(rbind(c(26,26,23,18,9),c(6,7,9,14,23)))
# KendallTauB(tab, conf.level = 0.95)
# Assocs(tab)

StuartTauC <- function(x, y = NULL, conf.level = NA, ...) {

  if(!is.null(y)) tab <- table(x, y, ...)
  else tab <- as.table(x)

  # Reference:
  # http://v8doc.sas.com/sashtml/stat/chap28/sect18.htm
  x <- ConDisPairs(tab)

  m <- min(dim(tab))
  n <- sum(tab)
  # Asymptotic standard error: sqrt(sigma2)
  sigma2 <- 4 * m^2 / ((m-1)^2 * n^4) * (sum(tab * (x$pi.c - x$pi.d)^2) - 4 * (x$C -x$D)^2/n)
  # debug: print(sqrt(sigma2))

  # Tau-c = (C - D)*[2m/(n2(m-1))]
  tauc <- (x$C - x$D) * 2 * min(dim(tab)) / (sum(tab)^2*(min(dim(tab))-1))

  if(is.na(conf.level)){
    result <- tauc
  } else {
    pr2 <- 1 - (1 - conf.level)/2
    CI <- qnorm(pr2) * sqrt(sigma2) * c(-1, 1) + tauc
    result <- c(tauc = tauc,  lwr.ci=max(CI[1], -1), ups.ci=min(CI[2], 1))
  }

  return(result)

}




SpearmanRho <- function(x, y = NULL, use = c("everything", "all.obs", "complete.obs",
            "na.or.complete","pairwise.complete.obs"), conf.level = NA ) {

  if(is.null(y)) {
    x <- Untable(x)
    y <- x[,2]
    x <- x[,1]
  }
  # Reference:
  #   https://stat.ethz.ch/pipermail/r-help/2006-October/114319.html
  # fisher z transformation for calc SpearmanRho ci :
  # Conover WJ, Practical Nonparametric Statistics (3rd edition). Wiley 1999.

  # http://support.sas.com/documentation/cdl/en/statugfreq/63124/PDF/default/statugfreq.pdf
  # pp 1738


  # n <- sum(tab)
  # ni. <- apply(tab, 1, sum)
  # n.j <- apply(tab, 2, sum)
  # F <- n^3 - sum(ni.^3)
  # G <- n^3 - sum(n.j^3)
  # w <- 1/12*sqrt(F * G)

  # ### Asymptotic standard error: sqrt(sigma2)
  # sigma2 <- 1
  # ### debug: print(sqrt(sigma2))

  # ### Tau-c = (C - D)*[2m/(n2(m-1))]
  # est <- 1

  # if(is.na(conf.level)){
    # result <- tauc
  # } else {
    # pr2 <- 1 - (1 - conf.level)/2
    # CI <- qnorm(pr2) * sqrt(sigma2) * c(-1, 1) + est
    # result <- c(SpearmanRho = est,  lwr.ci=max(CI[1], -1), ups.ci=min(CI[2], 1))
  # }

  # return(result)


  # Ref:
  # http://www-01.ibm.com/support/docview.wss?uid=swg21478368

  use <- match.arg(use, choices=c("everything", "all.obs", "complete.obs",
            "na.or.complete","pairwise.complete.obs"))

  rho <- cor(as.numeric(x), as.numeric(y), method="spearman", use = use)

  e_fx <- exp( 2 * ((.5 * log((1+rho) / (1-rho))) - c(1, -1) *
      (abs(qnorm((1 - conf.level)/2))) * (1 / sqrt(sum(complete.cases(x,y)) - 3)) ))
  ci <- (e_fx - 1) / (e_fx + 1)

  if (is.na(conf.level)) {
    result <- rho
  } else {
    pr2 <- 1 - (1 - conf.level) / 2
    result <- c(rho = rho, lwr.ci = max(ci[1], -1), ups.ci = min(ci[2], 1))
  }
  return(result)

}



# Definitions:
# http://v8doc.sas.com/sashtml/stat/chap28/sect18.htm

ConDisPairs <-function(x){

  # tab is a matrix of counts
  # Based on code of Michael Friendly and Laura Thompson

  # slooooow because of 2 nested for clauses O(n^2)
  # this is NOT faster when implemented with a mapply(...)

  # Lookin for alternatives in C
  # http://en.verysource.com/code/1169955_1/kendl2.cpp.html
  # cor(..., "kendall") is for dimensions better

  n <- nrow(x)
  m <- ncol(x)
  pi.c <- pi.d <- matrix(0, nrow = n, ncol = m)

  row.x <- row(x)
  col.x <- col(x)

  for(i in 1:n){
    for(j in 1:m){
      pi.c[i, j] <- sum(x[row.x<i & col.x<j]) + sum(x[row.x>i & col.x>j])
      pi.d[i, j] <- sum(x[row.x<i & col.x>j]) + sum(x[row.x>i & col.x<j])
    }
  }
  C <- sum(pi.c * x)/2
  D <- sum(pi.d * x)/2

  return(list(pi.c = pi.c, pi.d = pi.d, C = C, D = D))

}


BinTree <- function(n) {
  ranks <- rep(0L, n)
  yet.to.do <- 1:n
  depth <- floor(logb(n, 2))
  start <- as.integer(2^depth)
  lastrow.length <- 1 + n - start
  indx <- seq(1L, by = 2L, length = lastrow.length)
  ranks[yet.to.do[indx]] <- start + 0:(length(indx) - 1L)
  yet.to.do <- yet.to.do[-indx]
  while (start > 1) {
    start <- as.integer(start/2)
    indx <- seq(1L, by = 2L, length = start)
    ranks[yet.to.do[indx]] <- start + 0:(start - 1L)
    yet.to.do <- yet.to.do[-indx]
  }
  ranks
}


.DoCount <- function(y, x, wts) {

  # O(n log n):
  # http://www.listserv.uga.edu/cgi-bin/wa?A2=ind0506d&L=sas-l&P=30503



  if(missing(wts)) wts <- rep(1, length(x))

  ord <- order(y)
  ux <- sort(unique(x))
  n2 <- length(ux)
  index <- BinTree(n2)[match(x[ord], ux)] - 1L
  y <- cbind(y,1)
  res <- .Call("conc", y[ord,], as.double(wts[ord]),
        as.integer(index), as.integer(n2))

  return(list(pi.c = NA, pi.d = NA, C = res[2], D = res[1]))

}

# .DoCount(x, y) will do ConDisPairs but yet without se


# ConDisPairs(tab1)
# ConDisPairs2(tab1)
# some code of Marc Schwartz
# https://stat.ethz.ch/pipermail/r-help/2006-September/112806.html
# but this is not significantly better than friendly's version

# ConDisPairs2 <-function(x){
#
#   ### tab is a matrix of counts
#
#   mat.lr <- function(r, c) {
#     lr <- c( x[(r.x < r) & (c.x < c)], x[(r.x > r) & (c.x > c)] )
#     sum(lr)
#   }
#
#   mat.ll <- function(r, c)  {
#     ll <- c(x[(r.x < r) & (c.x > c)], x[(r.x > r) & (c.x < c)])
#     sum(ll)
#   }
#
#   ### get row and column index for each
#   ### matrix element
#   r.x <- row(x)
#   c.x <- col(x)
#
#   ### return the sum of each matrix[r, c] * sums
#   ### using mapply to sequence thru each matrix[r, c]
#   pi.c <- matrix(mapply(mat.lr, r = r.x, c = c.x), dim(x))
#   pi.d <- matrix(mapply(mat.ll, r = r.x, c = c.x), dim(x))
#
#   C <- sum(pi.c * x)/2
#   D <- sum(pi.d * x)/2
#
#   return(list(pi.c = pi.c, pi.d = pi.d, C = C, D = D))
#
# }

# all association measures combined

Assocs <- function(x, conf.level = 0.95){

  # this is from boot::corr combined with ci logic from cor.test
  r <- corr(d=CombPairs(1:nrow(x), 1:ncol(x)), as.vector(x))
  r.ci <- CorCI(rho = r, n = sum(x), conf.level = conf.level)

  res <- rbind(
    "Phi Coeff." = c(Phi(x), NA, NA)
    , "Contingency Coeff." = c(ContCoef(x),NA, NA)
    , "Cramer V" = CramerV(x, conf.level=conf.level)
    , "Goodman Kruskal Gamma" = GoodmanKruskalGamma(x, conf.level=conf.level)
    , "Kendall Tau-b" = KendallTauB(x, conf.level=conf.level)
    , "Stuart Tau-c" = StuartTauC(x, conf.level=conf.level)
    , "Somers D C|R" = SomersDelta(x, direction="column", conf.level=conf.level)
    , "Somers D R|C" = SomersDelta(x, direction="r", conf.level=conf.level)
#    , "Pearson Correlation" =c(cor.p$estimate, lwr.ci=cor.p$conf.int[1], upr.ci=cor.p$conf.int[2])
    , "Pearson Correlation" =c(r.ci[1], lwr.ci=r.ci[2], upr.ci=r.ci[3])
    , "Spearman Correlation" = SpearmanRho(x, conf.level=conf.level)
    , "Lambda C|R" = Lambda(x, direction="column", conf.level=conf.level)
    , "Lambda R|C" = Lambda(x, direction="row", conf.level=conf.level)
    , "Lambda sym" = Lambda(x, direction="sym", conf.level=conf.level)
    , "Uncertainty Coeff. C|R" = UncertCoef(x, direction="column", conf.level=conf.level)
    , "Uncertainty Coeff. R|C" = UncertCoef(x, direction="row", conf.level=conf.level)
    , "Uncertainty Coeff. sym" = UncertCoef(x, direction="sym", conf.level=conf.level)
    , "Mutual Information" = c(MutInf(x),NA,NA)
  )

  dimnames(res)[[2]][1] <- "estimate"
  class(res) <- c("Assocs", class(res))
  return(res)

}


print.Assocs <- function(x, digits=4, ...){
  out <- apply(round(x, digits), 2, Format, digits=digits)
  out[c(1,2,17), 2:3] <- "      -"
  dimnames(out) <- dimnames(x)

  print(data.frame(out), quote=FALSE)
}




## This is an exact copy from Hmisc
## Changes since sent to statlib: improved printing N matrix in print.hoeffd

HoeffD <- function(x, y) {

  phoeffd <- function(d, n)  {

    d <- as.matrix(d); n <- as.matrix(n)
    b <- d + 1/36/n
    z <- .5*(pi^4)*n*b
    zz <- as.vector(z)
    zz[is.na(zz)] <- 1e30   # so approx won't bark

    tabvals <- c(5297,4918,4565,4236,3930,
                 3648,3387,3146,2924,2719,2530,2355,
                 2194,2045,1908,1781,1663,1554,1453,
                 1359,1273,1192,1117,1047,0982,0921,
                 0864,0812,0762,0716,0673,0633,0595,
                 0560,0527,0496,0467,0440,0414,0390,
                 0368,0347,0327,0308,0291,0274,0259,
                 0244,0230,0217,0205,0194,0183,0173,
                 0163,0154,0145,0137,0130,0123,0116,
                 0110,0104,0098,0093,0087,0083,0078,
                 0074,0070,0066,0063,0059,0056,0053,
                 0050,0047,0045,0042,0025,0014,0008,
                 0005,0003,0002,0001)/10000

    P <- ifelse(z<1.1 | z>8.5, pmax(1e-8,pmin(1,exp(.3885037-1.164879*z))),
                matrix(approx(c(seq(1.1, 5,by=.05),
                                seq(5.5,8.5,by=.5)),
                              tabvals, zz)$y,
                       ncol=ncol(d)))

    dimnames(P) <- dimnames(d)
    P
  }

  if(!missing(y))
    x <- cbind(x, y)

  x[is.na(x)] <- 1e30
  storage.mode(x) <-
#   if(.R.)
      "double"
#  else
#    "single"

  p <- as.integer(ncol(x))
  if(p<1)
    stop("must have >1 column")

  n <- as.integer(nrow(x))
  if(n<5)
    stop("must have >4 observations")

  h <-
#     if(.R.)
      .Fortran("hoeffd", x, n, p, hmatrix=double(p*p), aad=double(p*p),
               maxad=double(p*p), npair=integer(p*p),
               double(n), double(n),  double(n), double(n), double(n),
               PACKAGE="DescTools")
#   else
#     .Fortran("hoeffd", x, n, p, hmatrix=single(p*p), npair=integer(p*p),
#              single(n), single(n),  single(n), single(n), single(n),
#              single(n), integer(n))

  nam <- dimnames(x)[[2]]
  npair <- matrix(h$npair, ncol=p)
  aad <- maxad <- NULL
 # if(.R.) {
    aad <- matrix(h$aad, ncol=p)
    maxad <- matrix(h$maxad, ncol=p)
    dimnames(aad) <- dimnames(maxad) <- list(nam, nam)
#  }
  h <- matrix(h$hmatrix, ncol=p)
  h[h>1e29] <- NA
  dimnames(h) <- list(nam, nam)
  dimnames(npair) <- list(nam, nam)
  P <- phoeffd(h, npair)
  diag(P) <- NA
  structure(list(D=30*h, n=npair, P=P, aad=aad, maxad=maxad), class="HoeffD")
}


print.HoeffD <- function(x, ...)
{
  cat("D\n")
  print(round(x$D,2))
  if(length(aad <- x$aad)) {
    cat('\navg|F(x,y)-G(x)H(y)|\n')
    print(round(aad,4))
  }
  if(length(mad <- x$maxad)) {
    cat('\nmax|F(x,y)-G(x)H(y)|\n')
    print(round(mad,4))
  }
  n <- x$n
  if(all(n==n[1,1]))
    cat("\nn=",n[1,1],"\n")
  else {
    cat("\nn\n")
    print(x$n)
  }

  cat("\nP\n")
  P <- x$P
  P <- ifelse(P<.0001,0,P)
  p <- format(round(P,4))
  p[is.na(P)] <- ""
  print(p, quote=FALSE)
  invisible()
}


###

## stats: distributions  ---------------------------------

dBenf <- function(x, ndigits = 1, log = FALSE) {
  if (!IsNumeric(ndigits, length.arg = 1,
                  positive = TRUE, integer.valued = TRUE) ||
        ndigits > 2)
    stop("argument 'ndigits' must be 1 or 2")
  lowerlimit <- ifelse(ndigits == 1, 1, 10)
  upperlimit <- ifelse(ndigits == 1, 9, 99)

  if (!is.logical(log.arg <- log) || length(log) != 1)
    stop("bad input for argument 'log'")
  rm(log)


  ans <- x * NA
  indexTF <- is.finite(x) & (x >= lowerlimit)

  ans[indexTF] <- log10(1 + 1/x[indexTF])
  ans[!is.na(x) & !is.nan(x) &
        ((x < lowerlimit) |
           (x > upperlimit) |
           (x != round(x)))] <- 0.0
  if (log.arg) log(ans) else ans
}


rBenf <- function(n, ndigits = 1) {
  if (!IsNumeric(ndigits, length.arg = 1,
                  positive = TRUE, integer.valued = TRUE) ||
        ndigits > 2)
    stop("argument 'ndigits' must be 1 or 2")
  lowerlimit <- ifelse(ndigits == 1, 1, 10)
  upperlimit <- ifelse(ndigits == 1, 9, 99)
  use.n <- if ((length.n <- length(n)) > 1) length.n else
    if (!IsNumeric(n, integer.valued = TRUE,
                    length.arg = 1, positive = TRUE))
      stop("bad input for argument 'n'") else n
  myrunif <- runif(use.n)

  ans <- rep(lowerlimit, length = use.n)
  for (ii in (lowerlimit+1):upperlimit) {
    indexTF <- (pBenf(ii-1, ndigits = ndigits) < myrunif) &
      (myrunif <= pBenf(ii, ndigits = ndigits))
    ans[indexTF] <- ii
  }
  ans
}


pBenf <- function(q, ndigits = 1, log.p = FALSE) {
  if (!IsNumeric(ndigits, length.arg = 1,
                  positive = TRUE, integer.valued = TRUE) ||
        ndigits > 2)
    stop("argument 'ndigits' must be 1 or 2")
  lowerlimit <- ifelse(ndigits == 1, 1, 10)
  upperlimit <- ifelse(ndigits == 1, 9, 99)

  ans <- q * NA
  floorq <- floor(q)
  indexTF <- is.finite(q) & (floorq >= lowerlimit)
  ans[indexTF] <- log10(1 + floorq[indexTF]) -
    ifelse(ndigits == 1, 0, 1)
  ans[!is.na(q) & !is.nan(q) & (q >= upperlimit)] <- 1
  ans[!is.na(q) & !is.nan(q) & (q <  lowerlimit)] <- 0
  if (log.p) log(ans) else ans
}




qBenf <- function(p, ndigits = 1) {
  if (!IsNumeric(ndigits, length.arg = 1,
                  positive = TRUE, integer.valued = TRUE) ||
        ndigits > 2)
    stop("argument 'ndigits' must be 1 or 2")
  lowerlimit <- ifelse(ndigits == 1, 1, 10)
  upperlimit <- ifelse(ndigits == 1, 9, 99)
  bad <- !is.na(p) & !is.nan(p) & ((p < 0) | (p > 1))
  if (any(bad))
    stop("bad input for argument 'p'")

  ans <- rep(lowerlimit, length = length(p))
  for (ii in (lowerlimit+1):upperlimit) {
    indexTF <- is.finite(p) &
      (pBenf(ii-1, ndigits = ndigits) < p) &
      (p <= pBenf(ii, ndigits = ndigits))
    ans[indexTF] <- ii
  }

  ans[ is.na(p) |  is.nan(p)] <- NA
  ans[!is.na(p) & !is.nan(p) & (p == 0)] <- lowerlimit
  ans[!is.na(p) & !is.nan(p) & (p == 1)] <- upperlimit
  ans
}



dRevGumbel <- function (x, location = 0, scale = 1) {
  # from VGAM  -- if (is.null(x)) FALSE else ifelse(is.na(x), FALSE, x)
  if (!IsNumeric(scale, positive=TRUE))
      stop("\"scale\" must be positive")
  temp = exp((x - location)/scale)
  temp * exp(-temp)/scale
}

pRevGumbel <- function (q, location = 0, scale = 1) {

  if (!IsNumeric(scale, positive=TRUE))
    stop("\"scale\" must be positive")
  1-exp(-exp((q - location)/scale))
}

qRevGumbel <- function (p, location = 0, scale = 1)
{
  if (!IsNumeric(scale, positive=TRUE))
    stop("\"scale\" must be positive")
  location + scale * log(-log(p))
}

qRevGumbelExp <- function (p) exp(qRevGumbel(p))

rRevGumbel <- function (n, location = 0, scale = 1)
{
  if (!IsNumeric(scale, positive=TRUE, integer.valued=TRUE))
    stop("bad input for argument \"n\"")
  if (!IsNumeric(scale, positive=TRUE))
    stop("\"scale\" must be positive")
  location + scale * log(-log(runif(n)))
}


RndPairs <- function(n, r, rdist1 = rnorm(n=n, mean = 0, sd = 1), rdist2 = rnorm(n=n, mean = 0, sd = 1)){

  # create correlated random pairs
  data.frame(matrix(nrow=n, ncol=2, data=cbind(rdist1, rdist2)) %*%
                chol(matrix(nrow=2, ncol=2, data=c(1, r, r, 1))))
}


RndWord <- function(size, length, x = LETTERS, replace = TRUE, prob = NULL){
  sapply(1:size, function(i) paste(sample(x=x, size=length, replace=replace, prob=prob), collapse=""))
}



## stats: tests ====


#### ******************************
#### ******TODO*TODO***************
#### ******xxxxxxxxx***************
#### ******************************

# original:

# https://github.com/nicebread/WRS
# Rand Wilcox,
# http://www.psychology.mcmaster.ca/bennett/boot09/rt2.pdf

#
#  Compute a 1-alpha confidence interval for the difference between
#  the trimmed means corresponding to two independent groups.
#  The bootstrap percentile t method is used.
#
#  The default amount of trimming is tr=.2
#  side=T indicates two-sided method using absolute value of the
#  test statistics within the bootstrap; otherwise the equal-tailed method
#  is used.
#
#  This function uses trimse.
#

# side<-as.logical(side)
# p.value<-NA
# yuenbt<-vector(mode="numeric",length=2)
# if(SEED)set.seed(2) # set seed of random number generator so that
# #             results can be duplicated.
# x<-x[!is.na(x)]  # Remove missing values in x
# y<-y[!is.na(y)]  # Remove missing values in y
# xcen<-x-mean(x,tr)
# ycen<-y-mean(y,tr)
# if(!side){
#   if(pr)print("NOTE: p-value computed only when side=T")
# }
# test<-(mean(x,tr)-mean(y,tr))/sqrt(trimse(x,tr=tr)^2+trimse(y,tr=tr)^2)
# datax<-matrix(sample(xcen,size=length(x)*nboot,replace=TRUE),nrow=nboot)
# datay<-matrix(sample(ycen,size=length(y)*nboot,replace=TRUE),nrow=nboot)
# top<-apply(datax,1,mean,tr)-apply(datay,1,mean,tr)
# botx<-apply(datax,1,trimse,tr)
# boty<-apply(datay,1,trimse,tr)
# tval<-top/sqrt(botx^2+boty^2)
# if(plotit){
#   if(op == 1)
#     akerd(tval)
#   if(op == 2)
#     rdplot(tval)
# }
# if(side)tval<-abs(tval)
# tval<-sort(tval)
# icrit<-floor((1-alpha)*nboot+.5)
# ibot<-floor(alpha*nboot/2+.5)
# itop<-floor((1-alpha/2)*nboot+.5)
# se<-sqrt((trimse(x,tr))^2+(trimse(y,tr))^2)
# yuenbt[1]<-mean(x,tr)-mean(y,tr)-tval[itop]*se
# yuenbt[2]<-mean(x,tr)-mean(y,tr)-tval[ibot]*se
# if(side){
#   yuenbt[1]<-mean(x,tr)-mean(y,tr)-tval[icrit]*se
#   yuenbt[2]<-mean(x,tr)-mean(y,tr)+tval[icrit]*se
#   p.value<-(sum(abs(test)<=abs(tval)))/nboot
# }
# list(ci=yuenbt,test.stat=test,p.value=p.value,est.1=mean(x,tr),est.2=mean(y,tr),est.dif=mean(x,tr)-mean(y,tr),
#      n1=length(x),n2=length(y))



# getAnywhere(t.test.default)
#
# function (x, y = NULL, alternative = c("two.sided", "less", "greater"),
#           mu = 0, paired = FALSE, var.equal = FALSE, conf.level = 0.95,
#           trim = 0, nboot = 599, na.rm = FALSE
#           ...)

.YuenTTestB <- function(x, y, trim = 0, conf.level = 0.95, nboot=599
                       , alternative = c("two.sided", "less", "greater"), mu = 0, na.rm = FALSE){


  TrimSE <- function(x, trim = 0, na.rm = FALSE) {

    #  Estimate the standard error of the gamma trimmed mean
    #  The default amount of trimming is trim = 0.2

    if(na.rm) x <- na.omit(x)

    winvar <- var(Winsorize(x, probs = c(trim, 1-trim)))

    trimse <- sqrt(winvar) / ((1 - 2 * trim) * sqrt(length(x)))
    trimse
  }


  alternative <- match.arg(alternative)
  method <- "Yuen Two Sample bootstrap t-test"
  dname <- paste(deparse(substitute(x)), "and", deparse(substitute(y)))

  if(na.rm) x <- na.omit(x)
  if(na.rm) y <- na.omit(y)

  meanx <- mean(x, trim = trim)
  meany <- mean(y, trim = trim)

  tstat <- (meanx - meany ) / sqrt(TrimSE(x, trim = trim)^2 + TrimSE(y, trim = trim)^2)

  sampx <- matrix(sample(x - meanx, size=length(x) * nboot, replace=TRUE), nrow=nboot)
  sampy <- matrix(sample(y - meany, size=length(y) * nboot, replace=TRUE), nrow=nboot)

  top <- apply(sampx, 1, mean, trim) - apply(sampy, 1, mean, trim)
  botx <- apply(sampx, 1, TrimSE, trim)
  boty <- apply(sampy, 1, TrimSE, trim)
  tval <- top / sqrt(botx^2 + boty^2)


  alpha <- 1 - conf.level
  se <- sqrt((TrimSE(x, trim = trim))^2 + (TrimSE(y, trim = trim))^2)

  if(alternative == "two.sided") {
    tval <- abs(tval)
    icrit <- floor((1 - alpha) * nboot + .5)
    cint <- meanx - meany + c(-1, 1) * tval[icrit] * se
    pval <- (sum(abs(tstat) <= abs(tval))) / nboot

  } else {
    tval <- sort(tval)
    ibot <- floor(alpha/2 * nboot + .5)
    itop <- floor((1 - alpha/2) * nboot + .5)
    cint <- meanx - meany - tval[c(itop, ibot)] * se

  }

  names(tstat) <- "t"
  names(mu) <- "difference in means"
  estimate <- c(meanx, meany)
  names(estimate) <- c("mean of x", "mean of y")

  attr(cint, "conf.level") <- conf.level
  rval <- list(statistic = tstat, p.value = pval,
               conf.int = cint, estimate = estimate, null.value = mu,
               alternative = alternative, method = method, data.name = dname)
  class(rval) <- "htest"
  return(rval)

}



YuenTTest <- function (x, ...)
  UseMethod("YuenTTest")


YuenTTest.formula <- function (formula, data, subset, na.action, ...)  {

  if (missing(formula) || (length(formula) != 3L) || (length(attr(terms(formula[-2L]),
                                                                  "term.labels")) != 1L))
    stop("'formula' missing or incorrect")
  m <- match.call(expand.dots = FALSE)
  if (is.matrix(eval(m$data, parent.frame())))
    m$data <- as.data.frame(data)
  m[[1L]] <- quote(stats::model.frame)
  m$... <- NULL
  mf <- eval(m, parent.frame())
  DNAME <- paste(names(mf), collapse = " by ")
  names(mf) <- NULL
  response <- attr(attr(mf, "terms"), "response")
  g <- factor(mf[[-response]])
  if (nlevels(g) != 2L)
    stop("grouping factor must have exactly 2 levels")
  DATA <- setNames(split(mf[[response]], g), c("x", "y"))
  y <- DoCall("YuenTTest", c(DATA, list(...)))
  y$data.name <- DNAME
  if (length(y$estimate) == 2L)
    names(y$estimate) <- paste("trimmed mean in group", levels(g))
  y
}


YuenTTest.default <- function (x, y = NULL, alternative = c("two.sided", "less", "greater"),
          mu = 0, paired = FALSE, conf.level = 0.95, trim = 0.2, ...) {

  alternative <- match.arg(alternative)
  if (!missing(mu) && (length(mu) != 1 || is.na(mu)))
    stop("'mu' must be a single number")
  if (!missing(conf.level) && (length(conf.level) != 1 || !is.finite(conf.level) ||
                                 conf.level < 0 || conf.level > 1))
    stop("'conf.level' must be a single number between 0 and 1")
  if (!is.null(y)) {
    dname <- paste(deparse(substitute(x)), "and", deparse(substitute(y)))
    if (paired)
      xok <- yok <- complete.cases(x, y)
    else {
      yok <- !is.na(y)
      xok <- !is.na(x)
    }
    y <- y[yok]
  }
  else {
    dname <- deparse(substitute(x))
    if (paired)
      stop("'y' is missing for paired test")
    xok <- !is.na(x)
    yok <- NULL
  }
  x <- x[xok]

  nx <- length(x)
  mx <- mean(x, trim = trim)
  vx <- var(Winsorize(x, probs = c(trim, 1-trim)))

  if (is.null(y) | paired) {
    if (nx < 2)
      stop("not enough 'x' observations")

    df <- nx - 2 * floor(trim * nx) - 1

    if(paired){
      my <- mean(y, trim = trim)
      vy <- var(Winsorize(y, probs = c(trim, 1-trim)))
      covxy <- var(Winsorize(x, probs = c(trim, 1-trim)), Winsorize(y, probs = c(trim, 1-trim)))
      stderr <- sqrt( (nx-1) * (vx + vy - 2 * covxy) / ((df + 1) * df) )
    } else {
      stderr <- sqrt(vx) / ((1 - 2 * trim) * sqrt(nx))
    }

    if (stderr < 10 * .Machine$double.eps * abs(mx))
      stop("data are essentially constant")

    if(paired){
      method <- "Yuen Paired t-test"
      tstat <- (mx - my - mu) / stderr
      estimate <- setNames(mx - my, "difference of trimmed means")

    } else {
      method <- "Yuen One Sample t-test"
      tstat <- (mx - mu)/stderr
      estimate <- setNames(mx, "trimmed mean of x")
    }

  }
  else {
    ny <- length(y)
    if (nx < 2)
      stop("not enough 'x' observations")
    if (ny < 2)
      stop("not enough 'y' observations")
    my <- mean(y, trim = trim)
    vy <- var(Winsorize(y, probs = c(trim, 1-trim)))
    method <- "Yuen Two Sample t-test"
    estimate <- c(mx, my)
    names(estimate) <- c("trimmed mean of x", "trimmed mean of y")

    dfx <- length(x) - 2 * floor(trim * length(x)) - 1
    dfy <- length(y) - 2 * floor(trim * length(y)) - 1

    stderrx <- (length(x) - 1) * vx / ((dfx + 1) * dfx)
    stderry <- (length(y) - 1) * vy / ((dfy + 1) * dfy)

    df <- (stderrx + stderry)^2 / (stderrx^2 / dfx + stderry^2 / dfy)

    stderr <- sqrt(stderrx + stderry)

    if (stderr < 10 * .Machine$double.eps * max(abs(mx), abs(my)))
      stop("data are essentially constant")
    tstat <- (mx - my - mu) / stderr
  }
  if (alternative == "less") {
    pval <- pt(tstat, df)
    cint <- c(-Inf, tstat + qt(conf.level, df))
  }
  else if (alternative == "greater") {
    pval <- pt(tstat, df, lower.tail = FALSE)
    cint <- c(tstat - qt(conf.level, df), Inf)
  }
  else {
    pval <- 2 * pt(-abs(tstat), df)
    alpha <- 1 - conf.level
    cint <- qt(1 - alpha/2, df)
    cint <- tstat + c(-cint, cint)
  }
  cint <- mu + cint * stderr
  names(tstat) <- "t"
  names(df) <- "df"
  names(trim) <- "trim"
  names(mu) <- if (paired || !is.null(y))
    "difference in trimmed means"
  else "trimmed mean"
  attr(cint, "conf.level") <- conf.level
  rval <- list(statistic = tstat, parameter = c(df, trim), p.value = pval,
               conf.int = cint, estimate = estimate, null.value = mu,
               alternative = alternative, method = method, data.name = dname)
  class(rval) <- "htest"
  return(rval)
}






SignTest <- function (x, ...)  UseMethod("SignTest")

SignTest.formula <- function (formula, data, subset, na.action, ...) {

  # this is designed just like wilcox.test.formula

  if (missing(formula) || (length(formula) != 3L) || (length(attr(terms(formula[-2L]),
      "term.labels")) != 1L))
      stop("'formula' missing or incorrect")
  m <- match.call(expand.dots = FALSE)
  if (is.matrix(eval(m$data, parent.frame())))
      m$data <- as.data.frame(data)
  m[[1L]] <- as.name("model.frame")
  m$... <- NULL
  mf <- eval(m, parent.frame())
  DNAME <- paste(names(mf), collapse = " by ")
  names(mf) <- NULL
  response <- attr(attr(mf, "terms"), "response")
  g <- factor(mf[[-response]])
  if (nlevels(g) != 2L)
      stop("grouping factor must have exactly 2 levels")
  DATA <- split(mf[[response]], g)
  names(DATA) <- c("x", "y")
  y <- DoCall("SignTest", c(DATA, list(...)))
  y$data.name <- DNAME
  y

}

# test:
#  cbind( c(NA,sort(x)), 0:n, dbinom(0:n, size=n, prob=0.5),  pbinom(0:n, size=n, prob=0.5))

SignTest.default <- function(x, y = NULL, alternative = c("two.sided", "less", "greater"),
    mu = 0, conf.level = 0.95, ...) {

  MedianCI_Binom <- function( x, conf.level = 0.95,
      alternative = c("two.sided", "less", "greater"), na.rm = FALSE ){
    # http://www.stat.umn.edu/geyer/old03/5102/notes/rank.pdf
    # http://de.scribd.com/doc/75941305/Confidence-Interval-for-Median-Based-on-Sign-Test
    if(na.rm) x <- na.omit(x)
    n <- length(x)
    switch( match.arg(alternative)
      , "two.sided" = {
          k <- qbinom(p = (1 - conf.level) / 2, size=n, prob=0.5, lower.tail=TRUE)
          ci <- sort(x)[c(k, n - k + 1)]
          attr(ci, "conf.level") <- 1 - 2 * pbinom(k-1, size=n, prob=0.5)
        }
      , "greater" = {
          k <- qbinom(p = (1 - conf.level), size=n, prob=0.5, lower.tail=TRUE)
          ci <- c(sort(x)[k], Inf)
          attr(ci, "conf.level") <- 1 - pbinom(k-1, size=n, prob=0.5)
        }
      , "less" = {
          k <- qbinom(p = conf.level, size=n, prob=0.5, lower.tail=TRUE)
          ci <- c(-Inf, sort(x)[k])
          attr(ci, "conf.level") <- pbinom(k, size=n, prob=0.5)
        }
    )
    return(ci)
  }

  alternative <- match.arg(alternative)

  if (!missing(mu) && ((length(mu) > 1L) || !is.finite(mu)))
      stop("'mu' must be a single number")

  if (!((length(conf.level) == 1L) && is.finite(conf.level) &&
      (conf.level > 0) && (conf.level < 1)))
      stop("'conf.level' must be a single number between 0 and 1")

  if (!is.numeric(x))
      stop("'x' must be numeric")

  if (!is.null(y)) {
      if (!is.numeric(y))
          stop("'y' must be numeric")
      if (length(x) != length(y))
          stop("'x' and 'y' must have the same length")

      DNAME <- paste(deparse(substitute(x)), "and", deparse(substitute(y)))
      OK <- complete.cases(x, y)
      x <- x[OK]
      y <- y[OK]
      METHOD <- "Dependent-samples Sign-Test"
      x <- (x - y)

  } else {
      DNAME <- deparse(substitute(x))
      x <- x[is.finite(x)]
      METHOD <- "One-sample Sign-Test"
  }

  d <- (x - mu)

  # Naive version:
  n.valid <- sum(d > 0) + sum(d < 0)
  if(n.valid > 0) {
    RVAL <- binom.test(x=sum(d > 0), n=n.valid, p=0.5, alternative = alternative, conf.level = conf.level )
  } else {
    RVAL <- binom.test(x=1, n=1)
  }

  RVAL$method <- METHOD
  RVAL$data.name <- DNAME
  names(mu) <- if (!is.null(y)) "median difference" else "median"

  names(RVAL$statistic) <- "S"
  RVAL$estimate <- median(d + mu, na.rm=TRUE)
  names(RVAL$parameter) <- "number of differences"
  mci <- MedianCI_Binom(d + mu, conf.level=conf.level, alternative=alternative, na.rm=TRUE)
  RVAL$conf.int <- mci
  attr(RVAL$conf.int, "conf.level") = round(attr(mci,"conf.level"), 3)

  names(RVAL$estimate) <- "median of the differences"
  RVAL$null.value <- mu
  class(RVAL) <- "htest"
  return(RVAL)

}



ZTest <- function (x, ...)
  UseMethod("ZTest")


ZTest.formula <- function (formula, data, subset, na.action, ...)  {

  if (missing(formula) || (length(formula) != 3L) || (length(attr(terms(formula[-2L]),
                                                                  "term.labels")) != 1L))
    stop("'formula' missing or incorrect")
  m <- match.call(expand.dots = FALSE)
  if (is.matrix(eval(m$data, parent.frame())))
    m$data <- as.data.frame(data)
  m[[1L]] <- quote(stats::model.frame)
  m$... <- NULL
  mf <- eval(m, parent.frame())
  DNAME <- paste(names(mf), collapse = " by ")
  names(mf) <- NULL
  response <- attr(attr(mf, "terms"), "response")
  g <- factor(mf[[-response]])
  if (nlevels(g) != 2L)
    stop("grouping factor must have exactly 2 levels")
  DATA <- setNames(split(mf[[response]], g), c("x", "y"))
  y <- DoCall("ZTest", c(DATA, list(...)))
  y$data.name <- DNAME
  if (length(y$estimate) == 2L)
    names(y$estimate) <- paste("mean in group", levels(g))
  y
}


ZTest.default <- function (x, y = NULL, alternative = c("two.sided", "less", "greater"),
                           paired = FALSE, mu = 0, sd_pop, conf.level = 0.95,  ...)  {

  alternative <- match.arg(alternative)
  if (!missing(mu) && (length(mu) != 1 || is.na(mu)))
    stop("'mu' must be a single number")
  if (!missing(conf.level) && (length(conf.level) != 1 || !is.finite(conf.level) ||
                                 conf.level < 0 || conf.level > 1))
    stop("'conf.level' must be a single number between 0 and 1")
  if (!is.null(y)) {
    dname <- paste(deparse(substitute(x)), "and", deparse(substitute(y)))

    if (paired)
      xok <- yok <- complete.cases(x, y)
    else {
      yok <- !is.na(y)
      xok <- !is.na(x)
    }

    y <- y[yok]
  }
  else {
    dname <- deparse(substitute(x))
    if (paired)
      stop("'y' is missing for paired test")
    xok <- !is.na(x)
    yok <- NULL
  }
  x <- x[xok]

  if (paired) {
    x <- x - y
    y <- NULL
  }

  nx <- length(x)
  mx <- mean(x)
  # vx <- sd_pop^2

  if (is.null(y)) {
    if (nx < 2)
      stop("not enough 'x' observations")
    stderr <- sqrt(sd_pop^2/nx)
    if (stderr < 10 * .Machine$double.eps * abs(mx))
      stop("data are essentially constant")
    zstat <- (mx - mu)/stderr

    method <- method <- if (paired)
      "Paired z-test" else "One Sample z-test"
    estimate <- setNames(mx, if (paired)
      "mean of the differences"
      else "mean of x")
  }
  else {
    ny <- length(y)
    if (nx < 1)
      stop("not enough 'x' observations")
    if (ny < 1)
      stop("not enough 'y' observations")
    if (nx + ny < 3)
      stop("not enough observations")
    my <- mean(y)

    method <- paste("Two Sample z-test")
    estimate <- c(mx, my)
    names(estimate) <- c("mean of x", "mean of y")

    stderr <- sqrt(sd_pop^2 * (1/nx + 1/ny))

    if (stderr < 10 * .Machine$double.eps * max(abs(mx),
                                                abs(my)))
      stop("data are essentially constant")
    zstat <- (mx - my - mu)/stderr
  }
  if (alternative == "less") {
    pval <- pnorm(zstat)
    cint <- c(-Inf, zstat + qnorm(conf.level))
  }
  else if (alternative == "greater") {
    pval <- pnorm(zstat, lower.tail = FALSE)
    cint <- c(zstat - qnorm(conf.level), Inf)
  }
  else {
    pval <- 2 * pnorm(-abs(zstat))
    alpha <- 1 - conf.level
    cint <- qnorm(1 - alpha/2)
    cint <- zstat + c(-cint, cint)
  }
  cint <- mu + cint * stderr
  names(zstat) <- "z"
  names(mu) <- if (paired || !is.null(y))
    "difference in means"
  else "mean"
  names(sd_pop) <- "Std. Dev. Population"
  attr(cint, "conf.level") <- conf.level
  rval <- list(statistic = zstat, p.value = pval,
               parameter = sd_pop,
               conf.int = cint, estimate = estimate, null.value = mu,
               alternative = alternative, method = method, data.name = dname)
  class(rval) <- "htest"
  return(rval)
}



# moved from Rcmdr 13 July 2004

# levene.test.default function slightly modified and generalized from Brian Ripley via R-help
# the original generic version was contributed by Derek Ogle
# last modified 28 January 2010 by J. Fox

LeveneTest <- function (y, ...) {
	UseMethod("LeveneTest")
}

LeveneTest.default <- function (y, group, center=median, ...) { # original levene.test
	if (!is.numeric(y))
		stop(deparse(substitute(y)), " is not a numeric variable")
	if (!is.factor(group)) {
		warning(deparse(substitute(group)), " coerced to factor.")
		group <- as.factor(group)
	}
	valid <- complete.cases(y, group)
	meds <- tapply(y[valid], group[valid], center, ...)
	resp <- abs(y - meds[group])
	table <- anova(lm(resp ~ group))[, c(1, 4, 5)]
	rownames(table)[2] <- " "
	dots <- deparse(substitute(...))
	attr(table, "heading") <- paste("Levene's Test for Homogeneity of Variance (center = ",
			deparse(substitute(center)), if(!(dots == "NULL")) paste(":", dots),  ")", sep="")
	table
}

LeveneTest.formula <- function(y, data, ...) {
	form <- y
	mf <- if (missing(data)) model.frame(form) else model.frame(form, data)
	if (any(sapply(2:dim(mf)[2], function(j) is.numeric(mf[[j]]))))
		stop("Levene's test is not appropriate with quantitative explanatory variables.")
	y <- mf[,1]
	if(dim(mf)[2]==2) group <- mf[,2]
	else {
		if (length(grep("\\+ | \\| | \\^ | \\:",form))>0) stop("Model must be completely crossed formula only.")
		group <- interaction(mf[,2:dim(mf)[2]])
	}
	LeveneTest.default(y = y, group=group, ...)
}

LeveneTest.lm <- function(y, ...) {
	LeveneTest.formula(formula(y), data=model.frame(y), ...)
}




RunsTest <- function (x, ...)  UseMethod("RunsTest")

RunsTest.formula <- function (formula, data, subset, na.action, ...) {

  # this is a taken analogue to wilcox.test.formula

  if (missing(formula) || (length(formula) != 3L) || (length(attr(terms(formula[-2L]),
                                                                  "term.labels")) != 1L))
    stop("'formula' missing or incorrect")
  m <- match.call(expand.dots = FALSE)
  if (is.matrix(eval(m$data, parent.frame())))
    m$data <- as.data.frame(data)
  m[[1L]] <- as.name("model.frame")
  m$... <- NULL
  mf <- eval(m, parent.frame())
  DNAME <- paste(names(mf), collapse = " by ")
  names(mf) <- NULL
  response <- attr(attr(mf, "terms"), "response")
  g <- factor(mf[[-response]])
  if (nlevels(g) != 2L)
    stop("grouping factor must have exactly 2 levels")
  DATA <- split(mf[[response]], g)
  names(DATA) <- c("x", "y")
  y <- DoCall("RunsTest", c(DATA, list(...)))
  y$data.name <- DNAME
  y

}


RunsTest.default <- function(x, y=NULL, alternative=c("two.sided", "less", "greater"), exact=NULL, na.rm = FALSE, ...) {

  # exact values:
  # http://www.reiter1.com/Glossar/Wald_Wolfowitz.htm

  # example:   x <- sample(c(0,1), size=20, r=TRUE)

  pruns <- function(r, n1, n2, alternative=c("two.sided", "less", "greater")) {

    # source: randomizeBE
    # author: D. Labes <detlewlabes at gmx.de>

    # function for calculating the denominator of the runs distribution
    .druns_nom <- function(r, n1, n2){
      pp <- vector(mode="numeric",length=length(r))
      for (i in seq_along(r)){
        if (2*r[i]%/%2==r[i]){
          # even 2*k
          k <- r[i]/2
          pp[i] <- 2*choose(n1-1, k-1)*choose(n2-1, k-1)
        } else {
          # odd 2*k+1
          k <- (r[i]-1)/2
          pp[i] <- choose(n1-1,k-1) * choose(n2-1,k) +
            choose(n1-1,k)   * choose(n2-1,k-1)
        }
      }
      pp
    }

    alternative <- match.arg(alternative)

    n <- n1+n2

    if(r<=1) stop("Number of runs must be > 1")
    if(r>n) stop("Number of runs must be < (n1+n2")
    if(n1<1 | n2<1) return(0) #??? is not random!

    E <- 1 + 2*n1*n2/n

    denom <- choose(n,n1)
    # how long should we make the r vector?
    # in very unsymmetric cases only a few elements of
    # pp = density have values > 0 if rmax=n1+n2
    # number of runs possible: 2*m if n=m, 2*m+1 if m<n
    rmax <- ifelse(n1==n2, 2*n1, 2*min(n1,n2)+1)
    rv <- 2:rmax
    pp <- .druns_nom(rv, n1, n2)

    # pL is p(R<=r) -> left/lower tail
    pL <- sum(pp[rv<=r])/denom
    #pU is p(R>=r) -> right/upper tail
    pU <- 1 - sum(pp[rv<=(r-1)])/denom

    # Equn. 4.7 of the SPSS documentation
    p2 <- sum(pp[abs(rv-E)>=abs(r-E)])/denom

    # Next is the rule from:
    # Gibbons "Nonparametric Methods for Quantitative Analysis"
    # 0.5 is to avoid p>1 if both pL and pU are >0.5
    p2min <- 2*min(c(pL, pU, 0.5))

    # we are using the SPSS approach wich takes into account the
    # unsymmetric form of the distribution if n1 << n2

    return(
      switch( alternative
              , "less" = pL
              , "greater" = pU
              , "two.sided" = p2
      )
    )

  }


  if(!is.null(y)) {
    dname <- paste(deparse(substitute(x)), "and", deparse(substitute(y)))
    # perform Wald-Wolfowitz-Test with 2 variables
    xy <- Sort(cbind(c(x,y), c(rep(0, length(x)), rep(1, length(y)))))[,2]
    res <- RunsTest(x=xy, alternative=alternative, exact=exact, na.rm=na.rm)
    res$data.name <- dname
    res$method <- "Wald-Wolfowitz Runs Test "
    return(res)
  }

  alternative <- match.arg(alternative)
  dname <- deparse(substitute(x))

  # Strip NAs
  if (na.rm) x <- na.omit(x)

  # let's have a 0,1 vector if x is a numeric vector with more than 2 values
  if(is.numeric(x) & (length(unique(x))>2)) {
    est <- median(x, na.rm=TRUE)
    names(est) <- "median(x)"
    x <- ((x > est)*1)

  } else {
    est <- NULL
  }

  x <- factor(x)
  if( nlevels(x) %nin% c(1,2) ) stop("Can only process dichotomous variables")
  x <- as.numeric(x) - 1

  # x <- sample(c(0,1), 100000000, replace=TRUE)
  # ### user  system elapsed
  #   9.39    6.76   16.30    system.time(rle(x))
  #   4.49    3.45    8.00    system.time(sum(diff(x) != 0) + 1)
  # so don't use rle...

  runs <- sum(diff(x) != 0) + 1
  m <- sum(x==0)
  n <- sum(x==1)

  if(is.null(exact)) { exact <- ((m +n) <= 30) }

  E <- 1 + 2*n*m / (n + m)
  s2 <- (2*n*m * (2*n*m - n - m)) / ((n + m)^2 * (n + m - 1))

  # this is the SPSS-Definition
  # http://publib.boulder.ibm.com/infocenter/spssstat/v20r0m0/index.jsp?topic=%2Fcom.ibm.spss.statistics.help%2Fidh_idd_npar_onesample_settings_tests_runs.htm
  if( n+m >= 50) {
    statistic <- (runs - E) / sqrt(s2)
  } else {
    switch( as.character(cut(runs - E, breaks=c(-Inf, -0.5, 0.5, Inf), labels=c("a", "b", "c")))
      , "a" = statistic <- (runs - E + 0.5) / sqrt(s2)
      , "b" = statistic <- 0
      , "c" = statistic <- (runs - E - 0.5) / sqrt(s2)
    )
  }

  switch( alternative
    , "less" = {
        p.value <- ifelse(exact, pruns(runs, m, n, alternative="less"), pnorm(statistic) )
        alternative <- "true number of runs is less than expected"
      }
    , "greater" = {
        p.value = ifelse(exact, pruns(runs, m, n, alternative="greater"), 1 - pnorm(statistic) )
        alternative <- "true number of runs is greater than expected"
      }
    , "two.sided" = {
        p.value = ifelse(exact, pruns(runs, m, n, alternative="two.sided"),
                         2 * min(pnorm(statistic), 1 - pnorm(statistic)) )
        alternative <- "true number of runs is not equal the expected number"
      }
  )

  method = "Runs Test for Randomness"
  names(statistic) <- "z"  # Standardized Runs Statistic

  # do not report statistic when exact p-value is calculated
  if(exact) statistic <- NULL

  structure(list(
    statistic = statistic,
    p.value = p.value,
    method = method,
    alternative = alternative,
    data.name = dname,
    estimate = est,
    parameter = c(runs=runs, m=m, n=n)),
  class = "htest")

}



DurbinWatsonTest <- function(formula, order.by = NULL, alternative = c("greater", "two.sided", "less"),
                             iterations = 15, exact = NULL, tol = 1e-10, data = list()) {

  dname <- paste(deparse(substitute(formula)))
  alternative <- match.arg(alternative)

  if(!inherits(formula, "formula")) {
    if(!is.null(w <- weights(formula))) {
      if(!isTRUE(all.equal(as.vector(w), rep(1L, length(w)))))
        stop("weighted regressions are not supported")
    }
    X <- if(is.matrix(formula$x))
      formula$x
    else model.matrix(terms(formula), model.frame(formula))
    y <- if(is.vector(formula$y))
      formula$y
    else model.response(model.frame(formula))
  } else {
    mf <- model.frame(formula, data = data)
    y <- model.response(mf)
    X <- model.matrix(formula, data = data)
  }

  if(!is.null(order.by))
  {
    if(inherits(order.by, "formula")) {
      z <- model.matrix(order.by, data = data)
      z <- as.vector(z[,ncol(z)])
    } else {
      z <- order.by
    }
    X <- as.matrix(X[order(z),])
    y <- y[order(z)]
  }

  n <- nrow(X)
  if(is.null(exact)) exact <- (n < 100)
  k <- ncol(X)

  res <- lm.fit(X,y)$residuals
  dw <- sum(diff(res)^2)/sum(res^2)
  Q1 <- chol2inv(qr.R(qr(X)))
  if(n < 3) {
    warning("not enough observations for computing a p value, set to 1")
    pval <- 1
  } else {
    if(exact)
    {
      A <- diag(c(1,rep(2, n-2), 1))
      A[abs(row(A)-col(A))==1] <- -1
      MA <- diag(rep(1,n)) - X %*% Q1 %*% t(X)
      MA <- MA %*% A
      ev <- eigen(MA)$values[1:(n-k)]
      if(any(Im(ev)>tol)) warning("imaginary parts of eigenvalues discarded")
      ev <- Re(ev)
      ev <- ev[ev>tol]

      pdw <- function(dw) .Fortran("pan", as.double(c(dw,ev)), as.integer(length(ev)),
                                   as.double(0), as.integer(iterations), x=double(1),
                                   PACKAGE = "DescTools")$x
      pval <- switch(alternative,
                     "two.sided" = (2*min(pdw(dw), 1-pdw(dw))),
                     "less" = (1 - pdw(dw)),
                     "greater" = pdw(dw))

      if(is.na(pval) || ((pval > 1) | (pval < 0)))
      {
        warning("exact p value cannot be computed (not in [0,1]), approximate p value will be used")
        exact <- FALSE
      }
    }
    if(!exact)
    {
      if(n < max(5, k)) {
        warning("not enough observations for computing an approximate p value, set to 1")
        pval <- 1
      } else {
        AX <- matrix(as.vector(filter(X, c(-1, 2, -1))), ncol = k)
        AX[1,] <- X[1,] - X[2,]
        AX[n,] <- X[n,] - X[(n-1),]
        XAXQ <- t(X) %*% AX %*% Q1
        P <- 2*(n-1) - sum(diag(XAXQ))
        Q <- 2*(3*n - 4) - 2* sum(diag(crossprod(AX) %*% Q1)) + sum(diag(XAXQ %*% XAXQ))
        dmean <- P/(n-k)
        dvar <- 2/((n-k)*(n-k+2)) * (Q - P*dmean)
        pval <- switch(alternative,
                       "two.sided" = (2*pnorm(abs(dw-dmean), sd=sqrt(dvar), lower.tail = FALSE)),
                       "less" = pnorm(dw, mean = dmean, sd = sqrt(dvar), lower.tail = FALSE),
                       "greater" = pnorm(dw, mean = dmean, sd = sqrt(dvar)))
      }
    }
  }

  alternative <- switch(alternative,
                        "two.sided" = "true autocorrelation is not 0",
                        "less" = "true autocorrelation is less than 0",
                        "greater" = "true autocorrelation is greater than 0")

  names(dw) <- "DW"
  RVAL <- list(statistic = dw, method = "Durbin-Watson test",
               alternative = alternative, p.value= pval, data.name=dname)
  class(RVAL) <- "htest"
  return(RVAL)
}



##
##  Bartels' Rank Test
##
BartelsRankTest <- function(x, alternative="two.sided", pvalue="normal"){
  # Performs Bartels Ratio Test for Randomness.
  #
  # Args:
  #   x: a numeric vector containing the data.
  #   alternative hypothesis, must be one of "two.sided" (default), "left.sided" or "right.sided"
  #   pv.method: asymptotic aproximation method used to compute the p-value.
  #
  # Returns:
  #   statistic: the value of the RVN statistic test and the theoretical mean value and variance of the RVN statistic test.
  #   n: the sample size, after the remotion of consecutive duplicate values.
  #   p.value: the asymptotic p-value.
  #   method: a character string indicating the test performed.
  #   data.name: a character string giving the name of the data.
  #   alternative: a character string describing the alternative.
  #
  dname <- deparse(substitute(x))
  # Remove NAs
  x <- na.omit(x)
  stopifnot(is.numeric(x))
  n <- length(x)
  if (alternative == "t"){alternative <- "two.sided"}
  if (alternative == "l"){alternative <- "left.sided"}
  if (alternative == "r"){alternative <- "right.sided"}
  if (alternative != "two.sided" & alternative != "left.sided" & alternative != "right.sided")
  {stop("must give a valid alternative")}
  if (n < 10){stop("sample size must be greater than 9")}
  # unique
  rk <- rank(x)
  d <- diff(rk)
  #d.rank <- n*(n^2-1)/12
  d.rank <- sum(rk^2)-n*(mean(rk)^2)
  RVN <- sum(d^2)/d.rank
  mu <- 2
  vr <- (4*(n-2)*(5*n^2-2*n-9))/(5*n*(n+1)*(n-1)^2)
  #
  # Computes the p-value
  if (pvalue == "auto"){pvalue<-ifelse(n<=100,"beta","normal")}
  if (pvalue == "beta"){
    btp <- (5*n*(n+1)*(n-1)^2)/(2*(n-2)*(5*n^2-2*n-9))-1/2
    pv0 <- pbeta(RVN/4,shape1=btp,shape2=btp)
  }
  if (pvalue=="normal"){
    pv0 <- pnorm((RVN - mu) / sqrt(vr))
  }

  if (alternative=="two.sided"){
    pv <- 2*min(pv0,1-pv0)
    alternative<-"nonrandomness"
  }
  if (alternative=="left.sided"){
    pv <- pv0
    alternative<-"trend"
  }
  if (alternative=="right.sided"){
    pv <- 1-pv0
    alternative<-"systematic oscillation"
  }

  test <- (RVN - mu) / sqrt(vr)
  rval <- list(statistic = c(statistic=test), nm=sum(d^2), rvn=RVN, mu=mu, var=vr, p.value = pv,
               method = "Bartels Ratio Test", data.name = dname, parameter=c(n=n), n=n, alternative=alternative)
  class(rval) <- "htest"
  return(rval)

}



MosesTest <- function (x, ...)  UseMethod("MosesTest")

# Extremreaktionen nach Moses: Nullhypothese: Die Spannweite der Werte ist
# in beiden Gruppen gleich gross. Die Werte beider Gruppen werden in eine gemeinsame
# Reihenfolge gebracht. Anschliessend werden ihnen Rangwerte zugewiesen.
# Eine der Gruppen (die Gruppe des Wertes, der in dem Dialogfeld
#                   Gruppen definieren als erstes angegeben ist) wird als Kontrollgruppe verwendet.
# Fuer diese Gruppe wird die Spannweite der Raenge als Differenz zwischen
# dem groessten und kleinsten Rangwert berechnet. Anhand dieser Spannweite errechnet
# sich die einseitige Signifikanz. Zusaetzlich wird der Test ein zweites
# Mal durchgefuehrt, wobei die Ausreisser der Gesamtstichprobe ausgeschlossen
# werden (insgesamt 5% der Faelle). Dabei werden sowohl die hoechsten als auch
# die niedrigsten Raenge entfernt. Das Testergebnis teilt die Anzahl der Faelle beider
# Gruppen, die Spannweiten und die entsprechenden einseitigen Signifikanzen
# fuer beide Tests (mit und ohne Ausreisser) mit. Fuer ein Beispiel siehe oben
# Abschnitt Moses-Test, S. 760.


MosesTest.formula <- function (formula, data, subset, na.action, ...) {

  # this is a taken analogue to wilcox.test.formula

  if (missing(formula) || (length(formula) != 3L) || (length(attr(terms(formula[-2L]),
      "term.labels")) != 1L))
      stop("'formula' missing or incorrect")
  m <- match.call(expand.dots = FALSE)
  if (is.matrix(eval(m$data, parent.frame())))
      m$data <- as.data.frame(data)
  m[[1L]] <- as.name("model.frame")
  m$... <- NULL
  mf <- eval(m, parent.frame())
  DNAME <- paste(names(mf), collapse = " by ")
  names(mf) <- NULL
  response <- attr(attr(mf, "terms"), "response")
  g <- factor(mf[[-response]])
  if (nlevels(g) != 2L)
      stop("grouping factor must have exactly 2 levels")
  DATA <- split(mf[[response]], g)
  names(DATA) <- c("x", "y")
  y <- DoCall("MosesTest", c(DATA, list(...)))
  y$data.name <- DNAME
  y

}



MosesTest.default <- function(x, y, extreme = NULL, ...){

  # example
  # x <- c(0.80, 0.83, 1.89, 1.04, 1.45, 1.38, 1.91, 1.64, 0.73, 1.46)
  # y <- c(1.15, 0.88, 0.90, 0.74, 1.21)
  # MosesTest(y, x)

  if(is.null(extreme)) extreme <- pmax(floor(0.05 * length(x)), 1)
  h <- extreme
  if(2*h > length(x)-2) h <- floor((length(x)-2)/2)

  # no alternative for the moses.test
  DNAME <- paste(deparse(substitute(x)), "and", deparse(substitute(y)))

  nk <- length(x)
  ne <- length(y)
  # decreasing ranks following SPSS-calculation
  R1 <- rank(-c(x, y))[1:nk]
  R1 <- sort(R1)[(h+1):(length(R1)-h)]

  S <- ceiling(max(R1) - min(R1) + 1)

  tmp <- 0
  for( i in 0 : (S - nk + 2*h)) {
    tmp <- tmp + choose(i + nk - 2*h - 2, i) * choose(ne + 2*h + 1 - i, ne - i)
  }

  PVAL <- (tmp / choose(nk + ne, nk))

  structure(list(statistic = c(S = S),
                 p.value = PVAL,
                 method = "Moses Test of Extreme Reactions",
                 alternative = "extreme values are more likely in x than in y",
                 data.name = DNAME),
            class = "htest")

}



SiegelTukeyTest <- function (x, ...)  UseMethod("SiegelTukeyTest")

SiegelTukeyTest.formula <- function (formula, data, subset, na.action, ...)
{
  # this is a taken analogue to wilcox.test.formula

  if (missing(formula) || (length(formula) != 3L) || (length(attr(terms(formula[-2L]),
      "term.labels")) != 1L))
      stop("'formula' missing or incorrect")
  m <- match.call(expand.dots = FALSE)
  if (is.matrix(eval(m$data, parent.frame())))
      m$data <- as.data.frame(data)
  m[[1L]] <- as.name("model.frame")
  m$... <- NULL
  mf <- eval(m, parent.frame())
  DNAME <- paste(names(mf), collapse = " by ")
  names(mf) <- NULL
  response <- attr(attr(mf, "terms"), "response")
  g <- factor(mf[[-response]])
  if (nlevels(g) != 2L)
      stop("grouping factor must have exactly 2 levels")
  DATA <- split(mf[[response]], g)
  names(DATA) <- c("x", "y")
  y <- DoCall("SiegelTukeyTest", c(DATA, list(...)))
  y$data.name <- DNAME
  y

}



SiegelTukeyRank <- function(x, g, drop.median = TRUE) {

    # they do not drop the median in:
    # http://en.wikipedia.org/wiki/Siegel%E2%80%93Tukey_test
    # A <- c(33,62,84,85,88,93,97); B <- c(4,16,48,51,66,98)
    # this is wrong there, as the author did not leave the median out

    ord.x <- order(x, g)
    sort.x <- x[ord.x]
    sort.id <- g[ord.x]

    n <- length(x)
    if(drop.median){
      if(n %% 2 > 0) {
        # gonna have to drop the (first) median value
        # as we sorted by the groupsize, this will be the one out of the bigger group (if existing)
        fm <- which( sort.x == median(sort.x))[1]
        sort.x <- sort.x[-fm]
        sort.id <- sort.id[-fm]
        n <- n-1
      }
    }

    base1 <- c(1, 4)
    iterator1 <- matrix(seq(from = 1, to = n, by = 4)) - 1
    rank1 <- apply(iterator1, 1, function(x) x + base1)

    iterator2 <- matrix(seq(from = 2, to = n, by = 4))
    base2 <- c(0, 1)
    rank2 <- apply(iterator2, 1, function(x) x + base2)

    if (length(rank1) == length(rank2)) {
        rank <- c(rank1[1:floor(n/2)], rev(rank2[1:ceiling(n/2)]))
    } else {
        rank <- c(rank1[1:ceiling(n/2)], rev(rank2[1:floor(n/2)]))
    }

    unique.ranks <- tapply(rank, sort.x, mean)
    unique.x <- as.numeric(as.character(names(unique.ranks)))

    ST.matrix <- merge(
       data.frame(sort.x, sort.id),          # this are the original values in x-order
       data.frame(unique.x, unique.ranks),   # this is the rank.matrix
       by.x = "sort.x", by.y = "unique.x")

    return(ST.matrix)
}


SiegelTukeyTest.default <- function(x, y, adjust.median = FALSE,
    alternative = c("two.sided","less","greater"), mu = 0,
    exact = NULL, correct = TRUE, conf.int = FALSE, conf.level = 0.95, ...) {
    ###### published on:
    #   http://www.r-statistics.com/2010/02/siegel-tukey-a-non-parametric-test-for-equality-in-variability-r-code/
    #   Main author of the function:  Daniel Malter

    # Doku: http://www.crcnetbase.com/doi/abs/10.1201/9781420036268.ch14


  if (!missing(mu) && ((length(mu) > 1L) || !is.finite(mu)))
      stop("'mu' must be a single number")

  if (conf.int) {
      if (!((length(conf.level) == 1L) && is.finite(conf.level) &&
          (conf.level > 0) && (conf.level < 1)))
          stop("'conf.level' must be a single number between 0 and 1")
  }

  if (!is.numeric(x))
      stop("'x' must be numeric")

  if (!is.null(y)) {
      if (!is.numeric(y))
          stop("'y' must be numeric")
      DNAME <- paste(deparse(substitute(x)), "and", deparse(substitute(y)))
      x <- x[is.finite(x)]
      y <- y[is.finite(y)]
  }
  else {
      DNAME <- deparse(substitute(x))
      x <- x[is.finite(x)]
  }

  # adjusting median
  if (adjust.median) {
      x <- x - median(x)
      y <- y - median(y)
  }

  # the larger group comes first
  if( length(x) > length(y) ){
    xx <- c(x, y)
    id <- c(rep(0, length(x)), rep(1, length(y)))
  } else {
    xx <- c(y,x)
    id <- c(rep(0, length(y)), rep(1, length(x)))
  }

  strank <- SiegelTukeyRank(xx, g = id)
  ranks0 <- strank$unique.ranks[strank$sort.id == 0]
  ranks1 <- strank$unique.ranks[strank$sort.id == 1]

  RVAL <- wilcox.test(ranks0, ranks1, alternative = alternative,
      mu = mu, paired = FALSE, exact = exact, correct = correct,
      conf.int = conf.int, conf.level = conf.level)

  RVAL$statistic <- sum(ranks1)
  names(RVAL$statistic)  <- "ST"
  RVAL$data.name <- DNAME
  RVAL <- c(RVAL, list(stranks = strank, MeanRanks = c(mean(ranks0), mean(ranks1))))
  RVAL$method <- "Siegel-Tukey-test for equal variability"
  RVAL$null.value <- 1
  names(RVAL$null.value) <- "ratio of scales"
  class(RVAL) <- "htest"
  return(RVAL)

  if(suppressWarnings(wilcox.test(x,y)$p.value) < 0.05) warning("SiegelTukeyTest: wilcox.test(x, y) is significant! Consider setting adjust.median = TRUE." )

}




JonckheereTerpstraTest <- function (x, ...)  UseMethod("JonckheereTerpstraTest")

JonckheereTerpstraTest.formula <- function (formula, data, subset, na.action, ...) {

    if (missing(formula) || (length(formula) != 3L))
        stop("'formula' missing or incorrect")
    m <- match.call(expand.dots = FALSE)
    if (is.matrix(eval(m$data, parent.frame())))
        m$data <- as.data.frame(data)
    m[[1L]] <- as.name("model.frame")
    mf <- eval(m, parent.frame())
    DNAME <- paste(names(mf), collapse = " by ")
    names(mf) <- NULL
    y <- DoCall("JonckheereTerpstraTest", as.list(mf))
    y$data.name <- DNAME
    y
}

JonckheereTerpstraTest.default <- function (x, g, alternative = c("two.sided", "increasing", "decreasing"), nperm=NULL, ...) {

    if (is.list(x)) {
        if (length(x) < 2L)
            stop("'x' must be a list with at least 2 elements")
        DNAME <- deparse(substitute(x))
        x <- lapply(x, function(u) u <- u[complete.cases(u)])
        k <- length(x)
        l <- sapply(x, "length")
        if (any(l == 0))
            stop("all groups must contain data")
        g <- factor(rep(1:k, l))
        x <- unlist(x)
    }
    else {
        if (length(x) != length(g))
            stop("'x' and 'g' must have the same length")
        DNAME <- paste(deparse(substitute(x)), "and", deparse(substitute(g)))
        OK <- complete.cases(x, g)
        x <- x[OK]
        g <- g[OK]
        if (!all(is.finite(g)))
            stop("all group levels must be finite")
        g <- factor(g)
        k <- nlevels(g)
        if (k < 2)
            stop("all observations are in the same group")
    }
    n <- length(x)
    if (n < 2)
        stop("not enough observations")

    # start calculating

  jtpdf <- function(gsize) {
    ng <- length(gsize)
    cgsize <- rev(cumsum(rev(gsize)))
    mxsum <- sum(gsize[-ng]*cgsize[-1]) + 1
    zz <- .Fortran("jtpdf",
                   as.integer(mxsum),
                   pdf=double(mxsum),
                   as.integer(ng),
                   as.integer(cgsize),
                   double(mxsum),
                   double(mxsum))
    zz$pdf
  }

  jtperm.p <- function(x, ng, gsize, cgsize, alternative, nperm) {
    # this function computes the pdf using the convolution by Mark van de Wiel

    n <- length(x)
    pjtrsum <- rep(0, nperm)
    for (np in 1:nperm){
      jtrsum <- 0
      for(i in 1:(ng-1)) {
        na <- gsize[i]
        nb <- n-cgsize[i+1]
  # this jtrsum will be small if data are increasing and large if decreasing
        jtrsum <- jtrsum + sum(rank(x[(cgsize[i]+1):n])[1:na]) - na*(na+1)/2
      }
      pjtrsum[np] <- jtrsum
      # permute the data; this way the first value is the original statistic
      x <- sample(x)
    }
    # one-sided p-values
    # number of permuted values at least as small as original
    iPVAL <- sum(pjtrsum <= pjtrsum[1])/nperm
    # number of permuted values at least as large as original
    dPVAL <- sum(pjtrsum >= pjtrsum[1])/nperm
    # return p-value for the alternative of interest
    PVAL <- switch(alternative,
                   "two.sided" = 2*min(iPVAL, dPVAL, 1),
                   "increasing" = iPVAL,
                   "decreasing" = dPVAL)
    PVAL
  }

  if(!is.numeric(x)) stop("data values should be numeric")
  if(!is.numeric(g) & !is.ordered(g)) stop("group should be numeric or ordered factor")
  alternative <- match.arg(alternative)
  METHOD <- "Jonckheere-Terpstra test"
  PERM <- !missing(nperm)
  n <- length(x)
  if(length(g) != n) stop("lengths of data values and group don't match")
  TIES <- length(unique(x)) != n
  gsize <- table(g)
  ng <- length(gsize)
  cgsize <- c(0,cumsum(gsize))
  x <- x[order(g)]
  jtrsum <- jtmean <- jtvar <- 0
  for(i in 1:(ng-1)) {
    na <- gsize[i]
    nb <- n-cgsize[i+1]
    jtrsum <- jtrsum + sum(rank(x[(cgsize[i]+1):n])[1:na]) - na*(na+1)/2
    jtmean <- jtmean + na*nb/2
    jtvar <- jtvar + na*nb*(na+nb+1)/12
  }
# this jtrsum will be small if data are increasing and large if decreasing
# to reverse this use 2*jtmean - jtrsum
  jtrsum <- 2*jtmean - jtrsum
  STATISTIC <- jtrsum
  names(STATISTIC) <- "JT"
  if (PERM) {
    PVAL <- jtperm.p(x, ng, gsize, cgsize, alternative, nperm)
  } else {
    if (n > 100 | TIES) {
      warning("Sample size > 100 or data with ties \n p-value based on normal approximation. Specify nperm for permutation p-value")
      zstat <- (STATISTIC-jtmean)/sqrt(jtvar)
      PVAL <- pnorm(zstat)
      PVAL <- switch(alternative,
                     "two.sided" = 2*min(PVAL, 1-PVAL, 1),
                     "increasing" = 1-PVAL,
                     "decreasing" = PVAL)
    } else {
      dPVAL <- sum(jtpdf(gsize)[1:(jtrsum+1)])
      iPVAL <- 1-sum(jtpdf(gsize)[1:(jtrsum)])
      PVAL <- switch(alternative,
                     "two.sided" = 2*min(iPVAL, dPVAL, 1),
                     "increasing" = iPVAL,
                     "decreasing" = dPVAL)
    }
  }

  RVAL <- list(statistic = STATISTIC,
               p.value = as.numeric(PVAL),
               alternative = alternative,
               method = METHOD,
               data.name = DNAME)
  class(RVAL) <- "htest"
  RVAL

}



# ***********************************
# Tests aus library(nortest)

ShapiroFranciaTest <- function (x) {
    DNAME <- deparse(substitute(x))
    x <- sort(x[complete.cases(x)])
    n <- length(x)
    if ((n < 5 || n > 5000))
        stop("sample size must be between 5 and 5000")
    y <- qnorm(ppoints(n, a = 3/8))
    W <- cor(x, y)^2
    u <- log(n)
    v <- log(u)
    mu <- -1.2725 + 1.0521 * (v - u)
    sig <- 1.0308 - 0.26758 * (v + 2/u)
    z <- (log(1 - W) - mu)/sig
    pval <- pnorm(z, lower.tail = FALSE)
    RVAL <- list(statistic = c(W = W), p.value = pval, method = "Shapiro-Francia normality test",
        data.name = DNAME)
    class(RVAL) <- "htest"
    return(RVAL)
}


PearsonTest <- function (x, n.classes = ceiling(2 * (n^(2/5))), adjust = TRUE) {

    DNAME <- deparse(substitute(x))
    x <- x[complete.cases(x)]
    n <- length(x)
    if (adjust) {
        dfd <- 2
    }
    else {
        dfd <- 0
    }
    num <- floor(1 + n.classes * pnorm(x, mean(x), sd(x)))
    count <- tabulate(num, n.classes)
    prob <- rep(1/n.classes, n.classes)
    xpec <- n * prob
    h <- ((count - xpec)^2)/xpec
    P <- sum(h)
    pvalue <- pchisq(P, n.classes - dfd - 1, lower.tail = FALSE)
    RVAL <- list(statistic = c(P = P), p.value = pvalue, method = "Pearson chi-square normality test",
        data.name = DNAME, n.classes = n.classes, df = n.classes -
            1 - dfd)
    class(RVAL) <- "htest"
    return(RVAL)
}


LillieTest <- function (x) {

    DNAME <- deparse(substitute(x))
    x <- sort(x[complete.cases(x)])
    n <- length(x)
    if (n < 5)
        stop("sample size must be greater than 4")
    p <- pnorm((x - mean(x))/sd(x))
    Dplus <- max(seq(1:n)/n - p)
    Dminus <- max(p - (seq(1:n) - 1)/n)
    K <- max(Dplus, Dminus)
    if (n <= 100) {
        Kd <- K
        nd <- n
    }
    else {
        Kd <- K * ((n/100)^0.49)
        nd <- 100
    }
    pvalue <- exp(-7.01256 * Kd^2 * (nd + 2.78019) + 2.99587 *
        Kd * sqrt(nd + 2.78019) - 0.122119 + 0.974598/sqrt(nd) +
        1.67997/nd)
    if (pvalue > 0.1) {
        KK <- (sqrt(n) - 0.01 + 0.85/sqrt(n)) * K
        if (KK <= 0.302) {
            pvalue <- 1
        }
        else if (KK <= 0.5) {
            pvalue <- 2.76773 - 19.828315 * KK + 80.709644 *
                KK^2 - 138.55152 * KK^3 + 81.218052 * KK^4
        }
        else if (KK <= 0.9) {
            pvalue <- -4.901232 + 40.662806 * KK - 97.490286 *
                KK^2 + 94.029866 * KK^3 - 32.355711 * KK^4
        }
        else if (KK <= 1.31) {
            pvalue <- 6.198765 - 19.558097 * KK + 23.186922 *
                KK^2 - 12.234627 * KK^3 + 2.423045 * KK^4
        }
        else {
            pvalue <- 0
        }
    }
    RVAL <- list(statistic = c(D = K), p.value = pvalue, method = "Lilliefors (Kolmogorov-Smirnov) normality test",
        data.name = DNAME)
    class(RVAL) <- "htest"
    return(RVAL)
}


CramerVonMisesTest <- function (x) {
    DNAME <- deparse(substitute(x))
    x <- sort(x[complete.cases(x)])
    n <- length(x)
    if (n < 8)
        stop("sample size must be greater than 7")
    p <- pnorm((x - mean(x))/sd(x))
    W <- (1/(12 * n) +
        sum(
            (p - (2 * seq(1:n) - 1)/(2 * n))^2
        ))
    WW <- (1 + 0.5/n) * W
    if (WW < 0.0275) {
        pval <- 1 - exp(-13.953 + 775.5 * WW - 12542.61 * WW^2)
    }
    else if (WW < 0.051) {
        pval <- 1 - exp(-5.903 + 179.546 * WW - 1515.29 * WW^2)
    }
    else if (WW < 0.092) {
        pval <- exp(0.886 - 31.62 * WW + 10.897 * WW^2)
    }
    else if (WW < 1.1) {
        pval <- exp(1.111 - 34.242 * WW + 12.832 * WW^2)
    }
    else {
        warning("p-value is smaller than 7.37e-10, cannot be computed more accurately")
        pval <- 7.37e-10
    }
    RVAL <- list(statistic = c(W = W), p.value = pval, method = "Cramer-von Mises normality test",
        data.name = DNAME)
    class(RVAL) <- "htest"
    return(RVAL)
}


#
# AndersonDarlingTest <- function (x) {
#
#     DNAME <- deparse(substitute(x))
#     x <- sort(x[complete.cases(x)])
#     n <- length(x)
#     if (n < 8)
#         stop("sample size must be greater than 7")
#     p <- pnorm((x - mean(x))/sd(x))
#     h <- (2 * seq(1:n) - 1) * (log(p) + log(1 - rev(p)))
#     A <- -n - mean(h)
#     AA <- (1 + 0.75/n + 2.25/n^2) * A
#
#     if (AA < 0.2) {
#         pval <- 1 - exp(-13.436 + 101.14 * AA - 223.73 * AA^2)
#     }
#     else if (AA < 0.34) {
#         pval <- 1 - exp(-8.318 + 42.796 * AA - 59.938 * AA^2)
#     }
#     else if (AA < 0.6) {
#         pval <- exp(0.9177 - 4.279 * AA - 1.38 * AA^2)
#     }
#     else if (AA < 160) {
#         pval <- exp(1.2937 - 5.709 * AA + 0.0186 * AA^2)
#     }
#     else {
#       pval <-0
#     }
#       RVAL <- list(statistic = c(A = A), p.value = pval, method = "Anderson-Darling normality test",
#         data.name = DNAME)
#     class(RVAL) <- "htest"
#     return(RVAL)
# }


##
## andarl.R
##
##  Anderson-Darling test and null distribution
##
## $Revision: 1.6 $ $Date: 2014/06/24 02:12:20 $
##

AndersonDarlingTest <- function(x, null="punif", ..., nullname) {

  .recogniseCdf <- function(s="punif") {
    if(!is.character(s) || length(s) != 1) return(NULL)
    if(nchar(s) <= 1 || substr(s,1,1) != "p") return(NULL)
    root <- substr(s, 2, nchar(s))
    a <- switch(root,
                beta     = "beta",
                binom    = "binomial",
                birthday = "birthday coincidence",
                cauchy   = "Cauchy",
                chisq    = "chi-squared",
                exp      = "exponential",
                f        = "F",
                gamma    = "Gamma",
                geom     = "geometric",
                hyper    = "hypergeometric",
                lnorm    = "log-normal",
                logis    = "logistic",
                nbinom   = "negative binomial",
                norm     = "Normal",
                pois     = "Poisson",
                t        = "Student's t",
                tukey    = "Tukey (Studentized range)",
                unif     = "uniform",
                weibull  = "Weibull",
                NULL)
    if(!is.null(a))
      return(paste(a, "distribution"))
    b <- switch(root,
                AD     = "Anderson-Darling",
                CvM    = "Cramer-von Mises",
                wilcox = "Wilcoxon Rank Sum",
                NULL)
    if(!is.null(b))
      return(paste("null distribution of", b, "Test Statistic"))
    return(NULL)
  }


  xname <- deparse(substitute(x))
  nulltext <- deparse(substitute(null))
  if(is.character(null)) nulltext <- null
  if(missing(nullname) || is.null(nullname)) {
    reco <- .recogniseCdf(nulltext)
    nullname <- if(!is.null(reco)) reco else
      paste("distribution", sQuote(nulltext))
  }
  stopifnot(is.numeric(x))
  x <- as.vector(x)
  n <- length(x)
  F0 <- if(is.function(null)) null else
    if(is.character(null)) get(null, mode="function") else
      stop("Argument 'null' should be a function, or the name of a function")
  U <- F0(x, ...)
  if(any(U < 0 | U > 1))
    stop("null distribution function returned values outside [0,1]")
  U <- sort(U)
  k <- seq_len(n)
  ## call Marsaglia C code
  z <- .C("ADtestR",
          x = as.double(U),
          n = as.integer(n),
          adstat = as.double(numeric(1)),
          pvalue = as.double(numeric(1))
  )
  STATISTIC <- z$adstat
  names(STATISTIC) <- "An"
  PVAL <- z$pvalue
  METHOD <- c("Anderson-Darling test of goodness-of-fit",
              paste("Null hypothesis:", nullname))
  extras <- list(...)
  parnames <- intersect(names(extras), names(formals(F0)))
  if(length(parnames) > 0) {
    pars <- extras[parnames]
    pard <- character(0)
    for(i in seq_along(parnames))
      pard[i] <- paste(parnames[i], "=", paste(pars[[i]], collapse=" "))
    pard <- paste("with",
                  ngettext(length(pard), "parameter", "parameters"),
                  "  ",
                  paste(pard, collapse=", "))
    METHOD <- c(METHOD, pard)
  }
  out <- list(statistic = STATISTIC,
              p.value = PVAL,
              method = METHOD,
              data.name = xname)
  class(out) <- "htest"
  return(out)
}

.pAD <- function(q, n=Inf, lower.tail=TRUE, fast=TRUE) {
  q <- as.numeric(q)
  p <- rep(NA_real_, length(q))
  if(any(ones <- is.infinite(q) & (q == Inf)))
    p[ones] <- 1
  if(any(zeroes <- (is.finite(q) & q <= 0) | (is.infinite(q) & (q == -Inf))))
    p[zeroes] <- 0
  ok <- is.finite(q) & (q > 0)
  nok <- sum(ok)
  if(nok > 0) {
    if(is.finite(n)) {
      z <- .C("ADprobN",
              a       = as.double(q[ok]),
              na      = as.integer(nok),
              nsample = as.integer(n),
              prob    = as.double(numeric(nok))
      )
      p[ok] <- z$prob
    } else if(fast) {
      ## fast version adinf()
      z <- .C("ADprobApproxInf",
              a    = as.double(q[ok]),
              na   = as.integer(nok),
              prob = as.double(numeric(nok))
      )
      p[ok] <- z$prob
    } else {
      ## slow, accurate version ADinf()
      z <- .C("ADprobExactInf",
              a    = as.double(q[ok]),
              na   = as.integer(nok),
              prob = as.double(numeric(nok))
      )
      p[ok] <- z$prob
    }

  }
  if(!lower.tail)
    p <- 1 - p
  return(p)
}


# .qAD <- local({
#
#   f <- function(x, N, P, Fast) {
#     .pAD(x, N, fast=Fast) - P
#   }
#
#   .qAD <- function(p, n=Inf, lower.tail=TRUE, fast=TRUE) {
#     ## quantiles of null distribution of Anderson-Darling test statistic
#     stopifnot(all(p >= 0))
#     stopifnot(all(p <= 1))
#     if(!lower.tail) p <- 1-p
#     ans <- rep(NA_real_, length(p))
#     for(i in which(p >= 0 & p < 1))
#       ans[i] <- uniroot(f, c(0, 1), N=n, P=p[i], Fast=fast, extendInt="up")$root
#     return(ans)
#   }
#
#   .qAD
# })
#
#
#




# ***********************************
# Tests aus library(tseries)
#
# JarqueBeraTest <- function(x, robust=TRUE, na.rm=FALSE) {
#
#   # Author: Adrian Trapletti
#
#   if(NCOL(x) > 1)
#       stop("x is not a vector or univariate time series")
#
#   if(na.rm) x <- na.omit(x)
#
#   DNAME <- deparse(substitute(x))
#   n <- length(x)
#   m1 <- sum(x)/n
#   m2 <- sum((x-m1)^2)/n
#   m3 <- sum((x-m1)^3)/n
#   m4 <- sum((x-m1)^4)/n
#   b1 <- (m3/m2^(3/2))^2
#   b2 <- (m4/m2^2)
#   STATISTIC <- n * b1 / 6 + n * (b2 - 3)^2 / 24
#   names(STATISTIC) <- "X-squared"
#   PARAMETER <- 2
#   names(PARAMETER) <- "df"
#   PVAL <- 1 - pchisq(STATISTIC,df = 2)
#   METHOD <- "Jarque Bera Test"
#   structure(list(statistic = STATISTIC,
#                  parameter = PARAMETER,
#                  p.value = PVAL,
#                  method = METHOD,
#                  data.name = DNAME),
#             class = "htest")
# }
#
#



JarqueBeraTest <- function (x, robust=TRUE, method=c("chisq", "mc"), N=0, na.rm=FALSE) {

  method <- match.arg(method)

  if (NCOL(x) > 1){ stop("x is not a vector or univariate time series") }
  if(na.rm) x <- na.omit(x)

  if ((method == "mc") & (N==0)) {
    stop("number of Monte Carlo simulations N should be provided for the empirical critical values")
  }

  DNAME <- deparse(substitute(x))

  ## Calculate the first 4 central moments
  n <- length(x)
  m1 <- sum(x)/n
  m2 <- sum((x - m1)^2)/n
  m3 <- sum((x - m1)^3)/n
  m4 <- sum((x - m1)^4)/n

  ## User can choose the Standard Jarque Bera Test or Robust Jarque Bera Test
  ## Robust Jarque Bera Test is default
  if(!robust) {
    b1 <- (m3/m2^(3/2))^2;
    b2 <- (m4/m2^2);
    statistic <- n * b1/6 + n * (b2 - 3)^2/24

  } else {
    J <- sqrt(pi/2) * mean(abs(x-median(x)))
    J2 <- J^2
    b1 <- (m3/(J2)^(3/2))^2
    b2 <- (m4/(J2)^2)
    vk<-64/n
    vs<-6/n
    ek<-3
    statistic <- b1/vs + (b2 - ek)^2/vk

  }

  if(method == "mc"){
    if(!robust) {
      ## computes empirical critical values for the JB statistic

      jb<-double(N)

      for (k in 1:N) {
        e <- rnorm(length(x), mean=0, sd = sqrt(1))
        m1 <- sum(e)/n
        m2 <- sum((e - m1)^2)/n
        m3 <- sum((e - m1)^3)/n
        m4 <- sum((e - m1)^4)/n
        b1 <- (m3/m2^(3/2))^2
        b2 <- (m4/m2^2)
        vk <- 24/n
        vs <- 6/n
        ek <- 3
        jb[k] <- b1/vs + (b2 - ek)^2/vk
      }

      y <- sort(jb)

      if (statistic >= max(y)) {
        p.value <- 0

      } else if (statistic<=min(y)) {
        p.value <- 1

      } else {
        bn <- which(y==min(y[I(y>=statistic)]))
        an <- which(y==max(y[I(y<statistic)]))
        a <- max(y[I(y<statistic)])
        b <- min(y[I(y>=statistic)])
        pa <- (an - 1) / (N - 1)
        pb <- (bn - 1) / (N - 1)
        alpha <- (statistic-a)/(b-a)
        p.value <- 1-alpha*pb-(1-alpha)*pa
      }

    } else {
      ## computes empirical critical values for the RJB statistic
      rjb <- double(N)

      for (k in 1:N) {
        e <- rnorm(length(x), mean=0, sd = sqrt(1))
        J <- sqrt(pi/2)*mean(abs(e-median(e)))
        J2 <- J^2
        m1 <- sum(e)/n
        m2 <- sum((e - m1)^2)/n
        m3 <- sum((e - m1)^3)/n
        m4 <- sum((e - m1)^4)/n
        b1 <- (m3/(J2)^(3/2))^2
        b2 <- (m4/(J2)^2)
        vk <- 64/n
        vs <- 6/n
        ek <- 3
        rjb[k] <- b1/vs + (b2 - ek)^2/vk
      }

      y <- sort(rjb)

      if (statistic >= max(y)) {
        p.value <- 0

      } else if (statistic <= min(y)) {
        p.value <- 1

      } else {
        bn <- which(y==min(y[I(y>=statistic)]))
        an <- which(y==max(y[I(y<statistic)]))
        a <- max(y[I(y<statistic)])
        b <- min(y[I(y>=statistic)])
        pa <- (an - 1) / (N - 1)
        pb <- (bn - 1) / (N - 1)
        alpha <- (statistic-a)/(b-a)
        p.value <- 1-alpha*pb-(1-alpha)*pa
      }
    }

  } else {
    p.value <- 1 - pchisq(statistic, df = 2)
  }

  METHOD <- ifelse(!robust, "Jarque Bera Test", "Robust Jarque Bera Test")
  STATISTIC=statistic
  names(STATISTIC) <- "X-squared"
  PARAMETER <- 2
  names(PARAMETER) <- "df"

  structure(list(statistic = STATISTIC, parameter = PARAMETER,
            p.value = p.value, method = METHOD, data.name = DNAME),
            class = "htest")

}




# PageTest <- function(x) {
#
#   DNAME <- deparse(substitute(x))
#   x <- x[complete.cases(x),]
#
#   rnksum <- apply(apply(x, 1, rank),1, sum)
#   L <- sum(seq_along(rnksum) * rnksum)
#   nc <- ncol(x)
#   nr <- nrow(x)
#   mu <- nr * nc * (nc+1)^2 / 4
#   sig <- nr * nc^2 * (nc+1)^2*(nc-1) / 144
#   z <- (L - mu)/sqrt(sig)
#
#   pval <- pnorm(z, lower.tail = FALSE)
#   RVAL <- list(statistic = c(L = L), p.value = pval, method = "Page test for ordered alternatives",
#       data.name = DNAME)
#   class(RVAL) <- "htest"
#   return(RVAL)
#
# }



# PageTest<-function(x) {

# ### Alternative: package coin
# ### independence_test(scores ~ product | sitting, data = egg_data,
# ### scores = list(product = 1:10),
# ### ytrafo = yt)

# ### http://imaging.mrc-cbu.cam.ac.uk/statswiki/FAQ/pagesL


  # if(missing(x))
    # stop("Usage: PageTest(x)\n\twhere x is a matrix of ranks")

  # dname <- deparse(substitute(x))

  # dimx <- dim(x)

  # ### This one only requires two dimensions
  # page.crit3 <- array(
    # c(28,41,54,66,79,91,104,116,128,141,153,165,178,190,202,215,227,239,251,
    # NA,42,55,68,81,93,106,119,131,144,156,169,181,194,206,218,231,243,256,
    # NA,NA,56,70,83,96,109,121,134,147,160,172,185,197,210,223,235,248,260),
    # c(19,3)
  # )

  # ### the rest require three
  # page.crit4plus <- array(
    # c(58,84,111,137,163,189,214,240,266,292,317,
    # 103,150,197,244,291,338,384,431,477,523,570,
    # 166,244,321,397,474,550,625,701,777,852,928,
    # 252,370,487,603,719,835,950,1065,1180,1295,1410,
    # 362,532,701,869,1037,1204,1371,1537,1703,1868,2035,
    # 500,736,971,1204,1436,1668,1900,2131,2361,2592,2822,
    # 670,987,1301,1614,1927,2238,2549,2859,3169,3478,3788,
    # 60,87,114,141,167,193,220,246,272,298,324,
    # 106,155,204,251,299,346,393,441,487,534,581,
    # 173,252,331,409,486,563,640,717,793,869,946,
    # 261,382,501,620,737,855,972,1088,1205,1321,1437,
    # 376,549,722,893,1063,1232,1401,1569,1736,1905,2072,
    # 520,761,999,1236,1472,1706,1940,2174,2407,2639,2872,
    # 696,1019,1339,1656,1972,2288,2602,2915,3228,3541,3852,
    # NA,89,117,145,172,198,225,252,278,305,331,
    # 109,160,210,259,307,355,403,451,499,546,593,
    # 178,260,341,420,499,577,655,733,811,888,965,
    # 269,394,516,637,757,876,994,1113,1230,1348,1465,
    # 388,567,743,917,1090,1262,1433,1603,1773,1943,2112,
    # 544,790,1032,1273,1512,1750,1987,2223,2459,2694,2929,
    # 726,1056,1382,1704,2025,2344,2662,2980,3296,3612,3927),
    # c(11,7,3)
    # )

  # mean.ranks <- apply(x, 2, mean)
  # Lval <- NA
  # p.table <- NA
  # L <- sum(apply(x, 2, sum) * 1:dimx[2])

  # if((dimx[1] > 1 && dimx[1] < 13) && (dimx[2] > 3 && dimx[2] < 11))
    # Lval <- page.crit4plus[dimx[1]-1,dimx[2]-3,]

  # if((dimx[1] > 1 && dimx[1] < 21) && dimx[2] == 3)
    # Lval <- page.crit3[dimx[1]-1,]

  # p.table <-
    # ifelse(L > Lval[1],ifelse(L > Lval[2],ifelse(L > Lval[3],"<=.001","<=.01"),"<=.05"),"NS")
  # #### print(Lval)

  # ### if there was no tabled value, calculate the normal approximation
  # if(length(Lval)<2) {
    # munum <- dimx[1]*dimx[2]*(dimx[2]+1)*(dimx[2]+1)
    # muL <- munum/4
    # cat("muL =",muL,"\n")
    # sigmaL <- (dimx[1]*dimx[2]*dimx[2]*(dimx[2]*dimx[2]-1)*(dimx[2]*dimx[2]-1))/
      # (144*(dimx[2]-1))
    # cat("sigmaL =",sigmaL,"\n")
    # zL <- ((12*L-3*munum)/(dimx[2]*(dimx[2]-1)))*sqrt((dimx[2]-1)/dimx[1])
    # pZ <- pnorm(zL,lower.tail=FALSE)
  # } else {
    # zL <- NA
    # pZ <- NA
  # }

  # #### ptt <- list(ranks=x, mean.ranks=mean.ranks, L=L, p.table=p.table, Z=zL, pZ=pZ)
  # #### class(ptt) <- "PageTest"
  # #### return(ptt)

  # if(is.na(p.table)) pval <- pZ else pval <- p.table

  # RVAL <- list(statistic = c(L = L), p.value = pval, method = "Page test for ordered alternatives",
      # data.name = dname)
  # class(RVAL) <- "htest"
  # return(RVAL)

# }

# print.PageTest<-function(x,...) {

  # cat("\nPage test for ordered alternatives\n")
  # cat("L =",x$L)

  # if(is.na(x$p.table)) {
  # plabel<-paste("Z =",x$Z,", p =",x$pZ,sep="",collapse="")
  # cat(plabel,x$p.chisq,"\n\n")
  # }
  # else cat("  p(table) ",x$p.table,"\n\n")
# }


PageTest <- function (y, ...) UseMethod("PageTest")


PageTest.default <- function (y, groups, blocks, ...) {

  p.page <- function(k, n, L){

    qvec <- .PageDF[k][[1]]
    f1 <- qvec

    for (i in 1:(n-1)) {
      erg <- convolve(f1, qvec, conj = TRUE, type = "open")
      f1 <- erg
    }
    p <- cumsum(erg)[n * k * (k+1) * (2*k+1)/6 + 1 - L]
    return(p)

  }


  DNAME <- deparse(substitute(y))
  if (is.matrix(y)) {
    groups <- factor(c(col(y)))
    blocks <- factor(c(row(y)))
  }
  else {
    if (any(is.na(groups)) || any(is.na(blocks)))
      stop("NA's are not allowed in 'groups' or 'blocks'")
    if (any(diff(c(length(y), length(groups), length(blocks))) !=
              0L))
      stop("'y', 'groups' and 'blocks' must have the same length")
    DNAME <- paste(DNAME, ", ", deparse(substitute(groups)),
                   " and ", deparse(substitute(blocks)), sep = "")
    if (any(table(groups, blocks) != 1))
      stop("not an unreplicated complete block design")
    groups <- factor(groups)
    blocks <- factor(blocks)
    o <- order(groups, blocks)
    y <- y[o]
    groups <- groups[o]
    blocks <- blocks[o]
  }
  k <- nlevels(groups)
  y <- matrix(unlist(split(y, blocks)), ncol = k, byrow = TRUE)
  y <- y[complete.cases(y), ]
  n <- nrow(y)


  rnksum <- apply(apply(y, 1, rank), 1, sum)
  L <- sum(seq_along(rnksum) * rnksum)
  nc <- ncol(y)
  nr <- nrow(y)

  if(nc < 16){
    pval <- p.page(k=nc, n=nr, L=L)
  } else {
    mu <- nr * nc * (nc + 1)^2/4
    # sig <- nr * nc^2 * (nc + 1)^2 * (nc - 1)/144
    sigma <- nr * nc^2 * (nc+1) * (nc^2-1) / 144
    z <- (L - mu)/sqrt(sigma)
    pval <- pnorm(z, lower.tail = FALSE)

  }

  structure(list(statistic = c(L = L), p.value = pval, method = "Page test for ordered alternatives",
                 data.name = DNAME),
          class = "htest")
}


PageTest.formula <- function (formula, data, subset, na.action, ...) {

  if (missing(formula))
    stop("formula missing")
  if ((length(formula) != 3L) || (length(formula[[3L]]) !=
                                    3L) || (formula[[3L]][[1L]] != as.name("|")) || (length(formula[[3L]][[2L]]) !=
                                                                                       1L) || (length(formula[[3L]][[3L]]) != 1L))
    stop("incorrect specification for 'formula'")
  formula[[3L]][[1L]] <- as.name("+")
  m <- match.call(expand.dots = FALSE)
  m$formula <- formula
  if (is.matrix(eval(m$data, parent.frame())))
    m$data <- as.data.frame(data)
  m[[1L]] <- as.name("model.frame")
  mf <- eval(m, parent.frame())
  DNAME <- paste(names(mf), collapse = " and ")
  names(mf) <- NULL
  y <- DoCall("PageTest", as.list(mf))
  y$data.name <- DNAME
  y

}



CochranQTest <- function(y, ...){

  # Cochran's Q Test is analogue to the friedman.test with 0,1 coded response

  res <- friedman.test(y, ...)
  attr(res$statistic, "names") <- "Q"
  res$method <- "Cochran's Q test"
  return(res)
}

CochranQTest.default <- function(y, groups, blocks, ...){
  res <- friedman.test(y, groups, blocks, ...)
  attr(res$statistic, "names") <- "Q"
  res$method <- "Cochran's Q test"
  return(res)
}

CochranQTest.formula <- function(formula, data, subset, na.action, ...){
  res <- friedman.test(formula, data, subset, na.action, ...)
  attr(res$statistic, "names") <- "Q"
  res$method <- "Cochran's Q test"
  return(res)
}


MHChisqTest <- function(x, srow=1:nrow(x), scol=1:ncol(x)){

  # calculates Mantel-Haenszel Chisquare test

  # check for rxc 2-dim matrix
  p <- (d <- dim(x))[1L]
  if(!is.numeric(x) || length(d) != 2L)
    stop("'x' is not a rxc numeric matrix")

  DNAME <- deparse(substitute(x))

  STATISTIC <- (sum(x) - 1) * corr(d=CombPairs(srow, scol), as.vector(x))^2
  PARAMETER <- 1
  names(STATISTIC) <- "X-squared"
  names(PARAMETER) <- "df"
  PVAL <- pchisq(STATISTIC, PARAMETER, lower.tail = FALSE)
  METHOD <- "Mantel-Haenszel Chi-Square"

  structure(list(statistic = STATISTIC, parameter = PARAMETER,
                 p.value = PVAL, method = METHOD, data.name = DNAME), class = "htest")
}



GTest <- function(x, y = NULL, correct=c("none", "williams", "yates"), p = rep(1/length(x), length(x))) {


  # Log-likelihood tests of independence & goodness of fit
  # Does Williams' and Yates' correction
  # does Monte Carlo simulation of p-values, via gtestsim.c
  #
  # G & q calculation from Sokal & Rohlf (1995) Biometry 3rd ed.
  # TOI Yates' correction taken from Mike Camann's 2x2 G-test fn.
  # GOF Yates' correction as described in Zar (2000)
  # more stuff taken from ctest's chisq.test()
  #
  # ToDo:
  # 1) Beautify
  # 2) Add warnings for violations
  # 3) Make appropriate corrections happen by default
  #
  # V3.3 Pete Hurd Sept 29 2001. phurd@ualberta.ca


  DNAME <- deparse(substitute(x))
  if (is.data.frame(x)) x <- as.matrix(x)
  if (is.matrix(x)) {
    if (min(dim(x)) == 1)
      x <- as.vector(x)
  }
  if (!is.matrix(x) && !is.null(y)) {
    if (length(x) != length(y))
      stop("x and y must have the same length")
    DNAME <- paste(DNAME, "and", deparse(substitute(y)))
    OK <- complete.cases(x, y)
    x <- as.factor(x[OK])
    y <- as.factor(y[OK])
    if ((nlevels(x) < 2) || (nlevels(y) < 2))
      stop("x and y must have at least 2 levels")
    x <- table(x, y)
  }
  if (any(x < 0) || any(is.na(x)))
    stop("all entries of x must be nonnegative and finite")
  if ((n <- sum(x)) == 0)
    stop("at least one entry of x must be positive")

  correct <- match.arg(correct)

  #If x is matrix, do test of independence
  if (is.matrix(x)) {
    #Test of Independence
    nrows<-nrow(x)
    ncols<-ncol(x)
    if (correct=="yates"){ # Do Yates' correction?
      if(dim(x)[1]!=2 || dim(x)[2]!=2) # check for 2x2 matrix
        stop("Yates' correction requires a 2 x 2 matrix")
      if((x[1,1]*x[2,2])-(x[1,2]*x[2,1]) > 0)
      {
#         x[1,1] <- x[1,1] - 0.5
#         x[2,2] <- x[2,2] - 0.5
#         x[1,2] <- x[1,2] + 0.5
#         x[2,1] <- x[2,1] + 0.5
#   this can be done quicker: 14.5.2015 AS
        x <- x + 0.5
        diag(x) <- diag(x) - 1

      } else {

        x <- x - 0.5
        diag(x) <- diag(x) + 1

#         x[1,1] <- x[1,1] + 0.5
#         x[2,2] <- x[2,2] + 0.5
#         x[1,2] <- x[1,2] - 0.5
#         x[2,1] <- x[2,1] - 0.5
      }
    }

    sr <- apply(x,1,sum)
    sc <- apply(x,2,sum)
    E <- outer(sr,sc, "*")/n
    # are we doing a monte-carlo?
    # no monte carlo GOF?
#     if (simulate.p.value){
#       METHOD <- paste("Log likelihood ratio (G-test) test of independence\n\t with simulated p-value based on", B, "replicates")
#       tmp <- .C("gtestsim", as.integer(nrows), as.integer(ncols),
#                 as.integer(sr), as.integer(sc), as.integer(n), as.integer(B),
#                 as.double(E), integer(nrows * ncols), double(n+1),
#                 integer(ncols), results=double(B), PACKAGE= "ctest")
#       g <- 0
#       for (i in 1:nrows){
#         for (j in 1:ncols){
#           if (x[i,j] != 0) g <- g + x[i,j] * log(x[i,j]/E[i,j])
#         }
#       }
#       STATISTIC <- G <- 2 * g
#       PARAMETER <- NA
#       PVAL <- sum(tmp$results >= STATISTIC)/B
#     }
#     else {
      # no monte-carlo
      # calculate G
      g <- 0
      for (i in 1:nrows){
        for (j in 1:ncols){
          if (x[i,j] != 0) g <- g + x[i,j] * log(x[i,j]/E[i,j])
        }
# }
      q <- 1
      if (correct=="williams"){ # Do Williams' correction
        row.tot <- col.tot <- 0
        for (i in 1:nrows){ row.tot <- row.tot + 1/(sum(x[i,])) }
        for (j in 1:ncols){ col.tot <- col.tot + 1/(sum(x[,j])) }
        q <- 1+ ((n*row.tot-1)*(n*col.tot-1))/(6*n*(ncols-1)*(nrows-1))
      }
      STATISTIC <- G <- 2 * g / q
      PARAMETER <- (nrow(x)-1)*(ncol(x)-1)
      PVAL <- 1-pchisq(STATISTIC,df=PARAMETER)
      if(correct=="none")
        METHOD <- "Log likelihood ratio (G-test) test of independence without correction"
      if(correct=="williams")
        METHOD <- "Log likelihood ratio (G-test) test of independence with Williams' correction"
      if(correct=="yates")
        METHOD <- "Log likelihood ratio (G-test) test of independence with Yates' correction"
    }
  }
  else {
    # x is not a matrix, so we do Goodness of Fit
    METHOD <- "Log likelihood ratio (G-test) goodness of fit test"
    if (length(x) == 1)
      stop("x must at least have 2 elements")
    if (length(x) != length(p))
      stop("x and p must have the same number of elements")
    E <- n * p

    if (correct=="yates"){ # Do Yates' correction
      if(length(x)!=2)
        stop("Yates' correction requires 2 data values")
      if ( (x[1]-E[1]) > 0.25) {
        x[1] <- x[1]-0.5
        x[2] <- x[2]+0.5
      }
      else if ( (E[1]-x[1]) > 0.25){
        x[1] <- x[1]+0.5
        x[2] <- x[2]-0.5
      }
    }
    names(E) <- names(x)
    g <- 0
    for (i in 1:length(x)){
      if (x[i] != 0) g <- g + x[i] * log(x[i]/E[i])
    }
    q <- 1
    if (correct=="williams"){ # Do Williams' correction
      q <- 1+(length(x)+1)/(6*n)
    }
    STATISTIC <- G <- 2*g/q
    PARAMETER <- length(x) - 1
    PVAL <- pchisq(STATISTIC, PARAMETER, lower.tail = FALSE)
  }
  names(STATISTIC) <- "G"
  names(PARAMETER) <- "X-squared df"
  names(PVAL) <- "p.value"
  structure(list(statistic=STATISTIC,parameter=PARAMETER,p.value=PVAL,
                 method=METHOD,data.name=DNAME, observed=x, expected=E),
            class="htest")
}






StuartMaxwellTest <- function (x, y = NULL) {

  # stuart.maxwell.mh computes the marginal homogeneity test for
  # a CxC matrix of assignments of objects to C categories or an
  # nx2 or 2xn matrix of category scores for n data objects by two
  # raters. The statistic is distributed as Chi-square with C-1
  # degrees of freedom.

  # The core code is form Jim Lemon, package concord
  # the intro is taken from mcnemar.test (core)

  if (is.matrix(x)) {
    r <- nrow(x)
    if ((r < 2) || (ncol(x) != r))
      stop("'x' must be square with at least two rows and columns")
    if (any(x < 0) || anyNA(x))
      stop("all entries of 'x' must be nonnegative and finite")
    DNAME <- deparse(substitute(x))
  }
  else {
    if (is.null(y))
      stop("if 'x' is not a matrix, 'y' must be given")
    if (length(x) != length(y))
      stop("'x' and 'y' must have the same length")
    DNAME <- paste(deparse(substitute(x)), "and", deparse(substitute(y)))
    OK <- complete.cases(x, y)
    x <- as.factor(x[OK])
    y <- as.factor(y[OK])
    r <- nlevels(x)
    if ((r < 2) || (nlevels(y) != r))
      stop("'x' and 'y' must have the same number of levels (minimum 2)")
    x <- table(x, y)
  }

  # get the marginals
  rowsums <- rowSums(x)
  colsums <- colSums(x)
  equalsums <- rowsums == colsums

  if(any(equalsums)) {
    # dump any categories with perfect agreement
    x <- x[!equalsums, !equalsums]
    # bail out if too many categories have disappeared
    if(dim(x)[1] < 2) stop("Too many equal marginals, cannot compute")
    # get new marginals
    rowsums <- rowSums(x)
    colsums <- colSums(x)
  }

  # use K-1 marginals
  Kminus1 <- length(rowsums) - 1
  smd <- (rowsums-colsums)[1:Kminus1]
  smS <- matrix(0, nrow=Kminus1, ncol=Kminus1)
  for(i in 1:Kminus1) {
    for(j in 1:Kminus1) {
      if(i == j) smS[i,j] <- rowsums[i] + colsums[j] - 2 * x[i,j]
      else smS[i,j] <- -(x[i,j] + x[j,i])
    }
  }

  STATISTIC <- t(smd) %*% solve(smS) %*% smd

  PARAMETER <- r - 1
  METHOD <- "Stuart-Maxwell test"

  PVAL <- pchisq(STATISTIC, PARAMETER, lower.tail = FALSE)
  names(STATISTIC) <- "chi-squared"
  names(PARAMETER) <- "df"
  RVAL <- list(statistic = STATISTIC, parameter = PARAMETER,
               p.value = PVAL, method = METHOD, data.name = DNAME)
  class(RVAL) <- "htest"
  return(RVAL)

}




BreslowDayTest <- function(x, OR = NA, correct = FALSE) {

  # Function to perform the Breslow and Day (1980) test including
  # the corrected test by Tarone
  # Uses the equations in Lachin (2000) p. 124-125.
  #
  # Programmed by Michael Hoehle <http://www-m4.ma.tum.de/pers/hoehle>
  # Note that the results of the Tarone corrected test do
  # not correspond to the numbers in the Lachin book...
  #
  # Params:
  #  x - a 2x2xK contingency table
  #  correct - if TRUE Tarones correction is returned
  #
  # Returns:
  #  a vector with three values
  #   statistic - Breslow and Day test statistic
  #   pval - p value evtl. based on the Tarone test statistic
  #               using a \chi^2(K-1) distribution
  #


  if(is.na(OR)) {
    #Find the common OR based on Mantel-Haenszel
    or.hat.mh <- mantelhaen.test(x)$estimate
  } else {
    or.hat.mh <- OR
  }

  #Number of strata
  K <- dim(x)[3]
  #Value of the Statistic
  X2.HBD <- 0
  #Value of aj, tildeaj and Var.aj
  a <- tildea <- Var.a <- numeric(K)

  for (j in 1:K) {
    #Find marginals of table j
    mj <- apply(x[,,j], MARGIN=1, sum)
    nj <- apply(x[,,j], MARGIN=2, sum)

    #Solve for tilde(a)_j
    coef <- c(-mj[1]*nj[1] * or.hat.mh, nj[2]-mj[1]+or.hat.mh*(nj[1]+mj[1]),
              1-or.hat.mh)
    sols <- Re(polyroot(coef))
    #Take the root, which fulfills 0 < tilde(a)_j <= min(n1_j, m1_j)
    tildeaj <- sols[(0 < sols) &  (sols <= min(nj[1],mj[1]))]
    #Observed value
    aj <- x[1,1,j]

    #Determine other expected cell entries
    tildebj <- mj[1] - tildeaj
    tildecj <- nj[1] - tildeaj
    tildedj <- mj[2] - tildecj

    #Compute \hat{\Var}(a_j | \widehat{\OR}_MH)
    Var.aj <- (1/tildeaj + 1/tildebj + 1/tildecj + 1/tildedj)^(-1)

    #Compute contribution
    X2.HBD <- X2.HBD + as.numeric((aj - tildeaj)^2 / Var.aj)

    #Assign found value for later computations
    a[j] <- aj ;  tildea[j] <- tildeaj ; Var.a[j] <- Var.aj
  }

  # Compute Tarone corrected test
  X2.HBDT <-as.numeric( X2.HBD -  (sum(a) - sum(tildea))^2/sum(Var.aj) )

  DNAME <- deparse(substitute(x))

  STATISTIC <- if(correct) X2.HBDT else X2.HBD
  PARAMETER <- K - 1
  # Compute p-value based on the Tarone corrected test
  PVAL <- 1 - pchisq(STATISTIC, PARAMETER)
  METHOD <- if(correct) "Breslow-Day Test on Homogeneity of Odds Ratios (with Tarone correction)" else
    "Breslow-Day test on Homogeneity of Odds Ratios"
  names(STATISTIC) <- "X-squared"
  names(PARAMETER) <- "df"
  structure(list(statistic = STATISTIC, parameter = PARAMETER,
                 p.value = PVAL, method = METHOD, data.name = DNAME
  ), class = "htest")

}


# the VCD package (available via CRAN) has a function called woolf_test()

WoolfTest <- function(x) {

  DNAME <- deparse(substitute(x))
  if (any(x == 0))
    x <- x + 1 / 2
  k <- dim(x)[3]
  or <- apply(x, 3, function(x) (x[1,1] * x[2,2]) / (x[1,2] * x[2,1]))
  w <-  apply(x, 3, function(x) 1 / sum(1 / x))
  o <- log(or)
  e <- weighted.mean(log(or), w)
  STATISTIC <- sum(w * (o - e)^2)
  PARAMETER <- k - 1
  PVAL <- 1 - pchisq(STATISTIC, PARAMETER)
  METHOD <- "Woolf Test on Homogeneity of Odds Ratios (no 3-Way assoc.)"
  names(STATISTIC) <- "X-squared"
  names(PARAMETER) <- "df"
  structure(list(statistic = STATISTIC, parameter = PARAMETER,
                 p.value = PVAL, method = METHOD, data.name = DNAME, observed = o,
                 expected = e), class = "htest")

}


LehmacherTest <- function(x, y = NULL) {

  if (is.matrix(x)) {
    r <- nrow(x)
    if ((r < 2) || (ncol(x) != r))
      stop("'x' must be square with at least two rows and columns")
    if (any(x < 0) || anyNA(x))
      stop("all entries of 'x' must be nonnegative and finite")
    DNAME <- deparse(substitute(x))
  }
  else {
    if (is.null(y))
      stop("if 'x' is not a matrix, 'y' must be given")
    if (length(x) != length(y))
      stop("'x' and 'y' must have the same length")
    DNAME <- paste(deparse(substitute(x)), "and", deparse(substitute(y)))
    OK <- complete.cases(x, y)
    x <- as.factor(x[OK])
    y <- as.factor(y[OK])
    r <- nlevels(x)
    if ((r < 2) || (nlevels(y) != r))
      stop("'x' and 'y' must have the same number of levels (minimum 2)")
    x <- table(x, y)
  }

  rsum <- rowSums(x)
  csum <- colSums(x)

  STATISTIC <- (rsum-csum)^2 / (rsum + csum - 2*diag(x))
  PARAMETER <- 1
  PVAL <- 1 - pchisq(STATISTIC, PARAMETER)
  METHOD <- "Lehmacher-Test on Marginal Homogeneity"
  names(STATISTIC) <- "X-squared"
  names(PARAMETER) <- "df"
  structure(list(statistic = STATISTIC, parameter = PARAMETER,
                 p.value = PVAL, p.value.corr = p.adjust(PVAL, "hochberg"),
                 method = METHOD, data.name = DNAME),
            class = "mtest")

}


print.mtest <- function (x, digits = 4L, ...) {

  cat("\n")
  cat(strwrap(x$method, prefix = "\t"), sep = "\n")
  cat("\n")
  cat("data:  ", x$data.name, "\n", sep = "")

  out <- character()
  out <- cbind(format(round(x$statistic, 4)), format.pval(x$p.value, digits = digits),
               format.pval(x$p.value.corr, digits = digits),
               symnum(x$p.value.corr, corr = FALSE, na = FALSE,
                      cutpoints = c(0, 0.001, 0.01, 0.05, 0.1, 1),
                      symbols = c("***", "**", "*", ".", " ")))
  colnames(out) <- c("X-squared", "pval", "pval adj", " ")
  rownames(out) <- if(is.null(rownames(x))) 1:length(x$statistic) else rownames(x)
  print.default(out, digits = 3, quote = FALSE, right = TRUE)

  cat("\n")
  cat("---\nSignif. codes: 0 `***' 0.001 `**' 0.01 `*' 0.05 `.' 0.1 ` ' 1\n\n")
  invisible(x)
}




CochranArmitageTest <- function(x, alternative = c("two.sided","increasing","decreasing")) {

  # based on:
  # http://tolstoy.newcastle.edu.au/R/help/05/07/9442.html
  DNAME <- deparse(substitute(x))

  if (!(any(dim(x)==2)))
    stop("Cochran-Armitage test for trend must be used with rx2-table", call.=FALSE)

  if (dim(x)[2]!=2) x <- t(x)

  nidot <- apply(x, 1, sum)
  n <- sum(nidot)

  # Ri <- scores(x, 1, "table")
  Ri <- 1:dim(x)[1]
  Rbar <- sum(nidot*Ri)/n

  s2 <- sum(nidot*(Ri-Rbar)^2)
  pdot1 <- sum(x[,1])/n
  z <- sum(x[,1]*(Ri-Rbar))/sqrt(pdot1*(1-pdot1)*s2)
  STATISTIC <- z

  alternative <- match.arg(alternative)

  PVAL <- switch(alternative,
            two.sided = 2*pnorm(abs(z), lower.tail=FALSE),
            increasing = pnorm(z),
            decreasing = pnorm(z, lower.tail=FALSE) )

  PARAMETER <- dim(x)[1]
  names(STATISTIC) <- "Z"
  names(PARAMETER) <- "dim"

  METHOD <- "Cochran-Armitage test for trend"
  structure(list(statistic = STATISTIC, parameter = PARAMETER, alternative = alternative,
                 p.value = PVAL, method = METHOD, data.name = DNAME
                 ), class = "htest")

}



EtaSq <- function (x, type = 2, anova = FALSE) {
  UseMethod("EtaSq")
}

EtaSq.lm <- function (x, type = 2, anova = FALSE) {

  # file:    etaSquared.R
  # author:  Dan Navarro
  # contact: daniel.navarro@adelaide.edu.au
  # changed: 13 November 2013
  # modified by Daniel Wollschlaeger 17.9.2014

  # etaSquared() calculates eta-squared and partial eta-squared for linear models
  # (usually ANOVAs). It takes an lm object as input and computes the effect size
  # for all terms in the model. By default uses Type II sums of squares to calculate
  # the effect size, but Types I and III are also possible. By default the output
  # only displays the effect size, but if requested it will also print out the full
  # ANOVA table.

  if (!is(anova, "logical") | length(anova) != 1) {
    stop("\"anova\" must be a single logical value")
  }
  if (!is(type, "numeric") | length(type) != 1) {
    stop("type must be equal to 1, 2 or 3")
  }
  if (type == 1) {
    ss <- anova(x)[, "Sum Sq", drop = FALSE]
    ss.res <- ss[dim(ss)[1], ]
    ss.tot <- sum(ss)
    ss <- ss[-dim(ss)[1], , drop = FALSE]
    ss <- as.matrix(ss)
  }
  else {
    if (type == 2) {
      ss.tot <- sum((x$model[, 1] - mean(x$model[, 1]))^2)
      ss.res <- sum((x$residuals)^2)
      terms <- attr(x$terms, "factors")[-1, , drop = FALSE]
      l <- attr(x$terms, "term.labels")
      ss <- matrix(NA, length(l), 1)
      rownames(ss) <- l
      for (i in seq_along(ss)) {
        vars.this.term <- which(terms[, i] != 0)
        dependent.terms <- which(apply(terms[vars.this.term, , drop = FALSE], 2, prod) > 0)
        m0 <- lm(x$terms[-dependent.terms], x$model)
        if (length(dependent.terms) > 1) {
          m1 <- lm(x$terms[-setdiff(dependent.terms, i)], x$model)
          ss[i] <- anova(m0, m1)$`Sum of Sq`[2]
        }
        else {
          ss[i] <- anova(m0, x)$`Sum of Sq`[2]
        }
      }
    }
    else {
      if (type == 3) {
        ## check if model was fitted with sum-to-zero contrasts
        ## necessary for valid SS type 3 (e.g., contr.sum, contr.helmert)
        IVs <- names(attr(model.matrix(x), "contrasts"))
        ## only relevant for more than one factor
        ## (and for unbalanced cell sizes and interactions, not tested here)
        if(length(IVs) > 1) {
          isSumToZero <- function(IV) {
            ## check if factor has directly associated contrasts
            if(!is.null(attr(x$model[, IV], "contrasts"))) {
              cm <- contrasts(x$model[, IV])
              all(colSums(cm) == 0)
            } else {
              ## check attributes from model matrix
              attr(model.matrix(x), "contrasts")[[IV]] %in% c("contr.sum", "contr.helmert")
            }
          }

          valid <- vapply(IVs, isSumToZero, logical(1))

          if(!all(valid)) {
            warning(c(ifelse(sum(!valid) > 1, "Factors ", "Factor "),
                      paste(IVs[!valid], collapse=", "),
                      ifelse(sum(!valid) > 1, " are", " is"),
                      " not associated with sum-to-zero contrasts",
                      " necessary for valid SS type III",
                      " when cell sizes are unbalanced",
                      " and interactions are present.",
                      " Consider re-fitting the model after setting",
                      " options(contrasts=c(\"contr.sum\", \"contr.poly\"))"))
          }
        }

        mod <- drop1(x, scope = x$terms)
        ss <- mod[-1, "Sum of Sq", drop = FALSE]
        ss.res <- mod[1, "RSS"]
        ss.tot <- sum((x$model[, 1] - mean(x$model[, 1]))^2)
        ss <- as.matrix(ss)
      }
      else {
        stop("type must be equal to 1, 2 or 3")
      }
    }
  }
  if (anova == FALSE) {
    eta2 <- ss/ss.tot
    eta2p <- ss/(ss + ss.res)
    E <- cbind(eta2, eta2p)
    rownames(E) <- rownames(ss)
    colnames(E) <- c("eta.sq", "eta.sq.part")
  }
  else {
    ss <- rbind(ss, ss.res)
    eta2 <- ss/ss.tot
    eta2p <- ss/(ss + ss.res)
    k <- length(ss)
    eta2p[k] <- NA
    df <- anova(x)[, "Df"]
    ms <- ss/df
    Fval <- ms/ms[k]
    p <- 1 - pf(Fval, df, rep.int(df[k], k))
    E <- cbind(eta2, eta2p, ss, df, ms, Fval, p)
    E[k, 6:7] <- NA
    colnames(E) <- c("eta.sq", "eta.sq.part", "SS", "df", "MS", "F", "p")
    rownames(E) <- rownames(ss)
    rownames(E)[k] <- "Residuals"
  }
  return(E)
}


EtaSq.aovlist <-  function (x, type = 2, anova = FALSE) {

    # author:  Daniel Wollschlaeger
    # contact: contact@dwoll.de
    # changed: 13 October 2014

    # EtaSq.aovlist() calculates partial eta-squared and generalized eta-squared
    # for aovlists

    if (!is(anova, "logical") | length(anova) != 1) {
      stop("\"anova\" must be a single logical value")
    }
    if (!is(type, "numeric") | length(type) != 1) {
      stop("type must be equal to 1, 2 or 3")
    }

    ## alternative: check design has balanced cell sizes
    if (type != 1) {
      stop("type must be equal to 1")
    }

    details <- aovlDetails(x)
    ss      <- details$Sum.Sq             # effect SS
    ss.res  <- sum(aovlErrorTerms(x)$SS)  # total error SS
    ss.tot  <- sum(ss) + sum(ss.res)

    # eta squared
    eta2 <- ss / ss.tot

    # partial eta squared
    # cf. Bakeman, R. (2005) Behavior Research Methods. 37(3), 379-384. Tables 1, 2
    eta2p <- ss / (ss + details$SSE)

    # generalized eta squared
    # if all factors are manipulated
    # cf. Bakeman, R. (2005) Behavior Research Methods. 37(3), 379-384. Tables 1, 2
    geta2 <- ss / (ss + sum(ss.res))

    if (anova == FALSE) {
      E <- cbind(eta2, eta2p, geta2)
      rownames(E) <- details$tt
      colnames(E) <- c("eta.sq", "eta.sq.part", "eta.sq.gen")
    } else {
      E <- data.frame(eta2=eta2,
                      eta2p=eta2p,
                      geta2=geta2,
                      ss=ss,
                      df=details$Df,
                      ms=details$Mean.Sq,
                      sse=details$SSE,
                      dfe=details$dfE,
                      Fval=details$F.value,
                      p=details$Pr..F.)
      colnames(E) <- c("eta.sq", "eta.sq.part", "eta.sq.gen", "SS", "df", "MS", "SSE", "dfE", "F", "p")
      rownames(E) <- details$tt
    }
    return(E)
  }

# author:  Daniel Wollschlaeger
aovlDetails <- function(aovObj) {
  aovSum  <- summary(aovObj)
  etNames <- names(aovSum)  # error terms

  getOneRes <- function(tt, tab) {  # tab=anova table, tt = tested term
    ttIdx <- which(DescTools::StrTrim(rownames(tab)) == tt)
    list(df=tab[ttIdx,       "Df"],
         SS=tab[ttIdx,       "Sum Sq"],
         MS=tab[ttIdx,       "Mean Sq"],
         dfE=tab["Residuals", "Df"],
         SSE=tab["Residuals", "Sum Sq"],
         MSE=tab["Residuals", "Mean Sq"],
         F=tab[ttIdx, "F value"],
         p=tab[ttIdx, "Pr(>F)"])
  }

  getTermRes <- function(et) { # et = error term
    tab <- aovSum[[et]][[1]]
    at  <- DescTools::StrTrim(rownames(tab)) # all terms
    tt  <- at[-which(at == "Residuals")]     # tested terms only

    if(length(tt) > 0)
    {
      # error terms
      etRes <- list(df=tab["Residuals", "Df"],
                    SS=tab["Residuals", "Sum Sq"],
                    MS=tab["Residuals", "Mean Sq"])
      ttRes <- lapply(tt, getOneRes, tab=tab)
      ttRes <- setNames(ttRes, tt)
      ttIdx <- which(DescTools::StrTrim(rownames(tab)) %in% tt)
      return(data.frame(tt=tt, et=et,
                        tab[ttIdx, , drop=FALSE],
                        dfE=etRes$df, SSE=etRes$SS, MSE=etRes$MS,
                        stringsAsFactors=FALSE))
    } else {
      emptyDf <- data.frame(matrix(ncol=10, nrow=0))
      return(setNames(emptyDf, c("tt", "et", "Df", "Sum.Sq", "Mean.Sq", "F.value",
                                 "Pr..F.", "dfE", "SSE", "MSE")))
    }
  }

  detailsL  <- setNames(lapply(etNames, getTermRes), etNames)
  detailsDf <- do.call("rbind", detailsL)
  rownames(detailsDf) <- NULL
  return(detailsDf)
}

aovlErrorTerms <- function(aovObj) {
  aovSum  <- summary(aovObj)
  etNames <- names(aovSum)
  getSS <- function(x) {
    aovSum[[x]][[1]]["Residuals", "Sum Sq"]
  }

  getMS <- function(x) {
    aovSum[[x]][[1]]["Residuals", "Mean Sq"]
  }

  getDF <- function(x) {
    aovSum[[x]][[1]]["Residuals", "Df"]
  }

  SS <- vapply(etNames, getSS, numeric(1))
  MS <- vapply(etNames, getMS, numeric(1))
  DF <- vapply(etNames, getDF, numeric(1))
  return(list(SS=SS, MS=MS, DF=DF))
}

# # RB-p
# N      <- 10
# P      <- 4
# id     <- factor(rep(1:N, times=P))
# IV     <- factor(rep(1:P,  each=N))
# DV_t1  <- round(rnorm(N, -0.3, 1), 2)
# DV_t2  <- round(rnorm(N, -0.2, 1), 2)
# DV_t3  <- round(rnorm(N,  0.1, 1), 2)
# DV_t4  <- round(rnorm(N,  0.4, 1), 2)
# DV     <- c(DV_t1, DV_t2, DV_t3, DV_t4)
# dfRBpL <- data.frame(id, IV, DV)
# rbp <- aov(DV ~ IV + Error(id/IV), data=dfRBpL)
# EtaSq(rbp)
#
# ez::ezANOVA(data=dfRBpL, wid=id, dv=DV, within=.(IV))

# # RBF-pq
# N        <- 10
# P        <- 2
# Q        <- 3
# id       <- factor(rep(1:N,              times=P*Q))
# IV1      <- factor(rep(rep(1:P, each=N), times=Q))
# IV2      <- factor(rep(rep(1:Q,           each=N*P)))
# DV_t11   <- round(rnorm(N, -0.8, 1), 2)
# DV_t12   <- round(rnorm(N, -0.7, 1), 2)
# DV_t13   <- round(rnorm(N,  0.0, 1), 2)
# DV_t21   <- round(rnorm(N,  0.2, 1), 2)
# DV_t22   <- round(rnorm(N,  0.3, 1), 2)
# DV_t23   <- round(rnorm(N,  1.0, 1), 2)
# DV       <- c(DV_t11, DV_t21, DV_t12, DV_t22, DV_t13, DV_t23)
# dfRBFpqL <- data.frame(id, IV1, IV2, DV)
# rbfpq <- aov(DV ~ IV1*IV2 + Error(id/(IV1*IV2)), data=dfRBFpqL)
# EtaSq(rbfpq)
#
# ez::ezANOVA(data=dfRBFpqL, wid=id, dv=DV, within=.(IV1, IV2))
#
# # SPF-p.q
# Nj       <- 10
# P        <- 3
# Q        <- 3
# id       <- factor(rep(1:(P*Nj),     times=Q))
# IVbtw    <- factor(rep(LETTERS[1:P], times=Q*Nj))
# IVwth    <- factor(rep(1:Q,           each=P*Nj))
# DV_t1    <- round(rnorm(P*Nj, -0.5, 1), 2)
# DV_t2    <- round(rnorm(P*Nj,  0,   1), 2)
# DV_t3    <- round(rnorm(P*Nj,  0.5, 1), 2)
# DV       <- c(DV_t1, DV_t2, DV_t3)
# dfSPFpqL <- data.frame(id, IVbtw, IVwth, DV)
# spfp.q <- aov(DV ~ IVbtw*IVwth + Error(id/IVwth), data=dfSPFpqL)
# EtaSq(spfp.q)
#
# ez::ezANOVA(data=dfSPFpqL, wid=id, dv=DV, within=.(IVwth), between=.(IVbtw))
#
# ##### SPF-p.qr
# Nj     <- 10
# P      <- 2
# Q      <- 3
# R      <- 2
# id     <- factor(rep(1:(P*Nj),            times=Q*R))
# IVbtw  <- factor(rep(LETTERS[1:P],        times=Q*R*Nj))
# IVwth1 <- factor(rep(1:Q,                  each=P*R*Nj))
# IVwth2 <- factor(rep(rep(1:R, each=P*Nj), times=Q))
# DV_t11 <- round(rnorm(P*Nj,  8, 2), 2)
# DV_t21 <- round(rnorm(P*Nj, 13, 2), 2)
# DV_t31 <- round(rnorm(P*Nj, 13, 2), 2)
# DV_t12 <- round(rnorm(P*Nj, 10, 2), 2)
# DV_t22 <- round(rnorm(P*Nj, 15, 2), 2)
# DV_t32 <- round(rnorm(P*Nj, 15, 2), 2)
# DV     <- c(DV_t11, DV_t12, DV_t21, DV_t22, DV_t31, DV_t32)
# dfSPFp.qrL <- data.frame(id, IVbtw, IVwth1, IVwth2, DV)
#
# spfp.qr <- aov(DV ~ IVbtw*IVwth1*IVwth2 + Error(id/(IVwth1*IVwth2)), data=dfSPFp.qrL)
# EtaSq(spfp.qr)
#
# ez::ezANOVA(data=dfSPFp.qrL, wid=id, dv=DV, within=.(IVwth1,IVwth2), between=.(IVbtw))
#
# ##### SPF-pq.r
# Njk    <- 20
# P      <- 2
# Q      <- 2
# R      <- 3
# id     <- factor(rep(1:(P*Q*Njk),          times=R))
# IVbtw1 <- factor(rep(1:P,                  times=Q*R*Njk))
# IVbtw2 <- factor(rep(rep(1:Q, each=P*Njk), times=R))
# IVwth  <- factor(rep(1:R,                   each=P*Q*Njk))
# DV_t1  <- round(rnorm(P*Q*Njk, -3, 2), 2)
# DV_t2  <- round(rnorm(P*Q*Njk,  1, 2), 2)
# DV_t3  <- round(rnorm(P*Q*Njk,  2, 2), 2)
# DV     <- c(DV_t1, DV_t2, DV_t3)
# dfSPFpq.rL <- data.frame(id, IVbtw1, IVbtw2, IVwth, DV)
#
# spfpq.r <- aov(DV ~ IVbtw1*IVbtw2*IVwth + Error(id/IVwth), data=dfSPFpq.rL)
# EtaSq(spfpq.r)
#
# ez::ezANOVA(data=dfSPFpq.rL, wid=id, dv=DV, within=.(IVwth), between=.(IVbtw1,IVbtw2))


# EtaSq <- function (x, type = 2, anova = FALSE) {
#
#   # file:    etaSquared.R
#   # author:  Dan Navarro
#   # contact: daniel.navarro@adelaide.edu.au
#   # changed: 13 November 2013
#   # modified by Daniel Wollschlaeger 17.9.2014
#
#
#   # etaSquared() calculates eta-squared and partial eta-squared for linear models
#   # (usually ANOVAs). It takes an lm object as input and computes the effect size
#   # for all terms in the model. By default uses Type II sums of squares to calculate
#   # the effect size, but Types I and III are also possible. By default the output
#   # only displays the effect size, but if requested it will also print out the full
#   # ANOVA table.
#
#
#   if (!is(anova, "logical") | length(anova) != 1) {
#     stop("\"anova\" must be a single logical value")
#   }
#   if (!is(x, "lm")) {
#     stop("\"x\" must be a linear model object")
#   }
#   if (!is(type, "numeric") | length(type) != 1) {
#     stop("type must be equal to 1, 2 or 3")
#   }
#   if (type == 1) {
#     ss <- anova(x)[, "Sum Sq", drop = FALSE]
#     ss.res <- ss[dim(ss)[1], ]
#     ss.tot <- sum(ss)
#     ss <- ss[-dim(ss)[1], , drop = FALSE]
#     ss <- as.matrix(ss)
#   }
#   else {
#     if (type == 2) {
#       ss.tot <- sum((x$model[, 1] - mean(x$model[, 1]))^2)
#       ss.res <- sum((x$residuals)^2)
#       terms <- attr(x$terms, "factors")[-1, , drop = FALSE]
#       l <- attr(x$terms, "term.labels")
#       ss <- matrix(NA, length(l), 1)
#       rownames(ss) <- l
#       for (i in seq_along(ss)) {
#         vars.this.term <- which(terms[, i] != 0)
#         dependent.terms <- which(apply(terms[vars.this.term, , drop = FALSE], 2, prod) > 0)
#         m0 <- lm(x$terms[-dependent.terms], x$model)
#         if (length(dependent.terms) > 1) {
#           m1 <- lm(x$terms[-setdiff(dependent.terms, i)], x$model)
#           ss[i] <- anova(m0, m1)$`Sum of Sq`[2]
#         }
#         else {
#           ss[i] <- anova(m0, x)$`Sum of Sq`[2]
#         }
#       }
#     }
#     else {
#       if (type == 3) {
#         ## check if model was fitted with sum-to-zero contrasts
#         ## necessary for valid SS type 3 (e.g., contr.sum, contr.helmert)
#         IVs <- names(attr(model.matrix(x), "contrasts"))
#         ## only relevant for more than one factor
#         ## (and for unbalanced cell sizes and interactions, not tested here)
#         if(length(IVs) > 1) {
#           isSumToZero <- function(IV) {
#             ## check if factor has directly associated contrasts
#             if(!is.null(attr(x$model[, IV], "contrasts"))) {
#               cm <- contrasts(x$model[, IV])
#               all(colSums(cm) == 0)
#             } else {
#               ## check attributes from model matrix
#               attr(model.matrix(x), "contrasts")[[IV]] %in% c("contr.sum", "contr.helmert")
#             }
#           }
#
#           valid <- vapply(IVs, isSumToZero, logical(1))
#
#           if(!all(valid)) {
#             warning(c(ifelse(sum(!valid) > 1, "Factors ", "Factor "),
#                       paste(IVs[!valid], collapse=", "),
#                       ifelse(sum(!valid) > 1, " are", " is"),
#                       " not associated with sum-to-zero contrasts",
#                       " necessary for valid SS type III",
#                       " when cell sizes are unbalanced",
#                       " and interactions are present.",
#                       " Consider re-fitting the model after setting",
#                       " options(contrasts=c(\"contr.sum\", \"contr.poly\"))"))
#           }
#         }
#
#         mod <- drop1(x, scope = x$terms)
#         ss <- mod[-1, "Sum of Sq", drop = FALSE]
#         ss.res <- mod[1, "RSS"]
#         ss.tot <- sum((x$model[, 1] - mean(x$model[, 1]))^2)
#         ss <- as.matrix(ss)
#       }
#       else {
#         stop("type must be equal to 1, 2 or 3")
#       }
#     }
#   }
#   if (anova == FALSE) {
#     eta2 <- ss/ss.tot
#     eta2p <- ss/(ss + ss.res)
#     E <- cbind(eta2, eta2p)
#     rownames(E) <- rownames(ss)
#     colnames(E) <- c("eta.sq", "eta.sq.part")
#   }
#   else {
#     ss <- rbind(ss, ss.res)
#     eta2 <- ss/ss.tot
#     eta2p <- ss/(ss + ss.res)
#     k <- length(ss)
#     eta2p[k] <- NA
#     df <- anova(x)[, "Df"]
#     ms <- ss/df
#     Fval <- ms/ms[k]
#     p <- 1 - pf(Fval, df, rep.int(df[k], k))
#     E <- cbind(eta2, eta2p, ss, df, ms, Fval, p)
#     E[k, 6:7] <- NA
#     colnames(E) <- c("eta.sq", "eta.sq.part", "SS", "df", "MS", "F", "p")
#     rownames(E) <- rownames(ss)
#     rownames(E)[k] <- "Residuals"
#   }
#   return(E)
# }



Eps <- function(S, p, g, n) {

  ## Purpose: calculates the Greenhouse-Geisser and Huynh-Feldt epsilons
  ## -------------------------------------------------------------------
  ## Arguments: S pxp covariance matrix
  ##            p dimension of observation vectors
  ##            g number of groups
  ##            n number of subjects

  ## Lit:    E.F. Vonesh + V.M. Chinchilli (1997), p.84-86
  ##         M.J. Crowder and D.J. Hand (1990), p.54-55

  ## Author: H.-R. Roth
  ## Date:   23.07.2002
  ## -------------------------------------------------------------------

  # U is a matrix of (p-1) orthonormal contrasts
  U <- t(cbind(diag(p-1),0) - outer(1:(p-1), 1:p, "<") / ((p-1):1))
  a <- 1/sqrt(colSums(U^2))
  U <- U%*%diag(a)
  V <- t(U) %*% S %*% U
  e <- (sum(diag(V)))^2/sum(diag(V%*%V))/(p-1)

  GGepsilon <- e
  HFepsilon <- min(1, (n*(p-1)*e - 2) / ((p-1)* (n-g-(p-1)*e) ))
  t.output <- c(GGepsilon, HFepsilon)
  names(t.output)  <- c("G-G-epsilon", "H-F-epsilon")
  t.output

}



power.chisq.test <- function (n = NULL, w = NULL, df = NULL, sig.level = 0.05, power = NULL) {

  if (sum(sapply(list(w, n, df, power, sig.level), is.null)) != 1)
    stop("exactly one of w, n, df, power or sig.level must be NULL")
  if (!is.null(w) && w < 0)
    stop("w must be positive")
  if (!is.null(n) && n < 1)
    stop("number of observations must be at least 1")
  if (!is.null(sig.level) && !is.numeric(sig.level) || any(0 > sig.level | sig.level > 1))
    stop(sQuote("sig.level"), " must be numeric in [0, 1]")
  if (!is.null(power) && !is.numeric(power) || any(0 > power | power > 1))
    stop(sQuote("power"), " must be numeric in [0, 1]")
  p.body <- quote({
    k <- qchisq(sig.level, df = df, lower = FALSE)
    pchisq(k, df = df, ncp = n * w^2, lower = FALSE)
  })
  if (is.null(power))
    power <- eval(p.body)
  else if (is.null(w))
    w <- uniroot(function(w) eval(p.body) - power, c(1e-10, 1e+05))$root
  else if (is.null(n))
    n <- uniroot(function(n) eval(p.body) - power, c(1 + 1e-10, 1e+05))$root
  else if (is.null(sig.level))
    sig.level <- uniroot(function(sig.level) eval(p.body) -
                           power, c(1e-10, 1 - 1e-10))$root
  else stop("internal error")

  METHOD <- "Chi squared power calculation"
  NOTE <- "n is the number of observations"
  structure(list(w = w, n = n, df = df, sig.level = sig.level,
                 power = power, method = METHOD, note = NOTE), class = "power.htest")
}




Contrasts <- function (levs) {
  k = length(levs)
  M = data.frame(levs = levs)
  for (i in 1:(k - 1)) {
    for (j in (i + 1):k) {
      con = rep(0, k)
      con[i] = -1
      con[j] = 1
      nm = paste(levs[j], levs[i], sep = "-")
      M[[nm]] = con
    }
  }
  row.names(M) = levs

  return(M[-1])

}


ScheffeTest <- function (x, ...)
  UseMethod("ScheffeTest")

ScheffeTest.default <- function (x, g = NULL, which = NULL, contrasts = NULL, conf.level = 0.95, ...) {
  ScheffeTest(x=aov(x~g), which=which, contrasts=contrasts, conf.level=conf.level, ...)
}



ScheffeTest.aov <- function(x, which=NULL, contrasts = NULL, conf.level=0.95, ...){

  mm <- model.tables(x, "means")
  if (is.null(mm$n))
    stop("no factors in the fitted model")
  tabs <- mm$tables[-1L]

  if(is.null(which)) which <- seq_along(tabs)

  tabs <- tabs[which]
  nn <- mm$n[names(tabs)]
  nn_na <- is.na(nn)
  if (all(nn_na))
    stop("'which' specified no factors")
  if (any(nn_na)) {
    warning("'which' specified some non-factors which will be dropped")
    tabs <- tabs[!nn_na]
    nn <- nn[!nn_na]
  }
  out <- setNames(vector("list", length(tabs)), names(tabs))
  MSE <- sum(x$residuals^2)/x$df.residual

  autoContr <- is.null(contrasts)
  if(!is.null(contrasts)){
    contrasts <- data.frame(contrasts)
  }

  # nm <- "tension"
  for (nm in names(tabs)) {
    tab <- tabs[[nm]]
    means <- as.vector(tab)

    nms <- if (length(d <- dim(tab)) > 1L) {
      dn <- dimnames(tab)
      apply(do.call("expand.grid", dn), 1L, paste, collapse = ":")
    } else names(tab)

    n <- nn[[nm]]
    if (length(n) < length(means))
      n <- rep.int(n, length(means))

    if(autoContr) contrasts <- Contrasts(nms)

    psi <- apply(contrasts * means, 2, sum)
    sscoeff <- apply(contrasts * contrasts / n, 2, sum)
    mspsi <- (psi * psi) / sscoeff

# Korrektur von Daniel Wollschlaeger 9.9.2014:
#     psi <- contrasts %*% means
#     sscoeff <- contrasts * contrasts %*% (1/n)

    dferr <- x$df.residual
    dfgrp <- length(x$residuals) - dferr - 1

    pval <- pf(psi^2/(MSE*sscoeff*dfgrp),
               df1=dfgrp, df2=dferr, lower.tail=FALSE)

    critvalue <- dfgrp * qf(1-conf.level, dfgrp, dferr, lower.tail=FALSE)

    lwr <- psi - sqrt(critvalue) * sqrt(MSE * sscoeff)
    upr <- psi + sqrt(critvalue) * sqrt(MSE * sscoeff)

    out[[nm]] <- cbind(diff=psi, lwr, upr, pval)
    colnames(out[[nm]]) <- c("diff","lwr.ci","upr.ci","pval")

    if(!autoContr) {
      # define contrasts rownames
      rownames(out[[nm]]) <-  apply(contrasts, 2, function(x)
        gettextf("%s-%s", paste(nms[x>0], collapse=","),
                 paste(nms[x<0], collapse=",")) )
      if(is.na(conf.level)) out[[nm]] <- out[[nm]][,-c(2:3)]
    }

    if(autoContr & is.na(conf.level)) {
      out[[nm]] <- matrix(NA, nrow=length(means), ncol=length(means))
      out[[nm]][lower.tri(out[[nm]], diag = FALSE)] <- pval
      dimnames(out[[nm]]) <- list(nms, nms)
      out[[nm]] <- out[[nm]][-1, -ncol(out[[nm]])]
    }

  }

  class(out) <- c("PostHocTest")
  attr(out, "orig.call") <- x$call
  attr(out, "conf.level") <- conf.level
  attr(out, "ordered") <- FALSE
  attr(out, "method") <- "Scheffe Test"
  attr(out, "method.str") <- gettextf("\n  Posthoc multiple comparisons of means : %s \n", attr(out, "method"))


  return(out)

}


PostHocTest <- function (x, ...)
  UseMethod("PostHocTest")



PostHocTest.aov <- function (x, which = NULL,
                         method=c("hsd","bonferroni","lsd","scheffe","newmankeuls","duncan"),
                         conf.level = 0.95, ordered = FALSE, ...) {

  method <- match.arg(method)

  if(method=="scheffe"){
    out <- ScheffeTest(x=x, which=which, conf.level=conf.level, ...)

  } else {

    mm <- model.tables(x, "means")
    if (is.null(mm$n))
      stop("no factors in the fitted model")
    tabs <- mm$tables[-1L]

    if(is.null(which)) which <- seq_along(tabs)
    tabs <- tabs[which]

    nn <- mm$n[names(tabs)]
    nn_na <- is.na(nn)
    if (all(nn_na))
      stop("'which' specified no factors")
    if (any(nn_na)) {
      warning("'which' specified some non-factors which will be dropped")
      tabs <- tabs[!nn_na]
      nn <- nn[!nn_na]
    }
    out <- setNames(vector("list", length(tabs)), names(tabs))
    MSE <- sum(x$residuals^2)/x$df.residual
    for (nm in names(tabs)) {
      tab <- tabs[[nm]]
      means <- as.vector(tab)
      nms <- if (length(d <- dim(tab)) > 1L) {
        dn <- dimnames(tab)
        apply(do.call("expand.grid", dn), 1L, paste, collapse = ":")
      }
      else names(tab)
      n <- nn[[nm]]
      if (length(n) < length(means))
        n <- rep.int(n, length(means))

      # this will be ignored for bonferroni, lsd
      if (method %in% c("hsd", "newmankeuls", "duncan") & as.logical(ordered)) {
        ord <- order(means)
        means <- means[ord]
        n <- n[ord]
        if (!is.null(nms))
          nms <- nms[ord]
      }

      center <- outer(means, means, "-")
      keep <- lower.tri(center)
      center <- center[keep]

      switch(method
             ,"bonferroni" = {
               width <-  qt(1 - (1 - conf.level)/(length(means) * (length(means) - 1)), x$df.residual) *
                 sqrt(MSE * outer(1/n, 1/n, "+"))[keep]
               est <- center/sqrt(MSE * outer(1/n, 1/n, "+")[keep])

               pvals <- pmin(2 * pt(abs(est), df = x$df.residual, lower.tail = FALSE)
                             * ((length(means)^2 - length(means))/2), 1)
               method.str <- "Bonferroni"

             }
             ,"lsd" = {
               width <-  qt(1 - (1 - conf.level)/2, x$df.residual) *
                 sqrt(MSE * outer(1/n, 1/n, "+"))[keep]
               est <- center/sqrt(MSE * outer(1/n, 1/n, "+")[keep])
               pvals <- 2 * pt(abs(est), df = x$df.residual, lower.tail = FALSE)
               method.str <- "Fisher LSD"
             }
             ,"hsd" = {
               width <- qtukey(conf.level, length(means), x$df.residual) *
                 sqrt((MSE/2) * outer(1/n, 1/n, "+"))[keep]
               est <- center/(sqrt((MSE/2) * outer(1/n, 1/n, "+"))[keep])
               pvals <- ptukey(abs(est), length(means), x$df.residual,
                               lower.tail = FALSE)
               method.str <- "Tukey HSD"

             }
             ,"newmankeuls" ={
               nmean <- (abs(outer(rank(means), rank(means), "-")) + 1)[keep]

               width <- qtukey(conf.level, nmean, x$df.residual) *
                 sqrt((MSE/2) * outer(1/n, 1/n, "+"))[keep]

               est <- center/(sqrt((MSE/2) * outer(1/n, 1/n, "+"))[keep])

               pvals <- ptukey(abs(est), nmean, x$df.residual, lower.tail = FALSE)
               method.str <- "Newman-Keuls"

             }
             ,"duncan" = {
               # same as newmankeuls, but with bonferroni corrected alpha
               nmean <- (abs(outer(rank(means), rank(means), "-")) + 1)[keep]

               width <- qtukey(conf.level^(nmean-1), nmean, x$df.residual) *
                 sqrt((MSE/2) * outer(1/n, 1/n, "+"))[keep]

               est <- center/(sqrt((MSE/2) * outer(1/n, 1/n, "+"))[keep])
               pvals <- 1-(1-ptukey(abs(est), nmean, x$df.residual,
                                    lower.tail = FALSE))^(1/(nmean - 1))

               method.str <- "Duncan's new multiple range test"

             }
             ,"dunnett" = {
               method.str <- "Dunnett"
             }
             ,"scottknott" = {
               method.str <- "Scott Knott"
             }
             ,"waller" = {
               method.str <- "Waller"
             }
             ,"gabriel" = {
               method.str <- "Gabriel"
             }
      )

      if(!is.na(conf.level)){
        dnames <- list(NULL, c("diff", "lwr.ci", "upr.ci", "pval"))
        if (!is.null(nms))
          dnames[[1L]] <- outer(nms, nms, paste, sep = "-")[keep]
        out[[nm]] <- array(c(center, center - width,
                             center + width, pvals), c(length(width), 4L), dnames)
      } else {
        out[[nm]] <- matrix(NA, nrow=length(means), ncol=length(means))
        out[[nm]][lower.tri(out[[nm]], diag = FALSE)] <- pvals
        dimnames(out[[nm]]) <- list(nms, nms)
        out[[nm]] <- out[[nm]][-1, -ncol(out[[nm]])]

      }
    }

    class(out) <- c("PostHocTest")
    attr(out, "orig.call") <- x$call
    attr(out, "conf.level") <- conf.level
    attr(out, "ordered") <- ordered
    attr(out, "method") <- method.str
    attr(out, "method.str") <- gettextf("\n  Posthoc multiple comparisons of means : %s \n", attr(out, "method"))

  }

  return(out)

}


PostHocTest.matrix <- function(x, method = c("none","fdr","BH","BY","bonferroni","holm","hochberg","hommel"),
                               conf.level = 0.95, ...) {

  # http://support.sas.com/resources/papers/proceedings14/1544-2014.pdf

  # no conf.level supported so far
  conf.level  <- NA

  method <- match.arg(method)

#  out <- setNames(vector("list", length(tabs)), names(tabs))

  pvals <- DescTools::PairApply(t(as.matrix(x)), FUN = function(y1, y2) chisq.test(cbind(y1,y2))$p.value, symmetric=TRUE)
  pvals[upper.tri(pvals, diag=TRUE)] <- NA

  if(method != "none")
    pvals[] <- p.adjust(pvals, method=method)

#  pvals[] <- format.pval(pvals, digits = 2, na.form = "-")
  pvals <- pvals[-1, -ncol(pvals)]
  out <- list()
  out[[deparse(substitute(x))]] <- pvals

  class(out) <- c("PostHocTest")
  attr(out, "orig.call") <- "table"
  attr(out, "conf.level") <- conf.level
  attr(out, "ordered") <- FALSE
  attr(out, "method") <- method
  attr(out, "method.str") <- gettextf("\n  Posthoc multiple comparisons on chi-square test : %s \n", attr(out, "method"))

  return(out)

}


PostHocTest.table <- function(x, method = c("none","fdr","BH","BY","bonferroni","holm","hochberg","hommel"),
                               conf.level = 0.95, ...) {
  class(x) <- "matrix"
  PostHocTest(x, method=method, conf.level=conf.level, ...)
}



#
# print.PostHocTest <- function(x, ...){
#
#   cat(gettextf("\n  Posthoc multiple comparisons of means : %s \n", attr(x, "method")))
#
#   cat("\nFit: ", deparse(attr(x, "orig.call"), 500L), "\n\n",
#       sep = "")
#
#   for(i in seq_along(x)){
#     cat("$",names(x)[i], "\n", sep="")
#     pp <- format.pval(x[[i]], 2, na.form = "-")
#     attributes(pp) <- attributes(x[[i]])
#     print(pp, quote = FALSE, ...)
#     cat("\n")
#   }
#   cat("\n")
# }



print.PostHocTest <- function (x, digits = getOption("digits"), ...) {

  cat(attr(x, "method.str"))
  if (!is.na(attr(x, "conf.level")))
    cat("    ", format(100 * attr(x, "conf.level"), 2), "% family-wise confidence level\n",
        sep = "")
  if (attr(x, "ordered"))
    cat("    factor levels have been ordered\n")
  if(!is.language(attr(x, "orig.call")) && !is.null(attr(x, "orig.call")))
    cat("\nFit: ", deparse(attr(x, "orig.call"), 500L), "\n\n", sep = "")
  else
    cat("\n")
  xx <- unclass(x)

  attr(xx, "orig.call") <- attr(xx, "conf.level") <-
    attr(xx, "ordered") <-  attr(xx, "method.str") <-  attr(xx, "method") <- NULL

  xx["data.name"] <- NULL

  if(!is.na(attr(x, "conf.level"))) {
    xx <- lapply(xx, as.data.frame)
    for(nm in names(xx)){
      xx[[nm]]$" " <- Format(xx[[nm]]$"pval", fmt="*")
      xx[[nm]]$"pval" <- format.pval(xx[[nm]]$"pval", digits=2, nsmall=4)
    }

    print.default(xx, digits=digits, ...)
    cat("---\nSignif. codes: 0 `***' 0.001 `**' 0.01 `*' 0.05 `.' 0.1 ` ' 1\n")
  } else {
    for(nm in names(xx)){
      xx[[nm]][] <- format.pval(xx[[nm]], 2, na.form = "-")
    }
#     attributes(pp) <- attributes(x$p.value)
    print(xx, digits=digits, quote = FALSE, ...)
  }
  cat("\n")

  invisible(x)
}



plot.PostHocTest <- function(x, ...){
  # original:   stats:::plot.TukeyHSD(x, ...)

  # don't need that here..
  x$data.name <- NULL

  for (i in seq_along(x)) {
    xi <- x[[i]][, -4L, drop = FALSE]
    yvals <- nrow(xi):1L
    dev.hold()
    on.exit(dev.flush())
    plot(c(xi[, "lwr.ci"], xi[, "upr.ci"]), rep.int(yvals, 2L),
         type = "n", axes = FALSE, xlab = "", ylab = "", main = NULL,
         ...)
    axis(1, ...)
    axis(2, at = nrow(xi):1, labels = dimnames(xi)[[1L]],
         srt = 0, ...)
    abline(h = yvals, lty = 1, lwd = 0.5, col = "lightgray")
    abline(v = 0, lty = 2, lwd = 0.5, ...)
    segments(xi[, "lwr.ci"], yvals, xi[, "upr.ci"], yvals, ...)
    segments(as.vector(xi), rep.int(yvals - 0.1, 3L), as.vector(xi),
             rep.int(yvals + 0.1, 3L), ...)
    title(main = paste0(format(100 * attr(x, "conf.level"),
                               digits = 2L), "% family-wise confidence level\n"),
          xlab = paste("Differences in mean levels of", names(x)[i]))
    box()
    dev.flush()
    on.exit()
  }

}



DunnTest <- function (x, ...)
  UseMethod("DunnTest")



DunnTest.formula <- function (formula, data, subset, na.action, ...) {

  if (missing(formula) || (length(formula) != 3L) || (length(attr(terms(formula[-2L]),
                                                                  "term.labels")) != 1L))
    stop("'formula' missing or incorrect")
  m <- match.call(expand.dots = FALSE)
  if (is.matrix(eval(m$data, parent.frame())))
    m$data <- as.data.frame(data)
  m[[1L]] <- quote(stats::model.frame)
  m$... <- NULL
  mf <- eval(m, parent.frame())
  if (length(mf) > 2L)
    stop("'formula' should be of the form response ~ group")
  DNAME <- paste(names(mf), collapse = " by ")
  names(mf) <- NULL
  response <- attr(attr(mf, "terms"), "response")
  y <- DoCall("DunnTest", c(as.list(mf), list(...)))
  y$data.name <- DNAME
  y
}




DunnTest.default <- function (x, g, method = c("holm","hochberg","hommel","bonferroni","BH","BY","fdr","none"),
                              out.list = TRUE, ...) {

  if (is.list(x)) {
    if (length(x) < 2L)
      stop("'x' must be a list with at least 2 elements")
    DNAME <- deparse(substitute(x))
    x <- lapply(x, function(u) u <- u[complete.cases(u)])
    k <- length(x)
    l <- sapply(x, "length")
    if (any(l == 0))
      stop("all groups must contain data")
    g <- factor(rep(1:k, l))
    x <- unlist(x)
  }
  else {
    if (length(x) != length(g))
      stop("'x' and 'g' must have the same length")
    DNAME <- paste(deparse(substitute(x)), "and", deparse(substitute(g)))
    OK <- complete.cases(x, g)
    x <- x[OK]
    g <- g[OK]
    if (!all(is.finite(g)))
      stop("all group levels must be finite")
    g <- factor(g)
    k <- nlevels(g)
    if (k < 2)
      stop("all observations are in the same group")
  }
  N <- length(x)
  if (N < 2)
    stop("not enough observations")

  method <- match.arg(method)

  nms <- levels(g)

  n <- tapply(g, g, length)
  rnk <- rank(x)
  mrnk <- tapply(rnk, g, mean)

  tau <- table(rnk[AllDuplicated(rnk)])
  tiesadj <- sum(tau^3 - tau) / (12*(N-1))
  mrnkdiff <- outer(mrnk, mrnk, "-")

  z <- mrnkdiff / sqrt( ((N*(N+1)/12) - tiesadj) * outer(1/n, 1/n, "+"))
  pvals <- pnorm(abs(z), lower.tail=FALSE)

  keep <- lower.tri(pvals)
  pvals <- pvals[keep]
  m <- sum(keep)

  out <- list()

  pvals <- p.adjust(pvals, method=method)
  method.str <- method

  if(out.list){
    dnames <- list(NULL, c("mean rank diff", "pval"))
    if (!is.null(nms))
      dnames[[1L]] <- outer(nms, nms, paste, sep = "-")[keep]
    out[[1]] <- array(c(mrnkdiff[keep], pvals), c(length(mrnkdiff[keep]), 2L), dnames)

  } else {
    out[[1]] <- matrix(NA, nrow=length(nms), ncol=length(nms))
    out[[1]][lower.tri(out[[1]], diag = FALSE)] <- pvals
    dimnames(out[[1]]) <- list(nms, nms)
    out[[1]] <- out[[1]][-1, -ncol(out[[1]])]

  }

  class(out) <- c("DunnTest")
  attr(out, "main") <- gettextf("Dunn's test of multiple comparisons using rank sums : %s ", method.str)
  attr(out, "method") <- method.str
  attr(out, "out.list") <- out.list

  return(out)

}




print.DunnTest <- function (x, digits = getOption("digits"), ...) {

  cat("\n", attr(x, "main"), "\n\n")
  xx <- unclass(x)

  if(attr(x, "out.list")==TRUE) {
    xx <- data.frame(x[1])
    xx$" " <- Format(xx$"pval", fmt="*")
    xx$"pval" <- format.pval(xx$"pval", digits=2, nsmall=4)

    print.data.frame(xx, digits=digits, ...)
    cat("---\nSignif. codes: 0 `***' 0.001 `**' 0.01 `*' 0.05 `.' 0.1 ` ' 1\n")
  } else {
    xx[[1]][] <- format.pval(xx[[1]], 2, na.form = "-")
    #     attributes(pp) <- attributes(x$p.value)
    print(xx[[1]], digits=digits, quote = FALSE, ...)
  }
  cat("\n")

  invisible(x)
}



# Test  NemenyiTest
#
# d.frm <- data.frame(x=c(28,30,33,35,38,41, 36,39,40,43,45,50, 44,45,47,49,53,54),
#                     g=c(rep(LETTERS[1:3], each=6)))
# NemenyiTest(x~g, d.frm)
#
# library(coin)
# library(multcomp)
# nem <- oneway_test(x ~ g, data=d.frm,
#                    ytrafo = function(data) trafo(data, numeric_trafo=rank),
#                    xtrafo = function(data) trafo(data, factor_trafo = function(x)
#                      model.matrix(~x - 1) %*% t(contrMat(table(x), "Tukey"))),
#                    teststat="max")
# nem
# pvalue(nem, method="single-step")


NemenyiTest <- function (x, ...)
  UseMethod("NemenyiTest")


NemenyiTest.formula <- function (formula, data, subset, na.action, ...) {

  if (missing(formula) || (length(formula) != 3L) || (length(attr(terms(formula[-2L]),
                                                                  "term.labels")) != 1L))
    stop("'formula' missing or incorrect")
  m <- match.call(expand.dots = FALSE)
  if (is.matrix(eval(m$data, parent.frame())))
    m$data <- as.data.frame(data)
  m[[1L]] <- quote(stats::model.frame)
  m$... <- NULL
  mf <- eval(m, parent.frame())
  if (length(mf) > 2L)
    stop("'formula' should be of the form response ~ group")
  DNAME <- paste(names(mf), collapse = " by ")
  names(mf) <- NULL
  response <- attr(attr(mf, "terms"), "response")
  y <- DoCall("NemenyiTest", c(as.list(mf), list(...)))
  y$data.name <- DNAME
  y
}




NemenyiTest.default <- function (x, g,
                                 dist = c("tukey", "chisq"), out.list = TRUE, ...) {

  if (is.list(x)) {
    if (length(x) < 2L)
      stop("'x' must be a list with at least 2 elements")
    DNAME <- deparse(substitute(x))
    x <- lapply(x, function(u) u <- u[complete.cases(u)])
    k <- length(x)
    l <- sapply(x, "length")
    if (any(l == 0))
      stop("all groups must contain data")
    g <- factor(rep(1:k, l))
    x <- unlist(x)
  }
  else {
    if (length(x) != length(g))
      stop("'x' and 'g' must have the same length")
    DNAME <- paste(deparse(substitute(x)), "and", deparse(substitute(g)))
    OK <- complete.cases(x, g)
    x <- x[OK]
    g <- g[OK]
    if (!all(is.finite(g)))
      stop("all group levels must be finite")
    g <- factor(g)
    k <- nlevels(g)
    if (k < 2)
      stop("all observations are in the same group")
  }
  N <- length(x)
  if (N < 2)
    stop("not enough observations")

  dist <- match.arg(dist, c("tukey", "chisq"))

  nms <- levels(g)

  n <- tapply(g, g, length)
  rnk <- rank(x)
  mrnk <- tapply(rnk, g, mean)

  tau <- table(rnk[AllDuplicated(rnk)])
  tiesadj <- min(1, 1 - sum(tau^3 - tau) / (N^3 - N))
  mrnkdiff <- outer(mrnk, mrnk, "-")

  if(dist == "chisq"){
    chi <- mrnkdiff^2 / ((N*(N+1)/12) * outer(1/n, 1/n, "+"))
    pvals <- pchisq(tiesadj * chi, df=k-1, lower.tail=FALSE)
  } else {
    z <- abs(mrnkdiff) / sqrt( (N*(N+1)/12) * outer(1/n, 1/n, "+"))
    pvals <- ptukey(z * sqrt(2), nmeans=k, df=Inf, lower.tail=FALSE)
  }


  keep <- lower.tri(pvals)
  pvals <- pvals[keep]
  m <- sum(keep)

  out <- list()

  # no p.adjustment in this test
  # pvals <- p.adjust(pvals, method=method)
  method.str <- "none" #method

  if(out.list){
    dnames <- list(NULL, c("mean rank diff", "pval"))
    if (!is.null(nms))
      dnames[[1L]] <- outer(nms, nms, paste, sep = "-")[keep]
    out[[1]] <- array(c(mrnkdiff[keep], pvals), c(length(mrnkdiff[keep]), 2L), dnames)

  } else {
    out[[1]] <- matrix(NA, nrow=length(nms), ncol=length(nms))
    out[[1]][lower.tri(out[[1]], diag = FALSE)] <- pvals
    dimnames(out[[1]]) <- list(nms, nms)
    out[[1]] <- out[[1]][-1, -ncol(out[[1]])]

  }

  class(out) <- c("DunnTest")
  attr(out, "main") <- gettextf("Nemenyi's test of multiple comparisons for independent samples (%s) ", dist)
  attr(out, "method") <- method.str
  attr(out, "out.list") <- out.list

  return(out)

}




DunnettTest <- function (x, ...)
  UseMethod("DunnettTest")



DunnettTest.formula <- function (formula, data, subset, na.action, ...) {

  if (missing(formula) || (length(formula) != 3L) || (length(attr(terms(formula[-2L]),
                                                                  "term.labels")) != 1L))
    stop("'formula' missing or incorrect")
  m <- match.call(expand.dots = FALSE)
  if (is.matrix(eval(m$data, parent.frame())))
    m$data <- as.data.frame(data)
  m[[1L]] <- quote(stats::model.frame)
  m$... <- NULL
  mf <- eval(m, parent.frame())
  if (length(mf) > 2L)
    stop("'formula' should be of the form response ~ group")
  DNAME <- paste(names(mf), collapse = " by ")
  names(mf) <- NULL
  response <- attr(attr(mf, "terms"), "response")
  y <- DoCall("DunnettTest", c(as.list(mf), list(...)))
  y$data.name <- DNAME
  y
}



DunnettTest.default <- function (x, g, control = NULL
                                  , conf.level = 0.95, ...) {

  if (is.list(x)) {
    if (length(x) < 2L)
      stop("'x' must be a list with at least 2 elements")
    DNAME <- deparse(substitute(x))
    x <- lapply(x, function(u) u <- u[complete.cases(u)])
    k <- length(x)
    l <- sapply(x, "length")
    if (any(l == 0))
      stop("all groups must contain data")
    g <- factor(rep(1:k, l))
    x <- unlist(x)
  } else {
    if (length(x) != length(g))
      stop("'x' and 'g' must have the same length")
    DNAME <- paste(deparse(substitute(x)), "and", deparse(substitute(g)))
    OK <- complete.cases(x, g)
    x <- x[OK]
    g <- g[OK]
    if (!all(is.finite(g)))
      stop("all group levels must be finite")
    g <- factor(g)
    k <- nlevels(g)
    if (k < 2)
      stop("all observations are in the same group")
  }
  N <- length(x)
  if (N < 2)
    stop("not enough observations")

  # just organisational stuff so far, got a fine x and g now

  if (is.null(control)) control <- levels(g)[1]

  ctrls <- control
  out <- list()

  for(ii in seq_along(ctrls)){

    control <- ctrls[ii]

    ni <- tapply(x, g, length)

    means <- tapply(x, g, mean)
    meandiffs <- means[names(means) != control] - means[control]

    fittedn <- ni[names(ni) != control]
    controln <- ni[control]

    s <- sqrt( sum(tapply(x, g, function(x) sum((x - mean(x))^2) )) /
                 (N - k))

    Dj <- meandiffs / (s * sqrt((1/fittedn) + (1/controln)))
    Rij <- sqrt(fittedn/(fittedn + controln))

    R <- outer(Rij, Rij, "*")
    diag(R) <- 1

    set.seed(5)  # for getting consistent results every run
    qvt <- mvtnorm::qmvt((1 - (1 - conf.level)/2), df = N - k, sigma = R, tail = "lower.tail")$quantile

    lower <- meandiffs - s * sqrt((1/fittedn) + (1/controln)) * qvt
    upper <- meandiffs + s * sqrt((1/fittedn) + (1/controln)) * qvt

    pval <- c()
    for (i in 1:(k-1)){
      pval[i] <- 1 - mvtnorm::pmvt(-abs(Dj[i]), abs(Dj[i]), corr=R, delta=rep(0, k-1), df=N - k)[1]
    }

    out[[ii]] <- cbind(diff=meandiffs, lower, upper, pval)
    dimnames(out[[ii]]) <- list(paste(names(meandiffs), control, sep="-"), c("diff", "lwr.ci", "upr.ci","pval"))
  }

  names(out) <- ctrls

  class(out) <- c("PostHocTest")
#  attr(out, "orig.call") <- NA
  attr(out, "conf.level") <- conf.level
  attr(out, "ordered") <- FALSE
  attr(out, "method") <- ""
  attr(out, "method.str") <- gettextf("\n  Dunnett's test for comparing several treatments with a control : %s \n", attr(out, "method"))

  return(out)

}




HotellingsT2Test <- function(x,...) {
  UseMethod("HotellingsT2Test")
}

HotellingsT2Test.default <- function(x, y=NULL, mu=NULL, test="f",...) {


  `HotellingsT.internal`  <-  function(x, y=NULL, mu, test) {
    n <- dim(x)[1]
    p <- dim(x)[2]

    if(is.null(y))     #one sample case
    {
      test.statistic <- n*as.numeric(t(colMeans(x)-mu)%*%solve(cov(x))%*%(colMeans(x)-mu))*switch(test,f=(n-p)/(p*(n-1)),chi=1)
      df.1 <- p
      df.2 <- switch(test,f=n-p,chi=NA)
      p.value <- 1-switch(test,f=pf(test.statistic,df.1,df.2),chi=pchisq(test.statistic,df.1))
      return(list(test.statistic=test.statistic,p.value=p.value,df.1=df.1,df.2=df.2))
    }

    # else two sample case
    n1 <- n
    n2 <- dim(y)[1]
    xmeans <- colMeans(x)
    ymeans <- colMeans(y)
    x.diff <- sweep(x,2,xmeans)
    y.diff <- sweep(y,2,ymeans)
    S.pooled <- 1/(n1+n2-2)*(t(x.diff)%*%x.diff+t(y.diff)%*%y.diff)
    test.statistic <- n1*n2/(n1+n2)*t(xmeans-ymeans-mu)%*%solve(S.pooled)%*%(xmeans-ymeans-mu)*switch(test,f=(n1+n2-p-1)/(p*(n1+n2-2)),chi=1)
    df.1 <- p
    df.2 <- switch(test,f=n1+n2-p-1,chi=NA)
    p.value <- 1-switch(test,f=pf(test.statistic,df.1,df.2),chi=pchisq(test.statistic,df.1))
    list(test.statistic=test.statistic,p.value=p.value,df.1=df.1,df.2=df.2)
  }


  if (is.null(y)) {
    DNAME <- deparse(substitute(x))
  } else {
    DNAME=paste(deparse(substitute(x)),"and",deparse(substitute(y)))
  }

  xok <- complete.cases(x)
  x <- x[xok,]
  if(!all(sapply(x, is.numeric))) stop("'x' must be numeric")
  x <- as.matrix(x)

  p <- dim(x)[2]

  if (!is.null(y)) {
    yok <- complete.cases(y)
    y <- y[yok,]

    if(!all(sapply(y, is.numeric))) stop("'y' must be numeric")
    if (p!=dim(y)[2]) stop("'x' and 'y' must have the same number of columns")
    y <- as.matrix(y)
  }

  if (is.null(mu)) mu <- rep(0,p)
  else if (length(mu)!=p) stop("length of 'mu' must equal the number of columns of 'x'")

  test <- match.arg(test,c("f","chi"))

  if (is.null(y) & test=="f") version <- "one.sample.f"
  if (is.null(y) & test=="chi") version <- "one.sample.chi"
  if (!is.null(y) & test=="f") version <- "two.sample.f"
  if (!is.null(y) & test=="chi") version <- "two.sample.chi"

  res1 <- switch(version,
                 "one.sample.f"={
                   result <- HotellingsT.internal(x,mu=mu,test=test)
                   STATISTIC <- result$test.statistic
                   names(STATISTIC) <- "T.2"
                   PVAL <- result$p.value
                   METHOD <- "Hotelling's one sample T2-test"
                   PARAMETER <- c(result$df.1,result$df.2)
                   names(PARAMETER) <- c("df1","df2")
                   RVAL <- list(statistic=STATISTIC,p.value=PVAL,method=METHOD,parameter=PARAMETER)

                   RVAL}
                 ,
                 "one.sample.chi"={
                   result <- HotellingsT.internal(x,mu=mu,test=test)
                   STATISTIC <- result$test.statistic
                   names(STATISTIC) <- "T.2"
                   PVAL <- result$p.value
                   METHOD <- "Hotelling's one sample T2-test"
                   PARAMETER <- c(result$df.1)
                   names(PARAMETER) <- c("df")
                   RVAL <- list(statistic=STATISTIC,p.value=PVAL,method=METHOD,parameter=PARAMETER)

                   RVAL}
                 ,
                 "two.sample.f"={
                   result <- HotellingsT.internal(x,y,mu,test)
                   STATISTIC <- result$test.statistic
                   names(STATISTIC) <- "T.2"
                   PVAL <- result$p.value
                   METHOD <- "Hotelling's two sample T2-test"
                   PARAMETER <- c(result$df.1,result$df.2)
                   names(PARAMETER) <- c("df1","df2")
                   RVAL <- list(statistic=STATISTIC,p.value=PVAL,method=METHOD,parameter=PARAMETER)

                   RVAL}
                 ,
                 "two.sample.chi"={
                   result <- HotellingsT.internal(x,y,mu,test)
                   STATISTIC <- result$test.statistic
                   names(STATISTIC) <- "T.2"
                   PVAL <- result$p.value
                   METHOD <- "Hotelling's two sample T2-test"
                   PARAMETER <- c(result$df.1)
                   names(PARAMETER) <- c("df")
                   RVAL <- list(statistic=STATISTIC,p.value=PVAL,method=METHOD,parameter=PARAMETER)

                   RVAL}
  )
  ALTERNATIVE="two.sided"
  NVAL <- paste("c(",paste(mu,collapse=","),")",sep="")
  if (is.null(y)) names(NVAL) <- "location" else names(NVAL) <- "location difference"
  res <- c(res1,list(data.name=DNAME,alternative=ALTERNATIVE,null.value=NVAL))
  class(res) <- "htest"
  return(res)
}


HotellingsT2Test.formula <- function (formula, data, subset, na.action, ...) {

  if (missing(formula) || (length(formula) != 3L) || (length(attr(terms(formula[-2L]),
                                                                  "term.labels")) != 1L))
    stop("'formula' missing or incorrect")
  m <- match.call(expand.dots = FALSE)
  if (is.matrix(eval(m$data, parent.frame())))
    m$data <- as.data.frame(data)
  m[[1L]] <- quote(stats::model.frame)
  m$... <- NULL
  mf <- eval(m, parent.frame())
  DNAME <- paste(names(mf), collapse = " by ")
  names(mf) <- NULL
  response <- attr(attr(mf, "terms"), "response")
  g <- factor(mf[[-response]])
  if (nlevels(g) != 2L)
    stop("grouping factor must have exactly 2 levels")
  # DATA <- setNames(split(mf[[response]], g), c("x", "y"))
  DATA <- setNames(split(as.data.frame(mf[[response]]), g), c("x", "y"))

  y <- DoCall("HotellingsT2Test", c(DATA, list(...)))
  y$data.name <- DNAME
  y
}


###


## basic finance functions  ---------------

NPV <- function(i, cf, t=seq(along=cf)-1) {
  # Net present value
  sum(cf/(1+i)^t)
}


IRR <- function(cf, t=seq(along=cf)-1) {
  # internal rate of return
  uniroot(NPV, c(0,1), cf=cf, t=t)$root
}


OPR <- function (K, D = NULL, log = FALSE) {

  # Einperiodenrenditen One-period-returns
  if (is.null(D))
    D <- rep(0, length(K))
  if (!log){
    res <- (D[-1] + K[-1] - K[-length(K)])/K[-length(K)]
  } else {
    res <- log((D[-1] + K[-1])/K[-length(K)])
  }

  return(res)

}


## utils: manipulation, utilities ====


Exec <- function(x) {
  # execute a command in a string, just as reminder
  eval(parse(text=x))
}



InDots <- function(..., arg, default){

  # was arg in the dots-args? parse dots.arguments
  arg <- unlist(match.call(expand.dots=FALSE)$...[arg])

  # if arg was not in ... then return default
  if(is.null(arg)) arg <- default

  return(arg)

}



FctArgs <- function(name, sort=FALSE) {

  # got that somewhere, but don't know from where...

  if(is.function(name)) name <- as.character(substitute(name))
  a <- formals(get(name, pos=1))
  if(is.null(a))
    return(NULL)
  arg.labels <- names(a)
  arg.values <- as.character(a)
  char <- sapply(a, is.character)
  arg.values[char] <- paste("\"", arg.values[char], "\"", sep="")

  if(sort)
  {
    ord <- order(arg.labels)
    if(any(arg.labels == "..."))
      ord <- c(ord[-which(arg.labels[ord]=="...")],
               which(arg.labels=="..."))
    arg.labels <- arg.labels[ord]
    arg.values <- arg.values[ord]
  }

  output <- data.frame(value=I(arg.values), row.names=arg.labels)
  print(output, right=FALSE)

  invisible(output)
}





Keywords <- function( topic ) {

  # verbatim from library(gtools)

  file <- file.path(R.home("doc"),"KEYWORDS")
  if(missing(topic))
  {
    file.show(file)
  } else {

#     ## Local copy of trim.character to avoid cyclic dependency with gdata ##
#     trim <-  function(s) {
#
#       s <- sub(pattern="^[[:blank:]]+", replacement="", x=s)
#       s <- sub(pattern="[[:blank:]]+$", replacement="", x=s)
#       s
#     }

    kw <- scan(file=file, what=character(), sep="\n", quiet=TRUE)
    kw <- grep("&", kw, value=TRUE)
    kw <- gsub("&[^&]*$","", kw)
    kw <- gsub("&+"," ", kw)
    kw <- na.omit(StrTrim(kw))

    ischar <- tryCatch(is.character(topic) && length(topic) ==
                         1L, error = identity)
    if (inherits(ischar, "error"))
      ischar <- FALSE
    if (!ischar)
      topic <- deparse(substitute(topic))

    item <- paste("^",topic,"$", sep="")

    # old, replaced by suggestion of K. Hornik 23.2.2015
    # topics <- function(k) help.search(keyword=k)$matches[,"topic"]

    topics <- function(k) {
      matches <- help.search(keyword=k)$matches
      matches[ , match("topic", tolower(colnames(matches)))]
    }

    matches <- lapply(kw, topics)
    names(matches) <- kw

    tmp <- unlist(lapply( matches, function(m) grep(item, m, value=TRUE) ))
    names(tmp)
  }
}


SysInfo <- function() {

  ## description <<  getSysinfo is a convenience function to compile some information about the
  ##                 computing system and environment used.

  package.names <- sapply(sessionInfo()[['otherPkgs']],'[[','Package')
  package.versions <- sapply(sessionInfo()[['otherPkgs']],'[[','Version')
  packages.all <- paste(gettextf("%s (%s)", package.names, package.versions), collapse=", ")

  pars.sys <- c('user', 'nodename', 'sysname', 'release')
  R.system <- paste(sessionInfo()[[1]]$version.string)

  sys.info <- paste(pars.sys, Sys.info()[pars.sys], collapse=', ', sep=': ')
  all.info <- paste(c(sys.info,', ', R.system,', installed Packages: ', packages.all),
                    sep='', collapse='')

  cat(gettextf("\nSystem: %s\nNodename: %s, User: %s",
               paste(Sys.info()[c("sysname","release","version")], collapse=" ")
               , Sys.info()["nodename"], Sys.info()["user"], "\n\n"))
  cat(gettextf("\nTotal Memory: %s MB\n\n", memory.limit()))
  cat(StrTrim(sessionInfo()$R.version$version.string), "\n")
  cat(sessionInfo()$platform, "\n")
  cat("\nLoaded Packages: \n", packages.all, "\n")

  DescToolsOptions()

  invisible(all.info)

}



DescToolsOptions <- function(default=FALSE){

  fmtToTxt <- function(x){
    # form a text with format options
    if(is.null(getOption(x))){
      txt <- "NULL (default)"
    } else {
      txt <- paste(capture.output(dput(getOption(x))), collapse="\n                    ")
    }
    return(txt)
  }

    if(default) { options("footnote1"=NULL)
                options("footnote2"=NULL)
                options("plotit"=NULL)
                options("col1"=NULL)
                options("col2"=NULL)
                options("col3"=NULL)
                options("fixedfont"=NULL)
                options("fixedfontsize"=NULL)
                options("fmt.abs"=NULL)
                options("fmt.per"=NULL)
                options("fmt.num"=NULL)
  }

  cat(gettextf("\nCurrently defined DescTools options:
  footnote1     = %s
  footnote2     = %s
  plotit        = %s
  col1          = %s
  col2          = %s
  col3          = %s
  fixedfont     = %s
  fixedfontsize = %s
  fmt.abs       = %s
  fmt.per       = %s
  fmt.num       = %s \n\n"
  , getOption("footnote1", "' (default)")
  , getOption("footnote2", '" (default)')
  , getOption("plotit", "FALSE (default)")
  , getOption("col1", "hblue (default)")
  , getOption("col2", "hred (default)")
  , getOption("col3", "horange (default)")
  , getOption("fixedfont", "Consolas (default)")
  , getOption("fixedfontsize", "7 (default)")
  , fmtToTxt("fmt.abs")
  , fmtToTxt("fmt.per")
  , fmtToTxt("fmt.num")
  ))

}



ParseSASDatalines <- function(x, env = .GlobalEnv, overwrite = FALSE) {

  # see: http://www.psychstatistics.com/2012/12/07/using-datalines-in-sas/
  # or:  http://www.ats.ucla.edu/stat/sas/library/SASRead_os.htm

  # split command to list by means of ;
  lst <- StrTrim(strsplit(x, ";")[[1]])
  dsname <- lst[grep(pattern = "^[Dd][Aa][Tt][Aa] ", StrTrim(lst))]   # this would be the dataname
  dsname <- gsub(pattern = "^[Dd][Aa][Tt][Aa] +", "", dsname)

  # get the columnnames from the input line
  input <- lst[grep(pattern = "^[Ii][Nn][Pp][Uu][Tt]", StrTrim(lst))]
  # get rid of potential single @
  input <- gsub("[ \n\t]@+[ \n\t]*", "", input)
  input <- gsub(pattern=" +\\$", "$", input)
  input <- gsub(" +", " ", input)
  cnames <- strsplit(input, " ")[[1]][-1]

  # the default values for the variables
  def <- rep(0, length(cnames))
  def[grep("\\$$", cnames)] <- "''"
  vars <- paste(gsub("\\$$","",cnames), def, sep="=", collapse=",")

  datalines <- lst[grep("datalines", tolower(lst))+1]

  res <- eval(parse(text=gettextf(
    "data.frame(scan(file=textConnection(datalines),
    what=list(%s), quiet=TRUE))", vars)))

  if(length(dsname) > 0){ # check if a dataname could be found
    if( overwrite | ! exists(dsname, envir=env) ) {
      assign(dsname, res, envir=env)
    } else {
      stop(gettextf("%s already exists in %s. Use overwrite = TRUE to overwrite it.", dsname, deparse(substitute(env))))
    }
  }
  return(res)

}


SetRowNames <- function (object = nm, nm) {
  rownames(object) <- nm
  object
}

SetColNames <- function (object = nm, nm) {
  colnames(object) <- nm
  object
}


Rename <- function(x, ..., gsub=FALSE, fixed=TRUE, warn=TRUE){

  subst <- c(...)
  if(gsub){
    names.x <- names(x)
    for(i in 1:length(subst)){
      names.x <- gsub(names(subst[i]),subst[i],names.x,fixed=fixed)
    }
    names(x) <- names.x
  }
  else {
    i <- match(names(subst),names(x))
    if(any(is.na(i))) {
      if(warn) warning("unused name(s) selected")
      if(any(!is.na(i)))
        subst <- subst[!is.na(i)]
      i <- i[!is.na(i)]
    }
    if(length(i))
      names(x)[i] <- subst
  }
  return(x)
}


# This does not work, because x does not come as a reference

# AddLabel <- function(x, text = ""){
  # ### add an attribute named "label" to a variable in a data.frame
  # attr(x, "label") <- text
# }

# attr(d.pizza$driver, "label") <- "The driver delivering the pizza"
# AddLabel(d.pizza$driver, "lkj?lkjlkjlk?lkj lkj lkj lkadflkj alskd lkas")



# simplified from Hmisc

"Label<-" <- function(x, ..., value) UseMethod("Label<-")

"Label<-.default" <- function(x, ..., value) {
  if(is.list(value))  stop("cannot assign a list to be a object label")
  if((length(value) != 1L) & !is.null(value)) stop("value must be character vector of length 1")

  attr(x, "label") <- value
  return(x)
}

"Label<-.data.frame" <- function(x, self=TRUE, ..., value) {
  if(!is.data.frame(x))  stop("x must be a data.frame")

  if(self){
    attr(x, "label") <- value
  } else {
    for (i in seq(along.with=x)) {
      Label(x[[i]]) <- value[[i]]
    }
  }
  return(x)
}


Label <- function(x, default=NULL, ...) UseMethod("Label")

Label.default <- function(x, ...) {
  attributes(x)$label
}

Label.data.frame <- function(x, ...) {
  labels <- mapply(FUN=Label, x=x)
  return(labels[unlist(lapply(labels, function(x) !is.null(x) ))])
}

SetLabel <- function (object = nm, nm) {
  Label(object) <- nm
  object
}



Sort <- function(x, ...) {
  UseMethod("Sort")
}

Sort.default <- function(x, ...) {
  sort(x = x, ...)
}

Sort.data.frame <- function(x, ord = NULL, decreasing = FALSE, factorsAsCharacter = TRUE,
                            na.last = TRUE, ...) {

  # why not using ord argument as in matrix and table instead of ord?

  if(is.null(ord)) { ord <- 1:ncol(x) }

  if(is.character(ord)) {
    ord <- match(ord, c("row.names", names(x)))
  } else if(is.numeric(ord)) {
    ord <- as.integer(ord) + 1
  }

  # recycle decreasing and by
  lgp <- list(decreasing = decreasing, ord = ord)
  # recycle all params to maxdim = max(unlist(lapply(lgp, length)))
  lgp <- lapply(lgp, rep, length.out = max(unlist(lapply(lgp, length))))
  # decreasing is not recycled in order, so we use rev to change the sorting direction
  # old: d.ord <- x[,lgp$ord, drop=FALSE]  # preserve data.frame with drop = FALSE
  d.ord <- data.frame(rn=rownames(x),x)[, lgp$ord, drop = FALSE] # preserve data.frame with drop = FALSE
  if(factorsAsCharacter){
    for( xn in which(sapply(d.ord, is.factor)) ){ d.ord[,xn] <- factor(d.ord[,xn], levels=sort(levels(d.ord[,xn]))) }
  }

  d.ord[, which(sapply(d.ord, is.character))] <- lapply(d.ord[,which(sapply(d.ord, is.character)), drop=FALSE], factor)
  d.ord <- data.frame(lapply(d.ord, as.numeric))
  d.ord[lgp$decreasing] <- lapply(d.ord[lgp$decreasing], "-")

  x[ do.call("order", c(as.list(d.ord), na.last=na.last)), , drop = FALSE]
}



Sort.matrix <- function (x, ord = NULL, decreasing = FALSE, na.last = TRUE, ...) {

  if (length(dim(x)) == 1 ){
    # do not specially handle 1-dimensional matrices
    res <- sort(x=x, decreasing=decreasing)

  } else {
    if (is.null(ord)) {
      # default order by sequence of columns
      ord <- 1:ncol(x)
    }

    # replace keyword by code
    ord[ord=="row_names"] <- 0
    # we have to coerce, as ord will be character if row_names is used
    ord <- as.numeric(ord)

    lgp <- list(decreasing = decreasing, ord = ord)
    lgp <- lapply(lgp, rep, length.out = max(unlist(lapply(lgp, length))))

    if( is.null(row.names(x))) {
      d.x <- data.frame(cbind(rownr=1:nrow(x)), x)
    } else {
      d.x <- data.frame(cbind( rownr=as.numeric(factor(row.names(x))), x))
    }
    d.ord <- d.x[, lgp$ord + 1, drop = FALSE]
    d.ord[lgp$decreasing] <- lapply(d.ord[lgp$decreasing], "-")

    res <- x[do.call("order", c(as.list(d.ord), na.last=na.last)), , drop=FALSE]
    # old version cannot be used for [n,1]-matrices, we switch to reset dim
    # class(res) <- "matrix"
    # 19.9.2013: dim kills rownames, so stick to drop = FALSE
    # dim(res) <- dim(x)
  }

  return(res)

}


Sort.table <- function (x, ord = NULL, decreasing = FALSE, na.last = TRUE, ...) {

  if (length(dim(x)) == 1 ){
    # do not specially handle 1-dimensional tables
    res <- sort(x=x, decreasing=decreasing)

  } else {
    if (is.null(ord)) {
      ord <- 1:ncol(x)
    }
    lgp <- list(decreasing = decreasing, ord = ord)
    lgp <- lapply(lgp, rep, length.out = max(unlist(lapply(lgp, length))))

    d.x <- data.frame(cbind( rownr=as.numeric(factor(row.names(x))), x, mar=apply(x, 1, sum)))
    d.ord <- d.x[, lgp$ord + 1, drop = FALSE]
    d.ord[lgp$decreasing] <- lapply(d.ord[lgp$decreasing], "-")

    res <- x[do.call("order", c(as.list(d.ord), na.last=na.last)), , drop=FALSE]
    class(res) <- "table"
  }

  return(res)

}



Rev <- function(x, ...) {
  # additional interface for rev...
  UseMethod("Rev")
}

Rev.default <- function(x, ...){
  rev(x)
}

Rev.table <- function(x, margin, ...) {

  if (!is.array(x))
    stop("'x' is not an array")

  newdim <- rep("", length(dim(x)))
  newdim[margin] <- paste(dim(x), ":1", sep="")[margin]
  z <- eval(parse(text=gettextf("x[%s]", paste(newdim, sep="", collapse=","))))
  class(z) <- oldClass(x)
  return(z)

}

Rev.matrix <- function(x, margin, ...) {
  Rev.table(x, margin, ...)
}


Rev.data.frame <- function(x, margin, ...) {

    if(1 %in% margin) x <- x[nrow(x):1L,]
    if(2 %in% margin) x <- x[, ncol(x):1L]
    return(x)
  }




Untable <- function(x, ...){
  UseMethod("Untable")
}


Untable.data.frame <- function(x, freq = "Freq", rownames = NULL, ...){

  if(all(is.na(match(freq, names(x)))))
    stop(gettextf("Frequency column %s does not exist!", freq))

  res <- x[Untable(x[,freq], type="as.numeric")[,], -grep(freq, names(x))]
  rownames(res) <- rownames

  return(res)
}



Untable.default <- function(x, dimnames=NULL, type = NULL, rownames = NULL, colnames = NULL, ...) {

  # recreates the data.frame out of a contingency table

  # coerce to table, such as also be able to handle vectors
  x <- as.table(x)
  if(!is.null(dimnames)) dimnames(x) <- dimnames
  if(is.null(dimnames) && identical(type, "as.numeric")) dimnames(x) <- list(seq_along(x))
  # set a title for the table if it does not have one

  # if(is.null(names(dimnames(x)))) names(dimnames(x)) <- ""
  # if(length(dim(x))==1 && names(dimnames(x))=="") names(dimnames(x)) <- "Var1"
  # replaced 26.3.2013
  for( i in 1:length(dimnames(x)) )
    if (is.null(names(dimnames(x)[i])) || names(dimnames(x)[i]) == "")
      if (length(dimnames(x)) == 1) names(dimnames(x)) <- gettextf("Var%s", i)
      else names(dimnames(x)[i]) <- gettextf("Var%s", i)

  res <- as.data.frame(expand.grid(dimnames(x))[rep(1:prod(dim(x)), as.vector(x)),])
  rownames(res) <- NULL
  if(!all(names(dimnames(x))=="")) colnames(res) <- names(dimnames(x))

  # return ordered factors, if wanted...
  if(is.null(type)) type <- "as.factor"
  # recycle type:
  if(length(type) < ncol(res)) type <- rep(type, length.out=ncol(res))

  for(i in 1:ncol(res)){
    if(type[i]=="as.numeric"){
      res[,i] <- as.numeric(as.character(res[,i]))
    } else {
      res[,i] <- eval(parse(text = gettextf("%s(res[,i])", type[i])))
    }
  }

  # overwrite the dimnames, if requested
  if(!is.null(rownames)) rownames(res) <- rownames
  if(!is.null(colnames)) colnames(res) <- colnames

  return(res)
}



FixToTab <- function(txt, sep = " ", delim = "\t", trim = TRUE, header = TRUE){

  # converts a fixed text to a delim separated table

  m <- do.call("rbind", strsplit(txt, ""))

  idx <- apply( m, 2, function(x) all(x == sep))
  # replace all multiple delims by just one
  idx[-1][(apply(cbind(idx[-1], idx[-length(idx)]), 1, sum) == 2)] <- FALSE
  m[,idx] <- delim
  tab <- apply( m, 1, paste, collapse="")

  # trim the columns
  if(trim) {
    tab <- do.call("rbind", lapply(strsplit(tab, delim), StrTrim))
  } else {
    tab <- do.call("rbind", strsplit(tab, delim))
  }

  if(header) {
    colnames(tab) <- tab[1,]
    tab <- tab[-1,]
  }

  return(tab)

}


ClipToVect <- function(doubleQuote = TRUE){

  # vectorizes the clipboard content

  x <- read.table("clipboard", sep="\t")

  if(!all(sapply(x, is.numeric))){
    if(doubleQuote)x <- sapply(x, dQuote)
    else x <- sapply(x, sQuote)
  }

  res <- paste(apply(x, 2, function(x) paste("c(", paste(x, collapse=",") , ")", sep="")), collapse=",\n")


  cat(res)
  invisible(res)

}

###


## GUI-Elements: select variables by dialog, FileOpen, DescDlg, ObjectBrowse ====


SaveAsDlg <- function(x, filename){
  if(missing(filename))
    filename <- file.choose()
  if(! is.na(filename)) save(list=deparse(substitute(x)), file = filename)
  else
    warning("No filename supplied")
}



SelectVarDlg <- function (x, ...) {

  # if x is NA then let the user select a data.frame
  # if(missing(x)){
    # x <- select.list( ls(envir=.GlobalEnv)[ lapply( lapply(ls(envir=.GlobalEnv), function(x) gettextf("class(%s)", x)),
       # function(x) eval(parse(text=x))) == "data.frame" ] , multiple=FALSE)
    # SelectVarDlg.data.frame(x=x, ...)
  # } else {
    UseMethod("SelectVarDlg")

}


.writeCB <- function (dat, ...) {

  sn <- Sys.info()["sysname"]
  if (sn == "Darwin") {
    file <- pipe("pbcopy")
    cat(dat, file = file, ...)
    close(file)
  }
  else if (sn == "Windows") {
    cat(dat, file = "clipboard", ...)
  }
  else {
    stop("Writing to the clipboard is not implemented for your system (",
         sn, ") in this package.")
  }
}


SelectVarDlg.default <- function(x, useIndex = FALSE, ...){

    # example: Sel(d.pizza)
    op <- options(useFancyQuotes = FALSE)
    xsel <- select.list(x, multiple = TRUE, graphics = TRUE)
    if(useIndex == TRUE) {
      xsel <- which(x %in% xsel)
    } else {
      xsel <- dQuote(xsel)
    }
    txt <- paste("c(", paste(xsel, collapse=","),")", sep="")

    # utils::writeClipboard(txt)
    .writeCB(txt)
    options(op)

    invisible(txt)
}


SelectVarDlg.factor <- function(x, ...) { SelectVarDlg.default( x = levels(x), ...) }

SelectVarDlg.data.frame <- function(x, ...) {
  txt <- paste( deparse(substitute(x)), "[,", SelectVarDlg.default( x = colnames(x), ...), "]", sep="", collapse="")
#  utils::writeClipboard(txt)
  .writeCB(txt)

  invisible(txt)
}




ImportDlg <- function(fmt=1) {
  # read.table text:
  if(fmt == 1) {
    fmt <- "\"%path%%fname%.%fxt%\""
  } else { if( fmt ==2) {
    fmt="d.%fname% <- read.table(file = \"%path%%fname%.%fxt%\", header = TRUE, sep = \";\", na.strings = c(\"NA\",\"NULL\"), strip.white = TRUE)"
  }}

  fn <- file.choose()
  # fn <- tcltk::tclvalue(tcltk::tkgetOpenFile())

  op <- options(useFancyQuotes = FALSE)
  # switch from backslash to slash
  fn <- gsub("\\\\", "/", fn)

  # parse the filename into path, filename, filextension
  fnamelong <- rev(unlist(strsplit(fn, "/")))[1]
  fxt <- rev(unlist(strsplit( fnamelong, "\\.")))[1]
  fname <- substr(fnamelong, 1, nchar(fnamelong) - nchar(fxt) - 1)
  path <- substr(fn, 1, nchar(fn) - nchar(fname) - nchar(fxt) - 1)

  rcmd <- gsub("%fname%", fname, gsub("%fxt%", fxt, gsub( "%path%", path, fmt)))

  # utils::writeClipboard(rcmd)
  .writeCB(rcmd)

  options(op)

  invisible(rcmd)

}


.InitDlg <- function(width, height, x=NULL, y=NULL, resizex=FALSE, resizey=FALSE, main="Dialog", ico="R"){

  top <- tcltk::tktoplevel()

  if(is.null(x)) x <- as.integer(tcltk::tkwinfo("screenwidth", top))/2 - 50
  if(is.null(y)) y <- as.integer(tcltk::tkwinfo("screenheight", top))/2 - 25
  geom <- gettextf("%sx%s+%s+%s", width, height, x, y)
  tcltk::tkwm.geometry(top, geom)
  tcltk::tkwm.title(top, main)
  tcltk::tkwm.resizable(top, resizex, resizey)
  tcltk::tkwm.iconbitmap(top, file.path(find.package("DescTools"), "extdata", paste(ico, "ico", sep=".")))

  return(top)

}


.ImportSPSS <- function(datasetname = "dataset") {
# read.spss
# function (file, use.value.labels = TRUE, to.data.frame = FALSE,
#           max.value.labels = Inf, trim.factor.names = FALSE, trim_values = TRUE,
#           reencode = NA, use.missings = to.data.frame)
  e1 <- environment()
  env.dsname <- character()
  env.use.value.labels <- logical()
  env.to.data.frame <- logical()
  env.max.value.labels <- character()
  env.trim.factor.names <- logical()
  env.trim.values <- logical()
  env.reencode <- character()
  env.use.missings <- logical()
  lst <- NULL

  OnOK <- function() {
    assign("lst", list(), envir = e1)
    assign("env.dsname", tcltk::tclvalue(dsname), envir = e1)
    assign("env.use.value.labels", tcltk::tclvalue(use.value.labels), envir = e1)
    assign("env.to.data.frame", tcltk::tclvalue(to.data.frame), envir = e1)
    assign("env.max.value.labels", tcltk::tclvalue(max.value.labels), envir = e1)
    assign("env.trim.factor.names", tcltk::tclvalue(trim.factor.names), envir = e1)
    assign("env.trim.values", tcltk::tclvalue(trim.values), envir = e1)
    assign("env.reencode", tcltk::tclvalue(reencode), envir = e1)
    assign("env.use.missings", tcltk::tclvalue(use.missings), envir = e1)
    tcltk::tkdestroy(top)
  }

  top <- .InitDlg(350, 300, main="Import SPSS Dataset")

  dsname <- tcltk::tclVar(datasetname)
  dsnameFrame <- tcltk::tkframe(top, padx = 10, pady = 10)
  entryDsname <- tcltk::ttkentry(dsnameFrame, width=30, textvariable=dsname)

  optionsFrame <- tcltk::tkframe(top, padx = 10, pady = 10)

  use.value.labels <- tcltk::tclVar("1")
  use.value.labelsCheckBox <- tcltk::ttkcheckbutton(optionsFrame, text="Use value labels", variable=use.value.labels)

  to.data.frame <- tcltk::tclVar("1")
  to.data.frameCheckBox <- tcltk::ttkcheckbutton(optionsFrame,
                                            text="Convert value labels to factor levels", variable=to.data.frame)
  max.value.labels <- tcltk::tclVar("Inf")
  entryMaxValueLabels <- tcltk::ttkentry(optionsFrame, width=30, textvariable=max.value.labels)

  trim.values <- tcltk::tclVar("1")
  trim.valuesCheckBox <- tcltk::ttkcheckbutton(optionsFrame, text="Ignore trailing spaces when matching"
                                         , variable=trim.values)
  trim.factor.names <- tcltk::tclVar("1")
  trim.factor.namesCheckBox <- tcltk::ttkcheckbutton(optionsFrame, text="Trim trailing spaces from factor levels"
                                               , variable=trim.factor.names)
  reencode <- tcltk::tclVar("")
  entryReencode <- tcltk::ttkentry(optionsFrame, width=30, textvariable=reencode)

  use.missings <- tcltk::tclVar("1")
  use.missingsCheckBox <- tcltk::ttkcheckbutton(optionsFrame, text="Use missings",
                                                variable=use.missings)

  tcltk::tkgrid(tcltk::tklabel(dsnameFrame, text="Enter name for data set:  "), entryDsname, sticky="w")
  tcltk::tkgrid(dsnameFrame, columnspan=2, sticky="w")
  tcltk::tkgrid(use.value.labelsCheckBox, sticky="w")
  tcltk::tkgrid(to.data.frameCheckBox, sticky="nw")
  tcltk::tkgrid(tcltk::ttklabel(optionsFrame, text="Maximal value label:"), sticky="nw")
  tcltk::tkgrid(entryMaxValueLabels, padx=20, sticky="nw")
  tcltk::tkgrid(trim.valuesCheckBox, sticky="w")
  tcltk::tkgrid(trim.factor.namesCheckBox, sticky="w")
  tcltk::tkgrid(tcltk::ttklabel(optionsFrame, text="Reencode character strings to the current locale:"), sticky="nw")
  tcltk::tkgrid(entryReencode, padx=20, sticky="nw")
  tcltk::tkgrid(use.missingsCheckBox, sticky="w")
  tcltk::tkgrid(optionsFrame, sticky="w")

  buttonsFrame <- tcltk::tkframe(top, padx = 10, pady = 10)
  tfButOK <- tcltk::tkbutton(buttonsFrame, text = "OK", command = OnOK, width=10)
  tfButCanc <- tcltk::tkbutton(buttonsFrame, width=10, text = "Cancel", command = function() tcltk::tkdestroy(top))

  tcltk::tkgrid(tfButOK, tfButCanc)
  tcltk::tkgrid.configure(tfButCanc, padx=c(6,6))
  tcltk::tkgrid.columnconfigure(buttonsFrame, 0, weight=2)
  tcltk::tkgrid.columnconfigure(buttonsFrame, 1, weight=1)

  tcltk::tkgrid(buttonsFrame, sticky="ew")
  tcltk::tkwait.window(top)

  if(!is.null(lst)){
    lst <- list(dsname=env.dsname, use.value.labels=as.numeric(env.use.value.labels),
                to.data.frame=as.numeric(env.to.data.frame),
                max.value.labels=env.max.value.labels, trim.factor.names=as.numeric(env.trim.factor.names),
                trim.values=as.numeric(env.trim.values), reencode=env.reencode, use.missings=as.numeric(env.use.missings)  )
  }
  return(lst)

}


.ImportSYSTAT <- function(datasetname = "dataset") {

  e1 <- environment()
  env.dsname <- character()
  env.to.data.frame <- logical()
  lst <- NULL

  top <- .InitDlg(350, 140, main="Import SYSTAT Dataset")

  OnOK <- function() {
    assign("lst", list(), envir = e1)
    assign("env.dsname", tcltk::tclvalue(dsname), envir = e1)
    assign("env.to.data.frame", tcltk::tclvalue(to.data.frame ), envir = e1)
    tcltk::tkdestroy(top)
  }

  dsname <- tcltk::tclVar(datasetname)
  dsnameFrame <- tcltk::tkframe(top, padx = 10, pady = 10)
  entryDsname <- tcltk::ttkentry(dsnameFrame, width=30, textvariable=dsname)

  optionsFrame <- tcltk::tkframe(top, padx = 10, pady = 10)
  to.data.frame <- tcltk::tclVar("1")
  to.data.frameCheckBox <- tcltk::ttkcheckbutton(optionsFrame,
                                            text="Convert dataset to data.frame", variable=to.data.frame)

  tcltk::tkgrid(tcltk::tklabel(dsnameFrame, text="Enter name for data set:  "), entryDsname, sticky="w")
  tcltk::tkgrid(dsnameFrame, columnspan=2, sticky="w")
  tcltk::tkgrid(to.data.frameCheckBox, sticky="w")
  tcltk::tkgrid(optionsFrame, sticky="w")

  buttonsFrame <- tcltk::tkframe(top, padx = 10, pady = 10)
  tfButOK <- tcltk::tkbutton(buttonsFrame, text = "OK", command = OnOK, width=10)
  tfButCanc <- tcltk::tkbutton(buttonsFrame, width=10, text = "Cancel", command = function() tcltk::tkdestroy(top))

  tcltk::tkgrid(tfButOK, tfButCanc)
  tcltk::tkgrid.configure(tfButCanc, padx=c(6,6))
  tcltk::tkgrid.columnconfigure(buttonsFrame, 0, weight=2)
  tcltk::tkgrid.columnconfigure(buttonsFrame, 1, weight=1)

  tcltk::tkgrid(buttonsFrame, sticky="ew")
  tcltk::tkwait.window(top)

  if(!is.null(lst)){
    lst <- list(dsname=env.dsname, to.data.frame=as.numeric(env.to.data.frame))
  }
  return(lst)

}



.ImportStataDlg <- function(datasetname = "dataset") {

#   function (file, convert.dates = TRUE, convert.factors = TRUE,
#             missing.type = FALSE, convert.underscore = FALSE, warn.missing.labels = TRUE)

  e1 <- environment()
  env.dsname <- character()
  env.convert.dates <- logical()
  env.convert.factors <- logical()
  env.convert.underscore <- logical()
  env.missing.type <- logical()
  env.warn.missing.labels <- logical()
  lst <- NULL

  OnOK <- function() {
    assign("lst", list(), envir = e1)
    assign("env.dsname", tcltk::tclvalue(dsname), envir = e1)
    assign("env.convert.dates", tcltk::tclvalue(convert.dates), envir = e1)
    assign("env.convert.factors", tcltk::tclvalue(convert.factors), envir = e1)
    assign("env.convert.underscore", tcltk::tclvalue(convert.underscore), envir = e1)
    assign("env.missing.type", tcltk::tclvalue(missing.type), envir = e1)
    assign("env.warn.missing.labels", tcltk::tclvalue(warn.missing.labels), envir = e1)
    tcltk::tkdestroy(top)
  }

  top <- .InitDlg(350, 220, main="Import Stata Dataset")

  dsname <- tcltk::tclVar(datasetname)
  dsnameFrame <- tcltk::tkframe(top, padx = 10, pady = 10)
  entryDsname <- tcltk::ttkentry(dsnameFrame, width=30, textvariable=dsname)

  optionsFrame <- tcltk::tkframe(top, padx = 10, pady = 10)

  convert.factors <- tcltk::tclVar("1")
  convert.factorsCheckBox <- tcltk::ttkcheckbutton(optionsFrame,
                                     text="Convert value labels to factor levels", variable=convert.factors)
  convert.dates <- tcltk::tclVar("1")
  convert.datesCheckBox <- tcltk::ttkcheckbutton(optionsFrame, text="Convert dates to R format", variable=convert.dates)

  missing.type <- tcltk::tclVar("1")
  missing.typeCheckBox <- tcltk::ttkcheckbutton(optionsFrame, text="Multiple missing types (>=Stata 8)"
                                          , variable=missing.type)
  convert.underscore <- tcltk::tclVar("1")
  convert.underscoreCheckBox <- tcltk::ttkcheckbutton(optionsFrame, text="Convert underscore to period"
                                                , variable=convert.underscore)
  warn.missing.labels <- tcltk::tclVar("1")
  warn.missing.labelsCheckBox <- tcltk::ttkcheckbutton(optionsFrame, text="Warn on missing labels",
                                                variable=warn.missing.labels)

  tcltk::tkgrid(tcltk::tklabel(dsnameFrame, text="Enter name for data set:  "), entryDsname, sticky="w")
  tcltk::tkgrid(dsnameFrame, columnspan=2, sticky="w")
  tcltk::tkgrid(convert.datesCheckBox, sticky="w")
  tcltk::tkgrid(convert.factorsCheckBox, sticky="nw")
  tcltk::tkgrid(missing.typeCheckBox, sticky="w")
  tcltk::tkgrid(convert.underscoreCheckBox, sticky="w")
  tcltk::tkgrid(warn.missing.labelsCheckBox, sticky="w")
  tcltk::tkgrid(optionsFrame, sticky="w")

  buttonsFrame <- tcltk::tkframe(top, padx = 10, pady = 10)
  tfButOK <- tcltk::tkbutton(buttonsFrame, text = "OK", command = OnOK, width=10)
  tfButCanc <- tcltk::tkbutton(buttonsFrame, width=10, text = "Cancel", command = function() tcltk::tkdestroy(top))

  tcltk::tkgrid(tfButOK, tfButCanc)
  tcltk::tkgrid.configure(tfButCanc, padx=c(6,6))
  tcltk::tkgrid.columnconfigure(buttonsFrame, 0, weight=2)
  tcltk::tkgrid.columnconfigure(buttonsFrame, 1, weight=1)

  tcltk::tkgrid(buttonsFrame, sticky="ew")
  tcltk::tkwait.window(top)

  if(!is.null(lst)){
    lst <- list(dsname=env.dsname, convert.factors=as.numeric(env.convert.factors),
                convert.dates=as.numeric(env.convert.dates), convert.underscore=as.numeric(env.convert.underscore),
                missing.type=as.numeric(env.missing.type), warn.missing.labels=as.numeric(env.warn.missing.labels)  )
  }
  return(lst)

}


ImportFileDlg <- function(auto_type = TRUE, env = .GlobalEnv)  {

  requireNamespace("tcltk", quietly = FALSE)

  filename <- tcltk::tclvalue(tcltk::tkgetOpenFile(filetypes= "{{All files} *}
     {{SPSS Files} {.sav}} {{SAS xport files} {.xpt, .xport}}
     {{SYSTAT} {*.sys, *.syd}} {{MiniTab} {.mtp}}
     {{Stata Files} {.dta}}"))

  # nicht topmost, aber wie mach ich das dann??
  # tcl("wm", "attributes", root, topmost=TRUE)

  if (filename=="") return

  path <- SplitPath(filename)

  fformats <- c("SPSS","SAS","SYSTAT", "Minitab","Stata")

  if(auto_type){
    xsel <- switch(toupper(path$extension),
                   "SAV"="SPSS",
                   "DTA"="Stata",
                   "SYD"="SYSTAT",
                   "SYS"="SYSTAT",
                   "MTP"="MiniTab",
                   "XPT"="SAS",
                   "XPORT"="SAS",
                   "SAS"="SAS",
                   select.list(fformats, multiple = FALSE, graphics = TRUE))
  } else {
    xsel <- select.list(fformats, multiple = FALSE, graphics = TRUE)
  }

  switch(xsel,
         "MiniTab"={
           zz <- foreign::read.mtp(file=filename)
         },
         "SYSTAT"={
           dlg <- .ImportSYSTAT(paste("d.", path$filename, sep=""))
           if(is.null(dlg)) return()
           zz <- foreign::read.systat(file=filename, to.data.frame = dlg$to.data.frame)
         },
         "SPSS"={
           dlg <- .ImportSPSS(paste("d.", path$filename, sep=""))
           if(is.null(dlg)) return()
           zz <- foreign::read.spss(file=filename, use.value.labels = dlg$use.value.labels,
                           to.data.frame = dlg$to.data.frame,
                           max.value.labels = dlg$max.value.labels,
                           trim.factor.names = dlg$trim.factor.names,
                           trim_values = dlg$trim_value,
                           reencode = ifelse(dlg$reencode=="", NA, dlg$reencode),
                           use.missings = dlg$use.missings)
         },
         "SAS"={
           print("not yet implemented.")
         },
         "Stata"={
           dlg <- .ImportStataDlg(paste("d.", path$filename, sep=""))
           if(is.null(dlg)) return()
           zz <- foreign::read.dta(file=filename, convert.dates = dlg[["convert.dates"]], convert.factors = dlg[["convert.factors"]],
                                   missing.type = dlg[["missing.type"]], convert.underscore = dlg[["convert.underscore"]],
                                   warn.missing.labels = dlg[["warn.missing.labels"]])
         })
  assign(dlg[["dsname"]], zz, envir=env)
  message(gettextf("Dataset %s has been successfully created!\n\n", dlg[["dsname"]]))
  # Exec(gettextf("print(str(%s, envir = %s))", dlg[["dsname"]],  deparse(substitute(env))))
}



PasswordDlg <- function() {

  requireNamespace("tcltk", quietly = FALSE)

  e1 = environment()
  pw = character()

  tfpw <- tcltk::tclVar("")

  OnOK <- function() {
    assign("pw", tcltk::tclvalue(tfpw), envir = e1)
    tcltk::tkdestroy(root)
  }

  # do not update screen
  tcltk::tclServiceMode(on = FALSE)
  # create window
  root <- .InitDlg(205, 110, resizex=FALSE, resizey=FALSE, main="Login", ico="key")

  # define widgets
  content = tcltk::tkframe(root, padx=10, pady=10)
  tfEntrPW = tcltk::tkentry(content, width="30", textvariable=tfpw, show="*" )
  tfButOK = tcltk::tkbutton(content,text="OK",command=OnOK, width=6)
  tfButCanc = tcltk::tkbutton(content, text="Cancel", width=7, command=function() tcltk::tkdestroy(root))

  # build GUI
  tcltk::tkgrid(content, column=0, row=0)
  tcltk::tkgrid(tcltk::tklabel(content, text="Enter Password"), column=0, row=0, columnspan=3, sticky="w")
  tcltk::tkgrid(tfEntrPW, column=0, row=1, columnspan=3, pady=10)
  tcltk::tkgrid(tfButOK, column=0, row=2, ipadx=15, sticky="w")
  tcltk::tkgrid(tfButCanc, column=2, row=2, ipadx=5, sticky="e")

  # binding event-handler
  tcltk::tkbind(tfEntrPW, "<Return>", OnOK)

  tcltk::tkfocus(tfEntrPW)
  tcltk::tclServiceMode(on = TRUE)

  tcltk::tcl("wm", "attributes", root, topmost=TRUE)

  tcltk::tkwait.window(root)

  return(pw)

}



ChooseColorDlg <- function() {
  requireNamespace("tcltk", quietly = FALSE)
  return(as.character(tcltk::tcl("tk_chooseColor", title="Choose a color")))
}



IdentifyA <- function(formula, data, subset, poly = FALSE){

  opt <- options(na.action=na.pass); on.exit(options(opt))

  # identifies points in a plot, lying in a rectangle, spanned by upleft, botright
  mf <- match.call(expand.dots = FALSE)
  m <- match(c("formula", "data", "na.action", "subset"), names(mf), 0L)
  mf <- mf[c(1L, m)]
  mf$drop.unused.levels <- TRUE
  mf[[1L]] <- as.name("model.frame")
  mf <- eval(mf, parent.frame())
  response <- attr(attr(mf, "terms"), "response")
  x <- mf[[-response]]
  y <- mf[[response]]

  vname <- attr(attr(attr(mf, "terms"), "dataClasses"), "names")

  if(poly){
    cat("Select polygon points and click on finish when done!\n")
    xy <- locator(type="n")
    polygon(xy, border="grey", lty="dotted")
    idx <- PtInPoly(data.frame(x, y), do.call("data.frame", xy))$pip == 1
    code <- paste("x %in% c(", paste(which(idx), collapse=","), ")", sep="")
  } else {
    cat("Select upper-left and bottom-right point!\n")
    xy <- locator(n=2, type="n")[1:2]
    rect(xy$x[1], xy$y[1], xy$x[2], xy$y[2], border="grey", lty="dotted")

    idx <- (x %[]% range(xy$x) & y %[]% range(xy$y))
    code <- paste(vname[2], " %[]% c(", xy$x[1], ", ", xy$x[2], ") & ", vname[1] ," %[]% c(",  xy$y[1], ", ", xy$y[2], "))", sep="")
  }

  res <- which(idx)
  xy <- lapply(lapply(xy, range), signif, digits=4)
  attr(x=res, which="cond") <- code

  return(res)

}


PtInPoly <- function(pnts, poly.pnts)  {

  #check if pnts & poly is 2 column matrix or dataframe
  pnts = as.matrix(pnts); poly.pnts = as.matrix(poly.pnts)
  if (!(is.matrix(pnts) & is.matrix(poly.pnts))) stop('pnts & poly.pnts must be a 2 column dataframe or matrix')
  if (!(dim(pnts)[2] == 2 & dim(poly.pnts)[2] == 2)) stop('pnts & poly.pnts must be a 2 column dataframe or matrix')

  #ensure first and last polygon points are NOT the same
  if (poly.pnts[1,1] == poly.pnts[nrow(poly.pnts),1] & poly.pnts[1,2] == poly.pnts[nrow(poly.pnts),2]) poly.pnts = poly.pnts[-1,]

  #run the point in polygon code
  out = .Call('pip',pnts[,1],pnts[,2],nrow(pnts),poly.pnts[,1],poly.pnts[,2],nrow(poly.pnts))

  #return the value
  return(data.frame(pnts,pip=out))
}




# Identify points in a plot using a formula.
# http://www.rforge.net/NCStats/files/
# Author: Derek Ogle <dogle@northland.edu>

identify.formula <- function(formula, data, subset, na.action, ...) {
#   mf <- model.frame(x, data)
#   x <- mf[,2]
#   y <- mf[,1]
#   identify(x, y, ...)

  if (missing(formula) || (length(formula) != 3L) || (length(attr(terms(formula[-2L]),
                                                                  "term.labels")) != 1L))
    stop("'formula' missing or incorrect")
  m <- match.call(expand.dots = FALSE)
  if (is.matrix(eval(m$data, parent.frame())))
    m$data <- as.data.frame(data)
  m[[1L]] <- quote(stats::model.frame)
  m$... <- NULL
  mf <- eval(m, parent.frame())
  response <- attr(attr(mf, "terms"), "response")

  identify(x=mf[[-response]], y=mf[[response]], ...)

}



# experimental: formula interface for split

split.formula <- function(x, f, drop = FALSE, data = NULL, ...) {
  mf <- model.frame(x, data)
  f <- mf[,2]
  x <- mf[,1]
  split(x, f, drop=drop, ...)
}




###

## helpers: PlotPar und PlotRCol


PlotPar <- function(){
  # plots the most used plot parameters

  usr <- par(no.readonly=TRUE);  on.exit(par(usr))

  if( !is.null(dev.list()) ){
    curwin <- dev.cur()
    on.exit({
      dev.set(curwin)
      par(usr)
      })
  }

  # this does not work and CRAN does not allow windows()
  # dev.new(width=7.2, height=4)

  par( mar=c(0,0,0,0), mex=0.001, xaxt="n", yaxt="n", ann=F, xpd=TRUE)
  plot( x=1:25, y=rep(11,25), pch=1:25, cex=2, xlab="", ylab=""
      , frame.plot=FALSE, ylim=c(-1,15))
  points( x=1:25, y=rep(12.5,25), pch=1:35, cex=2, col="blue", bg="red")
  text( x=1:25, y=rep(9.5,25), labels=1:25, cex=0.8 )
  segments( x0=1, x1=4, y0=0:5, lty=6:1, lwd=3 )
  text( x=5, y=6:0, adj=c(0,0.5), labels=c("0 = blank", "1 = solid (default)", "2 = dashed", "3 = dotted", "4 = dotdash", "5 = longdash", "6 = twodash") )
  segments( x0=10, x1=12, y0=0:6, lty=1, lwd=7:1 )
  text( x=13, y=0:6, adj=c(0,0.5), labels=7:1 )
  points( x=rep(15,7), y=0:6, cex=rev(c(0.8,1,1.5,2,3,4,7)) )
  text( x=16, y=0:6, adj=c(0,0.5), labels=rev(c(0.8,1,1.5,2,3,4,7)) )
  text( x=c(1,1,10,15,18,18), y=c(14,7.5,7.5,7.5,7.5,2.5), labels=c("pch","lty","lwd","pt.cex","adj","col"), cex=1.3, col="grey40")
  adj <- expand.grid(c(0,0.5,1),c(0,0.5,1))
  for( i in 1:nrow(adj)  ){
    text( x=18+adj[i,1]*7, y=3.5+adj[i,2]*3, label=paste("text", paste(adj[i,], collapse=",") ), adj=unlist(adj[i,]), cex=0.8 )
  }
  points( x=18:25, y=rep(1,8), col=1:8, pch=15, cex=2 )
  text( x=18:25, y=0, adj=c(0.5,0.5), labels=1:8, cex=0.8 )

}



PlotRCol <- function(ord=c("hsv","default"), label=c("text","hex","dec")) {

  usr <- par(no.readonly=TRUE);  on.exit(par(usr))

  # plots all named colors:   PlotRCol(lbel="hex") hat noch zuviele Bezeichnungen
  if( !is.null(dev.list()) ){
    curwin <- dev.cur()
    on.exit({
      dev.set(curwin)
      par(usr)
    })
  }

  # this does not work and CRAN does not allow windows()
  # dev.new(width=13, height=7)

  # colors without greys (and grays...)
  cols <- colors()[-grep( pattern="^gr[ea]y", colors())]

  # set order
  switch( match.arg( arg=ord, choices=c("hsv","default") )
	  , "default" = { # do nothing
      }
    , "hsv" = {
        rgbc <- col2rgb(cols)
        hsvc <- rgb2hsv(rgbc[1,],rgbc[2,],rgbc[3,])
        cols <- cols[ order(hsvc[1,],hsvc[2,],hsvc[3,]) ]
      }
  )

  cols <- c(cols, rep(NA,3) ) # um 3 NULL-Werte erweitern

  zeilen <- 38; spalten <- 12 # 660 Farben
  farben.zahlen <- matrix( 1:spalten ,nrow=zeilen, ncol=spalten, byrow=T ) # Matrix fuer Punkte

  x_offset <- 0.5
  x <- farben.zahlen[,1:spalten]  # x-Werte (Zahlen)
  y <- -rep(1:zeilen, spalten)    # y-Werte (Zahlen)

  par(mar=c(0,0,0,0), mex=0.001, xaxt="n", yaxt="n", ann=F)
  plot( x, y
    , pch=22    # Punkttyp Rechteck
    , cex=2     # Vergroesserung Punkte
    , bg=cols   # Hintergrundfarben
    , bty="n"   # keine Box
    , xlim=c(1,spalten+x_offset) # x-Wertebereich
  )
  switch( match.arg( arg=label, choices=c("text","hex","dec") )
	  , "text" = {
        text( x+0.1, y, cols, adj=0, cex=0.6 ) # Text Farben
      }
    , "hex" = {     # HEX-Codes
        text( x+0.1, y, adj=0, cex=0.6,
        c(apply(apply(col2rgb(cols[1:(length(cols)-3)]), 2, sprintf, fmt=" %02X"), 2, paste, collapse=""), rep("",3))
        )
      }
    , "dec" = {     # decimal RGB-Codes
        text( x+0.1, y, adj=0, cex=0.6,
        c(apply(apply(col2rgb(cols[1:(length(cols)-3)]), 2, sprintf, fmt=" %03d"), 2, paste, collapse=""), rep("",3))
        )
      }
  )
}


PlotMar <- function(){
  print( "Not yet implemented...")
  # should plot margins
  # die Umrechung in Linien-Abstaende funktioniert so nicht

  # par( mar=c(5,6,4,2)+0.1, mgp=c(3,2,1), xaxs="i")
  # par(xpd=TRUE,  mgp=c(3,2,1))

# plot(0:10, 0:10, type="n", xlab="x-Beschriftung", ,ylab="y-Beschriftung", main="Title")
# lht <- strheight("A")
# lwt <- strwidth("A")
# abline(v=c(-1,-2,-3)*lht, col="grey", lty="dotted")

# abline(h=c(-1,-2,-3)*lht , col="grey", lty="dotted")
# -par()$mgp*lht
# arrows(-3*lht,5,0, lwd="2", code=3, col="brown", len="0.12", angle=20)
# text("mgp[1] (default: 3)", x=0.2, y=5, adj=c(0,0.5), cex=0.8)

# arrows(-2*lht,7,0, lwd="2", code=3, col="brown", len="0.12", angle=20)
# text("mgp[2] (default: 1)", x=0.2, y=7, adj=c(0,0.5), cex=0.8)
# arrows(-1*lht,9,0, lwd="2", code=3, col="brown", len="0.12", angle=20)
# text("mgp[3] (default: 0)", x=0.2, y=9, adj=c(0,0.5), cex=0.8)

# box("outer", lty="solid", col="green")
# box("inner", lty="solid", col="green")
# box("figure", col="blue")

# arrows(-6*lht-0.05,1,0, lwd="2", code=3, col="brown", len="0.12", angle=20)
# text("mar[2] (default: 4)", x=0.2, y=1, adj=c(0,0.5), cex=0.8)
}



Mar <- function(bottom=NULL, left=NULL, top=NULL, right=NULL, outer=FALSE){

  if(outer){
    if(is.null(bottom)) bottom <- par("oma")[1]
    if(is.null(left)) left <- par("oma")[2]
    if(is.null(top)) top <- par("oma")[3]
    if(is.null(right)) right <- par("oma")[4]
    res <- par(oma=c(bottom, left, top, right))

  } else {
    if(is.null(bottom)) bottom <- par("mar")[1]
    if(is.null(left)) left <- par("mar")[2]
    if(is.null(top)) top <- par("mar")[3]
    if(is.null(right)) right <- par("mar")[4]
    res <- par(mar=c(bottom, left, top, right))

  }
  invisible(res)
}



Xplore <- function (x) {

  # require(manipulate)

  .PrepCmd <- function(xvar, yvar, data, dcol, col, dpch, pch, alpha, cex, grid, smooth, desc, show) {
    if(desc){
      if(yvar == "none"){
        s <- gettextf("Desc(%s$%s, plotit=FALSE)", deparse(substitute(data)), xvar)
      } else {
        s <- gettextf("Desc(%s ~ %s, data=%s, plotit=FALSE)", yvar, xvar, deparse(substitute(data)))
      }
    } else {

      if(xvar=="none" & yvar == "none"){
        s <- "Canvas()"

      } else if (yvar == "none") {
        s <- gettextf("PlotDesc(%s$%s, na.rm=TRUE)",
                      deparse(substitute(data)), xvar)
      } else {
        s <- gettextf("plot(%s ~ %s, data=%s", yvar,
                      xvar, deparse(substitute(data)))
        if (!is.na(dcol)) {
          s <- paste(s, gettextf(", col=as.numeric(%s)", dcol))
        } else  if (!is.na(col)) {
          s <- paste(s, gettextf(", col=SetAlpha('%s', %s)", col, alpha))
        }
        if (!is.na(dpch)) {
          s <- paste(s, gettextf(", pch=as.numeric(%s)", dpch))
        } else if (!is.na(pch)) {
          s <- paste(s, gettextf(", pch=as.numeric(%s)", pch))
        }
        if (!is.na(cex)) {
          s <- paste(s, gettextf(", cex=as.numeric(%s)", cex))
        }
        s <- paste(s, ")")
      }
      if (show)
        cat(s, "\n")
    }
    if(grid) s <- paste(s, ";grid()")
    if (!is.na(smooth)) {
      scmd <- ""
      if(smooth == "linear"){
        scmd <- gettextf("lines(lm(%s ~ %s, data=%s))", yvar,
                         xvar, deparse(substitute(data)))
      } else if(smooth == "loess"){
        scmd <- gettextf("lines(loess(%s ~ %s, data=%s))", yvar,
                         xvar, deparse(substitute(data)))
      }
      s <- paste(s, ";", scmd)
    }


    return(s)

  }

  # define the variables here, as the Rcmd check as CRAN will note miss a visible binding:
  #    Explore: no visible binding for global variable 'xvar'

  xvar <- character()
  yvar <- character()
  dcol <- character()
  dpch <- character()
  col <- character()
  pch <- character()
  alpha <- character()
  cex <- character()
  desc <- logical()
  show <- logical()

  variables <- c("none", as.list(names(x)))
  snames <- c(none = NA, as.list(names(x)[!sapply(x, IsNumeric)]))
  cols <- as.list(colors())
  smoothers <- as.list(c("none", "loess", "linear", "spline"))

  manipulate::manipulate({
    eval(parse(text = .PrepCmd(xvar, yvar, x, dcol, col, dpch, pch, alpha, cex, grid, smooth, desc, show)))
  },
  yvar = manipulate::picker(variables, initial = "none", label = "y-variable     "),
  xvar = manipulate::picker(variables, initial = "none", label = "x-variable     "),
  dcol = manipulate::picker(snames, initial = "none", label = "data color          "),
  col = manipulate::picker(cols, initial = "black", label = "color          "),
  dpch = manipulate::picker(snames, initial = "none", label = "data point character"),
  pch = manipulate::picker(as.list(as.character(1:25)), initial = "1", label = "point character"),
  alpha = manipulate::slider(min=0, max = 1, step = 0.1, ticks = TRUE, initial = 1, label = "transparency"),
  cex = manipulate::slider(min=0.1, max = 5, step = 0.1, ticks = TRUE, initial = 1, label = "point character extension"),
  grid = manipulate::checkbox(initial = FALSE, label = "grid"),
  smooth = manipulate::picker(smoothers, initial = "none", label = "smoother          "),
  desc = manipulate::button("Describe"),
  show = manipulate::button("Print command")
  )


}


###


# PlotTools *************************************


## graphics: base  ====

lines.loess <- function(x, col = getOption("col1", hblue), lwd = 2, lty = "solid", type = "l",  n = 100
                             , conf.level = 0.95, args.band = NULL, ...){

  newx <- seq(from = min(x$x, na.rm=TRUE), to = max(x$x, na.rm=TRUE), length = n)
  fit <- predict(x, newdata=newx, se = !is.na(conf.level) )

  if (!is.na(conf.level)) {

    # define default arguments for ci.band
    args.band1 <- list(col = SetAlpha(col, 0.30), border = NA)
    # override default arguments with user defined ones
    if (!is.null(args.band)) args.band1[names(args.band)] <- args.band

    # add a confidence band before plotting the smoother
    lwr.ci <- fit$fit + fit$se.fit * qnorm((1 - conf.level)/2)
    upr.ci <- fit$fit - fit$se.fit * qnorm((1 - conf.level)/2)
    do.call("DrawBand", c(args.band1, list(x=c(newx, rev(newx))), list(y=c(lwr.ci, rev(upr.ci)))) )
    # reset fit for plotting line afterwards
    fit <- fit$fit
  }

  lines( y = fit, x = newx, col = col, lwd = lwd, lty = lty, type = type)

}


lines.smooth.spline <- function (x, col = getOption("col1", hblue), lwd = 2, lty = "solid",
                                 type = "l", conf.level = 0.95, args.band = NULL,
                                 ...) {

  # newx <- seq(from = min(x$x, na.rm = TRUE), to = max(x$x, na.rm = TRUE), length = n)
  newx <- x$x

  fit <- predict(x, newdata = newx)

  if (!is.na(conf.level)) {
    args.band1 <- list(col = SetAlpha(col, 0.3), border = NA)
    if (!is.null(args.band))
      args.band1[names(args.band)] <- args.band

    res <- (x$yin - x$y)/(1-x$lev)      # jackknife residuals
    sigma <- sqrt(var(res))                     # estimate sd
    upr.ci <- fit$y + qnorm((1 - conf.level)/2) * sigma * sqrt(x$lev)   # upper 95% conf. band
    lwr.ci <- fit$y - qnorm((1 - conf.level)/2) * sigma * sqrt(x$lev)   # lower 95% conf. band

    do.call("DrawBand", c(args.band1, list(x = c(newx, rev(newx))),
                          list(y = c(lwr.ci, rev(upr.ci)))))

  }

  lines(y = fit$y, x = fit$x, col = col, lwd = lwd, lty = lty, type = type)
}



lines.lm <- function (x, col = getOption("col1", hblue), lwd = 2, lty = "solid",
                      type = "l", n = 100, conf.level = 0.95, args.cband = NULL,
                      pred.level = NA, args.pband = NULL, ...) {

  mod <- x$model

  # we take simply the second column of the model data.frame to identify the x variable
  # this will crash, if there are several resps and yield nonsense if there is
  # more than one pred,
  # so check for a simple regression model y ~ x (just one resp, just one pred)

  # Note:
  # The following will not work, because predict does not correctly recognise the newdata data.frame:
  # lines(lm(d.pizza$temperature ~ d.pizza$delivery_min), col=hred, lwd=3)
  # see what happens to the data.frame colnames in: predict(x, newdata=data.frame("d.pizza$delivery_min"=1:20))
  # this predict won't work.
  # always provide data:    y ~ x, data

  # thiss is not a really new problem:
  # http://faustusnotes.wordpress.com/2012/02/16/problems-with-out-of-sample-prediction-using-r/


  newx <- data.frame(seq(from = min(mod[,2], na.rm = TRUE), to = max(mod[,2],
                                                                     na.rm = TRUE), length = n))
  colnames(newx) <- names(mod)[2]
  fit <- predict(x, newdata = newx)

  if (!(is.na(pred.level) || identical(args.pband, NA)) ) {
    args.pband1 <- list(col = SetAlpha(col, 0.12), border = NA)
    if (!is.null(args.pband))
      args.pband1[names(args.pband)] <- args.pband

    ci <- predict(x, interval="prediction", newdata=newx, level=pred.level) # Vorhersageband
    do.call("DrawBand", c(args.pband1, list(x = c(unlist(newx), rev(unlist(newx)))),
                          list(y = c(ci[,2], rev(ci[,3])))))
  }

  if (!(is.na(conf.level) || identical(args.cband, NA)) ) {
    args.cband1 <- list(col = SetAlpha(col, 0.12), border = NA)
    if (!is.null(args.cband))
      args.cband1[names(args.cband)] <- args.cband

    ci <- predict(x, interval="confidence", newdata=newx, level=conf.level) # Vertrauensband
    do.call("DrawBand", c(args.cband1, list(x = c(unlist(newx), rev(unlist(newx)))),
                          list(y = c(ci[,2], rev(ci[,3])))))
  }

  lines(y = fit, x = unlist(newx), col = col, lwd = lwd, lty = lty,
        type = type)
}



ErrBars <- function(from, to = NULL, pos = NULL, mid = NULL, horiz = FALSE, col = par("fg"), lty = par("lty"),
                       lwd = par("lwd"), code = 3, length=0.05,
                       pch = NA, cex.pch = par("cex"), col.pch = par("fg"), bg.pch = par("bg"), ... ) {

  if(is.null(to)) {
    if(!any(dim(from) == 2)) stop("x0 must be a kx2 matrix, when x1 is not provided.")
    if(dim(from)[1] == 2) {
      to <- from[2,]
      from <- from[1,]
    } else {
      to <- from[,2]
      from <- from[,1]
    }
  }
  if(is.null(pos)) pos <- 1:length(from)
  if(horiz){
    arrows( x0=from, x1=to, y0=pos, col=col, lty=lty, lwd=lwd, angle=90, code=code, length=length, ... )
  } else {
    arrows( x0=pos, y0=from, y1=to, col=col, lty=lty, lwd=lwd, angle=90, code=code, length=length, ... )
  }
  if(!is.na(pch)){
    if(is.null(mid)) mid <- (from + to)/2
    # plot points
    if(horiz){
      points(x=mid, y=pos, pch = pch, cex = cex.pch, col = col.pch, bg=bg.pch)
    } else {
      points(x=pos, y=mid, pch = pch, cex = cex.pch, col = col.pch, bg=bg.pch)
    }
  }
}


ColorLegend <- function( x, y=NULL, cols=rev(heat.colors(100)), labels=NULL
  , width=NULL, height=NULL, horiz=FALSE
  , xjust=0, yjust=1, inset=0, border=NA, frame=NA
  , cntrlbl = FALSE
  , adj=ifelse(horiz,c(0.5,1), c(1,0.5)), cex=1.0, ...){

  # positionierungscode aus legend
  auto <- if (is.character(x))
    match.arg(x, c("bottomright", "bottom", "bottomleft",
        "left", "topleft", "top", "topright", "right", "center"))
  else NA

  usr <- par("usr")
  if( is.null(width) ) width <- (usr[2L] - usr[1L]) * ifelse(horiz, 0.92, 0.08)
  if( is.null(height) ) height <- (usr[4L] - usr[3L]) * ifelse(horiz, 0.08, 0.92)

  if (is.na(auto)) {
    left <- x - xjust * width
    top <- y + (1 - yjust) * height

  } else {
    inset <- rep(inset, length.out = 2)
    insetx <- inset[1L] * (usr[2L] - usr[1L])
    left <- switch(auto, bottomright = , topright = ,
        right = usr[2L] - width - insetx, bottomleft = ,
        left = , topleft = usr[1L] + insetx, bottom = ,
        top = , center = (usr[1L] + usr[2L] - width)/2)
    insety <- inset[2L] * (usr[4L] - usr[3L])
    top <- switch(auto, bottomright = , bottom = , bottomleft = usr[3L] +
        height + insety, topleft = , top = , topright = usr[4L] -
        insety, left = , right = , center = (usr[3L] +
        usr[4L] + height)/2)
  }

  xpd <- par(xpd=TRUE); on.exit(par(xpd))

  ncols <- length(cols)
  nlbls <- length(labels)
  if(horiz) {
    rect( xleft=left, xright=left+width/ncols*seq(ncols,0,-1), ytop=top, ybottom=top-height,
      col=cols, border=border)
    if(!is.null(labels)){
      if(cntrlbl) xlbl <- left + width/(2*ncols)+(width-width/ncols)/(nlbls-1) * seq(0,nlbls-1,1)
        else xlbl <- left + width/(nlbls-1) * seq(0,nlbls-1,1)
      text(y=top - (height + max(strheight(labels, cex=cex)) * 1.2)
        # Gleiche Korrektur wie im vertikalen Fall
        # , x=x+width/(2*ncols)+(width-width/ncols)/(nlbls-1) * seq(0,nlbls-1,1)
        , x=xlbl, labels=labels, adj=adj, cex=cex, ...)
     }
  } else {
    rect( xleft=left, ybottom=top-height, xright=left+width, ytop=top-height/ncols*seq(0,ncols,1),
      col=rev(cols), border=border)
    if(!is.null(labels)){
        # Korrektur am 13.6:
        # die groesste und kleinste Beschriftung sollen nicht in der Mitte der Randfarbkaestchen liegen,
        # sondern wirklich am Rand des strips
        # alt: , y=y-height/(2*ncols)- (height- height/ncols)/(nlbls-1)  * seq(0,nlbls-1,1)
        #, y=y-height/(2*ncols)- (height- height/ncols)/(nlbls-1)  * seq(0,nlbls-1,1)

      # 18.4.2015: reverse labels, as the logic below would misplace...
      labels <- rev(labels)

      if(cntrlbl) ylbl <- top - height/(2*ncols) - (height- height/ncols)/(nlbls-1)  * seq(0, nlbls-1,1)
        else ylbl <- top - height/(nlbls-1) * seq(0, nlbls-1, 1)
      text(x=left + width + strwidth("0", cex=cex) + max(strwidth(labels, cex=cex)) * adj[1]
        , y=ylbl, labels=labels, adj=adj, cex=cex, ... )
    }
  }
  if(!is.na(frame)) rect( xleft=left, xright=left+width, ytop=top, ybottom=top-height, border=frame)
}



BubbleLegend <- function(x, y=NULL, radius, cols
                         , labels=NULL, cols.lbl = "black"
                         , width = NULL, xjust = 0, yjust = 1, inset=0, border="black", frame=TRUE
                         , adj=c(0.5,0.5), cex=1.0, bg = NULL, asp = NULL, ...){

  # positionierungscode aus legend
  auto <- if(is.character(x))
    match.arg(x, c("bottomright", "bottom", "bottomleft",
                   "left", "topleft", "top", "topright", "right", "center"))
  else NA

  usr <- par("usr")
  if(is.null(width) ) width <- 2*max(radius) * 1.1

  if(is.null(asp)) # get aspect ratio from plot  w/h
    asp <- par("pin")[1]/diff(par("usr")[1:2]) / par("pin")[2]/diff(par("usr")[3:4])

  height <- width * asp

  if (is.na(auto)) {
    left <- x - xjust * width
    top <- y + (1 - yjust) * height

  } else {
    inset <- rep(inset, length.out = 2)
    insetx <- inset[1L] * (usr[2L] - usr[1L])
    left <- switch(auto, bottomright = , topright = , right = usr[2L] -
                     width - insetx, bottomleft = , left = , topleft = usr[1L] +
                     insetx, bottom = , top = , center = (usr[1L] + usr[2L] -
                                                            width)/2)
    insety <- inset[2L] * (usr[4L] - usr[3L])
    top <- switch(auto, bottomright = , bottom = , bottomleft = usr[3L] +
                    height + insety, topleft = , top = , topright = usr[4L] -
                    insety, left = , right = , center = (usr[3L] + usr[4L] +
                                                           height)/2)
  }

  xpd <- par(xpd=TRUE); on.exit(par(xpd))

  if(!is.na(frame))
    rect( xleft=left, ybottom=top-height, xright=left+width, ytop=top,
          col=bg, border=frame)

  DrawCircle(x = left + width/2, y = (top - height/2) + max(radius) - radius, radius = radius, col=cols, border=border)

  if(!is.null(labels)){
    d <- c(0, 2*radius)
    # ylbl <- (top - height/2) + max(radius) - diff(d) /2 + d[-length(d)]
    ylbl <- rev((top - height/2) + max(radius) - Midx(rev(2*radius), incl.zero = TRUE))
    text(x=left + width/2, y=ylbl, labels=labels, adj=adj, cex=cex, col=cols.lbl, ... )
  }

}

# PlotBubble(y ~ x, data=d.world,  area=pop/90, col="steelblue",
#            border="darkblue", xlab="", ylab="", panel.first=quote(grid()),
#            main="World population")
# BubbleLegend("bottomright", frame=TRUE, cols=SetAlpha("steelblue",0.5), bg="green",
#              radius = c(1500, 1000, 500), labels=c(1500, 1000, 500), cex=0.8,
#              cols.lbl=c("yellow", "red","blue"))


Canvas <- function(xlim=NULL, ylim=xlim, xpd=par("xpd"), mar=c(5.1,5.1,5.1,5.1),
                   asp=1, bg=par("bg"), ...){

  if(is.null(xlim)){
    xlim <- c(-1,1)
    ylim <- xlim
  }
  if(length(xlim)==1) {
    xlim <- c(-xlim,xlim)
    ylim <- xlim
  }

  usr <- par("xpd"=xpd, "mar"=mar, "bg"=bg);  on.exit(par(usr))

  plot( NA, NA, xlim=xlim, ylim=ylim, asp=asp, type="n", xaxt="n", yaxt="n",
        xlab="", ylab="", frame.plot = FALSE, ...)
}



# This is erroneous, but what did I then need, when I did that?
# Midx <- function(x, first=NULL){
#   if(!is.null(first)) x <- c(first, x)
#   res <- cumsum(filter(x, rep(1/2,2)))
#   res <-  res[-length(res)]
#   return(res)
# }


Midx <- function(x, incl.zero = FALSE, cumulate = FALSE){
  if(incl.zero) x <- c(0, x)
  res <- filter(x, rep(1/2,2))
  res <-  res[-length(res)]
  if(cumulate) res <- cumsum(res)
  return(res)
}



###

## graphics: colors ----


PalDescTools <- function(pal, n=100){

  palnames <- c("RedToBlack","RedBlackGreen","SteeblueWhite","RedWhiteGreen",
                "RedWhiteBlue0","RedWhiteBlue1","RedWhiteBlue2","RedWhiteBlue3","Helsana","Tibco","RedGreen1",
                "set1","set2","set3","dark2","accent","pastel1","pastel2","big","big2","dark","med","reg","light")

  if(is.numeric(pal)){
    pal <- palnames[pal]
  }
  big <- c("#800000", "#C00000", "#FF0000", "#FFC0C0",
          "#008000","#00C000","#00FF00","#C0FFC0",
          "#000080","#0000C0", "#0000FF","#C0C0FF",
          "#808000","#C0C000","#FFFF00","#FFFFC0",
          "#008080","#00C0C0","#00FFFF","#C0FFFF",
          "#800080","#C000C0","#FF00FF","#FFC0FF",
          "#C39004","#FF8000","#FFA858","#FFDCA8")

  switch(pal
         , RedToBlack= res <- colorRampPalette(c("red","yellow","green","blue","black"), space = "rgb")(n)
         , RedBlackGreen= res <- colorRampPalette(c("red", "black", "green"), space = "rgb")(n)
         , SteeblueWhite= res <- colorRampPalette(c("steelblue","white"), space = "rgb")(n)
         , RedWhiteGreen= res <- colorRampPalette(c("red", "white", "green"), space = "rgb")(n)
         , RedWhiteBlue0= res <- colorRampPalette(c("red", "white", "blue"))(n)
         , RedWhiteBlue1= res <- colorRampPalette(c("#67001F", "#B2182B", "#D6604D", "#F4A582", "#FDDBC7",
                                            "#FFFFFF", "#D1E5F0", "#92C5DE", "#4393C3", "#2166AC", "#053061"))(n)
         , RedWhiteBlue2= res <- colorRampPalette(c("#BB4444", "#EE9988", "#FFFFFF", "#77AADD", "#4477AA"))(n)
         , RedWhiteBlue3= res <- colorRampPalette(c(hred, "white", hblue))(n)
         , Helsana =  res <- c("rot"="#9A0941", "orange"="#F08100", "gelb"="#FED037"
                       , "ecru"="#CAB790", "hellrot"="#D35186", "hellblau"="#8296C4", "hellgruen"="#B3BA12")
         , Tibco=  res <- apply( mcol <- matrix(c(
                         0,91,0, 0,157,69, 253,1,97, 60,120,177,
                         156,205,36, 244,198,7, 254,130,1,
                         96,138,138, 178,113,60
                          ), ncol=3, byrow=TRUE), 1, function(x) rgb(x[1], x[2], x[3], maxColorValue=255))
         , RedGreen1=  res <- c(rgb(227,0,11, maxColorValue=255), rgb(227,0,11, maxColorValue=255),
                     rgb(230,56,8, maxColorValue=255), rgb(234,89,1, maxColorValue=255),
                     rgb(236,103,0, maxColorValue=255), rgb(241,132,0, maxColorValue=255),
                     rgb(245,158,0, maxColorValue=255), rgb(251,184,0, maxColorValue=255),
                     rgb(253,195,0, maxColorValue=255), rgb(255,217,0, maxColorValue=255),
                     rgb(203,198,57, maxColorValue=255), rgb(150,172,98, maxColorValue=255),
                     rgb(118,147,108, maxColorValue=255))

         , set1 =  res <- c("#E41A1C", "#377EB8", "#4DAF4A", "#984EA3","#FF7F00", "#FFFF33", "#A65628", "#F781BF", "#999999")
         , set2 =  res <- c("#66C2A5", "#FC8D62", "#8DA0CB", "#E78AC3","#A6D854", "#FFD92F", "#E5C494", "#B3B3B3")
         , set3 =  res <- c("#8DD3C7", "#FFFFB3", "#BEBADA", "#FB8072","#80B1D3", "#FDB462", "#B3DE69", "#FCCDE5", "#D9D9D9","#BC80BD","#CCEBC5")
         , dark2 =  res <- c("#1B9E77", "#D95F02", "#7570B3", "#E7298A","#66A61E", "#E6AB02", "#A6761D", "#666666")
         , accent =  res <- c("#7FC97F", "#BEAED4", "#FDC086", "#FFFF99","#386CB0", "#F0027F", "#BF5B17", "#666666")
         , pastel1 =  res <- c("#FBB4AE", "#B3CDE3", "#CCEBC5", "#DECBE4","#FED9A6", "#FFFFCC", "#E5D8BD", "#FDDAEC", "#F2F2F2")
         , pastel2 =  res <- c("#B3E2CD", "#FDCDAC", "#CBD5E8", "#F4CAE4","#E6F5C9", "#FFF2AE", "#F1E2CC", "#CCCCCC")
         , big =  res <- big
         , big2 =  res <- big[c(12,16,25,24,
                       2,11,6,15,18,26,23,
                       3,10,7,14,19,27,22,
                       4,8,20,28)]
         , dark =  res <- big[seq(1,28,by=4)]
         , med =  res <- big[seq(2,28,by=4)]
         , reg =  res <- big[seq(3,28,by=4)]
         , light = res <- big[seq(4,28,by=4)]

  )
  return(res)
}


PalTibco <- function(){
  col <- apply( mcol <- matrix(c(
      0,91,0, 0,157,69, 253,1,97, 60,120,177,
      156,205,36, 244,198,7, 254,130,1,
      96,138,138, 178,113,60
  ), ncol=3, byrow=TRUE), 1, function(x) rgb(x[1], x[2], x[3], maxColorValue=255))

  return(col)
}

PalRedToBlack <- function(n = 100) colorRampPalette(c("red","yellow","green","blue","black"), space = "rgb")(n)
PalRedBlackGreen <- function (n = 100) colorRampPalette(c("red", "black", "green"), space = "rgb")(n)
PalSteeblueWhite <- function(n = 100) colorRampPalette(c("steelblue","white"), space = "rgb")(n)

PalRedWhiteGreen <- function (n = 100) colorRampPalette(c("red", "white", "green"), space = "rgb")(n)

PalHelsana <- function() c("rot"="#9A0941", "orange"="#F08100", "gelb"="#FED037"
   , "ecru"="#CAB790", "hellrot"="#D35186", "hellblau"="#8296C4", "hellgruen"="#B3BA12")

hred  <- PalHelsana()[1]
horange <- PalHelsana()[2]
hyellow <- PalHelsana()[3]
hecru <- PalHelsana()[4]
hblue <- PalHelsana()[6]
hgreen <- PalHelsana()[7]


# example:
# barplot(1:7, col=SetAlpha(PalHelsana[c("ecru","hellgruen","hellblau")], 1) )

###


## geometric primitives ====

Stamp <- function(txt, wdpath=FALSE, time=FALSE, las=1, cex=0.6) {

  stamp <- function(x) {

    opar <- par(yaxt='s', xaxt='s', xpd=TRUE)
    on.exit(par(opar))
    plt <- par('plt')
    usr <- par('usr')

    ## when a logrithmic scale is in use (i.e. par('xlog') is true),
    ## then the x-limits would be 10^par('usr')[1:2].  Similarly for
    ## the y axis
    xcoord <- usr[2] + (usr[2] - usr[1])/(plt[2] - plt[1]) *
      (1-plt[2]) - cex*strwidth('m')
    ycoord <- usr[3] - diff(usr[3:4])/diff(plt[3:4])*(plt[3]) +
      cex*strheight('m')

    if(par('xlog')) xcoord <- 10^(xcoord)
    if(par('ylog')) ycoord <- 10^(ycoord)

    if(las==3){
      srt <- 90
      adj <- 0
    } else {
      srt <- 0
      adj <- 1
    }
    ## Print the text on the current plot
    text(xcoord, ycoord, x, adj=adj, srt=srt, cex=cex)
    invisible(x)
  }

  date.txt <- if(time) format(Sys.time())
                   else format(Sys.time(), '%Y-%m-%d')

  if(wdpath)
    date.txt <- paste(getwd(), date.txt)

#  oldpar <- par(mfrow=c(1,1), cex = 0.5)
#  on.exit(par(oldpar))

  if(!missing(txt))
    date.txt <- paste(txt, " ", date.txt, sep="")

  invisible(stamp(date.txt))

}



BoxedText <- function(x, y = NULL, labels = seq_along(x), adj = NULL,
     pos = NULL, offset = 0.5, vfont = NULL,
     cex = 1, txt.col = NULL, font = NULL, srt = 0, xpad = 0.2, ypad=0.2,
     density = NULL, angle = 45,
     col = "white", border = par("fg"), lty = par("lty"), lwd = par("lwd"), ...) {


  .BoxedText <- function(x, y = NULL, labels = seq_along(x), adj = NULL,
       pos = NA, offset = 0.5, vfont = NULL,
       cex = 1, txt.col = NULL, font = NULL, srt = 0, xpad = 0.2, ypad=0.2,
       density = NULL, angle = 45,
       col = "white", border = NULL, lty = par("lty"), lwd = par("lwd"), ...) {

    if(is.na(pos)) pos <- NULL   # we have to change default NULL to NA to be able to repeat it
    if(is.na(vfont)) vfont <- NULL

    w <- strwidth(labels, cex=cex, font=font, vfont=vfont)
    h <- strheight(labels, cex=cex, font=font, vfont=vfont)

    if(length(adj) == 1) adj <- c(adj, 0.5)

    xl <- x - adj[1] * w - strwidth("M", cex=cex, font=font, vfont=vfont) * xpad
    xr <- xl + w + 2*strwidth("M", cex=cex, font=font, vfont=vfont) * xpad

    yb <- y - adj[2] * h - strheight("M", cex=cex, font=font, vfont=vfont) * ypad
    yt <- yb + h + 2*strheight("M", cex=cex, font=font, vfont=vfont) * ypad

    xy <- Rotate(x=c(xl,xl,xr,xr), y=c(yb,yt,yt,yb), mx=x, my=y, theta=DegToRad(srt))
    polygon(x=xy$x, y=xy$y, col=col, density=density, angle=angle, border=border, lty=lty, lwd=lwd, ...)

    text(x=x, y=y, labels=labels, adj=adj, pos=pos, offset=offset, vfont=vfont, cex=cex, col=txt.col, font=font, srt=srt)
  }

  if(is.null(adj)) adj <- c(0.5, 0.5)
  if (is.null(pos)) pos <- NA
  if (is.null(vfont)) vfont <- NA
  if (is.null(txt.col)) txt.col <- par("fg")
  if (is.null(font)) font <- 1
  if (is.null(density)) density <- NA

  # recyle arguments:
  #   which parameter has the highest dimension
  # attention: we cannot repeat NULLs but we can repeat NAs, so we swap NULLs to NAs and
  #            reset them to NULL above
  lst <- list(x=x, y=y, labels=labels, adj=adj, pos=pos, offset=offset, vfont=vfont,
     cex=cex, txt.col=txt.col, font=font, srt=srt, xpad=xpad, ypad=ypad,
     density=density, angle=angle, col=col, border=border, lty=lty, lwd=lwd)
  maxdim <- max(unlist(lapply(lst, length)))

  # recycle all params to maxdim
  lgp <- lapply( lst, rep, length.out=maxdim )

  for( i in 1:maxdim){
    .BoxedText(
      x=lgp$x[i], y=lgp$y[i], labels=lgp$labels[i], adj=lgp$adj[i], pos=lgp$pos[i], offset=lgp$offset[i]
      , vfont=lgp$vfont[i], cex=lgp$cex[i], txt.col=lgp$txt.col[i], font=lgp$font[i]
      , srt=lgp$srt[i], xpad=lgp$xpad[i], ypad=lgp$ypad[i], density=lgp$density[i]
      , angle=lgp$angle[i], col=lgp$col[i], border=lgp$border[i], lty=lgp$lty[i], lwd=lgp$lwd[i] )
  }
}



DrawBezier <- function (x = 0, y = x, nv = 100,  col = par("col"), lty = par("lty")
  , lwd = par("lwd"), plot = TRUE ) {

    if (missing(y)) {
        y <- x[[2]]
        x <- x[[1]]
    }
    n <- length(x)
    X <- Y <- single(nv)
    Z <- seq(0, 1, length = nv)
    X[1] <- x[1]
    X[nv] <- x[n]
    Y[1] <- y[1]
    Y[nv] <- y[n]
    for (i in 2:(nv - 1)) {
        z <- Z[i]
        xz <- yz <- 0
        const <- (1 - z)^(n - 1)
        for (j in 0:(n - 1)) {
            xz <- xz + const * x[j + 1]
            yz <- yz + const * y[j + 1]
            const <- const * (n - 1 - j)/(j + 1) * z/(1 - z)
# debugging only:
#            if (is.na(const)) print(c(i, j, z))
        }
        X[i] <- xz
        Y[i] <- yz
    }
    if(plot) lines(x = as.single(X), y = as.single(Y), col=col, lty=lty, lwd=lwd )
    invisible(list(x = as.single(X), y = as.single(Y)))
}



DrawRegPolygon <- function( x = 0, y = x, radius.x = 1, radius.y = radius.x, rot = 0, nv = 3,
      border = par("fg"), col = par("bg"), lty = par("lty"), lwd = par("lwd"), plot = TRUE ) {

    # The workhorse for the geom stuff

    # example:
    # plot(c(0,1),c(0,1), asp=1, type="n")
    # DrawRegPolygon( x=0.5, y=0.5, radius.x=seq(0.5,0.1,-0.1), rot=0, nv=3:10, col=2)
    # DrawRegPolygon( x=0.5+1:5*0.05, y=0.5, radius.x=seq(0.5,0.1,-0.1), rot=0, nv=100, col=1:5)

    # which geom parameter has the highest dimension
    lgp <- list(x=x, y=y, radius.x=radius.x, radius.y=radius.y, rot=rot, nv=nv)
    maxdim <- max(unlist(lapply(lgp, length)))
    # recycle all params to maxdim
    lgp <- lapply( lgp, rep, length.out=maxdim )

    # recycle shape properties
    if (length(col) < maxdim)    { col <- rep(col, length.out = maxdim) }
    if (length(border) < maxdim) { border <- rep(border, length.out = maxdim) }
    if (length(lwd) < maxdim)    { lwd <- rep(lwd, length.out = maxdim) }
    if (length(lty) < maxdim)    { lty <- rep(lty, length.out = maxdim) }

    lst <- list()   # prepare result
    for (i in 1:maxdim) {
        theta.inc <- 2 * pi / lgp$nv[i]
        theta <- seq(0, 2 * pi, by = theta.inc)
        ptx <- cos(theta) * lgp$radius.x[i] + lgp$x[i]
        pty <- sin(theta) * lgp$radius.y[i] + lgp$y[i]
        if(lgp$rot[i] > 0){
          # rotate the structure if the angle is > 0
          dx <- ptx - lgp$x[i]
          dy <- pty - lgp$y[i]
          ptx <- lgp$x[i] + cos(lgp$rot[i]) * dx - sin(lgp$rot[i]) * dy
          pty <- lgp$y[i] + sin(lgp$rot[i]) * dx + cos(lgp$rot[i]) * dy
        }
        if( plot )
          polygon(ptx, pty, border = border[i], col = col[i], lty = lty[i],
              lwd = lwd[i])
        lst[[i]] <- list(x = ptx, y = pty)
    }
    invisible(lst)
}


DrawCircle <- function( x = 0, y = x, radius = 1, rot = 0, nv = 100, border = par("fg"), col = par("bg")
  , lty = par("lty"), lwd = par("lwd"), plot = TRUE ) {
  invisible( DrawRegPolygon(  x = x, y = y, radius.x=radius, nv=nv, border=border, col=col, lty=lty, lwd=lwd, plot = plot ) )
}

DrawEllipse <- function( x = 0, y = x, radius.x = 1, radius.y = 0.5, rot = 0, nv = 100, border = par("fg"), col = par("bg")
  , lty = par("lty"), lwd = par("lwd"), plot = TRUE ) {
  invisible( DrawRegPolygon(  x = x, y = y, radius.x = radius.x, radius.y = radius.y, nv = nv, rot = rot
    , border = border, col = col, lty = lty, lwd = lwd, plot = plot ) )
}



DrawArc <- function (x = 0, y = x, radius.x = 1, radius.y = radius.x, angle.beg = 0,
    angle.end = pi, nv = 100, col = par("col"), lty = par("lty"), lwd = par("lwd"), plot = TRUE) {

    # which geom parameter has the highest dimension
    lgp <- list(x = x, y = y, radius.x = radius.x, radius.y = radius.y,
        angle.beg = angle.beg, angle.end = angle.end, nv = nv)
    maxdim <- max(unlist(lapply(lgp, length)))
    # recycle all params to maxdim
    lgp <- lapply(lgp, rep, length.out = maxdim)

    # recycle shape properties
    if (length(col) < maxdim) {
        col <- rep(col, length.out = maxdim)
    }
    if (length(lwd) < maxdim) {
        lwd <- rep(lwd, length.out = maxdim)
    }
    if (length(lty) < maxdim) {
        lty <- rep(lty, length.out = maxdim)
    }

    lst <- list()
    for (i in 1:maxdim) {
        angdif <- lgp$angle.end[i] - lgp$angle.beg[i]
        theta <- seq(from = 0, to = ifelse(angdif < 0, angdif + 2*pi, angdif),
            length.out = lgp$nv[i]) + lgp$angle.beg[i]
        ptx <- (cos(theta) * lgp$radius.x[i] + lgp$x[i])
        pty <- (sin(theta) * lgp$radius.y[i] + lgp$y[i])
        if (plot) {
            lines(ptx, pty, col = col[i], lty = lty[i], lwd = lwd[i])
        }
        lst[[i]] <- list(x = ptx, y = pty)
    }
    invisible(lst)
}



DrawAnnulusSector <- function (x = 0, y = x, radius.in = 1, radius.out = 2, angle.beg = 0, angle.end = pi
  , nv = 100, border = par("fg"), col = par("bg"), lty = par("lty"), lwd = par("lwd"), plot = TRUE) {

  DrawSector <- function(x, y, radius.in, radius.out, angle.beg, angle.end
      , nv, border, col, lty, lwd, plot) {
    # let DrawArc calculate the 2 arcs
    pts <- DrawArc( x=x, y=y, radius.x = c(radius.out, radius.in), radius.y = c(radius.out, radius.in)
      , angle.beg = angle.beg, angle.end = angle.end, nv = nv
      , col = border, lty = lty, lwd = lwd, plot = FALSE )
    # combine the arcs to a annulus sector
    ptx <- c(pts[[1]]$x, rev(pts[[2]]$x))
    pty <- c(pts[[1]]$y, rev(pts[[2]]$y))
    if( plot ) { polygon(x = ptx, y = pty, col = col, border = border, lty = lty, lwd = lwd) }
    invisible(list(x = ptx, y = pty))
  }

  # which geom parameter has the highest dimension
  lgp <- list(x = x, y = y, radius.in = radius.in, radius.out = radius.out,
      angle.beg = angle.beg, angle.end = angle.end, nv = nv)
  maxdim <- max(unlist(lapply(lgp, length)))
  # recycle all params to maxdim
  lgp <- lapply(lgp, rep, length.out = maxdim)

  # recycle shape properties
  if (length(col) < maxdim) { col <- rep(col, length.out = maxdim) }
  if (length(border) < maxdim) { border <- rep(border, length.out = maxdim) }
  if (length(lwd) < maxdim) { lwd <- rep(lwd, length.out = maxdim) }
  if (length(lty) < maxdim) { lty <- rep(lty, length.out = maxdim) }

  # Draw the single sectors
  lst <- list()
  for (i in 1:maxdim) {
    pts <- DrawSector( x = lgp$x[i], y = lgp$y[i], radius.in = lgp$radius.in[i], radius.out = lgp$radius.out[i]
      , angle.beg = lgp$angle.beg[i], angle.end = lgp$angle.end[i], nv = lgp$nv[i]
      , border = border[i], col = col[i], lty = lty[i], lwd = lwd[i], plot = plot )
    lst[[i]] <- pts
  }
  invisible(lst)

}


DrawAnnulus <- function (x = 0, y = x, radius.in = 1, radius.out = 2, nv = 100, border = par("fg")
  , col = par("bg"), lty = par("lty"), lwd = par("lwd"), plot = TRUE) {

  pts.out <- DrawCircle(x = x, y = y, radius = radius.out, plot = FALSE)
  pts.in <- DrawCircle(x = x, y = y, radius = radius.in, plot = FALSE)

  ptx <- c( unlist(lapply(pts.out, "[", "x")), rev(unlist(lapply(pts.in, "[", "x"))) )
  pty <- c( unlist(lapply(pts.out, "[", "y")), rev(unlist(lapply(pts.in, "[", "y"))) )

  # we have to use polygon here, because of the transparent hole in the middle..
  # but don't know how to ged rid of the closing line, so draw polygon without border and then redraw circles
  polygon(x = ptx, y = pty, col = col, border = NA, lty = lty, lwd = lwd)
  lapply( pts.out, lines, col=border, lty=lty, lwd=lwd )
  lapply( pts.in, lines, col=border, lty=lty, lwd=lwd )

  invisible(list(x = ptx, y = pty))

}


DrawBand <- function(x, y, col = SetAlpha("grey", 0.5), border = NA) {

  # accept matrices but then only n x y
  if(!identical(dim(y), dim(x))){
    x <- as.matrix(x)
    y <- as.matrix(y)

    if(dim(x)[2] == 1 && dim(y)[2] == 2)
      x <- x[, c(1,1)]
    else if(dim(x)[2] == 2 && dim(y)[2] == 1)
      y <- y[, c(1,1)]
    else
      stop("incompatible dimensions for matrices x and y")

    x <- c(x[,1], rev(x[,2]))
    y <- c(y[,1], rev(y[,2]))

  }

  # adds a band to a plot, normally used for plotting confidence bands
  polygon(x=x, y=y, col = col, border = border)
}



Clockwise <- function(x, start=0){
  # Calculates begin and end angles from a list of given angles
  angles <- c(0, cumsum(x), 2*pi)
  revang <- 2*pi - angles + start
  return(data.frame( from=revang[-1], to=revang[-length(revang)]))
}


Rotate <- function( x, y, mx = 0, my = 0, theta=pi/3 ) {

  # which geom parameter has the highest dimension
  lgp <- list(x=x, y=y)
  maxdim <- max(unlist(lapply(lgp, length)))
  # recycle all params to maxdim
  lgp <- lapply( lgp, rep, length.out=maxdim )

  # rotate the structure
  dx <- lgp$x - mx
  dy <- lgp$y - my
  ptx <- mx + cos(theta) * dx - sin(theta) * dy
  pty <- my + sin(theta) * dx + cos(theta) * dy

  return(list(x=ptx, y=pty))

}




SpreadOut <- function(x, mindist = NULL, cex = 1.0) {

  if(is.null(mindist))
    mindist <- 0.9 * max(strheight(x, "inch", cex = cex))

  if(sum(!is.na(x)) < 2) return(x)
  xorder <- order(x)
  goodx <- x[xorder][!is.na(x[xorder])]
  gxlen <- length(goodx)
  start <- end <- gxlen%/%2

  # nicely spread groups of short intervals apart from their mean
  while(start > 0) {
    while(end < gxlen && goodx[end+1] - goodx[end] < mindist) end <- end+1
    while(start > 1 && goodx[start] - goodx[start-1] < mindist) start <- start-1
    if(start < end) {
      nsqueezed <- 1+end-start
      newx <- sum(goodx[start:end]) / nsqueezed - mindist * (nsqueezed %/% 2 - (nsqueezed / 2 == nsqueezed %/% 2) * 0.5)
      for(stretch in start:end) {
        goodx[stretch] <- newx
        newx <- newx+mindist
      }
    }
    start <- end <- start-1
  }

  start <- end <- length(goodx) %/% 2 + 1
  while(start < gxlen) {
    while(start > 1 && goodx[start] - goodx[start-1] < mindist) start <- start-1
    while(end < gxlen && goodx[end+1] - goodx[end] < mindist) end <- end+1
    if(start < end) {
      nsqueezed <- 1 + end - start
      newx <- sum(goodx[start:end]) / nsqueezed - mindist * (nsqueezed %/% 2 - (nsqueezed / 2 == nsqueezed %/% 2) * 0.5)
      for(stretch in start:end) {
        goodx[stretch] <- newx
        newx <- newx+mindist
      }
    }
    start <- end <- end+1
  }

  # force any remaining short intervals apart
  if(any(diff(goodx) < mindist)) {
    start <- gxlen %/% 2
    while(start > 1) {
      if(goodx[start] - goodx[start-1] < mindist)
        goodx[start-1] <- goodx[start] - mindist
      start <- start-1
    }
    end <- gxlen %/% 2
    while(end < gxlen) {
      if(goodx[end+1] - goodx[end] < mindist)
        goodx[end+1] <- goodx[end]+mindist
      end <- end+1
    }
  }

  x[xorder][!is.na(x[xorder])] <- goodx
  return(x)

}



ConnLines <- function(..., col = 1, lwd = 1, lty = "solid", xalign = c("mar","mid") ) {

  # add connection lines to a barplot
  # ... are the arguments, passed to barplot

  b <- barplot(..., plot = FALSE)

  arg <- unlist(match.call(expand.dots = FALSE)$...)
  if(is.null(arg$horiz)) horiz <- FALSE else horiz <- eval(arg$horiz, parent.frame())
  # debug: print(horiz)

  nr <- nrow(eval(arg[[1]], parent.frame())) # nrow(height)
  nc <- length(b)

  if(!is.null(nr)) {
    tmpcum <- apply(eval(arg[[1]], parent.frame()), 2, cumsum)
    ypos1 <- tmpcum[, -nc]
    ypos2 <- tmpcum[, -1]

  } else {
    tmpcum <- eval(arg[[1]], parent.frame())
    ypos1 <- tmpcum[-nc]
    ypos2 <- tmpcum[-1]
    nr <- 1
  }

  xalign <- match.arg(xalign)
  if(xalign=="mar"){

    # the midpoints of the bars
    mx <- (b[-1] + b[-length(b)]) / 2

    if(is.null(arg$space)) space <- 0.2
    else space <- eval(arg$space, parent.frame())

    lx <- mx - space/2
    rx <- mx + space/2

    xpos1 <- rep(lx, rep(nr, length(lx)))
    xpos2 <- rep(rx, rep(nr, length(rx)))

    if(horiz == FALSE)
      segments(xpos1, ypos1, xpos2, ypos2, col=col, lwd=lwd, lty=lty)
    else
      segments(ypos1, xpos1, ypos2, xpos2, col=col, lwd=lwd, lty=lty)

  } else if(xalign=="mid") {
    if(horiz == FALSE) {
      if(nr > 1)
        matlines(x=replicate(nr, b), y=t(tmpcum), lty=lty, lwd=lwd, col=col)
      else
        lines(x=b, y=tmpcum, lty=lty, lwd=lwd, col=col)
    } else {
      if(nr > 1)
        matlines(y=replicate(nr, b), x=t(tmpcum), lty=lty, lwd=lwd, col=col)
      else
        lines(y=b, x=tmpcum, lty=lty, lwd=lwd, col=col)

    }
  }

  invisible()

}


AxisBreak <- function (axis = 1, breakpos = NULL, pos = NA, bgcol = "white",
          breakcol = "black", style = "slash", brw = 0.02) {

  figxy <- par("usr")
  xaxl <- par("xlog")
  yaxl <- par("ylog")
  xw <- (figxy[2] - figxy[1]) * brw
  yw <- (figxy[4] - figxy[3]) * brw
  if (!is.na(pos))
    figxy <- rep(pos, 4)
  if (is.null(breakpos))
    breakpos <- ifelse(axis%%2, figxy[1] + xw * 2, figxy[3] +
                         yw * 2)
  if (xaxl && (axis == 1 || axis == 3))
    breakpos <- log10(breakpos)
  if (yaxl && (axis == 2 || axis == 4))
    breakpos <- log10(breakpos)
  switch(axis, br <- c(breakpos - xw/2, figxy[3] - yw/2, breakpos +
                         xw/2, figxy[3] + yw/2), br <- c(figxy[1] - xw/2, breakpos -
                                                           yw/2, figxy[1] + xw/2, breakpos + yw/2), br <- c(breakpos -
                                                                                                              xw/2, figxy[4] - yw/2, breakpos + xw/2, figxy[4] + yw/2),
         br <- c(figxy[2] - xw/2, breakpos - yw/2, figxy[2] +
                   xw/2, breakpos + yw/2), stop("Improper axis specification."))
  old.xpd <- par("xpd")
  par(xpd = TRUE)
  if (xaxl)
    br[c(1, 3)] <- 10^br[c(1, 3)]
  if (yaxl)
    br[c(2, 4)] <- 10^br[c(2, 4)]
  if (style == "gap") {
    if (xaxl) {
      figxy[1] <- 10^figxy[1]
      figxy[2] <- 10^figxy[2]
    }
    if (yaxl) {
      figxy[3] <- 10^figxy[3]
      figxy[4] <- 10^figxy[4]
    }
    if (axis == 1 || axis == 3) {
      rect(breakpos, figxy[3], breakpos + xw, figxy[4],
           col = bgcol, border = bgcol)
      xbegin <- c(breakpos, breakpos + xw)
      ybegin <- c(figxy[3], figxy[3])
      xend <- c(breakpos, breakpos + xw)
      yend <- c(figxy[4], figxy[4])
      if (xaxl) {
        xbegin <- 10^xbegin
        xend <- 10^xend
      }
    }
    else {
      rect(figxy[1], breakpos, figxy[2], breakpos + yw,
           col = bgcol, border = bgcol)
      xbegin <- c(figxy[1], figxy[1])
      ybegin <- c(breakpos, breakpos + yw)
      xend <- c(figxy[2], figxy[2])
      yend <- c(breakpos, breakpos + yw)
      if (xaxl) {
        xbegin <- 10^xbegin
        xend <- 10^xend
      }
    }
    par(xpd = TRUE)
  }
  else {
    rect(br[1], br[2], br[3], br[4], col = bgcol, border = bgcol)
    if (style == "slash") {
      if (axis == 1 || axis == 3) {
        xbegin <- c(breakpos - xw, breakpos)
        xend <- c(breakpos, breakpos + xw)
        ybegin <- c(br[2], br[2])
        yend <- c(br[4], br[4])
        if (xaxl) {
          xbegin <- 10^xbegin
          xend <- 10^xend
        }
      }
      else {
        xbegin <- c(br[1], br[1])
        xend <- c(br[3], br[3])
        ybegin <- c(breakpos - yw, breakpos)
        yend <- c(breakpos, breakpos + yw)
        if (yaxl) {
          ybegin <- 10^ybegin
          yend <- 10^yend
        }
      }
    }
    else {
      if (axis == 1 || axis == 3) {
        xbegin <- c(breakpos - xw/2, breakpos - xw/4,
                    breakpos + xw/4)
        xend <- c(breakpos - xw/4, breakpos + xw/4, breakpos +
                    xw/2)
        ybegin <- c(ifelse(yaxl, 10^figxy[3 + (axis ==
                                                 3)], figxy[3 + (axis == 3)]), br[4], br[2])
        yend <- c(br[4], br[2], ifelse(yaxl, 10^figxy[3 +
                                                        (axis == 3)], figxy[3 + (axis == 3)]))
        if (xaxl) {
          xbegin <- 10^xbegin
          xend <- 10^xend
        }
      }
      else {
        xbegin <- c(ifelse(xaxl, 10^figxy[1 + (axis ==
                                                 4)], figxy[1 + (axis == 4)]), br[1], br[3])
        xend <- c(br[1], br[3], ifelse(xaxl, 10^figxy[1 +
                                                        (axis == 4)], figxy[1 + (axis == 4)]))
        ybegin <- c(breakpos - yw/2, breakpos - yw/4,
                    breakpos + yw/4)
        yend <- c(breakpos - yw/4, breakpos + yw/4, breakpos +
                    yw/2)
        if (yaxl) {
          ybegin <- 10^ybegin
          yend <- 10^yend
        }
      }
    }
  }
  segments(xbegin, ybegin, xend, yend, col = breakcol, lty = 1)
  par(xpd = FALSE)
}



###

## graphics: conversions ====


PolToCart <- function(r, theta) list(x=r*cos(theta), y=r*sin(theta))

CartToPol <- function(x, y) {
  theta <- atan(y/x)
  theta[x<0] <- theta[x<0] + pi    # atan can't find the correct square (quadrant)
  list(r = sqrt(x^2 + y^2), theta=theta)
}


CartToSph <- function (x, y, z, up = TRUE ) {

  vphi <- CartToPol(x, y)          # x, y -> c( w, phi )
  R <- if (up) {
    CartToPol(vphi$r, z)          # ( w, z,  -> r, theta )
  } else {
    CartToPol(z, vphi$r)          # ( z, w,  -> r, theta )
  }
  res <- c(R[1], R[2], vphi[2])
  names(res) <- c("r", "theta", "phi")

  return (res)
}


SphToCart <- function (r, theta, phi, up = TRUE) {

  if (up) theta <- pi/2 - theta

  vz <- PolToCart(r, theta)
  xy <- PolToCart(vz$y, phi)

  res <- list(x=xy$x, y=xy$x, z=vz$x)

  return (res)
}



ColToHex <- function(col, alpha=1) {
  col.rgb <- col2rgb(col)
  col <- apply( col.rgb, 2, function(x) sprintf("#%02X%02X%02X", x[1], x[2], x[3]) )
  if(alpha != 1 ) col <- paste( col, DecToHex( round( alpha * 255, 0)), sep="")
  return( col )
  # old: sprintf("#%02X%02X%02X", col.rgb[1], col.rgb[2], col.rgb[3])
}


HexToRgb <- function(hex) {
  # converts a hexstring color to matrix with 3 red/green/blue rows
  # example: HexToRgb(c("#A52A2A","#A52A3B"))
  c2 <- do.call("cbind", lapply(hex, function(x) c(strtoi(substr(x,2,3), 16L), strtoi(substr(x,4,5), 16L), strtoi(substr(x,6,7), 16L))))
  return(c2)
}


HexToCol <- function(hexstr, method="rgb", metric="euclidean") RgbToCol(hexstr, method=method, metric=metric)

RgbToCol <- function(col, method="rgb", metric="euclidean") {

  switch( match.arg( arg=method, choices=c("rgb","hsv") )
     , "rgb" = {
            # accepts either a matrix with 3 columns RGB or a hexstr

          if(!is.matrix(col)) {
            col <- lapply(col, function(x) c(strtoi(substr(x,2,3), 16L), strtoi(substr(x,4,5), 16L), strtoi(substr(x,6,7), 16L)))
            col <- do.call("cbind", col)
          }
          coltab <- col2rgb(colors())

          switch( match.arg( arg=metric, choices=c("euclidean","manhattan") )
                  , "euclidean" = {
                    colors()[apply(col, 2, function(x) which.min(apply(apply(coltab, 2, "-", x)^2, 2, sum)))]
                  }
                  , "manhattan" = {
                    colors()[apply(col, 2, function(x) which.min(apply(abs(apply(coltab, 2, "-", x)), 2, sum)))]
                  }
          )
     }
     , "hsv" ={
            # accepts either a matrix with 3 columns RGB or a hexstr
            col <- ColToHsv(col)
            if(!is.matrix(col)) {
              col <- lapply(col, function(x) c(strtoi(substr(x,2,3), 16L), strtoi(substr(x,4,5), 16L), strtoi(substr(x,6,7), 16L)))
              col <- do.call("cbind", col)
            }
            coltab <- ColToHsv(colors())

            switch( match.arg( arg=metric, choices=c("euclidean","manhattan") )
                    , "euclidean" = {
                      colors()[apply(col, 2, function(x) which.min(apply(apply(coltab, 2, "-", x)^2, 2, sum)))]
                    }
                    , "manhattan" = {
                      colors()[apply(col, 2, function(x) which.min(apply(abs(apply(coltab, 2, "-", x)), 2, sum)))]
                    }
            )
     }
  )

  # alternative?
  # Identify closest match to a color:  plotrix::color.id

  # old:
  # coltab <- col2rgb(colors())
  # cdist <- apply(coltab, 2, function(z) sum((z - col)^2))
  # colors()[which(cdist == min(cdist))]
}


RgbToLong <- function(col) (c(1, 256, 256^2) %*% col)[1,]

# example:  RgbToLong(ColToRgb(c("green", "limegreen")))
# if ever needed...
# '~~> LONG To RGB
    # R = Col Mod 256
    # G = (Col \ 256) Mod 256
    # B = (Col \ 256 \ 256) Mod 256



# ColToDec is col2rgb??
ColToRgb <- function(col, alpha = FALSE) col2rgb(col, alpha)

ColToHsv <- function(col, alpha = FALSE) rgb2hsv(ColToRgb(col, alpha))


ColToGrey <- function(col){
  rgb <- col2rgb(col)
  g <- rbind( c(0.3, 0.59, 0.11) ) %*% rgb
  rgb(g, g, g, maxColorValue=255)
}


ColToGray <- function(col){
  ColToGrey(col)
}

# Add alpha channel to a HexCol
# paste("#00FF00", round(0.3 * 255,0), sep="" )


TextContrastColor <- function(col, method=c("glynn","sonego")) {

  switch( match.arg( arg=method, choices=c("glynn","sonego") )
          , "glynn" = {
            # efg, Stowers Institute for Medical Research
            # efg's Research Notes:
            #   http://research.stowers-institute.org/efg/R/Color/Chart
            #
            # 6 July 2004.  Modified 23 May 2005.

            # For a given col, define a text col that will have good contrast.
            #   Examples:
            #     > GetTextContrastcol("white")
            #     [1] "black"
            #     > GetTextContrastcol("black")
            #     [1] "white"
            #     > GetTextContrastcol("red")
            #     [1] "white"
            #     > GetTextContrastcol("yellow")
            #     [1] "black"
            vx <- rep("white", length(col))
            vx[ apply(col2rgb(col), 2, mean) > 127 ] <- "black"

          }
          , "sonego" = {
            # another idea from Paolo Sonego in OneRTipaDay:
            L <- c(0.2, 0.6, 0) %*% col2rgb(col) / 255
            vx <- ifelse(L >= 0.2, "#000060", "#FFFFA0")
          }
  )

  return(vx)

}



MixColor <- function (col1, col2, amount1=0.5) {

  .mix <- function(col1, col2, amount1=0.5) {
    # calculate mix
    mix <- apply(col2rgb(c(col1, col2), alpha=TRUE), 1, function(x) amount1 * x[1] + (1-amount1) * x[2])
    do.call("rgb", c(as.list(mix), maxColorValue=255))
  }

  m <- suppressWarnings(cbind(col1, col2, amount1))
  apply(m, 1, function(x) .mix(col1=x[1], col2=x[2], amount1=as.numeric(x[3])))

}



FindColor <- function(x, cols=rev(heat.colors(100)), min.x=min(pretty(x)), max.x=max(pretty(x)),
                      all.inside = FALSE){

	# Korrektur von min und max, wenn nicht standardmaessig
	colrange <- range( pretty(c(min.x,max.x)) )

	# Berechnung des entsprechenden Farb-Index
  col.idx <- findInterval(x, seq(colrange[1], colrange[2], length = length(cols) + 1)
                          , rightmost.closed=TRUE, all.inside=all.inside)
  col.idx[col.idx==0] <- NA  # den Index 0 gibt es nicht im Farbenvektor
  cols[col.idx]

  # alt:
	# cols[ findInterval( x, seq(colrange[1], colrange[2], length=length(cols)+1 ) ) ]
}


SetAlpha <- function(col, alpha=0.5) {

  if (length(alpha) < length(col)) alpha <- rep(alpha, length.out = length(col))
  if (length(col) < length(alpha)) col <- rep(col, length.out = length(alpha))

  acol <- substr(ColToHex(col), 1, 7)
  acol[!is.na(alpha)] <- paste(acol[!is.na(alpha)], DecToHex(round(alpha[!is.na(alpha)]*255,0)), sep="")
  acol[is.na(col)] <- NA
  return(acol)
}


###


## plots: PlotBubble ====

PlotBubble <-function(x, ...)
  UseMethod("PlotBubble")


PlotBubble.default <- function(x, y, area, col, border = NA, na.rm = FALSE, inches=FALSE, ...) {

  # http://blog.revolutionanalytics.com/2010/11/how-to-make-beautiful-bubble-charts-with-r.html

  d.frm <- data.frame(x=x, y=y, area=area, col=col)
  if(na.rm) d.frm <- d.frm[complete.cases(d.frm),]

  xlim <- range(pretty( sqrt(area[c(which.min(d.frm$x), which.max(d.frm$x))] / pi) * c(-1,1) + c(min(d.frm$x),max(d.frm$x)) ))
  ylim <- range(pretty( sqrt(area[c(which.min(d.frm$y), which.max(d.frm$y))] / pi) * c(-1,1) + c(min(d.frm$y),max(d.frm$y)) ))

  # make sure we see all the bubbles
  plot(x = x, y = y, xlim=xlim, ylim=ylim, type="n", ...)
  symbols(x=x, y=y, circles=sqrt(area / pi), fg=border, bg=col, inches=inches, add=TRUE)

}




PlotBubble.formula <- function (formula, data = parent.frame(), ..., subset, ylab = varnames[response]) {

  m <- match.call(expand.dots = FALSE)
  eframe <- parent.frame()
  md <- eval(m$data, eframe)
  if (is.matrix(md))
    m$data <- md <- as.data.frame(data)
  dots <- lapply(m$..., eval, md, eframe)
  nmdots <- names(dots)
  if ("main" %in% nmdots)
    dots[["main"]] <- enquote(dots[["main"]])
  if ("sub" %in% nmdots)
    dots[["sub"]] <- enquote(dots[["sub"]])
  if ("xlab" %in% nmdots)
    dots[["xlab"]] <- enquote(dots[["xlab"]])
#   if ("panel.first" %in% nmdots)
#     dots[["panel.first"]] <- match.fun(dots[["panel.first"]])
# http://r.789695.n4.nabble.com/panel-first-problem-when-plotting-with-formula-td3546110.html

  m$ylab <- m$... <- NULL
  subset.expr <- m$subset
  m$subset <- NULL
  m <- as.list(m)
  m[[1L]] <- stats::model.frame.default
  m <- as.call(c(m, list(na.action = NULL)))
  mf <- eval(m, eframe)
  if (!missing(subset)) {
    s <- eval(subset.expr, data, eframe)
    l <- nrow(mf)
    dosub <- function(x) if (length(x) == l)
      x[s]
    else x
    dots <- lapply(dots, dosub)
    mf <- mf[s, ]
  }

#   horizontal <- FALSE
#   if ("horizontal" %in% names(dots))
#     horizontal <- dots[["horizontal"]]

  response <- attr(attr(mf, "terms"), "response")

  if (response) {
    varnames <- names(mf)
    y <- mf[[response]]
    funname <- NULL
    xn <- varnames[-response]
    if (is.object(y)) {
      found <- FALSE
      for (j in class(y)) {
        funname <- paste0("plot.", j)
        if (exists(funname)) {
          found <- TRUE
          break
        }
      }
      if (!found)
        funname <- NULL
    }
    if (is.null(funname))
      funname <- "PlotBubble"

    if (length(xn)) {
      if (!is.null(xlab <- dots[["xlab"]]))
        dots <- dots[-match("xlab", names(dots))]
      for (i in xn) {
        xl <- if (is.null(xlab))
          i
        else xlab
        yl <- ylab
#         if (horizontal && is.factor(mf[[i]])) {
#           yl <- xl
#           xl <- ylab
#         }
        do.call(funname, c(list(mf[[i]], y, ylab = yl,
                                xlab = xl), dots))
      }
    }
    else do.call(funname, c(list(y, ylab = ylab), dots))
  }

  print(c(list(y, ylab = ylab), dots))

  invisible()
}


###

## plots: PlotFdist ====


PlotFdist <- function (x, main = deparse(substitute(x)), xlab = ""
                       , xlim = NULL
                       , do.hist = !(all(IsWhole(x,na.rm=TRUE)) & length(unique(na.omit(x))) < 13)
                       # do.hist overrides args.hist, add.dens and rug
                       , args.hist = NULL          # list( breaks = "Sturges", ...)
                       , args.rug = NA             # list( ticksize = 0.03, side = 1, ...), pass NA if no rug
                       , args.dens = NULL          # list( bw = "nrd0", col="#9A0941FF", lwd=2, ...), NA for no dens
                       , args.curve = NA           # list( ...), NA for no dcurve
                       , args.boxplot = NULL       # list( pars=list(boxwex=0.5), ...), NA for no boxplot
                       , args.ecdf = NULL          # list( col="#8296C4FF", ...), NA for no ecdf
                       , heights = NULL            # heights (hist, boxplot, ecdf) used by layout
                       , pdist = NULL              # distances of the plots, default = 0
                       , na.rm = FALSE, cex.axis = NULL, cex.main = NULL, mar = NULL) {

  # Plot function to display the distribution of a cardinal variable
  # combines a histogram with a density curve, a boxplot and an ecdf
  # rug can be added by using add.rug = TRUE

  # default colors are Helsana CI-colors

  # dev question: should dots be passed somewhere??

  usr <- par(no.readonly=TRUE);  on.exit(par(usr))

  add.boxplot <- !identical(args.boxplot, NA)
  add.rug <- !identical(args.rug, NA)
  add.dens <- !identical(args.dens, NA)
  add.ecdf <- !identical(args.ecdf, NA)
  add.dcurve <- !identical(args.curve, NA)

  # preset heights
  if(is.null(heights)){
    if(add.boxplot) {
      if(add.ecdf) heights <- c(2, 0.5, 1.4)
      else heights <- c(2, 1.4)
    } else {
      if(add.ecdf) heights <- c(2, 1.4)
    }
  }

  if(is.null(pdist)) {
    if(add.boxplot) pdist <- c(0, 0)
    else pdist <- c(0, 1)
  }

  if (add.ecdf && add.boxplot) {
    layout(matrix(c(1, 2, 3), nrow = 3, byrow = TRUE), heights = heights, TRUE)
    if(is.null(cex.axis)) cex.axis <- 1.3
    if(is.null(cex.main)) cex.main <- 1.7
  } else {
    if((add.ecdf || add.boxplot)) {
      layout(matrix(c(1, 2), nrow = 2, byrow = TRUE), heights = heights[1:2], TRUE)
      if(is.null(cex.axis)) cex.axis <- 0.9
    } else {
      if(is.null(cex.axis)) cex.axis <- 0.95
    }
  }

  # plot histogram, change margin if no main title
  par(mar = c(ifelse(add.boxplot || add.ecdf, 0, 5.1), 6.1, 1, 2.1))

  if(!is.null(mar)) {
    par(oma=mar)
  } else {
    if(!is.na(main)) { par(oma=c(0,0,3,0)) }
  }

  # wait for omitting NAs until all arguments are evaluated, e.g. main...
  if(na.rm) x <- na.omit(x)

  # handle open list of arguments: args.legend in barplot is implemented this way...
  # we need histogram anyway to define xlim
  args.hist1 <- list(x = x, xlab = "", ylab = "", freq = FALSE,
                     xaxt = ifelse(add.boxplot || add.ecdf, "n", "s"), xlim = xlim, ylim = NULL, main = NA, las = 1,
                     col = "white", border = "grey70", cex.axis = cex.axis)
  if (!is.null(args.hist)) {
    args.hist1[names(args.hist)] <- args.hist
  }
  x.hist <- DoCall("hist", c(args.hist1[names(args.hist1) %in%
                                           c("x", "breaks", "include.lowest", "right", "nclass")], plot = FALSE))
  x.hist$xname <- deparse(substitute(x))
  if (is.null(xlim))  args.hist1$xlim <- range(pretty(x.hist$breaks))
  args.histplot <- args.hist1[!names(args.hist1) %in% c("x", "breaks", "include.lowest", "right", "nclass")]

  if (do.hist) {
    # calculate max ylim for density curve, provided there should be one...
    # what's the maximal value in density or in histogramm$densities?

    # plot density
    if (add.dens) {
      # preset default values
      args.dens1 <- list(x = x,
                         col = getOption("col1", hred), lwd = 2, lty = "solid")
      if (!is.null(args.dens)) {
        args.dens1[names(args.dens)] <- args.dens
      }
      x.dens <- DoCall("density", args.dens1[-match(c("col",
                                                       "lwd", "lty"), names(args.dens1))])

      # overwrite the ylim if there's a larger density-curve
      args.histplot[["ylim"]] <- range(pretty(c(0, max(c(x.dens$y, x.hist$density)))))
    }
    DoCall("plot", append(list(x.hist), args.histplot))

    if (add.dens) {
      lines(x.dens, col = args.dens1$col, lwd = args.dens1$lwd, lty = args.dens1$lty)
    }


    # plot special distribution curve
    if (add.dcurve) {
      # preset default values
      args.curve1 <- list(expr = parse(text = gettextf("dnorm(x, %s, %s)", mean(x), sd(x))),
                          add = TRUE,
                          n = 500, col = getOption("col3", hgreen), lwd = 2, lty = "solid")
      if (!is.null(args.curve)) {
        args.curve1[names(args.curve)] <- args.curve
      }

      if (is.character(args.curve1$expr)) args.curve1$expr <- parse(text=args.curve1$expr)

      # do.call("curve", args.curve1)
      # this throws an error heere:
      # Error in eval(expr, envir, enclos) : could not find function "expr"
      # so we roll back to do.call
      do.call("curve", args.curve1)

    }


    if (add.rug) {
      args.rug1 <- list(x = x, col = "grey")
      if (!is.null(args.rug)) {
        args.rug1[names(args.rug)] <- args.rug
      }
      DoCall("rug", args.rug1)
    }
  }
  else {
    plot(prop.table(table(x)), type = "h", xlab = "", ylab = "",
         xaxt = "n", xlim = args.hist1$xlim, main = NA,
         frame.plot = FALSE, las = 1, cex.axis = cex.axis, panel.first = {
           abline(h = axTicks(2), col = "grey", lty = "dotted")
           abline(h = 0, col = "black")
         })
  }

  # boxplot
  if(add.boxplot){
    par(mar = c(ifelse(add.ecdf, 0, 5.1), 6.1, pdist[1], 2.1))
    args.boxplot1 <- list(x = x, frame.plot = FALSE, main = NA, boxwex = 1,
                          horizontal = TRUE, ylim = args.hist1$xlim,
                          at = 1, xaxt = ifelse(add.ecdf, "n", "s"),
                          outcex = 1.3, outcol = rgb(0,0,0,0.5), cex.axis=cex.axis)
    if (!is.null(args.boxplot)) {
      args.boxplot1[names(args.boxplot)] <- args.boxplot
    }
    DoCall("boxplot", args.boxplot1)
  }

  # plot ecdf
  if (add.ecdf) {
    par(mar = c(5.1, 6.1, pdist[2], 2.1))
#     args.ecdf1 <- list(x = x, frame.plot = FALSE, main = NA,
#                        xlim = args.hist1$xlim, col = getOption("col1", hblue), lwd = 2,
#                        xlab = xlab, yaxt = "n", ylab = "", verticals = TRUE,
#                        do.points = FALSE, cex.axis = cex.axis)
    args.ecdf1 <- list(x = x, main = NA, breaks={if(length(x)>1000) 1000 else NULL}, ylim=c(0,1),
                       xlim = args.hist1$xlim, col = getOption("col1", hblue), lwd = 2,
                       xlab = "", yaxt = "n", ylab = "", cex.axis = cex.axis,
                       frame.plot = FALSE)
    if (!is.null(args.ecdf)) {
      args.ecdf1[names(args.ecdf)] <- args.ecdf
    }


    DoCall("PlotECDF", args.ecdf1)
    #     DoCall("plot.ecdf", args.ecdf1)
#     axis(side = 2, at = seq(0, 1, 0.25), labels = gsub(pattern = "0\\.",
#                                                        replacement = " \\.", format(seq(0, 1, 0.25), 2)),
#          las = 1, xaxs = "e", cex.axis = cex.axis)
#     abline(h = c(0.25, 0.5, 0.75), col = "grey", lty = "dotted")
#     grid(ny = NA)
#     points(x=range(x), y=c(0,1), col=args.ecdf1$col, pch=3, cex=2)

  }

  if(!is.na(main)) {
    if(!is.null(cex.main)) par(cex.main=cex.main)
    title(main=main, outer = TRUE)
  }

  layout(matrix(1))           # reset layout on exit
}




PlotECDF <- function(x, breaks=NULL, col=getOption("col1", hblue),
                     ylab="", lwd = 2, xlab = NULL, cex.axis = NULL, ...){

  if(is.null(breaks)){
    tab <- table(x)
    xp <- as.numeric(names(tab))
    yp <- cumsum(tab)
  } else {
    xh <- hist(x, breaks=breaks, plot=FALSE)
    xp <- xh$mids
    yp <- cumsum(xh$density)
  }
  yp <- yp * 1/tail(yp, 1)

  if(is.null(xlab)) xlab <- deparse(substitute(x))

  plot(yp ~ xp, lwd=lwd, type = "s", col=col, xlab= xlab, yaxt="n",
       ylab = "", cex.axis=cex.axis, ...)

  axis(side = 2, at = seq(0, 1, 0.25),
       labels = gsub(pattern = "0\\.", replacement = " \\.", format(seq(0, 1, 0.25), 2)),
       las = 1, xaxs = "e", cex.axis = cex.axis)

  abline(h = c(0, 0.25, 0.5, 0.75, 1), col = "grey", lty = c("dashed","dotted","dotted","dotted","dashed"))
  grid(ny = NA)
  points(x = range(x), y = c(0, 1), col = col,  pch = 3, cex = 2)

}


###

## plots: PlotMultiDens ====

PlotMultiDens <- function (x, ...)
UseMethod("PlotMultiDens")


PlotMultiDens.formula <- function (formula, data, subset, na.action, ...) {

    if (missing(formula) || (length(formula) != 3))
        stop("formula missing or incorrect")

    m <- match.call(expand.dots = FALSE)
    if (is.matrix(eval(m$data, parent.frame())))
        m$data <- as.data.frame(data)
    m$... <- NULL
    m[[1]] <- as.name("model.frame")
    mf <- eval(m, parent.frame())

    response <- attr(attr(mf, "terms"), "response")

    PlotMultiDens(split(mf[[response]], mf[-response]), ...)
}



PlotMultiDens.default <- function( x, xlim = NULL, ylim = NULL
                                   , col = rainbow(length(x)), lty = "solid", lwd = 1
                                   , xlab = "x", ylab = "density"
                                   # , type = c("line", "stack", "cond")
                                   , args.dens = NULL
                                   , args.legend = NULL
                                   , na.rm = FALSE, flipxy=FALSE, ...) {

  # the input MUST be a numeric list, use split if there's no list:
  #   PlotMultiDens(list(x,y,z))

  # Alternative:
  # library(lattice)
  # densityplot(  ~ vl|  vjdeck + region_x, data=d.set )

  FlipDensXY <- function(x){
    # flips x and y values of a density-object
    tmp <- x$x
    x$x <- x$y
    x$y <- tmp
    return(x)
  }

  # na.omit if wished
  if(na.rm) x <- lapply(x, na.omit)

  args.dens1 <- list(n = 2^12, kernel="epanechnikov")     # default values
  if (!is.null(args.dens)) {
    args.dens1[names(args.dens)] <- args.dens
  }

  # recycle density arguments
  maxdim <- max(length(x), unlist(lapply(args.dens1, length)))
  args.dens1 <- lapply( args.dens1, rep, length.out=maxdim )

  # recycle x
  x <- rep(x, length.out=maxdim )

  # let's calculate the densities
  l.dens <- list()
  for(i in 1:maxdim)  {
    if(length(x[[i]]) > 2)
      l.dens[[i]] <- if(flipxy) {
        FlipDensXY(do.call("density", append(list(x[[i]]), lapply(args.dens1,"[", i)) ))
      } else {
        do.call("density", append(list(x[[i]]), lapply(args.dens1,"[", i)) )
      }
  }


  # recycle line attributes
  # which geom parameter has the highest dimension
  l.par <- list(lty=lty, lwd=lwd, col=col)
  l.par <- lapply( l.par, rep, length.out = maxdim )

  if( missing("xlim") ) xlim <- range(pretty( unlist(lapply(l.dens, "[", "x")) ) )
  if( missing("ylim") ) ylim <- range(pretty( unlist(lapply(l.dens, "[", "y")) ))

  dev.hold()
  on.exit(dev.flush())

  plot( x=1, y=1, xlim = xlim, ylim = ylim, type="n", xlab=xlab, ylab=ylab, ... )

#   switch(match.arg(type,choices=c("line","stack","cond"))
#     overlay = {
              for(i in 1:length(l.dens))  {
                lines( l.dens[[i]], col=l.par$col[i], lty=l.par$lty[i], lwd=l.par$lwd[i] )
               }
# },
#     stack =   { },
#     cond =    {
#               }
#   )

  args.legend1 <- list( x="topright", inset=0, legend=if(is.null(names(x))){1:length(x)} else {names(x)}
                        , fill=col, bg="white", cex=0.8 )
  if( length(unique(lwd))>1 || length(unique(lty))>1 ) {
    args.legend1[["fill"]] <-  NULL
    args.legend1[["col"]] <- col
    args.legend1[["lwd"]] <- lwd
    args.legend1[["lty"]] <- lty
  }
  if ( !is.null(args.legend) ) { args.legend1[names(args.legend)] <- args.legend }
  add.legend <- TRUE
  if(!is.null(args.legend)) if(all(is.na(args.legend))) {add.legend <- FALSE}

  if(add.legend) DoCall("legend", args.legend1)

  res <- DoCall(rbind, lapply((lapply(l.dens, "[", c("bw","n"))), data.frame))
  res$kernel <- unlist(args.dens1["kernel"])

  invisible(res)

}

## plots: PlotMarDens ====


PlotMarDens <- function( x, y, grp=1, xlim = NULL, ylim = NULL
  , col = rainbow(nlevels(factor(grp)))
  , mardens = c("all","x","y"), pch=1, pch.cex=1.0, main=""
  , na.rm = FALSE, args.legend = NULL
  , args.dens = NULL, ...){

  usr <- par("usr");  on.exit( par(usr) )

  mardens <- match.arg(arg = mardens, choices = c("all", "x", "y"))

  par(oma=c(0,0,3,0))

  d.frm <- data.frame(x=x, y=y, grp=grp)
  pch=rep(pch, length.out=nlevels(factor(grp)))    # recycle pch

  # this is plot.default defaults
  xlim <- if (is.null(xlim)) range(x[is.finite(x)]) else xlim
  ylim <- if (is.null(ylim)) range(y[is.finite(y)]) else ylim

  switch( mardens
    , "all" = { nf <- layout(matrix(c(2,0,1,3),2,2, byrow=TRUE), widths=c(9,1.5), heights=c(0.8,4), TRUE) }
    , "x" = { nf <- layout(matrix(c(2,1), 2,1, byrow=TRUE), c(9), c(0.8,4), TRUE) }
    , "y" =  { nf <- layout(matrix(c(1,2),1,2, byrow=TRUE), c(9,1.5), c(4), TRUE) }
  )

  par(mar=c(5,5,1,1))
  plot(x=d.frm$x, y=d.frm$y, xlim=xlim, ylim=ylim, type="n", ... )

  s <- split(d.frm[,1:2], d.frm$grp)
  for( i in seq_along(s)  ){
    points( x=s[[i]]$x, y=s[[i]]$y, col=col[i], pch=pch[i], cex=pch.cex)
  }


  args.legend1 <- list( x = "topright", inset = 0.02, legend = levels(factor(grp))
    , col = col, pch = pch, bg = "white", cex = 0.8 )
  if ( !is.null(args.legend) ) {
    if(!all(is.na(args.legend))){
      args.legend1[names(args.legend)] <- args.legend
    } else {
      args.legend1 <- NA
    }
  }

  if(!all(is.na(args.legend1))) do.call("legend", args.legend1)

  if(mardens %in% c("all","x")){
    par(mar=c(0,5,0,1))

    args.plotdens1 <- list(x = split(d.frm$x, d.frm$grp), na.rm = TRUE,
                       col = col, xlim = xlim, axes=FALSE,
                       args.legend = NA, xlab="", ylab="")
    if (!is.null(args.dens)) {
      args.plotdens1[names(args.dens)] <- args.dens
    }
    args.dens1 <- list(n = 4096, bw = "nrd0", kernel = "epanechnikov")
    if (!is.null(args.dens)) {
      ovr <- names(args.dens)[names(args.dens) %in% names(args.dens1)]
      args.dens1[ovr] <- args.dens[ovr]
    }
    args.plotdens1$args.dens <- args.dens1
    args.plotdens1 <- args.plotdens1[names(args.plotdens1) %nin% names(args.dens1)]

    do.call("PlotMultiDens", args.plotdens1)

#    PlotMultiDens( split(d.frm$x, d.frm$grp), col=col, na.rm=TRUE, xlim=xlim
#      , axes=FALSE, args.legend = NA, xlab="", ylab="" )
  }

  if(mardens %in% c("all","y")){
    par(mar=c(5,0,1,1))
    args.plotdens1 <- list(x = split(d.frm$y, d.frm$grp), na.rm = TRUE,
                           col = col, ylim = ylim, axes=FALSE, flipxy=TRUE,
                           args.legend = NA, xlab="", ylab="")
    if (!is.null(args.dens)) {
      args.plotdens1[names(args.dens)] <- args.dens
    }
    args.dens1 <- list(n = 4096, bw = "nrd0", kernel = "epanechnikov")
    if (!is.null(args.dens)) {
      ovr <- names(args.dens)[names(args.dens) %in% names(args.dens1)]
      args.dens1[ovr] <- args.dens[ovr]
    }
    args.plotdens1$args.dens <- args.dens1
    args.plotdens1 <- args.plotdens1[names(args.plotdens1) %nin% names(args.dens1)]

    do.call("PlotMultiDens", args.plotdens1)
#     PlotMultiDens( split(d.frm$y, d.frm$grp), col=col, na.rm=TRUE, ylim=ylim
#       , axes = FALSE, args.legend = NA, flipxy=TRUE, xlab="", ylab="" )

  }
  title(main=main, outer=TRUE)

}


###

## plots: PlotArea ====


PlotArea <- function(x, ...) {
# PlotArea - mehrere Flaechen uebereinander
# source: http://r.789695.n4.nabble.com/PlotArea-td2255121.html
# arni...
  UseMethod("PlotArea")
}

PlotArea.default <- function(x, y=NULL, prop=FALSE, add=FALSE, xlab=NULL, ylab=NULL,
                             col=NULL, frame.plot=FALSE, ...) {

  if(is.ts(x)) {  # ts/mts
    if(is.null(ylab)) ylab <- deparse(substitute(x))
    x <- data.frame(Time=time(x), x)
  }

  if(is.table(x)) { # table
    if(is.null(ylab)) ylab <- deparse(substitute(x))
    if(length(dim(x)) == 1)
      x <- t(t(unclass(x)))
    else
      x <- unclass(x)
  }

  if(is.matrix(x)) { # matrix
    if(!is.null(rownames(x)) && !any(is.na(suppressWarnings(as.numeric(rownames(x)))))) {
      x <- data.frame(as.numeric(rownames(x)), x)
      names(x)[1] <- ""
    } else {
      x <- data.frame(Index=seq_len(nrow(x)), x)
    }
  }

  if(is.list(x)) { # data.frame or list
    if(is.null(xlab))  xlab <- names(x)[1]
    if(is.null(ylab)) {
      if(length(x) == 2)
        ylab <- names(x)[2]
      else
        ylab <- ""
    }

    y <- x[-1]
    x <- x[[1]]
  }

  if(is.null(y)) { # one numeric vector passed, plot it on 1:n
    if(is.null(xlab))  xlab <- "Index"
    if(is.null(ylab))  ylab <- deparse(substitute(x))

    y <- x
    x <- seq_along(x)
  }

  if(is.null(xlab))  xlab <- deparse(substitute(x))
  if(is.null(ylab))  ylab <- deparse(substitute(y))

  y <- as.matrix(y)

  if(is.null(col))  col <- gray.colors(ncol(y))
  col <- rep(col, length.out=ncol(y))

  if(prop)  y <- prop.table(y, 1)

  y <- t(rbind(0, apply(y, 1, cumsum)))
  na <- is.na(x) | apply(is.na(y),1,any)
  x <- x[!na][order(x[!na])]
  y <- y[!na,][order(x[!na]),]

  if(!add)  suppressWarnings(matplot(x, y, type="n", xlab=xlab, ylab=ylab, frame.plot=frame.plot, ...))
  xx <- c(x, rev(x))

  for(i in 1:(ncol(y)-1)) {
    yy <- c(y[,i+1], rev(y[,i]))
    suppressWarnings(polygon(xx, yy, col=col[i], ...))
  }

  invisible(y[,-1])
}


PlotArea.formula <- function (formula, data, subset, na.action, ...) {

  m <- match.call(expand.dots=FALSE)
  if(is.matrix(eval(m$data,parent.frame())))   m$data <- as.data.frame(data)

  m$... <- NULL
  m[[1]] <- as.name("model.frame")

  if(as.character(formula[[2]]==".")) {
    rhs <- unlist(strsplit(deparse(formula[[3]])," *[:+] *"))
    lhs <- sprintf("cbind(%s)", paste(setdiff(names(data), rhs),collapse=","))
    m[[2]][[2]] <- parse(text=lhs)[[1]]
  }

  mf <- eval(m, parent.frame())
  if(is.matrix(mf[[1]])) {
    lhs <- as.data.frame(mf[[1]])
    names(lhs) <- as.character(m[[2]][[2]])[-1]
    PlotArea.default(cbind(mf[-1],lhs), ...)
  } else {
    PlotArea.default(mf[2:1], ...)
  }
}

###

## plots: PlotDotCI ====


PlotDot <- function (x, labels = NULL, groups = NULL, gdata = NULL, cex = par("cex"),
                     pch = 21, gpch = 21, bg = par("bg"), color = par("fg"), gcolor = par("fg"),
                     lcolor = "gray", xlim = NULL, main = NULL,
                     xlab = NULL, ylab = NULL, add = FALSE,
                     args.errbars = NULL, ...) {

  # this is mainly R-Core code from dotchart
  # extended by argument add and returning y-coordinates

  x <- Rev(x, margin=1)

  if(is.null(xlim)) {
    if(is.null(args.errbars)){
      xlim <- range(x[is.finite(x)])
    } else {
      rng <- c(args.errbars[["from"]], args.errbars[["to"]])
      xlim <- range(rng[is.finite(rng)])
    }
  }

  opar <- par("mai", "mar", "cex", "yaxs")
  on.exit(par(opar))
  par(cex = cex, yaxs = "i")
  if (!is.numeric(x))
    stop("'x' must be a numeric vector or matrix")
  n <- length(x)
  if (is.matrix(x)) {
    if (is.null(labels))
      labels <- rownames(x)
    if (is.null(labels))
      labels <- as.character(1L:nrow(x))
    labels <- rep_len(labels, n)
    if (is.null(groups))
      groups <- col(x, as.factor = TRUE)
    glabels <- levels(groups)
  }
  else {
    if (is.null(labels))
      labels <- names(x)
    glabels <- if (!is.null(groups))
      levels(groups)
    if (!is.vector(x)) {
      warning("'x' is neither a vector nor a matrix: using as.numeric(x)")
      x <- as.numeric(x)
    }
  }
  if(!add) plot.new()
  linch <- if (!is.null(labels))
    max(strwidth(labels, "inch"), na.rm = TRUE)
  else 0
  if (is.null(glabels)) {
    ginch <- 0
    goffset <- 0
  }
  else {
    ginch <- max(strwidth(glabels, "inch"), na.rm = TRUE)
    goffset <- 0.4
  }
  if (!(is.null(labels) && is.null(glabels))) {
    nmai <- par("mai")
    nmai[2L] <- nmai[4L] + max(linch + goffset, ginch) +
      0.1
    par(mai = nmai)
  }
  if (is.null(groups)) {
    o <- 1L:n
    y <- o
    ylim <- c(0, n + 1)
  }
  else {
    o <- sort.list(as.numeric(groups), decreasing = TRUE)
    x <- x[o]
    groups <- groups[o]
    color <- rep_len(color, length(groups))[o]
    lcolor <- rep_len(lcolor, length(groups))[o]
    offset <- cumsum(c(0, diff(as.numeric(groups)) != 0))
    y <- 1L:n + 2 * offset
    ylim <- range(0, y + 2)
  }
  if(!add) plot.window(xlim = xlim, ylim = ylim, log = "")
  lheight <- par("csi")
  if (!is.null(labels)) {
    linch <- max(strwidth(labels, "inch"), na.rm = TRUE)
    loffset <- (linch + 0.1)/lheight
    labs <- labels[o]
    mtext(labs, side = 2, line = loffset, at = y, adj = 0,
          col = color, las = 2, cex = cex, ...)
  }
  if(!add) abline(h = y, lty = "dotted", col = lcolor)
  points(x, y, pch = pch, col = color, bg = bg)
  if (!is.null(groups) & (!add)) {
    gpos <- rev(cumsum(rev(tapply(groups, groups, length)) +
                         2) - 1)
    ginch <- max(strwidth(glabels, "inch", font=2), na.rm = TRUE)
    goffset <- (max(linch + 0.2, ginch, na.rm = TRUE) + 0.1)/lheight
    mtext(glabels, side = 2, line = goffset, at = gpos, adj = 0, font=2,
          col = gcolor, las = 2, cex = cex, ...)
    if (!is.null(gdata)) {
      abline(h = gpos, lty = "dotted")
      points(gdata, gpos, pch = gpch, col = gcolor, bg = bg,
             ...)
    }
  }
  if(!add) axis(1)
  if(!add) box()
  if(!add) title(main = main, xlab = xlab, ylab = ylab, ...)

  # add error bars if requested
  args.errbars1 <- list(horiz=TRUE, pos=y)
  if(!is.null(args.errbars)) {
    args.errbars1[names(args.errbars)] <- args.errbars
    args.errbars1[["from"]] <- Rev(args.errbars1[["from"]], c(1,2))
    args.errbars1[["to"]] <- Rev(args.errbars1[["to"]], c(1,2))
    args.errbars1[["mid"]] <- Rev(args.errbars1[["mid"]], c(1,2))

    do.call("ErrBars", args.errbars1)
  }


  # return y-values
  invisible(y)

}




# PlotDotCI <- function( x, xlim = NULL, pch = 21, pch.cex = 1.0, pch.col = "black", pch.bg = "grey50"
#   , lcol = "grey40", lwd = 2, args.legend = NULL , code = 3, lend="butt"
#   , mar = c(7.1,4.1,4.1,2.1), ... ) {
#
#   # example:
#   # xx <- do.call("rbind",tapply( d.pizza$temperature, d.pizza$driver, MeanCI, na.rm=TRUE ) )
#   # rownames(xx) <- levels(d.pizza$driver)
#   # PlotDotCI( xx, pch.cex=1.2 )
#
#   usr <- par("usr");  on.exit( par(usr) )
#   par(mar=mar, lend=lend)
#
#   # we need xlim here, as all segments should be completely displayed
#   if( missing("xlim") ) xlim <- range(pretty(x))
#
#   x <- x[rev(1:nrow(x)),]    # reverse order by default
#
#   dotchart( x[,1], xaxt="n", xlim=xlim, color="black", ...)
#   abline(v=axTicks(1), col="grey", lty="dotted")
#   arrows( x0=x[,2], x1=x[,3], y0=1:nrow(x), col=lcol, lwd=lwd, angle=90, code=code, length=0.05 )
#   points( x=x[,1], y=1:nrow(x), bg=pch.bg, pch=pch, cex=pch.cex, col=pch.col )
#
#   # the default values for the legend
#   args.legend1 <- list( x = mean(par()$usr[1:2]), y = -1.3
#         , legend = c("estimate", "95%-CI"), xpd = TRUE
#         , ncol = 2, seg.len = 2, xjust = 0.5
#         , adj = c(0, 0.5)
#         , pt.bg = c(pch.bg, NA), lwd = lwd
#         , pch = c(pch, NA), col = c(pch.bg, lcol)
#         , bg = "white", cex = 0.8
#       )
#   if( length(unique(lwd))>1 ) {
#     args.legend1[["fill"]] <-  NULL
#     args.legend1[["col"]] <- col
#     args.legend1[["lwd"]] <- lwd
#   }
#   if ( !is.null(args.legend) ) { args.legend1[names(args.legend)] <- args.legend }
#   add.legend <- TRUE
#   if(!is.null(args.legend)) if(all(is.na(args.legend))) {add.legend <- FALSE}
#
#   if(add.legend) do.call("legend", args.legend1)
#
# }
#
#
#
# PlotDotCIp <- function(x, n, xlim=c(0,1), ord=c("rel", "abs", "names"), decreasing=FALSE, ... ) {
#
#   # example:
#
#   # tab <- table( d.pizza$driver, d.pizza$wine_delivered)
#   # PlotDotCIp( x=tab[,2], n=apply(tab,1,sum), ord="abs", dec=TRUE )
#
#   # parameter recycling for x and n:
#   #   which parameter has the highest dimension
#   lgp <- list(x=x, n=n)
#   maxdim <- max(unlist(lapply(lgp, length)))
#   #   recycle all params to maxdim
#   lgp <- lapply( lgp, rep, length.out=maxdim )
#
#   ci <- t(sapply(seq_along(x), function(i) BinomCI( x=lgp$x[i], n=lgp$n[i]) ))
#   rownames(ci) <- names(x)
#   switch( match.arg( arg=ord, choices=c("rel", "abs", "names") )
#     , "rel" = { idx <- order(ci[,1], decreasing=decreasing) }
#     , "abs" = { idx <- order(ci[,2], decreasing=decreasing) }
#     , "names" =  { idx <- order(names(x), decreasing=decreasing) }
#   )
#   ci <- ci[idx,]
#
#   PlotDotCI( ci, xlim=xlim, ... )
#
# }


PlotLinesA <- function(x, y, col=1:5, lty=1, lwd=1, lend = par("lend"), xlab = NULL,
                       ylab = NULL, xlim = NULL, ylim = NULL, cex = 1, cex.legend = 1,
                       main=NULL, grid=TRUE, mar=NULL){

  # example:
  #
  # m <- matrix(c(3,4,5,1,5,4,2,6,2), nrow = 3,
  #             dimnames = list(dose = c("A","B","C"),
  #                             age = c("2000","2001","2002")))
  # PlotLinesA(m, col=rev(c(PalHelsana(), "grey")), main="Dosw ~ age", lwd=3, ylim=c(1,10))


  last <- Sort(data.frame(t(tail(as.matrix(x), 1))))
  last <- setNames(last[,], nm = rownames(last))

  if(is.null(mar)) Mar(,,, 10)  # this would be nice, but there's no plot so far... max(strwidth(names(last))) * 1.2
  else do.call(Mar, as.list(mar))

  matplot(x, y, type="n", las=1, xlim=xlim, ylim=ylim, xaxt="n", main=main, ylab=ylab, cex = cex)
  axis(side = 1, at=c(1:nrow(x)), rownames(x), xlab=xlab)
  if(grid) grid()
  matplot(x, type="l", lty=lty, col=col, lwd=lwd, lend=lend, xaxt="n", add=TRUE)

  oldpar <- par(xpd=TRUE); on.exit(par(oldpar))
  mtext(text = names(last), side=4, line = 1.8, at = SpreadOut(last, mindist = 1.2 * strheight("M")),
        las=1, cex = cex.legend)
  segments(x0 = par("usr")[2] + diff(par("usr")[1:2]) * 0.02,
           x1 = par("usr")[2] + diff(par("usr")[1:2]) * 0.02 * 2,
           y0 = SpreadOut(unlist(last), mindist = 1.2 * strheight("M")),
           lwd=4, lend=1,
           col=col[match(names(last), colnames(x))])

}


###

## plots: PlotFun ====

PlotFun <- function(FUN, args=NULL, from=NULL, to=NULL, by=NULL, xlim=NULL,
                    ylim = NULL, polar = FALSE, type="l",
                    col = par("col"), lwd= par("lwd"), lty=par("lty"), pch=NA,
                    add = FALSE, ...){

#   # all dot arguments
#   dot.args <- match.call(expand.dots=FALSE)$...
#   # the dot arguments which match PercTable.table
#   # pt.args <- dot.args[names(dot.args) %in% names(formals(PercTable.table))]
#   # the dot arguments which DO NOT match PercTable.table
#   par.args <- dot.args[names(dot.args) %nin% names(formals(PlotFun))]

  # see also Hmisc::minor.tick


  vars <- all.vars(FUN)
  vars <- vars[vars %nin% names(args)]

  # this is not really smart ....
  if(is.null(from)) from <- -5
  if(is.null(to)) to <- 5
  if(is.null(by)) by <- (to - from) / 500


  # the independent variable
  assign(vars, seq(from = from, to = to, by=by))

  # define the parameters
  for(i in seq_along(args)) {
    assign(names(args)[i], unlist(args[i]))

    # this does not work:
    if(length(get(names(args)[i])) > 1) {
      assign(names(args)[i], get(names(args)[i])[1])
      warning(gettextf("first element used of '%s' argument", names(args)[i]))
    }
  }

  # Inhibit model interpretation for function plot
  FUN[[2]] <-   as.formula("~" %c% gettextf("I(%s)", deparse(FUN[[2]])) )[[2]]
  FUN[[3]] <-   as.formula("~" %c% gettextf("I(%s)", deparse(FUN[[3]])) )[[2]]

  # this will evaluate in parent.frame(), so in function's env
  p <- ParseFormula(FUN)

  y <- p$lhs$mf.eval[,1]
  x <- p$rhs$mf.eval[,1]

  if(polar){
    cord <- PolToCart(r = y, theta = x)
    y <- cord$y
    x <- cord$x
  }

  if(is.null(xlim)){
    xlim <- range(pretty(range(x[is.finite(x)])))
  }
  if(is.null(ylim)){
    ylim <- range(pretty(range(y[is.finite(y)])))
  }

  # define plot parameters
  m <- match.call(expand.dots = FALSE)
  m$...$frame.plot <- InDots(..., arg="frame.plot", default = FALSE)
  m$...$axes <- InDots(..., arg="axes", default = NULL)
  m$...$asp <- InDots(..., arg="asp", default = 1)
  m$...$xlab <- InDots(..., arg="xlab", default = "")
  m$...$ylab <- InDots(..., arg="ylab", default = "")
  if(is.null(m$...$axes)) {
    add.axes <- TRUE
    m$...$axes <- FALSE
  } else {
    add.axes <- FALSE
  }

  if(!add){
    do.call(plot, c(list(y=1, x=1, xlim=xlim, ylim=ylim, type="n"), m$...))
  }

  if(add.axes) {
    axis(1, pos = 0)
    # we set minor ticks for the axes, 4 ticks between 2 major ticks
    axp <- par("xaxp")
    axp[3] <- 5 * axp[3]
    axis(1, pos = 0, TRUE, at=axTicks(side=1, axp=axp), labels = NA, tck=-0.01)
    axis(2, pos = 0,las=1)
    axp <- par("yaxp")
    axp[3] <- 5 * axp[3]
    axis(2, pos = 0, TRUE, at=axTicks(side=1, axp=axp), labels = NA, tck=-0.01)
  }

  lines(y=y, x=x, type=type, col=col, lty=lty, lwd=lwd, pch=pch)

}

## plots: PlotPyramid ====



PlotPyramid <- function(lx, rx = NA, ylab = "",
            ylab.x = 0, col = c("red", "blue"), border = par("fg"),
            main = "", lxlab = "", rxlab = "", xlim = NULL,
            gapwidth = NULL, xaxt = TRUE,
            args.grid = NULL,
            cex.axis = par("cex.axis"), cex.lab = par("cex.axis"), cex.names = par("cex.axis"), adj = 0.5, ...) {

  if (missing(rx) && length(dim(lx)) > 0) {
    rx <- lx[, 2]
    lx <- lx[, 1]
  }

  b <- barplot(-lx, horiz=TRUE, plot=FALSE, ...)

  ylim <- c(0, max(b))
  if(is.null(xlim)) xlim <- c(-max(lx), max(rx))
  plot( 1, type="n", xlim=xlim, ylim=ylim, frame.plot=FALSE
        , xlab="", ylab="", axes=FALSE, main=main)
  if(is.null(gapwidth)) gapwidth <- max(strwidth(ylab, cex=cex.names)) + 3*strwidth("M", cex=cex.names)

  at.left <- axTicks(1)[axTicks(1)<=0] - gapwidth/2
  at.right <- axTicks(1)[axTicks(1)>=0] + gapwidth/2

  # grid: define default arguments
  if(!identical(args.grid, NA)){    # add grid
    args.grid1 <- list(col="grey", lty="dotted")
    # override default arguments with user defined ones
    if (!is.null(args.grid)) {
      args.grid1[names(args.grid)] <- args.grid
    }
    abline(v=c(at.left, at.right), col=args.grid1$col, lty=args.grid1$lty )
  }

  if(length(col) == 1) border <- rep(col, 2)
  lcol <- rep(col[seq_along(col) %% 2 == 1], times=length(lx))
  rcol <- rep(col[seq_along(col) %% 2 == 0], times=length(rx))

  if(length(border) == 1) border <- rep(border, 2)
  lborder <- rep(border[seq_along(border) %% 2 == 1], times=length(lx))
  rborder <- rep(border[seq_along(border) %% 2 == 0], times=length(rx))

  barplot(-lx, horiz=TRUE, col=lcol, add=T, axes=FALSE, names.arg="",
          offset=-gapwidth/2, border=lborder, ...)
  barplot(rx, horiz=TRUE, col=rcol, add=T, axes=FALSE, names.arg="",
          offset=gapwidth/2, border=rborder, ...)

  oldpar <- par(xpd=TRUE); on.exit(par(oldpar))

  ylab.x <- ylab.x + sign(ylab.x) * gapwidth/2
  text(ylab, x=ylab.x, y=b, cex=cex.names, adj = adj)

  if(!xaxt == "n"){
    axis(side=1, at=at.right, labels=axTicks(1)[axTicks(1)>=0], cex.axis=cex.axis)
    axis(side=1, at=at.left, labels=-axTicks(1)[axTicks(1)<=0], cex.axis=cex.axis)
  }

  mtext(text=rxlab, side=1, at=mean(at.right), padj=0.5, line=2.5, cex=cex.lab)
  mtext(text=lxlab, side=1, at=mean(at.left), padj=0.5, line=2.5, cex=cex.lab)

  return(b)   # return the same result as barplot
}



# old version:

# PlotPyramid <- function( x, y, col=c("blue","red"),...) {

  # plot( 1, type="n", xlim=range(pretty(c(-x,y))), ylim=c(0,length(x)), frame.plot=TRUE
    # , xlab="", ylab="", axes=FALSE, ... )
  # abline(v=0)
  # barplot(-x, horiz=TRUE, col=col[1], add=T, names.arg="", space=0, axes=FALSE)
  # barplot(y, horiz=TRUE, col=col[2], add=T, names.arg="", space=0, axes=FALSE)

  # axt <- axTicks(1)
  # print(axt)
  # abline(v=axt, col="grey", lty="dotted")
  # axis(side=1, labels=sprintf("%.0f%s", abs(axt)*100, "%"), at=axt, las=1, cex.axis=0.8)
  # axis(side=2, labels=axTicks(2), at=axTicks(2), las=2, cex.axis=0.8)

# }

# x <- c(0.32,.2,.1,.051,.08,.07,.05,.01)
# y <- c(0.2,.21,.15,.01,.08,.07,.05,.01)
# PlotPyramid(x, y)


###

## plots: PlotCorr ====

PlotCorr <- function(x, cols = colorRampPalette(c(getOption("col1", hred), "white", getOption("col2", hblue)), space = "rgb")(20)
  , breaks = seq(-1, 1, length = length(cols)+1), border="grey", lwd=1
  , args.colorlegend = NULL, xaxt = par("xaxt"), yaxt = par("yaxt"), cex.axis = 0.8, las = 2
  , mar = c(3,8,8,8), ...){

  # example:
  # m <- cor(d.pizza[,WhichNumerics(d.pizza)][,1:5], use="pairwise.complete.obs")
  # PlotCorr(m)
  # PlotCorr(m, args.colorlegend="n", las=1)
  # PlotCorr(m, cols=colorRampPalette(c("red", "white", "blue"), space = "rgb")(4), args.colorlegend=list(xlab=sprintf("%.1f", seq(1,-1, length=5))) )
  # PlotCorr(m, cols=colorRampPalette(c("red", "black", "green"), space = "rgb")(10))

  # PlotCorr(round(CramerV(d.pizza[,c("driver","operator","city", "quality")]),3))

  pars <- par(mar=mar); on.exit(par(pars))

  x <- x[,ncol(x):1]
  image(x=1:nrow(x), y=1:ncol(x), xaxt="n", yaxt="n", z=x, frame.plot=FALSE, xlab="", ylab=""
    , col=cols, breaks=breaks, ... )
  if(xaxt!="n") axis(side=3, at=1:nrow(x), labels=rownames(x), cex.axis=cex.axis, las=las, lwd=-1)
  if(yaxt!="n") axis(side=2, at=1:ncol(x), labels=colnames(x), cex.axis=cex.axis, las=las, lwd=-1)

  if((is.list(args.colorlegend) || is.null(args.colorlegend))){
    args.colorlegend1 <- list( labels=sprintf("%.1f", seq(1,-1, length=length(cols)/2+1))
      , x=nrow(x)+0.5 + nrow(x)/20, y=ncol(x)+0.5
      , width=nrow(x)/20, height=ncol(x), cols=cols, cex=0.8 )
    if ( !is.null(args.colorlegend) ) { args.colorlegend1[names(args.colorlegend)] <- args.colorlegend }

    do.call("ColorLegend", args.colorlegend1)
  }

  if(!is.na(border)) {
    usr <- par("usr")
    rect(xleft=0.5, xright=nrow(x)+0.5, ybottom=0.5, ytop=nrow(x)+0.5,
         lwd=lwd, border=border)
    usr <- par("usr")
    clip(0.5, nrow(x)+0.5, 0.5, nrow(x)+0.5)
    abline(h=seq(-2, nrow(x)+1,1)-0.5, v=seq(1,nrow(x)+1,1)-0.5, col=border,lwd=lwd)
    do.call("clip", as.list(usr))
  }

}

###

## plots: PlotFaces (Chernoff-Faces) ====

# aus TeachingDemos, Author: H. P. Wolf

# *************  Problem mit den Lippen, wenn farbig!!!! CLEARME! ********


PlotFaces <- function( xy = rbind(1:3,5:3,3:5,5:7), which.row, fill = FALSE, nrow, ncol,
              scale = TRUE, byrow = FALSE, main, labels, print.info=FALSE, col=NA){

  #21:
  spline <- function(a, y, m=200, plot=FALSE){
      n<-length(a)
    h<-diff(a)
    dy<-diff(y)
    sigma<-dy/h
    lambda<-h[-1]/(hh<-h[-1]+h[-length(h)])
    mu<-1-lambda
    d<-6*diff(sigma)/hh
    tri.mat<-2*diag(n-2)
    tri.mat[2+  (0:(n-4))*(n-1)] <-mu[-1]
    tri.mat[    (1:(n-3))*(n-1)] <-lambda[-(n-2)]
    M<-c(0,solve(tri.mat)%*%d,0)
    x<-seq(from=a[1],to=a[n],length=m)
    anz.kl <- hist(x,breaks=a,plot=FALSE)$counts
    adj<-function(i) i-1
    i<-rep(1:(n-1),anz.kl)+1
    S.x<-  M[i-1]*(a[i]-x          )^3 / (6*h[adj(i)])  +
           M[i]  *(x        -a[i-1])^3 / (6*h[adj(i)])  +
           (y[i-1] - M[i-1]*h[adj(i)]^2 /6) * (a[i]-x)/ h[adj(i)] +
          (y[i]   - M[i]  *h[adj(i)]^2 /6) * (x-a[i-1]) / h[adj(i)]
    if(plot){ plot(x,S.x,type="l"); points(a,y)    }
    return(cbind(x,S.x))
  }


  if(!identical(col, NA)) col <- rep(col, length.out=11)

  #4:
  n.char <- 15
  xy <- rbind(xy)
  if(byrow) xy <- t(xy)
  if(!missing(which.row)&& all( !is.na(match(which.row,1:dim(xy)[2])) ))
         xy <- xy[,which.row,drop=FALSE]
  mm <- dim(xy)[2]
  n <- dim(xy)[1]
  xnames <- dimnames(xy)[[1]]
  if(is.null(xnames)) xnames <- as.character(1:n)
  if(!missing(labels)) xnames <- labels
  if(scale){
     xy <- apply(xy, 2, function(x){
             x <- x - min(x)
             x <- if(max(x) > 0) { 2*x / max(x) - 1 } else { x } }
           )
  } else xy[] <- pmin(pmax(-1, xy), 1)
  xy <- rbind(xy)
  n.c <- dim(xy)[2]
  xy <- xy[,(h <- rep(1:mm, ceiling(n.char/mm))), drop=FALSE]
  if(fill) xy[, -(1:n.c)] <- 0


  #5:
  face.orig <- list(
        eye   = rbind(c(12,0),c(19,8),c(30,8),c(37,0),c(30,-8),c(19,-8),c(12,0))
       ,iris  = rbind(c(20,0),c(24,4),c(29,0),c(24,-5),c(20,0))
       ,lipso = rbind(c(0,-47),c( 7,-49)
                      ,lipsiend=c( 16,-53),c( 7,-60),c(0,-62))
       ,lipsi = rbind(c(7,-54),c(0,-54))                  # add lipsiend
       ,nose  = rbind(c(0,-6),c(3,-16),c(6,-30),c(0,-31))
       ,shape = rbind(c(0,44),c(29,40),c(51,22)
                   ,hairend = c(54,11)
                   ,earsta  = c(52,-4)
                   ,earend=c(46,-36)
                   ,c(38,-61), c(25,-83), c(0,-89))
       ,ear   = rbind(c(60,-11),c(57,-30))                # add earsta,earend
       ,hair  = rbind( hair1 = c(72,12), hair2 = c(64,50), c(36,74), c(0,79)) # add hairend
  )
  lipso.refl.ind <- 4:1
  lipsi.refl.ind <- 1
  nose.refl.ind  <- 3:1
  hair.refl.ind  <- 3:1
  shape.refl.ind <- 8:1
  shape.xnotnull <- 2:8
  nose.xnotnull  <- 2:3

  #2:
  nr <- n^0.5
  nc <- n^0.5
  if(!missing(nrow)) nr <- nrow
  if(!missing(ncol)) nc <- ncol
  opar <- par(mfrow = c(ceiling(c(nr,nc))), oma = rep(6,4), mar = rep(.7,4))
  on.exit(par(opar))


  #6:
  for(ind in 1:n){

    #7: ind <- 1
    factors <- xy[ind,]
    face <- face.orig

    #9:
    m <- mean(face$lipso[,2])
    face$lipso[,2] <- m + (face$lipso[,2] - m) * (1 + 0.7 * factors[4])
    face$lipsi[,2] <- m + (face$lipsi[,2] - m) * (1 + 0.7 * factors[4])
    face$lipso[,1] <- face$lipso[,1] * (1 + 0.7 * factors[5])
    face$lipsi[,1] <- face$lipsi[,1] * (1 + 0.7 * factors[5])
    face$lipso["lipsiend", 2] <- face$lipso["lipsiend", 2] + 20 * factors[6]

    #10:
    m <- mean(face$eye[,2])
    face$eye[,2] <- m+(face$eye[,2] -m)*(1+0.7*factors[7])
    face$iris[,2] <- m+(face$iris[,2]-m)*(1+0.7*factors[7])
    m <- mean(face$eye[,1])
    face$eye[,1] <- m+(face$eye[,1] -m)*(1+0.7*factors[8])
    face$iris[,1] < -m+(face$iris[,1]-m)*(1+0.7*factors[8])

    #11:
    m <- min(face$hair[,2])
    face$hair[,2] <- m+(face$hair[,2]-m)*(1+0.2*factors[9])
    m <- 0
    face$hair[,1] <- m+(face$hair[,1]-m)*(1+0.2*factors[10])
    m <- 0
    face$hair[c("hair1","hair2"),2] <- face$hair[c("hair1","hair2"),2]+50*factors[11]

    #12:
    m <- mean(face$nose[,2])
    face$nose[,2] <- m+(face$nose[,2]-m)*(1+0.7*factors[12])
    face$nose[nose.xnotnull,1] <- face$nose[nose.xnotnull,1]*(1+factors[13])

    #13:
    m <- mean(face$shape[c("earsta","earend"),1])
    face$ear[,1] <- m+(face$ear[,1]-m)* (1+0.7*factors[14])
    m <- min(face$ear[,2])
    face$ear[,2] <- m+(face$ear[,2]-m)* (1+0.7*factors[15])

    #8:
    face <- lapply(face, function(x){ x[,2]<-x[,2]*(1+0.2*factors[1]);x})
    face <- lapply(face, function(x){ x[,1]<-x[,1]*(1+0.2*factors[2]);x})
    face <- lapply(face, function(x){ x[,1] <- ifelse( x[,1]>0,
                                                 ifelse(x[,2] > -30, x[,1], pmax(0,x[,1]+(x[,2]+50)*0.2*sin(1.5*(-factors[3]))))
                                               ,0)
                                               x}
                   )

    invert <- function(x) cbind( -x[,1] ,x[,2] )

    face.obj <- list(
          hair = rbind(face$shape["hairend", ], face$hair, invert(face$hair[hair.refl.ind, ]),
                         invert(face$shape["hairend", , drop = FALSE]))
        , shape = rbind(face$shape, invert(face$shape[shape.refl.ind, ]))
        , eyer = face$eye
        , irisr = face$iris
        , eyel = invert(face$eye)
        , irisl = invert(face$iris)
        , lipso = rbind(face$lipso, invert(face$lipso[lipso.refl.ind, ]))
        , lipsi = rbind(face$lipso["lipsiend", ], face$lipsi,
                     invert(face$lipsi[lipsi.refl.ind, , drop = FALSE]),
                     invert(face$lipso["lipsiend", , drop = FALSE]))
        , earr = rbind(face$shape["earsta", ], face$ear, face$shape["earend", ])
        , earl = invert(rbind(face$shape["earsta", ], face$ear, face$shape["earend", ]))
        , nose = rbind(face$nose, invert(face$nose[nose.refl.ind, ]))
    )

    plot(1, type="n", xlim=c(-105,105) * 1.1, axes=FALSE, ylab="", ylim=c(-105,105) * 1.3 )
    title(xnames[ind])

    for(ind in seq(face.obj)) {
           x <- face.obj[[ind]][,1]
           y <- face.obj[[ind]][,2]
           xx <- spline(1:length(x), x, 40, FALSE)[,2]
           yy <- spline(1:length(y), y, 40, FALSE)[,2]

           if(identical(col, NA)){
             lines(xx, yy)
           } else {
             polygon(xx, yy, col=col[ind])
           }
    }

  }

  info <- c(var1 = "height of face   ", var2 = "width of face    ",
            var3 = "structure of face", var4 = "height of mouth  ",
            var5 = "width of mouth   ", var6 = "smiling          ",
            var7 = "height of eyes   ", var8 = "width of eyes    ",
            var9 = "height of hair   ", var10 = "width of hair   ",
            var11 = "style of hair   ", var12 = "height of nose  ",
            var13 = "width of nose   ", var14 = "width of ear    ",
            var15 = "height of ear   ")
  var.names <- dimnames(xy)[[2]]
#   if (0 == length(var.names))
#     var.names <- paste("Var", rows.orig, sep = "")
  info <- cbind(`modified item` = info, Var = var.names[1:length(info)])
  rownames(info) <- rep("", 15)

  if(print.info){
    cat("effect of variables:\n")
    print(info)
  }

  if(!missing(main)){
    par(opar)
    par(mfrow=c(1,1))
    mtext(main, 3, 3, TRUE, 0.5)
    title(main)
  }

}



###

## plots: PlotViolin ====


PlotViolin <- function(x, ...) {
  UseMethod("PlotViolin")
}



PlotViolin.default <- function (x, ..., horizontal = FALSE, bw = "SJ", na.rm = FALSE
                                , names = NULL, args.boxplot = NULL)  {

  # Make a simple violin plot call from violinplot. values are x,y to plot
  vlnplt <-  function(x, y, center, horizontal = FALSE,
                      col = NA , border = par("fg"), lty = 1, lwd = 1,
                      density = NULL, angle = 45, fillOddEven = FALSE, ...) {
      # double up first
      x <- c(x, rev(x))
      y <- c(y, -rev(y))
      y <- y + center

      # swap x and y if horizontal
      if (horizontal == FALSE) { tmp=x; x=y; y=tmp }

      polygon(x=x, y=y, border=border, col=col, lty=lty, lwd=lwd,
              density=density, angle=angle, fillOddEven=fillOddEven, ...)
    }


  # main *****************

  m <- match.call(expand.dots = FALSE)
  pars <- m$...[ names(m$...)[!is.na(match(names(m$...), c(
    "cex","cex.axis","cex.lab","cex.main","cex.sub","col.axis","col.lab","col.main","col.sub","family",
    "font","font.axis","font.lab","font.main","font.sub","las","tck","tcl","xaxt","xpd","yaxt"
  )))]]
  oldpar <- par(pars); on.exit(par(oldpar))

  args <- list(x, ...)
  namedargs <- if (!is.null(attributes(args)$names))
                 attributes(args)$names != ""
               else
                 rep(FALSE, length = length(args))

  groups <- if(is.list(x)) x else args[!namedargs]

  if (0 == (n <- length(groups)))
      stop("invalid first argument")
  if (length(class(groups)))
      groups <- unclass(groups)
  if (!missing(names))
      attr(groups, "names") <- names
  else {
      if (is.null(attr(groups, "names")))
          attr(groups, "names") <- 1:n
      names <- attr(groups, "names")
  }

  xvals <- matrix(0, nrow = 512, ncol = n)
  yvals <- matrix(0, nrow = 512, ncol = n)
  center <- 1:n
  for (i in 1:n) {
      if(na.rm) xi <- na.omit(groups[[i]])
        else xi <- groups[[i]]
      tmp.dens <- density(xi, bw = bw)
      xvals[, i] <- tmp.dens$x
      yvals.needtoscale <- tmp.dens$y
      yvals.scaled <- 7/16 * yvals.needtoscale / max(yvals.needtoscale)
      yvals[, i] <- yvals.scaled
  }
  if (horizontal == FALSE) {
      xrange <- c(1/2, n + 1/2)
      yrange <- range(xvals)
  }
  else {
      xrange <- range(xvals)
#      yrange <- c(min(yvals), max(yvals))
      yrange <- c(1/2, n + 1/2)
  }


  plot.args <- m$...[names(m$...)[!is.na(match(names(m$...),
     c("xlim","ylim","main","xlab","ylab","panel.first","panel.last","frame.plot","add")))]]
  if(! "xlim" %in% names(plot.args)) plot.args <- c(plot.args, list(xlim=xrange))
  if(! "ylim" %in% names(plot.args)) plot.args <- c(plot.args, list(ylim=yrange))
  if(! "xlab" %in% names(plot.args)) plot.args <- c(plot.args, list(xlab=""))
  if(! "ylab" %in% names(plot.args)) plot.args <- c(plot.args, list(ylab=""))
  if(! "frame.plot" %in% names(plot.args)) plot.args <- c(plot.args, list(frame.plot=TRUE))

  # plot only if add is not TRUE
  if(! "add" %in% names(plot.args)) add <- FALSE else add <- plot.args$add
  if(!add) do.call(plot, c(plot.args, list(x=0, y=0, type="n", axes=FALSE)))

  # poly.args <- m$...[names(m$...)[!is.na(match(names(m$...), c("border","col","lty","density","angle","fillOddEven")))]]
  # neu:
  poly.args <- args[names(args)[!is.na(match(names(args), c("border","col","lty","lwd","density","angle","fillOddEven")))]]
  poly.args <- lapply( poly.args, rep, length.out=n )

  for (i in 1:n)
#      do.call(vlnplt, c(poly.args[i], list(x=xvals[, i]), list(y=yvals[, i]),
#                        list(center=center[i]), list(horizontal = horizontal)))
      do.call(vlnplt, c(lapply(poly.args, "[", i), list(x=xvals[, i]), list(y=yvals[, i]),
                        list(center=center[i]), list(horizontal = horizontal)))

  axes <- Coalesce(unlist(m$...[names(m$...)[!is.na(match(names(m$...), c("axes")))]]), TRUE)
  if(axes){
    xaxt <- Coalesce(unlist(m$...[names(m$...)[!is.na(match(names(m$...), c("xaxt")))]]), TRUE)
    if(xaxt!="n") if(horizontal == TRUE) axis(1) else axis(1, at = 1:n, labels = names)

    yaxt <- Coalesce(unlist(m$...[names(m$...)[!is.na(match(names(m$...), c("yaxt")))]]), TRUE)
    if(yaxt!="n") if(horizontal == TRUE)  axis(2, at = 1:n, labels = names) else axis(2)
  }

  if(!identical(args.boxplot, NA)){

    args1.boxplot <- list(col="black", add=TRUE, boxwex=0.05, axes=FALSE,
       outline=FALSE, whisklty=1, staplelty=0, medcol="white")
    args1.boxplot[names(args.boxplot)] <- args.boxplot

    do.call(boxplot, c(list(x, horizontal = horizontal), args1.boxplot))

  }

}


# PlotViolin.formula <- function (formula, data = NULL, ..., subset) {
PlotViolin.formula <- function (formula, data, subset, na.action, ...) {

    if (missing(formula) || (length(formula) != 3))
        stop("formula missing or incorrect")
    m <- match.call(expand.dots = FALSE)
    if (is.matrix(eval(m$data, parent.frame())))
        m$data <- as.data.frame(data)
    m$... <- NULL

    m[[1]] <- as.name("model.frame")
    mf <- eval(m, parent.frame())
    response <- attr(attr(mf, "terms"), "response")

    PlotViolin(split(mf[[response]], mf[-response]), ...)
}


###

## plots: PlotPolar ====


PlotPolar <- function(r, theta = NULL, type="p"
  , rlim = NULL, main="", lwd = par("lwd"), lty = par("lty"), col = par("col")
  , pch = par("pch"), fill = NA, cex = par("cex")
  , mar = c(2, 2, 5, 2), add = FALSE, ...) {


  if( ncol(r <- as.matrix(r)) == 1) r <- t(r)
  k <- nrow(r)

  if(is.null(theta)) {
    theta <- seq(0, 2*pi, length=ncol(r)+1)[-(ncol(r)+1)]
    if( nrow(r) > 1 ){
      theta <- matrix( rep(theta, times=nrow(r)), ncol=ncol(r), byrow = TRUE )
    }  else {
      theta <- t(as.matrix(theta))
    }
  } else {
    if( ncol(theta <- as.matrix(theta)) == 1) theta <- t(theta)
  }

  # kang <- ncol(theta <- as.matrix(theta))
  # n <- nrow(r)
  # ### if (n != nrow(theta))
      # ### stop("'r' and 'theta' must have same number of rows")
  # if (kr > 1 && kang > 1 && kr != kang)
      # stop("'r' and 'theta' must have only 1 or the same number of columns")
  # if (kr == 1)
      # r <- matrix(r, nrow = n, ncol = kang)
  # if (kang == 1)
      # theta <- matrix(theta, nrow = n, ncol = kr)


  if (length(type) < k) type <- rep(type, length.out = k)
  if (length(lty) < k)  lty <- rep(lty, length.out = k)
  if (length(lwd) < k)  lwd <- rep(lwd, length.out = k)
  if (length(pch) < k)  pch <- rep(pch, length.out = k)
  if (length(col) < k)  col <- rep(col, length.out = k)
  if (length(fill) < k) fill <- rep(fill, length.out = k)
  if (length(cex) < k)  cex <- rep(cex, length.out = k)

  dev.hold()
  on.exit(dev.flush())

  # definition follows plot.default()
  rlim <- if (is.null(rlim)) max(abs(r[is.finite(r)]))*1.12
  if(!add){
    par(mar = mar, pty = "s", xpd=TRUE)
    plot(x=c(-rlim, rlim), y=c(-rlim, rlim),
      type = "n", axes = FALSE, main = main, xlab = "", ylab = "", ...)
  }

  for (i in seq_len(k)) {
    xy <- xy.coords( x=cos(theta[i,]) * r[i,], y=sin(theta[i,])*r[i,])
    if(type[i] == "p"){
      points( xy, pch = pch[i], col = col[i], cex = cex[i] )
    } else if( type[i]=="l") {
      polygon(xy, lwd = lwd[i], lty = lty[i], border = col[i], col = fill[i])
    } else if( type[i]=="h") {
      segments(x0=0, y0=0, x1=xy$x, y1=xy$y, lwd = lwd[i], lty = lty[i], col = col[i])
    }
  }
}



PolarGrid <- function(nr = NULL, ntheta = NULL, col = "lightgray"
  , lty = "dotted", lwd = par("lwd"), rlabels = NULL, alabels = NULL, lblradians = FALSE) {

  if (is.null(nr)) {             # use standard values with pretty axis values
      # at <- seq.int(0, par("xaxp")[2L], length.out = 1L + abs(par("xaxp")[3L]))
      at <- axTicks(1)[axTicks(1)>=0]
  } else if (!all(is.na(nr))) {  # use NA for suppress radial gridlines
    if (length(nr) > 1) {        # use nr as radius
      at <- nr
    } else {
      at <- seq.int(0, par("xaxp")[2L], length.out = nr + 1)#[-c(1, nr + 1)]
    }
  } else {at <- NULL}
  if(!is.null(at)) DrawCircle(0, 0, at, border = col, lty = lty, col = NA)

  if (is.null(ntheta)) {             # use standard values with pretty axis values
      at.ang <- seq(0, 2*pi, by=2*pi/12)
  } else if (!all(is.na(ntheta))) {  # use NA for suppress radial gridlines
    if (length(ntheta) > 1) {        # use ntheta as angles
      at.ang <- ntheta
    } else {
      at.ang <- seq(0, 2*pi, by=2*pi/ntheta)
    }
  } else {at.ang <- NULL}
  if(!is.null(at.ang)) segments(x0=0, y0=0, x1=max(par("usr"))*cos(at.ang)
    , y1=max(par("usr"))*sin(at.ang), col = col, lty = lty, lwd = lwd)

  # plot radius labels
  if(!is.null(at)){
    if(is.null(rlabels)) rlabels <- signif(at[-1],3)   # standard values
    if(!all(is.na(rlabels))) BoxedText( x=at[-1], y=0, labels=rlabels, border=FALSE, col="white")
  }

  # plot angle labels
  if(!is.null(at.ang)){
    if(is.null(alabels))
      if( lblradians == FALSE ){
        alabels <- RadToDeg(at.ang[-length(at.ang)])   # standard values in degrees
      } else {
        alabels <- Format(at.ang[-length(at.ang)], digits=2)   # standard values in radians
      }
    if(!all(is.na(alabels)))
      BoxedText( x=par("usr")[2]*1.07*cos(at.ang)[-length(at.ang)], y=par("usr")[2]*1.07*sin(at.ang)[-length(at.ang)]
        , labels=alabels, border=FALSE, col="white")
  }

}

###


## plots: PlotTernary =====

# clumsy *****************

# PlotTernary <- function(a, f, m, symb = 2, grid = FALSE, ...) {
#
#   # source: cwhmisc:::triplot
#   # author: Christian Hoffmann
#
#
#   .trigrid <- function(grid = FALSE) {
#
#     lines(c(0, 50, 100, 0), c(0, 87.8, 0, 0))  #draw frame
#     if(!grid) {
#       for(i in 1:4 * 20) {
#         lines(c(i, i - 1), c(0, 2 * .878))	#side a-c (base)
#         lines(c(i, i + 1), c(0, 2 * .878))
#         T.j <- i/2	#side a-b (left)
#         lines(c(T.j, T.j + 2), c(i * .878, i * .878))
#         lines(c(T.j, T.j + 1), c(i * .878, (i - 2) * .878))
#         T.j <- 100 - i/2	#side b-c (right)
#         lines(c(T.j, T.j - 2), c(i * .878, i * .878))
#         lines(c(T.j, T.j - 1), c(i * .878, (i - 2) * .878))
#       }
#     }
#     else {
#       for(i in 1:4 * 20) {
#         # draw dotted grid
#         lines(c(i, i/2), c(0, i * .878), lty = 4, col = 3)	#
#         lines(c(i, (50 + i/2)), c(0, .878 * (100 - i)), lty = 4,
#               col = 3)	# /
#         lines(c(i/2, (100 - i/2)), c(i * .878, i * .878), lty
#               = 4, col = 3)	# -
#       }
#       par(lty = 1, col = 1)
#     }
#   }
#
#
#   ta <- paste(substitute(a))
#   tf <- paste(substitute(f))
#   tm <- paste(substitute(m))
#   tot <- 100/(a + f + m)
#   b <- f * tot
#   y <- b * .878
#   x <- m * tot + b/2
#   par(pty = "s")
#   oldcol <- par("col")
#   plot(x, y, axes = FALSE, xlab = "", ylab = "", xlim = c(-10, 110),
#        ylim = c(-10, 110), type = "n", ...)
#   points(x,y,pch=symb)
#   par(col = oldcol)
#
#   .trigrid(grid)
#
#   text(-5, -5, ta)
#   text(105, -5, tm)
#   text(50, 93, tf)
#
#   par(pty = "m")
#   invisible()
#
# }
#



PlotTernary <- function(x, y = NULL, z = NULL, args.grid=NULL, lbl = NULL, main = "", ...){


  if(!(is.null(y) && is.null(z))){
    if(is.null(lbl)) lbl <- c(names(x), names(y), names(z))
    x <- cbind(x, y, z)
  } else {
    if(is.null(lbl)) lbl <- colnames(x)
    x <- as.matrix(x)
  }

  if(any(x < 0)) stop("X must be non-negative")
  s <- drop(x %*% rep(1, ncol(x)))
  if(any(s<=0)) stop("each row of X must have a positive sum")
  if(max(abs(s-1)) > 1e-6) {
    warning("row(s) of X will be rescaled")
    x <- x / s
  }

  oldpar <- par(xpd=TRUE)
  on.exit(par(oldpar))
  Canvas(mar=c(1,3,4,1) + .1, main=main)

  sq3 <- sqrt(3)/2

  # grid: define default arguments
  if(!identical(args.grid, NA)){
    args.grid1 <- list(col="grey", lty="dotted", nx=5)
    # override default arguments with user defined ones
    if (!is.null(args.grid)) {
      args.grid1[names(args.grid)] <- args.grid
    }

    d <- seq(0, 2*sq3, sq3*2/(args.grid1$nx))
    x0 <- -sq3 + (1) * d
    segments(x0 = x0, y0 = -0.5, x1 = x0 + sq3 - d*.5, y1 = 1- d * sq3, col=args.grid1$col, lty=args.grid1$lty)
    segments(x0 = x0, y0 = -0.5, x1 = -rev(x0 + sq3 - d*.5), y1 = rev(1- d * sq3), col=args.grid1$col, lty=args.grid1$lty)
    segments(x0 = x0 + sq3 - d*.5, y0 = 1- d * sq3, x1 = rev(x0 -d*.5), y1 = 1- d * sq3, col=args.grid1$col, lty=args.grid1$lty)
  }

  DrawRegPolygon(nv = 3, rot = pi/2, radius.x = 1, col=NA)

  eps <-0.15
  pts <- DrawRegPolygon(nv = 3, rot = pi/2, radius.x = 1+eps, plot=FALSE)[[1]]

  text(pts, labels = lbl[c(1,3,2)])

  points((x[,2] - x[,3]) * sq3, x[,1] * 1.5 - 0.5, ...)

}




## plots: PlotVenn ====


PlotVenn <- function (x, col = "transparent", plotit = TRUE, labels = NULL) {

  n <- length(x)

  if (n > 5)
    stop("Can't plot a Venn diagram with more than 5 sets...")

  xnames <- if(is.null(names(x))) LETTERS[1:n] else names(x)
  if(is.null(labels)) labels <- xnames

  tab <- table(unlist(x), unlist(lapply(1:length(x), function(i) rep(LETTERS[i], length(x[[i]])))))
  venntab <- table(apply(tab, 1, function(x) paste(LETTERS[1:n][as.logical(x)], collapse = "")))

  if (plotit) {

    plot(x = c(-7, 7), y = c(-7, 7), asp = 1, type = "n",
         xaxt = "n", yaxt = "n", xlab = "", ylab = "", frame.plot = FALSE)

    if (n == 2) {
      DrawCircle(x = c(2, -2), y = c(0, 0), radius = 3,
                 col = col)
      xy <- data.frame(x = c(-3, 3, 0), y = c(0, 0, 0),
                       set = c("A", "B", "AB")
                       , frq=NA)
      xy[match(rownames(venntab), xy$set),"frq"] <- venntab
      text(xy$x, xy$y, labels=xy$frq) # labels=xy$set)

      lbl <- data.frame(x = c(-6, 6), y = c(2.5, 2.5))
      text(lbl$x, lbl$y, label = labels, cex = 2)

    }
    else if (n == 3) {
      DrawCircle(x = c(2, -1, -1), y = c(0, 1.73, -1.73),
                 radius = 3, col = col)
      xy <- data.frame(x = c(3.5, -1.75, -1.75, 1, -2, 1, 0),
                       y = c(0, 3, -3, 1.75, 0, -1.75, 0),
                       set = c("A", "B", "C", "AB", "BC", "AC", "ABC")
                      , frq=NA)

      xy[match(rownames(venntab), xy$set),"frq"] <- venntab
      text(xy$x, xy$y, labels=xy$frq) # labels=xy$set)

      lbl <- data.frame(x = c(6.5, -4.5, -4.5), y = c(0,4.8,-4.8))
      text(lbl$x, lbl$y, label = labels, cex = 2)

    }
    else if (n == 4) {
      DrawEllipse(x = c(0, 0, 2, -2), y = c(0, 0, -2, -2),
                  radius.x = 6, radius.y = 4, rot = c(1, 3) * pi/4,
                  col = col)
      xy <- data.frame(x=c(-6.0,-4.0,-2.2,0.0,2.2,3.9,5.9,4.3,2.7,-3.1,-4.3,-2.6,-0.1,2.7,0.0)
                       , y=c(0.3,-2.9,-4.2,-5.7,-4.2,-2.9,0.2,2.3,4.2,4.0,2.3,0.9,-1.6,0.8,3.4)
                       , set=c("A","AC","ACD","AD","ABD","BD","D","CD","C","B","AB","ABC","ABCD","BCD","BC")
                       , frq=NA  )
      xy[match(rownames(venntab), xy$set),"frq"] <- venntab
      text(xy$x, xy$y, labels=xy$frq) # labels=xy$set)

      lbl <- data.frame(x = c(-8, -4.4, 4.5, 7.7), y = c(1.9, 5.4, 5.5, 2.5))
      text(lbl$x, lbl$y, label = labels, cex = 2)

    }
    else if (n == 5) {
      DrawEllipse(x=c(0,-1.5,-2,0,1), y=c(0,0,-2,-2.5,-1), radius.x=6, radius.y=3, rot=c(1.7,2.8,4.1,5.4,6.6), col=col)
      xy <- data.frame(x=c(4.9,-0.7,-5.9,-4.3,3.1, 3.6,2.4,0.9,-2.3,-3.8,-4.7,-3.9,-1.5,1.2,3.3,  2.6,1.8,1.2,-0.5,-2.7,-3.7,-4.3,-2.6,-0.9,0.9,3.4,  2.1,-2.1,-3.4,-0.9,-0.5   )
                       , y=c(0.5,4.5,1.7,-5.5,-6.1,  -1.1,1.8,2.7,2.9,1.5,-1.1,-3.1,-5,-4.7,-3.1,  0.1,2,1.4,2.4,2.2,0.2,-1.6,-3.3,-4.7,-3.8,-2.5,  -2.1,1.5,-1.3,-3.8,-0.8 )
                       , set=c("B","A","E","D","C",  "BE","AB","AD","AE","CE","DE","BD","CD","AC","BC"
                               ,"ABE","ABD", "ABDE","ADE","ACE","CDE","BDE","BCD","ACD","ABC","BCE", "ABCE","ACDE","BCDE","ABCD","ABCDE" )
                       , frq=NA  )
      xy[match(rownames(venntab), xy$set),"frq"] <- venntab
      text(xy$x, xy$y, labels=xy$frq) # labels=xy$set)

      lbl <- data.frame(x=c(1.8,7.6,5.8,-7.5,-7.9), y=c(6.3,-0.8,-7.1,-6.8,3.9))
      text( lbl$x, lbl$y, label=labels, cex=2)

    }

    xy$setx <- xy$set

    # replace AB.. by names of the list
    code <- data.frame(id=LETTERS[1:n], x=xnames)
    levels(xy$setx) <- sapply(levels(xy$setx), function(x) paste(code$x[match(unlist(strsplit(x, split="")), code$id)], collapse=""))
    names(venntab) <- sapply(names(venntab), function(x) paste(code$x[match(unlist(strsplit(x, split="")), code$id)], collapse=""))

  }
  else {
    xy <- NA
  }

  return(list(venntab, xy))
}


###

## plots: PlotHorizBar (GanttChart)  ----------



# info2 <- list(labels=c("Jim","Joe","Jim","John","John","Jake","Joe","Jed","Jake"),
  # starts=c(8.1,8.7,13.0,9.1,11.6,9.0,13.6,9.3,14.2),
  # ends=c(12.5,12.7,16.5,10.3,15.6,11.7,18.1,18.2,19.0))


PlotHorizBar <- function (from, to, grp = 1, col = "lightgrey", border = "black",
                          height = 0.6, add = FALSE, xlim = NULL, ylim = NULL, ...)  {

  # needed?? 6.5.2014
  # if (is.null(dev.list()))  plot.new()

  grp <- factor(grp)

  if(!add){
    if(is.null(xlim)) xlim <- range(pretty((c(from, to))))
    if(is.null(ylim)) ylim <- c(0, nlevels(grp) + 1)
    plot(1, xlim = xlim, ylim = ylim,
         type = "n", ylab = "", yaxt = "n", ...)
  }
  xleft <- from
  xright <- to
  ytop <- as.numeric(grp) + height/2
  ybottom <- as.numeric(grp) - height/2
  rect(xleft, ybottom, xright, ytop, density = NULL, angle = 45,
       col = col, border = border, lty = par("lty"), lwd = par("lwd"))

}




###

## plots: PlotTreemap ====

# the code is strongly based on Jeff Enos' treemap in library(portfolio), jeff@kanecap.com,

# potential improvements:
#   * make the position of the text more flexible (top-left, bottom-right etc.)
#   * clip text to the specific rectangles and don't allow to write over the rect.
#   * see examples at http://www.hiveondemand.com/portal/treemap_basics.jsp


PlotTreemap <- function(x, grp=NULL, labels=NULL, cex=1.0, text.col="black", col=rainbow(length(x)),
                        labels.grp=NULL, cex.grp=3, text.col.grp="black", border.grp="grey50",
                        lwd.grp=5, main="") {

  SqMap <- function(x) {

    .sqmap <- function(z, x0 = 0, y0 = 0, x1 = 1, y1 = 1, lst=list()) {

      cz <- cumsum(z$area)/sum(z$area)
      n <- which.min(abs(log(max(x1/y1, y1/x1) * sum(z$area) * ((cz^2)/z$area))))
      more <- n < length(z$area)
      a <- c(0, cz[1:n])/cz[n]
      if (y1 > x1) {
        lst <- list( data.frame(idx=z$idx[1:n],
                                x0=x0 + x1 * a[1:(length(a) - 1)],
                                y0=rep(y0, n), x1=x0 + x1 * a[-1], y1=rep(y0 + y1 * cz[n], n)))
        if (more) {
          lst <- append(lst, Recall(z[-(1:n), ], x0, y0 + y1 * cz[n], x1, y1 * (1 - cz[n]), lst))
        }
      } else {
        lst <- list( data.frame(idx=z$idx[1:n],
                                x0=rep(x0, n), y0=y0 + y1 * a[1:(length(a) - 1)],
                                x1=rep(x0 + x1 * cz[n], n), y1=y0 + y1 * a[-1]))
        if (more) {
          lst <- append(lst, Recall(z[-(1:n), ], x0 + x1 * cz[n], y0, x1 * (1 - cz[n]), y1, lst))
        }
      }
      lst
    }

    # z <- data.frame(idx=seq_along(z), area=z)
    if(is.null(names(x))) names(x) <- seq_along(x)
    x <- data.frame(idx=names(x), area=x)
    res <- do.call(rbind, .sqmap(x))
    rownames(res) <- x$idx
    return(res[,-1])

  }


  PlotSqMap <- function(z, col = NULL, border=NULL, lwd=par("lwd"), add=FALSE){
    if(is.null(col)) col <- as.character(z$col)
    # plot squarified treemap
    if(!add) Canvas(c(0,1), xpd=TRUE)
    for(i in 1:nrow(z)){
      rect(xleft=z[i,]$x0, ybottom=z[i,]$y0, xright=z[i,]$x1, ytop=z[i,]$y1,
           col=col[i], border=border, lwd=lwd)
    }
  }


  if(is.null(grp)) grp <- rep(1, length(x))
  if(is.null(labels)) labels <- names(x)

  # we need to sort the stuff
  ord <- order(grp, -x)
  x <- x[ord]
  grp <- grp[ord]
  labels <- labels[ord]
  col <- col[ord]


  # get the groups rects first
  zg <- SqMap(Sort(tapply(x, grp, sum), decreasing=TRUE))
  # the transformation information: x0 translation, xs stretching
  tm <- cbind(zg[,1:2], xs=zg$x1 - zg$x0, ys=zg$y1 - zg$y0)
  gmidpt <- data.frame(x=apply(zg[,c("x0","x1")], 1, mean),
                       y=apply(zg[,c("y0","y1")], 1, mean))

  if(is.null(labels.grp))
    if(nrow(zg)>1) {
      labels.grp <- rownames(zg)
    } else {
      labels.grp <- NA
    }

  Canvas(c(0,1), xpd=TRUE, asp=NA, main=main)

  res <- list()

  for( i in 1:nrow(zg)){

    # get the group index
    idx <- grp == rownames(zg)[i]
    xg.rect <- SqMap(Sort(x[idx], decreasing=TRUE))

    # transform
    xg.rect[,c(1,3)] <- xg.rect[,c(1,3)] * tm[i,"xs"] + tm[i,"x0"]
    xg.rect[,c(2,4)] <- xg.rect[,c(2,4)] * tm[i,"ys"] + tm[i,"y0"]

    PlotSqMap(xg.rect, col=col[idx], add=TRUE)

    res[[i]] <- list(grp=gmidpt[i,],
                     child= cbind(x=apply(xg.rect[,c("x0","x1")], 1, mean),
                                  y=apply(xg.rect[,c("y0","y1")], 1, mean)))

    text( x=apply(xg.rect[,c("x0","x1")], 1, mean),
          y=apply(xg.rect[,c("y0","y1")], 1, mean),
          labels=labels[idx], cex=cex, col=text.col )
  }

  names(res) <- rownames(zg)

  PlotSqMap(zg, col=NA, add=TRUE, border=border.grp, lwd=lwd.grp)

  text( x=apply(zg[,c("x0","x1")], 1, mean),
        y=apply(zg[,c("y0","y1")], 1, mean),
        labels=labels.grp, cex=cex.grp, col=text.col.grp)

  invisible(res)

}





###

## plots: PlotBag ====


####################################"
# the source code for the function
# from Hans Peter Wolf
#
# http://www.wiwi.uni-bielefeld.de/~wolf/software/R-wtools/bagplot/bagplot.R
#
#
##start:##


PlotBagPairs <- function(dm, trim = 0.0, main, numeric.only = TRUE,
                         factor = 3, approx.limit = 300, pch = 16,
                         cex = 0.8, precision = 1, col.loophull = "#aaccff",
                         col.looppoints = "#3355ff", col.baghull = "#7799ff",
                         col.bagpoints = "#000088", ...){
  if(missing(main)) main <- paste(deparse(substitute(dm)),"/ trim =",round(trim,3))
  if(length(trim) == 1) trim <- rep(trim, ncol(dm))
  if(numeric.only){
    dm <- dm[, idx <- sapply(1:ncol(dm), function(x) is.numeric(dm[,x]))]
    trim <- trim[idx]
  }
  for(j in 1:ncol(dm)){
    x <- dm[,j]
    if(!is.numeric(x)) x <- as.numeric(x)
    if( trim[j] > 0) {
      na.idx <- is.na(x)
      xlim <- quantile(x[!na.idx], c(trim[j] , 1-trim[j]))
      x[ na.idx |  x < xlim[1] | xlim[2] < x ] <- NA
    }
    dm[,j] <- x
  }
  # DM0 <<- dm
  h.fn <- function(x,y){
    idx <- !is.na(x) & !is.na(y)
    x <- x[ idx ]; y <- y[ idx ]
    BP <- PlotBag(x,y,add=TRUE,factor = factor, approx.limit = approx.limit, pch = pch,
                  cex = cex, precision = precision, col.loophull = col.loophull,
                  col.looppoints = col.looppoints, col.baghull = col.baghull,
                  col.bagpoints = col.bagpoints, verbose=FALSE)
    # BP <<- BP ### for debugging
  }
  par(mfrow=c(1,1))
  pairs(dm, panel = h.fn, ...)
  mtext(main, line=2.5)
  dm
}

#0:
##start:##
compute.bagplot <- function(x,y,
                            factor=3, # expanding factor for bag to get the loop
                            na.rm=FALSE, # should NAs removed or exchanged
                            approx.limit=300, # limit
                            dkmethod=2, # in 1:2; method 2 is recommended
                            precision=1, # controls precision of computation
                            verbose=FALSE,debug.plots="no" # tools for debugging
){

  "bagplot, version 2012/12/05, peter wolf"


  # define some functions
  win<-function(dx,dy){  atan2(y=dy,x=dx) }
  out.of.polygon<-function(xy,pg){  # 121026
    xy<-matrix(xy,ncol=2)
    # check trivial case
    if(nrow(pg)==1)  return(xy[,1]==pg[1] & xy[,2]==pg[2])
    # store number of points of xy and polygon
    m<-nrow(xy); n<-nrow(pg)
    # find small value relative to polygon
    limit <- -abs(1E-10*diff(range(pg)))
    # find vectors that are orthogonal to segments of polygon
    pgn<-cbind(diff(c(pg[,2],pg[1,2])),-diff(c(pg[,1],pg[1,1])))
    # find center of gravity of xy
    S<-colMeans(xy)
    # compute negative distances of polygon to center of gravity of xy
    dxy<-cbind(S[1]-pg[,1],S[2]-pg[,2])
    # unused: S.in.pg<-all(limit<apply(dxy*pgn,1,sum))
    if( !all( limit < apply(dxy*pgn,1,sum) ) ){
      pg<-pg[n:1,]; pgn<--pgn[n:1,]
    }
    # initialize result
    in.pg<-rep(TRUE,m)
    for(j in 1:n){
      dxy<-xy-matrix(pg[j,],m,2,byrow=TRUE)
      in.pg<-in.pg & limit<(dxy%*%pgn[j,])
    }
    return(!in.pg)
  }
  cut.z.pg<-function(zx,zy,p1x,p1y,p2x,p2y){
    a2<-(p2y-p1y)/(p2x-p1x); a1<-zy/zx
    sx<-(p1y-a2*p1x)/(a1-a2); sy<-a1*sx
    sxy<-cbind(sx,sy)
    h<-any(is.nan(sxy))||any(is.na(sxy))||any(Inf==abs(sxy))
    if(h){ # print("NAN found"); print(cbind(a1,a2,zx,zy,sxy,p2x-p1x))
      if(!exists("verbose")) verbose<-FALSE
      if(verbose) cat("special")
      # zx is zero ### 121030
      h<-0==zx
      sx<-ifelse(h,zx,sx); sy<-ifelse(h,p1y-a2*p1x,sy)
      # points on line defined by line segment
      a1 <- ifelse( abs(a1) == Inf, sign(a1)*123456789*1E10, a1) # 121030
      a2 <- ifelse( abs(a2) == Inf, sign(a2)*123456789*1E10, a2)
      # points on line defined by line segment
      h<-0==(a1-a2) & sign(zx)==sign(p1x)
      sx<-ifelse(h,p1x,sx); sy<-ifelse(h,p1y,sy)
      h<-0==(a1-a2) & sign(zx)!=sign(p1x)
      sx<-ifelse(h,p2x,sx); sy<-ifelse(h,p2y,sy)
      # line segment vertical
      #   & center NOT ON line segment
      h<-p1x==p2x & zx!=p1x & p1x!=0
      sx<-ifelse(h,p1x,sx); sy<-ifelse(h,zy*p1x/zx,sy)
      #   & center ON line segment
      h<-p1x==p2x & zx!=p1x & p1x==0
      sx<-ifelse(h,p1x,sx); sy<-ifelse(h,0,sy)
      #   & center NOT ON line segment & point on line     ### 121126
      h<-p1x==p2x & zx==p1x & p1x!=0 # & sign(zy)==sign(p1y)
      sx<-ifelse(h,zx,sx); sy<-ifelse(h,zy,sy)
      #   & center ON line segment & point on line
      h<-p1x==p2x & zx==p1x & p1x==0 & sign(zy)==sign(p1y)
      sx<-ifelse(h,p1x,sx); sy<-ifelse(h,p1y,sy)
      h<-p1x==p2x & zx==p1x & p1x==0 & sign(zy)!=sign(p1y)
      sx<-ifelse(h,p1x,sx); sy<-ifelse(h,p2y,sy)
      #  points identical to end points of line segment
      h<-zx==p1x & zy==p1y; sx<-ifelse(h,p1x,sx); sy<-ifelse(h,p1y,sy)
      h<-zx==p2x & zy==p2y; sx<-ifelse(h,p2x,sx); sy<-ifelse(h,p2y,sy)
      # point of z is center
      h<-zx==0 & zy==0; sx<-ifelse(h,0,sx); sy<-ifelse(h,0,sy)
      sxy<-cbind(sx,sy)
    } # end of special cases
    #if(verbose){ print(rbind(a1,a2));print(cbind(zx,zy,p1x,p1y,p2x,p2y,sxy))}
    if(!exists("debug.plots")) debug.plots<-"no"
    if(debug.plots=="all"){
      segments(sxy[,1],sxy[,2],zx,zy,col="red")
      segments(0,0,sxy[,1],sxy[,2],col="green",lty=2) ##!!
      points(sxy,col="red")
    }
    return(sxy)
  }
  find.cut.z.pg<-function(z,pg,center=c(0,0),debug.plots="no"){
    if(!is.matrix(z)) z<-rbind(z)
    if(1==nrow(pg)) return(matrix(center,nrow(z),2,TRUE))
    n.pg<-nrow(pg); n.z<-nrow(z)
    z<-cbind(z[,1]-center[1],z[,2]-center[2])
    pgo<-pg; pg<-cbind(pg[,1]-center[1],pg[,2]-center[2])
    if(!exists("debug.plots")) debug.plots<-"no"
    if(debug.plots=="all"){
      plot(rbind(z,pg,0),bty="n"); points(z,pch="p")
      lines(c(pg[,1],pg[1,1]),c(pg[,2],pg[1,2]))}
    # find angles of pg und z
    apg<-win(pg[,1],pg[,2])
    apg[is.nan(apg)]<-0; a<-order(apg); apg<-apg[a]; pg<-pg[a,]
    az<-win(z[,1],z[,2])
    # find line segments
    segm.no<-apply((outer(apg,az,"<")),2,sum)
    segm.no<-ifelse(segm.no==0,n.pg,segm.no)
    next.no<-1+(segm.no %% length(apg))
    # compute cut points
    cuts<-cut.z.pg(z[,1],z[,2],pg[segm.no,1],pg[segm.no,2],
                   pg[next.no,1],pg[next.no,2])
    # rescale
    cuts<-cbind(cuts[,1]+center[1],cuts[,2]+center[2])
    return(cuts)
  }
  # find.cut.z.pg(EX,  EX1,center=CE)
  hdepth.of.points<-function(tp){
    # 121030 second parameter n has been removed
    # if(!exists("precision")) precision <- 1 ### 121203
    # return(find.hdepths.tp(tp, xy, 181*precision)) ### 121202
    n.tp<-nrow(tp)
    tphdepth<-rep(0,n.tp); dpi<-2*pi-0.000001
    for(j in 1:n.tp) {
      dx<-tp[j,1]-xy[,1]; dy<-tp[j,2]-xy[,2]
      a<-win(dx,dy)+pi; h<-a<10; a<-a[h]; ident<-sum(!h)
      init<-sum(a < pi); a.shift<-(a+pi) %% dpi
      minusplus<-c(rep(-1,length(a)),rep(1,length(a))) #### 070824
      h<-cumsum(minusplus[order(c(a,a.shift))])
      tphdepth[j]<-init+min(h)+1 # +1 because of the point itself!!
      # tphdepth[j]<-init+min(h)+ident; cat("SUMME",ident)
    }
    tphdepth
  }

  find.hdepths.tp <- function(tp, data, number.of.directions=181){ # 121130
    # standardize dimensions
    xy <- as.matrix(data); tp <- as.matrix(rbind(tp)); n.tp <- dim(tp)[1]
    for( j in 1:2) {
      xy[,j] <- xy[,j] - (h <- min(xy[,j], na.rm=TRUE))
      tp[,j] <- tp[,j] -  h
      if( 0 < (h <- max(xy[,j], na.rm=TRUE))){
        xy[,j] <- xy[,j]/h; tp[,j] <- tp[,j]/h
      }
    }
    ##loop over directions##
    phi    <- c(seq(0,180,length=number.of.directions)[-1]*(2*pi/360))
    sinphi <- c(sin(phi),1); cosphi <- c(cos(phi),0)
    RM1 <- round(digits=6,rbind(cosphi,sinphi))
    hdtp <- rep(length(xy[,1]),length(tp[,1]))
    for( j in seq(along=sinphi)){ #print(j)
      xyt <- xy %*% RM1[,j]; tpt <- (tp %*% RM1[,j])[]
      xyt <- xyt[!is.na(xyt)] #; tpt <- sort(tpt)
      hdtp <- pmin(hdtp,(rank( c(tpt,xyt), ties.method="min"))[1:n.tp]
                   -rank( tpt,ties.method="min")
                   ,rank(-c(tpt,xyt), ties.method="min")[1:n.tp]
                   -rank(-tpt,ties.method="min")
      )
    }
    hdtp
  }


  expand.hull<-function(pg,k){
    if( 1 >= nrow(pg) ) return(pg) ## 121026 ## 121123 <= statt ==

    resolution<-floor(20*precision)
    pg0<-xy[hdepth==1,]
    pg0<-pg0[chull(pg0[,1],pg0[,2]),]
    end.points<-find.cut.z.pg(pg,pg0,center=center,debug.plots=debug.plots)
    lam<-((0:resolution)^1)/resolution^1

    pg.new<-pg
    for(i in 1:nrow(pg)){
      tp<-cbind(pg[i,1]+lam*(end.points[i,1]-pg[i,1]),
                pg[i,2]+lam*(end.points[i,2]-pg[i,2]))
      # hd.tp<-hdepth.of.points(tp)
      hd.tp<-find.hdepths.tp(tp,xy)
      ind<-max(sum(hd.tp>=k),1)
      if(ind<length(hd.tp)){  # hd.tp[ind]>k &&
        tp<-cbind(tp[ind,1]+lam*(tp[ind+1,1]-tp[ind,1]),
                  tp[ind,2]+lam*(tp[ind+1,2]-tp[ind,2]))
        # hd.tp<-hdepth.of.points(tp)
        hp.tp<-find.hdepths.tp(tp,xy)
        ind<-max(sum(hd.tp>=k),1)
      }
      pg.new[i,]<-tp[ind,]
    }
    pg.new<-pg.new[chull(pg.new[,1],pg.new[,2]),]
    # cat("depth pg.new", hdepth.of.points(pg.new))
    # cat("depth pg.new", find.hdepths.tp(pg.new,xy))

    pg.add<-0.5*(pg.new+rbind(pg.new[-1,],pg.new[1,]))
    # end.points<-find.cut.z.pg(pg,pg0,center=center)
    end.points<-find.cut.z.pg(pg.add,pg0,center=center) #### 070824
    for(i in 1:nrow(pg.add)){
      tp<-cbind(pg.add[i,1]+lam*(end.points[i,1]-pg.add[i,1]),
                pg.add[i,2]+lam*(end.points[i,2]-pg.add[i,2]))
      # hd.tp<-hdepth.of.points(tp)
      hd.tp<-find.hdepths.tp(tp,xy)
      ind<-max(sum(hd.tp>=k),1)
      if(ind<length(hd.tp)){ # hd.tp[ind]>k &&
        tp<-cbind(tp[ind,1]+lam*(tp[ind+1,1]-tp[ind,1]),
                  tp[ind,2]+lam*(tp[ind+1,2]-tp[ind,2]))
        # hd.tp<-hdepth.of.points(tp)
        hd.tp<-find.hdepths.tp(tp,xy)
        ind<-max(sum(hd.tp>=k),1)
      }
      pg.add[i,]<-tp[ind,]
    }
    # cat("depth pg.add", hdepth.of.points(pg.add))

    pg.new<-rbind(pg.new,pg.add)
    pg.new<-pg.new[chull(pg.new[,1],pg.new[,2]),]
  }
  cut.p.sl.p.sl<-function(xy1,m1,xy2,m2){
    sx<-(xy2[2]-m2*xy2[1]-xy1[2]+m1*xy1[1])/(m1-m2)
    sy<-xy1[2]-m1*xy1[1]+m1*sx
    if(!is.nan(sy)) return( c(sx,sy) )
    if(abs(m1)==Inf) return( c(xy1[1],xy2[2]+m2*(xy1[1]-xy2[1])) )
    if(abs(m2)==Inf) return( c(xy2[1],xy1[2]+m1*(xy2[1]-xy1[1])) )
  }
  pos.to.pg<-function(z,pg,reverse=FALSE){
    if(reverse){
      int.no<-apply(outer(pg[,1],z[,1],">="),2,sum)
      zy.on.pg<-pg[int.no,2]+pg[int.no,3]*(z[,1]-pg[int.no,1])
    }else{
      int.no<-apply(outer(pg[,1],z[,1],"<="),2,sum)
      zy.on.pg<-pg[int.no,2]+pg[int.no,3]*(z[,1]-pg[int.no,1])
    }
    #### ifelse(z[,2]<zy.on.pg, "lower","higher") ##### 121004
    result <- ifelse(z[,2]<zy.on.pg, "lower","higher") ####
    return(result)
    if( all(result=="lower") ){
      result <- ifelse(((z[,2] - zy.on.pg)/max(z[,2] - zy.on.pg)+1e-10) < 0,
                       "lower","higher")
    }
    if( all(result=="higher") ){
      result <- ifelse(((z[,2] - zy.on.pg)/max(z[,2] - zy.on.pg)-1e-10) < 0,
                       "lower","higher")
    }
    print(result)
    return(result)
  }
  find.polygon.center<-function(xy){
    #### if(missing(xy)){n<-50;x<-rnorm(n);y<-rnorm(n); xy<-cbind(x,y)}
    #### xy<-xy[chull(xy),]
    if(length(xy)==2) return(xy[1:2])
    if(nrow(xy)==2) return(colMeans(xy)) #### 121009
    #### partition polygon into triangles
    n<-length(xy[,1]); mxy<-colMeans(xy)
    xy2<-rbind(xy[-1,],xy[1,]); xy3<-cbind(rep(mxy[1],n),mxy[2])
    #### determine areas and centers of gravity of triangles
    S<-(xy+xy2+xy3)/3
    F2<-abs((xy[,1]-xy3[,1])*(xy2[,2]-xy3[,2])-
              (xy[,2]-xy3[,2])*(xy2[,1]-xy3[,1]))
    #### compute center of gravity of polygon
    lambda<-F2/sum(F2)
    SP<-colSums(cbind(S[,1]*lambda,S[,2]*lambda))
    return(SP)
  }
  # check input
  xydata<-if(missing(y)) x else cbind(x,y)
  if(is.data.frame(xydata)) xydata<-as.matrix(xydata)
  if(any(is.na(xydata))){
    if(na.rm){ xydata<-xydata[!apply(is.na(xydata),1,any),,drop=FALSE]
               print("Warning: NA elements have been removed!!")
    }else{ #121129
      xy.medians<-apply(xydata,2,function(x) median(x, na.rm=TRUE))
      # colMeans(xydata,na.rm=TRUE)
      for(j in 1:ncol(xydata)) xydata[is.na(xydata[,j]),j]<-xy.medians[j]
      print("Warning: NA elements have been exchanged by median values!!")
    }
  }
  # if(nrow(xydata)<3) {print("not enough data points"); return()} ### 121008
  if(length(xydata)<4) {print("not enough data points"); return()}
  if((length(xydata)%%2)==1) {print("number of values isn't even"); return()}
  if(!is.matrix(xydata)) xydata<-matrix(xydata,ncol=2,byrow=TRUE)
  # select sample in case of a very large data set
  very.large.data.set<-nrow(xydata) > approx.limit
  # use of random number generator may disturb simulation
  # therefore we now use a systematical part of the data 20120930
  #### OLD: set.seed(random.seed<-13)  #### SEED
  if(very.large.data.set){
    #### OLD: ind<-sample(seq(nrow(xydata)),size=approx.limit)
    step<-(n<-nrow(xydata))/approx.limit; ind <- round(seq(1,n,by=step))
    xy<-xydata[ind,]
  } else xy<-xydata
  n<-nrow(xy)
  points.in.bag<-floor(n/2)
  # if jittering is needed
  # the following two lines can be activated
  #xy<-xy+cbind(rnorm(n,0,.0001*sd(xy[,1])),
  #             rnorm(n,0,.0001*sd(xy[,2])))
  if(verbose) cat("end of initialization")

  prdata<-prcomp(xydata)
  is.one.dim<-(0 == max(prdata[[1]])) || (min(prdata[[1]])/max(prdata[[1]]))<0.00001 # 121129
  if(is.one.dim){
    if(verbose) cat("data set one dimensional")
    center<-colMeans(xydata)
    res<-list(xy=xy,xydata=xydata,prdata=prdata,
              is.one.dim=is.one.dim,center=center)
    class(res)<-"bagplot"
    return(res)
  }
  if(verbose) cat("data not linear")

  if(nrow(xydata)<=4) {
    if(verbose) cat("only three or four data points")
    center<-colMeans(xydata)
    res<-list(xy=xy,xydata=xydata,prdata=prdata,hdepths=rep(1,n),hdepth=rep(1,n),
              is.one.dim=is.one.dim,center=center,hull.center=NULL,
              hull.bag=NULL,hull.loop=NULL,pxy.bag=NULL,pxy.outer=xydata,
              pxy.outlier=NULL,exp.dk=xydata)
    class(res)<-"bagplot"
    return(res)
  }

  xym<-apply(xy,2,mean); xysd<-apply(xy,2,sd)
  xyxy<-cbind((xy[,1]-xym[1])/xysd[1],(xy[,2]-xym[2])/xysd[2])

  dx<-(outer(xy[,1],xy[,1],"-"))
  dy<-(outer(xy[,2],xy[,2],"-"))
  alpha<-atan2(y=dy,x=dx); diag(alpha)<-1000
  for(j in 1:n) alpha[,j]<-sort(alpha[,j])
  alpha<-alpha[-n,] ; m<-n-1
  #### quick look inside, just for check
  if(debug.plots=="all"){
    plot(xy,bty="n"); xdelta<-abs(diff(range(xy[,1]))); dx<-xdelta*.3
    for(j in 1:n) {
      p<-xy[j,]; dy<-dx*tan(alpha[,j])
      segments(p[1]-dx,p[2]-dy,p[1]+dx,p[2]+dy,col=j)
      text(p[1]-xdelta*.02,p[2],j,col=j)
    }
  }
  if(verbose) print("end of computation of angles")

  hdepth<-rep(0,n); dpi<-2*pi-0.000001; mypi<-pi-0.000001
  minusplus<-c(rep(-1,m),rep(1,m))
  if(FALSE){
    for(j in 1:n) {
      a<-alpha[,j]+pi; h<-a<10; a<-a[h]; init<-sum(a < mypi) # hallo
      a.shift<-(a+pi) %% dpi
      minusplus<-c(rep(-1,length(a)),rep(1,length(a))) #### 070824
      h<-cumsum(minusplus[order(c(a,a.shift))])
      hdepth[j]<-init+min(h)+1 # or do we have to count identical points?
      # hdepth[j]<-init+min(h)+sum(xy[j,1]==xy[,1] & xy[j,2]==xy[,2])
    }
  }
  find.hdepths <- function(xy, number.of.directions=181){ # 121126

    xy <- as.matrix(xy)
    for( j in 1:2) {
      xy[,j] <- xy[,j] - min(xy[,j])
      if( 0 < (h <- max(xy[,j]))) xy[,j] <- xy[,j] / max(xy[,j])
    }

    phi    <- c(seq(0,180,length=number.of.directions)[-1]*(2*pi/360))
    sinphi <- c(sin(phi),1); cosphi <- c(cos(phi),0)
    RM1 <- round(digits=6,rbind(cosphi,sinphi))
    hd <- rep(h<-length(xy[,1]),h)
    for( j in seq(along=sinphi)){
      xyt <- xy %*% RM1[,j]
      hd <- pmin(hd,rank(xyt,ties.method="min"), rank(-xyt,ties.method="min"))
    }
    #  xyt <- xy %*% RM1
    #  hd2 <- cbind(apply(xyt, 2, rank, ties.method="min"),
    #               apply(-xyt,2, rank, ties.method="min"))
    #  hd2 <- apply(hd2, 1, min)
    hd
  }
  hdepth <- find.hdepths(xy,181*precision)
  if(verbose){print("end of computation of hdepth:"); print(hdepth)}
  #### quick look inside, just for a check
  if(debug.plots=="all"){
    plot(xy,bty="n")
    xdelta<-abs(diff(range(xy[,1]))); dx<-xdelta*.1
    for(j in 1:n) {
      a<-alpha[,j]+pi; a<-a[a<10]; init<-sum(a < pi)
      a.shift<-(a+pi) %% dpi
      minusplus<-c(rep(-1,length(a)),rep(1,length(a))) #### 070824
      h<-cumsum(minusplus[ao<-(order(c(a,a.shift)))])
      no<-which((init+min(h)) == (init+h))[1]
      p<-xy[j,]; dy<-dx*tan(alpha[,j])
      segments(p[1]-dx,p[2]-dy,p[1]+dx,p[2]+dy,col=j,lty=3)
      dy<-dx*tan(c(sort(a),sort(a))[no])
      segments(p[1]-5*dx,p[2]-5*dy,p[1]+5*dx,p[2]+5*dy,col="black")
      text(p[1]-xdelta*.02,p[2],hdepth[j],col=1) # cex=2.5 assumes suitable fonts
    }
  }

  hd.table<-table(sort(hdepth))
  d.k<-cbind(dk=rev(cumsum(rev(hd.table))),
             k =as.numeric(names(hd.table)))
  k.1<-sum( points.in.bag < d.k[,1] )
  # if(nrow(d.k)>1){ ### version 09/2005, error in data set 1 of Meuleman
  # instead of >2 now >k.1 ### 070827
  # if(nrow(d.k)>k.1){ k<-d.k[k.1+1,2] } else { k<-d.k[k.1,2] }
  # this statement will not have an effect because of the next one:
  k<-d.k[k.1,2]+1 # 121004 increment depth by one not by looking for next depth
  if(verbose){cat("numbers of members of dk:"); print(hd.table); print(d.k)}
  if(verbose){cat("end of computation of k, k=",k,"k.1:",k.1)}
  # D.K<<-d.k; K.1<<-k.1; EX<<-exp.dk; EX.1<<-exp.dk.1; PDK<<-pdk; HDEPTH<<-hdepth

  center<-apply(xy[which(hdepth==max(hdepth)),,drop=FALSE],2,mean)
  hull.center<-NULL
  if(3<nrow(xy)&&length(hd.table)>0){
    n.p<-floor(1.5*c(32,16,8)[1+(n>50)+(n>200)]*precision)
    # limit.hdepth.to.check <- sort(hdepth, decreasing = TRUE)[min(nrow(xy),6)]
    # 121126
    h <- unique(sort(hdepth, decreasing = TRUE))
    limit.hdepth.to.check <- sort(h)[min(length(h),3)]
    h<-cands<-xy[limit.hdepth.to.check <= hdepth,,drop=FALSE]
    # h<-cands<-xy[rev(order(hdepth))[1:(min(nrow(xy),6))],]
    cands<-cands[chull(cands[,1],cands[,2]),]; n.c<-nrow(cands)
    if(is.null(n.c))cands<-h

    xyextr<-rbind(apply(cands,2,min),apply(cands,2,max))
    ## xydel<-2*(xyextr[2,]-xyextr[1,])/n.p ## unused
    if( (xyextr[2,1]-xyextr[1,1]) < 0.2*(h <- diff(range(xy[,1])))){
      xyextr[1:2,1] <- mean(xyextr[,1]) + c(-.1,.1) * h }            #### 121203
    if( (xyextr[2,2]-xyextr[1,2]) < 0.2*(h <- diff(range(xy[,2])))){
      xyextr[1:2,2] <- mean(xyextr[,2]) + c(-.1,.1) * h }            #### 121203
    if(verbose){cat("xyextr: looking for maximal depth"); print(xyextr) }
    h1<-seq(xyextr[1,1],xyextr[2,1],length=n.p)
    h2<-seq(xyextr[1,2],xyextr[2,2],length=n.p)
    tp<-cbind(as.vector(matrix(h1,n.p,n.p)), #      [1:n.p^2],
              as.vector(matrix(h2,n.p,n.p,TRUE))) # [1:n.p^2])
    # tphdepth<-max(hdepth.of.points(tp))-1
    tphdepth<-max(find.hdepths.tp(tp,xy))
    # if(verbose) { TP<<-tp; TPD<<-find.hdepths.tp(tp,xy) }
    if(verbose) cat("points(TP,pch=c(letters,LETTERS)[TPD+1])")
    # if max of testpoint is smaller than max depth of points take that max!
    if(verbose){ cat("depth of testpoints"); print(summary(tphdepth)) } # 121126
    tphdepth<-max(tphdepth,d.k[,2]) # 121004

    # define direction for hdepth search
    num<-floor(2*c(417,351,171,85,67,43)[sum(n>c(1,50,100,150,200,250))]*precision)
    num.h<-floor(num/2); angles<-seq(0,pi,length=num.h)
    ang<-tan(pi/2-angles)
    kkk<-tphdepth
    if(verbose){cat("max-hdepth found:"); print(kkk)}
    if(verbose) cat("find polygon with max depth")
    ia<-1; a<-angles[ia]; xyt<-xyxy%*%c(cos(a),-sin(a)); xyto<-order(xyt)
    # initial for upper part
    ind.k<-xyto[kkk]; cutp<-c(xyxy[ind.k,1],-10)
    dxy<-diff(range(xyxy))
    pg<-rbind(c(cutp[1],-dxy,Inf),c(cutp[1],dxy,NA))
    # initial for lower part
    ind.kk<-xyto[n+1-kkk]; cutpl<-c(xyxy[ind.kk,1],10)
    # pgl<-rbind(c(cutpl[1],dxy,Inf),c(cutpl[1],-dxy,NA))
    pgl<-rbind(c(cutpl[1],dxy,-Inf),c(cutpl[1],-dxy,NA))
    # the sign of inf doesn't matter
    if(debug.plots=="all"){ plot(xyxy,type="p",bty="n")
                            text(xy,,1:n,col="blue")
                            hx<-xy[ind.k,c(1,1)]; hy<-xy[ind.k,c(2,2)]
                            segments(hx,hy,c(10,-10),hy+ang[ia]*(c(10,-10)-hx),lty=2)
                            text(hx+rnorm(1,,.1),hy+rnorm(1,,.1),ia)
    }
    if(verbose) cat("start of computation of the directions: ","kkk=",kkk) # 121030
    for(ia in seq(angles)[-1]){

      # determine critical points pnew and pnewl of direction a
      # if(verbose) cat("ia",ia,angles[ia])
      # 121030
      a<-angles[ia]; angtan<-ang[ia]; xyt<-xyxy%*%c(cos(a),-sin(a)); xyto<-order(xyt)
      ind.k <-xyto[kkk]; ind.kk<-xyto[n+1-kkk]; pnew<-xyxy[ind.k,]; pnewl<-xyxy[ind.kk,]
      # if(verbose) if( 1 < sum(xyt == xyt[ind.k]) )print("WARNING: some points identical")
      if(debug.plots=="all") points(pnew[1],pnew[2],col="red")
      # new limiting lines are defined by pnew / pnewl and slope a
      # find segment of polygon that is cut by new limiting line and cut
      # if(ia>200) { #<show pg pgl>#; points(pnew[1],pnew[2],col="magenta",cex=6) }
      if( abs(angtan)>1e10){ if(verbose) cat("kkk",kkk,"x=c case")
                             # case of vertical slope #print(pg);print(pnew);print(xyt);lines(pg,col="red",lwd=3)
                             # number of points left of point pnew that limit the polygon
                             pg.no<-sum(pg[,1]<pnew[1])
                             if( 0 < pg.no ){
                               # the polygon (segment pg.no) has to be cut at x==pnew[1]
                               cutp <- c(pnew[1], pg [pg.no, 2]+pg [pg.no, 3]*(pnew [1]-pg [pg.no ,1]))
                               pg<- rbind(pg[1:pg.no,],  c(cutp,angtan), c(cutp[1]+dxy,  cutp[2] +angtan*dxy,NA))
                             } else {
                               if(verbose) cat("!!! case degenerated UPPER polygon: pg.no==0")
                               # the limiting point pnew is above the beginning of the polygon
                               # therefore, the polygon reduces to line
                               pg <- rbind(pg[1,], c(pg[2,1:2],NA))
                             }
                             pg.nol<-sum(pgl[,1]>=pnewl[1])
                             if( 0 < pg.nol ){ #??2 ### 121204
                               cutpl<-c(pnewl[1],pgl[pg.nol,2]+pgl[pg.nol,3]*(pnewl[1]-pgl[pg.nol,1]))
                               pgl<-rbind(pgl[1:pg.nol,],c(cutpl,angtan),c(cutpl[1]-dxy, cutpl[2]-angtan*dxy,NA))
                             } else {
                               if(verbose) cat("!!! case degenerated LOWER polygon: pgl.no==0")
                               pgl <- rbind(pgl[1,], c(pgl[2,1:2],NA))
                             }
      }else{ # if(verbose) cat("kkk",kkk,"normal case")
        # normal case upper polygon
        pg.inter<-pg[,2]-angtan*pg[,1]; pnew.inter<-pnew[2]-angtan*pnew[1]
        pg.no<-sum(pg.inter<pnew.inter)
        if(is.na(pg[pg.no,3])) pg[pg.no,3] <- -Inf # 121129 NaN/Na error
        cutp<-cut.p.sl.p.sl(pnew,ang[ia],pg[pg.no,1:2],pg[pg.no,3])
        pg<- rbind(pg[1:pg.no,],  c(cutp,angtan), c(cutp[1]+dxy,  cutp[2] +angtan*dxy,NA))
        # normal case lower polygon
        pg.interl<-pgl[,2]-angtan*pgl[,1]; pnew.interl<-pnewl[2]-angtan*pnewl[1]
        pg.nol<-sum(pg.interl>pnew.interl)
        if(is.na(pgl[pg.nol,3])) pgl[pg.nol,3] <- Inf # 121129 NaN/Na error
        cutpl<-cut.p.sl.p.sl(pnewl,angtan,pgl[pg.nol,1:2],pgl[pg.nol,3])
        pgl<-rbind(pgl[1:pg.nol,],c(cutpl,angtan),c(cutpl[1]-dxy, cutpl[2]-angtan*dxy,NA))
      }
      # if(kkk==KKK && ia == 51) { cat("ENDE: pgl"); print(pgl) }
      # update pg, pgl completed
      # PG<<-pg;PG.NO<<-pg.no;CUTP<<-cutp;DXY<<-dxy;PNEW<<-pnew;PGL<<-pgl;PG.NOL<<-pg.nol
      #
      # cat("angtan",angtan,"pg.no",pg.no,"pkt:",pnew)
      # if(ia==stopp) lines(pg,type="b",col="green")
      if(debug.plots=="all"){
        points(pnew[1],pnew[2],col="red")
        hx<-xyxy[ind.k,c(1,1)]; hy<-xyxy[ind.k,c(2,2)]
        segments(hx,hy,c(10,-10),hy+ang[ia]*(c(10,-10)-hx),lty=2)
        # text(hx+rnorm(1,,.1),hy+rnorm(1,,.1),ia)
        # print(pg)
        # if(ia==stopp) lines(pgl,type="b",col="green")
        points(cutpl[1],cutpl[2],col="red")
        hx<-xyxy[ind.kk,c(1,1)]; hy<-xyxy[ind.kk,c(2,2)]
        segments(hx,hy,c(10,-10),hy+ang[ia]*(c(10,-10)-hx),lty=2)
        #  text(hx+rnorm(1,,.1),hy+rnorm(1,,.1),ia)
        # print(pgl)
      }
      ##show pg pgl##
    }
    # if(verbose) PG <<- pg; PGL <<- pgl
    if(2<nrow(pg) && 2<nrow(pgl)){

      # plot(xyxy[,1:2],xlim=c(-.5,+.5),ylim=c(-.5,.50))
      # lines(pg,type="b",col="red"); lines(pgl,type="b",col="blue")
      # remove first and last points and multiple points #<show pg pgl>#
      limit<-1e-10
      # pg <-pg [c(TRUE,(abs(diff(pg [,1]))>limit)|(abs(diff(pg [,2]))>limit)),] old#
      idx <- c(TRUE,(abs(diff(pg [,1]))>limit)|(abs(diff(pg [,2]))>limit)) # 121008
      if(any(idx==FALSE)){
        pg <-pg[idx,]; pg[,3] <- c(diff(pg[,2])/diff(pg[,1]), NA)
      }
      # old reduction which caused some errors:
      # pgl<-pgl[c(TRUE,(abs(diff(pgl[,1]))>limit)|(abs(diff(pgl[,2]))>limit)),] error##
      # pgl<-pgl[c(     (abs(diff(pgl[,1]))>limit)|(abs(diff(pgl[,2]))>limit),TRUE),] old#
      idx <-      c(     (abs(diff(pgl[,1]))>limit)|(abs(diff(pgl[,2]))>limit),TRUE)#121008
      if(any(idx==FALSE)){
        pgl<-pgl[idx,]; pgl[,3] <- c(diff(pgl[,2])/diff(pgl[,1]), NA)
      }
      # add some tolerance in course of numerical problems
      pgl[,2]<-pgl[,2] - .00001  # 121004
      # show pg pgl>>
      pg<- pg [-nrow(pg ),][-1,,drop=FALSE]
      pgl<-pgl[-nrow(pgl),][-1,,drop=FALSE]
      # determine position according to the other polygon
      #   cat("relative position: lower polygon")
      indl<-pos.to.pg(round(pgl,digits=10),round(pg,digits=10))  # 121126
      #   cat("relative position: upper polygon")
      indu<-pos.to.pg(round(pg,digits=10),round(pgl,digits=10),TRUE)
      sr<-sl<-NULL # ; ##show pg pgl>>
      # right region
      if(indu[(npg<-nrow(pg))]=="lower" & indl[1]=="higher"){
        # cat("in if of right region: the upper polynom is somewhere lower")
        #  checking from the right: last point of lower polygon that is NOT ok
        rnuml<-which(indl=="lower")[1]-1
        #  checking from the left: last point of upper polygon that is ok
        rnumu<-npg+1-which(rev(indu=="higher"))[1]
        #  special case all points of lower polygon are upper
        if(is.na(rnuml)) rnuml<-sum(pg[rnumu,1]<pgl[,1])
        #  special case all points of upper polygon are lower
        if(is.na(rnumu)) rnumu<-sum(pg[,1]<pgl[rnuml,1])
        xyl<-pgl[rnuml,]; xyu<-pg[rnumu,]
        # cat("right"); print(rnuml); print(xyl)
        # cat("right"); print(rnumu); print(xyu)
        sr<-cut.p.sl.p.sl(xyl[1:2],xyl[3],xyu[1:2],xyu[3])
      }
      # left region
      if(indl[(npgl<-nrow(pgl))]=="higher"&indu[1]=="lower"){
        # cat("in if of left region: the upper polynom is somewhere lower")
        #  checking from the right: last point of lower polygon that is ok
        lnuml<-npgl+1-which(rev(indl=="lower"))[1]
        #  checking from the left: last point of upper polygon that is NOT ok
        lnumu<-which(indu=="higher")[1]-1
        #  special case all points of lower polygon are upper
        if(is.na(lnuml)) lnuml<-sum(pg[lnumu,1]<pgl[,1])
        #  special case all points of upper polygon are lower
        if(is.na(lnumu)) lnumu<-sum(pg[,1]<pgl[lnuml,1])
        xyl<-pgl[lnuml,]; xyu<-pg[lnumu,]
        # cat("left"); print(lnuml); print(xyl)
        # cat("left"); print(lnumu); print(xyu)
        sl<-cut.p.sl.p.sl(xyl[1:2],xyl[3],xyu[1:2],xyu[3])
      }
      # if(kkk==2){ ##show pg pgl##; INDU<<-indu; INDL<<-indl; PGL<<-pgl; PGU<<-pg}
      pg<-rbind(pg [indu=="higher",1:2,drop=FALSE],sr,
                pgl[indl=="lower", 1:2,drop=FALSE],sl)
      if(debug.plots=="all") lines(rbind(pg,pg[1,]),col="red")
      if(!any(is.na(pg)))  pg<-pg[chull(pg[,1],pg[,2]),]
      # if(kkk==7){ PG <<- pg }
    } else {
      if(2<nrow(pgl)){ #121204
        pg <- rbind(pg[2,1:2],pgl[-c(1,length(pgl[,1])),1:2])
      } else {
        pg <- rbind(pg [-c(1,length(pg [,1])),1:2],pgl[2,1:2])
        # rbind(pgl[2,1:2],pg[2,1:2])
      }
    }
    if(verbose) cat("END of computation of the directions")
    hull.center<-cbind(pg[,1]*xysd[1]+xym[1],pg[,2]*xysd[2]+xym[2])
    if(!any(is.na(hull.center))) center<-find.polygon.center(hull.center) else
      hull.center <- rbind(center)       # 121126
    if(verbose){ cat("CENTER"); print(center) }
    if(verbose){cat("hull.center",hull.center); print(table(tphdepth)) }
  }
  # if(verbose) cat("center depth:",hdepth.of.points(rbind(center))-1)
  if(verbose) cat("center depth:",find.hdepths.tp(rbind(center),xy)-1)
  if(verbose){print("end of computation of center"); print(center)}
  if(dkmethod==1){

    # inner hull of bag
    xyi<-xy[hdepth>=k,,drop=FALSE] # cat("dim XYI", dim(xyi))
    # 121028 some corrections for strange k situations
    if(0 < length(xyi)) pdk<-xyi[chull(xyi[,1],xyi[,2]),,drop=FALSE]
    # outer hull of bag
    if( k > 1 ){
      xyo<-xy[hdepth>=(k-1),,drop=FALSE]
      pdk.1<-xyo[chull(xyo[,1],xyo[,2]),,drop=FALSE]
    } else pdk.1 <- pdk
    if(0 == length(xyi)) pdk <- pdk.1
    if(verbose)cat("hull computed: pdk, pdk.1:")
    if(verbose){print(pdk); print(pdk.1) }
    if(debug.plots=="all"){
      plot(xy,bty="n")
      h<-rbind(pdk,pdk[1,]); lines(h,col="red",lty=2)
      h<-rbind(pdk.1,pdk.1[1,]);lines(h,col="blue",lty=3)
      points(center[1],center[2],pch=8,col="red")
    }
    exp.dk<-expand.hull(pdk,k)
    exp.dk.1<-expand.hull(exp.dk,k-1) # pdk.1,k-1,20)
  }else{

    # define direction for hdepth search
    num<-floor(2*c(417,351,171,85,67,43)[sum(n>c(1,50,100,150,200,250))]*precision)
    num.h<-floor(num/2); angles<-seq(0,pi,length=num.h)
    ang<-tan(pi/2-angles)
    # standardization of data set xyxy is used
    kkk<-k
    if(verbose) print("find polygon with depth something higher than that of the bag")
    if( kkk <= max(d.k[,2]) ){ # inner one ### 121030

      ia<-1; a<-angles[ia]; xyt<-xyxy%*%c(cos(a),-sin(a)); xyto<-order(xyt)
      # initial for upper part
      ind.k<-xyto[kkk]; cutp<-c(xyxy[ind.k,1],-10)
      dxy<-diff(range(xyxy))
      pg<-rbind(c(cutp[1],-dxy,Inf),c(cutp[1],dxy,NA))
      # initial for lower part
      ind.kk<-xyto[n+1-kkk]; cutpl<-c(xyxy[ind.kk,1],10)
      # pgl<-rbind(c(cutpl[1],dxy,Inf),c(cutpl[1],-dxy,NA))
      pgl<-rbind(c(cutpl[1],dxy,-Inf),c(cutpl[1],-dxy,NA))
      # the sign of inf doesn't matter
      if(debug.plots=="all"){ plot(xyxy,type="p",bty="n")
                              text(xy,,1:n,col="blue")
                              hx<-xy[ind.k,c(1,1)]; hy<-xy[ind.k,c(2,2)]
                              segments(hx,hy,c(10,-10),hy+ang[ia]*(c(10,-10)-hx),lty=2)
                              text(hx+rnorm(1,,.1),hy+rnorm(1,,.1),ia)
      }
      if(verbose) cat("start of computation of the directions: ","kkk=",kkk) # 121030
      for(ia in seq(angles)[-1]){

        # determine critical points pnew and pnewl of direction a
        # if(verbose) cat("ia",ia,angles[ia])
        # 121030
        a<-angles[ia]; angtan<-ang[ia]; xyt<-xyxy%*%c(cos(a),-sin(a)); xyto<-order(xyt)
        ind.k <-xyto[kkk]; ind.kk<-xyto[n+1-kkk]; pnew<-xyxy[ind.k,]; pnewl<-xyxy[ind.kk,]
        # if(verbose) if( 1 < sum(xyt == xyt[ind.k]) )print("WARNING: some points identical")
        if(debug.plots=="all") points(pnew[1],pnew[2],col="red")
        # new limiting lines are defined by pnew / pnewl and slope a
        # find segment of polygon that is cut by new limiting line and cut
        # if(ia>200) { #<show pg pgl>#; points(pnew[1],pnew[2],col="magenta",cex=6) }
        if( abs(angtan)>1e10){ if(verbose) cat("kkk",kkk,"x=c case")
                               # case of vertical slope #print(pg);print(pnew);print(xyt);lines(pg,col="red",lwd=3)
                               # number of points left of point pnew that limit the polygon
                               pg.no<-sum(pg[,1]<pnew[1])
                               if( 0 < pg.no ){
                                 # the polygon (segment pg.no) has to be cut at x==pnew[1]
                                 cutp <- c(pnew[1], pg [pg.no, 2]+pg [pg.no, 3]*(pnew [1]-pg [pg.no ,1]))
                                 pg<- rbind(pg[1:pg.no,],  c(cutp,angtan), c(cutp[1]+dxy,  cutp[2] +angtan*dxy,NA))
                               } else {
                                 if(verbose) cat("!!! case degenerated UPPER polygon: pg.no==0")
                                 # the limiting point pnew is above the beginning of the polygon
                                 # therefore, the polygon reduces to line
                                 pg <- rbind(pg[1,], c(pg[2,1:2],NA))
                               }
                               pg.nol<-sum(pgl[,1]>=pnewl[1])
                               if( 0 < pg.nol ){ #??2 ### 121204
                                 cutpl<-c(pnewl[1],pgl[pg.nol,2]+pgl[pg.nol,3]*(pnewl[1]-pgl[pg.nol,1]))
                                 pgl<-rbind(pgl[1:pg.nol,],c(cutpl,angtan),c(cutpl[1]-dxy, cutpl[2]-angtan*dxy,NA))
                               } else {
                                 if(verbose) cat("!!! case degenerated LOWER polygon: pgl.no==0")
                                 pgl <- rbind(pgl[1,], c(pgl[2,1:2],NA))
                               }
        }else{ # if(verbose) cat("kkk",kkk,"normal case")
          # normal case upper polygon
          pg.inter<-pg[,2]-angtan*pg[,1]; pnew.inter<-pnew[2]-angtan*pnew[1]
          pg.no<-sum(pg.inter<pnew.inter)
          if(is.na(pg[pg.no,3])) pg[pg.no,3] <- -Inf # 121129 NaN/Na error
          cutp<-cut.p.sl.p.sl(pnew,ang[ia],pg[pg.no,1:2],pg[pg.no,3])
          pg<- rbind(pg[1:pg.no,],  c(cutp,angtan), c(cutp[1]+dxy,  cutp[2] +angtan*dxy,NA))
          # normal case lower polygon
          pg.interl<-pgl[,2]-angtan*pgl[,1]; pnew.interl<-pnewl[2]-angtan*pnewl[1]
          pg.nol<-sum(pg.interl>pnew.interl)
          if(is.na(pgl[pg.nol,3])) pgl[pg.nol,3] <- Inf # 121129 NaN/Na error
          cutpl<-cut.p.sl.p.sl(pnewl,angtan,pgl[pg.nol,1:2],pgl[pg.nol,3])
          pgl<-rbind(pgl[1:pg.nol,],c(cutpl,angtan),c(cutpl[1]-dxy, cutpl[2]-angtan*dxy,NA))
        }
        # if(kkk==KKK && ia == 51) { cat("ENDE: pgl"); print(pgl) }
        # update pg, pgl completed
        # PG<<-pg;PG.NO<<-pg.no;CUTP<<-cutp;DXY<<-dxy;PNEW<<-pnew;PGL<<-pgl;PG.NOL<<-pg.nol
        #### ***********************
        #### cat("angtan",angtan,"pg.no",pg.no,"pkt:",pnew)
        # if(ia==stopp) lines(pg,type="b",col="green")
        if(debug.plots=="all"){
          points(pnew[1],pnew[2],col="red")
          hx<-xyxy[ind.k,c(1,1)]; hy<-xyxy[ind.k,c(2,2)]
          segments(hx,hy,c(10,-10),hy+ang[ia]*(c(10,-10)-hx),lty=2)
          # text(hx+rnorm(1,,.1),hy+rnorm(1,,.1),ia)
          # print(pg)
          # if(ia==stopp) lines(pgl,type="b",col="green")
          points(cutpl[1],cutpl[2],col="red")
          hx<-xyxy[ind.kk,c(1,1)]; hy<-xyxy[ind.kk,c(2,2)]
          segments(hx,hy,c(10,-10),hy+ang[ia]*(c(10,-10)-hx),lty=2)
          #  text(hx+rnorm(1,,.1),hy+rnorm(1,,.1),ia)
          # print(pgl)
        }
        ##show pg pgl##
      }
      # if(verbose) PG <<- pg; PGL <<- pgl
      if(2<nrow(pg) && 2<nrow(pgl)){

        # plot(xyxy[,1:2],xlim=c(-.5,+.5),ylim=c(-.5,.50))
        # lines(pg,type="b",col="red"); lines(pgl,type="b",col="blue")
        # remove first and last points and multiple points #<show pg pgl>#
        limit<-1e-10
        # pg <-pg [c(TRUE,(abs(diff(pg [,1]))>limit)|(abs(diff(pg [,2]))>limit)),] old#
        idx <- c(TRUE,(abs(diff(pg [,1]))>limit)|(abs(diff(pg [,2]))>limit)) # 121008
        if(any(idx==FALSE)){
          pg <-pg[idx,]; pg[,3] <- c(diff(pg[,2])/diff(pg[,1]), NA)
        }
        # old reduction which caused some errors:
        # pgl<-pgl[c(TRUE,(abs(diff(pgl[,1]))>limit)|(abs(diff(pgl[,2]))>limit)),] error##
        # pgl<-pgl[c(     (abs(diff(pgl[,1]))>limit)|(abs(diff(pgl[,2]))>limit),TRUE),] old#
        idx <-      c(     (abs(diff(pgl[,1]))>limit)|(abs(diff(pgl[,2]))>limit),TRUE)#121008
        if(any(idx==FALSE)){
          pgl<-pgl[idx,]; pgl[,3] <- c(diff(pgl[,2])/diff(pgl[,1]), NA)
        }
        # add some tolerance in course of numerical problems
        pgl[,2]<-pgl[,2] - .00001  #### 121004
        # show pg pgl>>
        pg<- pg [-nrow(pg ),][-1,,drop=FALSE]
        pgl<-pgl[-nrow(pgl),][-1,,drop=FALSE]
        # determine position according to the other polygon
        #   cat("relative position: lower polygon")
        indl<-pos.to.pg(round(pgl,digits=10),round(pg,digits=10))  # 121126
        #   cat("relative position: upper polygon")
        indu<-pos.to.pg(round(pg,digits=10),round(pgl,digits=10),TRUE)
        sr<-sl<-NULL # ; ##show pg pgl>>
        # right region
        if(indu[(npg<-nrow(pg))]=="lower" & indl[1]=="higher"){
          # cat("in if of right region: the upper polynom is somewhere lower")
          #  checking from the right: last point of lower polygon that is NOT ok
          rnuml<-which(indl=="lower")[1]-1
          #  checking from the left: last point of upper polygon that is ok
          rnumu<-npg+1-which(rev(indu=="higher"))[1]
          #  special case all points of lower polygon are upper
          if(is.na(rnuml)) rnuml<-sum(pg[rnumu,1]<pgl[,1])
          #  special case all points of upper polygon are lower
          if(is.na(rnumu)) rnumu<-sum(pg[,1]<pgl[rnuml,1])
          xyl<-pgl[rnuml,]; xyu<-pg[rnumu,]
          # cat("right"); print(rnuml); print(xyl)
          # cat("right"); print(rnumu); print(xyu)
          sr<-cut.p.sl.p.sl(xyl[1:2],xyl[3],xyu[1:2],xyu[3])
        }
        # left region
        if(indl[(npgl<-nrow(pgl))]=="higher"&indu[1]=="lower"){
          # cat("in if of left region: the upper polynom is somewhere lower")
          #  checking from the right: last point of lower polygon that is ok
          lnuml<-npgl+1-which(rev(indl=="lower"))[1]
          #  checking from the left: last point of upper polygon that is NOT ok
          lnumu<-which(indu=="higher")[1]-1
          #  special case all points of lower polygon are upper
          if(is.na(lnuml)) lnuml<-sum(pg[lnumu,1]<pgl[,1])
          #  special case all points of upper polygon are lower
          if(is.na(lnumu)) lnumu<-sum(pg[,1]<pgl[lnuml,1])
          xyl<-pgl[lnuml,]; xyu<-pg[lnumu,]
          # cat("left"); print(lnuml); print(xyl)
          # cat("left"); print(lnumu); print(xyu)
          sl<-cut.p.sl.p.sl(xyl[1:2],xyl[3],xyu[1:2],xyu[3])
        }
        # if(kkk==2){ ##show pg pgl##; INDU<<-indu; INDL<<-indl; PGL<<-pgl; PGU<<-pg}
        pg<-rbind(pg [indu=="higher",1:2,drop=FALSE],sr,
                  pgl[indl=="lower", 1:2,drop=FALSE],sl)
        if(debug.plots=="all") lines(rbind(pg,pg[1,]),col="red")
        if(!any(is.na(pg)))  pg<-pg[chull(pg[,1],pg[,2]),]
        # if(kkk==7){ PG <<- pg }
      } else {
        if(2<nrow(pgl)){ #121204
          pg <- rbind(pg[2,1:2],pgl[-c(1,length(pgl[,1])),1:2])
        } else {
          pg <- rbind(pg [-c(1,length(pg [,1])),1:2],pgl[2,1:2])
          # rbind(pgl[2,1:2],pg[2,1:2])
        }
      }
      if(verbose) cat("END of computation of the directions")
      exp.dk<-cbind(pg[,1]*xysd[1]+xym[1],pg[,2]*xysd[2]+xym[2])
    } else {
      exp.dk <- NULL
    }
    if( 1 < kkk ) kkk<-kkk-1 # outer one
    if(verbose) print("find polygon with depth a little bit lower than that of the bag")
    ia<-1; a<-angles[ia]; xyt<-xyxy%*%c(cos(a),-sin(a)); xyto<-order(xyt)
    # initial for upper part
    ind.k<-xyto[kkk]; cutp<-c(xyxy[ind.k,1],-10)
    dxy<-diff(range(xyxy))
    pg<-rbind(c(cutp[1],-dxy,Inf),c(cutp[1],dxy,NA))
    # initial for lower part
    ind.kk<-xyto[n+1-kkk]; cutpl<-c(xyxy[ind.kk,1],10)
    # pgl<-rbind(c(cutpl[1],dxy,Inf),c(cutpl[1],-dxy,NA))
    pgl<-rbind(c(cutpl[1],dxy,-Inf),c(cutpl[1],-dxy,NA))
    # the sign of inf doesn't matter
    if(debug.plots=="all"){ plot(xyxy,type="p",bty="n")
                            text(xy,,1:n,col="blue")
                            hx<-xy[ind.k,c(1,1)]; hy<-xy[ind.k,c(2,2)]
                            segments(hx,hy,c(10,-10),hy+ang[ia]*(c(10,-10)-hx),lty=2)
                            text(hx+rnorm(1,,.1),hy+rnorm(1,,.1),ia)
    }
    if(verbose) cat("start of computation of the directions: ","kkk=",kkk) # 121030
    for(ia in seq(angles)[-1]){

      # determine critical points pnew and pnewl of direction a
      # if(verbose) cat("ia",ia,angles[ia])
      # 121030
      a<-angles[ia]; angtan<-ang[ia]; xyt<-xyxy%*%c(cos(a),-sin(a)); xyto<-order(xyt)
      ind.k <-xyto[kkk]; ind.kk<-xyto[n+1-kkk]; pnew<-xyxy[ind.k,]; pnewl<-xyxy[ind.kk,]
      # if(verbose) if( 1 < sum(xyt == xyt[ind.k]) )print("WARNING: some points identical")
      if(debug.plots=="all") points(pnew[1],pnew[2],col="red")
      # new limiting lines are defined by pnew / pnewl and slope a
      # find segment of polygon that is cut by new limiting line and cut
      # if(ia>200) { #<show pg pgl>#; points(pnew[1],pnew[2],col="magenta",cex=6) }
      if( abs(angtan)>1e10){ if(verbose) cat("kkk",kkk,"x=c case")
                             # case of vertical slope #print(pg);print(pnew);print(xyt);lines(pg,col="red",lwd=3)
                             # number of points left of point pnew that limit the polygon
                             pg.no<-sum(pg[,1]<pnew[1])
                             if( 0 < pg.no ){
                               # the polygon (segment pg.no) has to be cut at x==pnew[1]
                               cutp <- c(pnew[1], pg [pg.no, 2]+pg [pg.no, 3]*(pnew [1]-pg [pg.no ,1]))
                               pg<- rbind(pg[1:pg.no,],  c(cutp,angtan), c(cutp[1]+dxy,  cutp[2] +angtan*dxy,NA))
                             } else {
                               if(verbose) cat("!!! case degenerated UPPER polygon: pg.no==0")
                               # the limiting point pnew is above the beginning of the polygon
                               # therefore, the polygon reduces to line
                               pg <- rbind(pg[1,], c(pg[2,1:2],NA))
                             }
                             pg.nol<-sum(pgl[,1]>=pnewl[1])
                             if( 0 < pg.nol ){ ##??2 ### 121204
                               cutpl<-c(pnewl[1],pgl[pg.nol,2]+pgl[pg.nol,3]*(pnewl[1]-pgl[pg.nol,1]))
                               pgl<-rbind(pgl[1:pg.nol,],c(cutpl,angtan),c(cutpl[1]-dxy, cutpl[2]-angtan*dxy,NA))
                             } else {
                               if(verbose) cat("!!! case degenerated LOWER polygon: pgl.no==0")
                               pgl <- rbind(pgl[1,], c(pgl[2,1:2],NA))
                             }
      }else{ # if(verbose) cat("kkk",kkk,"normal case")
        # normal case upper polygon
        pg.inter<-pg[,2]-angtan*pg[,1]; pnew.inter<-pnew[2]-angtan*pnew[1]
        pg.no<-sum(pg.inter<pnew.inter)
        if(is.na(pg[pg.no,3])) pg[pg.no,3] <- -Inf # 121129 NaN/Na error
        cutp<-cut.p.sl.p.sl(pnew,ang[ia],pg[pg.no,1:2],pg[pg.no,3])
        pg<- rbind(pg[1:pg.no,],  c(cutp,angtan), c(cutp[1]+dxy,  cutp[2] +angtan*dxy,NA))
        # normal case lower polygon
        pg.interl<-pgl[,2]-angtan*pgl[,1]; pnew.interl<-pnewl[2]-angtan*pnewl[1]
        pg.nol<-sum(pg.interl>pnew.interl)
        if(is.na(pgl[pg.nol,3])) pgl[pg.nol,3] <- Inf # 121129 NaN/Na error
        cutpl<-cut.p.sl.p.sl(pnewl,angtan,pgl[pg.nol,1:2],pgl[pg.nol,3])
        pgl<-rbind(pgl[1:pg.nol,],c(cutpl,angtan),c(cutpl[1]-dxy, cutpl[2]-angtan*dxy,NA))
      }
      # if(kkk==KKK && ia == 51) { cat("ENDE: pgl"); print(pgl) }
      # update pg, pgl completed
      # PG<<-pg;PG.NO<<-pg.no;CUTP<<-cutp;DXY<<-dxy;PNEW<<-pnew;PGL<<-pgl;PG.NOL<<-pg.nol
      #### ---**************************
      # cat("angtan",angtan,"pg.no",pg.no,"pkt:",pnew)
      # if(ia==stopp) lines(pg,type="b",col="green")
      if(debug.plots=="all"){
        points(pnew[1],pnew[2],col="red")
        hx<-xyxy[ind.k,c(1,1)]; hy<-xyxy[ind.k,c(2,2)]
        segments(hx,hy,c(10,-10),hy+ang[ia]*(c(10,-10)-hx),lty=2)
        # text(hx+rnorm(1,,.1),hy+rnorm(1,,.1),ia)
        # print(pg)
        # if(ia==stopp) lines(pgl,type="b",col="green")
        points(cutpl[1],cutpl[2],col="red")
        hx<-xyxy[ind.kk,c(1,1)]; hy<-xyxy[ind.kk,c(2,2)]
        segments(hx,hy,c(10,-10),hy+ang[ia]*(c(10,-10)-hx),lty=2)
        #  text(hx+rnorm(1,,.1),hy+rnorm(1,,.1),ia)
        # print(pgl)
      }
      ##show pg pgl##
    }
    # if(verbose) PG <<- pg; PGL <<- pgl
    if(2<nrow(pg) && 2<nrow(pgl)){

      # plot(xyxy[,1:2],xlim=c(-.5,+.5),ylim=c(-.5,.50))
      # lines(pg,type="b",col="red"); lines(pgl,type="b",col="blue")
      # remove first and last points and multiple points #<show pg pgl>#
      limit<-1e-10
      # pg <-pg [c(TRUE,(abs(diff(pg [,1]))>limit)|(abs(diff(pg [,2]))>limit)),] old#
      idx <- c(TRUE,(abs(diff(pg [,1]))>limit)|(abs(diff(pg [,2]))>limit)) # 121008
      if(any(idx==FALSE)){
        pg <-pg[idx,]; pg[,3] <- c(diff(pg[,2])/diff(pg[,1]), NA)
      }
      # old reduction which caused some errors:
      # pgl<-pgl[c(TRUE,(abs(diff(pgl[,1]))>limit)|(abs(diff(pgl[,2]))>limit)),] error##
      # pgl<-pgl[c(     (abs(diff(pgl[,1]))>limit)|(abs(diff(pgl[,2]))>limit),TRUE),] old#
      idx <-      c(     (abs(diff(pgl[,1]))>limit)|(abs(diff(pgl[,2]))>limit),TRUE)#121008
      if(any(idx==FALSE)){
        pgl<-pgl[idx,]; pgl[,3] <- c(diff(pgl[,2])/diff(pgl[,1]), NA)
      }
      # add some tolerance in course of numerical problems
      pgl[,2]<-pgl[,2] - .00001  #### 121004
      # show pg pgl>>
      pg<- pg [-nrow(pg ),][-1,,drop=FALSE]
      pgl<-pgl[-nrow(pgl),][-1,,drop=FALSE]
      # determine position according to the other polygon
      #   cat("relative position: lower polygon")
      indl<-pos.to.pg(round(pgl,digits=10),round(pg,digits=10))  # 121126
      #   cat("relative position: upper polygon")
      indu<-pos.to.pg(round(pg,digits=10),round(pgl,digits=10),TRUE)
      sr<-sl<-NULL # ; ##show pg pgl>>
      # right region
      if(indu[(npg<-nrow(pg))]=="lower" & indl[1]=="higher"){
        # cat("in if of right region: the upper polynom is somewhere lower")
        #  checking from the right: last point of lower polygon that is NOT ok
        rnuml<-which(indl=="lower")[1]-1
        #  checking from the left: last point of upper polygon that is ok
        rnumu<-npg+1-which(rev(indu=="higher"))[1]
        #  special case all points of lower polygon are upper
        if(is.na(rnuml)) rnuml<-sum(pg[rnumu,1]<pgl[,1])
        #  special case all points of upper polygon are lower
        if(is.na(rnumu)) rnumu<-sum(pg[,1]<pgl[rnuml,1])
        xyl<-pgl[rnuml,]; xyu<-pg[rnumu,]
        # cat("right"); print(rnuml); print(xyl)
        # cat("right"); print(rnumu); print(xyu)
        sr<-cut.p.sl.p.sl(xyl[1:2],xyl[3],xyu[1:2],xyu[3])
      }
      # left region
      if(indl[(npgl<-nrow(pgl))]=="higher"&indu[1]=="lower"){
        # cat("in if of left region: the upper polynom is somewhere lower")
        #  checking from the right: last point of lower polygon that is ok
        lnuml<-npgl+1-which(rev(indl=="lower"))[1]
        #  checking from the left: last point of upper polygon that is NOT ok
        lnumu<-which(indu=="higher")[1]-1
        #  special case all points of lower polygon are upper
        if(is.na(lnuml)) lnuml<-sum(pg[lnumu,1]<pgl[,1])
        #  special case all points of upper polygon are lower
        if(is.na(lnumu)) lnumu<-sum(pg[,1]<pgl[lnuml,1])
        xyl<-pgl[lnuml,]; xyu<-pg[lnumu,]
        # cat("left"); print(lnuml); print(xyl)
        # cat("left"); print(lnumu); print(xyu)
        sl<-cut.p.sl.p.sl(xyl[1:2],xyl[3],xyu[1:2],xyu[3])
      }
      # if(kkk==2){ ##show pg pgl##; INDU<<-indu; INDL<<-indl; PGL<<-pgl; PGU<<-pg}
      pg<-rbind(pg [indu=="higher",1:2,drop=FALSE],sr,
                pgl[indl=="lower", 1:2,drop=FALSE],sl)
      if(debug.plots=="all") lines(rbind(pg,pg[1,]),col="red")
      if(!any(is.na(pg)))  pg<-pg[chull(pg[,1],pg[,2]),]
      # if(kkk==7){ PG <<- pg }
    } else {
      if(2<nrow(pgl)){ #121204
        pg <- rbind(pg[2,1:2],pgl[-c(1,length(pgl[,1])),1:2])
      } else {
        pg <- rbind(pg [-c(1,length(pg [,1])),1:2],pgl[2,1:2])
        # rbind(pgl[2,1:2],pg[2,1:2])
      }
    }
    if(verbose) cat("END of computation of the directions")
    exp.dk.1<-cbind(pg[,1]*xysd[1]+xym[1],pg[,2]*xysd[2]+xym[2])
    if(is.null(exp.dk)) exp.dk <- exp.dk.1
    # EX.1 <<- exp.dk.1; EX   <<- exp.dk
    if(verbose) print("End of find hulls, method two")
  }

  # if(max(d.k[,2])==k.1||nrow(d.k)==1) lambda<-0 else {  ### 121027
  if(nrow(d.k)==k.1 || nrow(d.k)==1) lambda<-0 else {  # 121126
    ind <- sum(d.k[,2] <= k.1) # complicated, may be wrong in case of missing depths
    ind <- k.1 # 121123
    ndk.1 <- d.k[ ind, 1]
    ndk   <- d.k[ ind+1, 1] # number inner
    #         (halve - number inner)/(number outer - number inner)
    lambda  <-(n/2-ndk)             /(ndk.1   - ndk)
    # lambda<-(n/2-d.k[k.1+1,1])    /(d.k[k.1,1]-d.k[k.1+1,1]) ### old
    # cat(n/2, ndk,ndk.1, "k.1",k.1,"ind",ind)
  }
  if(verbose) cat("lambda",lambda)

  cut.on.pdk.1<-find.cut.z.pg(exp.dk,  exp.dk.1,center=center)
  # print("HALLO"); print(cut.on.pdk.1)
  cut.on.pdk  <-find.cut.z.pg(exp.dk.1,exp.dk,  center=center)
  # expand inner polgon exp.dk
  h1<-(1-lambda)*exp.dk+lambda*cut.on.pdk.1
  # shrink outer polygon exp.dk.1
  h2<-(1-lambda)*cut.on.pdk+lambda*exp.dk.1
  h<-rbind(h1,h2);
  h<-h[!is.nan(h[,1])&!is.nan(h[,2]),]
  hull.bag<-h[chull(h[,1],h[,2]),]
  # if(verbose){
  #   plot(xy); lines(exp.dk,col="red"); lines(exp.dk.1,col="blue");
  #   segments(cut.on.pdk[,1],cut.on.pdk[,2],exp.dk.1[,1],exp.dk.1[,2],col="red")
  #   segments(cut.on.pdk.1[,1],cut.on.pdk.1[,2],exp.dk[,1],exp.dk[,2],col="blue",lwd=3)
  #   points(cut.on.pdk.1,col="blue"); cat("cut.on.pdk.1"); print(cut.on.pdk.1)
  #   points(cut.on.pdk,col="red"); cat("cut.on.pdk"); print(cut.on.pdk)
  #   lines(hull.bag,col="green")
  # }
  if(verbose)cat("bag completed:")
  #if(verbose) print(hull.bag)
  if(debug.plots=="all"){   lines(hull.bag,col="red") }

  hull.loop<-cbind(hull.bag[,1]-center[1],hull.bag[,2]-center[2])
  hull.loop<-factor*hull.loop
  hull.loop<-cbind(hull.loop[,1]+center[1],hull.loop[,2]+center[2])
  if(verbose) cat("loop computed")

  if(!very.large.data.set){
    pxy.bag    <-xydata[hdepth>= k   ,,drop=FALSE]
    pkt.cand   <-xydata[hdepth==(k-1),,drop=FALSE]
    pkt.not.bag<-xydata[hdepth< (k-1),,drop=FALSE]
    if( 0 < length(pkt.cand) && 0 < length(hull.bag) ){
      outside<-out.of.polygon(pkt.cand,hull.bag)
      if(sum(!outside)>0)
        pxy.bag    <-rbind(pxy.bag,     pkt.cand[!outside,])
      if(sum( outside)>0)
        pkt.not.bag<-rbind(pkt.not.bag, pkt.cand[ outside,])
    }
  }else {
    extr<-out.of.polygon(xydata,hull.bag)
    pxy.bag    <-xydata[!extr,]
    pkt.not.bag<-xydata[extr,,drop=FALSE]
  }
  if(length(pkt.not.bag)>0){
    extr<-out.of.polygon(pkt.not.bag,hull.loop)
    pxy.outlier<-pkt.not.bag[extr,,drop=FALSE]
    if(0==length(pxy.outlier)) pxy.outlier<-NULL
    pxy.outer<-pkt.not.bag[!extr,,drop=FALSE]
  }else{
    pxy.outer<-pxy.outlier<-NULL
  }
  if(verbose) cat("points of bag, outer points and outlier identified")

  hull.loop<-rbind(pxy.outer,hull.bag)
  hull.loop<-hull.loop[chull(hull.loop[,1],hull.loop[,2]),]
  if(verbose) cat("end of computation of loop")

  res<-list(
    center=center,
    hull.center=hull.center,
    hull.bag=hull.bag,
    hull.loop=hull.loop,
    pxy.bag=pxy.bag,
    pxy.outer=if(length(pxy.outer)>0) pxy.outer else NULL,
    pxy.outlier=if(length(pxy.outlier)>0) pxy.outlier else NULL,
    hdepths=hdepth,
    is.one.dim=is.one.dim,
    prdata=prdata,
    # random.seed=random.seed,  ###SEED
    xy=xy,xydata=xydata
  )
  if(verbose) res<-c(res,list(exp.dk=exp.dk,exp.dk.1=exp.dk.1,hdepth=hdepth))
  class(res)<-"bagplot"
  return(res)
}

plot.bagplot <- function(x,
                       show.outlier=TRUE,# if TRUE outlier are shown
                       show.whiskers=TRUE, # if TRUE whiskers are shown
                       show.looppoints=TRUE, # if TRUE points in loop are shown
                       show.bagpoints=TRUE, # if TRUE points in bag are shown
                       show.loophull=TRUE, # if TRUE loop is shown
                       show.baghull=TRUE, # if TRUE bag is shown
                       add=FALSE, # if TRUE graphical elements are added to actual plot
                       pch=16,cex=.4, # to define further parameters of plot
                       verbose=FALSE, # tools for debugging
                       col.loophull="#aaccff", # Alternatives: #ccffaa, #ffaacc
                       col.looppoints="#3355ff", # Alternatives: #55ff33, #ff3355
                       col.baghull="#7799ff", # Alternatives: #99ff77, #ff7799
                       col.bagpoints="#000088", # Alternatives: #008800, #880000
                       transparency=FALSE,...
){
  if(missing(x)) return(
    "bagplot, version 2012/12/05, peter wolf"
  )
  # transparency flag and color flags have been proposed by wouter
  if (transparency==TRUE) {
    col.loophull = paste(col.loophull, "99", sep="")
    col.baghull = paste(col.baghull, "99", sep="")
  }

  win<-function(dx,dy){  atan2(y=dy,x=dx) }

  cut.z.pg<-function(zx,zy,p1x,p1y,p2x,p2y){
    a2<-(p2y-p1y)/(p2x-p1x); a1<-zy/zx
    sx<-(p1y-a2*p1x)/(a1-a2); sy<-a1*sx
    sxy<-cbind(sx,sy)
    h<-any(is.nan(sxy))||any(is.na(sxy))||any(Inf==abs(sxy))
    if(h){ # print("NAN found"); print(cbind(a1,a2,zx,zy,sxy,p2x-p1x))
      if(!exists("verbose")) verbose<-FALSE
      if(verbose) cat("special")
      # zx is zero ### 121030
      h<-0==zx
      sx<-ifelse(h,zx,sx); sy<-ifelse(h,p1y-a2*p1x,sy)
      # points on line defined by line segment
      a1 <- ifelse( abs(a1) == Inf, sign(a1)*123456789*1E10, a1) # 121030
      a2 <- ifelse( abs(a2) == Inf, sign(a2)*123456789*1E10, a2)
      # points on line defined by line segment
      h<-0==(a1-a2) & sign(zx)==sign(p1x)
      sx<-ifelse(h,p1x,sx); sy<-ifelse(h,p1y,sy)
      h<-0==(a1-a2) & sign(zx)!=sign(p1x)
      sx<-ifelse(h,p2x,sx); sy<-ifelse(h,p2y,sy)
      # line segment vertical
      #   & center NOT ON line segment
      h<-p1x==p2x & zx!=p1x & p1x!=0
      sx<-ifelse(h,p1x,sx); sy<-ifelse(h,zy*p1x/zx,sy)
      #   & center ON line segment
      h<-p1x==p2x & zx!=p1x & p1x==0
      sx<-ifelse(h,p1x,sx); sy<-ifelse(h,0,sy)
      #   & center NOT ON line segment & point on line     ### 121126
      h<-p1x==p2x & zx==p1x & p1x!=0 # & sign(zy)==sign(p1y)
      sx<-ifelse(h,zx,sx); sy<-ifelse(h,zy,sy)
      #   & center ON line segment & point on line
      h<-p1x==p2x & zx==p1x & p1x==0 & sign(zy)==sign(p1y)
      sx<-ifelse(h,p1x,sx); sy<-ifelse(h,p1y,sy)
      h<-p1x==p2x & zx==p1x & p1x==0 & sign(zy)!=sign(p1y)
      sx<-ifelse(h,p1x,sx); sy<-ifelse(h,p2y,sy)
      #  points identical to end points of line segment
      h<-zx==p1x & zy==p1y; sx<-ifelse(h,p1x,sx); sy<-ifelse(h,p1y,sy)
      h<-zx==p2x & zy==p2y; sx<-ifelse(h,p2x,sx); sy<-ifelse(h,p2y,sy)
      # point of z is center
      h<-zx==0 & zy==0; sx<-ifelse(h,0,sx); sy<-ifelse(h,0,sy)
      sxy<-cbind(sx,sy)
    } # end of special cases
    #if(verbose){ print(rbind(a1,a2));print(cbind(zx,zy,p1x,p1y,p2x,p2y,sxy))}
    if(!exists("debug.plots")) debug.plots<-"no"
    if(debug.plots=="all"){
      segments(sxy[,1],sxy[,2],zx,zy,col="red")
      segments(0,0,sxy[,1],sxy[,2],col="green",lty=2) ##!!
      points(sxy,col="red")
    }
    return(sxy)
  }

  find.cut.z.pg<-function(z,pg,center=c(0,0),debug.plots="no"){
    if(!is.matrix(z)) z<-rbind(z)
    if(1==nrow(pg)) return(matrix(center,nrow(z),2,TRUE))
    n.pg<-nrow(pg); n.z<-nrow(z)
    z<-cbind(z[,1]-center[1],z[,2]-center[2])
    pgo<-pg; pg<-cbind(pg[,1]-center[1],pg[,2]-center[2])
    if(!exists("debug.plots")) debug.plots<-"no"
    if(debug.plots=="all"){
      plot(rbind(z,pg,0),bty="n"); points(z,pch="p")
      lines(c(pg[,1],pg[1,1]),c(pg[,2],pg[1,2]))}
    # find angles of pg und z
    apg<-win(pg[,1],pg[,2])
    apg[is.nan(apg)]<-0; a<-order(apg); apg<-apg[a]; pg<-pg[a,]
    az<-win(z[,1],z[,2])
    # find line segments
    segm.no<-apply((outer(apg,az,"<")),2,sum)
    segm.no<-ifelse(segm.no==0,n.pg,segm.no)
    next.no<-1+(segm.no %% length(apg))
    # compute cut points
    cuts<-cut.z.pg(z[,1],z[,2],pg[segm.no,1],pg[segm.no,2],
                   pg[next.no,1],pg[next.no,2])
    # rescale
    cuts<-cbind(cuts[,1]+center[1],cuts[,2]+center[2])
    return(cuts)
  }
  # find.cut.z.pg(EX,  EX1,center=CE)

  center<-hull.center<-hull.bag<-hull.loop<-pxy.bag<-pxy.outer<-pxy.outlier<-NULL
  # random.seed <-
  hdepths<-is.one.dim<-prdata<-xy<-xydata<-exp.dk<-exp.dk.1<-hdepth<-NULL
  tphdepth<-tp<-NULL
  #090216
  bagplotobj<-x
  for(i in seq(along=bagplotobj))
    eval(parse(text=paste(names(bagplotobj)[i],"<-bagplotobj[[",i,"]]")))
  if(is.one.dim){

    if(!verbose) cat("data set one dimensional") # 121202
    ROT<-round(prdata[[2]],digits=5); IROT<-round(solve(ROT),digits=5)
    if(!add){ ## 121008 ## 121130
      plot(xydata,type="n",bty="n",pch=16,cex=1, ...) # xlim=xlim, ylim=ylim, ...)
    }
    # find five points for box and whiskers
    usr <- par()$usr; xlim <- usr[1:2]; ylim <- usr[3:4]
    mins <- usr[c(1,3)]; ranges <- usr[c(2,4)] - mins
    if(ROT[1,1]==0){ #  cat("FALL senkrecht")
      xydata <- cbind( mean(usr[1:2])  ,xydata[,2])
      boxplotres<-boxplot(xydata[,2],plot=FALSE)
      five<-cbind(mean(usr[1:2]),boxplotres$stat)
      dx <- 0.1*(xlim[2]-xlim[1]); dy <- 0
      idx.out <- if(0<length(boxplotres$out)) match(boxplotres$out, xydata[,2] ) else NULL
    }
    if(ROT[1,2]==0){ #  cat("FALL waagerecht")
      xydata <- cbind( xydata[,1], mean(usr[3:4]))
      boxplotres<-boxplot(xydata[,1],plot=FALSE)
      five<-cbind(boxplotres$stat,mean(usr[3:4]))
      dx <- 0; dy <- 0.1*(ylim[2]-ylim[1]) # 1/5 of del.y
      idx.out <- if(0<length(boxplotres$out)) match(boxplotres$out, xydata[,1] ) else NULL
    }
    if(ROT[1,2]!=0 && ROT[1,1]!=0){
      xytr<-xydata%*%ROT
      boxplotres<-boxplot(xytr[,1],plot=FALSE)
      five<-cbind(boxplotres$stat,xytr[1,2])%*%IROT
      # find small vector for box height
      vec <- five[5,] - five[1,]
      vec.ortho <- c(vec[2],-vec[1]) * ranges / par()$pin
      xy.delta <- vec.ortho * par()$pin[2:1] * ranges # plot region inches
      xy.delta <- xy.delta / sqrt( sum(xy.delta * xy.delta) )
      xy.delta <- xy.delta * .15 / ( sqrt(sum(abs(par()$pin*xy.delta/ranges)^2) ))
      dx <- xy.delta[1]; dy <- xy.delta[2]
      idx.out <- if(0<length(boxplotres$out)) match(boxplotres$out, xytr ) else NULL
    }
    # construct segments
    # whiskers
    segments(five[h<-c(1,5),1],five[h,2],five[h<-c(2,4),1],five[h,2], # col=col.looppoints,
             lwd=2)
    points(five[c(1,5),], cex=1, col=col.looppoints,pch=16)
    # box
    #segments(five[h<-2:4,1] + dx, five[h,2] + dy, five[h,1] - dx, five[h,2] - dy,
    #         col=col.bagpoints,lwd=2)
    #segments(five[2,1] + (h<-c(-1,1))*dx, five[2,2] + h*dy,
    #         five[4,1] + h*dx, five[4,2] + h*dy,
    #         col=col.bagpoints,lwd=2)
    polygon(five[c(2,4,4,2,2),1] + c(dx,dx,-dx,-dx,dx),
            five[c(2,4,4,2,2),2] + c(dy,dy,-dy,-dy,dy),
            col=col.baghull,lwd=1)
    # median
    segments(five[h<-3  ,1] + dx, five[h,2] + dy,
             five[h,1] - dx, five[h,2] - dy,col="red",lwd=3)
    # Outlier
    if(0 < length(idx.out) && !is.na(idx.out[1])){
      points(xydata[idx.out,,drop=FALSE], cex=1, pch=16,col="red")
    }
    #  segments(five[3,1],five[3,2],five[3,1]+1*vec.ortho[1],
    #           five[3,2]+100*vec.ortho[2],col="green",lwd=5)
    #  segments(five[3,1],five[3,2],five[3,1]+1*vec1[1],
    #           five[3,2]+1*vec1[2],col="red",lwd=5)
    #  points(five,cex=2,col="green")
    return("one dimensional boxplot plottet")
  } else {

    if(!add) plot(xydata,type="n",pch=pch,cex=cex,bty="n",...)
    if(verbose) text(xy[,1],xy[,2],paste(as.character(hdepth))) # cex=2 needs fonts
    # loop: --************
    if(show.loophull){ # fill loop
      h<-rbind(hull.loop,hull.loop[1,]); lines(h[,1],h[,2],lty=1)
      polygon(hull.loop[,1],hull.loop[,2],col=col.loophull)
    }
    if(show.looppoints && 0 < length(pxy.outer)){ # points in loop
      points(pxy.outer[,1],pxy.outer[,2],col=col.looppoints,pch=pch,cex=cex)
    }
    # bag: --*****************
    if(show.baghull && 0 < length(hull.bag)){ # fill bag
      h<-rbind(hull.bag,hull.bag[1,]); lines(h[,1],h[,2],lty=1)
      polygon(hull.bag[,1],hull.bag[,2],col=col.baghull)
    }
    if(show.bagpoints && 0 < length(pxy.bag)){ # points in bag
      points(pxy.bag[,1],pxy.bag[,2],col=col.bagpoints,pch=pch,cex=cex)
    }
    # whiskers
    if(show.whiskers && 0 < length(pxy.outer)){
      debug.plots<-"not"
      if((n<-length(xy[,1]))<15){
        segments(xy[,1],xy[,2],rep(center[1],n),rep(center[2],n),
                 col="red")
      }else{
        pkt.cut<-find.cut.z.pg(pxy.outer,hull.bag,center=center)
        segments(pxy.outer[,1],pxy.outer[,2],pkt.cut[,1],pkt.cut[,2],
                 col="red")
      }
    }
    # outlier: ---**********************
    if(show.outlier && 0 < length(pxy.outlier)){ # points in loop
      points(pxy.outlier[,1],pxy.outlier[,2],col="red",pch=pch,cex=cex)
    }
    # center:
    if(exists("hull.center") && 2 < length(hull.center)){
      h<-rbind(hull.center,hull.center[1,]); lines(h[,1],h[,2],lty=1)
      polygon(hull.center[,1],hull.center[,2],col="orange")
    }
    if(!is.one.dim) points(center[1],center[2],pch=8,col="red")
    if(verbose && 0 < length(exp.dk.1) ){
      h<-rbind(exp.dk,exp.dk[1,]); lines(h,col="blue",lty=2)
      h<-rbind(exp.dk.1,exp.dk.1[1,]); lines(h,col="black",lty=2, lwd=3)
      if(exists("tphdepth") && 0<length(tphdepth))
        text(tp[,1],tp[,2],as.character(tphdepth),col="green")
      text(xy[,1],xy[,2],paste(as.character(hdepth)))  # cex=2 needs special fonts
      points(center[1],center[2],pch=8,col="red")
    }
    "bagplot plottet"
  }
}

# find.hdepths <- function(xy, number.of.directions=181){ ### 121126

  # xy <- as.matrix(xy)
  # for( j in 1:2) {
    # xy[,j] <- xy[,j] - min(xy[,j])
    # if( 0 < (h <- max(xy[,j]))) xy[,j] <- xy[,j] / max(xy[,j])
  # }

  # phi    <- c(seq(0,180,length=number.of.directions)[-1]*(2*pi/360))
  # sinphi <- c(sin(phi),1); cosphi <- c(cos(phi),0)
  # RM1 <- round(digits=6,rbind(cosphi,sinphi))
  # hd <- rep(h<-length(xy[,1]),h)
  # for( j in seq(along=sinphi)){
    # xyt <- xy %*% RM1[,j]
    # hd <- pmin(hd,rank(xyt,ties.method="min"), rank(-xyt,ties.method="min"))
  # }
  # ###  xyt <- xy %*% RM1
  # ### hd2 <- cbind(apply(xyt, 2, rank, ties.method="min"),
  # ###               apply(-xyt,2, rank, ties.method="min"))
  # ###  hd2 <- apply(hd2, 1, min)
  # hd
# }
# find.hdepths.tp <- function(tp, data, number.of.directions=181){ ### 121130
  # ### standardize dimensions ###
  # xy <- as.matrix(data); tp <- as.matrix(rbind(tp)); n.tp <- dim(tp)[1]
  # for( j in 1:2) {
    # xy[,j] <- xy[,j] - (h <- min(xy[,j], na.rm=TRUE))
    # tp[,j] <- tp[,j] -  h
    # if( 0 < (h <- max(xy[,j], na.rm=TRUE))){
      # xy[,j] <- xy[,j]/h; tp[,j] <- tp[,j]/h
    # }
  # }
  # ##loop over directions##
  # phi    <- c(seq(0,180,length=number.of.directions)[-1]*(2*pi/360))
  # sinphi <- c(sin(phi),1); cosphi <- c(cos(phi),0)
  # RM1 <- round(digits=6,rbind(cosphi,sinphi))
  # hdtp <- rep(length(xy[,1]),length(tp[,1]))
  # for( j in seq(along=sinphi)){ #print(j)
    # xyt <- xy %*% RM1[,j]; tpt <- (tp %*% RM1[,j])[]
    # xyt <- xyt[!is.na(xyt)] #; tpt <- sort(tpt)
    # hdtp <- pmin(hdtp,(rank( c(tpt,xyt), ties.method="min"))[1:n.tp]
                 # -rank( tpt,ties.method="min")
                 # ,rank(-c(tpt,xyt), ties.method="min")[1:n.tp]
                 # -rank(-tpt,ties.method="min")
    # )
  # }
  # hdtp
# }

# hdepth<-function(xy,data){
  # ###function to compute the h-depths of points

  # win<-function(dx,dy){  atan2(y=dy,x=dx) }
  # if(missing(data)) data <- xy
  # tp <- xy; xy <- data
  # n.tp<-nrow(tp); n <- length(xy[,1])
  # tphdepth<-rep(0,n.tp); dpi<-2*pi-0.000001
  # for(j in 1:n.tp) {
    # ### compute difference of coordinates of tp j and data
    # dx<-tp[j,1]-xy[,1]; dy<-tp[j,2]-xy[,2]
    # ### remove data points that are identical to tp j
    # h <- tp[j,1] != xy[,1] & tp[j,2] != xy[,2]
    # dx <- dx[h]; dy <- dy[h]; n <- length(dx)
    # minusplus<-c(rep(-1,n),rep(1,n)) #### 070824
    # ### compute angles of slopes of lines through tp j and data
    # a<-win(dx,dy)+pi; h<-a<10; a<-a[h]; ident<-sum(!h)
    # ### count number of angles that are lower than pi == points above tp j
    # init<-sum(a < pi); a.shift<-(a+pi) %% dpi
    # ### count points relative to the tp j in halve planes
    # h<-cumsum(minusplus[order(c(a,a.shift))])
    # ### find minimum number of points in a halve plane
    # tphdepth[j]<-init+min(h)+1 ### +1 because of the point itself!!
    # ### tphdepth[j]<-init+min(h)+ident; cat("SUMME",ident)
  # }
  # tphdepth
# }

# hdepth <- find.hdepths.tp #121202

PlotBag <- function(x, y,
                    factor=3, # expanding factor for bag to get the loop
                    na.rm=FALSE, # should 'NAs' values be removed or exchanged
                    approx.limit=300, # limit
                    show.outlier=TRUE,# if TRUE outlier are shown
                    show.whiskers=TRUE, # if TRUE whiskers are shown
                    show.looppoints=TRUE, # if TRUE points in loop are shown
                    show.bagpoints=TRUE, # if TRUE points in bag are shown
                    show.loophull=TRUE, # if TRUE loop is shown
                    show.baghull=TRUE, # if TRUE bag is shown
                    create.plot=TRUE, # if TRUE a plot is created
                    add=FALSE, # if TRUE graphical elements are added to actual plot
                    pch=16,cex=.4, # some graphical parameters
                    dkmethod=2, # in 1:2; there are two methods for approximating the bag
                    precision=1, # controls precision of computation
                    verbose=FALSE,debug.plots="no", # tools for debugging
                    col.loophull="#aaccff", # Alternatives: #ccffaa, #ffaacc
                    col.looppoints="#3355ff", # Alternatives: #55ff33, #ff3355
                    col.baghull="#7799ff", # Alternatives: #99ff77, #ff7799
                    col.bagpoints="#000088", # Alternatives: #008800, #880000
                    transparency=FALSE, ... # to define further parameters of plot
){
  if(missing(x)) return(
    "bagplot, version 2012/12/05, peter wolf"
  )
  bo<-compute.bagplot(x=x,y=y,factor=factor,na.rm=na.rm,
                      approx.limit=approx.limit,dkmethod=dkmethod,
                      precision=precision,verbose=verbose,debug.plots=debug.plots)
  if(create.plot){
    plot(bo,
         show.outlier=show.outlier,
         show.whiskers=show.whiskers,
         show.looppoints=show.looppoints,
         show.bagpoints=show.bagpoints,
         show.loophull=show.loophull,
         show.baghull=show.baghull,
         add=add,pch=pch,cex=cex,
         verbose=verbose,
         col.loophull=col.loophull,
         col.looppoints=col.looppoints,
         col.baghull=col.baghull,
         col.bagpoints=col.bagpoints,
         transparency=transparency, ...
    )
  }
  invisible(bo)
}


###

## plots: PlotCirc ====


PlotCirc <- function(tab, acol = rainbow(sum(dim(tab))), aborder = "darkgrey",
                     rcol = SetAlpha(acol[1:nrow(tab)], 0.5), rborder = "darkgrey",
                     gap = 5, main = "", labels = NULL, cex.lab = 1.0,
                     las = 1, adj = NULL, dist = 2){

  ribbon <- function( angle1.beg, angle1.end, angle2.beg, angle2.end,
                      radius1 = 1, radius2 = radius1, col = "blue",
                      border ="darkgrey" ){
    xy1 <- DescTools::PolToCart( radius1, angle1.beg )
    xy2 <- DescTools::PolToCart( radius2, angle1.end )
    xy3 <- DescTools::PolToCart( radius1, angle2.beg )
    xy4 <- DescTools::PolToCart( radius2, angle2.end )

    bez1 <- DescTools::DrawArc(radius.x = radius2, angle.beg = DescTools::CartToPol(xy2$x, xy2$y)$theta, angle.end = DescTools::CartToPol(xy4$x, xy4$y)$theta, plot=FALSE)[[1]]
    bez2 <- DescTools::DrawBezier( x = c(xy4$x, 0, xy3$x), y = c(xy4$y, 0, xy3$y), plot=FALSE )
    bez3 <- DescTools::DrawArc(radius.x = radius1, angle.beg=DescTools::CartToPol(xy3$x, xy3$y)$theta, angle.end=DescTools::CartToPol(xy1$x, xy1$y)$theta, plot=FALSE )[[1]]
    bez4 <- DescTools::DrawBezier( x = c(xy1$x, 0, xy2$x), y = c(xy1$y, 0, xy2$y), plot=FALSE )

    polygon( x=c(bez1$x, bez2$x, bez3$x, bez4$x),
             y=c(bez1$y, bez2$y, bez3$y, bez4$y), col=col, border=border)
  }

  n <- sum(tab)
  ncol <- ncol(tab)
  nrow <- nrow(tab)
  d <- DegToRad(gap)    # the gap between the sectors in radiant

  acol <- rep(acol, length.out = ncol+nrow)
  rcol <- rep(rcol, length.out = nrow)
  aborder <- rep(aborder, length.out = ncol+nrow)
  rborder <- rep(rborder, length.out = nrow)

  mpts.left <- c(0, cumsum(as.vector(rbind(rev(apply(tab, 2, sum))/ n * (pi - ncol * d), d))))
  mpts.right <- cumsum(as.vector(rbind(rev(apply(tab, 1, sum))/ n * (pi - nrow * d), d)))
  mpts <- c(mpts.left, mpts.right + pi) + pi/2 + d/2

  DescTools::Canvas(10, main=main, xpd=TRUE)
  DescTools::DrawAnnulusSector(x=0, y=0, radius.in=9.5, radius.out=10,
                    angle.beg=mpts[seq_along(mpts) %% 2 == 1], angle.end=mpts[seq_along(mpts) %% 2 == 0],
                    col=acol, border=aborder)

  if(is.null(labels)) labels <- rev(c(rownames(tab), colnames(tab)))

  ttab <- rbind(DescTools::Rev(tab, margin=2) / n * (pi - ncol * d), d)
  pts.left <- (c(0, cumsum(as.vector(ttab))))

  ttab <- rbind(DescTools::Rev(t(tab), margin=2)/ n * (pi - nrow * d), d)
  pts.right <- (c( cumsum(as.vector(ttab)))) + pi

  pts <- c(pts.left, pts.right) + pi/2 + d/2
  dpt <- data.frame(from=pts[-length(pts)], to=pts[-1])

  for( i in 1:ncol) {
    for( j in 1:nrow) {
      lang <- dpt[(i-1)*(nrow+1)+j,]
      rang <- DescTools::Rev(dpt[-nrow(dpt),], margin=1)[(j-1)*(ncol+1) + i,]
      ribbon( angle1.beg=rang[,2], angle1.end=lang[,1], angle2.beg=rang[,1], angle2.end=lang[,2],
              radius1 = 10, radius2 = 9, col = rcol[j], border = rborder[j])
    }}

  out <- DescTools::PolToCart(r = 10 + dist, theta=filter(mpts, rep(1/2,2))[seq(1,(nrow+ncol)*2, by=2)])

  if(las == 2){
    if(is.null(adj)) adj <- c(rep(1, nrow), rep(0,ncol))
    adj <- rep(adj, length_out=length(labels))
    sapply(seq_along(labels),
           function(i) text(out$x[i], out$y[i], labels=labels[i], cex=cex.lab,
                            srt=DescTools::RadToDeg(atan(out$y[i]/out$x[i])), adj=adj[i]))
  } else {
    text(out, labels=labels, cex=cex.lab, srt=ifelse(las==3, 90, 0), adj=adj)
  }

  invisible(out)

}



###

## plots: PlotWeb ====


PlotWeb <- function(m, col=c("red","blue"), lty=par("lty"), args.legend=NULL, pch=21, pt.cex=2,
                    pt.col="black", pt.bg="darkgrey", ... ){

# following an idee from library(LIM)
# example(plotweb)

  oldpar <- par(c("lend","xpd"))
  on.exit(par(oldpar))

  w <- 4
  par("xpd"=TRUE, lend="butt")

  DescTools::Canvas(w, ...)
  angles <- seq(0, 2*pi, length=nrow(m)+1)[-1]
  xy <- DescTools::PolToCart(r=3, theta=angles)
  cbind(1, (angles %[]% c(pi/2, 3*pi/2))*1)
  text(x=xy$x, y=round(xy$y,3), labels=colnames(m), pos=(!angles %[]% c(pi/2, 3*pi/2))*2 + 2, offset=1 )
  #text(x=xy$x, y=round(xy$y,3), labels="x", pos=(!angles %[]% c(pi/2, 3*pi/2))*2+2   )

  d.m <- data.frame( from=rep(colnames(m), nrow(m)), to=rep(colnames(m), each=nrow(m))
    , d=as.vector(m)
    , from.x=rep(xy$x, nrow(m)), from.y=rep(xy$y, nrow(m)), to.x=rep(xy$x, each=nrow(m)), to.y=rep(xy$y, each=nrow(m)) )
  # d.m <- d.m[d.m$d > 0,]
  # lineare transformation of linewidth
  a <- 1
  b <- 15
  d.m$d.sc <- (b-a) * (min(d.m$d)-a) + (b-a) /diff(range(d.m$d)) * d.m$d

  d.m$d.sc <- DescTools::LinScale(abs(d.m$d), newlow=0.5, newhigh=10 )
  col <- rep(col, length.out=2)
  segments( x0=d.m$from.x, y0=d.m$from.y, x1 = d.m$to.x, y1 = d.m$to.y,
         col = col[((sign(d.m$d)+1)/2)+1], lty = lty, lwd = d.m$d.sc, lend= 1)
  points( xy, cex=pt.cex, pch=pch, col=pt.col, bg=pt.bg )

  args.legend1 <- list( x="bottomright", inset=-0.05, legend=round(c(-min(abs(d.m$d)), max(abs(d.m$d))), 3)
                        , lwd = c(a,b), col=col, bg="white", cex=0.8)
  if ( !is.null(args.legend) ) { args.legend1[names(args.legend)] <- args.legend }
  add.legend <- TRUE
  if(!is.null(args.legend)) if(all(is.na(args.legend))) {add.legend <- FALSE}

  if(add.legend) do.call("legend", args.legend1)

  invisible(xy)

}


###

## plots: PlotCandlestick ====

PlotCandlestick <-  function(x, y, xlim = NULL, ylim = NULL, col = c("springgreen4","firebrick"), border=NA, args.grid = NULL, ...) {


  xlim <- if (is.null(xlim))
    range(x[is.finite(x)])
  else xlim
  ylim <- if (is.null(ylim))
    range(y[is.finite(y)])
  else ylim

  plot(x = 1, y = 1, xlim = xlim,
    ylim = ylim, type = "n", xaxt = "n", xlab = "", ...)

  add.grid <- TRUE
  if(!is.null(args.grid)) if(all(is.na(args.grid))) {add.grid <- FALSE}

  if (add.grid) {
    args.grid1 <- list(lty="solid", col="grey83")
    if (!is.null(args.grid)) {
      args.grid1[names(args.grid)] <- args.grid
    }
    do.call("grid", args.grid1)
  }

  # open low high close
  segments(x0 = x, y0 = y[,2], y1 = y[,3], col = col[(y[,1] > y[,4]) * 1 + 1])
  rect(xleft = x - 0.3, ybottom = y[,1], xright = x + 0.3, ytop = y[, 4],
    col = col[(y[,1] > y[,4]) * 1 + 1], border = border)

  axis(side = 1, at = x, labels = x)

}



###

## plots: PlotSuperbar

# ueberlagerte Barplots
# Superbarplot in UsingR


###

## plots: PlotMatrix ====


PlotMatrix <- function(x, y=NULL, data=NULL, panel=l.panel,
         nrows=0, ncols=nrows, save=TRUE, robrange.=FALSE, range.=NULL,
         pch=NULL, col=1, reference=0, ltyref=3,
         log="", xaxs="r", yaxs="r", xaxmar=NULL, yaxmar=NULL,
         vnames=NULL, main='', cex.points=NA, cex.lab=0.7, cex.text=1.3,
         cex.title=1,
         bty="o", oma=NULL, ...) {

# Purpose:    pairs  with different plotting characters, marks and/or colors
#             showing submatrices of the full scatterplot matrix
#             possibly on several pages
# ******************************************************************************
# Author: Werner Stahel, Date: 23 Jul 93; minor bug-fix+comments:
  # M.Maechler

  is.formula <- function(object) length(class(object))>0 && class(object)=="formula"


  l.panel <- function(x,y,indx,indy,pch=1,col=1,cex=cex.points,...) {
    if (is.character(pch)) text(x,y,pch,col=col,cex=cex) else
    points(x,y,pch=pch,col=col,cex=cex,...)
  }
  oldpar <- par(c("mfrow","mar","cex","oma","mgp"))
  on.exit(par(oldpar))
# **************** preparations **************
# data
  if (is.formula(x))  {
    if (length(x)==2)
    x <- model.frame(x,data, na.action=NULL)  else {
      ld <- model.frame(x[c(1,3)],data, na.action=NULL)
      ld <- cbind(ld, model.frame(x[1:2],data, na.action=NULL))
      x <- ld
    }
  }
  if (is.data.frame(x)) {
    for (jj in 1:length(x)) x[[jj]] <- as.numeric(x[[jj]])
    x <- as.matrix(x)
  } else x <- cbind(x)
#  stop("!PlotMatrix! first argument must either be a formula or a data.frame or matrix")
  nv1 <- dim(x)[2]
  lv1 <- lv2 <- 0
  if (is.null(y)) {
    ldata <- x
    if (save) { nv1 <- nv1-1; lv2 <- 1 }
    nv2 <- nv1
  } else { # cbind y to data for easier preparations
    save <- FALSE
    if (is.formula(y))  {
      ld <- model.frame(x[c(1,3)],data, na.action=NULL)
    if (length(x)>2)
      ld <- cbind(ld, model.frame(x[1:2],data, na.action=NULL))
    x <- ld
  }
    if (is.formula(y)) {
      if (length(y)==2)
        y <- model.frame(y,data, na.action=NULL)  else {
          ld <- model.frame(y[c(1,3)],data, na.action=NULL)
          ld <- cbind(ld, model.frame(y[1:2],data, na.action=NULL))
          y <- ld
        }
    }
    if (is.data.frame(y)) {
      for (jj in 1:length(y)) y[[jj]] <- as.numeric(y[[jj]])
      y <- as.matrix(y)
    }
    ldata <- cbind(x, as.matrix(y))
    nv2 <- ncol(ldata)-nv1 ; lv2 <- nv1 }
  nvv <- ncol(ldata)
  tnr <- nrow(ldata)
# variable labels
  if (missing(vnames)) vnames <- dimnames(ldata)[[2]]
  if (is.null(vnames)) vnames <- paste("V",1:nvv)
# plotting characters
  if (length(pch)==0) pch <- 1
# range
  rg <- matrix(nrow=2,ncol=nvv,dimnames=list(c("min","max"),vnames))
  if(is.matrix(range.)) {
    if (is.null(colnames(range.))) {
      if (ncol(range)==ncol(rg)) rg[,] <- range.  else
      warning('argument  range.  not suitable. ignored')
    } else {
      lj <- match(colnames(range.),vnames)
      if (any(is.na(lj))) {
        warning('variables', colnames(range.)[is.na(lj)],'not found')
        if (any(!is.na(lj))) rg[,lj[!is.na(lj)]] <- range.[,!is.na(lj)]
      }
    }
  }
  else
    if (length(range.)==2&&is.numeric(range.)) rg[,] <- matrix(range.,2,nvv)

  lna <- apply(is.na(rg),2, any)
  if (any(lna))
    rg[,lna] <- apply(ldata[,lna,drop=FALSE],2,
      if(robrange.) RobRange else range, na.rm=TRUE, finite=TRUE)
  colnames(rg) <- vnames
# reference lines
  tjref <- (length(reference)>0)&&!(is.logical(reference)&&!reference)
  if (tjref) {
    if(length(reference)==1) lref <- rep(reference,length=nvv) else {
      lref <- rep(NA,nvv)
      lref[match(names(reference),vnames)] <- reference
    }
    names(lref) <- vnames
  }
# plot
  jmain <- !is.null(main)&&main!=""
  lpin <- par("pin")
  lnm <- if (lpin[1]>lpin[2]) {
    if (nv1==6 && nv2==6) c(6,6) else c(5,6) } else c(8,5)
  if (is.na(nrows)||nrows<1) nrows <- ceiling(nv1/((nv1-1)%/%lnm[1]+1))
  if (is.na(ncols)||ncols<1) ncols <- ceiling(nv2/((nv2-1)%/%lnm[2]+1))
  if (is.null(xaxmar)) xaxmar <- 1+(nv1*nv2>1)
  if (any(is.na(xaxmar))) xaxmar <- 1+(nv1*nv2>1)
  xaxmar <- ifelse(xaxmar>1,3,1)
  if (is.null(yaxmar)) yaxmar <- 2+(nv1*nv2>1)
  if (any(is.na(yaxmar))) yaxmar <- 2+(nv1*nv2>1)
  yaxmar <- ifelse(yaxmar>2,4,2)
  if (length(oma)!=4)
    oma <- c(2+(xaxmar==1), 2+(yaxmar==2),
             1.5+(xaxmar==3)+cex.title*2*jmain,
             2+(yaxmar==4))
#    oma <- 2 + c(0,0,!is.null(main)&&main!="",1)
  par(mfrow=c(nrows,ncols))
##-   if (!is.na(cex)) par(cex=cex)
##-   cex <- par("cex")
##-   cexl <- cex*cexlab
##-   cext <- cex*cextext
  par(oma=oma*cex.lab, mar=rep(0.2,4), mgp=cex.lab*c(1,0.5,0))
  if (is.na(cex.points)) cex.points <- max(0.2,min(1,1.5-0.2*log(tnr)))
#
  # log
  if (length(grep("x",log))>0) ldata[ldata[,1:nv1]<=0,1:nv1] <- NA
  if (length(grep("y",log))>0) ldata[ldata[,lv2+1:nv2]<=0,lv2+1:nv2] <- NA
  npgr <- ceiling(nv2/nrows)
  npgc <- ceiling(nv1/ncols)
# ******************** plots **********************
  for (ipgr in 1:npgr) {
    lr <- (ipgr-1)*nrows
  for (ipgc in 1:npgc) {
    lc <- (ipgc-1)*ncols
    if (save&&((lr+nrows)<=lc)) break
  for (jr in 1:nrows) { #-- plot row [j]
    jd2 <- lr+jr
    j2 <- lv2 + jd2
    if (jd2<=nv2)  v2 <- ldata[,j2]
    for (jc in 1:ncols) { #-- plot column  [j2-lv2] = 1:nv2
      jd1 <- lc+jc
      j1 <- lv1 + jd1
    if (jd2<=nv2 & jd1<=nv1) {
      v1 <- ldata[,j1]
      plot(v1,v2, type="n", xlab="", ylab="", axes=FALSE,
           xlim <- rg[,j1], ylim <- rg[,j2],
           xaxs=xaxs, yaxs=yaxs, log=log, cex=cex.points)
      usr <- par("usr")
      if (jr==nrows||jd2==nv2) {
        if (xaxmar==1) axis(1)
        mtext(vnames[j1], side=1, line=(0.5+1.2*(xaxmar==1))*cex.lab,
              cex=cex.lab, at=mean(usr[1:2]))
      }
      if (jc==1) {
        if (yaxmar==2) axis(2)
        mtext(vnames[j2], side=2, line=(0.5+1.2*(yaxmar==2))*cex.lab,
              cex=cex.lab, at=mean(usr[3:4]))
      }
      if (jr==1&&xaxmar==3) axis(3,xpd=TRUE)
      if (jc==ncols||jd1==nv1) if (yaxmar==4) axis(4,xpd=TRUE)
      box(bty=bty)
      if (any(v1!=v2,na.rm=TRUE)) { # not diagonal
        panel(v1,v2,jd1,jd2, pch, col, ...)
        if (tjref) abline(h=lref[j1],v=lref[j2],lty=ltyref)
      }
      else { uu <- par("usr") # diagonal: print variable name
             text(mean(uu[1:2]),mean(uu[3:4]), vnames[j1], cex=cex.text) }
    }
      else frame()
    }
  }
  if (jmain) mtext(main,3,oma[3]*0.9-2*cex.title,outer=TRUE,cex=cex.title)
##-   stamp(sure=FALSE,line=par("mgp")[1]+0.5)
#  stamp(sure=FALSE,line=oma[4]-1.8) ### ??? why does it need so much space?
  }}
  on.exit(par(oldpar))
  "PlotMatrix: done"
}

###


# Descriptive functions
# Descriptive summaries for univariate description: Desc. ...


# Decriptive Tools *********************************

## plots: ACF, GACF and other TimeSeries plots ----------

PlotACF <- function(series, lag.max = 10*log10(length(series)), ...)  {

  ## Purpose:  time series plot with correlograms
  #  Original name: f.acf

  ## ---
  ## Arguments: series : time series
  ##           lag.max : the maximum number of lags for the correlograms


  ## ---
  ## Author: Markus Huerzeler, Date: 15 Jun 94
  ## Revision: Christian Keller, 5 May 98
  ## Revision: Markus Huerzeler, 11. Maerz 04

  if (!is.null(dim(series)))
    stop("f.acf is only implemented for univariate time series")
  par(mfrow=c(1,1))
  old.par <- par(mar=c(3,3,1,1), mgp=c(1.5,0.5,0))
  on.exit(par(old.par))
  split.screen(figs=matrix(c(0,1,0.33,1, 0,0.5,0,0.33, 0.5,1,0,0.33),
                           ncol=4, byrow=T), erase=TRUE)
  ##screen(1)
  plot.ts(series, cex=0.7, ylab=deparse(substitute(series)), ...)
  screen(2)
  PlotGACF(series, lag.max=lag.max, cex=0.7)
  screen(3)
  PlotGACF(series, lag.max=lag.max, type="part", cex=0.7)
  close.screen(all.screens=TRUE)
  invisible(par(old.par))
}


PlotGACF <- function(series, lag.max=10*log10(length(series)), type="cor", ylab=NULL, ...)
{
  ## Author: Markus Huerzeler, Date:  6 Jun 94
  ## Revision: Christian Keller, 27 Nov 98
  ## Revision: Markus Huerzeler, 11 Mar 02
  ## Correction for axis labels with ts-objects and deletion of ACF(0), Andri/10.01.2014

  # original name g.plot.acf
  # erg <- acf(series, type=type, plot=FALSE, lag.max=lag.max, na.action=na.omit)

  # debug:  series <- AirPassengers
  type <- match.arg(type, c("cor","cov","part"))

  erg <- acf(na.omit(series), type=type, plot=FALSE, lag.max=lag.max)

  erg.acf <- erg$acf
  # set the first acf(0) = 1 to 0
  if(type=="cor") {
    erg.acf[1] <- 0
    if(is.null(ylab)) ylab <- "ACF"
  }
  if(type=="part") {
    # add a 0-value to the partial corr. fct.
    erg.acf <- c(0, erg.acf)
    if(is.null(ylab)) ylab <- "PACF"
  }

  erg.konf <- 2/sqrt(erg$n.used)
  yli <- range(c(erg.acf, erg.konf, -erg.konf))*c(1.1, 1.1)
  # old: erg.lag <- as.vector(erg$lag)
  # new: get rid of the phases and use lags even with timeseries
  erg.lag <- seq_along(erg.acf)-1

  ## Labels fuer x-Achse definieren:
  ## 1. Label ist immer erg.lag[1]
  pos <- pretty(c(0, erg.lag))
  n <- length(pos)
  d <- pos[2] - pos[1] ; f <- pos[1]-erg.lag[1]
  pos <- c(erg.lag[1], pos[1][f > d/2], pos[2:n])

  plot(erg.lag, erg.acf, type="h", ylim=yli, xlab="Lag k", ylab=ylab,
       xaxt="n", xlim=c(0,length(erg.acf)), ...)
  axis(1, at=pos, ...)
  abline(0,0)
  abline(h=c(erg.konf, - erg.konf), lty=2, col="blue")
  invisible()
}


PlotMonth <- function(x, type = "l", labels, xlab = "", ylab = deparse(substitute(x)), ...)
#--
# Funktion fuer univariate Zeitreihen, zeichnet die Monats- oder Saisoneffekte
#
# von S+5 uebernommen und an R angepasst
#
# x muss eine univariate Zeitreihe sein
#--

{
  if(length(dim(x)))
    stop("This implementation is only for univariate time series")
  old.opts <- options(warn = -1)

  on.exit(options(old.opts))

  if(!(type == "l" || type == "h"))
    stop(paste("type is \"", type, "\", it must be \"l\" or \"h\"",
               sep = ""))

  f <- frequency(x)
  cx <- cycle(x)
  m <- tapply(x, cx, mean)
  if(cx[1] != 1 || cx[length(x)] != f) {
    x <- ts(c(rep(NA, cx[1] - 1), x, rep(NA, f - cx[length(x)])),
            start = start(x, format = T)[1], end = c(end(x, format
                                                         = T)[1], f), frequency = f)
    cx <- cycle(x)
  }
  i <- order(cx)
  n <- length(x)
  if(missing(labels))
    labels <- if(f == 12) c("Jan", "Feb", "Mar", "Apr", "May",
                            "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
    ) else if(f == 4)
      c("First", "Second", "Third", "Fourth")
  else 1:f
  if(length(labels) != f)
    stop(paste("There must be", f, "labels"))
  p <- n/f
  hx <- seq(1, n, by = p) + (0:(f - 1))
  hy <- rep(m, rep(2, length(m)))
  X <- as.vector(outer(0:(p - 1), hx, "+"))
  plot(c(1, n + f), range(x[!is.na(x)]), type = "n", axes = F, xlab =
         xlab, ylab = ylab, ...)
  dotdot <- list(...)
  ddttl <- match(c("main", "sub", "axes", "ylim"), names(dotdot), nomatch
                 = 0)
  ddttl <- ddttl[ddttl != 0]
  add.axes <- T
  if(length(ddttl)) {
    if(any(names(dotdot) == "axes"))
      add.axes <- dotdot$axes
    dotdot <- dotdot[ - ddttl]
  }
  if(type == "l")
    for(j in 1:f)
      do.call("lines", c(list(hx[j]:(hx[j] + p - 1), x[i][
        ((j - 1) * p + 1):(j * p)]), dotdot))
  else if(type == "h")
    do.call("segments", c(list(X, x[i], X, m[cx][i]), dotdot))
  do.call("segments", c(list(hx, m, hx + p, m), dotdot))
  if(add.axes) {
    box()
    axis(2)
    axis(1, at = hx + p/2, labels = labels)
  }
  invisible()
}

# eval-version:
#
# PlotQQ <- function(x, qdist, ..., main=NULL, xlab=NULL, ylab=NULL, args.qqline=NULL){
#
#   # qqplot for an optional distribution
#
#   # example:
#   # y <- rexp(100, 1/10)
#   # PlotQQ(y, "qexp", rate=1/10)
#   # PlotQQ(y, qexp, rate=1/10)  # the function name can also be passed as function
#
#   if(is.function(qdist)) {
#     # if qdist is a function, then save it under new name and
#     # overwrite function name in fct, which has to be character
#     fct <- qdist
#     qdist <- "fct"
#   }
#
#   y <- sort(x)
#   x <- ppoints(y)
#   x <- eval(parse(text=gettextf("%s(x, ...)", qdist)))
#
#   if(is.null(main)) main <- gettextf("Q-Q-Plot", qdist)
#   if(is.null(xlab)) xlab <- gettextf("Theoretical Quantiles (%s)", parse(text = gettextf("%s(x, ...)", fct)))
#   if(is.null(ylab)) ylab <- "Sample Quantiles"
#
#   plot(x=x, y, main=main, xlab=xlab, ylab=ylab)
#
#   # add qqline if desired
#   add.qqline <- TRUE
#   if(!is.null(args.qqline)) if(all(is.na(args.qqline))) {add.qqline <- FALSE}
#
#   if(add.qqline) {
#
#     # define default arguments for ci.band
#     args.qqline1 <- list(probs = c(0.25, 0.75), qtype=7, col=par("fg"), lwd=par("lwd"), lty=par("lty"))
#     # override default arguments with user defined ones
#     if (!is.null(args.qqline)) args.qqline1[names(args.qqline)] <- args.qqline
#
#     # estimate qqline, instead of set it to abline(a = 0, b = 1)
#     # plot qqline through the 25% and 75% quantiles (same as qqline does for normal dist)
#     ly <- quantile(y, prob=args.qqline1[["probs"]], type=args.qqline1[["qtype"]], na.rm = TRUE)
#     lx <- eval(parse(text = gettextf("%s(c(%s,%s), ...)", qdist,
#                                      args.qqline1[["probs"]][1], args.qqline1[["probs"]][2])))
#
#     slope <- diff(ly) / diff(lx)
#     int <- ly[1L] - slope * lx[1L]
#     do.call("abline", c(args.qqline1[c("col","lwd","lty")], list(a=int, b=slope)) )
#
#   }
#
# }


PlotQQ <- function(x, qdist, main=NULL, xlab=NULL, ylab=NULL, args.qqline=NULL,  ...){

  # qqplot for an optional distribution

  # example:
  # y <- rexp(100, 1/10)
  # PlotQQ(y, function(p) qexp(p, rate=1/10))

  y <- sort(x)
  p <- ppoints(y)
  x <- qdist(p)

  if(is.null(main)) main <- gettextf("Q-Q-Plot", qdist)
  if(is.null(xlab)) xlab <- "Theoretical Quantiles"
  if(is.null(ylab)) ylab <- "Sample Quantiles"

  plot(x=x, y, main=main, xlab=xlab, ylab=ylab, ...)


# John Fox implements a envelope option in car::qqplot, in the sense of:
#   (unfortunately using ddist...)
#
#   # add qqline if desired
#   if(!identical(args.band, NA)) {
#     n <- length(x)
#     zz <- qnorm(1 - (1 - args.band$conf.level) / 2)
#     SE <- (slope / d.function(z, ...)) * sqrt(p * (1 - p) / n)
#     fit.value <- int + slope * z
#
#     upper <- fit.value + zz * SE
#     lower <- fit.value - zz * SE
#
#     lines(z, upper, lty = 2, lwd = lwd, col = col.lines)
#     lines(z, lower, lty = 2, lwd = lwd, col = col.lines)
#   }

  # add qqline if desired
  if(!identical(args.qqline, NA)) {

    # define default arguments for ci.band
    args.qqline1 <- list(probs = c(0.25, 0.75), qtype=7, col=par("fg"), lwd=par("lwd"), lty=par("lty"))
    # override default arguments with user defined ones
    if (!is.null(args.qqline)) args.qqline1[names(args.qqline)] <- args.qqline

    # estimate qqline, instead of set it to abline(a = 0, b = 1)
    # plot qqline through the 25% and 75% quantiles (same as qqline does for normal dist)
    ly <- quantile(y, prob=args.qqline1[["probs"]], type=args.qqline1[["qtype"]], na.rm = TRUE)
    lx <- qdist(args.qqline1[["probs"]])

    slope <- diff(ly) / diff(lx)
    int <- ly[1L] - slope * lx[1L]
    do.call("abline", c(args.qqline1[c("col","lwd","lty")], list(a=int, b=slope)) )

  }

}



## Describe  ====


# Format-Funktion, brauchen wir ueberall
.fmt <- function(x, digits=3, sdigits=7, big.mark="'") {
  x <- as.numeric(x)
  if(is.finite(x)){
    fdigits <- ifelse( IsWhole(x), 0
      , ifelse(x > 1e3, digits - (round(log(abs(x),10),0)-3), digits )
    )
    switch( findInterval( abs(x), c(0,.Machine$double.eps^0.5, 1e-4, 1e6) )
                    , "1" = { formatC(x, digits=fdigits, format="f", big.mark=big.mark ) }
                    , "2" = { formatC(x, digits=digits, format="e", big.mark=big.mark ) }
                    , "3" = { formatC(x, digits=fdigits, format="f", big.mark=big.mark ) }
                    , "4" = { formatC(x, digits=digits, format="e", big.mark=big.mark ) }
    )
  } else {
    formatC(x)
  }
}


.txtline <- function(txt, width, space="", ind="") {
  paste(
    ind, paste(format(names(txt), width=width, justify="right"), collapse=space), "\n",
    ind, paste(format(txt, width=width, justify="right"), collapse=space), "\n",
    sep="" )
}



Desc.matrix <- function(x, main=NULL, rfrq = NULL, margins = c(1,2), p =  rep(1/length(x), length(x)), plotit=getOption("plotit", FALSE),
                        verbose = c("medium","low","high"), ... ){
  Desc.table(x, main=main, rfrq = rfrq, margins = margins, p = p, plotit = plotit, verbose = verbose, ... )
  invisible()
}


Desc.table <- function(x, main=NULL, rfrq = NULL, margins = c(1,2), p = rep(1/length(x), length(x)),
                       plotit=getOption("plotit", FALSE), verbose = c("medium","low","high"), ... ){

  .warn <- function(x){
    if(any(x$expected < 5) && is.finite(x$parameter)){
      cat("\nWarning message:\n  Exp. counts < 5: Chi-squared approx. may be incorrect!!\n")
    }
  }

  opt  <- options(scipen=4); on.exit(options(opt))

  # define verbosity
  verbose <- match.arg(verbose, c("medium","low","high"))
  verbose <- match(verbose, c("low","medium","high"), nomatch=2)

  if(is.null(rfrq)) rfrq <- ifelse(verbose > 1, "111","000")

  if(is.null(main)) main <- gettextf("%s (%s)", deparse(substitute(x)), paste(class(x), collapse=", "))

  if(!identical(main, NA)) {
    cat( paste(rep("-",(as.numeric(options("width"))-2)), collapse=""), "\n" )
    cat(main)
  }
  if( !is.null(attr(x,"label")) ) cat(" :", strwrap(attr(x,"label"), indent=2, exdent=2), sep="\n" )
  cat("\n")

  # Pairs summary
  n <- sum(x)

  if(length(dim(x)) > 2) { # multdim table

    cat("\nSummary: \n",
        "n: ", n, ", ", length(dim(x)), "-dim table: ", paste(dim(x), collapse=" x ")
        , "\n\n", sep="" )

    print(ftable(addmargins(x, c(1, length(dim(x))))))
    cat("\n")

  } else {  # <= 2-dimensional table

    if(length(dim(x))==1) {       # 1-dim table ****
      cat("\nSummary: \n",
          "n: ", n,
          ", rows: ", dim(x)[1]
          , "\n\n", sep="" )

      suppressWarnings(r.chisq <- chisq.test(x, p=p))
      cat("Pearson's Chi-squared test (1-dim uniform):\n  "
          , .CaptOut(r.chisq)[5], "\n\n", sep="")
      .warn(r.chisq)

      # use Freq instead of PercTable for 1-d tables
      f <- Freq(x)
      f[,2] <- Format(f[,2], fmt=.fmt_abs())
      f[,3] <- Format(f[,3], fmt=.fmt_per())
      f[,4] <- Format(f[,4], fmt=.fmt_abs())
      f[,5] <- Format(f[,5], fmt=.fmt_per())

      if(InDots(..., arg="expected", default=FALSE))
        f <- cbind(f, exp=Format(unname(r.chisq$expected), big.mark="'", digits=1))
      if(InDots(..., arg="residuals", default=FALSE))
        f <- cbind(f, res=Format(unname(as.matrix(r.chisq$residuals)), digits=1, big.mark="'"))
      if(InDots(..., arg="stdres", default=FALSE))
        f <- cbind(f, stdres=Format(unname(as.matrix(r.chisq$stdres)), digits=1))

      print.data.frame(f, print.gap=2)

    } else {                      # 2-dim tabl *****

        if(!is.null(attr(x, "missings")))
          missn <- paste(",", attr(x, "missings"), paste="")
        else
          missn <- ""

        cat("\nSummary: \n",
        "n: ", Format(n, fmt=.fmt_abs()),
        ", rows: ", Format(dim(x)[1], fmt=.fmt_abs()),
        ", columns: ", Format(dim(x)[2], fmt=.fmt_abs()),
        missn
    	  , "\n\n", sep="" )

      if(dim(x)[1] == 2 & dim(x)[2] == 2 ){

        if(verbose=="3"){
          suppressWarnings(r.chisq <- chisq.test(x, p=p, correct = FALSE))
          cat("Pearson's Chi-squared test:\n  ", .CaptOut(r.chisq)[5], "\n", sep="")
        }
        suppressWarnings(r.chisq <- chisq.test(x, p=p))
        cat("Pearson's Chi-squared test (cont. adj):\n  ", .CaptOut(r.chisq)[5], "\n", sep="")
        cat("Fisher's exact test ", .CaptOut( fisher.test(x))[5], "\n", sep="")

        if(verbose > 1){ # print only with verbosity > 1
          cat("", .CaptOut( mcnemar.test(x))[5], "\n", sep="")
        }

        .warn(r.chisq)

        if(verbose > 1){ # print only with verbosity > 1
          cat("\n")
          m <- ftable(format(rbind(
             "odds ratio    " = OddsRatio(x, conf.level=0.95)
            , "rel. risk (col1)  " = RelRisk(x, conf.level=0.95, method="wald", delta=0)
            , "rel. risk (col2)  " = RelRisk(x[,c(2,1)], conf.level=0.95, method="wald", delta=0)
          ), digits=3, nsmall=3))

          attr(m, "col.vars")[[1]][1] <- "estimate"
          print(m)
        }

      } else {

        if(verbose=="3"){
          suppressWarnings(r.chisq <- chisq.test(x, p=p, correct = FALSE))
          cat("Pearson's Chi-squared test:\n  ", .CaptOut(r.chisq)[5], "\n", sep="")
        }

        suppressWarnings(r.chisq <- chisq.test(x, p=p))
        cat("Pearson's Chi-squared test (cont. adj):\n  ", .CaptOut(r.chisq)[5], "\n", sep="")
        if(verbose > 1){ # print only with verbosity > 1

          # Log-likelihood chi-squared (G2) test of independence (homogeneity)
          lhrat <- 2 * sum(r.chisq$observed * log(r.chisq$observed/r.chisq$expected), na.rm=TRUE)
          alpha <- pchisq(lhrat, df=r.chisq$parameter, lower.tail = FALSE)
          cat(gettextf("Likelihood Ratio:\n  X-squared = %s, df = %s, p-value = %s\n",
                       round(lhrat, 4), r.chisq$parameter, format.pval(alpha, digits=4)))
          # Mantel-Haenszel ChiSquared (linear hypothesis)
          mh <- MHChisqTest(x)
          alpha <- mh$p.value
          cat(gettextf("Mantel-Haenszel Chi-squared:\n  X-squared = %s, df = %s, p-value = %s\n",
                       round(mh$statistic, 4), 1, format.pval(alpha, digits=4)))

        }

        .warn(r.chisq)

      }

      switch(verbose
        , "1" = { cat("\n")
                }
        , "2" = {
            cat(sprintf(
            "\nPhi-Coefficient        %.3f\nContingency Coeff.     %.3f\nCramer's V             %.3f\n"
            , Phi(x)
            , ContCoef(x)
            , CramerV(x)
            ) )
            cat("\n")
          }
        , "3" = {
            cat("\n")
            print(Assocs(x))
            cat("\n")
          }
      )
      print(PercTable(x, rfrq=rfrq, margins=margins, ...))
    }

    cat("\n")

  }

  if(plotit) {
    horiz <- InDots(..., arg="horiz", default=TRUE)
    PlotDesc.table(x, main=main, horiz = horiz)
  }
  invisible()

}



TOne <- function(x, grp = NA){


  afmt <- .fmt_abs()
  pfmt <- .fmt_per()
  nfmt <- .fmt_num()

  # creates the table one in a study

  num_fun <- function(x){
    # wie soll die einzelne Zelle fuer numerische Daten aussehen
#    fmt <- structure(list(digits=2, bigmark="'"), class="fmt")
    gettextf("%s (%s)",
             Format(mean(x, na.rm=TRUE), fmt=nfmt),
             Format(sd(x, na.rm=TRUE), fmt=nfmt))
  }

  num_row <- function(x, g, total=TRUE, test="kruskal.test", vname = deparse(substitute(x))){
    # wie soll die zeile aussehen fuer numerische Daten
    p <- eval(parse(text=gettextf("%s(x ~ g)", test)))
    cbind(var=vname, total = num_fun(x), rbind(tapply(x, g, num_fun)), Format(p$p.value, fmt="*"))
  }


  cat_mat <- function(x, g, vname=deparse(substitute(x))){
#     fmt.a <- structure(list(digits=0, bigmark="'"), class="fmt")
#     fmt.p <- structure(list(digits=1, fmt="%"), class="fmt")

    tab <- table(x, g)
    ptab <- prop.table(tab, 1)
    tab <- addmargins(tab, 2)
    ptab <- cbind(ptab, Sum=prop.table(table(x)))


    # crunch tab and ptab
    m <- matrix(NA, nrow=nrow(tab), ncol=ncol(tab))
    m[,] <- gettextf("%s (%s)",
                     Format(tab, fmt=afmt),
                     Format(ptab, fmt=pfmt))
    # totals to the left
    m <- m[, c(ncol(m), 1:(ncol(m)-1))]

    # set rownames
    m <- cbind( c(vname, paste(" ", levels(x))),
                rbind("", m))
    # add test
    p <- chisq.test(tab)$p.value
    m <- cbind(m, c(Format(p, fmt="*"), rep("", nlevels(x))))
    m
  }

  dich_mat <- function(x, g, vname=deparse(substitute(x))){
#     fmt.a <- structure(list(digits=0, bigmark="'"), class="fmt")
#     fmt.p <- structure(list(digits=1, fmt="%"), class="fmt")

    tab <- Rev(table(x, g), margin=1)
    ptab <- prop.table(tab, 1)
    tab <- addmargins(tab, 2)
    ptab <- cbind(ptab, Sum = prop.table(tab[,"Sum"]))

    m <- matrix(NA, nrow=nrow(tab), ncol=ncol(tab))
    m[,] <- gettextf("%s (%s)",
                     Format(tab, fmt=afmt),
                     Format(ptab, fmt=pfmt))

    # totals to the left
    m <- m[, c(ncol(m), 1:(ncol(m)-1))]

    if(identical(dim(tab), c(2,2))){
      p <- fisher.test(tab)$p.value
    } else {
      p <- chisq.test(tab)$p.value
    }
    m <- rbind(c(vname, m[1,], Format(p, fmt="*")))
    m
  }


  # find description types
  ctype <- sapply(x, class)
  ctype[sapply(x, IsDichotomous)] <- "dich"
  ctype[sapply(ctype, function(x) x %in% c("numeric","integer"))] <- "num"
  ctype[sapply(ctype, function(x) x %in% c("factor","ordered","character"))] <- "cat"


  lst <- list()
  for(i in 1:ncol(x)){
    if(ctype[i] == "num"){
      lst[[i]] <- num_row(x[,i], grp, vname=colnames(x)[i])

    } else if(ctype[i] == "cat") {
      lst[[i]] <- cat_mat(x[,i], grp, vname=colnames(x)[i])

    } else if(ctype[i] == "dich") {
      lst[[i]] <- dich_mat(x[,i], grp, vname=colnames(x)[i])

    } else {
      lst[[i]] <- rbind(c(colnames(x)[i], rep(NA, nlevels(grp) + 2)))
    }

  }
  return(do.call(rbind, lst))
}



Desc.Lc <- function (x, main = NULL, p = c(0.8,0.9,0.95,0.99), plotit=getOption("plotit", FALSE), ...) {

  # describe a Lorenz curve

  if (is.null(main))
    main <- gettextf("%s (%s)", deparse(substitute(x)),
                      paste(class(x), collapse = ", "))
  n <- length(x$p)

  cat(paste(rep("-", (as.numeric(options("width")) - 2)), collapse = ""),
      "\n")
  if (!identical(main, NA))
    cat(main)
  if (!is.null(attr(x, "label")))
    cat(" :", strwrap(attr(x, "label"), indent = 2, exdent = 2),
        sep = "\n")
  cat("\n\n")

  d.frm <- data.frame( (1-p), sapply(p, function(p){1 - approx(x=x$p, y=x$L, xout=p)$y}))
  colnames(d.frm) <- c("1-p","1-L(p)")

  txt <- d.frm
  txt[,2] <- round(txt[,2], 3)
  txt <- .CaptOut(txt)
  txt <- gsub(pattern = "0\\.", replacement = " \\.", txt)

  lres <- list(l1 = list(n = n, `0s` = max(x$p[x$L==0]), Gini=x$Gini))

  lfmt <- lapply(lres, lapply, .fmt)
  width <- max(c(unlist(lapply(lfmt, nchar)), unlist(lapply(lapply(lfmt, names), nchar))))
  cat(paste(lapply(lfmt, .txtline, width = width, ind = "  ",
                   space = " "), collapse = "\n"), "\n")

  cat(txt, sep = "\n")

  if (plotit)
    if (lres$l1$n > 0)
      plot(x, main = main)

  invisible(lres)
}



Flags <- function(x){
  res <- x[, sapply(x, IsDichotomous)]
  class(res) <- "flags"
  return(res)
}



Desc.flags <- function(x, i=1, plotit=getOption("plotit", FALSE), ...){

  cat( paste(rep("-",(as.numeric(options("width"))-2)), collapse=""), "\n" )
  main <- InDots(..., arg="main", default = "Multiple dichotomous variables")
  cat(main)
  if( !is.null(attr(x,"label")) ) cat(" :", strwrap(attr(x,"label"), indent=2, exdent=2), sep="\n" )
  cat("\n")

  cat( "\nSummary: \n", "total n: ", nrow(x), "\n\n", sep="" )

  d.sub <- x

  flags <- do.call(rbind, lapply(d.sub, function(z) {
    tab <- table(z)
    data.frame(val = names(tab[i]), abs=tab[i], BinomCI(tab[i], sum(tab)))
  }
  ))
  out <- data.frame( do.call(rbind,  lapply(d.sub, function(x) cbind(NAs=sum(is.na(x)), n=length(x)- sum(is.na(x)))))
                     , flags)
  out[,5:7] <- apply(out[,5:7],2, Format, digits=3)

  print(out, quote=FALSE)
  cat("\n")

  if(plotit) PlotDesc(x)

}



###

## PlotDesc functions for univariate description  ====

PlotDesc <- function(x, ..., wrd=NULL){
  if(length(na.omit(x))==0) {

    plot(1, type="n", axes=FALSE, xlab="", ylab="", xlim=c(0,1),ylim=c(0,1), frame.plot=TRUE)
    text(x=0.5, y=0.5, labels="Nothing to plot...")

    if(!is.null(wrd)) WrdPlot(width=7.5, height=4.7, dfact=2.4, crop=c(0,0,0.7,0), wrd=wrd, append.cr=TRUE)

  } else {
    if( is.vector(x) && length(unique(na.omit(x))) == 2) {
      PlotDesc.logical(x=x, ..., wrd=wrd)
    } else {
      UseMethod("PlotDesc")
    }
  }

}


# PlotDesc.formula <- function(x, data, ..., wrd=NULL) {
#   mf <- model.frame(x, data)
#   PlotDesc(mf[,1], mf[,2], ..., wrd=wrd)
# }


PlotDesc.default<- function(x, ...) {
  warning( gettextf("Unhandled class %s of %s.\n", class(x), deparse(substitute(x)) ) )
}


PlotDesc.ordered <- function(x, ..., wrd=NULL) {
  mf <- match.call(expand.dots = FALSE)
  mf$...["ord"] <- InDots(..., arg="ord", default = "level")
  # error if main is not treated here... why??
  mf$...["main"] <- InDots(..., arg="main", default = deparse(substitute(x)))
  args <- append(list(x=x, wrd=wrd), mf$...)
  do.call(PlotDesc.factor, args)

}



PlotDesc.data.frame <- function(x, ..., wrd=NULL){
  for( cx in colnames(x) ){
    PlotDesc( x[,cx], main=cx, ..., wrd=wrd)
  }
  invisible()

}


PlotDesc.numeric <- function(x, main = deparse(substitute(x)), ..., wrd=NULL) {
  # just pass everything to PlotFdist, but omit NAs as density in PlotFDist would not handle it..
  PlotFdist(x=na.omit(x), main=main, ...)
  if(!is.null(wrd)) WrdPlot(width=8, height=5.5, dfact=2.3, crop=c(0,0,1,0), wrd=wrd, append.cr=FALSE)
  invisible()

}


PlotDesc.integer <- function(x, main = deparse(substitute(x))
  , ord=c("val_asc","val_desc","frq_asc","frq_desc")
  , maxrows=12, ... , wrd=NULL) {

  switch(as.character(cut(length(unique(na.omit(x))), breaks=c(0,2,15,Inf), labels=1:3))
    , "1" = { PlotDesc.logical(x, main=main, ..., wrd=wrd) }
    , "2" = { PlotDesc.factor(x, main=main, maxrows=maxrows, ..., type="dot", ord="none", wrd=wrd)  }
    , "3" = { PlotDesc.numeric(x, main=main, ..., wrd=wrd) }
  )
  invisible()

}





PlotDesc.factor <- function (x, main = deparse(substitute(x)),
                             ord = c("desc", "level", "name", "asc", "none"), maxrows = 12, lablen = 25,
                             type=c("bar","dot"), col=NULL, border=NULL, xlim=NULL, ecdf=FALSE, ..., wrd=NULL)  {


  if (nlevels(factor(x)) <= 2) {
    PlotDesc.logical(x, main = main, ..., wrd=wrd)
  }
  else {

    oldpar <- par(no.readonly=TRUE);  on.exit( par(oldpar) )

    # was cex in the dots-args? parse dots.arguments
    cex <- unlist(match.call(expand.dots=FALSE)$...["cex"])
    if(is.null(cex)) cex <- par("cex")

    tab <- table(x)
    switch(match.arg(arg = ord, choices = c("desc", "level", "name", "asc", "none")),
           name = { tab <- tab[order(rownames(tab))]},
           asc =  { tab <- sort(tab) },
           desc = { tab <- -sort(-tab) })

    ptab <- prop.table(tab)
    trunc_fg <- (nrow(tab) > maxrows)
    if (!is.na(maxrows)) {
      tab <- tab[1:min(nrow(tab), maxrows)]
      ptab <- ptab[1:min(nrow(tab), maxrows)]
    }

    if(max(nchar(rownames(tab))) > lablen ) rownames(tab) <- StrTrunc(rownames(tab), lablen)
    wtxt <- max(strwidth(rownames(tab), "inch"))
    wplot <- (par("pin")[1] - wtxt) / 2
    layout(matrix(c(1,2), nrow=1), widths=c(wtxt + wplot, wplot) * 2.54 )
    par(mai=c(1.5, max(strwidth(rev(rownames(tab)), "inch"))+.5, 0.2, .3)+.02)
    if(!is.na(main)) par(oma=c(0,0,3,0))


    switch(match.arg(arg = type, choices = c("bar", "dot")),
           dot = {

             if(is.null(xlim)) xlim <- range(pretty(tab)) + c(-1,1) * diff(range(pretty(tab))) * 0.04

             if(is.null(col)) col <- getOption("col1", hblue)
             if(is.null(border)) border <- "black"
             b <- barplot( rev(tab), horiz=TRUE, border=NA, col="white", las=1,
                           xlim=xlim,
                           xpd=FALSE, xlab="frequency", cex.names=cex, cex.axis=cex, cex.lab=cex, tck=-0.04)
             abline(h=b, v=0, col="grey", lty="dotted")
             points( x=as.vector(rev(tab)), y=b, yaxt = "n", col=border, pch=21, bg=col, cex=1.3)
             box()

             par(mai=c(1.5, 0.1, 0.2, .3)+.02)
             b <- barplot( rev(ptab), horiz=TRUE, border=NA, col="white", las=1, names="", xlim=c(-0.04,1.04), xlab="percent", cex.names=cex, cex.axis=cex, cex.lab=cex, tck=-0.04)
             abline(h=b, v=0, col="grey", lty="dotted")
             points( x=as.vector(rev(ptab)), y=b, col=border, pch=21, bg=col, cex=1.3)
             box()

           }, bar = { # type = "bar"

             if(is.null(xlim)) xlim <- range(pretty(c(0.96*min(tab), 1.04*max(tab))))

             if(is.null(col)) {
               col <- c(rep("grey80", length.out=2*nrow(tab)), rep(SetAlpha("grey80",0.4), length.out=nrow(tab)))
             } else {
               if(length(col)==1){
                 col <- c(rep(col, length.out=2*nrow(tab)), rep(SetAlpha(col,0.3), length.out=nrow(tab)))
               } else {
                 col <- rep(col, length.out=3*nrow(tab))
               }
             }
             if(is.null(border)) border <- NA
             barplot( rev(tab), horiz=TRUE, col=col[1:nrow(tab)], border=border, las=1, xlim=xlim, xpd=FALSE, xlab="frequency", cex.names=cex, cex.axis=cex, cex.lab=cex, tck=-0.04)
             grid(ny=NA)

             par(mai=c(1.5, 0.15, 0.2, .3) + .02)
             if(ecdf) {
               barplot( rev(cumsum(ptab)), horiz=TRUE, col=col[(2*nrow(tab)+1):(3*nrow(tab))], border=border, las=1, names="", xlim=c(0,1), xlab="percent", cex.names=cex, cex.axis=cex, cex.lab=cex, tck=-0.04)
               barplot( rev(ptab), horiz=TRUE, col=col[(nrow(tab)+1):(2*nrow(tab))], border=border, names="", xlab=NA, ylab=NA, add=TRUE, axes=FALSE)
             } else {
               barplot( rev(ptab), horiz=TRUE, col=col[(nrow(tab)+1):(2*nrow(tab))], border=border, las=1, names="", xlim=c(0,1), xlab="percent", cex.names=cex, cex.axis=cex, cex.lab=cex, tck=-0.04)
             }
             grid(ny=NA)

           })

    if(!is.na(main)) title(main=main, outer=TRUE)

    if (trunc_fg)
      text(x = par()$usr[2], y = 0.4, labels = " ...[list output truncated]  ",
           cex = 0.6, adj = c(1, 0.5))

    if(!is.null(wrd)) WrdPlot(width=8, height=pmin(2+3/6*nrow(ptab), 10), dfact=2.7, crop=c(0,0,1,0), wrd=wrd, append.cr=FALSE)

  }
  invisible()

}




PlotDesc.logical <- function(x, main = deparse(substitute(x)), xlab="",
                             col1=getOption("col1", hblue), col2=getOption("col2", hred), ..., wrd=NULL) {

  tab <- table(factor(x))
  if(nrow(tab)>2) stop( "!PlotDesc.logical! can only display 2 levels" )
  ptab <- prop.table(tab)

  oldpar <- par(no.readonly=TRUE);  on.exit( par(oldpar) )
  # usr <- par("usr"); on.exit(par(usr))

  par(mar=c(4.1,2.1,0,2.1))
  if(!is.na(main)) par(oma=c(0,0,3,0))

  plot( x=ptab[1], y=1, cex=0.8, xlim=c(0,1), yaxt="n", ylab="", type="n", bty="n", xlab=xlab, main=NA)
  segments( x0=0, x1=1, y0=1, y1=1, col="grey")
  segments( x0=c(0,1), x1=c(0,1), y0=0.8, y1=1.2, col="grey")
  # insert grid
  segments( x0=seq(0,1,0.1), x1=seq(0,1,0.1), y0=0.8, y1=1.2, col="grey", lty="dotted")
  rect(xleft=0, ybottom=0.95, xright=ptab[1], ytop=1.05, col=col1 )     # greenyellow
  rect(xleft=ptab[1], ybottom=0.95, xright=1, ytop=1.05, col=col2 )     # green4
  ci.99 <- BinomCI(tab[1], sum(tab), conf.level=0.99)[2:3]
  ci.95 <- BinomCI(tab[1], sum(tab), conf.level=0.95)[2:3]
  ci.90 <- BinomCI(tab[1], sum(tab), conf.level=0.90)[2:3]
  rect(xleft=ci.99[1], ybottom=0.9, xright=ci.99[2], ytop=1.1, col="grey80" ) # olivedrab1
  rect(xleft=ci.95[1], ybottom=0.9, xright=ci.95[2], ytop=1.1, col="grey60" ) # olivedrab3
  rect(xleft=ci.90[1], ybottom=0.9, xright=ci.90[2], ytop=1.1, col="grey40" ) # olivedrab4
  segments( x0=ptab[1], x1=ptab[1], y0=0.7, y1=1.3)

  legend( x=0, y=0.75, legend=c("ci.99     ","ci.95     ","ci.90     "), box.col="white"
    , fill=c("grey80","grey60","grey40"), bg="white", cex=1, ncol=3, text.width=c(0.2,0.2,0.2) )
  text( names(ptab), x=c(ptab[1], ptab[1] + 1)/2, y=1.2 )
  if(!is.na(main)) title(main=main, outer=TRUE)

  if(!is.null(wrd)) WrdPlot(width=6, height=4, dfact=2.6, crop=c(0.2,0.2,2,0), wrd=wrd, append.cr=FALSE)
  invisible()

}





PlotDesc.Date <- function(x, main = deparse(substitute(x)), breaks = NULL, ..., wrd = NULL) {

  # example:
  # PlotDesc.Date( x, newwin=TRUE )

  # plots exp-obs dotcharts of weekdays and months
  oldpar <- par(no.readonly=TRUE);  on.exit( par(oldpar) )

  # par(mar=c(10.1,3.1,4.1,1.1), oma=c(0,9,0,0), mfrow=c(1,1))
  par(oma=c(0,9,0,0))

  tab <- c(table( factor( format( x, "%A"), levels=format(ISOdate(2000, 1, 3:9), "%A"), ordered=TRUE) ))
  r.chi <- chisq.test(rev(tab))

  dotchart( as.numeric(r.chi$exp[]), xlim=range(pretty(range(c(r.chi$exp[],r.chi$obs[]))))
    , color="black", bg="white", pch=21, cex=0.8, xpd=TRUE  )
  mtext(side=2, at=1:7, line=2, names(r.chi$exp), las=1)
  points( x=r.chi$obs[], y=1:7, col="black", bg="black", pch=21, cex=1.2 )
  points( x=r.chi$exp[], y=1:7, col="black", bg="white", pch=21, cex=1.2 )

  if(!is.na(main) & is.null(wrd)) title(main=gettextf("%s (a: weekday)", main))

  if(!is.null(wrd)) WrdPlot(width=6.5, height=5, dfact=2.5, wrd=wrd, append.cr=TRUE)

  # Haeufigkeiten normiert mit Anzahl Tagen im Monat
  # par(mar=c(10.1,3.1,1.1,1.1))

  ydays <- factor( format(seq(from=as.Date("2010-01-01")
    ,to=as.Date("2010-12-31"), by="day"), "%B"), levels=format(ISOdate(2000, 1:12, 1), "%B") )
  r.chi <- chisq.test( rev(c(table(factor(format(x, "%B"),levels=levels(ydays)))))
    , p=prop.table( rev( c(table(ydays)))) )
  month_xlim <- range(pretty(range(c(r.chi$exp[],r.chi$obs[]))))
  dotchart( as.numeric(r.chi$exp[]), xlim=month_xlim
    , color="black", bg="white", pch=21, cex=0.8, xpd=TRUE  )
  mtext(side=2, at=1:12, line=2, names(r.chi$exp), las=1)
  points( x=r.chi$obs[], y=1:12, col="black", bg="black", pch=21, cex=1.2 )
  points( x=r.chi$exp[], y=1:12, col="black", bg="white", pch=21, cex=1.2 )

  legend(x="bottom", inset=-0.5, legend=c("expected","observed"), xpd=TRUE, ncol=2
    , pch=c(21), col=c("black","black"), bg="white", pt.bg=c("white","black"), cex=1
    , pt.cex=1, xjust=0.5, adj=c(0,0.5),  text.width=c(4,4) )

  if(!is.na(main) & is.null(wrd)) title(main=gettextf("%s (b: month)", main))

  if(!is.null(wrd)) WrdPlot(width=6.5, height=6.2, dfact=2.5, wrd=wrd, append.cr=TRUE)

  # breaks can be:  c("month","days","weeks","quarter","year")

  # old:
  #   tab <- table(cut(x, breaks))
  #
  #   # par( mar=c(8.1,3.1,3.1,1.1) )
  #   plot( y=as.vector(tab), x=as.Date(names(tab)), type="h", cex=0.8, xlab="abs. frq.", xaxt="n"
  #     , ylab="", ... )
  #   axis.Date(1, cex.axis=0.8, at=seq(as.Date(names(tab)[1]), as.Date(rev(names(tab))[1]), breaks)
  #     , labels=strftime(seq(as.Date(names(tab)[1]), as.Date(rev(names(tab))[1]), breaks), "%y-%m") )

  if(is.null(breaks)) {
    # get some appropiate default for the breaks
    dd <- as.integer(diff(range(x, na.rm=TRUE)))
    dw <- dd / (360/52) # weeks
    dm <- dd / (360/12) # months
    dq <- dd / (360/4) # quarters
    dy <- dd / 360 # years

    breaks <- ifelse(dy<12, ifelse(dq<12, ifelse(dm<12, ifelse(dw<12,"days","weeks"),"months"), "quarters"), "years")
  }
  Mar(,0)
  hist(x, breaks=breaks, main=NA)

  if(!is.na(main) & is.null(wrd)) title(main=gettextf("%s (c: %s)", main, breaks))
  # return(invisible(c(devlst, dev.cur()))) # return window numbers ..

  if(!is.null(wrd)) WrdPlot(width=6.5, height=4, dfact=2.5, wrd=wrd, append.cr=TRUE)
  invisible()

}


PlotDesc.matrix <- function(x, col1=getOption("col1", hblue), col2=getOption("col2", hred),
                           horiz = TRUE, main=NA, ..., wrd=NULL){

  # treat matrix as table
  PlotDesc.table(x, col1=col1, col2=col2, horiz=horiz, main=main, ..., wrd=wrd)
}



PlotMosaic <- function (x, main = deparse(substitute(x)), horiz = TRUE, cols = NULL,
                        off = 0.02, mar = NULL, xlab = NULL, ylab = NULL) {

  if (is.null(xlab))
    xlab <- Coalesce(names(dimnames(x)[2]), "x")
  if (is.null(ylab))
    ylab <- Coalesce(names(dimnames(x)[1]), "y")
  if (is.null(mar))
    mar <- c(ifelse(is.na(xlab), 2.1, 5.1), ifelse(is.na(ylab), 5.1, 7.1),
             ifelse(is.na(main), 6.1, 8.1), 1.6)

  Canvas(xlim = c(0, 1), ylim = c(0, 1), asp = NA, mar = mar)

  col1 <- getOption("col1", hblue)
  col2 <- getOption("col2", hred)

  oldpar <- par(xpd = TRUE)
  on.exit(par(oldpar))

  if (horiz) {

    if (is.null(cols))
      cols <- colorRampPalette(c(col1, "white", col2), space = "rgb")(ncol(x))

    ptab <- Rev(prop.table(x, 1), margin = 1)
    ptab <- ptab * (1 - (ncol(ptab) - 1) * off)
    pxt <- Rev(prop.table(margin.table(x, 1)) * (1 - (nrow(x) - 1) * off))

    y_from <- c(0, cumsum(pxt) + (1:(nrow(x))) * off)[-nrow(x) - 1]
    y_to <- cumsum(pxt) + (0:(nrow(x) - 1)) * off

    x_from <- t((apply(cbind(0, ptab), 1, cumsum) + (0:ncol(ptab)) * off)[-(ncol(ptab) + 1), ])
    x_to <- t((apply(ptab, 1, cumsum) + (0:(ncol(ptab) - 1) * off))[-(ncol(ptab) + 1), ])

    for (j in 1:nrow(ptab)) {
      rect(xleft = x_from[j,], ybottom = y_from[j],
           xright = x_to[j,], ytop = y_to[j], col = cols)
    }

    txt_y <- apply(cbind(y_from, y_to), 1, mean)
    txt_x <- apply(cbind(x_from[nrow(x_from),], x_to[nrow(x_from),]), 1, mean)

    text(labels = Rev(rownames(x)), y = txt_y, x = -0.04, las = 1, adj = 1)
    text(labels = colnames(x), x = txt_x, y = 1.04, srt = 90, adj = 0)

  } else {

    if (is.null(cols))
      cols <- colorRampPalette(c(col1, "white", col2), space = "rgb")(nrow(x))

    ptab <- Rev(prop.table(x, 2), margin = 1)
    ptab <- ptab * (1 - (nrow(ptab) - 1) * off)
    pxt <- (prop.table(margin.table(x, 2)) * (1 - (ncol(x) - 1) * off))

    x_from <- c(0, cumsum(pxt) + (1:(ncol(x))) * off)[-ncol(x) -
                                                          1]
    x_to <- cumsum(pxt) + (0:(ncol(x) - 1)) * off
    y_from <- (apply(rbind(0, ptab), 2, cumsum) + (0:nrow(ptab)) *
                 off)[-(nrow(ptab) + 1), ]
    y_to <- (apply(ptab, 2, cumsum) + (0:(nrow(ptab) - 1) *
                                         off))[-(nrow(ptab) + 1), ]
    for (j in 1:ncol(ptab)) {
      rect(xleft = x_from[j], ybottom = y_from[, j], xright = x_to[j],
           ytop = y_to[, j], col = cols)
    }

    txt_y <- apply(cbind(y_from[, 1], y_to[, 1]), 1, mean)
    txt_x <- apply(cbind(x_from, x_to), 1, mean)

    text(labels = Rev(rownames(x)), y = txt_y, x = -0.04, las = 1, adj = 1)
    text(labels = colnames(x), x = txt_x, y = 1.04, srt = 90, adj = 0)

  }

  if (!is.na(main)) title(main = main)
  if (!is.na(xlab)) title(xlab = xlab, line = 1)
  if (!is.na(ylab)) title(ylab = ylab)

  invisible(list(x = txt_x, y = txt_y))

}




PlotDesc.table <- function(x, col1=getOption("col1", hblue), col2=getOption("col2", hred),
                        horiz = TRUE, main=NA, ..., wrd=NULL){

  oldpar <- par(no.readonly=TRUE);  on.exit( par(oldpar) )

  if(length(dim(x)) == 1){
    maxrows <- InDots(..., arg="maxrows", default = 12)
    PlotDesc.factor(Untable(x)[,], main=main, ord="none", wrd=wrd, maxrows=maxrows)
    width <- 6
    height <- 4

  } else if(length(dim(x)) > 2){
    mosaicplot(x, main="", cex=0.8, las=1 # , xlab="", ylab=""
               , col=colorRampPalette(c(col1, "white", col2), space = "rgb")(ncol(x)), ... )

    width <- 8
    height <- 8  # dimension for 2 mosaicplots
    par(mfrow=c(1,1))
    par(mar=c(3.1,4.1,1.1,0.5), oma=c(0,0,ifelse(is.na(main), 0, 2),0))

  } else {

    if(horiz){
      width <- 16
      height <- 6.5  # dimension for 2 mosaicplots
      par(mfrow=c(1,2))
      par(oma=c(1.1, 2.1,ifelse(is.na(main), 0, 2.1),0))

    } else {
      width <- 7
      height <- 14  # dimension for 2 mosaicplots
      par(mfrow=c(2,1), xpd=TRUE)
      par(oma=c(3.1,1.1,ifelse(is.na(main), 0, 2),0))
    }


    PlotMosaic(x, main=NA, xlab=NA, ylab=NA, horiz=TRUE)
    PlotMosaic(x, main=NA, xlab=NA, ylab=NA, horiz=FALSE)

    title(xlab=Coalesce(names(dimnames(x))[2], "x"), outer=TRUE, line=-1)
    title(ylab=Coalesce(names(dimnames(x))[1], "y"), outer=TRUE, line=0)

  }

  if(!is.null(wrd)) WrdPlot(width=width, height=height, dfact=2.0, crop=c(0,0,0,0), wrd=wrd, append.cr=TRUE)

  if(!is.na(main) && (length(dim(x)) != 1)) title(main, outer=TRUE)

  invisible()

}

#
#
# PlotDesc.table <- function(x, col1=getOption("col1", hblue), col2=getOption("col2", hred),
#                            horiz = TRUE, main=NA, ..., mar=c(1.1, 1.1), wrd=NULL){
#
#   oldpar <- par(no.readonly=TRUE);  on.exit( par(oldpar) )
#
#   if(length(dim(x)) == 1){
#     maxrows <- InDots(..., arg="maxrows", default = 12)
#     PlotDesc.factor(Untable(x)[,], main=main, ord="none", wrd=wrd, maxrows=maxrows)
#     width <- 6
#     height <- 4
#
#   } else if(length(dim(x)) > 2){
#     mosaicplot(x, main="", cex=0.8, las=1 # , xlab="", ylab=""
#                , col=colorRampPalette(c(col1, "white", col2), space = "rgb")(ncol(x)), ... )
#
#     width <- 8
#     height <- 8  # dimension for 2 mosaicplots
#     par(mfrow=c(1,1))
#     par(mar=c(3.1,4.1,1.1,0.5), oma=c(0,0,ifelse(is.na(main), 0, 2),0))
#
#   } else {
#
#     if(horiz){
#       width <- 16
#       height <- 6.5  # dimension for 2 mosaicplots
#       par(mfrow=c(1,2))
#       # par(mar=c(0,2.1,1.1,0.5), oma=c(3.1,2.1,ifelse(is.na(main), 0, 2),0))
#       par(mar=c(0, mar[1], mar[2],0.5), oma=c(3.1,1.1,ifelse(is.na(main), 0, 2),0))
#
#       #par(mfrow=c(1,2), oma=c(3.1, 3.1, 5.1, 0))
#
#     } else {
#       width <- 7
#       height <- 14  # dimension for 2 mosaicplots
#       par(mfrow=c(2,1), xpd=TRUE)
#       par(mar=c(1.1,mar[1], mar[2],0.5), oma=c(3.1,1.1,ifelse(is.na(main), 0, 2),0))
#     }
#
#
#     PlotMosaic(x, main=NULL, horiz=TRUE)
#     PlotMosaic(x, main=NULL, horiz=FALSE)
#
#     title(xlab=Coalesce(names(dimnames(x))[2], "x"),
#           ylab=Coalesce(names(dimnames(x))[1], "y"), outer=TRUE, line = 1)
#
#
# #     mosaicplot(x, main="", cex=0.8, las=2, dir=c("h","v"), xlab="", ylab=""
# #       , col=colorRampPalette(c(col1, "white", col2), space = "rgb")(ncol(x)), ... )
# #
# #     if(horiz) Mar(,0) else Mar(,,0)
# #
# #     mosaicplot(t(x), main="", cex=0.8, las=2, xlab="", ylab=""
# #       , col=colorRampPalette(c(col1, "white", col2), space = "rgb")(ncol(t(x))), ... )
# #
# #     title(xlab=Coalesce(names(dimnames(x))[2], "x"), outer=TRUE,  line = 1)
# #     title(ylab=Coalesce(names(dimnames(x))[1], "y"), outer=TRUE,  line = -1)
#
#   }
#
#   if(!is.null(wrd)) WrdPlot(width=width, height=height, dfact=2.0, crop=c(0,0,0,0), wrd=wrd, append.cr=TRUE)
#
#   if(!is.na(main) && (length(dim(x)) != 1)) title(main, outer=TRUE)
#
#   # ToDo:
#   # place another good table plot from vcd here, but which?....
#   invisible()
#
# }


## PlotDesc for bivariate representations  -------------

PlotDescNumFact <- function( formula, data, main=deparse(formula), notch=FALSE,
  add_ni = TRUE, ... , wrd=NULL){

  # PlotMultiDens() would maybe be nice as well
  # or perhaps violinplot??

  # create a new graphics window
  usr <- par("usr");  on.exit( par(usr) )
  par( mar=c(5,4,2*add_ni,2)+.1, oma=c(0,0,4.1,0))

  layout( matrix(c(1,2), ncol=2, byrow=TRUE), widths=c(2,1), TRUE)
  boxplot( formula, data, notch=notch, type="n", xaxt="n", yaxt="n", ... )
  grid(nx=NA, ny=NULL)
  bx <- boxplot( formula, data, col="white", notch=notch, add=TRUE, cex.axis=0.8, ... )

  if(add_ni){ mtext( paste("n=", bx$n, sep=""), side=3, line=1, at=1:length(bx$n), cex=0.8) }

  plot.design(x=formula, data=data, cex=0.8, xlab="", ylab="", cex.axis=0.8, main="", ... )
  mtext( "means", side=3, line=1, cex=0.8)
  title(main=main, outer=TRUE)

  if(!is.null(wrd)) WrdPlot(width=15, height=7, dfact=2.2, crop=c(0,0,0.2,0), wrd=wrd, append.cr=TRUE)
  invisible()

}




PlotDescNumNum <- function( form1, form2, data, main = NULL, xlab= NULL, ylab= NULL, ... , wrd=NULL) {

  # create a new graphics window
  usr <- par("usr");  on.exit( par(usr) )
  par(mfrow=c(1,2), mar=c(5.1, 4.1, 4.1, 2.1), oma=c(0,0,0,0))

  plot( form1, data=data, col=rgb(0,0,0,0.3), type="n", main=NA, xlab=xlab, ylab=ylab, ... )
  grid()
  points( form1, data=data, col=rgb(0,0,0,0.3) )
  lines(loess(form1, data=data))

  # und alles nochmals mit vertauschten Achsen
  # transponiere die formula
  plot( form2, data=data, col=rgb(0,0,0,0.3), type="n", main=NA, xlab=ylab, ylab=xlab,... )
  grid()
  points( form2, data=data, col=rgb(0,0,0,0.3) )
  lines(loess(form2, data=data))

  if(is.null(main)) main <- form1
  if(!is.na(main)) title(main = main, outer=TRUE, line = -1.5)

  if(!is.null(wrd)) WrdPlot(width=13, height=6.5, dfact=2.5, crop=c(0,0,0.2,0), wrd=wrd, append.cr=TRUE)
  invisible()

}


PlotDesc.flags <- function(x, ..., wrd = NULL){

  oldpar <- par(no.readonly=TRUE);  on.exit( par(oldpar) )

  flags <- do.call(rbind, lapply(x, function(z) {
    tab <- table(z)
    BinomCI(tab[1], sum(tab))
  }))
  rownames(flags) <- names(x)

  par(mai=c(1, max(strwidth(rev(rownames(flags)), "inch"))+2, 0.2, .3)+.02)
  PlotDot(flags, lwd = 20, code = 0, cex=0.9,
          lcolor = PalHelsana()["hellgruen"], pch="|", pch.cex = 2.5,
          xlim=c(0,1), lend="butt")

  if(!is.null(wrd)) WrdPlot(width=8, height=pmin(3+3/6*nrow(flags), 10),
                            dfact=2.5, crop=c(0,0,0.2,0), wrd=wrd, append.cr=TRUE)
  invisible()

}


###

## Descriptive summaries for bivariate description  ====


# Summary fuer kontinuierliche ~ factor Variablen

DescNumFact <- function( x, grp, digits = NULL
  , xname=deparse(substitute(x)), grpname=deparse(substitute(grp))
  , width=getOption("width")
  , use.na = c("no", "ifany", "always"), plotit=getOption("plotit", FALSE)) {

  if( is.null(digits) ) {
    digits <- c(NA,NA,NA,NA,0,3,0,0)
  } else if (length(digits) == 1)  {
    digits <- c(rep(digits, 4),0,3,0,0)
  }
  # else take them, as they are defined

	outline <- function(x, width, digits=NA, markext=TRUE) {

		out <- paste(paste( formatC( x, width=width, digits=digits, format="f" ), collapse=" "),"")
		if(markext==TRUE) {
		  for( i in which(x==min(x))*(width+1) ) substr(out,i,i) <- getOption("footnote1","'")
		  for( i in which(x==max(x))*(width+1) ) substr(out,i,i) <- getOption("footnote2",'"')
		}
		return(out)
	}

  # Pairs summary
  n <- length(x)
  idcomp <- complete.cases(x, grp)
  vn <- sum(idcomp)
  dig <- format.info(signif((n-vn)/n*100,3))[2]-2    # hier 3 signifikante Stellen fuer beide Angaben bestimmen

  d.res <- data.frame(
      mean= tapply( x, grp, FUN=mean, na.rm=T )
	  , median= tapply( x, grp, FUN=median, na.rm=T )
	  , sd= tapply( x, grp, FUN=sd, na.rm=T )
	  , IQR= tapply( x, grp, FUN=IQR, na.rm=T )
#	  , n= tapply( x, grp, FUN=length )  function(x) sum(!is.na(x))
#	  , np= tapply( x, grp, FUN=length )/sum(!is.na(x))
    , n= tapply( x, grp, FUN=function(x) sum(!is.na(x)) )
	  , np= tapply( x, grp, FUN=function(x) sum(!is.na(x))) / vn
	  , NAs= tapply( x, grp, FUN=function(x) sum(is.na(x)))
	  , "0s"= tapply( x, grp, FUN=function(x) sum(na.omit(x)==0))
    , row.names=NULL
	)
  if(is.null(levels(grp))) cname <- levels(factor(grp)) else cname <- levels(grp)
  cname[is.na(cname)] <- "NA"
  rownames(d.res) <- cname
  rname <- c("mean","median","sd","IQR","n","np","NAs","0s")  # cannot use names as 0s is replaced by X.0s....

  cat("\nSummary: \n",
      "n pairs: ", .fmt(n),
      ", valid: ", .fmt(vn), " (", round(vn/n*100, dig), "%)",
      ", missings: ", .fmt(n-vn), " (", round((n-vn)/n*100, dig), "%)",
      ", groups: ", length(cname),
      "\n\n"
      , sep="" )

	d.fmt <- data.frame(digits=rep(NA,ncol(d.res)), width=NA)
	for( i in 1:ncol(d.res) ){
     if(is.na(digits[i])) {
	     d.fmt$digits[i] <- Ndec(format(d.res[,i])[1])
	   } else {
       d.fmt$digits[i] <- digits[i]
	   }
     d.fmt$width[i] <- max( nchar(formatC(d.res[,i], format="f", digits=d.fmt$digits[i])) )
	}
  # d.fmt$digits[6] <- signif( d.res$np, 3)
  # d.fmt$width[6] <- max( nchar(formatC(d.res[,6], format="f", digits=d.fmt$digits[6])) )

  wmax <- max(c( max(d.fmt$width)   # die maximale Breite der Zahlen
    , nchar(rownames(d.res))) )     # die maximale Breite der ueberschriften
  lenrowname <- max(nchar(rname))

	out <- vector(mode="character", length=ncol(d.res)+1)
	out[1] <- paste( paste(rep(" ",lenrowname),collapse=""),
	    outline(rownames(d.res), width=wmax+1, digits=NA, markext=FALSE)
		, sep=" ")

	markext <- c(TRUE,TRUE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE)
  cat( "\n" )

	for( i in 1:ncol(d.res) ){
	  out[i+1] <- paste(paste( format( rname[i], width=lenrowname )
	    , outline(d.res[,i], width=wmax+1, digits=d.fmt$digits[i], markext=markext[i]), collapse="" )
		, sep=" " )
	}
  #cat( wmax+2, "\n")
	CatTable(out, wcol=wmax+2, nrepchars=8, width )
  cat(gettextf("%s min, %s max\n", Coalesce(getOption("footnote1"),"'"), Coalesce(getOption("footnote2"),'"')))

  # cat("\nKruskal-Wallis rank sum test:\n  "
	#   , .CaptOut( kruskal.test( x ~ grp, na.action = "na.omit" ))[5], "\n", sep="")

  res <- tryCatch(kruskal.test( x ~ grp, na.action = "na.omit"), error=function(e) {e})

  if (inherits(res, "simpleError")) {
    cat(gettextf("\nError in kruskal.test(x) : %s\n\n", res$message))
  } else {
    cat(gettextf("\nKruskal-Wallis rank sum test:\n  %s",
                 .CaptOut(res)[5], "\n\n", sep=""))
  }

  if((sum(is.na(grp)) > 0) & (length(grep("NA",cname))==0))
    cat(gettextf("\nWarning:\n  Grouping variable contains %s NAs (%s"
      , sum(is.na(grp)), signif(sum(is.na(grp))/length(grp), digits=3)*100), "%).\n", sep="")

  cat( "\n")

  if(plotit){
    PlotDescNumFact( formula=formula("x ~ grp"), data=data.frame(x=x, grp=grp),
                     main=paste(xname, " ~ ", grpname, sep="") )
    # main would be nice here...
  }
  invisible()

}




DescNumNum <- function(x, y, xname=deparse(substitute(x))
    , yname=deparse(substitute(y)), plotit=getOption("plotit", FALSE)) {

  n <- length(x)
  vn <- sum(complete.cases(x,y))
  digits <- format.info(signif((n-vn)/n*100,3))[2]-2    # hier 3 signifikante Stellen fuer beide Angaben bestimmen
  cat( "\nSummary: \n",
    "n pairs: ", Format(n, digits=0, big.mark="'"),
    ", valid: ", Format(vn, digits=0, big.mark="'"), " (", Format(vn/n, digits=1, fmt="%"), ")",
# old:    ", missings: ", Format(n-vn, big.mark="'"), " (", round((n-vn)/n*100, digits), "%)\n\n"
    ", missings: ", Format(n-vn, digits=0, big.mark="'"), " (", Format((n-vn)/n, digits=1, fmt="%"), ")\n\n"
	, sep="" )

  cat(sprintf(
    "\nPearson corr. : %s\nSpearman corr.: %s\nKendall corr. : %s\n"
    , Format(cor(x, y, use="pairwise.complete.obs"), digits=3)
    , Format(cor(x, y, method="spearman", use="pairwise.complete.obs"), digits=3)
    , if(n < 5000){
        Format(cor(x, y, method="kendall", use="pairwise.complete.obs"), digits=3)
      } else {
        "(sample too large)"
      }
  ))

  cat("\n")

  if(plotit){
    d.frm <- data.frame(x=x, y=y)
#     names(d.frm) <-  c(xname, yname)
#     PlotDescNumNum( form1=formula(gettextf("%s ~ %s", xname, yname)),
#                     form2=formula(gettextf("%s ~ %s", yname, xname)), data=d.frm,
#                     main = gettextf("%s ~ %s", yname, xname) )
    PlotDescNumNum( form1=formula("y ~ x"),
                    form2=formula("x ~ y"), data=d.frm,
                    main = gettextf("%s ~ %s", yname, xname), xlab = xname, ylab = yname )
  }
  invisible()

}


DescFactNum <- function(x, y, xname=deparse(substitute(x))
                       , yname=deparse(substitute(y)), plotit=getOption("plotit", FALSE), digits = NULL, ...) {

  # use the other way round first
  DescNumFact(x = y, grp = x, plotit=FALSE, digits=digits, ... )

  xy <- na.omit(data.frame(x=x, y=y))

  ptab <- prop.table(table(unname(xy$x), CutQ(xy$y, probs = seq(0,1,0.1), na.rm = TRUE)), 2)
  cat(gettextf("\nProportions of %s in the quantiles of %s:\n", xname , yname))
  print(round(ptab,3), quote=FALSE)
  cat("\n")

  if(plotit) PlotDescFactNum(y, x, ptab, main=paste(xname, " ~ ", yname, sep=""))
  invisible()

}



PlotDescFactNum <- function( x, y, ptab, col1=getOption("col1", hblue), col2=getOption("col2", hred), main=NULL, notch=FALSE,
                            add_ni = TRUE, ... , wrd=NULL){

  if(is.null(main)) main <- paste(deparse(substitute(y)), " ~ ", deparse(substitute(x)), sep="")

  usr <- par("usr");  on.exit( par(usr) )
  par( mar=c(5,4,2*add_ni,2)+.1, oma=c(0,0,4.1,0))

  layout( matrix(c(1,2), ncol=2, byrow=TRUE), widths=c(1,2), TRUE)
  boxplot(x ~ y, notch=notch, type="n", xaxt="n", yaxt="n", ... )
  grid(nx=NA, ny=NULL)
  bx <- boxplot( x ~ y, col="white", notch=notch, add=TRUE, cex.axis=0.8, ... )

  if(add_ni){ mtext( paste("n=", bx$n, sep=""), side=3, line=1, at=1:length(bx$n), cex=0.8) }

  if(nrow(ptab) < 3){
    plot(ptab[2,], xaxt="n", las=1, ylab="", xlab="Quantiles of x")
    axis(side=1, at=1:10, labels=gettextf("Q%s", 1:10))
    grid()
    if(ncol(ptab) > 6) { lines(loess(p ~ x, data.frame(p=ptab[2,], x=1:ncol(ptab)))) }
  } else {
    Mar(,,1,)
    mosaicplot(t(ptab), las=1, cex=1, col=colorRampPalette(c(col1, "white", col2), space = "rgb")(nrow(ptab)), main=NA)
  }

  title(main=main, outer=TRUE)

  if(!is.null(wrd)) WrdPlot(width=15, height=7, dfact=2.2, crop=c(0,0,0.2,0), wrd=wrd, append.cr=TRUE)
  invisible()

}



###

## Special: Desc.formula() ====


ParseFormula <- function(formula, data=parent.frame(), drop = TRUE) {

  xhs <- function(formula, data = parent.frame(), na.action=na.pass){

    # get all variables out of the formula
    vars <- attr(terms(formula, data=data), "term.labels")

    # evaluate model.frame
    mf <- match.call(expand.dots = FALSE)
    m <- match(c("formula", "data", "na.action"), names(mf), 0)
    mf <- mf[c(1, m)]
    mf$na.action <- na.action
    mf$drop.unused.levels <- TRUE
    mf[[1]] <- as.name("model.frame")

    mf.rhs <- eval.parent(mf)

    # model frame does not evaluate interaction, so let's do that here
    d.tmp <- mf.rhs[,FALSE] # create a new data.frame
    for(x in vars){
      if( length(grep(":", x))>0 )      # there's a : in the variable
        d.tmp <- data.frame(d.tmp,
           interaction( mf.rhs[, names(mf.rhs)[names(mf.rhs) %in% unlist(strsplit(x, ":"))]],
              sep=":", drop = drop)      # set drop unused levels to TRUE here by default
        )
      else
        d.tmp <- data.frame(d.tmp, mf.rhs[,x])
    }
    names(d.tmp) <- vars

    return(list(formula=formula, mf=mf.rhs, mf.eval=d.tmp, vars=vars))
  }

  f1 <- formula

  # evaluate subset
  m <- match.call(expand.dots = FALSE)

  # do not support . on both sides of the formula
  if( (length(grep("^\\.$", all.vars(f1[[2]])))>0) && (length(grep("^\\.$", all.vars(f1[[3]])))>0) )
    stop("dot argument on both sides of the formula are not supported")

  # swap left and right hand side and take just the right side
  # so both sides are evaluated with right side logic, but independently
  lhs <- xhs(formula(paste("~", deparse(f1[[2]])), data=data), data=data)
  rhs <- xhs(formula(paste("~", deparse(f1[[3]])), data=data), data=data)

  # now handle the dot argument
  if(any(all.vars(f1[[2]]) == ".")){   # dot on the left side
    lhs$vars <- lhs$vars[!lhs$vars %in% rhs$vars]
    lhs$mf <- lhs$mf[lhs$vars]
    lhs$mf.eval <- lhs$mf.eval[lhs$vars]
  } else if(any(all.vars(f1[[3]]) == ".")){     # dot on the right side
    rhs$vars <- rhs$vars[!rhs$vars %in% lhs$vars]
    rhs$mf <- rhs$mf[rhs$vars]
    rhs$mf.eval <- rhs$mf.eval[rhs$vars]
  } else {    # no dot: do nothing
  }

  list(formula=formula, lhs=list(mf=lhs$mf, mf.eval=lhs$mf.eval, vars=lhs$vars),
    rhs=list(mf=rhs$mf, mf.eval=rhs$mf.eval, vars=rhs$vars))

}



Desc.formula <- function(formula, data = parent.frame(), subset, plotit=getOption("plotit", FALSE), ...) {

  mf <- match.call(expand.dots = FALSE)

  # parse dots.arguments, such as not to send unappropriate arguments to subfunctions
  dotargs.factor.factor <- mf$...[ names(mf$...)[
    !is.na(match(names(mf$...), names( formals( Desc.table) )))
    ] ]
  dotargs.numeric.factor <- mf$...[ names(mf$...)[
    !is.na(match(names(mf$...), names( formals( DescNumFact) )))
    ] ]
  dotargs.factor.numeric <- mf$...[ names(mf$...)[
    !is.na(match(names(mf$...), names( formals( DescFactNum) )))
    ] ]
  dotargs.numeric.numeric <- mf$...[ names(mf$...)[
    !is.na(match(names(mf$...), names( formals( DescNumNum) )))
    ] ]

  subset.expr <- mf$subset
  mf$subset <- NULL
  if (!missing(subset)) {
    s <- eval(subset.expr, data, parent.frame())
    data <- data[s,]
  }

  mm <- ParseFormula(formula=formula, data=data)

  # don't want AsIs (will come in case of I(...)) to proceed, so just coerce to vector an back again
  # but don't use the following, as interaction names will be set to y.x instead of y:x
  # mm$lhs$mf.eval <- data.frame(lapply(mm$lhs$mf.eval, as.vector))
  # mm$rhs$mf.eval <- data.frame(lapply(mm$rhs$mf.eval, as.vector))
  for(i in which(lapply(mm$lhs$mf.eval, class) == "AsIs")) {
    mm$lhs$mf.eval[,i] <- as.vector(mm$lhs$mf.eval[,i])
  }
  for(i in which(lapply(mm$rhs$mf.eval, class) == "AsIs")) {
    mm$rhs$mf.eval[,i] <- as.vector(mm$rhs$mf.eval[,i])
  }

  # start output
  cat("\nCall:\n")
  cat(paste(deparse(sys.call()), sep = "\n", collapse = "\n"),"\n\n", sep = "")

  # start analysis
  for(resp in mm$lhs$vars){         # for all response variables
    for(pred in mm$rhs$vars){       # evalutate for all conditions
      x <- mm$lhs$mf.eval[,resp]
      grp <- mm$rhs$mf.eval[,pred]

      cat( paste(rep("-",(as.numeric(options("width"))-2)), collapse=""), "\n" )
      cat( paste(resp, " ~ ", pred, sep="") )
      if( !is.null(attr(x,"label")) ) cat(" :", strwrap(attr(x,"label"), indent=2, exdent=2), sep="\n" )
      cat("\n")

      # coerce logicals and characters to factors
#       if( class(x)[1] %in% c("logical","character")) x <- factor(x)
#       if( class(grp)[1] %in% c("logical","character")) grp <- factor(grp)
      if( IsDichotomous(x)) x <- factor(x)
      if( IsDichotomous(grp)) grp <- factor(grp)


      if(class(x)[1] %in% c("numeric","integer")){

          if(class(grp)[1] %in% c("numeric","integer")){
            do.call( DescNumNum, args=append( list(x=grp, y=x, xname=pred, yname=resp, plotit=plotit), dotargs.numeric.numeric))

          } else if(class(grp)[1] %in% c("factor","ordered")){
            do.call( DescNumFact, args=append( list(x=x, grp=grp, xname=resp, grpname=pred, plotit=plotit), dotargs.numeric.factor ))

          } else {
            cat(gettextf("Don't know how to describe class: %s ~ %s!\n", paste(class(x), collapse=", "),
                         paste(class(grp), collapse=", ")), "\n")
          }
      } else if(class(x)[1] %in% c("factor","ordered")){

          if( class(grp)[1] %in% c("numeric","integer")){
            do.call( DescFactNum, args=append( list(x=x, y=grp, xname=resp, yname=pred, plotit=plotit), dotargs.factor.numeric ))

          } else if ( class(grp)[1] %in% c("factor","ordered")){
            useNA <- InDots(..., arg="useNA", default="no")
            tab <- table(x, grp, dnn=c(resp, pred), useNA=useNA)

            if(useNA == "no"){  # add missing info only if there are any (depends on useNA)
              n <- max(length(x),length(grp))
              idcomp <- complete.cases(x, grp)  # cases
              vn <- sum(idcomp)                 # valid n pairs
              missn <- paste("total pairs: ", Format(n, fmt=.fmt_abs()),
    #                          ", valid: ", .fmt(vn), " (", round(vn/n*100, 3), "%)",
    #                           ... well, don't use .fmt_per() here, as it would not be understandable in the context
                             ", missings: ", Format(n-vn, fmt=.fmt_abs()), " (", Format((n-vn)/n, digits=2, fmt="%"), ")",
                             sep="")
              attr(tab, "missings") <- missn
            }

            main <- gettextf("%s ~ %s", resp, pred)
            do.call( Desc, args=append( list(x=tab, xname="", grpname="", plotit=FALSE, main=NA), dotargs.factor.factor) )
            if(plotit) PlotDesc.table(tab, main=main)
          } else {
            cat(gettextf("Don't know how to describe class: %s ~ %s!\n", class(x), class(grp)), "\n")
          }
      } else {
        cat(gettextf("Don't know how to describe class: %s ~ %s!\n", class(x), class(grp)), "\n")
      }

    }
  }
invisible()

}



###


## Word descriptives:  DescWrd. ... ====

DescWrd.default <- function(x, wrd, main = deparse(substitute(x)),
                            plotit = getOption("plotit", FALSE), ...) {

  .plotReset <- function(){
    layout(matrix(1))
    par(
      xlog = FALSE, ylog = FALSE, adj = 0.5, ann = TRUE,
      ask = FALSE, bg = "white", bty = "o", cex = 1, cex.axis = 1,
      cex.lab = 1, cex.main = 1.2, cex.sub = 1, col = "black",
      col.axis = "black", col.lab = "black", col.main = "black",
      col.sub = "black", crt = 0, err = 0L, family = "", fg = "black",
      fig = c(0, 1, 0, 1), fin = c(12.8333333333333, 8), font = 1L,
      font.axis = 1L, font.lab = 1L, font.main = 2L, font.sub = 1L,
      #      lab = c(5L, 5L, 7L), las = 0L, lend = "round", lheight = 1,
      lab = c(5L, 5L, 7L), lend = "round", lheight = 1,
      ljoin = "round", lmitre = 10, lty = "solid", lwd = 1,
      mai = c(1.36, 1.09333, 1.093333, 0.56), mar = c(5.1, 4.1,4.1, 2.1),
      mex = 1, mfcol = c(1L, 1L), mfg = c(1L, 1L, 1L, 1L),
      mfrow = c(1L, 1L), mgp = c(3, 1, 0), mkh = 0.001, new = FALSE,
      oma = c(0, 0, 0, 0), omd = c(0, 1, 0, 1), omi = c(0, 0, 0, 0),
      pch = 1L, pin = c(11.18, 5.54666666666667),
      plt = c(0.0851948051948052, 0.956363636363636, 0.17, 0.863333333333333),
      ps = 16L, pty = "m", smo = 1, srt = 0, tck = NA_real_,
      tcl = -0.5, usr = c(0, 1, 0, 1), xaxp = c(0, 1, 5), xaxs = "r", xaxt = "s", xpd = FALSE,
      yaxp = c(0, 1, 5), yaxs = "r", yaxt = "s", ylbias = 0.2)
    #     par(
    #       xlog = FALSE, ylog = FALSE,
    #       mai = c(1.36, 1.09333, 1.093333, 0.56), mar = c(5.1, 4.1,4.1, 2.1),
    #       mex = 1, mfcol = c(1L, 1L), mfg = c(1L, 1L, 1L, 1L),
    #       mfrow = c(1L, 1L),
    #       oma = c(0, 0, 0, 0), omd = c(0, 1, 0, 1), omi = c(0, 0, 0, 0),
    #       usr = c(0, 1, 0, 1), xpd = FALSE
    #       )
  }


  if(!is.null(main)) WrdCaption(x=main, wrd=wrd)

  # we should overwrite plotit here, as it would be plotted two times...
  txt <- .CaptOut(Desc(x, plotit = FALSE, ...))[-(1:2)]

  # insert table
  if(inherits(x, "Date")) {
    # special Date Table...
    wrd[["ActiveDocument"]][["Tables"]]$Add( wrd[["Selection"]][["Range"]], NumRows=2, NumColumns=2 )
    wrd[["Selection"]]$MoveRight(Unit=wdConst$wdCharacter, Count=2, Extend=wdConst$wdExtend)
    wrd[["Selection"]][["Cells"]]$Merge()

    WrdText( txt=txt[1:6], wrd=wrd )
    wrd[["Selection"]]$MoveRight( wdConst$wdCell, 1, 0)
    WrdText( txt=txt[-c(1:6)], wrd=wrd )

  } else {
    if(max(unlist(lapply(txt, nchar))) < 59){  # decide if two rows or 2 columns ist adequate
      wrd[["ActiveDocument"]][["Tables"]]$Add( wrd[["Selection"]][["Range"]], NumRows=1, NumColumns=2 )
      horiz1 <- FALSE
    } else {
      wrd[["ActiveDocument"]][["Tables"]]$Add( wrd[["Selection"]][["Range"]], NumRows=2, NumColumns=1 )
      horiz1 <- TRUE
    }
    WrdText( txt=txt, wrd=wrd )
  }
  wrd[["Selection"]]$MoveRight( wdConst$wdCell, 1, 0)

  if(plotit){
    .plotReset()

    # corr 8.11.2014: not sure if we need the dots here, anyway they can produce errors
    # PlotDesc(x, main="", ..., wrd=wrd)
    if(any(class(x)=="table") || class(x)=="matrix"){
      horiz <- InDots(..., arg="horiz", default = horiz1)
      PlotDesc(x, main="", wrd=wrd, horiz=horiz)  # 2.2.2015: table might need the horiz argument, that's clearly a hack...
      # ...  rises a warning for disregarding other arguments, as verbose for example
      #  ******* KEEP AN EYE ON ME *****************
    } else {
      PlotDesc(x, main="", wrd=wrd)
    }
  }

  wrd[["Selection"]]$EndOf( wdConst$wdTable )
  # get out of tablerange
  wrd[["Selection"]]$MoveRight( wdConst$wdCharacter, 2, 0 )
  wrd[["Selection"]]$TypeParagraph()

  invisible()

}


DescWrd.data.frame <- function (x, wrd, main = NULL, plotit = getOption("plotit", FALSE), enum = TRUE, ...) {

  # Start report:     data.frame  Infos einfuegen **************
  WrdCaption( "Describe data.frame", wrd=wrd )
  wrd[["Selection"]]$TypeParagraph()
  WrdText(.CaptOut(Str(x, list.len = Inf)), wrd = wrd)
  wrd[["Selection"]]$TypeParagraph()
  wrd[["Selection"]]$TypeParagraph()

  if(is.null(main))
    main <- paste(if(enum) paste(seq_along(colnames(x)) , "- "), colnames(x),
                  " (", lapply(lapply(x, class), paste, collapse=", "), ")", sep="")
  else
    main <- rep(main, length.out = ncol(x))

  for( cx in colnames(x) ){
    # cat( "\n", sep, "\n", sep="")
    # Alternative mit Fensterbreite:
    # cat( paste(rep("-",getOption("width")-2),collapse=""), "\n")
    Desc(x[, cx], main = main[match(cx, colnames(x))], wrd = wrd, plotit=plotit, ...)
  }
  cat("\n")
  invisible()

}


DescWrd.list <- function (x, wrd, main = NULL, plotit = getOption("plotit", FALSE), enum = TRUE, ...) {

  # Start report:     data.frame  Infos einfuegen **************
  WrdCaption( "Describe data.frame", wrd=wrd )
  wrd[["Selection"]]$TypeParagraph()
  WrdText(.CaptOut(Str(x, list.len = Inf)), wrd = wrd)
  wrd[["Selection"]]$TypeParagraph()
  wrd[["Selection"]]$TypeParagraph()

  if(is.null(main))
    main <- paste(if(enum) paste(seq_along(names(x)) , "- "), names(x),
                  " (", lapply(lapply(x, class), paste, collapse=", "), ")", sep="")
  else
    main <- rep(main, length.out = length(x))

  for( i in seq_along(x) ){
    # cat( "\n", sep, "\n", sep="")
    # Alternative mit Fensterbreite:
    # cat( paste(rep("-",getOption("width")-2),collapse=""), "\n")
    Desc(x[, i], main = main[i], wrd = wrd, plotit=plotit, ...)
  }
  cat("\n")
  invisible()

}



###

## DescWrd.formula() ====

DescWrd.formula <- function(formula, data = parent.frame(), subset = TRUE, wrd = NULL, plotit = getOption("plotit", FALSE), ...) {

  if(!IsValidWrd(wrd)) stop("wrd is not a valid handle to a running Word instance.")

  mf <- match.call(expand.dots = FALSE)

  # parse dots.arguments, such as not to send unappropriate arguments to subfunctions
  dotargs.factor.factor <- mf$...[ names(mf$...)[
    !is.na(match(names(mf$...), names( formals( Desc.table) )))
    ] ]
  dotargs.numeric.factor <- mf$...[ names(mf$...)[
    !is.na(match(names(mf$...), names( formals( DescNumFact) )))
    ] ]
  dotargs.factor.numeric <- mf$...[ names(mf$...)[
    !is.na(match(names(mf$...), names( formals( DescFactNum) )))
    ] ]
  dotargs.numeric.numeric <- mf$...[ names(mf$...)[
    !is.na(match(names(mf$...), names( formals( DescNumNum) )))
    ] ]

  subset.expr <- mf$subset
  mf$subset <- NULL
  if (!missing(subset)) {
    s <- eval(subset.expr, data, parent.frame())
    data <- data[s,]
  }
  mm <- ParseFormula(formula=formula, data=data)

  # don't want AsIs (will come in case of I(...)) to proceed, so just coerce to vector an back again
  # but don't use the following, as interaction names will be set to y.x instead of y:x
  # mm$lhs$mf.eval <- data.frame(lapply(mm$lhs$mf.eval, as.vector))
  # mm$rhs$mf.eval <- data.frame(lapply(mm$rhs$mf.eval, as.vector))
  for(i in which(lapply(mm$lhs$mf.eval, class) == "AsIs")) {
    mm$lhs$mf.eval[,i] <- as.vector(mm$lhs$mf.eval[,i])
  }
  for(i in which(lapply(mm$rhs$mf.eval, class) == "AsIs")) {
    mm$rhs$mf.eval[,i] <- as.vector(mm$rhs$mf.eval[,i])
  }

  # start output
  cat("\nCall:\n")
  cat(paste(deparse(sys.call()), sep = "\n", collapse = "\n"),"\n\n", sep = "")

  # start analysis
  for(resp in mm$lhs$vars){         # for all response variables
    for(pred in mm$rhs$vars){       # evalutate for all conditions
      x <- mm$lhs$mf.eval[,resp]
      grp <- mm$rhs$mf.eval[,pred]

#       cat( paste(rep("-",(as.numeric(options("width"))-2)), collapse=""), "\n" )
#       cat( paste(resp, " ~ ", pred, sep="") )
#       if( !is.null(attr(x,"label")) ) cat(" :", strwrap(attr(x,"label"), indent=2, exdent=2), sep="\n" )
#       cat("\n")

    # coerce logicals and characters to factors
#     if( class(x)[1] %in% c("logical","character")) x <- factor(x)
#     if( class(grp)[1] %in% c("logical","character")) grp <- factor(grp)
    if( IsDichotomous(x)) x <- factor(x)
    if( IsDichotomous(grp)) grp <- factor(grp)

    # main report caption
    WrdCaption( x=paste(resp, " ~ ", pred, sep=""), wrd=wrd )

    # coerce logicals and characters to factors
    if( class(x)[1] %in% c("logical","character")) x <- factor(x)
    if( class(grp)[1] %in% c("logical","character")) grp <- factor(grp)


    if(class(x)[1] %in% c("numeric","integer")){

      if(class(grp)[1] %in% c("numeric","integer")){
        WrdText( .CaptOut(
          do.call( DescNumNum, args=append( list(x=grp, y=x, xname=pred, yname=resp, plotit=plotit), dotargs.numeric.numeric)) ))
        if(plotit)
          WrdPlot(width=13, height=6.5, dfact=2.5, crop=c(0,0,0.2,0), wrd=wrd, append.cr=TRUE)

      } else if(class(grp)[1] %in% c("factor","ordered")){
        WrdText( .CaptOut(
          do.call( DescNumFact, args=append( list(x=x, grp=grp, xname=resp, grpname=pred, plotit=plotit), dotargs.numeric.factor )) ))
        if(plotit)
          WrdPlot(width=13, height=6.5, dfact=2.5, crop=c(0,0,0.2,0), wrd=wrd, append.cr=TRUE)

      } else {
        cat(gettextf("Don't know how to describe class: %s ~ %s!\n", paste(class(x), collapse=", "),
                     paste(class(grp), collapse=", ")), "\n")
      }
    } else if(class(x)[1] %in% c("factor","ordered")){

      if( class(grp)[1] %in% c("numeric","integer")){
        WrdText( .CaptOut(
          do.call( DescFactNum, args=append( list(x=x, y=grp, xname=resp, yname=pred, plotit=plotit), dotargs.factor.numeric )) ))
        if(plotit)
          WrdPlot(width=13, height=6.5, dfact=2.5, crop=c(0,0,0.2,0), wrd=wrd, append.cr=TRUE)

      } else if ( class(grp)[1] %in% c("factor","ordered")){
        tab <- table(x, grp, dnn=c(resp, pred))
        WrdText( .CaptOut(
          do.call( Desc, args=append( list(x=tab,
                                           xname="", grpname="", plotit=FALSE,
                                           main=NA), dotargs.factor.factor) )
        ))
        WrdText("\n", wrd=wrd)
        if(plotit)
          PlotDesc.table(tab, horiz = TRUE, wrd=wrd)
      } else {
        cat(gettextf("Don't know how to describe class: %s ~ %s!\n", class(x), class(grp)), "\n")
      }
    } else {
      cat(gettextf("Don't know how to describe class: %s ~ %s!\n", class(x), class(grp)), "\n")
    }

    }
  }

  invisible()

}




###

## Word fundamentals  ====

createCOMReference <- function(ref, className) {
  RDCOMClient::createCOMReference(ref, className)
}


GetCurrWrd <- function() {

  # stopifnot(require(RDCOMClient))

  if (requireNamespace("RDCOMClient", quietly = FALSE)) {

    # there's no "get"-function in RDCOMClient, so just create a new here..
    hwnd <- RDCOMClient::COMCreate("Word.Application", existing=TRUE)
    if(is.null(hwnd)) warning("No running Word application found!")

    options(lastWord = hwnd)

  } else {

    if(Sys.info()["sysname"] == "Windows")
      warning("RDCOMClient is not available. To install it use: install.packages('RDCOMClient', repos = 'http://www.stats.ox.ac.uk/pub/RWin/')")
    else
      warning(gettextf("RDCOMClient is unfortunately not available for %s systems (Windows-only).", Sys.info()["sysname"]))

    wrd <- NULL

  }

  invisible(hwnd)

}


GetNewWrd <- function(visible = TRUE, template = "Normal", header=FALSE
                       , main="Descriptive report") {

  # stopifnot(require(RDCOMClient))

  if (requireNamespace("RDCOMClient", quietly = FALSE)) {

    # Starts the Word application with wrd as handle
    hwnd <- RDCOMClient::COMCreate("Word.Application", existing=FALSE)
    options(lastWord = hwnd)

    if( visible == TRUE ) hwnd[["Visible"]] <- TRUE

    # Create a new document based on template
    # VBA code:
    # Documents.Add Template:= _
    #        "O:\G\GI\_Admin\Administration\09_Templates\newlogo_GI_doc_bericht.dot", _
    #        NewTemplate:=False, DocumentType:=0
    #
    newdoc <- hwnd[["Documents"]]$Add(template, FALSE, 0)

    # prepare word document, with front page, table of contents, footer ...
    if(header) .WrdPrepRep( wrd=hwnd, main=main )

  } else {

    if(Sys.info()["sysname"] == "Windows")
      warning("RDCOMClient is not available. To install it use: install.packages('RDCOMClient', repos = 'http://www.stats.ox.ac.uk/pub/RWin/')")
    else
      warning(gettextf("RDCOMClient is unfortunately not available for %s systems (Windows-only).", Sys.info()["sysname"]))

    hwnd <- NULL
  }

  invisible( hwnd )
}



# .GetNewWrdA <- function(visible = TRUE, template = "Normal", header=FALSE
#                       , main="Descriptive report") {
#
#   # stopifnot(require(RDCOMClient))
#
#   # Starts the Word application with wrd as handle
#   wrd <- RDCOMClient::COMCreate("Word.Application", existing=FALSE)
#   options(lastWord = wrd)
#
#   if( visible == TRUE ) wrd[["Visible"]] <- TRUE
#
#   # Create a new document based on template
#   # VBA code:
#   # Documents.Add Template:= _
#   #        "O:\G\GI\_Admin\Administration\09_Templates\newlogo_GI_doc_bericht.dot", _
#   #        NewTemplate:=False, DocumentType:=0
#   #
#   newdoc <- wrd[["Documents"]]$Add(template, FALSE, 0)
#
#   # prepare word document, with front page, table of contents, footer ...
#   if(header) .WrdPrepRep( wrd=wrd, main=main )
#
#   return( invisible( wrd ) )
# }



# GetNewWrd <- function(visible = TRUE, template = "Normal", header=FALSE
#                       , main="Descriptive report") {
#
#   stopifnot(require(RDCOMClient))
#
#   # Starts the Word application with wrd as handle
#   wrd <- RDCOMClient::COMCreate("Word.Application", existing=FALSE)
#   options(lastWord = wrd)
#
#   if( visible == TRUE ) wrd[["Visible"]] <- TRUE
#
#   # Create a new document based on template
#   # VBA code:
#   # Documents.Add Template:= _
#   #        "O:\G\GI\_Admin\Administration\09_Templates\newlogo_GI_doc_bericht.dot", _
#   #        NewTemplate:=False, DocumentType:=0
#   #
#   newdoc <- wrd[["Documents"]]$Add(template, FALSE, 0)
#
#   # prepare word document, with front page, table of contents, footer ...
#   if(header) .WrdPrepRep( wrd=wrd, main=main )
#
#   return( invisible( wrd ) )
# }


.WrdPrepRep <- function(wrd, main="Bericht" ){

  # only internal user out from GetNewWrd()
  # creates new word instance and prepares document for report

  # constants
  # wdPageBreak <- 7
  # wdSeekCurrentPageHeader <- 9  ### Kopfzeile
  # wdSeekCurrentPageFooter <- 10	### Fusszeile
  # wdSeekMainDocument <- 0
  # wdPageFitBestFit <- 2
  # wdFieldEmpty <- -1

  # Show DocumentMap
  wrd[["ActiveWindow"]][["DocumentMap"]] <- TRUE
  wrdWind <- wrd[["ActiveWindow"]][["ActivePane"]][["View"]][["Zoom"]]
  wrdWind[["PageFit"]] <- wdConst$wdPageFitBestFit

  wrd[["Selection"]]$TypeParagraph()
  wrd[["Selection"]]$TypeParagraph()

  wrd[["Selection"]]$WholeStory()
  # 15.1.2012 auskommentiert: WrdSetFont(wrd=wrd)

  # Idee: ueberschrift definieren (geht aber nicht!)
  #wrd[["ActiveDocument"]][["Styles"]]$Item("ueberschrift 2")[["Font"]][["Name"]] <- "Consolas"
  #wrd[["ActiveDocument"]][["Styles"]]$Item("ueberschrift 2")[["Font"]][["Size"]] <- 10
  #wrd[["ActiveDocument"]][["Styles"]]$Item("ueberschrift 2")[["Font"]][["Bold"]] <- TRUE

  #wrd[["ActiveDocument"]][["Styles"]]$Item("ueberschrift 2")[["ParagraphFormat"]]["Borders"]]$Item(wdBorderTop)[["LineStyle"]] <- wdConst$wdLineStyleSingle

  WrdCaption( main, wrd=wrd)
  wrd[["Selection"]]$TypeText(gettextf("%s/%s\n",format(Sys.time(), "%d.%m.%Y"), Sys.getenv("username")))
  wrd[["Selection"]]$InsertBreak( wdConst$wdPageBreak)

  # Inhaltsverzeichnis einfuegen ***************
  wrd[["ActiveDocument"]][["TablesOfContents"]]$Add( wrd[["Selection"]][["Range"]] )
  # Original VB-Code:
  # With ActiveDocument
  # .TablesOfContents.Add Range:=Selection.Range, RightAlignPageNumbers:= _
  # True, UseHeadingStyles:=True, UpperHeadingLevel:=1, _
  # LowerHeadingLevel:=2, IncludePageNumbers:=True, AddedStyles:="", _
  # UseHyperlinks:=True, HidePageNumbersInWeb:=True, UseOutlineLevels:= _
  # True
  # .TablesOfContents(1).TabLeader = wdTabLeaderDots
  # .TablesOfContents.Format = wdIndexIndent
  # End With

  # Fusszeile	***************
  wrdView <- wrd[["ActiveWindow"]][["ActivePane"]][["View"]]
  wrdView[["SeekView"]] <- wdConst$wdSeekCurrentPageFooter
  wrd[["Selection"]]$TypeText( gettextf("%s/%s\t\t",format(Sys.time(), "%d.%m.%Y"), Sys.getenv("username")) )
  wrd[["Selection"]][["Fields"]]$Add( wrd[["Selection"]][["Range"]], wdConst$wdFieldEmpty, "PAGE" )
  # Roland wollte das nicht (23.11.2014):
  # wrd[["Selection"]]$TypeText("\n\n")
  wrdView[["SeekView"]] <- wdConst$wdSeekMainDocument

  wrd[["Selection"]]$InsertBreak( wdConst$wdPageBreak)
  invisible()

}




# put that to an example...
# WrdPageBreak <- function( wrd = .lastWord ) {
#   wrd[["Selection"]]$InsertBreak(wdConst$wdPageBreak)
# }

# WrdPlot(wrd=wrd, height=10, width=16)

WrdPlot <- function( type="png", append.cr=TRUE, crop=c(0,0,0,0), main = NULL,
                     picscale=100, height=NA, width=NA, res=300, dfact=1.6, wrd = getOption("lastWord") ){

  # png is considered a good choice for export to word (Smith)
  # http://blog.revolutionanalytics.com/2009/01/10-tips-for-making-your-r-graphics-look-their-best.html

  # height, width in cm!
  # scale will be overidden, if height/width defined


  # Example: WrdPlot(picscale=30)
  #          WrdPlot(width=8)

  .CentimetersToPoints <- function(x) x * 28.35
  .PointsToCentimeters <- function(x) x / 28.35
  # http://msdn.microsoft.com/en-us/library/bb214076(v=office.12).aspx

  # handle missing height or width values
  if (is.na(width) ){
    if (is.na(height)) {
      width <- 14
      height <- par("pin")[2] / par("pin")[1] * width
    } else {
      width <- par("pin")[1] / par("pin")[2] * height
    }
  } else {
    if (is.na(height) ){
        height <- par("pin")[2] / par("pin")[1] * width
    }
  }


  # get a [type] tempfilename:
  fn <- paste( tempfile(pattern = "file", tmpdir = tempdir()), ".", type, sep="" )
  # this is a problem for RStudio....
  # savePlot( fn, type=type )
  # png(fn, width=width, height=height, units="cm", res=300 )
  dev.copy(eval(parse(text=type)), fn, width=width*dfact, height=height*dfact, res=res, units="cm")
  d <- dev.off()

  # add it to our word report
  res <- wrd[["Selection"]][["InlineShapes"]]$AddPicture( fn, FALSE, TRUE )
  wrdDoc <- wrd[["ActiveDocument"]]
  pic <- wrdDoc[["InlineShapes"]]$Item( wrdDoc[["InlineShapes"]][["Count"]] )

  pic[["LockAspectRatio"]] <- -1  # = msoTrue
  picfrmt <- pic[["PictureFormat"]]
  picfrmt[["CropBottom"]] <- .CentimetersToPoints(crop[1])
  picfrmt[["CropLeft"]] <- .CentimetersToPoints(crop[2])
  picfrmt[["CropTop"]] <- .CentimetersToPoints(crop[3])
  picfrmt[["CropRight"]] <- .CentimetersToPoints(crop[4])

  if( is.na(height) & is.na(width) ){
    # or use the ScaleHeight/ScaleWidth attributes:
    pic[["ScaleHeight"]] <- picscale
    pic[["ScaleWidth"]] <- picscale
  } else {
    # Set new height:
    if( is.na(width) ) width <- height / .PointsToCentimeters( pic[["Height"]] ) * .PointsToCentimeters( pic[["Width"]] )
    if( is.na(height) ) height <- width / .PointsToCentimeters( pic[["Width"]] ) * .PointsToCentimeters( pic[["Height"]] )
    pic[["Height"]] <- .CentimetersToPoints(height)
    pic[["Width"]] <- .CentimetersToPoints(width)
  }

  if( append.cr == TRUE ) { wrd[["Selection"]]$TypeText("\n")
  } else {
    wrd[["Selection"]]$MoveRight(wdConst$wdCharacter, 1, 0)
  }

  if( file.exists(fn) ) { file.remove(fn) }

  if(!is.null(main)){
    # insert caption
    sel <- wrd$Selection()  # "Abbildung"
    sel$InsertCaption(Label=wdConst$wdCaptionFigure, Title=main)
    sel$TypeParagraph()
  }

  invisible(pic)

}


IsValidWrd <- function(wrd = getOption("lastWord")){
  # returns TRUE if the selection of the wrd pointer can be evaluated
  # meaning the pointer points to a running word instance and so far valid
  res <- tryCatch(wrd[["Selection"]], error=function(e) {e})
  return(!inherits(res, "simpleError")) # Error in

}


WrdCaption <- function(x, stylename = wdConst$wdStyleHeading1, wrd = getOption("lastWord") ) {

  wrdSel <- wrd[["Selection"]]
  wrdFont <- wrdSel[["Font"]]

  if(is.null(wrdSel)) stop("No running word found!")

  currfont <- list(
    name = wrdFont[["Name"]] ,
    size = wrdFont[["Size"]] ,
    bold = wrdFont[["Bold"]] ,
    italic = wrdFont[["Italic"]]
  )

  wrdSel[["Style"]] <- stylename
  wrdSel$TypeText(x)
  wrdSel$TypeParagraph()

  wrdSel[["Style"]] <- wdConst$wdStyleNormal

  # Restore old font
  wrdFont[["Name"]] <- currfont[["name"]]
  wrdFont[["Size"]] <- currfont[["size"]]
  wrdFont[["Bold"]] <- currfont[["bold"]]
  wrdFont[["Italic"]] <- currfont[["italic"]]
  invisible()

}


WrdText <- function(txt, fixedfont=TRUE, fontname=NULL,
                    fontsize=NULL, bold=FALSE, italic=FALSE, col=NULL,
                    alignment = c("left","right","center"), spaceBefore=0, spaceAfter=0,
                    lineSpacingRule = wdConst$wdLineSpaceSingle,
                    appendCR=TRUE, wrd=getOption("lastWord") ){

  if(fixedfont){
    fontname <- Coalesce(fontname, getOption("fixedfont", "Consolas"))
    fontsize <- Coalesce(fontsize, getOption("fixedfontsize", 7))
  }

  if (!inherits(txt, "character"))  txt <- .CaptOut(txt)

  wrdSel <- wrd[["Selection"]]
  wrdFont <- wrdSel[["Font"]]

  currfont <- list(
    name = wrdFont[["Name"]] ,
    size = wrdFont[["Size"]] ,
    bold = wrdFont[["Bold"]] ,
    italic = wrdFont[["Italic"]],
    color = wrdFont[["Color"]]
  )

  if(!is.null(fontname)) wrdFont[["Name"]] <- fontname
  if(!is.null(fontsize)) wrdFont[["Size"]] <- fontsize
  wrdFont[["Bold"]] <- bold
  wrdFont[["Italic"]] <- italic
  wrdFont[["Color"]] <- Coalesce(col, wdConst$wdColorBlack)

  alignment <- switch(match.arg(alignment),
                      "left"= wdConst$wdAlignParagraphLeft,
                      "right"= wdConst$wdAlignParagraphRight,
                      "center"= wdConst$wdAlignParagraphCenter
  )

  wrdSel[["ParagraphFormat"]][["Alignment"]] <- alignment
  wrdSel[["ParagraphFormat"]][["SpaceBefore"]]  <- spaceBefore
  wrdSel[["ParagraphFormat"]][["SpaceAfter"]]  <- spaceAfter
  wrdSel[["ParagraphFormat"]][["LineSpacingRule"]] <- lineSpacingRule

  wrdSel$TypeText( paste(txt,collapse="\n") )
  if(appendCR) wrdSel$TypeParagraph()

  # Restore old font
  wrdFont[["Name"]] <- currfont[["name"]]
  wrdFont[["Size"]] <- currfont[["size"]]
  wrdFont[["Bold"]] <- currfont[["bold"]]
  wrdFont[["Italic"]] <- currfont[["italic"]]
  wrdFont[["Color"]] <- currfont[["color"]]

  invisible(currfont)

}


WrdGoto <- function (name, what = wdConst$wdGoToBookmark, wrd = getOption("lastWord")) {
  wrdSel <- wrd[["Selection"]]
  wrdSel$GoTo(what=what, Name=name)
  invisible()
}


WrdInsertBookmark <- function (name, wrd = getOption("lastWord")) {

  #   With ActiveDocument.Bookmarks
  #   .Add Range:=Selection.Range, Name:="entb"
  #   .DefaultSorting = wdSortByName
  #   .ShowHidden = False
  #   End With

  wrdBookmarks <- wrd[["ActiveDocument"]][["Bookmarks"]]
  wrdBookmarks$Add(name)
  invisible()
}


WrdUpdateBookmark <- function (name, text, what = wdConst$wdGoToBookmark, wrd = getOption("lastWord")) {

  #   With ActiveDocument.Bookmarks
  #   .Add Range:=Selection.Range, Name:="entb"
  #   .DefaultSorting = wdSortByName
  #   .ShowHidden = False
  #   End With

  wrdSel <- wrd[["Selection"]]
  wrdSel$GoTo(What=what, Name=name)
  wrdSel[["Text"]] <- text
  # the bookmark will be deleted, how can we avoid that?
  wrdBookmarks <- wrd[["ActiveDocument"]][["Bookmarks"]]
  wrdBookmarks$Add(name)
  invisible()
}



WrdSetFont <- function(fontname = "Consolas", fontsize = 7, bold = FALSE, italic = FALSE, wrd = getOption("lastWord") ) {

  wrdSel <- wrd[["Selection"]]
  wrdFont <- wrdSel[["Font"]]

  currfont <- list(
    name = wrdFont[["Name"]] ,
    size = wrdFont[["Size"]] ,
    bold = wrdFont[["Bold"]] ,
    italic = wrdFont[["Italic"]]
  )

  wrdFont[["Name"]] <- fontname
  wrdFont[["Size"]] <- fontsize

  invisible(currfont)

}


WrdGetFont <- function(wrd = getOption("lastWord") ) {
  # returns the font object list: list(name, size, bold, italic) on the current position

  wrdSel <- wrd[["Selection"]]
  wrdFont <- wrdSel[["Font"]]

  currfont <- list(
    name = wrdFont[["Name"]] ,
    size = wrdFont[["Size"]] ,
    bold = wrdFont[["Bold"]] ,
    italic = wrdFont[["Italic"]]
  )
  return(currfont)
}



WrdR <- function(x,  wrd = getOption("lastWord") ){

  WrdText(paste("> ", x, sep=""), wrd=wrd, fontname="Courier New", fontsize=10, bold=TRUE, italic=TRUE)
  txt <- .CaptOut(eval(parse(text=x)))
  if(sum(nchar(txt))>0) WrdText(txt, wrd=wrd, fontname="Courier New", fontsize=10, bold=TRUE)

  invisible()

}





WrdInsTab <- function(nrow = 1, ncol = 1, heights = NULL, widths = NULL, main = NULL, wrd = getOption("lastWord")){

  .CentimetersToPoints <- function(x) x * 28.35

  res <- wrd[["ActiveDocument"]][["Tables"]]$Add(wrd[["Selection"]][["Range"]],
                                                 NumRows = nrow, NumColumns = ncol)
  if(!is.null(widths)) {
    widths <- rep(widths, length.out=ncol)
    for(i in 1:ncol){
      # set column-widths
      tcol <- res$Columns(i)
      tcol[["Width"]] <- .CentimetersToPoints(widths[i])
    }
  }
  if(!is.null(heights)) {
    heights <- rep(heights, length.out=nrow)
    for(i in 1:nrow){
      # set row heights
      tcol <- res$Rows(i)
      tcol[["Height"]] <- .CentimetersToPoints(heights[i])
    }
  }

  if(!is.null(main)){
    # insert caption
    sel <- wrd$Selection()  # "Abbildung"
    sel$InsertCaption(Label=wdConst$wdCaptionTable, Title=main)
    sel$TypeParagraph()
  }

  invisible(res)
}





###

## Word Table - experimental code

WrdTable <- function(tab, main = NULL, wrd = getOption("lastWord"), row.names = FALSE, ...){
  UseMethod("WrdTable")

}


WrdTable.Freq <- function(tab, main = NULL, wrd = getOption("lastWord"), row.names = FALSE, ...){

  tab[,c(3,5)] <- sapply(round(tab[,c(3,5)], 3), Format, digits=3)
  WrdTable.default(tab=tab, wrd=wrd)

  if(!is.null(main)){
    # insert caption
    sel <- wrd$Selection()  # "Abbildung"
    sel$InsertCaption(Label=wdConst$wdCaptionTable, Title=main)
    sel$TypeParagraph()
  }

  invisible()

}

WrdTable.ftable <- function(tab, main = NULL, wrd = getOption("lastWord"), row.names = FALSE, ...) {
  tab <- FixToTab(capture.output(tab))
  NextMethod()
}


WrdTable.default <- function (tab,  main = NULL, wrd = getOption("lastWord"), row.names=FALSE
                              , fmt = NULL, fontsize = NULL, ...) {


  dim1 <- ncol(tab)
  dim2 <- nrow(tab)
  if(row.names) dim1 <- dim1 + 1

  # wdConst ist ein R-Objekt (Liste mit 2755 Objekten!!!)

  write.table(tab, file = "clipboard", sep = "\t", quote = FALSE, row.names=row.names)

  myRange <- wrd[["Selection"]][["Range"]]
  bm      <- wrd[["ActiveDocument"]][["Bookmarks"]]$Add("PasteHere", myRange)
  myRange$Paste()

  if(row.names) wrd[["Selection"]]$TypeText("\t")

  myRange[["Start"]] <- bm[["Range"]][["Start"]]
  myRange$Select()
  bm$Delete()
  wrd[["Selection"]]$ConvertToTable(Separator       = wdConst$wdSeparateByTabs,
                                    NumColumns      = dim1,
                                    NumRows         = dim2,
                                    AutoFitBehavior = wdConst$wdAutoFitFixed)

  wrdTable <- wrd[["Selection"]][["Tables"]]$Item(1)
  # http://www.thedoctools.com/downloads/DocTools_List_Of_Built-in_Style_English_Danish_German_French.pdf
  wrdTable[["Style"]] <- -115 # "Tabelle Klassisch 1"
  wrdSel <- wrd[["Selection"]]


  if(!is.null(fmt)){  # fmt <- "rl"
    # expects a llrr character vector for alignment
    align <- rep(unlist(strsplit(fmt, "")), length.out=wrdTable[["Columns"]]$count())

    for(i in 1:wrdTable[["Columns"]]$count()){
      wrdTable[["Columns"]]$Item(i)$Select()
      wrd[["Selection"]][["ParagraphFormat"]][["Alignment"]] <-
        if(align[i]=="l") wdConst$wdAlignParagraphLeft
        else if(align[i]=="c") wdConst$wdAlignParagraphCenter
        else if(align[i]=="r") wdConst$wdAlignParagraphRight
      if(!is.null(fontsize))
         wrd[["Selection"]][["Font"]][["Size"]] <- fontsize

    }

  } else {
    wrdSel[["ParagraphFormat"]][["Alignment"]] <- wdConst$wdAlignParagraphLeft
    wrdTable[["Columns"]]$Item(1)$Select()
    wrd[["Selection"]][["ParagraphFormat"]][["Alignment"]] <- wdConst$wdAlignParagraphLeft
  }


#   if(!is.null(fontsize)){
#     wrdTable$Select()
#     wrd[["Selection"]][["Font"]][["Size"]] <- fontsize
#   }

  # Cursor aus der Tabelle auf die letzte Postition im Dokument setzten
  # Selection.GoTo What:=wdGoToPercent, Which:=wdGoToLast
  wrd[["Selection"]]$GoTo(What = wdConst$wdGoToPercent, Which= wdConst$wdGoToLast)

  if(!is.null(main)){
    # insert caption
    sel <- wrd$Selection()  # "Abbildung"
    sel$InsertCaption(Label=wdConst$wdCaptionTable, Title=main)
    sel$TypeParagraph()

  }

  invisible()

}


# WrdTable <- function(tab, wrd){

# ###  http://home.wanadoo.nl/john.hendrickx/statres/other/PasteAsTable.html

# write.table(tab, file="clipboard", sep="\t", quote=FALSE)

# myRange <- wrd[["Selection"]][["Range"]]

# bm <- wrd[["ActiveDocument"]][["Bookmarks"]]$Add("PasteHere", myRange)

# myRange$Paste()
# wrd[["Selection"]]$TypeText("\t")

# myRange[["Start"]] <- bm[["Range"]][["Start"]]
# myRange$Select()

# bm$Delete()

# wrd[["Selection"]]$ConvertToTable(Separator=wdConst$wdSeparateByTabs, NumColumns=4,
# NumRows=9, AutoFitBehavior=wdConst$wdAutoFitFixed)

# wrdTable <- wrd[["Selection"]][["Tables"]]$Item(1)
# wrdTable[["Style"]] <- "Tabelle Klassisch 1"

# wrdSel <- wrd[["Selection"]]
# wrdSel[["ParagraphFormat"]][["Alignment"]] <- wdConst$wdAlignParagraphRight

# #left align the first column
# wrdTable[["Columns"]]$Item(1)$Select()
# wrd[["Selection"]][["ParagraphFormat"]][["Alignment"]] <- wdConst$wdAlignParagraphLeft

# ### wtab[["ApplyStyleHeadingRows"]] <- TRUE
# ### wtab[["ApplyStyleLastRow"]] <- FALSE
# ### wtab[["ApplyStyleFirstColumn"]] <- TRUE
# ### wtab[["ApplyStyleLastColumn"]] <- FALSE
# ### wtab[["ApplyStyleRowBands"]] <- TRUE
# ### wtab[["ApplyStyleColumnBands"]] <- FALSE

# ### With Selection.Tables(1)
# #### If .Style <> "Tabellenraster" Then
# ### .Style = "Tabellenraster"
# ### End If

# ### wrd[["Selection"]]$ConvertToTable( Separator=wdConst$wdSeparateByTabs, AutoFit=TRUE, Format=wdConst$wdTableFormatSimple1,
# ### ApplyBorders=TRUE, ApplyShading=TRUE, ApplyFont=TRUE,
# ### ApplyColor=TRUE, ApplyHeadingRows=TRUE, ApplyLastRow=FALSE,
# ### ApplyFirstColumn=TRUE, ApplyLastColumn=FALSE)

# ###  wrd[["Selection"]][["Tables"]]$Item(1)$Select()
# #wrd[["Selection"]][["ParagraphFormat"]][["Alignment"]] <- wdConst$wdAlignParagraphRight
# ### ### left align the first column
# ### wrd[["Selection"]][["Columns"]]$Item(1)$Select()
# ### wrd[["Selection"]][["ParagraphFormat"]][["Alignment"]] <- wdConst$wdAlignParagraphLeft
# ### wrd[["Selection"]][["ParagraphFormat"]][["Alignment"]] <- wdConst$wdAlignParagraphRight



# }




# require ( xtable )
# data ( tli )
# fm1 <- aov ( tlimth ~ sex + ethnicty + grade + disadvg , data = tli )
# fm1.table <- print ( xtable (fm1), type ="html")

# Tabellen-Studie via HTML FileExport


# WrdInsTable <- function( tab, wrd ){
# htmtab <- print(xtable(tab), type ="html")

# ### Let's create a summary file and insert it
# ### get a tempfile:
# fn <- paste(tempfile(pattern = "file", tmpdir = tempdir()), ".txt", sep="")

# write(htmtab, file=fn)
# wrd[["Selection"]]$InsertFile(fn)
# wrd[["ActiveDocument"]][["Tables"]]$Item(
# wrd[["ActiveDocument"]][["Tables"]][["Count"]] )[["Style"]] <- "Tabelle Klassisch 1"

# }

# WrdInsTable( fm1, wrd=wrd )

# data(d.pizza)
# txt <- Desc( temperature ~ driver, data=d.pizza )
# WrdInsTable( txt, wrd=wrd )

# WrdPlot(PlotDescNumFact( temperature ~ driver, data=d.pizza, newwin=T )
# , wrd=wrd, width=17, crop=c(0,0,60,0))


WrdKill <- function(){
  # Word might not alwasy quit and end the task
  # so killing the task is "ultima ratio"...

  shell('taskkill /F /IM WINWORD.EXE')
}


###

## Excel functions   ====


GetNewXL <- function( visible = TRUE ) {

  if (requireNamespace("RDCOMClient", quietly = FALSE)) {

      # Starts the Excel with xl as handle
    hwnd <- RDCOMClient::COMCreate("Excel.Application")
    if( visible == TRUE ) hwnd[["Visible"]] <- TRUE

    # Create a new workbook
    newwb <- hwnd[["Workbooks"]]$Add

  } else {

    if(Sys.info()["sysname"] == "Windows")
      warning("RDCOMClient is not available. To install it use: install.packages('RDCOMClient', repos = 'http://www.stats.ox.ac.uk/pub/RWin/')")
    else
      warning(gettextf("RDCOMClient is unfortunately not available for %s systems (Windows-only).", Sys.info()["sysname"]))

    hwnd <- NULL
  }

  invisible(hwnd)

}


GetCurrXL <- function() {


#  stopifnot(require(RDCOMClient))
  if (requireNamespace("RDCOMClient", quietly = FALSE)) {

  # try to get a handle to a running XL instance
  # there's no "get"-function in RDCOMClient, so just create a new here..
  hwnd <- RDCOMClient::COMCreate("Excel.Application", existing=TRUE)
  if(is.null(hwnd)) warning("No running Excel application found!")

  options(lastXL = hwnd)

  } else {

    if(Sys.info()["sysname"] == "Windows")
      warning("RDCOMClient is not available. To install it use: install.packages('RDCOMClient', repos = 'http://www.stats.ox.ac.uk/pub/RWin/')")
    else
      warning(gettextf("RDCOMClient is unfortunately not available for %s systems (Windows-only).", Sys.info()["sysname"]))

    hwnd <- NULL
  }

  invisible(hwnd)

}



XLView <- function (x, col.names = TRUE, row.names = TRUE, na = "") {

  # define some XL constants
  xlToRight <- -4161

  fn <- paste(tempfile(pattern = "file", tmpdir = tempdir()),
              ".csv", sep = "")
  xl <- GetNewXL()
  owb <- xl[["Workbooks"]]

  if(!missing(x)){
    write.table(x, file = fn, sep = ";", col.names = col.names,
                qmethod = "double", row.names = row.names, na=na)
    ob <- owb$Open(fn)
    # if row.names are saved there's the first cell in the first line missing
    # I don't actually see, how to correct this besides inserting a cell in XL
    if(row.names) xl$Cells(1, 1)$Insert(Shift=xlToRight)
    xl[["Cells"]][["EntireColumn"]]$AutoFit()

  } else {
    owb$Add()
    awb <- xl[["ActiveWorkbook"]]
    # delete sheets(2,3) without asking, if it's ok
    xl[["DisplayAlerts"]] <- FALSE
    xl$Sheets(c(2,3))$Delete()
    xl[["DisplayAlerts"]] <- TRUE
    awb$SaveAs( Filename=fn, FileFormat=6 )
  }
  invisible(fn)
}



XLGetRange <- function (file = NULL, sheet = NULL, range = NULL, as.data.frame = TRUE,
                        header = FALSE, stringsAsFactors = FALSE) {

  A1ToZ1S1 <- function(x){
    xlcol <- c( LETTERS
                , sort(c(outer(LETTERS, LETTERS, paste, sep="" )))
                , sort(c(outer(LETTERS, c(outer(LETTERS, LETTERS, paste, sep="" )), paste, sep="")))
    )[1:16384]

    z1s1 <- function(x) {
      colnr <- match( regmatches(x, regexec("^[[:alpha:]]+", x)), xlcol)
      rownr <- as.numeric(regmatches(x, regexec("[[:digit:]]+$", x)))
      return(c(rownr, colnr))
    }

    lapply(unlist(strsplit(toupper(x),":")), z1s1)
  }


  # main function  *******************************

  if(is.null(file)){
    xl <- GetCurrXL()
    ws <- xl$ActiveSheet()
    if(is.null(range)) {
      # if there is a selection in XL then use it, if only one cell selected use currentregion
      sel <- xl$Selection()
      if(sel$Cells()$Count() == 1 ){
        range <- xl$ActiveCell()$CurrentRegion()$Address(FALSE, FALSE)
      } else {
        range <- sapply(1:sel$Areas()$Count(), function(i) sel$Areas()[[i]]$Address(FALSE, FALSE) )

        # old: this did not work on some XL versions with more than 28 selected areas
        # range <- xl$Selection()$Address(FALSE, FALSE)
        # range <- unlist(strsplit(range, ";"))
        # there might be more than 1 single region, split by ;
        # (this might be a problem for other locales)
      }
    }
  } else {
    xl <- GetNewXL()
    wb <- xl[["Workbooks"]]$Open(file)
    ws <- wb$Sheets(sheet)$select()
  }

  lst <- list()
  #  for(i in 1:length(range)){  # John Chambers prefers seq_along: (why actually?)
  for(i in seq_along(range)){
    zs <- A1ToZ1S1(range[i])
    rr <- xl$Range(xl$Cells(zs[[1]][1], zs[[1]][2]), xl$Cells(zs[[2]][1], zs[[2]][2]) )
    lst[[i]] <- rr[["Value2"]]
    names(lst)[i] <- range[i]
  }

  # replace NULL values by NAs, as NULLs are evil while coercing to data.frame!
  if(as.data.frame){
    #    for(i in 1:length(lst)){    # original
    for(i in seq_along(lst)){
      #      for(j in 1:length(lst[[i]])){
      for(j in seq_along(lst[[i]])){
        lst[[i]][[j]][unlist(lapply(lst[[i]][[j]], is.null))] <- NA
      }
      xnames <- unlist(lapply(lst[[i]], "[", 1))        # define the names in case header = TRUE
      if(header) lst[[i]] <- lapply(lst[[i]], "[", -1)  # delete the first row
      lst[[i]] <- do.call(data.frame, c(lapply(lst[[i]][], unlist), stringsAsFactors = stringsAsFactors))
      if(header){
        names(lst[[i]]) <- xnames
      } else {
        names(lst[[i]]) <- paste("X", 1:ncol(lst[[i]]), sep="")
      }
    }
  }

  # just return a single object (for instance data.frame) if only one range was supplied
  if(length(lst)==1) lst <- lst[[1]]

  opt <- options(useFancyQuotes=FALSE); on.exit(options(opt))
  attr(lst,"call") <- gettextf("XLGetRange(file = %s, sheet = %s,
     range = c(%s),
     as.data.frame = %s, header = %s, stringsAsFactors = %s)",
     gsub("\\\\", "\\\\\\\\",
        dQuote(paste(xl$ActiveWorkbook()$Path(),
                     xl$ActiveWorkbook()$Name(), sep="\\"))),
     dQuote(xl$ActiveSheet()$Name()),
#     gettextf(paste(dQuote(names(lst)), collapse=",")),
     gettextf(paste(dQuote(range), collapse=",")),
     as.data.frame, header, stringsAsFactors)

  if(!is.null(file)) xl$Quit()  # only quit, if a new XL-instance was created before

  return(lst)
}



XLGetWorkbook <- function (file) {

  xlLastCell <- 11

  xl <- GetNewXL()
  wb <- xl[["Workbooks"]]$Open(file)

  lst <- list()
  for( i in 1:wb[["Sheets"]][["Count"]]){
    ws <- wb[["Sheets", i]]
    ws[["Range", "A1"]][["Select"]]
    rngLast <- xl[["ActiveCell"]][["SpecialCells", xlLastCell]][["Address"]]
    lst[[i]] <- ws[["Range", paste("A1",rngLast, sep=":")]][["Value2"]]
  }

  xl$Quit()
  return(lst)

}


XLKill <- function(){
  # Excel would only quit, when all workbooks are closed before, someone said.
  # http://stackoverflow.com/questions/15697282/excel-application-not-quitting-after-calling-quit

  # We experience, that it Would not even then quit, when there's no workbook loaded at all.
  # so killing the task is "ultima ratio"...

  shell('taskkill /F /IM EXCEL.EXE')
}


XLDateToPOSIXct <- function(x, tz = "GMT"){
  as.POSIXct(x * (60*60*24), origin="1899-12-30", tz=tz)
}


###

## PowerPoint functions ====



GetNewPP <- function (visible = TRUE, template = "Normal") {

  #  stopifnot(require(RDCOMClient))
  if (requireNamespace("RDCOMClient", quietly = FALSE)) {

    hwnd <- RDCOMClient::COMCreate("PowerPoint.Application")
    if (visible == TRUE) { hwnd[["Visible"]] <- TRUE }

    newpres <- hwnd[["Presentations"]]$Add(TRUE)
    ppLayoutBlank <- 12
    newpres[["Slides"]]$Add(1, ppLayoutBlank)
    options("lastPP" = hwnd)

  } else {

    if(Sys.info()["sysname"] == "Windows")
      warning("RDCOMClient is not available. To install it use: install.packages('RDCOMClient', repos = 'http://www.stats.ox.ac.uk/pub/RWin/')")
    else
      warning(gettextf("RDCOMClient is unfortunately not available for %s systems (Windows-only).", Sys.info()["sysname"]))

    hwnd <- NULL

  }

  invisible(hwnd)
}


GetCurrPP <- function() {

  #  stopifnot(require(RDCOMClient))
  if (requireNamespace("RDCOMClient", quietly = FALSE)) {

    # there's no "get"-function in RDCOMClient, so just create a new here..
    hwnd <- RDCOMClient::COMCreate("PowerPoint.Application", existing=TRUE)
    if(is.null(hwnd)) warning("No running PowerPoint application found!")

    options("lastPP" = hwnd)

  } else {

    if(Sys.info()["sysname"] == "Windows")
      warning("RDCOMClient is not available. To install it use: install.packages('RDCOMClient', repos = 'http://www.stats.ox.ac.uk/pub/RWin/')")
    else
      warning(gettextf("RDCOMClient is unfortunately not available for %s systems (Windows-only).", Sys.info()["sysname"]))

    hwnd <- NULL
  }


  invisible(hwnd)

}



PpAddSlide <- function(pos = NULL, pp = getOption("lastPP")){

  slides <- pp[["ActivePresentation"]][["Slides"]]
  if(is.null(pos)) pos <- slides$Count()+1
  slides$AddSlide(pos, slides$Item(1)[["CustomLayout"]])$Select()

  invisible()
}



PpText <- function (txt, x=1, y=1, height=50, width=100, fontname = "Calibri", fontsize = 18, bold = FALSE,
                    italic = FALSE, col = "black", bg = "white", hasFrame = TRUE, pp = getOption("lastPP")) {

  msoShapeRectangle <- 1

  if (class(txt) != "character")
    txt <- .CaptOut(txt)
#  slide <- pp[["ActivePresentation"]][["Slides"]]$Item(1)
  slide <- pp$ActiveWindow()$View()$Slide()
  shape <- slide[["Shapes"]]$AddShape(msoShapeRectangle, x, y, x + width, y+height)
  textbox <- shape[["TextFrame"]]
  textbox[["TextRange"]][["Text"]] <- txt

  tbfont <- textbox[["TextRange"]][["Font"]]
  tbfont[["Name"]] <- fontname
  tbfont[["Size"]] <- fontsize
  tbfont[["Bold"]] <- bold
  tbfont[["Italic"]] <- italic
  tbfont[["Color"]] <- RgbToLong(ColToRgb(col))

  textbox[["MarginBottom"]] <- 10
  textbox[["MarginLeft"]] <- 10
  textbox[["MarginRight"]] <- 10
  textbox[["MarginTop"]] <- 10

  shp <- shape[["Fill"]][["ForeColor"]]
  shp[["RGB"]] <- RgbToLong(ColToRgb(bg))
  shp <- shape[["Line"]]
  shp[["Visible"]] <- hasFrame

  invisible(shape)

}





PpPlot <- function( type="png", crop=c(0,0,0,0),
                     picscale=100, x=1, y=1, height=NA, width=NA, res=200, dfact=1.6, pp = getOption("lastPP") ){

  # height, width in cm!
  # scale will be overidden, if height/width defined

  # Example: PpPlot(picscale=30)
  #          PpPlot(width=8)

  .CentimetersToPoints <- function(x) x * 28.35
  .PointsToCentimeters <- function(x) x / 28.35
  # http://msdn.microsoft.com/en-us/library/bb214076(v=office.12).aspx

  # handle missing height or width values
  if (is.na(width) ){
    if (is.na(height)) {
      width <- 14
      height <- par("pin")[2] / par("pin")[1] * width
    } else {
      width <- par("pin")[1] / par("pin")[2] * height
    }
  } else {
    if (is.na(height) ){
      height <- par("pin")[2] / par("pin")[1] * width
    }
  }


  # get a [type] tempfilename:
  fn <- paste( tempfile(pattern = "file", tmpdir = tempdir()), ".", type, sep="" )
  # this is a problem for RStudio....
  # savePlot( fn, type=type )
  # png(fn, width=width, height=height, units="cm", res=300 )
  dev.copy(eval(parse(text=type)), fn, width=width*dfact, height=height*dfact, res=res, units="cm")
  d <- dev.off()


  # slide <- pp[["ActivePresentation"]][["Slides"]]$Item(1)
  slide <- pp$ActiveWindow()$View()$Slide()
  pic <- slide[["Shapes"]]$AddPicture(fn, FALSE, TRUE, x, y)

  picfrmt <- pic[["PictureFormat"]]
  picfrmt[["CropBottom"]] <- .CentimetersToPoints(crop[1])
  picfrmt[["CropLeft"]] <- .CentimetersToPoints(crop[2])
  picfrmt[["CropTop"]] <- .CentimetersToPoints(crop[3])
  picfrmt[["CropRight"]] <- .CentimetersToPoints(crop[4])

  if( is.na(height) & is.na(width) ){
    # or use the ScaleHeight/ScaleWidth attributes:
    msoTrue <- -1
    msoFalse <- 0
    pic$ScaleHeight(picscale/100, msoTrue)
    pic$ScaleWidth(picscale/100, msoTrue)

  } else {
    # Set new height:
    if( is.na(width) ) width <- height / .PointsToCentimeters( pic[["Height"]] ) * .PointsToCentimeters( pic[["Width"]] )
    if( is.na(height) ) height <- width / .PointsToCentimeters( pic[["Width"]] ) * .PointsToCentimeters( pic[["Height"]] )
    pic[["Height"]] <- .CentimetersToPoints(height)
    pic[["Width"]] <- .CentimetersToPoints(width)
  }

  if( file.exists(fn) ) { file.remove(fn) }

  invisible( pic )

}




###


## Entwicklungs-Ideen ====


# With ActiveDocument.Bookmarks
# .Add Range:=Selection.Range, Name:="start"
# .DefaultSorting = wdSortByName
# .ShowHidden = False
# End With
# Selection.TypeText Text:="Hier kommt mein Text"
# Selection.TypeParagraph
# Selection.TypeText Text:="und auf weiteren Zeilen"
# Selection.TypeParagraph
# With ActiveDocument.Bookmarks
# .Add Range:=Selection.Range, Name:="stop"
# .DefaultSorting = wdSortByName
# .ShowHidden = False
# End With
# Selection.GoTo What:=wdGoToBookmark, Name:="start"
# Selection.GoTo What:=wdGoToBookmark, Name:="stop"
# With ActiveDocument.Bookmarks
# .DefaultSorting = wdSortByName
# .ShowHidden = False
# End With
# Selection.MoveLeft Unit:=wdWord, Count:=2, Extend:=wdExtend
# Selection.HomeKey Unit:=wdStory, Extend:=wdExtend
# Selection.Font.Name = "Arial Black"
# Selection.EndKey Unit:=wdStory
# Selection.GoTo What:=wdGoToBookmark, Name:="stop"
# Selection.Find.ClearFormatting
# With Selection.Find
# .Text = "0."
# .Replacement.Text = " ."
# .Forward = True
# .Wrap = wdFindContinue
# .Format = False
# .MatchCase = False
# .MatchWholeWord = False
# .MatchWildcards = False
# .MatchSoundsLike = False
# .MatchAllWordForms = False
# End With
# ActiveDocument.Bookmarks("start").Delete
# With ActiveDocument.Bookmarks
# .DefaultSorting = wdSortByName
# .ShowHidden = False
# End With
# End Sub
# wdSortByName =0
# wdGoToBookmark = -1
# wdFindContinue = 1
# wdStory = 6



# Bivariate Darstellungen gute uebersicht
# pairs( lapply( lapply( c( d.set[,-1], list()), "as.numeric" ), "jitter" ), col=rgb(0,0,0,0.2) )


# Gruppenweise Mittelwerte fuer den ganzen Recordset
# wrdInsertText( "Mittelwerte zusammengefasst\n\n" )
# wrdInsertSummary(
# signif( cbind(
# t(as.data.frame( lapply( d.frm, tapply, grp, "mean", na.rm=T )))
# , tot=mean(d.frm, na.rm=T)
# ), 3)

