% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CovarianceFunctions.R
\name{CovLP}
\alias{CovLP}
\title{CovLp}
\usage{
CovLP(x, pdim = 2, la = 1, lb = 1)
}
\arguments{
\item{x}{The data as a matrix or data frame. If it is a matrix or data frame, then each row is viewed as one multivariate observation.}

\item{pdim}{The parameter of the weighted \eqn{ {L} ^ {p} dim } depth}

\item{la}{parameter of a simple weight function \eqn{ w = ax + b }}

\item{lb}{parameter of a simple weight function \eqn{ w = ax + b }}
}
\value{
loc: Robust Estimate of Location:

cov: Robust Estimate of Covariance:

Returns depth weighted covariance matrix.
}
\description{
Weighted by \eqn{ L ^ p } depth (outlyingness) multivariate location and scatter estimators.
}
\details{
Using depth function one can define a depth-weighted location and scatter estimators. In case of location estimator we have \deqn{ L(F) = {\int {{x}{{w}_{1}}(D({x}, F))dF({x})}} / {{{w}_{1}}(D({x}, F))dF({x})} } Subsequently, a depth-weighted scatter estimator is defined as \deqn{ S(F) = \frac{ \int {({x} - L(F)){{({x} - L(F))} ^ {T}}{{w}_{2}}(D({x}, F))dF({x})} }{ \int {{{w}_{2}}(D({x}, F))dF({x})}}, } where \eqn{ {{w}_{2}}(\cdot) } is a suitable weight function that can be different from \eqn{ {{w}_{1}}(\cdot) }.

The \pkg{DepthProc} package offers these estimators for weighted \eqn{ {L} ^ {p} } depth. Note that \eqn{ L(\cdot) } and \eqn{ S(\cdot) } include multivariate versions of trimmed means and covariance matrices. Their sample counterparts take the form \deqn{ {{T}_{WD}}({{{X}} ^ {n}}) = {\sum\limits_{i = 1} ^ {n} {{{d}_{i}}{{X}_{i}}}} / {\sum\limits_{i = 1} ^ {n} {{{d}_{i}}}}, } \deqn{ DIS({{{X}}^{n}}) = \frac{ \sum\limits_{i = 1} ^ {n} {{{d}_{i}}\left( {{{X}}_{i}} - {{T}_{WD}}({{{X}} ^ {n}}) \right){{\left( {{{X}}_{i}} - {{T}_{WD}}({{{X}} ^ {n}}) \right)} ^ {T}}} }{ \sum\limits_{i = 1} ^ {n} {{{d}_{i}}}}, } where \eqn{ {{d}_{i}} } are sample depth weights, \eqn{ {{w}_{1}}(x) = {{w}_{2}}(x) = x }.
}
\examples{
# EXAMPLE 1
x <- mvrnorm(n = 100, mu = c(0, 0), Sigma = 3 * diag(2))
cov_x <- CovLP(x, 2, 1, 1)

# EXAMPLE 2
data(under5.mort, inf.mort, maesles.imm)
data1990 <- na.omit(cbind(under5.mort[, 1], inf.mort[, 1], maesles.imm[, 1]))
CovLP(data1990)

}
\seealso{
\code{\link{depthContour}} and \code{\link{depthPersp}} for depth graphics.
}
\author{
Daniel Kosiorowski and Zygmunt Zawadzki from Cracow University of Economics.
}
\keyword{depth}
\keyword{function}
\keyword{multivariate}
\keyword{nonparametric}
\keyword{robust}
