% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetMx.R
\name{GetMx}
\alias{GetMx}
\title{Get matrix of the problem (Mx) function}
\usage{
GetMx(tp, M1)
}
\arguments{
\item{tp}{String. Type of problem. Generated by GetProblemType function.}

\item{M1}{Matrix. Initial matrix without missing categories.}
}
\description{
This function produce 4 new auxiliar matrix. The definition of the matrix depends on the type of problem (tp). For
example, if tp = 2.X, the program will create M2 with dimension 3x3 instead 2x2, and will add  to each cell, this way
we can use this auxiliars macros to solve the problem and avoid issues with solutions in the boundary or not completly defined. See complete
list in Detail section.
}
\details{
-------+------+------------+---------------+------------------+-----------------+
        | Case |      M2    |       M3      |        M4        |        M5       |
 -------+------+------------+---------------+------------------+-----------------+
 Purpose|      | Delta + SE | Delta + SE    | Delta asintotic  | Delta asintotic |
	   |      |            | M1 diagonal or|   Kappa + SE     |      extra      |
        |      |            | frontier sol. |                  |                 |
 -------+------+------------+---------------+------------------+-----------------+
        | 2.0  |  M1* +0.5  |       ---     |     M1 + 0.5     |       M1 + 1    |
 -------+------+------------+---------------+------------------+-----------------+
        | 2.1  |  M1* +0.5  |       ---     |     M1 + 0.5     |       M1 + 1    |
 -------+------+------------+---------------+------------------+-----------------+
        | 2.2  |  M1* +0.5  |       ---     |        M1        |       M1 + 1    |
 -------+------+------------+---------------+------------------+-----------------+
        | 3.0  |   M1 +0.5  |       ---     |     M1 + 0.5     |        ---      |
 -------+------+------------+---------------+------------------+-----------------+
        | 3.1  |     M1     |    M1 + 0.5   |     M1 + 0.5     |        ---      |
 -------+------+------------+---------------+------------------+-----------------+
        | 3.2  |  M1* +0.5  |       ---     |         M1       |        ---      |
 -------+------+------------+---------------+------------------+-----------------+
        | 3.3  |  M1* +0.5  |       ---     |         M1       |        ---      |
 -------+------+------------+---------------+------------------+-----------------+
        | 3.4  |     M1     |    M1 + 0.5   |         M1       |        ---      |
 -------+------+------------+---------------+------------------+-----------------+
        | 3.5  |     M1     |       ---     |         M1       |        ---      |
 -------+------+------------+---------------+------------------+-----------------+
}
\examples{
GetMx("3.2",matrix(c(1,2,0,3,4,0,0,0,1),3,3))
}
\keyword{M1}
\keyword{Mx}
\keyword{tp}
