/*
 * Decompiled with CFR 0.152.
 */
package edu.cens.spatial;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.rosuda.JGR.DataLoader;
import org.rosuda.JGR.RController;
import org.rosuda.JGR.editor.Editor;
import org.rosuda.JGR.toolkit.AboutDialog;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.data.ColumnHeaderListener;
import org.rosuda.deducer.data.DataView;
import org.rosuda.deducer.data.DataViewer;
import org.rosuda.deducer.data.ExDefaultTableModel;
import org.rosuda.deducer.data.ExScrollableTable;
import org.rosuda.deducer.data.ExTable;
import org.rosuda.deducer.data.RDataFrameModel;
import org.rosuda.deducer.toolkit.SaveData;
import org.rosuda.ibase.Common;
import org.rosuda.ibase.toolkit.EzMenuSwing;

public class SpatialDataView
extends DataView
implements ActionListener {
    SpatialDataView(String string) {
        super(string + "@data");
    }

    protected void init(String string) {
        this.dataName = string;
        RDataFrameModel rDataFrameModel = new RDataFrameModel(string){

            public int getRowCount() {
                return this.getRealRowCount();
            }
        };
        this.table = new ExTable((ExDefaultTableModel)rDataFrameModel);
        this.dataScrollPane = new ExScrollableTable(this.table);
        this.dataScrollPane.setRowNamesModel(((RDataFrameModel)this.dataScrollPane.getExTable().getModel()).getRowNamesModel());
        this.dataScrollPane.getExTable().setDefaultRenderer(Object.class, (TableCellRenderer)new RDataFrameModel.RCellRenderer(rDataFrameModel));
        this.dataScrollPane.displayContextualMenu(false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.dataScrollPane);
    }

    public void setData(String string) {
        this.dataName = string + "@data";
        RDataFrameModel rDataFrameModel = new RDataFrameModel(this.dataName){

            public int getRowCount() {
                return this.getRealRowCount();
            }
        };
        ((RDataFrameModel)this.table.getModel()).removeCachedData();
        this.table.setModel((TableModel)rDataFrameModel);
        this.dataScrollPane.setRowNamesModel(((RDataFrameModel)this.dataScrollPane.getExTable().getModel()).getRowNamesModel());
        this.dataScrollPane.getExTable().setDefaultRenderer(Object.class, (TableCellRenderer)new RDataFrameModel.RCellRenderer(rDataFrameModel));
    }

    public JMenuBar generateMenuBar() {
        JFrame jFrame = new JFrame();
        String[] stringArray = new String[]{"+", "File", "@NNew Data", "newdata", "@LOpen Data", "loaddata", "@SSave Data", "Save Data", "-", "-", "@PPrint", "print", "~File.Quit", "+", "Edit", "@CCopy", "copy", "@XCut", "cut", "@VPaste", "paste", "-", "Remove Data from Workspace", "Clear Data", "~Window", "+", "Help", "R Help", "help", "~About", "0"};
        JMenuBar jMenuBar = EzMenuSwing.getEzMenu((JFrame)jFrame, (ActionListener)this, (String[])stringArray);
        if (!Common.isMac()) {
            EzMenuSwing.addMenuSeparator((JFrame)jFrame, (String)"Edit");
            EzMenuSwing.addJMenuItem((JFrame)jFrame, (String)"Help", (String)"About", (String)"about", (ActionListener)this);
            for (int i = 0; i < jMenuBar.getMenuCount(); ++i) {
                if (!jMenuBar.getMenu(i).getText().equals("About")) continue;
                jMenuBar.remove(i);
                --i;
            }
        }
        return jFrame.getJMenuBar();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            String string = actionEvent.getActionCommand();
            if (string == "Open Data") {
                new DataLoader();
            } else if (string == "Save Data") {
                new SaveData(this.dataName);
            } else if (string == "Clear Data") {
                if (this.dataName == null) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Invalid selection: There is no data loaded.");
                    return;
                }
                int n = JOptionPane.showConfirmDialog(null, "Remove Data Frame " + this.dataName + " from enviornment?\n" + "Unsaved changes will be lost.", "Clear Data Frame", 0, 3);
                if (n == 1) {
                    return;
                }
                Deducer.eval((String)("rm(" + this.dataName + ")"));
                RController.refreshObjects();
            } else if (string == "about") {
                new AboutDialog(null);
            } else if (string == "cut") {
                this.table.cutSelection();
            } else if (string == "copy") {
                this.table.copySelection();
            } else if (string == "paste") {
                this.table.pasteSelection();
            } else if (string == "print") {
                try {
                    this.table.print(JTable.PrintMode.NORMAL);
                }
                catch (Exception exception) {}
            } else if (string == "editor") {
                new Editor();
            } else if (string == "exit") {
                ((JFrame)this.getTopLevelAncestor()).dispose();
            } else if (string == "newdata") {
                String string2 = JOptionPane.showInputDialog("Data Name: ");
                if ((string2 = Deducer.getUniqueName((String)string2)) != null) {
                    Deducer.eval((String)(string2.trim() + "<-data.frame(Var1=NA)"));
                    RController.refreshObjects();
                }
            } else if (string == "loaddata") {
                DataLoader dataLoader = new DataLoader();
            } else if (string == "help") {
                Deducer.execute((String)"help.start()");
            } else if (string == "table") {
                DataViewer dataViewer = new DataViewer();
                dataViewer.setLocationRelativeTo(null);
                dataViewer.setVisible(true);
            } else if (string == "save") {
                new SaveData(this.dataName);
            }
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
    }

    public void cleanUp() {
        ((RDataFrameModel)this.table.getModel()).removeCachedData();
    }

    public class DataViewColumnHeaderListener
    extends ColumnHeaderListener {
        private ExTable table;
        private JPopupMenu menu;

        public DataViewColumnHeaderListener(ExTable exTable) {
            this.table = exTable;
            JTableHeader jTableHeader = this.table.getTableHeader();
            jTableHeader.addMouseListener((MouseListener)((Object)this));
        }

        public void remove() {
            this.table.getTableHeader().removeMouseListener((MouseListener)((Object)this));
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            boolean bl = System.getProperty("java.vendor").indexOf("Apple") > -1;
            TableColumnModel tableColumnModel = this.table.getColumnModel();
            int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
            int n2 = this.table.convertColumnIndexToModel(n);
            this.table.selectColumn(n);
            if (mouseEvent.getButton() == 3 && !bl) {
                new ColumnContextMenu(mouseEvent);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            boolean bl;
            boolean bl2 = bl = System.getProperty("java.vendor").indexOf("Apple") > -1;
            if (mouseEvent.isPopupTrigger() && bl) {
                new ColumnContextMenu(mouseEvent);
            }
        }

        class ColumnContextMenu
        implements ActionListener {
            int vColIndex;
            int mColIndex;

            public ColumnContextMenu(MouseEvent mouseEvent) {
                TableColumnModel tableColumnModel = DataViewColumnHeaderListener.this.table.getColumnModel();
                this.vColIndex = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                this.mColIndex = DataViewColumnHeaderListener.this.table.convertColumnIndexToModel(this.vColIndex);
                DataViewColumnHeaderListener.this.menu = new JPopupMenu();
                DataViewColumnHeaderListener.this.table.getTableHeader().add(DataViewColumnHeaderListener.this.menu);
                JMenuItem jMenuItem = new JMenuItem("Sort (Increasing)");
                jMenuItem.addActionListener(this);
                DataViewColumnHeaderListener.this.menu.add(jMenuItem);
                jMenuItem = new JMenuItem("Sort (Decreasing)");
                jMenuItem.addActionListener(this);
                DataViewColumnHeaderListener.this.menu.add(jMenuItem);
                DataViewColumnHeaderListener.this.menu.add(new JSeparator());
                JMenuItem jMenuItem2 = new JMenuItem("Copy");
                jMenuItem2.addActionListener(this);
                DataViewColumnHeaderListener.this.menu.add(jMenuItem2);
                JMenuItem jMenuItem3 = new JMenuItem("Cut");
                jMenuItem3.addActionListener(this);
                DataViewColumnHeaderListener.this.menu.add(jMenuItem3);
                JMenuItem jMenuItem4 = new JMenuItem("Paste");
                jMenuItem4.addActionListener(this);
                DataViewColumnHeaderListener.this.menu.add(jMenuItem4);
                DataViewColumnHeaderListener.this.menu.addSeparator();
                JMenuItem jMenuItem5 = new JMenuItem("Insert");
                jMenuItem5.addActionListener(this);
                DataViewColumnHeaderListener.this.menu.add(jMenuItem5);
                JMenuItem jMenuItem6 = new JMenuItem("Insert New Column");
                jMenuItem6.addActionListener(this);
                DataViewColumnHeaderListener.this.menu.add(jMenuItem6);
                JMenuItem jMenuItem7 = new JMenuItem("Remove Column");
                jMenuItem7.addActionListener(this);
                DataViewColumnHeaderListener.this.menu.add(jMenuItem7);
                DataViewColumnHeaderListener.this.menu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }

            public void actionPerformed(ActionEvent actionEvent) {
                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                if (jMenuItem.getText() == "Copy") {
                    DataViewColumnHeaderListener.this.table.getCopyPasteAdapter().copy();
                } else if (jMenuItem.getText() == "Cut") {
                    DataViewColumnHeaderListener.this.table.cutColumn(this.vColIndex);
                } else if (jMenuItem.getText() == "Paste") {
                    DataViewColumnHeaderListener.this.table.getCopyPasteAdapter().paste();
                } else if (jMenuItem.getText() == "Insert") {
                    DataViewColumnHeaderListener.this.table.insertColumn(this.vColIndex);
                } else if (jMenuItem.getText() == "Insert New Column") {
                    DataViewColumnHeaderListener.this.table.insertNewColumn(this.vColIndex);
                } else if (jMenuItem.getText() == "Remove Column") {
                    DataViewColumnHeaderListener.this.table.removeColumn(this.vColIndex);
                } else if (jMenuItem.getText().equals("Sort (Increasing)")) {
                    String string = SpatialDataView.this.dataName + " <- sort(" + SpatialDataView.this.dataName + ", by=~" + DataViewColumnHeaderListener.this.table.getColumnName(this.vColIndex).trim() + ")";
                    Deducer.eval((String)string);
                    SpatialDataView.this.refresh();
                } else if (jMenuItem.getText().equals("Sort (Decreasing)")) {
                    String string = SpatialDataView.this.dataName + " <- sort(" + SpatialDataView.this.dataName + ", by=~ -" + DataViewColumnHeaderListener.this.table.getColumnName(this.vColIndex).trim() + ")";
                    Deducer.eval((String)string);
                    SpatialDataView.this.refresh();
                }
                DataViewColumnHeaderListener.this.menu.setVisible(false);
            }
        }
    }
}

