/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.plots;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import org.rosuda.JGR.layout.AnchorConstraint;
import org.rosuda.JGR.layout.AnchorLayout;
import org.rosuda.deducer.plots.ElementModel;
import org.rosuda.deducer.plots.ElementView;
import org.rosuda.deducer.plots.Facet;
import org.rosuda.deducer.plots.ParamFacet;
import org.rosuda.deducer.plots.ParamFacetWidget;
import org.rosuda.deducer.widgets.VariableSelectorWidget;

public class FacetPanel
extends ElementView {
    private VariableSelectorWidget variableSelector;
    private ParamFacetWidget facetWidget;
    private Facet model;

    public FacetPanel() {
        this.initGUI();
    }

    private void initGUI() {
        try {
            AnchorLayout anchorLayout = new AnchorLayout();
            this.setLayout((LayoutManager)anchorLayout);
            this.setPreferredSize(new Dimension(413, 422));
            this.variableSelector = new VariableSelectorWidget();
            this.add((Component)this.variableSelector, new AnchorConstraint(53, 398, 972, 30, 1, 1, 1, 1));
            this.variableSelector.setPreferredSize(new Dimension(152, 388));
            this.variableSelector.setCopyMode(true);
            this.facetWidget = new ParamFacetWidget(this.variableSelector, new ParamFacet());
            this.add((Component)this.facetWidget, new AnchorConstraint(150, 972, 850, 427, 1, 1, 0, 1));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public ElementModel getModel() {
        this.updateModel();
        return this.model;
    }

    public void setModel(ElementModel elementModel) {
        this.model = (Facet)elementModel;
        if (this.model.data != null) {
            this.variableSelector.setSelectedData(this.model.data);
        }
        this.facetWidget.setModel(this.model.param);
        this.facetWidget.setType(this.model.facetType);
    }

    public void updateModel() {
        this.model.data = this.variableSelector.getSelectedData();
        this.model.facetType = this.facetWidget.getType();
        this.facetWidget.updateModel();
    }

    public VariableSelectorWidget getVariableSelector() {
        return this.variableSelector;
    }
}

