/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.toolkit;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.rosuda.JGR.layout.AnchorConstraint;
import org.rosuda.JGR.layout.AnchorLayout;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.deducer.toolkit.OkayCancelPanel;
import org.rosuda.deducer.toolkit.VariableSelector;

public class VariableSelectionDialog
extends JDialog
implements ActionListener {
    private VariableSelector selector;
    private OkayCancelPanel okcan;
    private ArrayList selectedVariables = new ArrayList();

    public VariableSelectionDialog(JFrame jFrame) {
        super((Frame)jFrame, true);
        this.initGUI();
    }

    private void initGUI() {
        try {
            AnchorLayout anchorLayout = new AnchorLayout();
            this.getContentPane().setLayout((LayoutManager)anchorLayout);
            this.okcan = new OkayCancelPanel(false, false, this);
            this.getContentPane().add((Component)this.okcan, new AnchorConstraint(858, 892, 983, 128, 1, 1, 1, 1));
            this.okcan.getApproveButton().setText("Select");
            this.selector = new VariableSelector();
            this.getContentPane().add((Component)this.selector, new AnchorConstraint(40, 1002, 836, 2, 1, 1, 1, 1));
            this.selector.setPreferredSize(new Dimension(238, 233));
            this.selector.setBorder(BorderFactory.createTitledBorder("Variables"));
            this.setTitle("Select a Variable");
            this.setSize(300, 600);
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            String string = actionEvent.getActionCommand();
            if (string == "Cancel") {
                this.dispose();
            } else if (string == "Select") {
                Object[] objectArray = this.selector.getJList().getSelectedValues();
                String string2 = (String)this.selector.getJComboBox().getSelectedItem();
                for (int i = 0; i < objectArray.length; ++i) {
                    this.selectedVariables.add(string2 + "$" + objectArray[i]);
                }
                this.dispose();
            }
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
    }

    public void SetSingleSelection(boolean bl) {
        if (bl) {
            this.selector.getJList().setSelectionMode(0);
        } else {
            this.selector.getJList().setSelectionMode(2);
        }
    }

    public void setComboBox(String string) {
        this.selector.getJComboBox().setSelectedItem(string);
    }

    public List getSelectedVariables() {
        return this.selectedVariables;
    }

    public String getSelecteditem() {
        if (this.selectedVariables.size() > 0) {
            return (String)this.selectedVariables.get(0);
        }
        return null;
    }

    public void setRFilter(String string) {
        this.selector.setRFilter(string);
    }
}

