/*
 * Decompiled with CFR 0.152.
 */
package net.starschema.clouddb.jdbc.list;

import java.util.ArrayList;
import java.util.List;
import net.starschema.clouddb.jdbc.Logger;
import net.starschema.clouddb.jdbc.list.ColumnCall;
import net.starschema.clouddb.jdbc.list.Expression;
import net.starschema.clouddb.jdbc.list.FromExpression;
import net.starschema.clouddb.jdbc.list.FunctionCall;
import net.starschema.clouddb.jdbc.list.MultiCall;
import net.starschema.clouddb.jdbc.list.Node;
import net.starschema.clouddb.jdbc.list.Resolver;
import net.starschema.clouddb.jdbc.list.SubQuery;
import net.starschema.clouddb.jdbc.list.TreeBuilder;

public class MultiCallResolver
extends Resolver {
    FromExpression fromExpression;
    MultiCall multiCall;
    Expression parent;
    Logger logger = Logger.getLogger(this.getClass());

    public MultiCallResolver(MultiCall call, FromExpression fromExpression, TreeBuilder builder) {
        super(builder);
        this.fromExpression = fromExpression;
        this.multiCall = call;
    }

    public List<ColumnCall> getSubstitutesforJokerCall() {
        ArrayList<ColumnCall> returnList = new ArrayList<ColumnCall>();
        List<ColumnCall> parseSubQueryForJokerCalls = this.parseSubQForJokers((SubQuery)this.fromExpression.children.get(0));
        for (ColumnCall columnCall : parseSubQueryForJokerCalls) {
            Node pointedNode = columnCall.getPointedNode();
            List<String> synonyms = null;
            if (pointedNode.getTokenType() == 19) {
                synonyms = ((ColumnCall)ColumnCall.class.cast(pointedNode)).getSynonyms();
            } else if (pointedNode.getTokenType() == 53) {
                synonyms = ((FunctionCall)FunctionCall.class.cast(pointedNode)).getSynonyms();
            }
            List<String> scopesTwo = this.multiCall.getScopes();
            String scope = "";
            for (String scopeString : scopesTwo) {
                scope = scope + scopeString + ".";
            }
            boolean found = false;
            for (String synonymString : synonyms) {
                if (!synonymString.startsWith(scope) || synonymString.substring(scope.length()).contains(".")) continue;
                found = true;
            }
            if (!found) continue;
            returnList.add(columnCall);
        }
        return returnList;
    }
}

