/*
 * Decompiled with CFR 0.152.
 */
package net.starschema.clouddb.jdbc;

import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import net.starschema.clouddb.jdbc.Logger;

public class BQSQLException
extends SQLException {
    private static final long serialVersionUID = -3669725541475950504L;
    Logger logger = Logger.getLogger(BQSQLException.class.getName());

    public BQSQLException() {
        StringWriter sw = new StringWriter();
        super.printStackTrace(new PrintWriter(sw));
        String stacktrace = sw.toString();
        this.logger.debug("SQLexception " + stacktrace);
    }

    public BQSQLException(String reason) {
        super(reason);
        StringWriter sw = new StringWriter();
        super.printStackTrace(new PrintWriter(sw));
        String stacktrace = sw.toString();
        this.logger.debug(reason + stacktrace);
    }

    public BQSQLException(String reason, String sqlState) {
        super(reason, sqlState);
        StringWriter sw = new StringWriter();
        super.printStackTrace(new PrintWriter(sw));
        String stacktrace = sw.toString();
        this.logger.debug("SQLexception " + reason + " ;; " + sqlState + " ;; " + stacktrace);
    }

    public BQSQLException(String reason, String sqlState, int vendorCode) {
        super(reason, sqlState, vendorCode);
        StringWriter sw = new StringWriter();
        super.printStackTrace(new PrintWriter(sw));
        String stacktrace = sw.toString();
        this.logger.debug("SQLexception " + reason + " " + sqlState + " " + String.valueOf(vendorCode) + stacktrace);
    }

    public BQSQLException(String reason, String sqlState, int vendorCode, Throwable cause) {
        super(reason, sqlState, vendorCode, cause);
        BQSQLException.enrichReason(reason, cause);
        this.logger.debug("SQLexception " + reason + " " + sqlState + " " + String.valueOf(vendorCode), cause);
    }

    public BQSQLException(String reason, String sqlState, Throwable cause) {
        super(BQSQLException.enrichReason(reason, cause), sqlState, cause);
        this.logger.debug("SQLexception " + reason + " " + sqlState, cause);
    }

    public BQSQLException(String reason, Throwable cause) {
        super(BQSQLException.enrichReason(reason, cause), cause);
        this.logger.debug("SQLexception " + reason, cause);
    }

    public BQSQLException(Throwable cause) {
        super(cause);
        this.logger.debug("SQLexception ", cause);
    }

    private static String enrichReason(String reason, Throwable cause) {
        GoogleJsonResponseException googleJsonResponseException;
        String prefix;
        String string = prefix = reason != null && !reason.isEmpty() ? reason + " - " : "";
        if (cause instanceof GoogleJsonResponseException && (googleJsonResponseException = (GoogleJsonResponseException)cause).getDetails() != null) {
            return prefix + googleJsonResponseException.getDetails().getMessage();
        }
        return reason;
    }
}

