% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build.R
\name{package_build}
\alias{package_build}
\title{Pre-process, document and build a data package}
\usage{
package_build(packageName = NULL, vignettes = FALSE, log = INFO,
  deps = TRUE, install = TRUE)
}
\arguments{
\item{packageName}{\code{character} path to package source directory. Defaults to the current path when NULL.}

\item{vignettes}{\code{logical} specify whether to build vignettes. Default FALSE.}

\item{log}{log level \code{INFO,WARN,DEBUG,FATAL}}

\item{deps}{\code{logical} should we pass data objects into subsequent scripts? Default TRUE}

\item{install}{\code{logical} automatically install and load the package after building. (default TRUE)}
}
\description{
Combines the preprocessing, documentation, and build steps into one.
}
\examples{
if(rmarkdown::pandoc_available()){
f <- tempdir()
f <- file.path(f,"foo.Rmd")
con <- file(f)
writeLines("```{r}\\n tbl = table(sample(1:10,1000,replace=TRUE)) \\n```\\n",con=con)
close(con)
pname <- basename(tempfile())
datapackage_skeleton(name=pname,
   path=tempdir(),
   force = TRUE,
   r_object_names = "tbl",
   code_files = f)

package_build(file.path(tempdir(),pname))
}
}
