% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{class}
\name{databel-class}
\alias{[,databel-method}
\alias{[<-,databel-method}
\alias{backingfilename}
\alias{backingfilename,databel-method}
\alias{cachesizeMb}
\alias{cachesizeMb,databel-method}
\alias{cachesizeMb<-}
\alias{cachesizeMb<-,databel-method}
\alias{connect}
\alias{connect,databel-method}
\alias{databel-class}
\alias{dim,databel-method}
\alias{dimnames,databel-method}
\alias{dimnames<-,databel-method}
\alias{disconnect}
\alias{disconnect,databel-method}
\alias{get_dimnames}
\alias{get_dimnames,databel-method}
\alias{length,databel-method}
\alias{save_as}
\alias{save_as,databel-method}
\alias{setReadOnly<-}
\alias{setReadOnly<-,databel-method}
\alias{set_dimnames<-}
\alias{set_dimnames<-,databel-method}
\alias{show,databel-method}
\title{DatABEL class}
\usage{
\S4method{show}{databel}(object)

\S4method{dim}{databel}(x)

\S4method{length}{databel}(x)

\S4method{dimnames}{databel}(x)

\S4method{dimnames}{databel}(x) <- value

\S4method{[}{databel}(x, i, j, drop)

\S4method{[}{databel}(x, i, j) <- value

get_dimnames(object)

set_dimnames(x) <- value

backingfilename(object)

cachesizeMb(object)

cachesizeMb(x) <- value

save_as(x, rows, cols, file, cachesizeMb = 64, readonly = TRUE)

connect(object, readonly = TRUE)

disconnect(object)

setReadOnly(x) <- value
}
\arguments{
\item{j}{Column index}

\item{file}{Filename to save to}

\item{rows}{Index for the rows}

\item{cols}{Index for the columns}

\item{cachesizeMb}{Amount (in MB) of RAM to use for caching DatABEL
data.}

\item{readonly}{Boolean that specifies whether the file is to be
used in read-only mode or not}

\item{object}{Any R object}

\item{x}{an \R object, for example a matrix, array or data frame.}

\item{value}{For the default method, either \code{NULL} or
    a numeric vector, which is coerced to integer (by truncation).}

\item{i}{
    indices specifying elements to extract or replace.  Indices are
    \code{numeric} or \code{character} vectors or empty (missing) or
    \code{NULL}.  Numeric values are coerced to integer as by
    \code{\link{as.integer}} (and hence truncated towards zero).
    Character vectors will be matched to the \code{\link{names}} of the
    object (or for matrices/arrays, the \code{\link{dimnames}}):
    see \sQuote{Character indices} below for further details.

    For \code{[}-indexing only: \code{i}, \code{j}, \code{\dots} can be
    logical vectors, indicating elements/slices to select.  Such vectors
    are recycled if necessary to match the corresponding extent.
    \code{i}, \code{j}, \code{\dots} can also be negative integers,
    indicating elements/slices to leave out of the selection.

    When indexing arrays by \code{[} a single argument \code{i} can be a
    matrix with as many columns as there are dimensions of \code{x}; the
    result is then a vector with elements corresponding to the sets of
    indices in each row of \code{i}.

    An index value of \code{NULL} is treated as if it were \code{integer(0)}.
  }

\item{drop}{For matrices and arrays.  If \code{TRUE} the result is
    coerced to the lowest possible dimension (see the examples).  This
    only works for extracting elements, not for the replacement.  See
    \code{\link{drop}} for further details.
  }
}
\description{
DatABEL stores matrix-shape data in such a way that it can be
retrieved fast.
}
\section{Slots}{

\describe{
\item{\code{usedRowIndex}}{(\code{"integer"})}

\item{\code{usedColIndex}}{(\code{"integer"})}

\item{\code{uninames}}{(\code{"list"})}

\item{\code{backingfilename}}{Name of the (stem of the) file that contains
the data stored in DatABEL format (\code{"character"})}

\item{\code{cachesizeMb}}{Amount (in MB) of RAM to use for caching DatABEL
data. (\code{"integer"})}

\item{\code{data}}{(\code{"externalptr"})}
}}
\note{
Will extend description here
}
\author{
Yurii Aulchenko
}

