% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Swrappers.R
\name{setColNames.DTSg}
\alias{setColNames.DTSg}
\alias{setColNames}
\alias{setnames}
\title{Set column names}
\usage{
\method{setColNames}{DTSg}(
  x,
  cols = self$cols(class = "numeric")[1L],
  values,
  clone = getOption("DTSgClone"),
  ...
)
}
\arguments{
\item{x}{A \code{\link{DTSg}} object (S3 method only).}

\item{cols}{A character vector specifying the columns whose names shall be
set. The name of the \emph{.dateTime} column cannot be changed.}

\item{values}{A character vector of the same length as \code{cols} specifying the
desired column names.}

\item{clone}{A logical specifying if the object shall be modified in place or
if a deep clone (copy) shall be made beforehand.}

\item{...}{Not used (S3 method only).}
}
\value{
Returns a \code{\link{DTSg}} object.
}
\description{
Changes the column names of \code{\link{DTSg}} objects.
}
\examples{
# new DTSg object
x <- DTSg$new(values = flow)

# rename column "flow" to "River Flow"
## R6 method
x$setColNames(
  cols = "flow",
  values = "River Flow"
)$print()

## S3 method
print(setColNames(
  x = x,
  cols = "flow",
  values = "River Flow"
))

}
\seealso{
\code{\link{cols}}, \code{\link{getOption}}
}
