% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic.functions.R, R/Simulation.R
\docType{methods}
\name{run}
\alias{run}
\alias{run,Simulation-method}
\title{S4 generic method to run a simulation}
\usage{
run(object, run.parallel = FALSE, max.cores = NA, ...)

\S4method{run}{Simulation}(object, run.parallel = FALSE, max.cores = NA,
  save.data = FALSE, load.data = FALSE, data.path = character(0))
}
\arguments{
\item{object}{an object of class Simulation}

\item{run.parallel}{logical option to use multiple processors}

\item{max.cores}{integer maximum number of cores to use, if not specified then
one less than the number available will be used.}

\item{...}{allows the three previous optional arguments to be specified}

\item{save.data}{logical allows the datasets from the simulation to be 
saved to file}

\item{load.data}{logical allows the datasets to be loaded from file rather than
simulated afresh.}

\item{data.path}{character file path to the data files.}
}
\value{
an object of class simulation which now includes the results
}
\description{
Runs the simulation and returns the simulation object with results. If
running in parallel and max.cores is not specified it will default to using
one less than the number of cores / threads on your machine.
}
\seealso{
\code{\link{make.simulation}}
}

