% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/syncSize.R
\name{syncSize}
\alias{syncSize}
\title{Data synchronization}
\usage{
syncSize(data, powercol, timecol = 0, xcol, method = "minimum power")
}
\arguments{
\item{data}{A list of two data sets to be synchronized.}

\item{powercol}{A numeric stating the column number of power production.}

\item{timecol}{A numeric stating the column number of data time stamp. Default value is zero. A value other than zero should be provided when \code{method = 'time'}.}

\item{xcol}{A numeric or vector stating the column number(s) of power curve input covariates/features (to be used for energy decomposition).}

\item{method}{A string specifying data synchronization method. Default value \code{'minimum power'}; other options include \code{'time'} and \code{'random'}.}
}
\value{
a list containing the synchronized datasets.
}
\description{
Data synchronization is meant to make a pair of data to have the same size. It is performed by removing some data points from the larger dataset. This step is important when comparing energy production between two data sets because energy production is time-based.
}
\examples{

data = list(data1[1:200,], data2[1:180, ])
powercol = 7
timecol = 1
xcol = c(2:6)
method = 'random'
sync.dat = syncSize(data, powercol, timecol, xcol, method)

data = list(data1[500:700,], data2[600:750, ])
powercol = 7
timecol = 1
xcol = c(2:6)
method = 'time'
sync.dat = syncSize(data, powercol, timecol, xcol, method)

}
\references{
Latiffianti, E, Ding, Y, Sheng, S, Williams, L, Morshedizadeh, M, Rodgers, M (2022). "Analysis of leading edge protection application on wind turbine performance through energy and power decomposition approaches". Wind Energy. 2022; 1-19. \doi{10.1002/we.2722}.
}
