% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_model.R
\name{run_model}
\alias{run_model}
\title{A function that runs a DSAIRM/DSAIDE app}
\usage{
run_model(modelsettings, modelfunction)
}
\arguments{
\item{modelsettings}{a list with model settings. needs to contain list elements with names and values for all inputs expected by simulation function. Also needs to contain an element plotscale to indicate which axis should be on a log scale (x, y or both), a list element nplots to indicate number of plots that should be produced when calling the generate_plot function with the result, and a list element modeltype which specifies what kind of model should be run. Currently one of (_ode_, _discrete_, _stochastic_, _usanalysis_, _modelexploration_, _fit_ ). Stochastic models also need an nreps list entry to indicate numer of repeat simulations.}

\item{modelfunction}{The name of a simulation function to be run with the indicated settings.}
}
\value{
A vectored list named "result" with each main list element containing the simulation results in a dataframe called dat and associated metadata required for generate_plot and generate_text functions. Most often there is only one main list entry (result[[1]]) for a single plot/text.
}
\description{
This function takes a model and model settings and runs it.
It runs the simulation determined by the model settings and returns simulation results.
}
\details{
This function runs a model for specific settings. It is similar to analyze_model in the modelbuilder package.
}
