% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_idcontrol_ode.R
\name{simulate_idcontrol_ode}
\alias{simulate_idcontrol_ode}
\title{Simulation of a compartmental infectious disease transmission model including different control mechanisms}
\usage{
simulate_idcontrol_ode(
  S = 1000,
  I = 1,
  E = 0,
  Sv = 1000,
  Iv = 0,
  bP = 0,
  bA = 0,
  bI = 0.001,
  bE = 0,
  bv = 0.001,
  bh = 0.001,
  gP = 0.5,
  gA = 0.5,
  gI = 0.5,
  pA = 1,
  pI = 10,
  c = 1,
  f = 0,
  d = 0,
  w = 0,
  mh = 0,
  nh = 0,
  mv = 0,
  nv = 0,
  tmax = 300
)
}
\arguments{
\item{S}{: initial number of susceptible hosts : numeric}

\item{I}{: initial number of infected and symptomatic hosts : numeric}

\item{E}{: initial amount of pathogen in environment : numeric}

\item{Sv}{: initial number of susceptible vectors : numeric}

\item{Iv}{: initial number of infected vectors : numeric}

\item{bP}{: rate of transmission from pre-symptomatic to susceptible hosts : numeric}

\item{bA}{: rate of transmission from asymptomatic to susceptible hosts : numeric}

\item{bI}{: rate of transmission from symptomatic to susceptible hosts : numeric}

\item{bE}{: rate of transmission from environment to susceptible hosts : numeric}

\item{bv}{: rate of transmission from infected vectors to susceptible hosts : numeric}

\item{bh}{: rate of transmission from symptomatic hosts to susceptible vectors : numeric}

\item{gP}{: rate at which a person leaves the P compartment : numeric}

\item{gA}{: rate at which a person leaves the A compartment : numeric}

\item{gI}{: rate at which a person leaves the I compartment : numeric}

\item{pA}{: rate of pathogen shedding into environment by asymptomatic hosts : numeric}

\item{pI}{: rate of pathogen shedding into environment by symptomatic hosts : numeric}

\item{c}{: rate of pathogen decay in environment : numeric}

\item{f}{: fraction of pre-symptomatic individuals that have an asymptomatic infection : numeric}

\item{d}{: fraction of symptomatic infected hosts that die due to disease : numeric}

\item{w}{: rate at which recovered persons lose immunity and return to susceptible state : numeric}

\item{mh}{: the rate at which new hosts enter the model (are born) : numeric}

\item{nh}{: the rate of natural death of hosts (the inverse it the average lifespan) : numeric}

\item{mv}{: the rate at which new vectors enter the model (are born) : numeric}

\item{nv}{: the rate of natural death of vectors (the inverse it the average lifespan) : numeric}

\item{tmax}{: maximum simulation time, in units of months : numeric}
}
\value{
This function returns the simulation result as obtained from a call
  to the deSolve ode solver.
}
\description{
Simulation of a compartmental model with several different compartments:
  Susceptibles (S), Infected and Pre-symptomatic (P),
  Infected and Asymptomatic (A), Infected and Symptomatic (I),
  Recovered and Immune (R) and Dead (D).
  Also modeled is an environmental pathogen stage (E), and susceptible (Sv) and infected (Iv) vectors.

  Any initial conditions not specified below start at 0.
}
\details{
A compartmental ID model with several states/compartments
  is simulated as a set of ordinary differential
  equations. The function returns the output from the odesolver as a matrix,
  with one column per compartment/variable. The first column is time.
}
\section{Warning}{

  This function does not perform any error checking. So if you try to do
  something nonsensical (e.g. have I0 > PopSize or any negative values or fractions > 1),
  the code will likely abort with an error message
}

\examples{
  # To run the simulation with default parameters just call the function:
  result <- simulate_idcontrol_ode()
  # To choose parameter values other than the standard one, specify them like such:
  result <- simulate_idcontrol_ode(S = 2000, I = 10, tmax = 100, f = 0.1, d = 0.2)
  # You should then use the simulation result returned from the function, like this:
  plot(result$ts[ , "time"], result$ts[ , "S"],xlab='Time',ylab='Number Susceptible',type='l')
}
\references{
See e.g. Keeling and Rohani 2008 for SIR models and the
  documentation for the deSolve package for details on ODE solvers
}
\seealso{
The UI of the Shiny app 'IDPatterns', which is part of this package, contains more details on the model.
}
\author{
Andreas Handel
}
