% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Optimaldrugs.R
\name{Optimaldrugs}
\alias{Optimaldrugs}
\title{Identifying the optimal drugs}
\usage{
Optimaldrugs(ExpData,Label,DrugSPESC,CentralityScore,nperm=1000,
                   topcut=10,pcut=0.01,weight=FALSE)
}
\arguments{
\item{ExpData}{A gene expression profile of interest (rows are genes, columns are samples).}

\item{Label}{A character vector consist of "0" and "1" which represent sample class in gene expression profile. "0" means normal sample and "1" means disease sample.}

\item{DrugSPESC}{A matrix with n rows and m columns. n is the number of subpathways and m is the number of all drugs. The values in this matrix is weighted enrichmentscore of subpathways induced by each drug. The users could obtain this matrix from our example data.}

\item{CentralityScore}{The result of function "CalCentralityScore".}

\item{nperm}{Number of random permutations (default: 1000).}

\item{topcut}{The parameter "topcut" represents the number of selected SPs from the top or bottom of the ranked SP list. The topcut defaults to 10.}

\item{pcut}{The parameter "pcut" represents the threshold of statistical significance for screen SPs. The pcut defaults to 0.01.}

\item{weight}{A boolean value determines the method for calculating the drug-disease association score of the drug. "weight=FALSE"(default): Similar to "CMap" (Lamb et al., 2006), no weight is needed. "weight=TRUE": KS random walk statistic with individualized subpathway activity score as weight was used to calculate the drug-disease reverse association score.}
}
\value{
A dataframe with four columns which are "Drug"(drug names),"DES"(drug enrichment score),"p-value"(statistical significance),"FDR"(adjusted statistical significance).
}
\description{
Function "Optimaldrugs" used to identify the optimal drugs for specific disease.
}
\examples{
##Obtain input data
#Weighted enrichmentscore of subpathways induced by each drug were stored
#in package "DRviaSPCNData". "DRviaSPCNData" has been uploaded to the
#github repository.Users can download and install through "install_github"
#function and set parameter url="hanjunwei-lab/DRviaSPCNData".
#After installing and loading package "DRviaSPCNData",
#users can use the following command to get the data.
#DrugSPESCMatrix<-GetData('DrugSPESCMatrix')
CentralityScoreResult<-GetExample("CentralityScoreResult")
GEP<-GetExample("GEP")
Slabel<-GetExample("Slabel")
\donttest{#Run the function
Opdrugresult<-Optimaldrugs(ExpData=GEP,Label=Slabel,DrugSPESC=DrugSPESCMatrix,
CentralityScore=CentralityScoreResult,nperm=1000,topcut=10,pcut=0.01,weight=FALSE)}
}
