% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DPI.R
\name{p_to_bf}
\alias{p_to_bf}
\title{Convert \emph{p} values to approximate (pseudo) Bayes Factors (PseudoBF10).}
\usage{
p_to_bf(p, n, log = FALSE, label = FALSE)
}
\arguments{
\item{p}{\emph{p} value(s).}

\item{n}{Number of observations.}

\item{log}{Return \code{log(BF10)} or raw \code{BF10}. Defaults to \code{FALSE}.}

\item{label}{Add labels (i.e., names) to returned values. Defaults to \code{FALSE}.}
}
\value{
A (named) numeric vector of pseudo Bayes Factors (\eqn{\text{PseudoBF}_{10}}).
}
\description{
Convert \emph{p} values to approximate (pseudo) Bayes Factors (PseudoBF10). This transformation has been suggested by Wagenmakers (2022).
}
\examples{
p_to_bf(0.05, 100)
p_to_bf(c(0.01, 0.05), 100)
p_to_bf(c(0.001, 0.01, 0.05, 0.1), 100, label=TRUE)
p_to_bf(c(0.001, 0.01, 0.05, 0.1), 1000, label=TRUE)

}
\references{
Wagenmakers, E.-J. (2022). \emph{Approximate objective Bayes factors from p-values and sample size: The \eqn{3p\sqrt{n}} rule.} PsyArXiv.
\doi{10.31234/osf.io/egydq}
}
\seealso{
\code{\link[bayestestR:p_to_bf]{bayestestR::p_to_bf()}}
}
