% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DefineClasses.r
\docType{class}
\name{Rec-class}
\alias{Rec-class}
\title{Class \code{'Rec'}}
\description{
An object for storing the MP recommendations
}
\section{Slots}{

\describe{
\item{\code{TAC}}{A numeric value with the TAC recommendation}

\item{\code{Effort}}{A numeric value with the effort recommendation as a fraction of current (nyear) fishing effort}

\item{\code{Spatial}}{A boolean vector of length 'nareas' specifying if area is open (1) or closed (0) to fishing}

\item{\code{Allocate}}{A boolean value describing if effort should be re-allocated from close to open areas}

\item{\code{LR5}}{smallest length at 5 per cent retention - in absolute units - i.e same units as Linf and L50}

\item{\code{LFR}}{smallest length at full retention  - in absolute units - i.e same units as Linf and L50}

\item{\code{HS}}{upper harvest slot (no retention above this)  - in absolute units - i.e same units as Linf and L50}

\item{\code{Rmaxlen}}{retention of the largest size class - fraction between 0 and 1}

\item{\code{L5}}{smallest length at 5 per cent selection - in absolute units - i.e same units as Linf and L50}

\item{\code{LFS}}{smallest length at full selection  - in absolute units - i.e same units as Linf and L50}

\item{\code{Vmaxlen}}{selection of the largest size class - fraction between 0 and 1}

\item{\code{Fdisc}}{fraction of discarded fish that die - fraction between 0 and 1}

\item{\code{DR}}{Discard rate - the fraction of caught fish that are discarded}

\item{\code{Misc}}{An empty list that can be used to store information and pass on to MPs in future}
}}

\section{Objects from the Class}{
 Objects can be created by calls of the form
\code{new('Rec')}
}

\author{
A. Hordyk
}
\keyword{classes}
