% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MPs_Output.R
\name{LstepCC1}
\alias{LstepCC1}
\alias{LstepCC2}
\alias{LstepCC3}
\alias{LstepCC4}
\title{Step-wise Constant Catch}
\usage{
LstepCC1(x, Data, reps = 100, plot = FALSE, yrsmth = 5, xx = 0,
  stepsz = 0.05, llim = c(0.96, 0.98, 1.05))

LstepCC2(x, Data, reps = 100, plot = FALSE, yrsmth = 5, xx = 0.1,
  stepsz = 0.05, llim = c(0.96, 0.98, 1.05))

LstepCC3(x, Data, reps = 100, plot = FALSE, yrsmth = 5, xx = 0.2,
  stepsz = 0.05, llim = c(0.96, 0.98, 1.05))

LstepCC4(x, Data, reps = 100, plot = FALSE, yrsmth = 5, xx = 0.3,
  stepsz = 0.05, llim = c(0.96, 0.98, 1.05))
}
\arguments{
\item{x}{A position in a data-limited methods data object}

\item{Data}{A data-limited methods data object}

\item{reps}{The number of stochastic samples of the MP recommendation(s)}

\item{plot}{Logical. Show the plot?}

\item{yrsmth}{Years over which to calculate mean length.}

\item{xx}{Parameter controlling the fraction of mean catch to start using in
first year}

\item{stepsz}{Parameter controlling the size of update increment in TAC or effort.}

\item{llim}{A vector of length reference points that determine the
conditions for increasing, maintaining or reducing the TAC or effort.}
}
\value{
An object of class \code{\link[=Rec-class]{Rec}} with the \code{TAC} slot populated with a numeric vector of length \code{reps}
}
\description{
A management procedure that incrementally adjusts the TAC according to the
mean length of recent catches.
}
\details{
The TAC is calculated as:
\deqn{\textrm{TAC} = 
             \left\{\begin{array}{ll} 
             \textrm{TAC}^* - 2 S\textrm{TAC}^* & \textrm{if } r < 0.96  \\ 
             \textrm{TAC}^* - S \textrm{TAC}^* & \textrm{if } r < 0.98 \\ 
             \textrm{TAC}^* & \textrm{if } > 1.058 \\
             \end{array}\right.
           }{}
where \eqn{\textrm{TAC}^*} is (1-\code{xx}) times average catch in the first year,
and previous catch in all projection years, \eqn{S} is step-size determined by \code{stepsz},
and \eqn{r} is the ratio of \eqn{L_\textrm{recent}} and \eqn{L_\textrm{ave}}
which are mean length over the most recent \code{yrsmth}  years and 2 x \code{yrsmth} historical
years respectively.

The conditions are specified in the \code{llim} argument to the function.
}
\section{Functions}{
\itemize{
\item \code{LstepCC1}: The least biologically precautionary TAC-based MP.

\item \code{LstepCC2}: More biologically precautionary than \code{LstepCC1} (\code{xx} = 0.1)

\item \code{LstepCC3}: More biologically precautionary than \code{LstepCC2} (\code{xx} = 0.2)

\item \code{LstepCC4}: The most precautionary TAC-based MP.
}}

\section{Required Data}{

See \linkS4class{Data} for information on the \code{Data} object \cr


\code{LstepCC1}: Cat, LHYear, ML, Year


\code{LstepCC2}: Cat, LHYear, ML, Year


\code{LstepCC3}: Cat, LHYear, ML, Year


\code{LstepCC4}: Cat, LHYear, ML, Year
}

\section{Rendered Equations}{

See \href{https://dlmtool.github.io/DLMtool/reference/LstepCC1.html}{Online Documentation} for correctly rendered equations






}

\examples{
LstepCC1(1, Data=DLMtool::SimulatedData, plot=TRUE)

LstepCC2(1, Data=DLMtool::SimulatedData, plot=TRUE)
LstepCC3(1, Data=DLMtool::SimulatedData, plot=TRUE)
LstepCC4(1, Data=DLMtool::SimulatedData, plot=TRUE)
}
\references{
Carruthers et al. 2015. Performance evaluation of simple
management procedures. ICES J. Mar Sci. 73, 464-482.

Geromont, H.F., Butterworth, D.S. 2014. Generic management procedures for
data-poor fisheries; forecasting with few data. ICES J. Mar. Sci.
doi:10.1093/icesjms/fst232
}
\author{
T. Carruthers
}
