% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paste_pct_sum.R
\name{paste_pct_sum}
\alias{paste_pct_sum}
\title{Get the percentage of two values pretty formatted.}
\usage{
paste_pct_sum(
  x,
  pct_ref = 1,
  with_percent_sign = TRUE,
  with_absolute = TRUE,
  decimal_separator = ".",
  digits = 2
)
}
\arguments{
\item{x}{(numeric) The absolute value.}

\item{pct_ref}{(numeric, Optional) The reference value to which the ratio of the
absolute value x is calculated. Default is 1.}

\item{with_percent_sign}{(boolean, Optional) Should a percentage sign be
added to the final string? Default = TRUE}

\item{with_absolute}{(boolean, Optional) Should the two absolute reference
values also be output? Default = TRUE}

\item{decimal_separator}{(string, optional) The character to be used to
indicate the numeric decimal point.}

\item{digits}{(int, optional) The number of digits after the decimal
separator to round to.}
}
\value{
A character string.
}
\description{
Get the percentage of two values pretty formatted.
  Thanks to kapsner for the inspiration!
}
\examples{
  paste_pct_sum(.15, 2)
  #> "7.50\% (0.15 of 2)"
}
