% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DHARMa.R
\name{createDHARMa}
\alias{createDHARMa}
\title{Convert simulated residuals to a DHARMa object}
\usage{
createDHARMa(scaledResiduals = NULL, simulatedResponse = NULL,
  observedResponse = NULL, fittedPredictedResponse = NULL,
  integerResponse = F)
}
\arguments{
\item{scaledResiduals}{optional scaled residuals from a simulation, e.g. Bayesian p-values. If those are not provided, simulated and true observations have to be provided.}

\item{simulatedResponse}{matrix of observations simulated from the fitted model - row index for observations and colum index for simulations}

\item{observedResponse}{true observations}

\item{fittedPredictedResponse}{fitted predicted response. Optional, but will be neccessary for some plots. If scaled residuals are Bayesian p-values, using the median posterior prediction as fittedPredictedResponse is recommended.}

\item{integerResponse}{if T, noise will be added at to the residuals to maintain a uniform expectations for integer responses (such as Poisson or Binomial). Unlike in \code{\link{simulateResiduals}}, the nature of the data is not automatically detected, so this MUST be set by the user appropriately}
}
\description{
Convert simulated residuals to a DHARMa object
}
\details{
The use of this function is to convert simulated residuals (e.g. from a point estimate, or Bayesian p-values) to a DHARMa object, to make use of the plotting / test functions in DHARMa
}
\note{
Either scaled residuals or (simulatedResponse AND observed response) have to be provided
}
