% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input.R
\name{read.LPJ}
\alias{read.LPJ}
\title{Prepare the output table from LPJ-GUESS for visualization}
\usage{
read.LPJ(file = "vegstruct.out", stand.id = 1, patch.id = NULL,
  year = NULL, lon = NULL, lat = NULL, grass = TRUE)
}
\arguments{
\item{file}{the filename to be read}

\item{stand.id}{the stand ID default to 0.}

\item{patch.id}{if a single patch should be used (default all)}

\item{year}{if a single year should be used (default all)}

\item{lon}{if a single longitude should be used (default all). Should be defined, if more than one gridpoint is in the output.}

\item{lat}{as above}

\item{grass}{should grasses be included (so far they are not yet further processed).}
}
\value{
individual vegetation data.frame with equal indivuduals from each cohort.
}
\description{
Stand ID and Patch ID start counting at 0 in the standard output. Here the value of 1 is added, to be consistent with R.
}
\examples{
\dontrun{
dgvm3d.locations = read.table("gridlist.txt",
                              col.names=c("Lon", "Lat", "Name"), sep="\\t",
                              stringsAsFactors=FALSE)
dgvm3d.succession=list()
for (i in 1:nrow(dgvm3d.locations)) {
  dgvm3d.succession[[dgvm3d.locations$Name[i]]] =
   read.LPJ("vegstruct.out",
            lon=dgvm3d.locations$Lon[i],
            lat=dgvm3d.locations$Lat[i])
   dgvm3d.succession[[i]] = dgvm3d.succession[[i]][!(dgvm3d.succession[[i]]$Year \%\% 5) &
                                                   dgvm3d.succession[[i]]$Year > 1859, ]
}
}
}
