% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glm_CMP.R
\name{glm.CMP}
\alias{glm.CMP}
\title{Fit a COM-Poisson Double Generalized Linear Model}
\usage{
glm.CMP(formula.mu, formula.nu, init.beta = NULL, init.delta = NULL,
  data, weights, subset, na.action, maxiter_series = 1000, tol = 0,
  offset, opts = NULL, model.mu = TRUE, model.nu = TRUE, x = FALSE,
  y = TRUE, z = FALSE)
}
\arguments{
\item{formula.mu}{regression formula linked to \code{log(mu)}}

\item{formula.nu}{regression formula linked to \code{log(nu)}}

\item{init.beta}{initial values for regression coefficients of \code{beta}.}

\item{init.delta}{initial values for regression coefficients of \code{delta}.}

\item{data}{an optional data frame, list or environment (or object coercible
by \code{\link[base]{as.data.frame}} to a data frame) containing the
variables in the model. If not found in data, the variables are taken from
\code{environment(formula)}, typically the environment from which
\code{glm.CMP} is called.}

\item{weights}{an optional vector of \sQuote{prior weights} to be used in the
fitting process. Should be \code{NULL} or a numeric vector.}

\item{subset}{an optional vector specifying a subset of observations to be
used in the fitting process.}

\item{na.action}{a function which indicates what should happen when the data
contain \code{NAs}. The default is set by the \code{na.action} setting of
\code{\link[base]{options}}, and is \code{\link[stats]{na.fail}} if that is
unset. The \sQuote{factory-fresh} default is
\code{\link[stats:na.fail]{na.omit}}. Another possible value is
\code{NULL}, no action. Value \code{\link[stats:na.fail]{na.exclude}} can
be useful.}

\item{maxiter_series}{Maximum number of iterations to perform in the
calculation of the normalizing constant.}

\item{tol}{tolerance with default zero meaning to iterate until additional
terms to not change the partial sum in the calculation of the normalizing
constant.}

\item{offset}{this can be used to specify an a priori known component to be
included in the linear predictor during fitting. This should be \code{NULL}
or a numeric vector of length equal to the number of cases. One or more
\code{\link[stats]{offset}} terms can be included in the formula instead or
as well, and if more than one is specified their sum is used. See
\code{\link[stats:model.extract]{model.offset}}.}

\item{opts}{a list with options to the optimizer,
\code{\link[nloptr]{nloptr}}, that fits the model. See, the \code{opts}
parameter of \code{\link[nloptr]{nloptr}} for further details.}

\item{model.mu}{a logical value indicating whether the \emph{mu model frame}
should be included as a component of the returned value.}

\item{model.nu}{a logical value indicating whether the \emph{nu model frame}
should be included as a component of the returned value.}

\item{x}{logical value indicating whether the mu model matrix used in the
fitting process should be returned as a component of the returned value.}

\item{y}{logical value indicating whether the response vector used in the
fitting process should be returned as a component of the returned value.}

\item{z}{logical value indicating whether the nu model matrix used in the
fitting process should be returned as a component of the returned value.}
}
\value{
\code{glm.CMP} returns an object of class \code{"glm_CMP"}. The
  function \code{\link[base]{summary}} can be used to obtain or print a
  summary of the results. An object of class \code{"glm_CMP"} is a list
  containing at least the following components: \item{\code{coefficients}}{a
  named vector of coefficients.} \item{\code{residuals}}{the residuals, that
  is response minus fitted values.} \item{\code{fitted.values}}{the fitted
  mean values.} \item{\code{linear.predictors}}{the linear fit on link
  scale.} \item{\code{call}}{the matched call.} \item{\code{offset}}{the
  offset vector used.} \item{\code{weights}}{the weights initially supplied,
  a vector of \code{1s} if none were.} \item{\code{y}}{if requested (the
  default) the y vector used.} \item{\code{matrix.mu}}{if requested, the mu
  model matrix.} \item{\code{matrix.nu}}{if requested, the nu model matrix.}
  \item{\code{model.mu}}{if requested (the default) the mu model frame.}
  \item{\code{model.nu}}{if requested (the default) the nu model frame.}
}
\description{
The \code{glm.CMP} function is used to fit a COM-Poisson double generalized
linear model with a log-link for the mean (\code{mu}) and the dispersion
parameter (\code{nu}).
}
\details{
Fit a COM-Poisson double generalized linear model using as optimizer the
NLOPT_LD_SLSQP algorithm of function \code{\link[nloptr]{nloptr}}.
}
\examples{
Bids$size.sq <- Bids$size^2
fit <- glm.CMP(formula.mu = numbids ~ leglrest + rearest + finrest +
               whtknght + bidprem + insthold + size + size.sq + regulatn,
               formula.nu = numbids ~ 1, data = Bids)
summary(fit)
}
\references{
Huang, A. (2017). Mean-parametrized Conway–Maxwell–Poisson
regression models for dispersed counts. Statistical Modelling 17, 359--380.

Johnson, S. G. (2018). \href{https://CRAN.R-project.org/package=nloptr}{The
nlopt nonlinear-optimization package}
}
