% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotGOTwoGroups.R
\name{plotGOTwoGroups}
\alias{plotGOTwoGroups}
\title{Plot results from a hypergeometric enrichment test to compare two conditions.}
\usage{
plotGOTwoGroups(dfList1, dfList2, nTerms = 5, minSize = 40,
  maxSize = 1000, labelsCol = "Ontology", adjustPVals = TRUE,
  plotrix_gap = 20, GOTermTypes = c("BP", "CC", "MF"), pValCutoff = 0.05,
  filterSignificant = FALSE, filterSigThresh = 0.05,
  labels = c("Corr Class 1", "GO Term Name", "Corr Class 2"),
  fill_zero_cats = FALSE)
}
\arguments{
\item{dfList1}{A named list of data frames corresponding to different GO term enrichments from the first condition or differential correlation class.}

\item{dfList2}{A named list of data frames corresponding to different GO term enrichments from the second condition or differential correlation class.}

\item{nTerms}{The number of most difference-in-enrichment (i.e., difference adjusted p-value for the difference in log OR) terms to plot from each GO term type.}

\item{minSize}{The number of genes above which a gene set should be removed from analysis (e.g., because it is so small as to be overly specific and untrustworthy).}

\item{maxSize}{The number of genes above which a gene set should be removed from analysis (e.g., because it is so big as to be overly generic and relatively uninteresting).}

\item{labelsCol}{The column specifying the fill labels of the GO terms to be plotted.}

\item{adjustPVals}{Logical, indicating whether or not p-values for the difference in log odds between conditions should be adjusted by the Benjamini-Hochberg method.}

\item{plotrix_gap}{Parameter specifying the size of the gap between the two sides of the ORs.}

\item{GOTermTypes}{Character vector for the GO term types to be plotted.}

\item{pValCutoff}{p-Value cutoff to specify how significant each term enrichment must be in at least one of the groups to be considered for the comparison between the conditions. If no cutoff is desired, set to 1.}

\item{filterSignificant}{Logical, indicating whether or not the p-value for the difference in ORs between groups should be required to be less than a particular threshold prior to downstream analysis.}

\item{filterSigThresh}{Number indicating the threshold of the p-value for the difference in ORs between groups required if filterSignificant is TRUE.}

\item{labels}{Character vector specifying labels for the pyramid plot; first entry = left label, second entry = middle label, third entry = right label.}

\item{fill_zero_cats}{Logical, indicating whether counts of zero in some groups should be included in the comparisons. Adds 0.1 to the ORs and in the denominator of the count for the calculation of the SE in the cases where there are zero counts identified, as a convservative measure to prevent finding infinite differences between groups.}
}
\value{
A data frame with the values used to create the plot.
}
\description{
Uses plotrix to create a pyramid plot of the odds-ratios from enrichment tests of GO terms derived from differentially correlated gene sets (or any gene sets inputted into upstream functions) in two conditions. Note that the first column of each data frame is removed to allow for row binding, and otherwise the column names should match.
}

