% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddplot.R
\name{ddplot}
\alias{ddplot}
\title{Create a heatmap showing the correlations in two conditions.}
\usage{
ddplot(dcObject = NULL, corMatA = NULL, corMatB = NULL, zDiff = NULL,
  flip = TRUE, color_palette = NULL, customize_heatmap = FALSE,
  heatmapClassic = FALSE, corPower = 2, ...)
}
\arguments{
\item{dcObject}{A differential correlation object from which correlation and differential correlation matrices will be extracted. Optional; can also input the correlation matrices and differential correlation matrix individually.}

\item{corMatA}{Optional, correlation matrix from condition A. Will be plotted in the lower left triangle.}

\item{corMatB}{Optional, correlation matrix from condition B. Will be plotted in the upper right triangle.}

\item{zDiff}{Optional, difference measure of correlations between conditions A and B.}

\item{flip}{Switch the ordering of z-differences to be inverse. Default = TRUE}

\item{color_palette}{Colors for plotting the heatmap. If not specified, defaults to a color-blind palette where blue corresponds to a negative correlation and orange/red corresponds to a positive one.}

\item{customize_heatmap}{Option to remove some default options in the heatmap plot, to allow users to add custom options.}

\item{heatmapClassic}{Option to make the heatmap more granular (e.g., not showing the individual gene symbols) and more of a "classic" type of heatmap. Overrides most other heatmap options.}

\item{corPower}{The power to raise the correlations to before plotting the classic heatmap. Larger correlation powers emphasize larger correlation values relatively more compared to smaller correlation values.}

\item{...}{Additional plotting arguments to the heatmap.2 function.}
}
\value{
The sorted difference in z-score matrix in both conditions, which you can use to create your own plot if you'd prefer.
}
\description{
This function orders the differences in correlations between conditions by the median strength of correlation differences for each gene and plots a heatmap of the correlations in each condition (lower = condition A, upper = condition B) using the heatmap.2 function from the gplots package.
}

