% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxplot.R
\name{plot_group_stats}
\alias{plot_group_stats}
\title{Visualize overall data set as a function of a metadata grouping.}
\usage{
plot_group_stats(filename = "group_stats_plot.pdf", id_field, groupBy,
  normalized = TRUE, theme = 1, returnData = FALSE)
}
\arguments{
\item{filename}{Filename for output plot.  Valid extensions are ".pdf" and ".png".
File generation can be turned off using set_output_mode("screen"). Output will be written to the /group_stats/ directory.}

\item{id_field}{The unique ID field for this data set.  Should be the field that corresponds to count column names and target rownames.}

\item{groupBy}{The field by which to group samples in the boxplot. I.E. "time"}

\item{normalized}{Toggles between whether normalized or non-normalized data should be used. Boolean. Default=TRUE.}

\item{theme}{Theme for the layout and color scheme for the plot.  Valid selections are integers between 1-6.}

\item{returnData}{Boolean. Determines if this visualization should return data used to generate the visualization. Default=FALSE.}
}
\value{
If returnData is true, this function will return the long-form table of expression containing
categorical grouping, and sample IDs, log fold-change, and gene name.
}
\description{
This function plots groupwise expression as with regard to a specified target data grouping. This function can be
used to visualize the overall data set according to metadata grouping.  For instance, overall expression at different
timepoints can be viewed, or infected vs control expression levels can be plotted.  This visualization is also
ideal for examining the impact of normalization or filtering.
}
\examples{
\dontrun{

#Plot the overall data set expression levels grouped by time.
plot_group_stats("group_stats_plot.pdf", "SampleID", groupBy="Time",
                   normalized=TRUE, theme=1, returnData=FALSE)

}
}
\keyword{boxplot}
\keyword{distribution}
\keyword{expression}
\keyword{group}
\keyword{normalization}
\keyword{visualization}
