% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DELTD.R
\name{Beta}
\alias{Beta}
\title{Estimate Density Values by Beta kernel}
\usage{
Beta(x = NULL, y, k = NULL, h = NULL)
}
\arguments{
\item{x}{scheme for generating grid points}

\item{y}{a numeric vector of positive values}

\item{k}{number of gird points}

\item{h}{the bandwidth}
}
\value{
\item{x}{grid points}
        \item{y}{estimated values of density}
}
\description{
This function provide the estimated Kernel density values by using Beta Kernel. The Beta kernel is developed by Chen (2000) by using Beta distribution of first kind. He was first to introduce asymetrical kernels to control boundary Bias.
Beta Kernel is
\deqn{K_{Beta( \frac{x}{h}+1, \frac{1-x}{h}+1)}(y)=\frac{y^ \frac{x}{h} (1-y)^{\frac{1-x}{b}}} { B \{ \frac{x}{h}+1, \frac{(1-x)}{h}+1 \}}}
}
\details{
In this function, choice of bandwidth, number of grid points and scheme that how these grid points are generated are user based. If any parameter(s) is missing then function used default parameters.
But at least \code{x} or \code{k} should be specified otherwise \code{NA} will be produced. If \code{x} is missing then function will generate \code{k} grid points by using uniform distribution. Similarly, if
\code{k} is missing then function consider it same to length of main vector. In case if \code{h} is missing then function used normal scale rule bandwidth for non-normal data and described in Silverman (1986). This function can be onlt used if
data is between (0, 1). Similarly, \code{x} should be also lies between (0, 1).
}
\examples{
## Data: Simulated or real data can be used
## Number of grid points "k" should be at least equal to the data size.
## If user defines the generating scheme of grid points then length
## of grid points should be equal or greater than "k", Otherwise NA will be produced.
y <- runif(50)
xx <- sample(0.00001:900, 500, replace = FALSE)/1000
h <- 0.9
Beta(x = xx, y = y, k = 500, h = h)

## If scheme for generating grid points is unknown
y <- runif(500)
h <- 0.9
Beta(x = xx, y = y, k = 500, h = h)

\dontrun{
## If user do not mention the number of grid points
y <- runif(1000)
xx <- seq(0.001, 1000, length = 2000)

## any bandwidth can be used
require(kedd)
h <- h.bcv(y) ## Biased cross validation
Beta(x = xx, y = y, h = h)
}

\dontrun{
##if both generating scheme and number of grid points are missing then function generate NA
y <- runif(1000)
band = 0.8
Beta(y = y, h = band)
}

## if bandwidth is missing
y <- runif(100)
xx <- seq(0.001, 100, length = 300)
Beta(x = xx, y = y, k = 200)

}
\references{
Chen, S. X. 2000. Beta kernel smothers for regression curves. \emph{Statistica Sinica} \strong{10}, 73-91.
Silverman, B. W. 1986. \emph{Density Estimation}. Chapman & Hall/ CRC, London.
}
\seealso{
For further kernels see \code{\link{Erlang}}, \code{\link{BS}}, \code{\link{Gamma}}and \code{\link{LogN}}. To plot its density see \code{\link{plot.Beta}} and to calculate MSE \code{\link{mse}}.
}
\author{
Javaria Ahmad Khan, Atif Akbar.
}
