% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DELTD.R
\name{plot.BS}
\alias{plot.BS}
\title{Density Plot by Birnbaum-Saunders kernel}
\usage{
\method{plot}{BS}(x, ...)
}
\arguments{
\item{x}{An object of class "BS"}

\item{\dots}{Not presently used in this implementation}
}
\value{
Nothing
}
\description{
Plot Kernel density by using Birnbaum-Saunders Kernel.
}
\examples{
y <- rexp(100,1)
h <- 0.79 * IQR(y) * length(y) ^ (-1/5)
den <- BS(y,200,h)
plot(den, type = "s", ylab = "Density Function", lty = 1, xlab = "Time")
## To add true density along with estimated
d1<-density(y,bw=h)
lines(d1,type="p",col="green")
}
\references{
Jin, X.; Kawczak, J. 2003. Birnbaum-Saunders & Lognormal kernel estimators for modeling durations in high frequency financial data. \emph{Annals of Economics and Finance} \strong{4}, 103–124.
}
\seealso{
For further kernels see \code{\link{plot.Erlang}}, \code{\link{plot.Gamma}} and \code{\link{plot.LN}}. For estimated values \code{\link{BS}} and for MSE \code{\link{mseBS}}.
}
\author{
Javaria Ahmad Khan, Atif Akbar.
}
