% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmmclustering.R
\name{size.search}
\alias{size.search}
\title{Size Search Algorithm}
\usage{
size.search(sequences, log_space = FALSE, print = FALSE)
}
\arguments{
\item{sequences}{An \code{stslist} object (see
\code{\link[TraMineR]{seqdef}}) of sequences with discrete observations.}

\item{log_space}{Logical, parameter provided to
\code{\link[seqHMM]{fit_model}} for whether to use optimization in log
space or not.}

\item{print}{Logical, whether to print intermediate steps or not.}
}
\value{
A list with the optimal number of HMM states and the optimal
  \code{hmm} object.
}
\description{
The size search algorithm finds the optimal number of HMM states for a set of
sequences and returns both the optimal \code{hmm} object and the
corresponding number of hidden states. Used in \code{\link{select.seeds}}.
}
\seealso{
Used in the DBHC seed selection procedure in
  \code{\link{select.seeds}}.
}
