\name{DALY-package}

\alias{DALY-package}

\docType{package}

\title{
A GUI for stochastic DALY calculation in R
}

\description{
The \emph{DALY Calculator} is a free, open-source Graphical User Interface (GUI) for stochastic disability-adjusted life year (DALY) calculation, developed in the \R environment for statistical computing.
\cr\cr
The main goal of the \emph{DALY Calculator} is to provide a flexible and easy-to-use tool for DALY calculation, and to promote consistency in the uncertainty analysis of DALYs.
}

\details{
\tabular{ll}{
Package: \tab DALY\cr
Type: \tab Package\cr
Version: \tab 1.0\cr
Date: \tab 2011-03-23\cr
Depends: \tab R (>= 2.12.0), tcltk\cr
License: \tab GPL (>= 2)\cr
URL: \tab http://www.r-project.org, http://studwww.ugent.be/~bdvleess/DALYcalculator\cr
LazyLoad: \tab yes
}
}
\author{
Brecht Devleesschauwer, Arie Havelaar, Juanita Haagsma, Nicolas Praet, Niko Speybroeck

\strong{Maintainer:} Brecht Devleesschauwer <brecht.devleesschauwer@ugent.be>
}

\references{
	\itemize{
		\item{Murray CJL (1994). Quantifying the burden of disease: the technical basis for disability-adjusted life years. \emph{Bulletin of the World Health Organization 72(3),} 429-445.}
		\item{Murray CJL, Acharya AK (1997). Understanding DALYs. \emph{Journal of Health Economics 16(6),} 703-730.}
		\item{Praet N, Speybroeck N, Manzanedo R, Berkvens D, Nforninwe DN, Zoli A, Quet F, Preux P-M, Carabin H, Geerts S (2009). The disease burden of \emph{Taenia solium} cysticercosis in Cameroon. \emph{PLoS Neglected Tropical Diseases 3(3),} e406.}
		\item{Kortbeek LM, Hofhuis A, Nijhuis CDM, Havelaar AH (2009). Congenital toxoplasmosis and DALYs in the Netherlands. \emph{Memorias de Instituto Oswaldo Cruz 104(2),} 370-373.}
	}
}

\seealso{
\code{\link{DALYcalculator}} (for a brief summary)\cr
\code{\link{DALYmanual}} (for a more comprehensive overview)
}