% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_performance.R
\name{model_performance}
\alias{model_performance}
\title{Dataset Level Model Performance Measures}
\usage{
model_performance(explainer, ..., cutoff = 0.5)
}
\arguments{
\item{explainer}{a model to be explained, preprocessed by the \code{\link{explain}} function}

\item{...}{other parameters}

\item{cutoff}{a cutoff for classification models, needed for measures like recall, precision, ACC, F1. By default 0.5.}
}
\value{
An object of the class \code{model_performance}.
}
\description{
Function \code{model_performance()} calculates various performance measures for classification and regression models.
For classification models following measures are calculated: F1, accuracy, recall, precision and AUC.
For regression models following measures are calculated: mean squared error, R squared, median absolute deviation.
}
\examples{
 \dontrun{
library("ranger")
titanic_ranger_model <- ranger(survived~., data = titanic_imputed, num.trees = 100,
                               probability = TRUE)
# It's a good practice to pass data without target variable
explainer_ranger  <- explain(titanic_ranger_model, data = titanic_imputed[,-8],
                             y = titanic_imputed$survived)
# resulting dataframe has predicted values and residuals
mp_ex_rn <- model_performance(explainer_ranger)

titanic_glm_model <- glm(survived~., data = titanic_imputed, family = "binomial")
explainer_glm <- explain(titanic_glm_model, data = titanic_imputed[,-8],
                         y = titanic_imputed$survived,
                    predict_function = function(m,x) predict.glm(m,x,type = "response"),
                         label = "glm")
mp_ex_glm <- model_performance(explainer_glm)
mp_ex_glm
plot(mp_ex_glm)
plot(mp_ex_glm, mp_ex_rn)

titanic_lm_model <- lm(survived~., data = titanic_imputed)
explainer_lm <- explain(titanic_lm_model, data = titanic_imputed[,-8], y = titanic_imputed$survived)
mp_ex_lm <- model_performance(explainer_lm)
plot(mp_ex_lm)
plot(mp_ex_glm, mp_ex_rn, mp_ex_lm)
 }

}
\references{
Explanatory Model Analysis. Explore, Explain and Examine Predictive Models. \url{https://pbiecek.github.io/ema/}
}
