% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAISIE_plot_params.R
\name{DAISIE_plot_immigration}
\alias{DAISIE_plot_immigration}
\title{Plot immigration rate through time}
\usage{
DAISIE_plot_immigration(
  total_time,
  K,
  area_pars,
  gam,
  peak,
  mainland_n,
  hyper_pars = NULL,
  island_ontogeny = "beta",
  sea_level = "const",
  removed_timepoints,
  resolution
)
}
\arguments{
\item{total_time}{Numeric defining the length of the simulation in time
units.}

\item{K}{A numeric with carrying capacity.}

\item{area_pars}{A named list containing area and sea level parameters as
created by \code{\link{create_area_pars}()}:
\itemize{
  \item{[1]: maximum area}
  \item{[2]: current area}
  \item{[3]: value from 0 to 1 indicating where in the island's history the
  peak area is achieved}
  \item{[4]: total island age}
  \item{[5]: amplitude of area fluctuation from sea level}
  \item{[6]: frequency of sine wave of area change from sea level}
  \item{[7]: angle of the slope of the island}
}}

\item{gam}{A numeric with the per capita immigration rate.}

\item{peak}{A numeric value specifying the peakiness (or shaprness) of the
ontogeny curve. Higher values imply peakier ontogeny. This value is
internally calculated by \code{\link{calc_peak}()} given the area at the
present and the \code{area_pars}.}

\item{mainland_n}{A numeric stating the number of mainland species, that
is the number of species that can potentially colonize the island.
If using a clade-specific diversity dependence, this value is set to 1.
If using an island-wide diversity dependence, this value is set to the
number of mainland species.}

\item{hyper_pars}{A named list of numeric hyperparameters for the rate
calculations as returned by \code{\link{create_hyper_pars}()}:
\itemize{
  \item{[1]: is d the scaling parameter for exponent for calculating
  cladogenesis rate}
  \item{[2]: is x the exponent for calculating extinction rate}
}}

\item{island_ontogeny}{In \code{\link{DAISIE_sim_time_dep}()},
\code{\link{DAISIE_ML_CS}} and plotting a string describing the type of
island ontogeny. Can be \code{"const"}, \code{"beta"} for a beta function
describing area through time. String checked by
\code{\link{is_island_ontogeny_input}()}. \cr In all other functions a
numeric describing the type of island ontogeny. Can be \code{0} for
constant, \code{1} for a beta function describing area through time. In ML
functions \code{island_ontogeny = NA} assumes constant ontogeny. Time
dependent estimation is not yet available as development is still ongoing.
Will return an error if called in that case.}

\item{sea_level}{In \code{\link{DAISIE_sim_time_dep}()} and plotting a
string describing the type of sea level. Can be \code{"const"} or
\code{"sine"} for a sine function describing area through time. String
checked by \code{\link{is_sea_level_input}()}.
\cr In all other functions a numeric describing the type of sea level. Can
be \code{0} for constant, \code{1} for a sine function describing area
through time.}

\item{removed_timepoints}{Positive integer with number of first datapoints
to be removed from rate plots (to prevent Inf)}

\item{resolution}{numeric indicating resolution of plot. Should be < 0.}
}
\value{
a plot with per capita immigration rate through time and dataframe with immigration
at corresponding time
}
\description{
Plot immigration rate through time
}
\author{
Pedro Neves
}
\keyword{internal}
