% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prediction.PredictionOutput.R
\name{PredictionOutput}
\alias{PredictionOutput}
\title{Encapsulates the achieved predictions.}
\description{
The class used to encapsulates all the computed predictions to
facilitate their access and maintenance.
}
\seealso{
\code{\link{D2MCS}}
}
\keyword{math}
\keyword{misc}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PredictionOutput-new}{\code{PredictionOutput$new()}}
\item \href{#method-PredictionOutput-getPredictions}{\code{PredictionOutput$getPredictions()}}
\item \href{#method-PredictionOutput-getType}{\code{PredictionOutput$getType()}}
\item \href{#method-PredictionOutput-getTarget}{\code{PredictionOutput$getTarget()}}
\item \href{#method-PredictionOutput-clone}{\code{PredictionOutput$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PredictionOutput-new"></a>}}
\if{latex}{\out{\hypertarget{method-PredictionOutput-new}{}}}
\subsection{Method \code{new()}}{
Method for initializing the object arguments during runtime.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PredictionOutput$new(predictions, type, target)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{predictions}}{A \link{list} of \code{\link{FinalPred}}
elements.}

\item{\code{type}}{A \link{character} to define which type of predictions
should be returned. If not defined all type of probabilities will be
returned. Conversely if "prob" or "raw" is defined then computed
'probabilistic' or 'class' values are returned.}

\item{\code{target}}{A \link{character} defining the value of the
positive class.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PredictionOutput-getPredictions"></a>}}
\if{latex}{\out{\hypertarget{method-PredictionOutput-getPredictions}{}}}
\subsection{Method \code{getPredictions()}}{
The function returns the final predictions.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PredictionOutput$getPredictions()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \link{list} containing the final predictions or \link{NULL} if
classification stage was not successfully performed.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PredictionOutput-getType"></a>}}
\if{latex}{\out{\hypertarget{method-PredictionOutput-getType}{}}}
\subsection{Method \code{getType()}}{
The function returns the type of prediction should be
returned. If "prob" or "raw" is defined then computed 'probabilistic' or
'class' values are returned.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PredictionOutput$getType()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \link{character} value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PredictionOutput-getTarget"></a>}}
\if{latex}{\out{\hypertarget{method-PredictionOutput-getTarget}{}}}
\subsection{Method \code{getTarget()}}{
The function returns the value of the target class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PredictionOutput$getTarget()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \link{character} value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PredictionOutput-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PredictionOutput-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PredictionOutput$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
