% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prediction.MinimizeFP.R
\name{MinimizeFP}
\alias{MinimizeFP}
\title{Combined metric strategy to minimize FP errors.}
\description{
Calculates if the positive class is the predicted one in all
metrics, otherwise, the instance is not considered to have the positive
class associated.
}
\seealso{
\code{\link{CombinedMetrics}}
}
\keyword{classif}
\keyword{math}
\section{Super class}{
\code{\link[D2MCS:CombinedMetrics]{D2MCS::CombinedMetrics}} -> \code{MinimizeFP}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{MinimizeFP$new()}}
\item \href{#method-getFinalPrediction}{\code{MinimizeFP$getFinalPrediction()}}
\item \href{#method-clone}{\code{MinimizeFP$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="D2MCS" data-topic="CombinedMetrics" data-id="getRequiredMetrics">}\href{../../D2MCS/html/CombinedMetrics.html#method-getRequiredMetrics}{\code{D2MCS::CombinedMetrics$getRequiredMetrics()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Method for initializing the object arguments during runtime.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MinimizeFP$new(required.metrics = c("MCC", "PPV"))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{required.metrics}}{A \link{character} vector of length greater than
2 with the name of the required metrics.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getFinalPrediction"></a>}}
\if{latex}{\out{\hypertarget{method-getFinalPrediction}{}}}
\subsection{Method \code{getFinalPrediction()}}{
Function to obtain the final prediction based on different
metrics.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MinimizeFP$getFinalPrediction(
  raw.pred,
  prob.pred,
  positive.class,
  negative.class
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{raw.pred}}{A \link{character} list of length greater than 2 with the
class value of the predictions made by the metrics.}

\item{\code{prob.pred}}{A \link{numeric} list of length greater than 2 with the
probability of the predictions made by the metrics.}

\item{\code{positive.class}}{A \link{character} with the value of the positive
class.}

\item{\code{negative.class}}{A \link{character} with the value of the negative
class.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \link{logical} value indicating if the instance is predicted as
positive class or not.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MinimizeFP$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
