% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findcutpoints.R
\name{findcutpoints}
\alias{findcutpoints}
\title{Find two optimal cutpoints using optimal equal-HR method}
\usage{
findcutpoints(cox_pspline_fit, data, nquantile = 100, exclude = 0.05,
  eps = 0.01, shape = "U")
}
\arguments{
\item{cox_pspline_fit}{Cox model with psplined x, e.g. coxph(Surv(t,d)~pspline(x,df=0,caic=T),data=test).}

\item{data}{a dataframe contain survival outcome and a continuous variable which needs to find two optimal cutpoints.}

\item{nquantile}{an integer; the default value is 100, which means using the 100-quantiles of log relative hazard to find cutpoints.}

\item{exclude}{a decimals; it is used for excluding extreme values of log relative hazardthe. The default value is 0.05, which log relative hazard values smaller than 5th percentile or larger than 95th percentile are excluded.}

\item{eps}{a decimals; the default value is 0,01. It restrict the difference between the log relative hazard values of two cadidate cutpoints to be less than 0.01.}

\item{shape}{a string; equals "U" or "inverseU"}
}
\description{
Use optimal equal-HR method to determine two optimal cutpoints of a continuous predictor that has a U-shape relationship with survival outcomes based on Cox regression model.
}
\details{
A function to find two optimal cutpoints
}
\examples{

\donttest{
#### Example 1. Find two optimal cutpoints in an univariate Cox model
# Fit an univariate Cox model with pspline
require(survival)
result <- coxph(Surv(t,d)~pspline(x,df=0,caic=TRUE),data=test)
# Visualize the relationship
# Explore whether there is a U-shaped relationship between x and log relative hazard
termplot(result,se=TRUE,col.term=1,ylab='log relative hazard')
# Find two opitmal cutpoints using optimal equal-HR method.
cuts <- findcutpoints(cox_pspline_fit = result, data = test, shape='U')
cuts$optimal # output two optimal cutpoints

#### Example 2. Find two optimal cutpoints in a multivariate Cox model
# Fit a multivariate Cox model with pspline
# The independent variable which is need to find cutpoints should be placed before other covariates.
# To find cutpoints of x, Surv(t,d)~pspline(x)+x1 should be used instead of Surv(t,d)~x1+pspline(x)
require(survival)
result <- coxph(Surv(t,d)~pspline(x,df=0,caic=TRUE)+x1,data=test)
# The rest procedure is the same as example 1
# Visualize the relationship
# Explore whether there is a U-shaped relationship between x and log relative hazard
termplot(result,se=TRUE,col.term=1,ylab='log relative hazard')
# Find two opitmal cutpoints of the first independent variable.
cuts <- findcutpoints(cox_pspline_fit = result, data = test, shape='U')
cuts$optimal # output two optimal cutpoints
}
}
