% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Coxmos_plot_functions.R
\name{plot_pseudobeta_newObservation.list}
\alias{plot_pseudobeta_newObservation.list}
\title{plot_pseudobeta_newObservation.list}
\usage{
plot_pseudobeta_newObservation.list(
  lst_models,
  new_observation,
  error.bar = TRUE,
  onlySig = TRUE,
  alpha = 0.05,
  zero.rm = TRUE,
  top = NULL,
  auto.limits = TRUE,
  show.betas = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{lst_models}{List of Coxmos models.}

\item{new_observation}{Numeric matrix or data.frame. New explanatory variables (raw data) for one
observation. Qualitative variables must be transform into binary variables.}

\item{error.bar}{Logical. Show error bar (default: TRUE).}

\item{onlySig}{Logical. Compute pseudobetas using only significant components (default: TRUE).}

\item{alpha}{Numeric. Numerical values are regarded as significant if they fall below the
threshold (default: 0.05).}

\item{zero.rm}{Logical. Remove variables with a pseudobeta equal to 0 (default: TRUE).}

\item{top}{Numeric. Show "top" first variables with the higher pseudobetas in absolute value. If
top = NULL, all variables are shown (default: NULL).}

\item{auto.limits}{Logical. If "auto.limits" = TRUE, limits are detected automatically (default: TRUE).}

\item{show.betas}{Logical. Show original betas (default: FALSE).}

\item{verbose}{Logical. If verbose = TRUE, extra messages could be displayed (default: FALSE).}
}
\value{
A list of lst_models length with a list of four elements per each model:
\code{plot}: Linear prediction per variable.
\code{lp.var}: Value of each linear prediction per variable.
\code{norm_observation}: Observation normalized using the model information.
\code{observation}: Observation used.
}
\description{
Run the function "plot_pseudobeta_newObservation" for a list of models. More information
in "?plot_pseudobeta_newObservation".
}
\examples{
data("X_proteomic")
data("Y_proteomic")
set.seed(123)
index_train <- caret::createDataPartition(Y_proteomic$event, p = .5, list = FALSE, times = 1)
X_train <- X_proteomic[index_train,1:50]
Y_train <- Y_proteomic[index_train,]
X_test <- X_proteomic[-index_train,1:50]
Y_test <- Y_proteomic[-index_train,]
splsicox.model <- splsicox(X_train, Y_train, n.comp = 2, penalty = 0.5, x.center = TRUE,
x.scale = TRUE)
splsdrcox.model <- splsdrcox_penalty(X_train, Y_train, n.comp = 2, penalty = 0.5, x.center = TRUE,
x.scale = TRUE)
lst_models = list("sPLSICOX" = splsicox.model, "sPLSDRCOX" = splsdrcox.model)
plot_pseudobeta_newObservation.list(lst_models, new_observation = X_test[1,,drop=FALSE])
}
\author{
Pedro Salguero Garcia. Maintainer: pedsalga@upv.edu.es
}
