% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Coxmos_plot_functions.R
\name{plot_pseudobeta}
\alias{plot_pseudobeta}
\title{plot_pseudobeta}
\usage{
plot_pseudobeta(
  model,
  error.bar = TRUE,
  onlySig = FALSE,
  alpha = 0.05,
  zero.rm = TRUE,
  top = NULL,
  auto.limits = TRUE,
  show_percentage = TRUE,
  size_percentage = 3,
  title_size_text = 15,
  legend_size_text = 12,
  x_axis_size_text = 10,
  y_axis_size_text = 10,
  label_x_axis_size = 10,
  label_y_axis_size = 10
)
}
\arguments{
\item{model}{Coxmos model.}

\item{error.bar}{Logical. Show error bar (default: TRUE).}

\item{onlySig}{Logical. Compute pseudobetas using only significant components (default: FALSE).}

\item{alpha}{Numeric. Numerical values are regarded as significant if they fall below the threshold
(default: 0.05).}

\item{zero.rm}{Logical. Remove variables with a pseudobeta equal to 0 (default: TRUE).}

\item{top}{Numeric. Show "top" first variables with the higher pseudobetas in absolute value. If
top = NULL, all variables are shown (default: NULL).}

\item{auto.limits}{Logical. If "auto.limits" = TRUE, limits are detected automatically (default: TRUE).}

\item{show_percentage}{Logical. If show_percentage = TRUE, it shows the contribution percentage
for each variable to the full model (default: TRUE).}

\item{size_percentage}{Numeric. Size of percentage text (default: 3).}

\item{title_size_text}{Numeric. Text size for legend title (default: 15).}

\item{legend_size_text}{Numeric. Text size for legend title (default: 12).}

\item{x_axis_size_text}{Numeric. Text size for x axis (default: 10).}

\item{y_axis_size_text}{Numeric. Text size for y axis (default: 10).}

\item{label_x_axis_size}{Numeric. Text size for x label axis (default: 10).}

\item{label_y_axis_size}{Numeric. Text size for y label axis (default: 10).}
}
\value{
A list containing the following elements:
\code{plot}: Depending on the model type, this can either be a single ggplot object visualizing the pseudo-beta coefficients for the original variables in a single block PLS-Cox model, or a list of ggplot objects for each block in a multiblock PLS-Cox model. Each plot provides a comprehensive visualization of the pseudo-beta coefficients, potentially including error bars, significance filtering, and variable contribution percentages.
\code{beta}: A matrix or list of matrices (for multiblock models) containing the computed pseudo-beta coefficients for the original variables. These coefficients represent the influence of each original variable on the survival prediction.
\code{sd.min}: A matrix or list of matrices (for multiblock models) representing the lower bounds of the error bars for the pseudo-beta coefficients.
\code{sd.max}: A matrix or list of matrices (for multiblock models) representing the upper bounds of the error bars for the pseudo-beta coefficients.
}
\description{
This function decomposes a PLS-Cox model, translating it into a pseudo-beta
interpretation with respect to the original variables. The decomposition is based on the
relationship between the Cox coefficients associated with each component and the weights
corresponding to the original variables. The final Cox formula is thus expressed in terms of
these original variables.
}
\details{
The \code{plot_pseudobeta} function offers a comprehensive visualization and interpretation
of a PLS-Cox model in terms of the original variables. The function begins by validating the model's
class and type. For single block models, the function computes the pseudo-betas by multiplying
the loading weights (\code{W.star}) with the Cox coefficients. For multiblock models, this computation
is performed for each block separately.

The function provides flexibility in terms of visualization. Users can opt to display error bars,
filter out non-significant components based on a significance threshold (\code{alpha}), and remove
variables with a pseudo-beta of zero. Additionally, the function allows for automatic limit
detection for the plot and displays the contribution percentage of each variable to the full model.
The resulting plot can be customized further with various text size parameters for different plot
elements.

It's worth noting that the function supports both single block and multiblock PLS-Cox models. For
multiblock models, the function returns a list of plots, one for each block, whereas for single
block models, a single plot is returned.
}
\examples{
data("X_proteomic")
data("Y_proteomic")
X <- X_proteomic[,1:50]
Y <- Y_proteomic
splsicox.model <- splsicox(X, Y, n.comp = 2, penalty = 0.5, x.center = TRUE, x.scale = TRUE)
plot_pseudobeta(model = splsicox.model)
}
\author{
Pedro Salguero Garcia. Maintainer: pedsalga@upv.edu.es
}
