% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_test_stat_t.R
\name{find_test_stat_t}
\alias{find_test_stat_t}
\title{Finds t statistic (observed test statistic) for data set}
\usage{
find_test_stat_t(sample_data, variable)
}
\arguments{
\item{sample_data}{Sample data set. Data should have column indicating
exposure (1) or non exposure (0) for each group (row) that is measured. Each
measured outcome (variable) should be represented by an additional column.}

\item{variable}{Variable measured
Format: sample_data$column}
}
\value{
Observed Test Statistic (Numeric)
}
\description{
Finds t statistic between experimental
(exposed) and control (non exposed) group for measured outcome in dataset
}
\examples{
find_test_stat_t(sample_district_1DS,
sample_district_1DS$charge_prosecuted_1000_rate_post -
sample_district_1DS$charge_prosecuted_1000_rate_pre)

find_test_stat_t(sample_district_1D,
sample_district_1D$charge_prosecuted_1000_rate_post -
sample_district_1D$charge_prosecuted_1000_rate_pre)
}
