\name{CorporaCoCo-package}
\alias{CorporaCoCo-package}
\alias{CorporaCoCo}
\docType{package}

\title{Comparing Co-occurrence between corpora.}
\description{
  The package implements the method introduced in Wiegand and Hennessey et al. 
  (2017a). It identifies significant difference in co-occurrence counts for
  a given node or set of nodes across two corpora, using a Fisher’s Exact test.
}
\details{
  A good place to start is the
  \sQuote{\href{../doc/intro.html}{Introduction to CorporaCoCo}} vignette.
  You can open the vignette with
  \code{vignette("intro", package = "CorporaCoCo")}.

  For a list of all documentation use \code{library(help="CorporaCoCo")}.
  For updates on development versions of the package and documentation, 
  please see the \href{https://github.com/mahlberg-lab/CorporaCoCo}{GitHub page}.
}

\author{
  Maintainer: Mahlberg - Lab  <mahlberg.lab@gmail.com>.
}

\references{
  * Wiegand, V., Hennessey, A., Tench, C. R., & Mahlberg, M. (2017a, May 24). 
    \emph{Comparing co-occurrences between corpora}. 38th ICAME conference,
    Charles University, Prague.

  *	Wiegand, V., Hennessey, A., Tench, C. R., & Mahlberg, M. (2017b, July 24). 
    \emph{A cookbook of co-occurrence comparison techniques and how they relate
    to the subtleties in your research question}. 9th International Corpus 
    Linguistics Conference, University of Birmingham, Birmingham.

  Examples of how the method has been used can be found in:

  * Mahlberg, M., Wiegand, V., & Hennessey, A. (2020). Eye language – body part 
    collocations and textual contexts in the nineteenth-century novel. In L. 
    Fesenmeier & I. Novakova (Eds.), \emph{Phraseology and Stylistics of Literary
    Language/Phraséologie et Stylistique de la Langue Littéraire} (pp. 143–176). 
    Peter Lang.
    \url{https://www.academia.edu/45152494/Eye_language_body_part_collocations_and_textual_contexts_in_the_nineteenth_century_novel}

  * Wiegand, V. (2019). \emph{A Corpus Linguistic Approach to Meaning-Making
    Patterns in Surveillance Discourse} [PhD, University of Birmingham]. 
    \url{https://etheses.bham.ac.uk/id/eprint/9778}
}
