% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mosaicPlot.R
\name{mosaicPlot}
\alias{mosaicPlot}
\title{Mosaic Plot}
\usage{
mosaicPlot(
  dataset = cs.in.dataset(),
  preds = cs.in.predictors(),
  resps = cs.in.responses(),
  return.results = FALSE,
  ...
)
}
\arguments{
\item{dataset}{[\code{\link{data.frame}}]\cr
Dataset with named columns. The names correspond to predictors and responses.}

\item{preds}{[\code{character}]\cr
Character vector of predictor variables.}

\item{resps}{[\code{character}]\cr
Character vector of response variables.}

\item{return.results}{[\code{logical(1)}]\cr
If \code{FALSE} the function returns \code{TRUE} invisibly.
If \code{TRUE}, it returns a \code{\link{list}} of results.
Default is \code{FALSE}.}

\item{...}{[ANY]\cr
Additional arguments to be passed to 
\code{\link[vcd]{mosaic}}
. Please consider possible script variables (\code{scriptvars}) to prevent duplicates.}
}
\value{
Logical [\code{TRUE}] invisibly and outputs to Cornerstone or, 
  if \code{return.results = TRUE}, \code{\link{list}} of 
  resulting \code{\link{data.frame}} objects:
  \item{long.contingency}{Contingency table in long format.}
}
\description{
Plots (extended) mosaic displays via \code{\link[vcd]{mosaic}}.
  The last response variable is highlighted.
  A high-dimensional contingency table is calculated via \code{\link[vcd]{structable}}
  from the given dataset.
  Flat contingency table splits predictors horizontally and optional responses vertically.
}
\examples{
# Draw mosaic plot from 'titanic' data:
mosaicPlot(titanic, c("Class", "Age", "Sex", "Survived"))
res = mosaicPlot(titanic, c("Class", "Age"), c("Sex", "Survived"), return.results = TRUE)
print(res)
}
