% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Terminator.R
\name{Terminator}
\alias{Terminator}
\title{Destructing values to have missing ones}
\usage{
Terminator(target = NULL, wrath = 0.1, diag = 0, Z = NULL)
}
\arguments{
\item{target}{the dataset (matrix or data.frame) in which missing values will be made}

\item{wrath}{the ratio of missing values in the output}

\item{diag}{if == 1 it creates a diagonal band of missing values (no complete line, no complete column, but not too much missing values)}

\item{Z}{adjacency matrix to coerce a maximum of 1 missing value per sub-regression for each individual}
}
\value{
the matrix with missing values.
}
\description{
Destructing values to have missing ones
}
\examples{
data <- mtcars

# add 5\% of missing values
datamiss <- Terminator(target = data, wrath = 0.05)
showdata(datamiss) # plot positions of the missing values

# create a diagonal of missing values
datamiss <- Terminator(target = data, diag = 1)
showdata(datamiss) # plot positions of the missing values (no full individuals, no full variable)
   
}
