% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expcond.R
\name{expcond}
\alias{expcond}
\title{Conditional expectation}
\usage{
expcond(w, family, rot = 0, cpar, margin, dfC = NULL, subs = 1000)
}
\arguments{
\item{w}{value of the conditioning random variable}

\item{family}{copula model: "gaussian" , "t" , "clayton" ,"joe", "frank" , "gumbel",  "plackett"}

\item{rot}{rotation: 0 (default), 90, 180 (survival), or 270}

\item{cpar}{copula parameter}

\item{margin}{marginal distribution function}

\item{dfC}{degrees of freedom for the Student copula (default is NULL)}

\item{subs}{number of subdivisions for the integrals (default=1000)}
}
\value{
\item{mest}{Conditional expectations}
}
\description{
This function computes the conditional expectation for a given copula family and a given margin variables for a clustered data model. The clusters ar3e independent but the observations with clusters are dependent, according to a one-factor copula model.
}
\examples{
margin = function(x){ppois(x,10)}
expcond(0.4,'clayton',cpar=2,margin=margin)

}
\author{
Pavel Krupskii and Bruno N. Remillard
}
