% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ShapleyConcept.R
\name{drawShapleyValue}
\alias{drawShapleyValue}
\title{Draw Shapley value for 3 or 4 players}
\usage{
drawShapleyValue(v, holdOn = FALSE, colour = NA, label = TRUE,
  name = "Shapley value")
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}

\item{holdOn}{draws in a existing plot}

\item{colour}{draws the geometric object (i.e. point or convex polyhedron) with this colour, all colour names can be seen with "colors()"}

\item{label}{activates the labels for the figure}

\item{name}{set a name for the label}
}
\value{
None.
}
\description{
drawShapleyValue draws the Shapley value for 3 or 4 players.
}
\examples{
library(CoopGame)
v=c(0,0,0,1,1,0,1)
drawShapleyValue(v) 
}
\references{
Shapley L.S. (1953) "A value for n-person games". In: Kuhn, H., Tucker, A.W. (Eds.), Contributions to the Theory of Games II, Princeton University Press, pp. 307--317

Aumann R.J. (2010) "Some non-superadditive games, and their Shapley values, in the Talmud", Int. Journal of Game Theory 39(1), pp. 3--10

Peters H. (2015)  \emph{Game Theory: A Multi-Leveled Approach}, 2nd Edition, Springer, pp. 156--159

Maschler M., Solan E. and Zamir S. (2013) \emph{Game Theory}, Cambridge University Press, pp. 748--781
}
\author{
Alexandra Tiukkel
}
