% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NucleolusDerivatives.R
\name{drawProportionalNucleolus}
\alias{drawProportionalNucleolus}
\title{Draw proportional nucleolus for 3 or 4 players}
\usage{
drawProportionalNucleolus(v, holdOn = FALSE, colour = NA,
  label = TRUE, name = "Proportional Nucleolus")
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}

\item{holdOn}{draws in a existing plot}

\item{colour}{draws the geometric object (i.e. point or convex polyhedron) with this colour, all colour names can be seen with "colors()"}

\item{label}{activates the labels for the figure}

\item{name}{set a name for the label}
}
\value{
None.
}
\description{
drawProportionalNucleolus draws the proportional nucleolus for 3 or 4 players.
}
\examples{
library(CoopGame)
v<-c(0,0,0,48,60,72,140)
drawProportionalNucleolus(v)
}
\references{
Young H. P., Okada N. and Hashimoto, T. (1982) "Cost allocation in water resources development", Water resources research 18(3), pp. 463--475
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
