% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ImputationsetConcept.R
\name{drawImputationset}
\alias{drawImputationset}
\alias{drawImputationSet}
\title{Draw imputation set for 3 or 4 players}
\usage{
drawImputationset(v, label = TRUE)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}

\item{label}{activates the labels for the figure}
}
\value{
None.
}
\description{
drawImputationset draws the imputation set for 3 or 4 players.
}
\examples{
library(CoopGame)
v=c(0,1,2,3,4,5,6)
drawImputationset(v)
}
\references{
Peleg B. and Sudhoelter P. (2007) \emph{Theory of cooperative games}, 2nd Edition, Springer, p. 20

Maschler M., Solan E. and Zamir S. (2013) \emph{Game Theory}, Cambridge University Press, p. 674

Osborne M.J. and Rubinstein A. (1994) \emph{A Course in Game Theory}, MIT Press, p. 278

Narahari Y. (2015)  \emph{Game Theory and Mechanism Design}, World Scientific Publishing, p. 407
}
\author{
Johannes Anwander \email{anwander.johannes@gmail.com}

Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
