% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoreCoverConcept.R
\name{belongsToCoreCover}
\alias{belongsToCoreCover}
\title{Check if point is core cover element}
\usage{
belongsToCoreCover(x, v)
}
\arguments{
\item{x}{numeric vector containing allocations for each player}

\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\value{
\code{TRUE} if point belongs to core cover, \code{FALSE} otherwise
}
\description{
belongsToCoreCover checks if the point is in the core cover
}
\examples{
library(CoopGame)
belongsToCoreCover(x=c(1,1,1), v=c(0,0,0,1,1,1,3))

\donttest{
library(CoopGame)
v <- c(0,0,0,3,3,3,6)
belongsToCoreCover(x=c(2,2,2),v)
#[1] TRUE
belongsToCoreCover(x=c(1,2,4),v)
#[1] FALSE
}

}
\references{
Tijs S.H. and Lipperts F.A.S. (1982) "The hypercube and the core cover of n-person cooperative games", Cahiers du Centre d' Etudes de Researche Operationelle 24, pp. 27--37

Branzei R., Dimitrov D. and Tijs S. (2006) \emph{Models in cooperative game theory}, Springer, p. 21

Chakravarty S.R., Mitra M. and Sarkar P. (2015) \emph{A Course on Cooperative Game Theory}, Cambridge University Press, pp. 45--46
}
\author{
Johannes Anwander \email{anwander.johannes@gmail.com}

Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
