% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.conData.R
\name{plot.conData}
\alias{plot.conData}
\title{Visualize the course of the variables over time}
\usage{
\method{plot}{conData}(x, plottype = "interval", color = NULL, ...)
}
\arguments{
\item{x}{conData object}

\item{plottype}{Character specified as 'interval', 'line', or 'both'}

\item{color}{Character string of colornames for all variables (default='black')}

\item{...}{Parameters to be transfered to the plot function}
}
\value{
Plot visualizing the course of the variables over time
}
\description{
Visualize the course of the variables over time
}
\examples{
ExampleData <- cbind(rep(c(0,1),100),
                     rep(c(0,0,0,0,0,1,1,1,1,1),20),
                     c(rep(c(0,0,0,1,1),20),
                       rep(c(0,1,1,1,1),20)),
                     ifelse(rnorm(200,0,1)<0.95,1,0),
                     c(
                      ifelse(rnorm(100,0,1)<0.7,1,0),
                      ifelse(rnorm(100,0,1)<0.7,0,1)
                     ),
                     ifelse(rnorm(200,0,1)<(-0.98),1,0))
colnames(ExampleData) <- c('Var 1','Var 2','Var 3',
                           'Var 4','Var 5','Var 6')
PersData <- conData(ExampleData)
fancy.col=c('purple','slateblue', 'royalblue', 'cyan4',
            'green3', 'olivedrab3', 'orange', 'orangered')
plot(PersData,plottype='line',color=fancy.col)

data(SymptomData)
Sdata <- conData(SymptomData)
fancy.col=c('purple','slateblue', 'royalblue', 'cyan4',
            'green3', 'olivedrab3', 'orange', 'orangered')
plot(Sdata, plottype='interval',color=fancy.col)


}
